# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from .configurable_data_sink_names import ConfigurableDataSinkNames

try:
    import pydantic
    if pydantic.__version__.startswith("1."):
        raise ImportError

    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class DataSinkDefinition(pydantic.BaseModel):
    """
    Schema for a data sink definition.
    """

    label: str = pydantic.Field(
        description="The label field will be used to display the name of the component in the UI"
    )
    json_schema: typing.Dict[str, typing.Any] = pydantic.Field(
        description="The json_schema field can be used by clients to determine how to construct the component"
    )
    sink_type: ConfigurableDataSinkNames = pydantic.Field(
        description="The name field will act as the unique identifier of DataSinkDefinition objects"
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}
