# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from .configurable_transformation_names import ConfigurableTransformationNames
from .configured_transformation_item_component import ConfiguredTransformationItemComponent

try:
    import pydantic
    if pydantic.__version__.startswith("1."):
        raise ImportError

    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class ConfiguredTransformationItem(pydantic.BaseModel):
    """
    Configured transformations for pipelines.

    Similar to ConfigurableTransformation but includes a few
    more fields that are useful to the platform.
    """

    id: typing.Optional[str]
    configurable_transformation_type: ConfigurableTransformationNames = pydantic.Field(
        description="Name for the type of transformation this is (e.g. SIMPLE_NODE_PARSER). Can also be an enum instance of llama_index.ingestion.transformations.ConfigurableTransformations. This will be converted to ConfigurableTransformationNames."
    )
    component: ConfiguredTransformationItemComponent = pydantic.Field(
        description="Component that implements the transformation"
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}
