# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from .az_storage_blob_reader_file_extractor_value import AzStorageBlobReaderFileExtractorValue

try:
    import pydantic
    if pydantic.__version__.startswith("1."):
        raise ImportError

    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class AzStorageBlobReader(pydantic.BaseModel):
    """
    General reader for any Azure Storage Blob file or directory.

    Args:
    container_name (str): name of the container for the blob.
    blob (Optional[str]): name of the file to download. If none specified
    this loader will iterate through list of blobs in the container.
    name_starts_with (Optional[str]): filter the list of blobs to download
    to only those whose names begin with the specified string.
    include: (Union[str, List[str], None]): Specifies one or more additional
    datasets to include in the response. Options include: 'snapshots',
    'metadata', 'uncommittedblobs', 'copy', 'deleted',
    'deletedwithversions', 'tags', 'versions', 'immutabilitypolicy',
    'legalhold'.
    file_extractor (Optional[Dict[str, Union[str, BaseReader]]]): A mapping of file
    extension to a BaseReader class that specifies how to convert that file
    to text. See `SimpleDirectoryReader` for more details, or call this path `llama_index.readers.file.base.DEFAULT_FILE_READER_CLS`.
    connection_string (str): A connection string which can be found under a storage account's "Access keys" security tab. This parameter
    can be used in place of both the account URL and credential.
    account_url (str): URI to the storage account, may include SAS token.
    credential (Union[str, Dict[str, str], AzureNamedKeyCredential, AzureSasCredential, TokenCredential, None] = None):
    The credentials with which to authenticate. This is optional if the account URL already has a SAS token.
    """

    is_remote: typing.Optional[bool]
    container_name: str
    prefix: typing.Optional[str]
    blob: typing.Optional[str]
    name_starts_with: typing.Optional[str]
    include: typing.Optional[typing.Any]
    file_extractor: typing.Optional[typing.Dict[str, AzStorageBlobReaderFileExtractorValue]]
    connection_string: typing.Optional[str]
    account_url: typing.Optional[str]
    credential: typing.Optional[typing.Any]
    class_name: typing.Optional[str]

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}
