# This file was auto-generated by Fern from our API Definition.

import typing
import urllib.parse
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.jsonable_encoder import jsonable_encoder
from ...core.remove_none_from_dict import remove_none_from_dict
from ...errors.unprocessable_entity_error import UnprocessableEntityError
from ...types.eval_dataset import EvalDataset
from ...types.http_validation_error import HttpValidationError
from ...types.local_eval import LocalEval
from ...types.local_eval_results import LocalEvalResults
from ...types.local_eval_sets import LocalEvalSets
from ...types.pipeline import Pipeline
from ...types.pipeline_create import PipelineCreate
from ...types.project import Project
from ...types.project_create import ProjectCreate
from ...types.prompt_mixin_prompts import PromptMixinPrompts

try:
    import pydantic
    if pydantic.__version__.startswith("1."):
        raise ImportError

    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ProjectClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list_projects(self, *, project_name: typing.Optional[str] = None) -> typing.List[Project]:
        """
        List projects or get one by name

        Parameters:
            - project_name: typing.Optional[str].
        ---
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.project.list_projects()
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "api/project"),
            params=remove_none_from_dict({"project_name": project_name}),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.List[Project], _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def create_project(self, *, request: ProjectCreate) -> Project:
        """
        Create a new project.

        Parameters:
            - request: ProjectCreate.
        ---
        from platform import ProjectCreate
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.project.create_project(
            request=ProjectCreate(
                name="string",
            ),
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "api/project"),
            json=jsonable_encoder(request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(Project, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def upsert_project(self, *, request: ProjectCreate) -> Project:
        """
        Upsert a project.
        Updates if a project with the same name already exists. Otherwise, creates a new project.

        Parameters:
            - request: ProjectCreate.
        ---
        from platform import ProjectCreate
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.project.upsert_project(
            request=ProjectCreate(
                name="string",
            ),
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "PUT",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "api/project"),
            json=jsonable_encoder(request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(Project, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_project(self, project_id: str) -> Project:
        """
        Get a project by ID.

        Parameters:
            - project_id: str.
        ---
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.project.get_project(
            project_id="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/project/{project_id}"),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(Project, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def update_existing_project(self, project_id: str, *, name: str) -> Project:
        """
        Update an existing project.

        Parameters:
            - project_id: str.

            - name: str.
        ---
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.project.update_existing_project(
            project_id="string",
            name="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "PUT",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/project/{project_id}"),
            json=jsonable_encoder({"name": name}),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(Project, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def create_pipeline_for_project(self, project_id: str, *, request: PipelineCreate) -> Pipeline:
        """
        Create a new pipeline for a project.

        Parameters:
            - project_id: str.

            - request: PipelineCreate.
        ---
        from platform import (
            EvalExecutionParams,
            PipelineCreate,
            PipelineType,
            PresetRetrievalParams,
            SupportedEvalLlmModelNames,
        )
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.project.create_pipeline_for_project(
            project_id="string",
            request=PipelineCreate(
                preset_retrieval_parameters=PresetRetrievalParams(),
                eval_parameters=EvalExecutionParams(
                    llm_model=SupportedEvalLlmModelNames.GPT_3_5_TURBO,
                ),
                name="string",
                pipeline_type=PipelineType.PLAYGROUND,
            ),
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/project/{project_id}/pipeline"),
            json=jsonable_encoder(request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(Pipeline, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def upsert_pipeline_for_project(self, project_id: str, *, request: PipelineCreate) -> Pipeline:
        """
        Upsert a pipeline for a project.
        Updates if a pipeline with the same name and project_id already exists. Otherwise, creates a new pipeline.

        Parameters:
            - project_id: str.

            - request: PipelineCreate.
        ---
        from platform import (
            EvalExecutionParams,
            PipelineCreate,
            PipelineType,
            PresetRetrievalParams,
            SupportedEvalLlmModelNames,
        )
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.project.upsert_pipeline_for_project(
            project_id="string",
            request=PipelineCreate(
                preset_retrieval_parameters=PresetRetrievalParams(),
                eval_parameters=EvalExecutionParams(
                    llm_model=SupportedEvalLlmModelNames.GPT_3_5_TURBO,
                ),
                name="string",
                pipeline_type=PipelineType.PLAYGROUND,
            ),
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "PUT",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/project/{project_id}/pipeline"),
            json=jsonable_encoder(request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(Pipeline, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_datasets_for_project(self, project_id: str) -> typing.List[EvalDataset]:
        """
        Get all eval datasets for a project.

        Parameters:
            - project_id: str.
        ---
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.project.get_datasets_for_project(
            project_id="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/project/{project_id}/eval/dataset"),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.List[EvalDataset], _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def create_eval_dataset_for_project(self, project_id: str, *, name: str) -> EvalDataset:
        """
        Create a new eval dataset for a project.

        Parameters:
            - project_id: str.

            - name: str. The name of the EvalDataset.
        ---
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.project.create_eval_dataset_for_project(
            project_id="string",
            name="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/project/{project_id}/eval/dataset"),
            json=jsonable_encoder({"name": name}),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(EvalDataset, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def create_local_eval_set_for_project(
        self, project_id: str, *, app_name: str, results: typing.Dict[str, typing.List[LocalEval]]
    ) -> typing.List[LocalEvalResults]:
        """
        Create a new local eval set.

        Parameters:
            - project_id: str.

            - app_name: str. The name of the app.

            - results: typing.Dict[str, typing.List[LocalEval]]. The eval results.
        ---
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.project.create_local_eval_set_for_project(
            project_id="string",
            app_name="string",
            results={"string": []},
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/project/{project_id}/localevalset"),
            json=jsonable_encoder({"app_name": app_name, "results": results}),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.List[LocalEvalResults], _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_local_evals_for_project(self, project_id: str) -> typing.List[LocalEvalResults]:
        """
        Get all local eval results for a project.

        Parameters:
            - project_id: str.
        ---
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.project.get_local_evals_for_project(
            project_id="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/project/{project_id}/localeval"),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.List[LocalEvalResults], _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_local_eval_sets_for_project(self, project_id: str) -> typing.List[LocalEvalSets]:
        """
        Get all local eval sets for a project.

        Parameters:
            - project_id: str.
        ---
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.project.get_local_eval_sets_for_project(
            project_id="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/project/{project_id}/localevalsets"),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.List[LocalEvalSets], _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def delete_local_eval_set(self, project_id: str, local_eval_set_id: str) -> typing.Any:
        """
        Delete a local eval set.

        Parameters:
            - project_id: str.

            - local_eval_set_id: str.
        ---
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.project.delete_local_eval_set(
            project_id="string",
            local_eval_set_id="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "DELETE",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"api/project/{project_id}/localevalset/{local_eval_set_id}"
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.Any, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_promptmixin_prompts(self, project_id: str) -> typing.List[PromptMixinPrompts]:
        """
        Get all PromptMixin prompt sets for a project.

        Parameters:
            - project_id: str.
        ---
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.project.get_promptmixin_prompts(
            project_id="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/project/{project_id}/prompts"),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.List[PromptMixinPrompts], _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def create_prompt_mixin_prompts(self, project_id: str, *, request: PromptMixinPrompts) -> PromptMixinPrompts:
        """
        Create a new PromptMixin prompt set.

        Parameters:
            - project_id: str.

            - request: PromptMixinPrompts.
        ---
        from platform import PromptMixinPrompts
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.project.create_prompt_mixin_prompts(
            project_id="string",
            request=PromptMixinPrompts(
                project_id="string",
                name="string",
                prompts=[],
            ),
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/project/{project_id}/prompts"),
            json=jsonable_encoder(request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(PromptMixinPrompts, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def update_promptmixin_prompts(
        self, project_id: str, prompt_set_id: str, *, request: PromptMixinPrompts
    ) -> PromptMixinPrompts:
        """
        Update a PromptMixin prompt set.

        Parameters:
            - project_id: str.

            - prompt_set_id: str.

            - request: PromptMixinPrompts.
        ---
        from platform import PromptMixinPrompts
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.project.update_promptmixin_prompts(
            project_id="string",
            prompt_set_id="string",
            request=PromptMixinPrompts(
                project_id="string",
                name="string",
                prompts=[],
            ),
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "PUT",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"api/project/{project_id}/prompts/{prompt_set_id}"
            ),
            json=jsonable_encoder(request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(PromptMixinPrompts, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def delete_prompt_mixin_prompts(self, project_id: str, prompt_set_id: str) -> typing.Any:
        """
        Delete a PromptMixin prompt set.

        Parameters:
            - project_id: str.

            - prompt_set_id: str.
        ---
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.project.delete_prompt_mixin_prompts(
            project_id="string",
            prompt_set_id="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "DELETE",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"api/project/{project_id}/prompts/{prompt_set_id}"
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.Any, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncProjectClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list_projects(self, *, project_name: typing.Optional[str] = None) -> typing.List[Project]:
        """
        List projects or get one by name

        Parameters:
            - project_name: typing.Optional[str].
        ---
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.project.list_projects()
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "api/project"),
            params=remove_none_from_dict({"project_name": project_name}),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.List[Project], _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def create_project(self, *, request: ProjectCreate) -> Project:
        """
        Create a new project.

        Parameters:
            - request: ProjectCreate.
        ---
        from platform import ProjectCreate
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.project.create_project(
            request=ProjectCreate(
                name="string",
            ),
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "api/project"),
            json=jsonable_encoder(request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(Project, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def upsert_project(self, *, request: ProjectCreate) -> Project:
        """
        Upsert a project.
        Updates if a project with the same name already exists. Otherwise, creates a new project.

        Parameters:
            - request: ProjectCreate.
        ---
        from platform import ProjectCreate
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.project.upsert_project(
            request=ProjectCreate(
                name="string",
            ),
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "PUT",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "api/project"),
            json=jsonable_encoder(request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(Project, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_project(self, project_id: str) -> Project:
        """
        Get a project by ID.

        Parameters:
            - project_id: str.
        ---
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.project.get_project(
            project_id="string",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/project/{project_id}"),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(Project, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def update_existing_project(self, project_id: str, *, name: str) -> Project:
        """
        Update an existing project.

        Parameters:
            - project_id: str.

            - name: str.
        ---
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.project.update_existing_project(
            project_id="string",
            name="string",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "PUT",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/project/{project_id}"),
            json=jsonable_encoder({"name": name}),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(Project, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def create_pipeline_for_project(self, project_id: str, *, request: PipelineCreate) -> Pipeline:
        """
        Create a new pipeline for a project.

        Parameters:
            - project_id: str.

            - request: PipelineCreate.
        ---
        from platform import (
            EvalExecutionParams,
            PipelineCreate,
            PipelineType,
            PresetRetrievalParams,
            SupportedEvalLlmModelNames,
        )
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.project.create_pipeline_for_project(
            project_id="string",
            request=PipelineCreate(
                preset_retrieval_parameters=PresetRetrievalParams(),
                eval_parameters=EvalExecutionParams(
                    llm_model=SupportedEvalLlmModelNames.GPT_3_5_TURBO,
                ),
                name="string",
                pipeline_type=PipelineType.PLAYGROUND,
            ),
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/project/{project_id}/pipeline"),
            json=jsonable_encoder(request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(Pipeline, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def upsert_pipeline_for_project(self, project_id: str, *, request: PipelineCreate) -> Pipeline:
        """
        Upsert a pipeline for a project.
        Updates if a pipeline with the same name and project_id already exists. Otherwise, creates a new pipeline.

        Parameters:
            - project_id: str.

            - request: PipelineCreate.
        ---
        from platform import (
            EvalExecutionParams,
            PipelineCreate,
            PipelineType,
            PresetRetrievalParams,
            SupportedEvalLlmModelNames,
        )
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.project.upsert_pipeline_for_project(
            project_id="string",
            request=PipelineCreate(
                preset_retrieval_parameters=PresetRetrievalParams(),
                eval_parameters=EvalExecutionParams(
                    llm_model=SupportedEvalLlmModelNames.GPT_3_5_TURBO,
                ),
                name="string",
                pipeline_type=PipelineType.PLAYGROUND,
            ),
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "PUT",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/project/{project_id}/pipeline"),
            json=jsonable_encoder(request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(Pipeline, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_datasets_for_project(self, project_id: str) -> typing.List[EvalDataset]:
        """
        Get all eval datasets for a project.

        Parameters:
            - project_id: str.
        ---
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.project.get_datasets_for_project(
            project_id="string",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/project/{project_id}/eval/dataset"),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.List[EvalDataset], _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def create_eval_dataset_for_project(self, project_id: str, *, name: str) -> EvalDataset:
        """
        Create a new eval dataset for a project.

        Parameters:
            - project_id: str.

            - name: str. The name of the EvalDataset.
        ---
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.project.create_eval_dataset_for_project(
            project_id="string",
            name="string",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/project/{project_id}/eval/dataset"),
            json=jsonable_encoder({"name": name}),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(EvalDataset, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def create_local_eval_set_for_project(
        self, project_id: str, *, app_name: str, results: typing.Dict[str, typing.List[LocalEval]]
    ) -> typing.List[LocalEvalResults]:
        """
        Create a new local eval set.

        Parameters:
            - project_id: str.

            - app_name: str. The name of the app.

            - results: typing.Dict[str, typing.List[LocalEval]]. The eval results.
        ---
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.project.create_local_eval_set_for_project(
            project_id="string",
            app_name="string",
            results={"string": []},
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/project/{project_id}/localevalset"),
            json=jsonable_encoder({"app_name": app_name, "results": results}),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.List[LocalEvalResults], _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_local_evals_for_project(self, project_id: str) -> typing.List[LocalEvalResults]:
        """
        Get all local eval results for a project.

        Parameters:
            - project_id: str.
        ---
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.project.get_local_evals_for_project(
            project_id="string",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/project/{project_id}/localeval"),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.List[LocalEvalResults], _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_local_eval_sets_for_project(self, project_id: str) -> typing.List[LocalEvalSets]:
        """
        Get all local eval sets for a project.

        Parameters:
            - project_id: str.
        ---
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.project.get_local_eval_sets_for_project(
            project_id="string",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/project/{project_id}/localevalsets"),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.List[LocalEvalSets], _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def delete_local_eval_set(self, project_id: str, local_eval_set_id: str) -> typing.Any:
        """
        Delete a local eval set.

        Parameters:
            - project_id: str.

            - local_eval_set_id: str.
        ---
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.project.delete_local_eval_set(
            project_id="string",
            local_eval_set_id="string",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "DELETE",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"api/project/{project_id}/localevalset/{local_eval_set_id}"
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.Any, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_promptmixin_prompts(self, project_id: str) -> typing.List[PromptMixinPrompts]:
        """
        Get all PromptMixin prompt sets for a project.

        Parameters:
            - project_id: str.
        ---
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.project.get_promptmixin_prompts(
            project_id="string",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/project/{project_id}/prompts"),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.List[PromptMixinPrompts], _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def create_prompt_mixin_prompts(self, project_id: str, *, request: PromptMixinPrompts) -> PromptMixinPrompts:
        """
        Create a new PromptMixin prompt set.

        Parameters:
            - project_id: str.

            - request: PromptMixinPrompts.
        ---
        from platform import PromptMixinPrompts
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.project.create_prompt_mixin_prompts(
            project_id="string",
            request=PromptMixinPrompts(
                project_id="string",
                name="string",
                prompts=[],
            ),
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/project/{project_id}/prompts"),
            json=jsonable_encoder(request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(PromptMixinPrompts, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def update_promptmixin_prompts(
        self, project_id: str, prompt_set_id: str, *, request: PromptMixinPrompts
    ) -> PromptMixinPrompts:
        """
        Update a PromptMixin prompt set.

        Parameters:
            - project_id: str.

            - prompt_set_id: str.

            - request: PromptMixinPrompts.
        ---
        from platform import PromptMixinPrompts
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.project.update_promptmixin_prompts(
            project_id="string",
            prompt_set_id="string",
            request=PromptMixinPrompts(
                project_id="string",
                name="string",
                prompts=[],
            ),
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "PUT",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"api/project/{project_id}/prompts/{prompt_set_id}"
            ),
            json=jsonable_encoder(request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(PromptMixinPrompts, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def delete_prompt_mixin_prompts(self, project_id: str, prompt_set_id: str) -> typing.Any:
        """
        Delete a PromptMixin prompt set.

        Parameters:
            - project_id: str.

            - prompt_set_id: str.
        ---
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.project.delete_prompt_mixin_prompts(
            project_id="string",
            prompt_set_id="string",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "DELETE",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"api/project/{project_id}/prompts/{prompt_set_id}"
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.Any, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
