# This file was auto-generated by Fern from our API Definition.

import typing
import urllib.parse
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.jsonable_encoder import jsonable_encoder
from ...core.remove_none_from_dict import remove_none_from_dict
from ...errors.unprocessable_entity_error import UnprocessableEntityError
from ...types.configured_transformation_item import ConfiguredTransformationItem
from ...types.data_sink_create import DataSinkCreate
from ...types.data_source_create import DataSourceCreate
from ...types.data_source_managed_ingestion_job_record import DataSourceManagedIngestionJobRecord
from ...types.eval_dataset_job_record import EvalDatasetJobRecord
from ...types.eval_execution_params import EvalExecutionParams
from ...types.eval_execution_params_override import EvalExecutionParamsOverride
from ...types.eval_question_result import EvalQuestionResult
from ...types.http_validation_error import HttpValidationError
from ...types.loaded_file import LoadedFile
from ...types.loaded_file_payload import LoadedFilePayload
from ...types.pipeline import Pipeline
from ...types.pipeline_managed_ingestion_job_record import PipelineManagedIngestionJobRecord
from ...types.pipeline_type import PipelineType
from ...types.platform_text_node import PlatformTextNode
from ...types.playground_job_record import PlaygroundJobRecord
from ...types.preset_retrieval_params import PresetRetrievalParams
from ...types.raw_file import RawFile
from ...types.raw_file_managed_ingestion_job_record import RawFileManagedIngestionJobRecord
from ...types.retrieve_results import RetrieveResults

try:
    import pydantic
    if pydantic.__version__.startswith("1."):
        raise ImportError

    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class PipelineClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def search_pipelines(
        self,
        *,
        project_name: str,
        pipeline_name: typing.Optional[str] = None,
        pipeline_type: typing.Optional[PipelineType] = None,
    ) -> typing.List[Pipeline]:
        """
        Search for pipelines by various parameters.

        Parameters:
            - project_name: str.

            - pipeline_name: typing.Optional[str].

            - pipeline_type: typing.Optional[PipelineType].
        ---
        from platform import PipelineType
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.pipeline.search_pipelines(
            project_name="string",
            pipeline_type=PipelineType.PLAYGROUND,
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "api/pipeline"),
            params=remove_none_from_dict(
                {"project_name": project_name, "pipeline_name": pipeline_name, "pipeline_type": pipeline_type}
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.List[Pipeline], _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_pipeline_for_project(
        self, pipeline_id: str, *, with_managed_ingestion_status: typing.Optional[bool] = None
    ) -> Pipeline:
        """
        Get a pipeline by ID for a given project.

        Parameters:
            - pipeline_id: str.

            - with_managed_ingestion_status: typing.Optional[bool].
        ---
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.pipeline.get_pipeline_for_project(
            pipeline_id="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/pipeline/{pipeline_id}"),
            params=remove_none_from_dict({"with_managed_ingestion_status": with_managed_ingestion_status}),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(Pipeline, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def update_existing_pipeline(
        self,
        pipeline_id: str,
        *,
        configured_transformations: typing.Optional[typing.List[ConfiguredTransformationItem]] = OMIT,
        data_source_ids: typing.Optional[typing.List[str]] = OMIT,
        data_sources: typing.Optional[typing.List[DataSourceCreate]] = OMIT,
        data_sink_ids: typing.Optional[typing.List[str]] = OMIT,
        data_sinks: typing.Optional[typing.List[DataSinkCreate]] = OMIT,
        raw_file_names: typing.Optional[typing.List[str]] = OMIT,
        preset_retrieval_parameters: typing.Optional[PresetRetrievalParams] = OMIT,
        eval_parameters: typing.Optional[EvalExecutionParams] = OMIT,
        llama_parse_enabled: typing.Optional[bool] = OMIT,
        name: typing.Optional[str] = OMIT,
        managed_pipeline_id: typing.Optional[str] = OMIT,
    ) -> Pipeline:
        """
        Update an existing pipeline for a project.

        Parameters:
            - pipeline_id: str.

            - configured_transformations: typing.Optional[typing.List[ConfiguredTransformationItem]].

            - data_source_ids: typing.Optional[typing.List[str]]. List of data source IDs. When provided instead of data_sources, the data sources will be looked up by ID.

            - data_sources: typing.Optional[typing.List[DataSourceCreate]]. List of data sources. When provided instead of data_source_ids, the data sources will be created.

            - data_sink_ids: typing.Optional[typing.List[str]]. List of data sink IDs. When provided instead of data_sinks, the data sinks will be looked up by ID.

            - data_sinks: typing.Optional[typing.List[DataSinkCreate]]. List of data sinks. When provided instead of data_sink_ids, the data sinks will be created.

            - raw_file_names: typing.Optional[typing.List[str]]. List of raw file names to be used as pipeline inputs.

            - preset_retrieval_parameters: typing.Optional[PresetRetrievalParams]. Preset retrieval parameters for the pipeline.

            - eval_parameters: typing.Optional[EvalExecutionParams]. Eval parameters for the pipeline.

            - llama_parse_enabled: typing.Optional[bool]. Whether to use LlamaParse during pipeline execution.

            - name: typing.Optional[str].

            - managed_pipeline_id: typing.Optional[str]. The ID of the ManagedPipeline this playground pipeline is linked to.
        ---
        from platform import (
            EvalExecutionParams,
            PresetRetrievalParams,
            SupportedEvalLlmModelNames,
        )
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.pipeline.update_existing_pipeline(
            pipeline_id="string",
            preset_retrieval_parameters=PresetRetrievalParams(),
            eval_parameters=EvalExecutionParams(
                llm_model=SupportedEvalLlmModelNames.GPT_3_5_TURBO,
            ),
        )
        """
        _request: typing.Dict[str, typing.Any] = {}
        if configured_transformations is not OMIT:
            _request["configured_transformations"] = configured_transformations
        if data_source_ids is not OMIT:
            _request["data_source_ids"] = data_source_ids
        if data_sources is not OMIT:
            _request["data_sources"] = data_sources
        if data_sink_ids is not OMIT:
            _request["data_sink_ids"] = data_sink_ids
        if data_sinks is not OMIT:
            _request["data_sinks"] = data_sinks
        if raw_file_names is not OMIT:
            _request["raw_file_names"] = raw_file_names
        if preset_retrieval_parameters is not OMIT:
            _request["preset_retrieval_parameters"] = preset_retrieval_parameters
        if eval_parameters is not OMIT:
            _request["eval_parameters"] = eval_parameters
        if llama_parse_enabled is not OMIT:
            _request["llama_parse_enabled"] = llama_parse_enabled
        if name is not OMIT:
            _request["name"] = name
        if managed_pipeline_id is not OMIT:
            _request["managed_pipeline_id"] = managed_pipeline_id
        _response = self._client_wrapper.httpx_client.request(
            "PUT",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/pipeline/{pipeline_id}"),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(Pipeline, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def delete_pipeline(self, pipeline_id: str) -> None:
        """
        Delete a pipeline by ID.

        Parameters:
            - pipeline_id: str.
        ---
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.pipeline.delete_pipeline(
            pipeline_id="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "DELETE",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/pipeline/{pipeline_id}"),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_loaded_files_for_pipeline(self, pipeline_id: str) -> typing.List[LoadedFile]:
        """
        Get loaded files for a pipeline by ID.

        Parameters:
            - pipeline_id: str.
        ---
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.pipeline.get_loaded_files_for_pipeline(
            pipeline_id="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/pipeline/{pipeline_id}/loaded_file"),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.List[LoadedFile], _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_loaded_file_content(self, pipeline_id: str, loaded_file_id: str) -> LoadedFilePayload:
        """
        Get loaded files for a data source by ID.

        Parameters:
            - pipeline_id: str.

            - loaded_file_id: str.
        ---
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.pipeline.get_loaded_file_content(
            pipeline_id="string",
            loaded_file_id="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"api/pipeline/{pipeline_id}/loaded_file/{loaded_file_id}/content",
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(LoadedFilePayload, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def deploy_playground_pipeline(
        self, pipeline_id: str, *, managed_pipeline_name: typing.Optional[str] = None
    ) -> Pipeline:
        """
        Deploy a playground pipeline to a managed pipeline.

        Parameters:
            - pipeline_id: str.

            - managed_pipeline_name: typing.Optional[str].
        ---
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.pipeline.deploy_playground_pipeline(
            pipeline_id="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/pipeline/{pipeline_id}/deploy"),
            params=remove_none_from_dict({"managed_pipeline_name": managed_pipeline_name}),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(Pipeline, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def deploy_playground_pipeline_with_existing_managed_pipeline(self, pipeline_id: str) -> Pipeline:
        """
        Deploy a playground pipeline to the managed pipeline it is already associated with.

        Parameters:
            - pipeline_id: str.
        ---
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.pipeline.deploy_playground_pipeline_with_existing_managed_pipeline(
            pipeline_id="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "PUT",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/pipeline/{pipeline_id}/deploy"),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(Pipeline, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def create_playground_pipeline(
        self, pipeline_id: str, *, playground_pipeline_name: typing.Optional[str] = None
    ) -> Pipeline:
        """
        Create a playground pipeline from a managed pipeline.

        Parameters:
            - pipeline_id: str.

            - playground_pipeline_name: typing.Optional[str].
        ---
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.pipeline.create_playground_pipeline(
            pipeline_id="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/pipeline/{pipeline_id}/playground"),
            params=remove_none_from_dict({"playground_pipeline_name": playground_pipeline_name}),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(Pipeline, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_all_playground_jobs(self, pipeline_id: str) -> typing.List[PlaygroundJobRecord]:
        """
        Get all PlaygroundJobRecords for a given pipeline.

        Parameters:
            - pipeline_id: str.
        ---
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.pipeline.get_all_playground_jobs(
            pipeline_id="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"api/pipeline/{pipeline_id}/playground_job"
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.List[PlaygroundJobRecord], _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def create_playground_job(
        self, pipeline_id: str, *, loaded_file_ids: typing.Optional[typing.Union[str, typing.List[str]]] = None
    ) -> PlaygroundJobRecord:
        """
        Kick off a new Playground execution.

        Parameters:
            - pipeline_id: str.

            - loaded_file_ids: typing.Optional[typing.Union[str, typing.List[str]]].
        ---
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.pipeline.create_playground_job(
            pipeline_id="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"api/pipeline/{pipeline_id}/playground_job"
            ),
            params=remove_none_from_dict({"loaded_file_ids": loaded_file_ids}),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(PlaygroundJobRecord, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_playground_job_result(
        self,
        pipeline_id: str,
        *,
        configured_transformation_id: typing.Optional[str] = None,
        loaded_file_id: typing.Optional[str] = None,
        offset: typing.Optional[int] = None,
        limit: typing.Optional[int] = None,
    ) -> typing.List[PlatformTextNode]:
        """
        Get the result of the latest Playground job.

        Parameters:
            - pipeline_id: str.

            - configured_transformation_id: typing.Optional[str].

            - loaded_file_id: typing.Optional[str].

            - offset: typing.Optional[int].

            - limit: typing.Optional[int].
        ---
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.pipeline.get_playground_job_result(
            pipeline_id="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"api/pipeline/{pipeline_id}/playground_job/result"
            ),
            params=remove_none_from_dict(
                {
                    "configured_transformation_id": configured_transformation_id,
                    "loaded_file_id": loaded_file_id,
                    "offset": offset,
                    "limit": limit,
                }
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.List[PlatformTextNode], _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_playground_job(self, pipeline_id: str, playground_job_id: str) -> PlaygroundJobRecord:
        """
        Get status of a single pipeline PlaygroundJob for a given pipeline.

        Parameters:
            - pipeline_id: str.

            - playground_job_id: str.
        ---
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.pipeline.get_playground_job(
            pipeline_id="string",
            playground_job_id="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"api/pipeline/{pipeline_id}/playground_job/{playground_job_id}",
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(PlaygroundJobRecord, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_eval_dataset_executions(self, pipeline_id: str, eval_dataset_id: str) -> typing.List[EvalDatasetJobRecord]:
        """
        Get the status of an EvalDatasetExecution.

        Parameters:
            - pipeline_id: str.

            - eval_dataset_id: str.
        ---
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.pipeline.get_eval_dataset_executions(
            pipeline_id="string",
            eval_dataset_id="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"api/pipeline/{pipeline_id}/eval_dataset/{eval_dataset_id}/execute",
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.List[EvalDatasetJobRecord], _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def execute_eval_dataset(
        self,
        pipeline_id: str,
        eval_dataset_id: str,
        *,
        eval_question_ids: typing.List[str],
        params: typing.Optional[EvalExecutionParamsOverride] = OMIT,
    ) -> EvalDatasetJobRecord:
        """
        Execute a dataset.

        Parameters:
            - pipeline_id: str.

            - eval_dataset_id: str.

            - eval_question_ids: typing.List[str].

            - params: typing.Optional[EvalExecutionParamsOverride]. The parameters for the eval execution that will override the ones set in the pipeline.
        ---
        from platform import EvalExecutionParamsOverride, SupportedEvalLlmModelNames
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.pipeline.execute_eval_dataset(
            pipeline_id="string",
            eval_dataset_id="string",
            eval_question_ids=[],
            params=EvalExecutionParamsOverride(
                llm_model=SupportedEvalLlmModelNames.GPT_3_5_TURBO,
            ),
        )
        """
        _request: typing.Dict[str, typing.Any] = {"eval_question_ids": eval_question_ids}
        if params is not OMIT:
            _request["params"] = params
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"api/pipeline/{pipeline_id}/eval_dataset/{eval_dataset_id}/execute",
            ),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(EvalDatasetJobRecord, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_eval_dataset_execution_result(
        self, pipeline_id: str, eval_dataset_id: str
    ) -> typing.List[EvalQuestionResult]:
        """
        Get the result of an EvalDatasetExecution.
        If eval_question_ids is specified, only the results for the specified
        questions will be returned.
        If any of the specified questions do not have a result, they will be ignored.

        Parameters:
            - pipeline_id: str.

            - eval_dataset_id: str.
        ---
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.pipeline.get_eval_dataset_execution_result(
            pipeline_id="string",
            eval_dataset_id="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"api/pipeline/{pipeline_id}/eval_dataset/{eval_dataset_id}/execute/result",
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.List[EvalQuestionResult], _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_eval_dataset_execution(
        self, pipeline_id: str, eval_dataset_id: str, eval_dataset_execution_id: str
    ) -> EvalDatasetJobRecord:
        """
        Get the status of an EvalDatasetExecution.

        Parameters:
            - pipeline_id: str.

            - eval_dataset_id: str.

            - eval_dataset_execution_id: str.
        ---
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.pipeline.get_eval_dataset_execution(
            pipeline_id="string",
            eval_dataset_id="string",
            eval_dataset_execution_id="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"api/pipeline/{pipeline_id}/eval_dataset/{eval_dataset_id}/execute/{eval_dataset_execution_id}",
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(EvalDatasetJobRecord, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_raw_file_managed_ingestion_executions(
        self, pipeline_id: str, raw_file_name: str
    ) -> typing.List[RawFileManagedIngestionJobRecord]:
        """
        Get all ManagedRawFileIngestionExecution for a given pipeline and raw file.

        Parameters:
            - pipeline_id: str.

            - raw_file_name: str.
        ---
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.pipeline.get_raw_file_managed_ingestion_executions(
            pipeline_id="string",
            raw_file_name="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"api/pipeline/{pipeline_id}/raw_file/{raw_file_name}/managed_ingest",
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.List[RawFileManagedIngestionJobRecord], _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def run_raw_file_managed_ingestion(self, pipeline_id: str, raw_file_name: str) -> RawFileManagedIngestionJobRecord:
        """
        Execute a ManagedRawFileIngestion.

        Parameters:
            - pipeline_id: str.

            - raw_file_name: str.
        ---
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.pipeline.run_raw_file_managed_ingestion(
            pipeline_id="string",
            raw_file_name="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"api/pipeline/{pipeline_id}/raw_file/{raw_file_name}/managed_ingest",
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(RawFileManagedIngestionJobRecord, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_raw_file_managed_ingestion_execution(
        self, pipeline_id: str, raw_file_name: str, managed_raw_file_ingestion_id: str
    ) -> RawFileManagedIngestionJobRecord:
        """
        Get a single ManagedRawFileIngestionExecution for a given pipeline and raw file.

        Parameters:
            - pipeline_id: str.

            - raw_file_name: str.

            - managed_raw_file_ingestion_id: str.
        ---
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.pipeline.get_raw_file_managed_ingestion_execution(
            pipeline_id="string",
            raw_file_name="string",
            managed_raw_file_ingestion_id="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"api/pipeline/{pipeline_id}/raw_file/{raw_file_name}/managed_ingest/{managed_raw_file_ingestion_id}",
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(RawFileManagedIngestionJobRecord, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_managed_data_source_ingestion_executions(
        self, pipeline_id: str, data_source_id: str
    ) -> typing.List[DataSourceManagedIngestionJobRecord]:
        """
        Get all ManagedDataSourceIngestionExecution for a given pipeline and data source.

        Parameters:
            - pipeline_id: str.

            - data_source_id: str.
        ---
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.pipeline.get_managed_data_source_ingestion_executions(
            pipeline_id="string",
            data_source_id="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"api/pipeline/{pipeline_id}/data_source/{data_source_id}/managed_ingest",
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.List[DataSourceManagedIngestionJobRecord], _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def run_managed_data_source_ingestion(
        self, pipeline_id: str, data_source_id: str
    ) -> DataSourceManagedIngestionJobRecord:
        """
        Execute a ManagedDataSourceIngestion.

        Parameters:
            - pipeline_id: str.

            - data_source_id: str.
        ---
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.pipeline.run_managed_data_source_ingestion(
            pipeline_id="string",
            data_source_id="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"api/pipeline/{pipeline_id}/data_source/{data_source_id}/managed_ingest",
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(DataSourceManagedIngestionJobRecord, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_managed_data_source_ingestion_execution(
        self, pipeline_id: str, data_source_id: str, managed_data_source_ingestion_id: str
    ) -> DataSourceManagedIngestionJobRecord:
        """
        Get a single ManagedDataSourceIngestionExecution for a given pipeline and data source.

        Parameters:
            - pipeline_id: str.

            - data_source_id: str.

            - managed_data_source_ingestion_id: str.
        ---
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.pipeline.get_managed_data_source_ingestion_execution(
            pipeline_id="string",
            data_source_id="string",
            managed_data_source_ingestion_id="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"api/pipeline/{pipeline_id}/data_source/{data_source_id}/managed_ingest/{managed_data_source_ingestion_id}",
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(DataSourceManagedIngestionJobRecord, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_managed_pipeline_ingestion_executions(
        self, pipeline_id: str
    ) -> typing.List[PipelineManagedIngestionJobRecord]:
        """
        Get all ManagedPipelineIngestionExecution for a given pipeline.

        Parameters:
            - pipeline_id: str.
        ---
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.pipeline.get_managed_pipeline_ingestion_executions(
            pipeline_id="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"api/pipeline/{pipeline_id}/managed_ingest"
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.List[PipelineManagedIngestionJobRecord], _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def run_managed_pipeline_ingestion(self, pipeline_id: str) -> PipelineManagedIngestionJobRecord:
        """
        Execute a ManagedPipelineIngestion.

        Parameters:
            - pipeline_id: str.
        ---
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.pipeline.run_managed_pipeline_ingestion(
            pipeline_id="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"api/pipeline/{pipeline_id}/managed_ingest"
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(PipelineManagedIngestionJobRecord, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_managed_ingestion_execution(
        self, pipeline_id: str, managed_pipeline_ingestion_id: str
    ) -> PipelineManagedIngestionJobRecord:
        """
        Parameters:
            - pipeline_id: str.

            - managed_pipeline_ingestion_id: str.
        ---
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.pipeline.get_managed_ingestion_execution(
            pipeline_id="string",
            managed_pipeline_ingestion_id="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"api/pipeline/{pipeline_id}/managed_ingest/{managed_pipeline_ingestion_id}",
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(PipelineManagedIngestionJobRecord, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def run_search(
        self,
        pipeline_id: str,
        *,
        dense_similarity_top_k: typing.Optional[int] = OMIT,
        sparse_similarity_top_k: typing.Optional[int] = OMIT,
        enable_reranking: typing.Optional[bool] = OMIT,
        rerank_top_n: typing.Optional[int] = OMIT,
        alpha: typing.Optional[float] = OMIT,
        search_filters: typing.Optional[typing.Dict[str, typing.List[typing.Any]]] = OMIT,
        query: str,
        class_name: typing.Optional[str] = OMIT,
    ) -> RetrieveResults:
        """
        Get retrieval results for a managed pipeline and a query

        Parameters:
            - pipeline_id: str.

            - dense_similarity_top_k: typing.Optional[int]. Number of nodes for dense retrieval.

            - sparse_similarity_top_k: typing.Optional[int]. Number of nodes for sparse retrieval.

            - enable_reranking: typing.Optional[bool]. Enable reranking for retrieval

            - rerank_top_n: typing.Optional[int]. Number of reranked nodes for returning.

            - alpha: typing.Optional[float]. Alpha value for hybrid retrieval to determine the weights between dense and sparse retrieval. 0 is sparse retrieval and 1 is dense retrieval.

            - search_filters: typing.Optional[typing.Dict[str, typing.List[typing.Any]]]. Search filters for retrieval. the format of search_filters is a dict of {key: (operator, value)}

            - query: str. The query to retrieve against.

            - class_name: typing.Optional[str].
        ---
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.pipeline.run_search(
            pipeline_id="string",
            query="string",
        )
        """
        _request: typing.Dict[str, typing.Any] = {"query": query}
        if dense_similarity_top_k is not OMIT:
            _request["dense_similarity_top_k"] = dense_similarity_top_k
        if sparse_similarity_top_k is not OMIT:
            _request["sparse_similarity_top_k"] = sparse_similarity_top_k
        if enable_reranking is not OMIT:
            _request["enable_reranking"] = enable_reranking
        if rerank_top_n is not OMIT:
            _request["rerank_top_n"] = rerank_top_n
        if alpha is not OMIT:
            _request["alpha"] = alpha
        if search_filters is not OMIT:
            _request["search_filters"] = search_filters
        if class_name is not OMIT:
            _request["class_name"] = class_name
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/pipeline/{pipeline_id}/retrieve"),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(RetrieveResults, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def read_raw_files(self, pipeline_id: str) -> typing.List[RawFile]:
        """
        Read RawFile metadata objects.

        Parameters:
            - pipeline_id: str.
        ---
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.pipeline.read_raw_files(
            pipeline_id="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/pipeline/{pipeline_id}/raw_file"),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.List[RawFile], _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def upsert_raw_file(self, pipeline_id: str, *, file: typing.IO) -> RawFile:
        """
        Uploads a raw file to S3 and returns the RawFile metadata object.

        Parameters:
            - pipeline_id: str.

            - file: typing.IO.
        """
        _response = self._client_wrapper.httpx_client.request(
            "PUT",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/pipeline/{pipeline_id}/raw_file"),
            data=jsonable_encoder({}),
            files={"file": file},
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(RawFile, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def read_raw_file_content(self, pipeline_id: str, name: str) -> None:
        """
        Redirects to a presigned url to read the raw file content.

        Parameters:
            - pipeline_id: str.

            - name: str.
        ---
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.pipeline.read_raw_file_content(
            pipeline_id="string",
            name="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"api/pipeline/{pipeline_id}/raw_file/{name}"
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def delete_raw_file(self, pipeline_id: str, name: str) -> None:
        """
        Delete the raw file from S3.

        Parameters:
            - pipeline_id: str.

            - name: str.
        ---
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.pipeline.delete_raw_file(
            pipeline_id="string",
            name="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "DELETE",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"api/pipeline/{pipeline_id}/raw_file/{name}"
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncPipelineClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def search_pipelines(
        self,
        *,
        project_name: str,
        pipeline_name: typing.Optional[str] = None,
        pipeline_type: typing.Optional[PipelineType] = None,
    ) -> typing.List[Pipeline]:
        """
        Search for pipelines by various parameters.

        Parameters:
            - project_name: str.

            - pipeline_name: typing.Optional[str].

            - pipeline_type: typing.Optional[PipelineType].
        ---
        from platform import PipelineType
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.pipeline.search_pipelines(
            project_name="string",
            pipeline_type=PipelineType.PLAYGROUND,
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "api/pipeline"),
            params=remove_none_from_dict(
                {"project_name": project_name, "pipeline_name": pipeline_name, "pipeline_type": pipeline_type}
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.List[Pipeline], _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_pipeline_for_project(
        self, pipeline_id: str, *, with_managed_ingestion_status: typing.Optional[bool] = None
    ) -> Pipeline:
        """
        Get a pipeline by ID for a given project.

        Parameters:
            - pipeline_id: str.

            - with_managed_ingestion_status: typing.Optional[bool].
        ---
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.pipeline.get_pipeline_for_project(
            pipeline_id="string",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/pipeline/{pipeline_id}"),
            params=remove_none_from_dict({"with_managed_ingestion_status": with_managed_ingestion_status}),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(Pipeline, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def update_existing_pipeline(
        self,
        pipeline_id: str,
        *,
        configured_transformations: typing.Optional[typing.List[ConfiguredTransformationItem]] = OMIT,
        data_source_ids: typing.Optional[typing.List[str]] = OMIT,
        data_sources: typing.Optional[typing.List[DataSourceCreate]] = OMIT,
        data_sink_ids: typing.Optional[typing.List[str]] = OMIT,
        data_sinks: typing.Optional[typing.List[DataSinkCreate]] = OMIT,
        raw_file_names: typing.Optional[typing.List[str]] = OMIT,
        preset_retrieval_parameters: typing.Optional[PresetRetrievalParams] = OMIT,
        eval_parameters: typing.Optional[EvalExecutionParams] = OMIT,
        llama_parse_enabled: typing.Optional[bool] = OMIT,
        name: typing.Optional[str] = OMIT,
        managed_pipeline_id: typing.Optional[str] = OMIT,
    ) -> Pipeline:
        """
        Update an existing pipeline for a project.

        Parameters:
            - pipeline_id: str.

            - configured_transformations: typing.Optional[typing.List[ConfiguredTransformationItem]].

            - data_source_ids: typing.Optional[typing.List[str]]. List of data source IDs. When provided instead of data_sources, the data sources will be looked up by ID.

            - data_sources: typing.Optional[typing.List[DataSourceCreate]]. List of data sources. When provided instead of data_source_ids, the data sources will be created.

            - data_sink_ids: typing.Optional[typing.List[str]]. List of data sink IDs. When provided instead of data_sinks, the data sinks will be looked up by ID.

            - data_sinks: typing.Optional[typing.List[DataSinkCreate]]. List of data sinks. When provided instead of data_sink_ids, the data sinks will be created.

            - raw_file_names: typing.Optional[typing.List[str]]. List of raw file names to be used as pipeline inputs.

            - preset_retrieval_parameters: typing.Optional[PresetRetrievalParams]. Preset retrieval parameters for the pipeline.

            - eval_parameters: typing.Optional[EvalExecutionParams]. Eval parameters for the pipeline.

            - llama_parse_enabled: typing.Optional[bool]. Whether to use LlamaParse during pipeline execution.

            - name: typing.Optional[str].

            - managed_pipeline_id: typing.Optional[str]. The ID of the ManagedPipeline this playground pipeline is linked to.
        ---
        from platform import (
            EvalExecutionParams,
            PresetRetrievalParams,
            SupportedEvalLlmModelNames,
        )
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.pipeline.update_existing_pipeline(
            pipeline_id="string",
            preset_retrieval_parameters=PresetRetrievalParams(),
            eval_parameters=EvalExecutionParams(
                llm_model=SupportedEvalLlmModelNames.GPT_3_5_TURBO,
            ),
        )
        """
        _request: typing.Dict[str, typing.Any] = {}
        if configured_transformations is not OMIT:
            _request["configured_transformations"] = configured_transformations
        if data_source_ids is not OMIT:
            _request["data_source_ids"] = data_source_ids
        if data_sources is not OMIT:
            _request["data_sources"] = data_sources
        if data_sink_ids is not OMIT:
            _request["data_sink_ids"] = data_sink_ids
        if data_sinks is not OMIT:
            _request["data_sinks"] = data_sinks
        if raw_file_names is not OMIT:
            _request["raw_file_names"] = raw_file_names
        if preset_retrieval_parameters is not OMIT:
            _request["preset_retrieval_parameters"] = preset_retrieval_parameters
        if eval_parameters is not OMIT:
            _request["eval_parameters"] = eval_parameters
        if llama_parse_enabled is not OMIT:
            _request["llama_parse_enabled"] = llama_parse_enabled
        if name is not OMIT:
            _request["name"] = name
        if managed_pipeline_id is not OMIT:
            _request["managed_pipeline_id"] = managed_pipeline_id
        _response = await self._client_wrapper.httpx_client.request(
            "PUT",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/pipeline/{pipeline_id}"),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(Pipeline, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def delete_pipeline(self, pipeline_id: str) -> None:
        """
        Delete a pipeline by ID.

        Parameters:
            - pipeline_id: str.
        ---
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.pipeline.delete_pipeline(
            pipeline_id="string",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "DELETE",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/pipeline/{pipeline_id}"),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_loaded_files_for_pipeline(self, pipeline_id: str) -> typing.List[LoadedFile]:
        """
        Get loaded files for a pipeline by ID.

        Parameters:
            - pipeline_id: str.
        ---
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.pipeline.get_loaded_files_for_pipeline(
            pipeline_id="string",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/pipeline/{pipeline_id}/loaded_file"),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.List[LoadedFile], _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_loaded_file_content(self, pipeline_id: str, loaded_file_id: str) -> LoadedFilePayload:
        """
        Get loaded files for a data source by ID.

        Parameters:
            - pipeline_id: str.

            - loaded_file_id: str.
        ---
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.pipeline.get_loaded_file_content(
            pipeline_id="string",
            loaded_file_id="string",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"api/pipeline/{pipeline_id}/loaded_file/{loaded_file_id}/content",
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(LoadedFilePayload, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def deploy_playground_pipeline(
        self, pipeline_id: str, *, managed_pipeline_name: typing.Optional[str] = None
    ) -> Pipeline:
        """
        Deploy a playground pipeline to a managed pipeline.

        Parameters:
            - pipeline_id: str.

            - managed_pipeline_name: typing.Optional[str].
        ---
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.pipeline.deploy_playground_pipeline(
            pipeline_id="string",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/pipeline/{pipeline_id}/deploy"),
            params=remove_none_from_dict({"managed_pipeline_name": managed_pipeline_name}),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(Pipeline, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def deploy_playground_pipeline_with_existing_managed_pipeline(self, pipeline_id: str) -> Pipeline:
        """
        Deploy a playground pipeline to the managed pipeline it is already associated with.

        Parameters:
            - pipeline_id: str.
        ---
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.pipeline.deploy_playground_pipeline_with_existing_managed_pipeline(
            pipeline_id="string",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "PUT",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/pipeline/{pipeline_id}/deploy"),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(Pipeline, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def create_playground_pipeline(
        self, pipeline_id: str, *, playground_pipeline_name: typing.Optional[str] = None
    ) -> Pipeline:
        """
        Create a playground pipeline from a managed pipeline.

        Parameters:
            - pipeline_id: str.

            - playground_pipeline_name: typing.Optional[str].
        ---
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.pipeline.create_playground_pipeline(
            pipeline_id="string",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/pipeline/{pipeline_id}/playground"),
            params=remove_none_from_dict({"playground_pipeline_name": playground_pipeline_name}),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(Pipeline, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_all_playground_jobs(self, pipeline_id: str) -> typing.List[PlaygroundJobRecord]:
        """
        Get all PlaygroundJobRecords for a given pipeline.

        Parameters:
            - pipeline_id: str.
        ---
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.pipeline.get_all_playground_jobs(
            pipeline_id="string",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"api/pipeline/{pipeline_id}/playground_job"
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.List[PlaygroundJobRecord], _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def create_playground_job(
        self, pipeline_id: str, *, loaded_file_ids: typing.Optional[typing.Union[str, typing.List[str]]] = None
    ) -> PlaygroundJobRecord:
        """
        Kick off a new Playground execution.

        Parameters:
            - pipeline_id: str.

            - loaded_file_ids: typing.Optional[typing.Union[str, typing.List[str]]].
        ---
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.pipeline.create_playground_job(
            pipeline_id="string",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"api/pipeline/{pipeline_id}/playground_job"
            ),
            params=remove_none_from_dict({"loaded_file_ids": loaded_file_ids}),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(PlaygroundJobRecord, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_playground_job_result(
        self,
        pipeline_id: str,
        *,
        configured_transformation_id: typing.Optional[str] = None,
        loaded_file_id: typing.Optional[str] = None,
        offset: typing.Optional[int] = None,
        limit: typing.Optional[int] = None,
    ) -> typing.List[PlatformTextNode]:
        """
        Get the result of the latest Playground job.

        Parameters:
            - pipeline_id: str.

            - configured_transformation_id: typing.Optional[str].

            - loaded_file_id: typing.Optional[str].

            - offset: typing.Optional[int].

            - limit: typing.Optional[int].
        ---
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.pipeline.get_playground_job_result(
            pipeline_id="string",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"api/pipeline/{pipeline_id}/playground_job/result"
            ),
            params=remove_none_from_dict(
                {
                    "configured_transformation_id": configured_transformation_id,
                    "loaded_file_id": loaded_file_id,
                    "offset": offset,
                    "limit": limit,
                }
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.List[PlatformTextNode], _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_playground_job(self, pipeline_id: str, playground_job_id: str) -> PlaygroundJobRecord:
        """
        Get status of a single pipeline PlaygroundJob for a given pipeline.

        Parameters:
            - pipeline_id: str.

            - playground_job_id: str.
        ---
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.pipeline.get_playground_job(
            pipeline_id="string",
            playground_job_id="string",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"api/pipeline/{pipeline_id}/playground_job/{playground_job_id}",
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(PlaygroundJobRecord, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_eval_dataset_executions(
        self, pipeline_id: str, eval_dataset_id: str
    ) -> typing.List[EvalDatasetJobRecord]:
        """
        Get the status of an EvalDatasetExecution.

        Parameters:
            - pipeline_id: str.

            - eval_dataset_id: str.
        ---
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.pipeline.get_eval_dataset_executions(
            pipeline_id="string",
            eval_dataset_id="string",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"api/pipeline/{pipeline_id}/eval_dataset/{eval_dataset_id}/execute",
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.List[EvalDatasetJobRecord], _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def execute_eval_dataset(
        self,
        pipeline_id: str,
        eval_dataset_id: str,
        *,
        eval_question_ids: typing.List[str],
        params: typing.Optional[EvalExecutionParamsOverride] = OMIT,
    ) -> EvalDatasetJobRecord:
        """
        Execute a dataset.

        Parameters:
            - pipeline_id: str.

            - eval_dataset_id: str.

            - eval_question_ids: typing.List[str].

            - params: typing.Optional[EvalExecutionParamsOverride]. The parameters for the eval execution that will override the ones set in the pipeline.
        ---
        from platform import EvalExecutionParamsOverride, SupportedEvalLlmModelNames
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.pipeline.execute_eval_dataset(
            pipeline_id="string",
            eval_dataset_id="string",
            eval_question_ids=[],
            params=EvalExecutionParamsOverride(
                llm_model=SupportedEvalLlmModelNames.GPT_3_5_TURBO,
            ),
        )
        """
        _request: typing.Dict[str, typing.Any] = {"eval_question_ids": eval_question_ids}
        if params is not OMIT:
            _request["params"] = params
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"api/pipeline/{pipeline_id}/eval_dataset/{eval_dataset_id}/execute",
            ),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(EvalDatasetJobRecord, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_eval_dataset_execution_result(
        self, pipeline_id: str, eval_dataset_id: str
    ) -> typing.List[EvalQuestionResult]:
        """
        Get the result of an EvalDatasetExecution.
        If eval_question_ids is specified, only the results for the specified
        questions will be returned.
        If any of the specified questions do not have a result, they will be ignored.

        Parameters:
            - pipeline_id: str.

            - eval_dataset_id: str.
        ---
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.pipeline.get_eval_dataset_execution_result(
            pipeline_id="string",
            eval_dataset_id="string",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"api/pipeline/{pipeline_id}/eval_dataset/{eval_dataset_id}/execute/result",
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.List[EvalQuestionResult], _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_eval_dataset_execution(
        self, pipeline_id: str, eval_dataset_id: str, eval_dataset_execution_id: str
    ) -> EvalDatasetJobRecord:
        """
        Get the status of an EvalDatasetExecution.

        Parameters:
            - pipeline_id: str.

            - eval_dataset_id: str.

            - eval_dataset_execution_id: str.
        ---
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.pipeline.get_eval_dataset_execution(
            pipeline_id="string",
            eval_dataset_id="string",
            eval_dataset_execution_id="string",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"api/pipeline/{pipeline_id}/eval_dataset/{eval_dataset_id}/execute/{eval_dataset_execution_id}",
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(EvalDatasetJobRecord, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_raw_file_managed_ingestion_executions(
        self, pipeline_id: str, raw_file_name: str
    ) -> typing.List[RawFileManagedIngestionJobRecord]:
        """
        Get all ManagedRawFileIngestionExecution for a given pipeline and raw file.

        Parameters:
            - pipeline_id: str.

            - raw_file_name: str.
        ---
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.pipeline.get_raw_file_managed_ingestion_executions(
            pipeline_id="string",
            raw_file_name="string",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"api/pipeline/{pipeline_id}/raw_file/{raw_file_name}/managed_ingest",
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.List[RawFileManagedIngestionJobRecord], _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def run_raw_file_managed_ingestion(
        self, pipeline_id: str, raw_file_name: str
    ) -> RawFileManagedIngestionJobRecord:
        """
        Execute a ManagedRawFileIngestion.

        Parameters:
            - pipeline_id: str.

            - raw_file_name: str.
        ---
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.pipeline.run_raw_file_managed_ingestion(
            pipeline_id="string",
            raw_file_name="string",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"api/pipeline/{pipeline_id}/raw_file/{raw_file_name}/managed_ingest",
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(RawFileManagedIngestionJobRecord, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_raw_file_managed_ingestion_execution(
        self, pipeline_id: str, raw_file_name: str, managed_raw_file_ingestion_id: str
    ) -> RawFileManagedIngestionJobRecord:
        """
        Get a single ManagedRawFileIngestionExecution for a given pipeline and raw file.

        Parameters:
            - pipeline_id: str.

            - raw_file_name: str.

            - managed_raw_file_ingestion_id: str.
        ---
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.pipeline.get_raw_file_managed_ingestion_execution(
            pipeline_id="string",
            raw_file_name="string",
            managed_raw_file_ingestion_id="string",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"api/pipeline/{pipeline_id}/raw_file/{raw_file_name}/managed_ingest/{managed_raw_file_ingestion_id}",
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(RawFileManagedIngestionJobRecord, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_managed_data_source_ingestion_executions(
        self, pipeline_id: str, data_source_id: str
    ) -> typing.List[DataSourceManagedIngestionJobRecord]:
        """
        Get all ManagedDataSourceIngestionExecution for a given pipeline and data source.

        Parameters:
            - pipeline_id: str.

            - data_source_id: str.
        ---
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.pipeline.get_managed_data_source_ingestion_executions(
            pipeline_id="string",
            data_source_id="string",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"api/pipeline/{pipeline_id}/data_source/{data_source_id}/managed_ingest",
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.List[DataSourceManagedIngestionJobRecord], _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def run_managed_data_source_ingestion(
        self, pipeline_id: str, data_source_id: str
    ) -> DataSourceManagedIngestionJobRecord:
        """
        Execute a ManagedDataSourceIngestion.

        Parameters:
            - pipeline_id: str.

            - data_source_id: str.
        ---
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.pipeline.run_managed_data_source_ingestion(
            pipeline_id="string",
            data_source_id="string",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"api/pipeline/{pipeline_id}/data_source/{data_source_id}/managed_ingest",
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(DataSourceManagedIngestionJobRecord, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_managed_data_source_ingestion_execution(
        self, pipeline_id: str, data_source_id: str, managed_data_source_ingestion_id: str
    ) -> DataSourceManagedIngestionJobRecord:
        """
        Get a single ManagedDataSourceIngestionExecution for a given pipeline and data source.

        Parameters:
            - pipeline_id: str.

            - data_source_id: str.

            - managed_data_source_ingestion_id: str.
        ---
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.pipeline.get_managed_data_source_ingestion_execution(
            pipeline_id="string",
            data_source_id="string",
            managed_data_source_ingestion_id="string",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"api/pipeline/{pipeline_id}/data_source/{data_source_id}/managed_ingest/{managed_data_source_ingestion_id}",
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(DataSourceManagedIngestionJobRecord, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_managed_pipeline_ingestion_executions(
        self, pipeline_id: str
    ) -> typing.List[PipelineManagedIngestionJobRecord]:
        """
        Get all ManagedPipelineIngestionExecution for a given pipeline.

        Parameters:
            - pipeline_id: str.
        ---
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.pipeline.get_managed_pipeline_ingestion_executions(
            pipeline_id="string",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"api/pipeline/{pipeline_id}/managed_ingest"
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.List[PipelineManagedIngestionJobRecord], _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def run_managed_pipeline_ingestion(self, pipeline_id: str) -> PipelineManagedIngestionJobRecord:
        """
        Execute a ManagedPipelineIngestion.

        Parameters:
            - pipeline_id: str.
        ---
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.pipeline.run_managed_pipeline_ingestion(
            pipeline_id="string",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"api/pipeline/{pipeline_id}/managed_ingest"
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(PipelineManagedIngestionJobRecord, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_managed_ingestion_execution(
        self, pipeline_id: str, managed_pipeline_ingestion_id: str
    ) -> PipelineManagedIngestionJobRecord:
        """
        Parameters:
            - pipeline_id: str.

            - managed_pipeline_ingestion_id: str.
        ---
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.pipeline.get_managed_ingestion_execution(
            pipeline_id="string",
            managed_pipeline_ingestion_id="string",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"api/pipeline/{pipeline_id}/managed_ingest/{managed_pipeline_ingestion_id}",
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(PipelineManagedIngestionJobRecord, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def run_search(
        self,
        pipeline_id: str,
        *,
        dense_similarity_top_k: typing.Optional[int] = OMIT,
        sparse_similarity_top_k: typing.Optional[int] = OMIT,
        enable_reranking: typing.Optional[bool] = OMIT,
        rerank_top_n: typing.Optional[int] = OMIT,
        alpha: typing.Optional[float] = OMIT,
        search_filters: typing.Optional[typing.Dict[str, typing.List[typing.Any]]] = OMIT,
        query: str,
        class_name: typing.Optional[str] = OMIT,
    ) -> RetrieveResults:
        """
        Get retrieval results for a managed pipeline and a query

        Parameters:
            - pipeline_id: str.

            - dense_similarity_top_k: typing.Optional[int]. Number of nodes for dense retrieval.

            - sparse_similarity_top_k: typing.Optional[int]. Number of nodes for sparse retrieval.

            - enable_reranking: typing.Optional[bool]. Enable reranking for retrieval

            - rerank_top_n: typing.Optional[int]. Number of reranked nodes for returning.

            - alpha: typing.Optional[float]. Alpha value for hybrid retrieval to determine the weights between dense and sparse retrieval. 0 is sparse retrieval and 1 is dense retrieval.

            - search_filters: typing.Optional[typing.Dict[str, typing.List[typing.Any]]]. Search filters for retrieval. the format of search_filters is a dict of {key: (operator, value)}

            - query: str. The query to retrieve against.

            - class_name: typing.Optional[str].
        ---
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.pipeline.run_search(
            pipeline_id="string",
            query="string",
        )
        """
        _request: typing.Dict[str, typing.Any] = {"query": query}
        if dense_similarity_top_k is not OMIT:
            _request["dense_similarity_top_k"] = dense_similarity_top_k
        if sparse_similarity_top_k is not OMIT:
            _request["sparse_similarity_top_k"] = sparse_similarity_top_k
        if enable_reranking is not OMIT:
            _request["enable_reranking"] = enable_reranking
        if rerank_top_n is not OMIT:
            _request["rerank_top_n"] = rerank_top_n
        if alpha is not OMIT:
            _request["alpha"] = alpha
        if search_filters is not OMIT:
            _request["search_filters"] = search_filters
        if class_name is not OMIT:
            _request["class_name"] = class_name
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/pipeline/{pipeline_id}/retrieve"),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(RetrieveResults, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def read_raw_files(self, pipeline_id: str) -> typing.List[RawFile]:
        """
        Read RawFile metadata objects.

        Parameters:
            - pipeline_id: str.
        ---
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.pipeline.read_raw_files(
            pipeline_id="string",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/pipeline/{pipeline_id}/raw_file"),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.List[RawFile], _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def upsert_raw_file(self, pipeline_id: str, *, file: typing.IO) -> RawFile:
        """
        Uploads a raw file to S3 and returns the RawFile metadata object.

        Parameters:
            - pipeline_id: str.

            - file: typing.IO.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "PUT",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/pipeline/{pipeline_id}/raw_file"),
            data=jsonable_encoder({}),
            files={"file": file},
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(RawFile, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def read_raw_file_content(self, pipeline_id: str, name: str) -> None:
        """
        Redirects to a presigned url to read the raw file content.

        Parameters:
            - pipeline_id: str.

            - name: str.
        ---
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.pipeline.read_raw_file_content(
            pipeline_id="string",
            name="string",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"api/pipeline/{pipeline_id}/raw_file/{name}"
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def delete_raw_file(self, pipeline_id: str, name: str) -> None:
        """
        Delete the raw file from S3.

        Parameters:
            - pipeline_id: str.

            - name: str.
        ---
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.pipeline.delete_raw_file(
            pipeline_id="string",
            name="string",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "DELETE",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"api/pipeline/{pipeline_id}/raw_file/{name}"
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
