# This file was auto-generated by Fern from our API Definition.

import typing
import urllib.parse
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.jsonable_encoder import jsonable_encoder
from ...errors.unprocessable_entity_error import UnprocessableEntityError
from ...types.configurable_data_source_names import ConfigurableDataSourceNames
from ...types.data_source import DataSource
from ...types.data_source_create import DataSourceCreate
from ...types.data_source_load_job_record import DataSourceLoadJobRecord
from ...types.http_validation_error import HttpValidationError
from .types.data_source_update_component import DataSourceUpdateComponent

try:
    import pydantic
    if pydantic.__version__.startswith("1."):
        raise ImportError

    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class DataSourceClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def create_data_source(self, *, request: DataSourceCreate) -> DataSource:
        """
        Create a new data source.

        Parameters:
            - request: DataSourceCreate.
        ---
        from platform import ConfigurableDataSourceNames, DataSourceCreate
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.data_source.create_data_source(
            request=DataSourceCreate(
                name="string",
                source_type=ConfigurableDataSourceNames.DISCORD,
            ),
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "api/data_source"),
            json=jsonable_encoder(request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(DataSource, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def upsert_data_source(self, *, request: DataSourceCreate) -> DataSource:
        """
        Upserts a data source.
        Updates if a data source with the same name and user_id already exists.Otherwise, creates a new data source.

        Parameters:
            - request: DataSourceCreate.
        ---
        from platform import ConfigurableDataSourceNames, DataSourceCreate
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.data_source.upsert_data_source(
            request=DataSourceCreate(
                name="string",
                source_type=ConfigurableDataSourceNames.DISCORD,
            ),
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "PUT",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "api/data_source"),
            json=jsonable_encoder(request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(DataSource, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_data_source(self, data_source_id: str) -> DataSource:
        """
        Get a data source by ID.

        Parameters:
            - data_source_id: str.
        ---
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.data_source.get_data_source(
            data_source_id="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/data_source/{data_source_id}"),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(DataSource, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def update_data_source(
        self,
        data_source_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        source_type: ConfigurableDataSourceNames,
        component: typing.Optional[DataSourceUpdateComponent] = OMIT,
    ) -> DataSource:
        """
        Update a data source by ID.

        Parameters:
            - data_source_id: str.

            - name: typing.Optional[str]. The name of the data source.

            - source_type: ConfigurableDataSourceNames.

            - component: typing.Optional[DataSourceUpdateComponent].
        ---
        from platform import ConfigurableDataSourceNames
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.data_source.update_data_source(
            data_source_id="string",
            source_type=ConfigurableDataSourceNames.DISCORD,
        )
        """
        _request: typing.Dict[str, typing.Any] = {"source_type": source_type}
        if name is not OMIT:
            _request["name"] = name
        if component is not OMIT:
            _request["component"] = component
        _response = self._client_wrapper.httpx_client.request(
            "PUT",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/data_source/{data_source_id}"),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(DataSource, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def delete_data_source(self, data_source_id: str) -> None:
        """
        Delete a data source by ID.

        Parameters:
            - data_source_id: str.
        ---
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.data_source.delete_data_source(
            data_source_id="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "DELETE",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/data_source/{data_source_id}"),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_data_source_executions(self, data_source_id: str) -> typing.List[DataSourceLoadJobRecord]:
        """
        Get all data source executions for a given data source.

        Parameters:
            - data_source_id: str.
        ---
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.data_source.get_data_source_executions(
            data_source_id="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"api/data_source/{data_source_id}/execution"
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.List[DataSourceLoadJobRecord], _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def create_data_source_execution(self, data_source_id: str) -> DataSourceLoadJobRecord:
        """
        Create a new data source execution.

        Parameters:
            - data_source_id: str.
        ---
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.data_source.create_data_source_execution(
            data_source_id="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"api/data_source/{data_source_id}/execution"
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(DataSourceLoadJobRecord, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_data_source_execution(
        self, data_source_id: str, data_source_load_execution_id: str
    ) -> DataSourceLoadJobRecord:
        """
        Get a data source execution by ID.

        Parameters:
            - data_source_id: str.

            - data_source_load_execution_id: str.
        ---
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.data_source.get_data_source_execution(
            data_source_id="string",
            data_source_load_execution_id="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"api/data_source/{data_source_id}/execution/{data_source_load_execution_id}",
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(DataSourceLoadJobRecord, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncDataSourceClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def create_data_source(self, *, request: DataSourceCreate) -> DataSource:
        """
        Create a new data source.

        Parameters:
            - request: DataSourceCreate.
        ---
        from platform import ConfigurableDataSourceNames, DataSourceCreate
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.data_source.create_data_source(
            request=DataSourceCreate(
                name="string",
                source_type=ConfigurableDataSourceNames.DISCORD,
            ),
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "api/data_source"),
            json=jsonable_encoder(request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(DataSource, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def upsert_data_source(self, *, request: DataSourceCreate) -> DataSource:
        """
        Upserts a data source.
        Updates if a data source with the same name and user_id already exists.Otherwise, creates a new data source.

        Parameters:
            - request: DataSourceCreate.
        ---
        from platform import ConfigurableDataSourceNames, DataSourceCreate
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.data_source.upsert_data_source(
            request=DataSourceCreate(
                name="string",
                source_type=ConfigurableDataSourceNames.DISCORD,
            ),
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "PUT",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "api/data_source"),
            json=jsonable_encoder(request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(DataSource, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_data_source(self, data_source_id: str) -> DataSource:
        """
        Get a data source by ID.

        Parameters:
            - data_source_id: str.
        ---
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.data_source.get_data_source(
            data_source_id="string",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/data_source/{data_source_id}"),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(DataSource, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def update_data_source(
        self,
        data_source_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        source_type: ConfigurableDataSourceNames,
        component: typing.Optional[DataSourceUpdateComponent] = OMIT,
    ) -> DataSource:
        """
        Update a data source by ID.

        Parameters:
            - data_source_id: str.

            - name: typing.Optional[str]. The name of the data source.

            - source_type: ConfigurableDataSourceNames.

            - component: typing.Optional[DataSourceUpdateComponent].
        ---
        from platform import ConfigurableDataSourceNames
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.data_source.update_data_source(
            data_source_id="string",
            source_type=ConfigurableDataSourceNames.DISCORD,
        )
        """
        _request: typing.Dict[str, typing.Any] = {"source_type": source_type}
        if name is not OMIT:
            _request["name"] = name
        if component is not OMIT:
            _request["component"] = component
        _response = await self._client_wrapper.httpx_client.request(
            "PUT",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/data_source/{data_source_id}"),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(DataSource, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def delete_data_source(self, data_source_id: str) -> None:
        """
        Delete a data source by ID.

        Parameters:
            - data_source_id: str.
        ---
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.data_source.delete_data_source(
            data_source_id="string",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "DELETE",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/data_source/{data_source_id}"),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_data_source_executions(self, data_source_id: str) -> typing.List[DataSourceLoadJobRecord]:
        """
        Get all data source executions for a given data source.

        Parameters:
            - data_source_id: str.
        ---
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.data_source.get_data_source_executions(
            data_source_id="string",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"api/data_source/{data_source_id}/execution"
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.List[DataSourceLoadJobRecord], _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def create_data_source_execution(self, data_source_id: str) -> DataSourceLoadJobRecord:
        """
        Create a new data source execution.

        Parameters:
            - data_source_id: str.
        ---
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.data_source.create_data_source_execution(
            data_source_id="string",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"api/data_source/{data_source_id}/execution"
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(DataSourceLoadJobRecord, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_data_source_execution(
        self, data_source_id: str, data_source_load_execution_id: str
    ) -> DataSourceLoadJobRecord:
        """
        Get a data source execution by ID.

        Parameters:
            - data_source_id: str.

            - data_source_load_execution_id: str.
        ---
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.data_source.get_data_source_execution(
            data_source_id="string",
            data_source_load_execution_id="string",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"api/data_source/{data_source_id}/execution/{data_source_load_execution_id}",
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(DataSourceLoadJobRecord, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
