# This file was auto-generated by Fern from our API Definition.

import typing
import urllib.parse
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.jsonable_encoder import jsonable_encoder
from ...errors.unprocessable_entity_error import UnprocessableEntityError
from ...types.configurable_data_sink_names import ConfigurableDataSinkNames
from ...types.data_sink import DataSink
from ...types.data_sink_create import DataSinkCreate
from ...types.http_validation_error import HttpValidationError
from .types.data_sink_update_component import DataSinkUpdateComponent

try:
    import pydantic
    if pydantic.__version__.startswith("1."):
        raise ImportError

    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class DataSinkClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def create_data_sink(self, *, request: DataSinkCreate) -> DataSink:
        """
        Create a new data sink.

        Parameters:
            - request: DataSinkCreate.
        ---
        from platform import ConfigurableDataSinkNames, DataSinkCreate
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.data_sink.create_data_sink(
            request=DataSinkCreate(
                name="string",
                sink_type=ConfigurableDataSinkNames.CHROMA,
            ),
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "api/data_sink"),
            json=jsonable_encoder(request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(DataSink, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def upsert_data_sink(self, *, request: DataSinkCreate) -> DataSink:
        """
        Upserts a data sink.
        Updates if a data sink with the same name and user_id already exists. Otherwise, creates a new data sink.

        Parameters:
            - request: DataSinkCreate.
        ---
        from platform import ConfigurableDataSinkNames, DataSinkCreate
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.data_sink.upsert_data_sink(
            request=DataSinkCreate(
                name="string",
                sink_type=ConfigurableDataSinkNames.CHROMA,
            ),
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "PUT",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "api/data_sink"),
            json=jsonable_encoder(request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(DataSink, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_data_sink(self, data_sink_id: str) -> DataSink:
        """
        Get a data sink by ID.

        Parameters:
            - data_sink_id: str.
        ---
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.data_sink.get_data_sink(
            data_sink_id="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/data_sink/{data_sink_id}"),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(DataSink, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def update_data_sink(
        self,
        data_sink_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        sink_type: ConfigurableDataSinkNames,
        component: typing.Optional[DataSinkUpdateComponent] = OMIT,
    ) -> DataSink:
        """
        Update a data sink by ID.

        Parameters:
            - data_sink_id: str.

            - name: typing.Optional[str]. The name of the data sink.

            - sink_type: ConfigurableDataSinkNames.

            - component: typing.Optional[DataSinkUpdateComponent].
        ---
        from platform import ConfigurableDataSinkNames
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.data_sink.update_data_sink(
            data_sink_id="string",
            sink_type=ConfigurableDataSinkNames.CHROMA,
        )
        """
        _request: typing.Dict[str, typing.Any] = {"sink_type": sink_type}
        if name is not OMIT:
            _request["name"] = name
        if component is not OMIT:
            _request["component"] = component
        _response = self._client_wrapper.httpx_client.request(
            "PUT",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/data_sink/{data_sink_id}"),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(DataSink, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def delete_data_sink(self, data_sink_id: str) -> None:
        """
        Delete a data sink by ID.

        Parameters:
            - data_sink_id: str.
        ---
        from platform.client import PlatformApi

        client = PlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.data_sink.delete_data_sink(
            data_sink_id="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "DELETE",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/data_sink/{data_sink_id}"),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncDataSinkClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def create_data_sink(self, *, request: DataSinkCreate) -> DataSink:
        """
        Create a new data sink.

        Parameters:
            - request: DataSinkCreate.
        ---
        from platform import ConfigurableDataSinkNames, DataSinkCreate
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.data_sink.create_data_sink(
            request=DataSinkCreate(
                name="string",
                sink_type=ConfigurableDataSinkNames.CHROMA,
            ),
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "api/data_sink"),
            json=jsonable_encoder(request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(DataSink, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def upsert_data_sink(self, *, request: DataSinkCreate) -> DataSink:
        """
        Upserts a data sink.
        Updates if a data sink with the same name and user_id already exists. Otherwise, creates a new data sink.

        Parameters:
            - request: DataSinkCreate.
        ---
        from platform import ConfigurableDataSinkNames, DataSinkCreate
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.data_sink.upsert_data_sink(
            request=DataSinkCreate(
                name="string",
                sink_type=ConfigurableDataSinkNames.CHROMA,
            ),
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "PUT",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "api/data_sink"),
            json=jsonable_encoder(request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(DataSink, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_data_sink(self, data_sink_id: str) -> DataSink:
        """
        Get a data sink by ID.

        Parameters:
            - data_sink_id: str.
        ---
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.data_sink.get_data_sink(
            data_sink_id="string",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/data_sink/{data_sink_id}"),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(DataSink, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def update_data_sink(
        self,
        data_sink_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        sink_type: ConfigurableDataSinkNames,
        component: typing.Optional[DataSinkUpdateComponent] = OMIT,
    ) -> DataSink:
        """
        Update a data sink by ID.

        Parameters:
            - data_sink_id: str.

            - name: typing.Optional[str]. The name of the data sink.

            - sink_type: ConfigurableDataSinkNames.

            - component: typing.Optional[DataSinkUpdateComponent].
        ---
        from platform import ConfigurableDataSinkNames
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.data_sink.update_data_sink(
            data_sink_id="string",
            sink_type=ConfigurableDataSinkNames.CHROMA,
        )
        """
        _request: typing.Dict[str, typing.Any] = {"sink_type": sink_type}
        if name is not OMIT:
            _request["name"] = name
        if component is not OMIT:
            _request["component"] = component
        _response = await self._client_wrapper.httpx_client.request(
            "PUT",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/data_sink/{data_sink_id}"),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(DataSink, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def delete_data_sink(self, data_sink_id: str) -> None:
        """
        Delete a data sink by ID.

        Parameters:
            - data_sink_id: str.
        ---
        from platform.client import AsyncPlatformApi

        client = AsyncPlatformApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.data_sink.delete_data_sink(
            data_sink_id="string",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "DELETE",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/data_sink/{data_sink_id}"),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
