"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.diffUnknown = exports.diffResource = exports.diffParameter = exports.diffOutput = exports.diffMetadata = exports.diffMapping = exports.diffCondition = exports.diffAttribute = void 0;
const cfnspec = require("../../cfnspec/lib");
const types = require("./types");
const util_1 = require("./util");
function diffAttribute(oldValue, newValue) {
    return new types.Difference(_asString(oldValue), _asString(newValue));
}
exports.diffAttribute = diffAttribute;
function diffCondition(oldValue, newValue) {
    return new types.ConditionDifference(oldValue, newValue);
}
exports.diffCondition = diffCondition;
function diffMapping(oldValue, newValue) {
    return new types.MappingDifference(oldValue, newValue);
}
exports.diffMapping = diffMapping;
function diffMetadata(oldValue, newValue) {
    return new types.MetadataDifference(oldValue, newValue);
}
exports.diffMetadata = diffMetadata;
function diffOutput(oldValue, newValue) {
    return new types.OutputDifference(oldValue, newValue);
}
exports.diffOutput = diffOutput;
function diffParameter(oldValue, newValue) {
    return new types.ParameterDifference(oldValue, newValue);
}
exports.diffParameter = diffParameter;
function diffResource(oldValue, newValue) {
    const resourceType = {
        oldType: oldValue && oldValue.Type,
        newType: newValue && newValue.Type,
    };
    let propertyDiffs = {};
    let otherDiffs = {};
    if (resourceType.oldType !== undefined && resourceType.oldType === resourceType.newType) {
        // Only makes sense to inspect deeper if the types stayed the same
        const typeSpec = cfnspec.filteredSpecification(resourceType.oldType);
        const impl = typeSpec.ResourceTypes[resourceType.oldType];
        propertyDiffs = util_1.diffKeyedEntities(oldValue.Properties, newValue.Properties, (oldVal, newVal, key) => _diffProperty(oldVal, newVal, key, impl));
        otherDiffs = util_1.diffKeyedEntities(oldValue, newValue, _diffOther);
        delete otherDiffs.Properties;
    }
    return new types.ResourceDifference(oldValue, newValue, {
        resourceType, propertyDiffs, otherDiffs,
    });
    function _diffProperty(oldV, newV, key, resourceSpec) {
        let changeImpact = types.ResourceImpact.NO_CHANGE;
        const spec = resourceSpec && resourceSpec.Properties && resourceSpec.Properties[key];
        if (spec && !util_1.deepEqual(oldV, newV)) {
            switch (spec.UpdateType) {
                case cfnspec.schema.UpdateType.Immutable:
                    changeImpact = types.ResourceImpact.WILL_REPLACE;
                    break;
                case cfnspec.schema.UpdateType.Conditional:
                    changeImpact = types.ResourceImpact.MAY_REPLACE;
                    break;
                default:
                    // In those cases, whatever is the current value is what we should keep
                    changeImpact = types.ResourceImpact.WILL_UPDATE;
            }
        }
        return new types.PropertyDifference(oldV, newV, { changeImpact });
    }
    function _diffOther(oldV, newV) {
        return new types.Difference(oldV, newV);
    }
}
exports.diffResource = diffResource;
function diffUnknown(oldValue, newValue) {
    return new types.Difference(oldValue, newValue);
}
exports.diffUnknown = diffUnknown;
/**
 * Coerces a given value to +string | undefined+.
 *
 * @param value the value to be coerced.
 *
 * @returns +undefined+ if +value+ is +null+ or +undefined+,
 *      +value+ if it is a +string+,
 *      a compact JSON representation of +value+ otherwise.
 */
function _asString(value) {
    if (value == null) {
        return undefined;
    }
    if (typeof value === 'string') {
        return value;
    }
    return JSON.stringify(value);
}
//# sourceMappingURL=data:application/json;base64,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