"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.hasOutput = exports.findOutputs = void 0;
const section_1 = require("./section");
function findOutputs(inspector, props = {}) {
    const section = inspector.value.Outputs;
    const result = section_1.matchSection(section, props);
    if (!result.match) {
        return [];
    }
    return result.matches;
}
exports.findOutputs = findOutputs;
function hasOutput(inspector, props) {
    const section = inspector.value.Outputs;
    const result = section_1.matchSection(section, props);
    if (result.match) {
        return;
    }
    if (result.closestResult === undefined) {
        return 'No outputs found in the template';
    }
    return [
        `Template has ${result.analyzedCount} outputs, but none match as expected.`,
        section_1.formatFailure(result.closestResult),
    ].join('\n');
}
exports.hasOutput = hasOutput;
//# sourceMappingURL=data:application/json;base64,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