"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.hasMapping = exports.findMappings = void 0;
const section_1 = require("./section");
function findMappings(inspector, props = {}) {
    const section = inspector.value.Mappings;
    const result = section_1.matchSection(section, props);
    if (!result.match) {
        return [];
    }
    return result.matches;
}
exports.findMappings = findMappings;
function hasMapping(inspector, props) {
    const section = inspector.value.Mappings;
    const result = section_1.matchSection(section, props);
    if (result.match) {
        return;
    }
    if (result.closestResult === undefined) {
        return 'No mappings found in the template';
    }
    return [
        `Template has ${result.analyzedCount} mappings, but none match as expected.`,
        section_1.formatFailure(result.closestResult),
    ].join('\n');
}
exports.hasMapping = hasMapping;
//# sourceMappingURL=data:application/json;base64,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