"use strict";
// Generated from the AliCloud ROS Resource Specification
Object.defineProperty(exports, "__esModule", { value: true });
exports.RosDBNodes = exports.RosDBInstance = exports.RosDBClusterEndpointAddress = exports.RosDBClusterEndpoint = exports.RosDBClusterAccessWhiteList = exports.RosDBCluster = exports.RosAccountPrivilege = exports.RosAccount = void 0;
const ros = require("@alicloud/ros-cdk-core");
/**
 * Determine whether the given properties match those of a `RosAccountProps`
 *
 * @param properties - the TypeScript properties of a `RosAccountProps`
 *
 * @returns the result of the validation.
 */
function RosAccountPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    if (properties.accountDescription && (Array.isArray(properties.accountDescription) || (typeof properties.accountDescription) === 'string')) {
        errors.collect(ros.propertyValidator('accountDescription', ros.validateLength)({
            data: properties.accountDescription.length,
            min: 2,
            max: 256,
        }));
    }
    errors.collect(ros.propertyValidator('accountDescription', ros.validateString)(properties.accountDescription));
    errors.collect(ros.propertyValidator('accountPrivilege', ros.validateString)(properties.accountPrivilege));
    errors.collect(ros.propertyValidator('dbClusterId', ros.requiredValidator)(properties.dbClusterId));
    errors.collect(ros.propertyValidator('dbClusterId', ros.validateString)(properties.dbClusterId));
    errors.collect(ros.propertyValidator('dbName', ros.validateString)(properties.dbName));
    if (properties.accountType && (typeof properties.accountType) !== 'object') {
        errors.collect(ros.propertyValidator('accountType', ros.validateAllowedValues)({
            data: properties.accountType,
            allowedValues: ["Normal", "Super"],
        }));
    }
    errors.collect(ros.propertyValidator('accountType', ros.validateString)(properties.accountType));
    errors.collect(ros.propertyValidator('accountName', ros.requiredValidator)(properties.accountName));
    if (properties.accountName && (Array.isArray(properties.accountName) || (typeof properties.accountName) === 'string')) {
        errors.collect(ros.propertyValidator('accountName', ros.validateLength)({
            data: properties.accountName.length,
            min: 1,
            max: 16,
        }));
    }
    errors.collect(ros.propertyValidator('accountName', ros.validateString)(properties.accountName));
    errors.collect(ros.propertyValidator('accountPassword', ros.requiredValidator)(properties.accountPassword));
    if (properties.accountPassword && (Array.isArray(properties.accountPassword) || (typeof properties.accountPassword) === 'string')) {
        errors.collect(ros.propertyValidator('accountPassword', ros.validateLength)({
            data: properties.accountPassword.length,
            min: 8,
            max: 32,
        }));
    }
    errors.collect(ros.propertyValidator('accountPassword', ros.validateString)(properties.accountPassword));
    return errors.wrap('supplied properties not correct for "RosAccountProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::POLARDB::Account` resource
 *
 * @param properties - the TypeScript properties of a `RosAccountProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::POLARDB::Account` resource.
 */
// @ts-ignore TS6133
function rosAccountPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosAccountPropsValidator(properties).assertSuccess();
    }
    return {
        AccountName: ros.stringToRosTemplate(properties.accountName),
        AccountPassword: ros.stringToRosTemplate(properties.accountPassword),
        DBClusterId: ros.stringToRosTemplate(properties.dbClusterId),
        AccountDescription: ros.stringToRosTemplate(properties.accountDescription),
        AccountPrivilege: ros.stringToRosTemplate(properties.accountPrivilege),
        AccountType: ros.stringToRosTemplate(properties.accountType),
        DBName: ros.stringToRosTemplate(properties.dbName),
    };
}
/**
 * A ROS template type:  `ALIYUN::POLARDB::Account`
 */
class RosAccount extends ros.RosResource {
    /**
     * Create a new `ALIYUN::POLARDB::Account`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosAccount.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.accountName = props.accountName;
        this.accountPassword = props.accountPassword;
        this.dbClusterId = props.dbClusterId;
        this.accountDescription = props.accountDescription;
        this.accountPrivilege = props.accountPrivilege;
        this.accountType = props.accountType;
        this.dbName = props.dbName;
    }
    get rosProperties() {
        return {
            accountName: this.accountName,
            accountPassword: this.accountPassword,
            dbClusterId: this.dbClusterId,
            accountDescription: this.accountDescription,
            accountPrivilege: this.accountPrivilege,
            accountType: this.accountType,
            dbName: this.dbName,
        };
    }
    renderProperties(props) {
        return rosAccountPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosAccount = RosAccount;
/**
 * The resource type name for this resource class.
 */
RosAccount.ROS_RESOURCE_TYPE_NAME = "ALIYUN::POLARDB::Account";
/**
 * Determine whether the given properties match those of a `RosAccountPrivilegeProps`
 *
 * @param properties - the TypeScript properties of a `RosAccountPrivilegeProps`
 *
 * @returns the result of the validation.
 */
function RosAccountPrivilegePropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('accountPrivilege', ros.requiredValidator)(properties.accountPrivilege));
    if (properties.accountPrivilege && (Array.isArray(properties.accountPrivilege) || (typeof properties.accountPrivilege) === 'string')) {
        errors.collect(ros.propertyValidator('accountPrivilege', ros.validateLength)({
            data: properties.accountPrivilege.length,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('accountPrivilege', ros.validateString)(properties.accountPrivilege));
    errors.collect(ros.propertyValidator('dbClusterId', ros.requiredValidator)(properties.dbClusterId));
    errors.collect(ros.propertyValidator('dbClusterId', ros.validateString)(properties.dbClusterId));
    errors.collect(ros.propertyValidator('dbName', ros.requiredValidator)(properties.dbName));
    if (properties.dbName && (Array.isArray(properties.dbName) || (typeof properties.dbName) === 'string')) {
        errors.collect(ros.propertyValidator('dbName', ros.validateLength)({
            data: properties.dbName.length,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('dbName', ros.validateString)(properties.dbName));
    errors.collect(ros.propertyValidator('accountName', ros.requiredValidator)(properties.accountName));
    if (properties.accountName && (Array.isArray(properties.accountName) || (typeof properties.accountName) === 'string')) {
        errors.collect(ros.propertyValidator('accountName', ros.validateLength)({
            data: properties.accountName.length,
            min: 1,
            max: 16,
        }));
    }
    errors.collect(ros.propertyValidator('accountName', ros.validateString)(properties.accountName));
    return errors.wrap('supplied properties not correct for "RosAccountPrivilegeProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::POLARDB::AccountPrivilege` resource
 *
 * @param properties - the TypeScript properties of a `RosAccountPrivilegeProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::POLARDB::AccountPrivilege` resource.
 */
// @ts-ignore TS6133
function rosAccountPrivilegePropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosAccountPrivilegePropsValidator(properties).assertSuccess();
    }
    return {
        AccountName: ros.stringToRosTemplate(properties.accountName),
        AccountPrivilege: ros.stringToRosTemplate(properties.accountPrivilege),
        DBClusterId: ros.stringToRosTemplate(properties.dbClusterId),
        DBName: ros.stringToRosTemplate(properties.dbName),
    };
}
/**
 * A ROS template type:  `ALIYUN::POLARDB::AccountPrivilege`
 */
class RosAccountPrivilege extends ros.RosResource {
    /**
     * Create a new `ALIYUN::POLARDB::AccountPrivilege`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosAccountPrivilege.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.accountName = props.accountName;
        this.accountPrivilege = props.accountPrivilege;
        this.dbClusterId = props.dbClusterId;
        this.dbName = props.dbName;
    }
    get rosProperties() {
        return {
            accountName: this.accountName,
            accountPrivilege: this.accountPrivilege,
            dbClusterId: this.dbClusterId,
            dbName: this.dbName,
        };
    }
    renderProperties(props) {
        return rosAccountPrivilegePropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosAccountPrivilege = RosAccountPrivilege;
/**
 * The resource type name for this resource class.
 */
RosAccountPrivilege.ROS_RESOURCE_TYPE_NAME = "ALIYUN::POLARDB::AccountPrivilege";
/**
 * Determine whether the given properties match those of a `RosDBClusterProps`
 *
 * @param properties - the TypeScript properties of a `RosDBClusterProps`
 *
 * @returns the result of the validation.
 */
function RosDBClusterPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('defaultTimeZone', ros.validateString)(properties.defaultTimeZone));
    errors.collect(ros.propertyValidator('cloneDataPoint', ros.validateString)(properties.cloneDataPoint));
    errors.collect(ros.propertyValidator('gdnId', ros.validateString)(properties.gdnId));
    errors.collect(ros.propertyValidator('resourceGroupId', ros.validateString)(properties.resourceGroupId));
    if (properties.backupRetentionPolicyOnClusterDeletion && (typeof properties.backupRetentionPolicyOnClusterDeletion) !== 'object') {
        errors.collect(ros.propertyValidator('backupRetentionPolicyOnClusterDeletion', ros.validateAllowedValues)({
            data: properties.backupRetentionPolicyOnClusterDeletion,
            allowedValues: ["ALL", "LATEST", "NONE"],
        }));
    }
    errors.collect(ros.propertyValidator('backupRetentionPolicyOnClusterDeletion', ros.validateString)(properties.backupRetentionPolicyOnClusterDeletion));
    errors.collect(ros.propertyValidator('sourceResourceId', ros.validateString)(properties.sourceResourceId));
    errors.collect(ros.propertyValidator('dbType', ros.requiredValidator)(properties.dbType));
    if (properties.dbType && (typeof properties.dbType) !== 'object') {
        errors.collect(ros.propertyValidator('dbType', ros.validateAllowedValues)({
            data: properties.dbType,
            allowedValues: ["MySQL", "Oracle", "PostgreSQL"],
        }));
    }
    errors.collect(ros.propertyValidator('dbType', ros.validateString)(properties.dbType));
    errors.collect(ros.propertyValidator('dbVersion', ros.requiredValidator)(properties.dbVersion));
    errors.collect(ros.propertyValidator('dbVersion', ros.validateString)(properties.dbVersion));
    if (properties.clusterNetworkType && (typeof properties.clusterNetworkType) !== 'object') {
        errors.collect(ros.propertyValidator('clusterNetworkType', ros.validateAllowedValues)({
            data: properties.clusterNetworkType,
            allowedValues: ["VPC"],
        }));
    }
    errors.collect(ros.propertyValidator('clusterNetworkType', ros.validateString)(properties.clusterNetworkType));
    errors.collect(ros.propertyValidator('securityIpList', ros.validateString)(properties.securityIpList));
    errors.collect(ros.propertyValidator('dbClusterParameters', RosDBCluster_DBClusterParametersPropertyValidator)(properties.dbClusterParameters));
    errors.collect(ros.propertyValidator('maintainTime', ros.validateString)(properties.maintainTime));
    if (properties.tags && (Array.isArray(properties.tags) || (typeof properties.tags) === 'string')) {
        errors.collect(ros.propertyValidator('tags', ros.validateLength)({
            data: properties.tags.length,
            min: undefined,
            max: 20,
        }));
    }
    errors.collect(ros.propertyValidator('tags', ros.listValidator(RosDBCluster_TagsPropertyValidator))(properties.tags));
    if (properties.lowerCaseTableNames && (typeof properties.lowerCaseTableNames) !== 'object') {
        errors.collect(ros.propertyValidator('lowerCaseTableNames', ros.validateAllowedValues)({
            data: properties.lowerCaseTableNames,
            allowedValues: [0, 1],
        }));
    }
    errors.collect(ros.propertyValidator('lowerCaseTableNames', ros.validateNumber)(properties.lowerCaseTableNames));
    if (properties.autoRenewPeriod && (typeof properties.autoRenewPeriod) !== 'object') {
        errors.collect(ros.propertyValidator('autoRenewPeriod', ros.validateAllowedValues)({
            data: properties.autoRenewPeriod,
            allowedValues: [1, 2, 3, 6, 12, 24, 36],
        }));
    }
    errors.collect(ros.propertyValidator('autoRenewPeriod', ros.validateNumber)(properties.autoRenewPeriod));
    errors.collect(ros.propertyValidator('tdeStatus', ros.validateBoolean)(properties.tdeStatus));
    errors.collect(ros.propertyValidator('zoneId', ros.validateString)(properties.zoneId));
    errors.collect(ros.propertyValidator('vSwitchId', ros.validateString)(properties.vSwitchId));
    if (properties.renewalStatus && (typeof properties.renewalStatus) !== 'object') {
        errors.collect(ros.propertyValidator('renewalStatus', ros.validateAllowedValues)({
            data: properties.renewalStatus,
            allowedValues: ["AutoRenewal", "Normal", "NotRenewal"],
        }));
    }
    errors.collect(ros.propertyValidator('renewalStatus', ros.validateString)(properties.renewalStatus));
    if (properties.dbClusterDescription && (Array.isArray(properties.dbClusterDescription) || (typeof properties.dbClusterDescription) === 'string')) {
        errors.collect(ros.propertyValidator('dbClusterDescription', ros.validateLength)({
            data: properties.dbClusterDescription.length,
            min: 2,
            max: 256,
        }));
    }
    errors.collect(ros.propertyValidator('dbClusterDescription', ros.validateString)(properties.dbClusterDescription));
    if (properties.period && (typeof properties.period) !== 'object') {
        errors.collect(ros.propertyValidator('period', ros.validateAllowedValues)({
            data: properties.period,
            allowedValues: [1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24, 36],
        }));
    }
    errors.collect(ros.propertyValidator('period', ros.validateNumber)(properties.period));
    errors.collect(ros.propertyValidator('payType', ros.requiredValidator)(properties.payType));
    if (properties.payType && (typeof properties.payType) !== 'object') {
        errors.collect(ros.propertyValidator('payType', ros.validateAllowedValues)({
            data: properties.payType,
            allowedValues: ["Postpaid", "Prepaid"],
        }));
    }
    errors.collect(ros.propertyValidator('payType', ros.validateString)(properties.payType));
    errors.collect(ros.propertyValidator('creationCategory', ros.validateString)(properties.creationCategory));
    errors.collect(ros.propertyValidator('securityGroupIds', ros.listValidator(ros.validateString))(properties.securityGroupIds));
    errors.collect(ros.propertyValidator('dbNodeClass', ros.requiredValidator)(properties.dbNodeClass));
    errors.collect(ros.propertyValidator('dbNodeClass', ros.validateString)(properties.dbNodeClass));
    if (properties.creationOption && (typeof properties.creationOption) !== 'object') {
        errors.collect(ros.propertyValidator('creationOption', ros.validateAllowedValues)({
            data: properties.creationOption,
            allowedValues: ["CloneFromPolarDB", "CloneFromRDS", "MigrationFromRDS", "Normal", "CreateGdnStandby"],
        }));
    }
    errors.collect(ros.propertyValidator('creationOption', ros.validateString)(properties.creationOption));
    errors.collect(ros.propertyValidator('vpcId', ros.validateString)(properties.vpcId));
    return errors.wrap('supplied properties not correct for "RosDBClusterProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::POLARDB::DBCluster` resource
 *
 * @param properties - the TypeScript properties of a `RosDBClusterProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::POLARDB::DBCluster` resource.
 */
// @ts-ignore TS6133
function rosDBClusterPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosDBClusterPropsValidator(properties).assertSuccess();
    }
    return {
        DBNodeClass: ros.stringToRosTemplate(properties.dbNodeClass),
        DBType: ros.stringToRosTemplate(properties.dbType),
        DBVersion: ros.stringToRosTemplate(properties.dbVersion),
        PayType: ros.stringToRosTemplate(properties.payType),
        AutoRenewPeriod: ros.numberToRosTemplate(properties.autoRenewPeriod),
        BackupRetentionPolicyOnClusterDeletion: ros.stringToRosTemplate(properties.backupRetentionPolicyOnClusterDeletion),
        CloneDataPoint: ros.stringToRosTemplate(properties.cloneDataPoint),
        ClusterNetworkType: ros.stringToRosTemplate(properties.clusterNetworkType),
        CreationCategory: ros.stringToRosTemplate(properties.creationCategory),
        CreationOption: ros.stringToRosTemplate(properties.creationOption),
        DBClusterDescription: ros.stringToRosTemplate(properties.dbClusterDescription),
        DBClusterParameters: rosDBClusterDBClusterParametersPropertyToRosTemplate(properties.dbClusterParameters),
        DefaultTimeZone: ros.stringToRosTemplate(properties.defaultTimeZone),
        GDNId: ros.stringToRosTemplate(properties.gdnId),
        LowerCaseTableNames: ros.numberToRosTemplate(properties.lowerCaseTableNames),
        MaintainTime: ros.stringToRosTemplate(properties.maintainTime),
        Period: ros.numberToRosTemplate(properties.period),
        RenewalStatus: ros.stringToRosTemplate(properties.renewalStatus),
        ResourceGroupId: ros.stringToRosTemplate(properties.resourceGroupId),
        SecurityGroupIds: ros.listMapper(ros.stringToRosTemplate)(properties.securityGroupIds),
        SecurityIPList: ros.stringToRosTemplate(properties.securityIpList),
        SourceResourceId: ros.stringToRosTemplate(properties.sourceResourceId),
        Tags: ros.listMapper(rosDBClusterTagsPropertyToRosTemplate)(properties.tags),
        TDEStatus: ros.booleanToRosTemplate(properties.tdeStatus),
        VpcId: ros.stringToRosTemplate(properties.vpcId),
        VSwitchId: ros.stringToRosTemplate(properties.vSwitchId),
        ZoneId: ros.stringToRosTemplate(properties.zoneId),
    };
}
/**
 * A ROS template type:  `ALIYUN::POLARDB::DBCluster`
 */
class RosDBCluster extends ros.RosResource {
    /**
     * Create a new `ALIYUN::POLARDB::DBCluster`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosDBCluster.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrClusterConnectionString = this.getAtt('ClusterConnectionString');
        this.attrClusterEndpointId = this.getAtt('ClusterEndpointId');
        this.attrCustomConnectionStrings = this.getAtt('CustomConnectionStrings');
        this.attrCustomEndpointIds = this.getAtt('CustomEndpointIds');
        this.attrDbClusterId = this.getAtt('DBClusterId');
        this.attrDbNodeIds = this.getAtt('DBNodeIds');
        this.attrOrderId = this.getAtt('OrderId');
        this.attrPrimaryConnectionString = this.getAtt('PrimaryConnectionString');
        this.attrPrimaryEndpointId = this.getAtt('PrimaryEndpointId');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.dbNodeClass = props.dbNodeClass;
        this.dbType = props.dbType;
        this.dbVersion = props.dbVersion;
        this.payType = props.payType;
        this.autoRenewPeriod = props.autoRenewPeriod;
        this.backupRetentionPolicyOnClusterDeletion = props.backupRetentionPolicyOnClusterDeletion;
        this.cloneDataPoint = props.cloneDataPoint;
        this.clusterNetworkType = props.clusterNetworkType;
        this.creationCategory = props.creationCategory;
        this.creationOption = props.creationOption;
        this.dbClusterDescription = props.dbClusterDescription;
        this.dbClusterParameters = props.dbClusterParameters;
        this.defaultTimeZone = props.defaultTimeZone;
        this.gdnId = props.gdnId;
        this.lowerCaseTableNames = props.lowerCaseTableNames;
        this.maintainTime = props.maintainTime;
        this.period = props.period;
        this.renewalStatus = props.renewalStatus;
        this.resourceGroupId = props.resourceGroupId;
        this.securityGroupIds = props.securityGroupIds;
        this.securityIpList = props.securityIpList;
        this.sourceResourceId = props.sourceResourceId;
        this.tags = props.tags;
        this.tdeStatus = props.tdeStatus;
        this.vpcId = props.vpcId;
        this.vSwitchId = props.vSwitchId;
        this.zoneId = props.zoneId;
    }
    get rosProperties() {
        return {
            dbNodeClass: this.dbNodeClass,
            dbType: this.dbType,
            dbVersion: this.dbVersion,
            payType: this.payType,
            autoRenewPeriod: this.autoRenewPeriod,
            backupRetentionPolicyOnClusterDeletion: this.backupRetentionPolicyOnClusterDeletion,
            cloneDataPoint: this.cloneDataPoint,
            clusterNetworkType: this.clusterNetworkType,
            creationCategory: this.creationCategory,
            creationOption: this.creationOption,
            dbClusterDescription: this.dbClusterDescription,
            dbClusterParameters: this.dbClusterParameters,
            defaultTimeZone: this.defaultTimeZone,
            gdnId: this.gdnId,
            lowerCaseTableNames: this.lowerCaseTableNames,
            maintainTime: this.maintainTime,
            period: this.period,
            renewalStatus: this.renewalStatus,
            resourceGroupId: this.resourceGroupId,
            securityGroupIds: this.securityGroupIds,
            securityIpList: this.securityIpList,
            sourceResourceId: this.sourceResourceId,
            tags: this.tags,
            tdeStatus: this.tdeStatus,
            vpcId: this.vpcId,
            vSwitchId: this.vSwitchId,
            zoneId: this.zoneId,
        };
    }
    renderProperties(props) {
        return rosDBClusterPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosDBCluster = RosDBCluster;
/**
 * The resource type name for this resource class.
 */
RosDBCluster.ROS_RESOURCE_TYPE_NAME = "ALIYUN::POLARDB::DBCluster";
/**
 * Determine whether the given properties match those of a `DBClusterParametersProperty`
 *
 * @param properties - the TypeScript properties of a `DBClusterParametersProperty`
 *
 * @returns the result of the validation.
 */
function RosDBCluster_DBClusterParametersPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('parameters', ros.validateString)(properties.parameters));
    if (properties.effectiveTime && (typeof properties.effectiveTime) !== 'object') {
        errors.collect(ros.propertyValidator('effectiveTime', ros.validateAllowedValues)({
            data: properties.effectiveTime,
            allowedValues: ["Auto", "Immediately", "MaintainTime"],
        }));
    }
    errors.collect(ros.propertyValidator('effectiveTime', ros.validateString)(properties.effectiveTime));
    return errors.wrap('supplied properties not correct for "DBClusterParametersProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::POLARDB::DBCluster.DBClusterParameters` resource
 *
 * @param properties - the TypeScript properties of a `DBClusterParametersProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::POLARDB::DBCluster.DBClusterParameters` resource.
 */
// @ts-ignore TS6133
function rosDBClusterDBClusterParametersPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosDBCluster_DBClusterParametersPropertyValidator(properties).assertSuccess();
    return {
        Parameters: ros.stringToRosTemplate(properties.parameters),
        EffectiveTime: ros.stringToRosTemplate(properties.effectiveTime),
    };
}
/**
 * Determine whether the given properties match those of a `TagsProperty`
 *
 * @param properties - the TypeScript properties of a `TagsProperty`
 *
 * @returns the result of the validation.
 */
function RosDBCluster_TagsPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('value', ros.validateString)(properties.value));
    errors.collect(ros.propertyValidator('key', ros.requiredValidator)(properties.key));
    errors.collect(ros.propertyValidator('key', ros.validateString)(properties.key));
    return errors.wrap('supplied properties not correct for "TagsProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::POLARDB::DBCluster.Tags` resource
 *
 * @param properties - the TypeScript properties of a `TagsProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::POLARDB::DBCluster.Tags` resource.
 */
// @ts-ignore TS6133
function rosDBClusterTagsPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosDBCluster_TagsPropertyValidator(properties).assertSuccess();
    return {
        Value: ros.stringToRosTemplate(properties.value),
        Key: ros.stringToRosTemplate(properties.key),
    };
}
/**
 * Determine whether the given properties match those of a `RosDBClusterAccessWhiteListProps`
 *
 * @param properties - the TypeScript properties of a `RosDBClusterAccessWhiteListProps`
 *
 * @returns the result of the validation.
 */
function RosDBClusterAccessWhiteListPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('securityIps', ros.requiredValidator)(properties.securityIps));
    errors.collect(ros.propertyValidator('securityIps', ros.validateString)(properties.securityIps));
    if (properties.dbClusterIpArrayName && (Array.isArray(properties.dbClusterIpArrayName) || (typeof properties.dbClusterIpArrayName) === 'string')) {
        errors.collect(ros.propertyValidator('dbClusterIpArrayName', ros.validateLength)({
            data: properties.dbClusterIpArrayName.length,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('dbClusterIpArrayName', ros.validateString)(properties.dbClusterIpArrayName));
    errors.collect(ros.propertyValidator('dbClusterId', ros.requiredValidator)(properties.dbClusterId));
    errors.collect(ros.propertyValidator('dbClusterId', ros.validateString)(properties.dbClusterId));
    return errors.wrap('supplied properties not correct for "RosDBClusterAccessWhiteListProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::POLARDB::DBClusterAccessWhiteList` resource
 *
 * @param properties - the TypeScript properties of a `RosDBClusterAccessWhiteListProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::POLARDB::DBClusterAccessWhiteList` resource.
 */
// @ts-ignore TS6133
function rosDBClusterAccessWhiteListPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosDBClusterAccessWhiteListPropsValidator(properties).assertSuccess();
    }
    return {
        DBClusterId: ros.stringToRosTemplate(properties.dbClusterId),
        SecurityIps: ros.stringToRosTemplate(properties.securityIps),
        DBClusterIPArrayName: ros.stringToRosTemplate(properties.dbClusterIpArrayName),
    };
}
/**
 * A ROS template type:  `ALIYUN::POLARDB::DBClusterAccessWhiteList`
 */
class RosDBClusterAccessWhiteList extends ros.RosResource {
    /**
     * Create a new `ALIYUN::POLARDB::DBClusterAccessWhiteList`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosDBClusterAccessWhiteList.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrDbClusterId = this.getAtt('DBClusterId');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.dbClusterId = props.dbClusterId;
        this.securityIps = props.securityIps;
        this.dbClusterIpArrayName = props.dbClusterIpArrayName;
    }
    get rosProperties() {
        return {
            dbClusterId: this.dbClusterId,
            securityIps: this.securityIps,
            dbClusterIpArrayName: this.dbClusterIpArrayName,
        };
    }
    renderProperties(props) {
        return rosDBClusterAccessWhiteListPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosDBClusterAccessWhiteList = RosDBClusterAccessWhiteList;
/**
 * The resource type name for this resource class.
 */
RosDBClusterAccessWhiteList.ROS_RESOURCE_TYPE_NAME = "ALIYUN::POLARDB::DBClusterAccessWhiteList";
/**
 * Determine whether the given properties match those of a `RosDBClusterEndpointProps`
 *
 * @param properties - the TypeScript properties of a `RosDBClusterEndpointProps`
 *
 * @returns the result of the validation.
 */
function RosDBClusterEndpointPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    if (properties.autoAddNewNodes && (typeof properties.autoAddNewNodes) !== 'object') {
        errors.collect(ros.propertyValidator('autoAddNewNodes', ros.validateAllowedValues)({
            data: properties.autoAddNewNodes,
            allowedValues: ["Disable", "Enable"],
        }));
    }
    errors.collect(ros.propertyValidator('autoAddNewNodes', ros.validateString)(properties.autoAddNewNodes));
    errors.collect(ros.propertyValidator('dbClusterId', ros.requiredValidator)(properties.dbClusterId));
    errors.collect(ros.propertyValidator('dbClusterId', ros.validateString)(properties.dbClusterId));
    errors.collect(ros.propertyValidator('endpointType', ros.validateString)(properties.endpointType));
    if (properties.readWriteMode && (typeof properties.readWriteMode) !== 'object') {
        errors.collect(ros.propertyValidator('readWriteMode', ros.validateAllowedValues)({
            data: properties.readWriteMode,
            allowedValues: ["ReadOnly", "ReadWrite"],
        }));
    }
    errors.collect(ros.propertyValidator('readWriteMode', ros.validateString)(properties.readWriteMode));
    if (properties.nodes && (Array.isArray(properties.nodes) || (typeof properties.nodes) === 'string')) {
        errors.collect(ros.propertyValidator('nodes', ros.validateLength)({
            data: properties.nodes.length,
            min: 2,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('nodes', ros.listValidator(ros.validateAny))(properties.nodes));
    errors.collect(ros.propertyValidator('endpointConfig', RosDBClusterEndpoint_EndpointConfigPropertyValidator)(properties.endpointConfig));
    return errors.wrap('supplied properties not correct for "RosDBClusterEndpointProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::POLARDB::DBClusterEndpoint` resource
 *
 * @param properties - the TypeScript properties of a `RosDBClusterEndpointProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::POLARDB::DBClusterEndpoint` resource.
 */
// @ts-ignore TS6133
function rosDBClusterEndpointPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosDBClusterEndpointPropsValidator(properties).assertSuccess();
    }
    return {
        DBClusterId: ros.stringToRosTemplate(properties.dbClusterId),
        AutoAddNewNodes: ros.stringToRosTemplate(properties.autoAddNewNodes),
        EndpointConfig: rosDBClusterEndpointEndpointConfigPropertyToRosTemplate(properties.endpointConfig),
        EndpointType: ros.stringToRosTemplate(properties.endpointType),
        Nodes: ros.listMapper(ros.objectToRosTemplate)(properties.nodes),
        ReadWriteMode: ros.stringToRosTemplate(properties.readWriteMode),
    };
}
/**
 * A ROS template type:  `ALIYUN::POLARDB::DBClusterEndpoint`
 */
class RosDBClusterEndpoint extends ros.RosResource {
    /**
     * Create a new `ALIYUN::POLARDB::DBClusterEndpoint`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosDBClusterEndpoint.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrAddresses = this.getAtt('Addresses');
        this.attrConnectionString = this.getAtt('ConnectionString');
        this.attrDbEndpointId = this.getAtt('DBEndpointId');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.dbClusterId = props.dbClusterId;
        this.autoAddNewNodes = props.autoAddNewNodes;
        this.endpointConfig = props.endpointConfig;
        this.endpointType = props.endpointType;
        this.nodes = props.nodes;
        this.readWriteMode = props.readWriteMode;
    }
    get rosProperties() {
        return {
            dbClusterId: this.dbClusterId,
            autoAddNewNodes: this.autoAddNewNodes,
            endpointConfig: this.endpointConfig,
            endpointType: this.endpointType,
            nodes: this.nodes,
            readWriteMode: this.readWriteMode,
        };
    }
    renderProperties(props) {
        return rosDBClusterEndpointPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosDBClusterEndpoint = RosDBClusterEndpoint;
/**
 * The resource type name for this resource class.
 */
RosDBClusterEndpoint.ROS_RESOURCE_TYPE_NAME = "ALIYUN::POLARDB::DBClusterEndpoint";
/**
 * Determine whether the given properties match those of a `EndpointConfigProperty`
 *
 * @param properties - the TypeScript properties of a `EndpointConfigProperty`
 *
 * @returns the result of the validation.
 */
function RosDBClusterEndpoint_EndpointConfigPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    if (properties.consistLevel && (typeof properties.consistLevel) !== 'object') {
        errors.collect(ros.propertyValidator('consistLevel', ros.validateAllowedValues)({
            data: properties.consistLevel,
            allowedValues: ["0", "1"],
        }));
    }
    errors.collect(ros.propertyValidator('consistLevel', ros.validateString)(properties.consistLevel));
    return errors.wrap('supplied properties not correct for "EndpointConfigProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::POLARDB::DBClusterEndpoint.EndpointConfig` resource
 *
 * @param properties - the TypeScript properties of a `EndpointConfigProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::POLARDB::DBClusterEndpoint.EndpointConfig` resource.
 */
// @ts-ignore TS6133
function rosDBClusterEndpointEndpointConfigPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosDBClusterEndpoint_EndpointConfigPropertyValidator(properties).assertSuccess();
    return {
        ConsistLevel: ros.stringToRosTemplate(properties.consistLevel),
    };
}
/**
 * Determine whether the given properties match those of a `RosDBClusterEndpointAddressProps`
 *
 * @param properties - the TypeScript properties of a `RosDBClusterEndpointAddressProps`
 *
 * @returns the result of the validation.
 */
function RosDBClusterEndpointAddressPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('dbEndpointId', ros.requiredValidator)(properties.dbEndpointId));
    errors.collect(ros.propertyValidator('dbEndpointId', ros.validateString)(properties.dbEndpointId));
    errors.collect(ros.propertyValidator('dbClusterId', ros.requiredValidator)(properties.dbClusterId));
    errors.collect(ros.propertyValidator('dbClusterId', ros.validateString)(properties.dbClusterId));
    if (properties.connectionStringPrefix && (typeof properties.connectionStringPrefix) !== 'object') {
        errors.collect(ros.propertyValidator('connectionStringPrefix', ros.validateAllowedPattern)({
            data: properties.connectionStringPrefix,
            reg: /[a-z][-a-z0-9]{4,28}[a-z0-9]/
        }));
    }
    errors.collect(ros.propertyValidator('connectionStringPrefix', ros.validateString)(properties.connectionStringPrefix));
    if (properties.netType && (typeof properties.netType) !== 'object') {
        errors.collect(ros.propertyValidator('netType', ros.validateAllowedValues)({
            data: properties.netType,
            allowedValues: ["Public", "Private"],
        }));
    }
    errors.collect(ros.propertyValidator('netType', ros.validateString)(properties.netType));
    return errors.wrap('supplied properties not correct for "RosDBClusterEndpointAddressProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::POLARDB::DBClusterEndpointAddress` resource
 *
 * @param properties - the TypeScript properties of a `RosDBClusterEndpointAddressProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::POLARDB::DBClusterEndpointAddress` resource.
 */
// @ts-ignore TS6133
function rosDBClusterEndpointAddressPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosDBClusterEndpointAddressPropsValidator(properties).assertSuccess();
    }
    return {
        DBClusterId: ros.stringToRosTemplate(properties.dbClusterId),
        DBEndpointId: ros.stringToRosTemplate(properties.dbEndpointId),
        ConnectionStringPrefix: ros.stringToRosTemplate(properties.connectionStringPrefix),
        NetType: ros.stringToRosTemplate(properties.netType),
    };
}
/**
 * A ROS template type:  `ALIYUN::POLARDB::DBClusterEndpointAddress`
 */
class RosDBClusterEndpointAddress extends ros.RosResource {
    /**
     * Create a new `ALIYUN::POLARDB::DBClusterEndpointAddress`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosDBClusterEndpointAddress.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrAddress = this.getAtt('Address');
        this.attrConnectionString = this.getAtt('ConnectionString');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.dbClusterId = props.dbClusterId;
        this.dbEndpointId = props.dbEndpointId;
        this.connectionStringPrefix = props.connectionStringPrefix;
        this.netType = props.netType;
    }
    get rosProperties() {
        return {
            dbClusterId: this.dbClusterId,
            dbEndpointId: this.dbEndpointId,
            connectionStringPrefix: this.connectionStringPrefix,
            netType: this.netType,
        };
    }
    renderProperties(props) {
        return rosDBClusterEndpointAddressPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosDBClusterEndpointAddress = RosDBClusterEndpointAddress;
/**
 * The resource type name for this resource class.
 */
RosDBClusterEndpointAddress.ROS_RESOURCE_TYPE_NAME = "ALIYUN::POLARDB::DBClusterEndpointAddress";
/**
 * Determine whether the given properties match those of a `RosDBInstanceProps`
 *
 * @param properties - the TypeScript properties of a `RosDBInstanceProps`
 *
 * @returns the result of the validation.
 */
function RosDBInstancePropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('characterSetName', ros.requiredValidator)(properties.characterSetName));
    errors.collect(ros.propertyValidator('characterSetName', ros.validateString)(properties.characterSetName));
    if (properties.accountPrivilege && (typeof properties.accountPrivilege) !== 'object') {
        errors.collect(ros.propertyValidator('accountPrivilege', ros.validateAllowedValues)({
            data: properties.accountPrivilege,
            allowedValues: ["ReadWrite", "ReadOnly", "DMLOnly", "DDLOnly"],
        }));
    }
    errors.collect(ros.propertyValidator('accountPrivilege', ros.validateString)(properties.accountPrivilege));
    if (properties.dbDescription && (Array.isArray(properties.dbDescription) || (typeof properties.dbDescription) === 'string')) {
        errors.collect(ros.propertyValidator('dbDescription', ros.validateLength)({
            data: properties.dbDescription.length,
            min: 2,
            max: 256,
        }));
    }
    errors.collect(ros.propertyValidator('dbDescription', ros.validateString)(properties.dbDescription));
    errors.collect(ros.propertyValidator('dbClusterId', ros.requiredValidator)(properties.dbClusterId));
    errors.collect(ros.propertyValidator('dbClusterId', ros.validateString)(properties.dbClusterId));
    errors.collect(ros.propertyValidator('dbName', ros.requiredValidator)(properties.dbName));
    if (properties.dbName && (typeof properties.dbName) !== 'object') {
        errors.collect(ros.propertyValidator('dbName', ros.validateAllowedPattern)({
            data: properties.dbName,
            reg: /^[a-z0-9][-_a-z0-9]{0,63}(?<![-_]$)$/
        }));
    }
    errors.collect(ros.propertyValidator('dbName', ros.validateString)(properties.dbName));
    errors.collect(ros.propertyValidator('accountName', ros.validateString)(properties.accountName));
    return errors.wrap('supplied properties not correct for "RosDBInstanceProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::POLARDB::DBInstance` resource
 *
 * @param properties - the TypeScript properties of a `RosDBInstanceProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::POLARDB::DBInstance` resource.
 */
// @ts-ignore TS6133
function rosDBInstancePropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosDBInstancePropsValidator(properties).assertSuccess();
    }
    return {
        CharacterSetName: ros.stringToRosTemplate(properties.characterSetName),
        DBClusterId: ros.stringToRosTemplate(properties.dbClusterId),
        DBName: ros.stringToRosTemplate(properties.dbName),
        AccountName: ros.stringToRosTemplate(properties.accountName),
        AccountPrivilege: ros.stringToRosTemplate(properties.accountPrivilege),
        DBDescription: ros.stringToRosTemplate(properties.dbDescription),
    };
}
/**
 * A ROS template type:  `ALIYUN::POLARDB::DBInstance`
 */
class RosDBInstance extends ros.RosResource {
    /**
     * Create a new `ALIYUN::POLARDB::DBInstance`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosDBInstance.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.characterSetName = props.characterSetName;
        this.dbClusterId = props.dbClusterId;
        this.dbName = props.dbName;
        this.accountName = props.accountName;
        this.accountPrivilege = props.accountPrivilege;
        this.dbDescription = props.dbDescription;
    }
    get rosProperties() {
        return {
            characterSetName: this.characterSetName,
            dbClusterId: this.dbClusterId,
            dbName: this.dbName,
            accountName: this.accountName,
            accountPrivilege: this.accountPrivilege,
            dbDescription: this.dbDescription,
        };
    }
    renderProperties(props) {
        return rosDBInstancePropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosDBInstance = RosDBInstance;
/**
 * The resource type name for this resource class.
 */
RosDBInstance.ROS_RESOURCE_TYPE_NAME = "ALIYUN::POLARDB::DBInstance";
/**
 * Determine whether the given properties match those of a `RosDBNodesProps`
 *
 * @param properties - the TypeScript properties of a `RosDBNodesProps`
 *
 * @returns the result of the validation.
 */
function RosDBNodesPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('amount', ros.requiredValidator)(properties.amount));
    if (properties.amount && (typeof properties.amount) !== 'object') {
        errors.collect(ros.propertyValidator('amount', ros.validateRange)({
            data: properties.amount,
            min: 1,
            max: 16,
        }));
    }
    errors.collect(ros.propertyValidator('amount', ros.validateNumber)(properties.amount));
    errors.collect(ros.propertyValidator('dbClusterId', ros.requiredValidator)(properties.dbClusterId));
    errors.collect(ros.propertyValidator('dbClusterId', ros.validateString)(properties.dbClusterId));
    return errors.wrap('supplied properties not correct for "RosDBNodesProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::POLARDB::DBNodes` resource
 *
 * @param properties - the TypeScript properties of a `RosDBNodesProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::POLARDB::DBNodes` resource.
 */
// @ts-ignore TS6133
function rosDBNodesPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosDBNodesPropsValidator(properties).assertSuccess();
    }
    return {
        Amount: ros.numberToRosTemplate(properties.amount),
        DBClusterId: ros.stringToRosTemplate(properties.dbClusterId),
    };
}
/**
 * A ROS template type:  `ALIYUN::POLARDB::DBNodes`
 */
class RosDBNodes extends ros.RosResource {
    /**
     * Create a new `ALIYUN::POLARDB::DBNodes`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosDBNodes.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrDbNodeIds = this.getAtt('DBNodeIds');
        this.attrOrderIds = this.getAtt('OrderIds');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.amount = props.amount;
        this.dbClusterId = props.dbClusterId;
    }
    get rosProperties() {
        return {
            amount: this.amount,
            dbClusterId: this.dbClusterId,
        };
    }
    renderProperties(props) {
        return rosDBNodesPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosDBNodes = RosDBNodes;
/**
 * The resource type name for this resource class.
 */
RosDBNodes.ROS_RESOURCE_TYPE_NAME = "ALIYUN::POLARDB::DBNodes";
//# sourceMappingURL=data:application/json;base64,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