"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3ToSqs = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const defaults = require("@aws-solutions-constructs/core");
const s3n = require("@aws-cdk/aws-s3-notifications");
const core_1 = require("@aws-cdk/core");
const core_2 = require("@aws-solutions-constructs/core");
/**
 * @summary The S3ToSqs class.
 */
class S3ToSqs extends core_1.Construct {
    /**
     * @summary Constructs a new instance of the S3ToSqs class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {S3ToSqsProps} props - user provided props for the construct.
     * @since 0.8.0
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        let bucket;
        let enableEncryptionParam = props.enableEncryptionWithCustomerManagedKey;
        if (props.enableEncryptionWithCustomerManagedKey === undefined ||
            props.enableEncryptionWithCustomerManagedKey === true) {
            enableEncryptionParam = true;
        }
        // Setup the S3 bucket
        if (!props.existingBucketObj) {
            [this.s3Bucket, this.s3LoggingBucket] = defaults.buildS3Bucket(this, {
                bucketProps: props.bucketProps,
                loggingBucketProps: props.loggingBucketProps,
                logS3AccessLogs: props.logS3AccessLogs
            });
            bucket = this.s3Bucket;
        }
        else {
            bucket = props.existingBucketObj;
        }
        this.s3BucketInterface = bucket;
        // Setup the dead letter queue, if applicable
        this.deadLetterQueue = defaults.buildDeadLetterQueue(this, {
            existingQueueObj: props.existingQueueObj,
            deployDeadLetterQueue: props.deployDeadLetterQueue,
            deadLetterQueueProps: props.deadLetterQueueProps,
            maxReceiveCount: props.maxReceiveCount
        });
        // Setup the queue
        [this.sqsQueue, this.encryptionKey] = defaults.buildQueue(this, 'queue', {
            existingQueueObj: props.existingQueueObj,
            queueProps: props.queueProps,
            deadLetterQueue: this.deadLetterQueue,
            enableEncryptionWithCustomerManagedKey: enableEncryptionParam,
            encryptionKey: props.encryptionKey
        });
        // Setup the S3 bucket event types
        let s3EventTypes;
        if (!props.s3EventTypes) {
            s3EventTypes = defaults.defaultS3NotificationEventTypes;
        }
        else {
            s3EventTypes = props.s3EventTypes;
        }
        // Setup the S3 bucket event filters
        let s3Eventfilters = [];
        if (props.s3EventFilters) {
            s3Eventfilters = props.s3EventFilters;
        }
        // Setup the S3 bucket event notifications
        s3EventTypes.forEach(type => bucket.addEventNotification(type, new s3n.SqsDestination(this.sqsQueue), ...s3Eventfilters));
        core_2.addCfnNagS3BucketNotificationRulesToSuppress(core_1.Stack.of(this), 'BucketNotificationsHandler050a0587b7544547bf325f094a3db834');
    }
}
exports.S3ToSqs = S3ToSqs;
_a = JSII_RTTI_SYMBOL_1;
S3ToSqs[_a] = { fqn: "@aws-solutions-constructs/aws-s3-sqs.S3ToSqs", version: "1.160.0" };
//# sourceMappingURL=data:application/json;base64,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