import numpy


class Multiplication:
    """
    Instantiate a multiplication operation.
    Numbers will be multiplied by the given multiplier.

    :param multiplier: The multiplier.
    :type multiplier: int
    """

    def __init__(self, multiplier):
        self.multiplier = multiplier

    def multiply(self, number):
        """
        Multiply a given number by the multiplier.

        :param number: The number to multiply.
        :type number: int

        :return: The result of the multiplication.
        :rtype: int
        """

        return number * self.multiplier

    def square(self):
        """
        Multiply the multiplier to itself.

        :return: The result of the multiplication.
        :rtype: int
        """

        return self.multiplier * self.multiplier

# # Instantiate a Multiplication object
# multiplication = Multiplication(2)
#
# # Call the multiply method
# print(multiplication.multiply(5))
