# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['inquirer', 'inquirer.render', 'inquirer.render.console']

package_data = \
{'': ['*']}

install_requires = \
['blessed>=1.19.0', 'python-editor>=1.0.4', 'readchar>=3.0.6']

setup_kwargs = {
    'name': 'inquirer',
    'version': '2.10.1',
    'description': 'Collection of common interactive command line user interfaces, based on Inquirer.js',
    'long_description': '====================  =================================================================================\nTests                 |Tests| |Codecov|\n--------------------  ---------------------------------------------------------------------------------\nDownloads             |pip dm| |pip dw| |pip dd|\n--------------------  ---------------------------------------------------------------------------------\nAbout                 |License| |pip wheel| |pip pyversions| |pip implem|\n--------------------  ---------------------------------------------------------------------------------\nStatus                |version| |status| |Documentation|\n====================  =================================================================================\n\nCollection of common interactive command line user interfaces, based on `Inquirer.js`_.\n\nGoal and Philosophy\n===================\n\nBorn as a `Inquirer.js`_ clone, it shares part of the goals and philosophy.\n\nSo, **Inquirer** should ease the process of asking end user **questions**, **parsing**, **validating** answers, managing **hierarchical prompts** and providing **error feedback**.\n\nYou can `download the python-inquirer code from GitHub`_ or `download the wheel from Pypi`_.\n\nPlatforms support\n------------------\n\nPython-inquirer supports mainly UNIX-based platforms (eq. Mac OS, Linux, etc.). Windows has experimental support, please let us know if there are any problems!\n\nInstallation\n============\n\n.. code:: console\n\n    pip install inquirer\n\n\nDocumentation\n=============\n\nDocumentation has been moved to `magmax.org/python-inquirer <https://magmax.org/python-inquirer/>`_.\n\nBut here you have a couple of usage examples:\n\n\nText\n----\n\n.. code:: python\n\n  import re\n\n  import inquirer\n  questions = [\n    inquirer.Text(\'name\', message="What\'s your name"),\n    inquirer.Text(\'surname\', message="What\'s your surname"),\n    inquirer.Text(\'phone\', message="What\'s your phone number",\n                  validate=lambda _, x: re.match(\'\\+?\\d[\\d ]+\\d\', x),\n                  )\n  ]\n  answers = inquirer.prompt(questions)\n\n|inquirer text|\n\n\nEditor\n------\n\nLike a Text question, but used for larger answers. It opens external text editor which is used to collect the answer.\n\nThe environment variables $VISUAL and $EDITOR, can be used to specify which editor should be used. If not present\ninquirer fallbacks to `vim -> emacs -> nano` in this order based on availability in the system.\n\nExternal editor handling is done using great library `python-editor <https://github.com/fmoo/python-editor>`_.\n\nExample:\n\n.. code:: python\n\n  import inquirer\n  questions = [\n    inquirer.Editor(\'long_text\', message="Provide long text")\n  ]\n  answers = inquirer.prompt(questions)\n\n\nList\n----\n\nShows a list of choices, and allows the selection of one of them.\n\nExample:\n\n.. code:: python\n\n\n  import inquirer\n  questions = [\n    inquirer.List(\'size\',\n                  message="What size do you need?",\n                  choices=[\'Jumbo\', \'Large\', \'Standard\', \'Medium\', \'Small\', \'Micro\'],\n              ),\n  ]\n  answers = inquirer.prompt(questions)\n\nList questions can take one extra argument :code:`carousel=False`. If set to true, the answers will rotate (back to first when pressing down on last choice, and down to last choice when pressing up on first choice)\n\n|inquirer list|\n\n\nCheckbox\n--------\n\nShows a list of choices, with multiple selection.\n\nExample:\n\n.. code:: python\n\n\n  import inquirer\n  questions = [\n    inquirer.Checkbox(\'interests\',\n                      message="What are you interested in?",\n                      choices=[\'Computers\', \'Books\', \'Science\', \'Nature\', \'Fantasy\', \'History\'],\n                      ),\n  ]\n  answers = inquirer.prompt(questions)\n\nCheckbox questions can take one extra argument :code:`carousel=False`. If set to true, the answers will rotate (back to first when pressing down on last choice, and down to last choice when pressing up on first choice)\n\n|inquirer checkbox|\n\nPath\n----\n\nLike Text question, but with builtin validations for working with paths.\n\nExample:\n\n.. code:: python\n\n\n  import inquirer\n  questions = [\n    inquirer.Path(\'log_file\',\n                   message="Where logs should be located?",\n                   path_type=inquirer.Path.DIRECTORY,\n                  ),\n  ]\n  answers = inquirer.prompt(questions)\n\n\nContributing\n============\n\nContributions are very welcome.\nTo learn more, see the `Contributor Guide`_.\n\nLicense\n=======\n\nCopyright (c) 2014-2021 Miguel Ángel García (`@magmax_en`_), based on `Inquirer.js`_, by Simon Boudrias (`@vaxilart`_)\n\nLicensed under `the MIT license`_.\n\n\n.. |Tests| image:: https://github.com/magmax/python-inquirer/workflows/Tests/badge.svg\n  :target: https://github.com/magmax/python-inquirer/actions?workflow=Tests\n  :alt: Tests\n.. |Codecov| image:: https://codecov.io/gh/magmax/python-inquirer/branch/master/graph/badge.svg\n  :target: https://app.codecov.io/gh/magmax/python-inquirer\n  :alt: Codecov\n.. |Documentation| image:: https://github.com/magmax/python-inquirer/workflows/Documentation/badge.svg\n   :target: https://magmax.org/python-inquirer/\n   :alt: Read the documentation at https://magmax.org/python-inquirer/\n.. |pip version| image:: https://img.shields.io/pypi/v/inquirer.svg\n    :target: https://pypi.python.org/pypi/inquirer\n    :alt: Latest PyPI version\n.. |pip dm| image:: https://img.shields.io/pypi/dm/inquirer.svg\n    :target: https://pypi.python.org/pypi/inquirer\n    :alt: Last month downloads from pypi\n.. |pip dw| image:: https://img.shields.io/pypi/dw/inquirer.svg\n    :target: https://pypi.python.org/pypi/inquirer\n    :alt: Last week downloads from pypi\n.. |pip dd| image:: https://img.shields.io/pypi/dd/inquirer.svg\n    :target: https://pypi.python.org/pypi/inquirer\n    :alt: Yesterday downloads from pypi\n.. |License| image:: https://img.shields.io/pypi/l/inquirer.svg\n    :target: https://pypi.python.org/pypi/inquirer\n    :alt: License\n.. |pip wheel| image:: https://img.shields.io/pypi/wheel/inquirer.svg\n    :target: https://pypi.python.org/pypi/inquirer\n    :alt: Wheel\n.. |pip pyversions| image::  \thttps://img.shields.io/pypi/pyversions/inquirer.svg\n    :target: https://pypi.python.org/pypi/inquirer\n    :alt: Python versions\n.. |pip implem| image::  \thttps://img.shields.io/pypi/implementation/inquirer.svg\n    :target: https://pypi.python.org/pypi/inquirer\n    :alt: Python interpreters\n.. |status| image::\thttps://img.shields.io/pypi/status/inquirer.svg\n    :target: https://pypi.python.org/pypi/inquirer\n    :alt: Status\n.. |version| image:: https://img.shields.io/pypi/v/inquirer.svg\n    :target: https://pypi.python.org/pypi/inquirer\n    :alt: Status\n.. |inquirer text| image:: http://magmax.org/python-inquirer/_images/inquirer_text.png\n  :alt: Example of Text Question\n.. |inquirer list| image:: http://magmax.org/python-inquirer/_images/inquirer_list.png\n  :alt: Example of List Question\n.. |inquirer checkbox| image:: http://magmax.org/python-inquirer/_images/inquirer_checkbox.png\n  :alt: Example of Checkbox Question\n.. _Inquirer.js: https://github.com/SBoudrias/Inquirer.js\n.. _examples/: https://github.com/magmax/python-inquirer/tree/master/examples\n.. _`download the python-inquirer code from GitHub`: https://github.com/magmax/python-inquirer\n.. _`download the wheel from Pypi`: https://pypi.python.org/pypi/inquirer\n.. _@vaxilart: https://twitter.com/vaxilart\n.. _@magmax_en: https://twitter.com/magmax_en\n.. _the MIT license: https://opensource.org/licenses/MIT\n.. github-only\n.. _Contributor Guide: CONTRIBUTING.rst\n',
    'author': 'Miguel Ángel García',
    'author_email': 'miguelangel.garcia@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/magmax/python-inquirer',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7',
}


setup(**setup_kwargs)
