from dataclasses import dataclass
from typing import Optional

import torch
from transformers.modeling_outputs import TokenClassifierOutput


@dataclass
class SpanMarkerOutput(TokenClassifierOutput):
    """
    Class for outputs of SpanMarker models.

    Args:
        loss (`torch.FloatTensor` of shape `(1,)`, *optional*, returned when `labels` is provided):
            Classification loss.
        logits (`torch.FloatTensor` of shape `(batch_size, sequence_length, config.num_labels)`):
            Classification scores (before SoftMax).
        hidden_states (`tuple(torch.FloatTensor)`, *optional*, returned when `config.output_hidden_states=True`):
            Tuple of `torch.FloatTensor` (one for the output of the embeddings, if the model has an embedding layer, +
            one for the output of each layer) of shape `(batch_size, sequence_length, hidden_size)`.

            Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.
        attentions (`tuple(torch.FloatTensor)`, *optional*, returned when `config.output_attentions=True`):
            Tuple of `torch.FloatTensor` (one for each layer) of shape `(batch_size, num_heads, sequence_length,
            sequence_length)`.

            Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
            heads.
        num_words (`torch.Tensor`, *optional*):
            A vector with length `batch_size` that tracks how many words were in the input of each sample in the batch.
            Required for evaluation purposes.
    """

    num_words: Optional[torch.Tensor] = None
