# coding: utf-8

"""
    XTRF Home Portal API

    XTRF Home Portal API enables you to perform operations on Projects, Quotes, Customers, Vendors etc. as a XTRF Home Portal user. <br>The documentation is generated from OpenAPI specification 3.0 available <a href=\"/home-api/openapi.json\">here</a> <br>   The API client/consumer code may be easily generated in 60+ programming languages using an open source code generator available at the time of writing this documentation at <a href='https://editor.swagger.io/'>https://editor.swagger.io/</a> Thank you for using XTRF Application Programming interface (XTRF API). By using the API you agree to the terms below. If you disagree with any of these terms, XTRF does not grant you a license to use the XTRF API. XTRF reserves the right to update and change these terms from time to time without a prior notice of API users. You can always find the most recent version of these terms here:   # noqa: E501

    OpenAPI spec version: 2.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six
from xtrf_python_api.models.customer_contact_emails_dto import CustomerContactEmailsDTO  # noqa: F401,E501


class ContactDTO(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'phones': 'list[str]',
        'sms': 'str',
        'fax': 'str',
        'emails': 'CustomerContactEmailsDTO',
        'websites': 'list[str]'
    }

    attribute_map = {
        'phones': 'phones',
        'sms': 'sms',
        'fax': 'fax',
        'emails': 'emails',
        'websites': 'websites'
    }

    def __init__(self, phones=None, sms=None, fax=None, emails=None, websites=None):  # noqa: E501
        """ContactDTO - a model defined in Swagger"""  # noqa: E501
        self._phones = None
        self._sms = None
        self._fax = None
        self._emails = None
        self._websites = None
        self.discriminator = None
        if phones is not None:
            self.phones = phones
        if sms is not None:
            self.sms = sms
        if fax is not None:
            self.fax = fax
        if emails is not None:
            self.emails = emails
        if websites is not None:
            self.websites = websites

    @property
    def phones(self):
        """Gets the phones of this ContactDTO.  # noqa: E501

        phones' numbers  # noqa: E501

        :return: The phones of this ContactDTO.  # noqa: E501
        :rtype: list[str]
        """
        return self._phones

    @phones.setter
    def phones(self, phones):
        """Sets the phones of this ContactDTO.

        phones' numbers  # noqa: E501

        :param phones: The phones of this ContactDTO.  # noqa: E501
        :type: list[str]
        """

        self._phones = phones

    @property
    def sms(self):
        """Gets the sms of this ContactDTO.  # noqa: E501

        mobile phone for which SMS notifications will be sent (if configured)  # noqa: E501

        :return: The sms of this ContactDTO.  # noqa: E501
        :rtype: str
        """
        return self._sms

    @sms.setter
    def sms(self, sms):
        """Sets the sms of this ContactDTO.

        mobile phone for which SMS notifications will be sent (if configured)  # noqa: E501

        :param sms: The sms of this ContactDTO.  # noqa: E501
        :type: str
        """

        self._sms = sms

    @property
    def fax(self):
        """Gets the fax of this ContactDTO.  # noqa: E501

        fax number  # noqa: E501

        :return: The fax of this ContactDTO.  # noqa: E501
        :rtype: str
        """
        return self._fax

    @fax.setter
    def fax(self, fax):
        """Sets the fax of this ContactDTO.

        fax number  # noqa: E501

        :param fax: The fax of this ContactDTO.  # noqa: E501
        :type: str
        """

        self._fax = fax

    @property
    def emails(self):
        """Gets the emails of this ContactDTO.  # noqa: E501


        :return: The emails of this ContactDTO.  # noqa: E501
        :rtype: CustomerContactEmailsDTO
        """
        return self._emails

    @emails.setter
    def emails(self, emails):
        """Sets the emails of this ContactDTO.


        :param emails: The emails of this ContactDTO.  # noqa: E501
        :type: CustomerContactEmailsDTO
        """

        self._emails = emails

    @property
    def websites(self):
        """Gets the websites of this ContactDTO.  # noqa: E501

        websites  # noqa: E501

        :return: The websites of this ContactDTO.  # noqa: E501
        :rtype: list[str]
        """
        return self._websites

    @websites.setter
    def websites(self, websites):
        """Sets the websites of this ContactDTO.

        websites  # noqa: E501

        :param websites: The websites of this ContactDTO.  # noqa: E501
        :type: list[str]
        """

        self._websites = websites

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ContactDTO, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ContactDTO):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
