# coding: utf-8

"""
    XTRF Home Portal API

    XTRF Home Portal API enables you to perform operations on Projects, Quotes, Customers, Vendors etc. as a XTRF Home Portal user. <br>The documentation is generated from OpenAPI specification 3.0 available <a href=\"/home-api/openapi.json\">here</a> <br>   The API client/consumer code may be easily generated in 60+ programming languages using an open source code generator available at the time of writing this documentation at <a href='https://editor.swagger.io/'>https://editor.swagger.io/</a> Thank you for using XTRF Application Programming interface (XTRF API). By using the API you agree to the terms below. If you disagree with any of these terms, XTRF does not grant you a license to use the XTRF API. XTRF reserves the right to update and change these terms from time to time without a prior notice of API users. You can always find the most recent version of these terms here:   # noqa: E501

    OpenAPI spec version: 2.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from xtrf_python_api.api_client import ApiClient


class DictionariesApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_active(self, **kwargs):  # noqa: E501
        """Returns active dictionary entities for all types.  # noqa: E501

        Returns active dictionary entities for all types.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_active(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ManyValuesPerTypeDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_active_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_active_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_active_with_http_info(self, **kwargs):  # noqa: E501
        """Returns active dictionary entities for all types.  # noqa: E501

        Returns active dictionary entities for all types.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_active_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ManyValuesPerTypeDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_active" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/dictionaries/active', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ManyValuesPerTypeDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_active_by_type(self, type, **kwargs):  # noqa: E501
        """Returns active values from a given dictionary.  # noqa: E501

        Returns active values from a given dictionary.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_active_by_type(type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str type: dictionary type (required)
        :param str name_equals: exact name of entity
        :return: DictionaryEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_active_by_type_with_http_info(type, **kwargs)  # noqa: E501
        else:
            (data) = self.get_active_by_type_with_http_info(type, **kwargs)  # noqa: E501
            return data

    def get_active_by_type_with_http_info(self, type, **kwargs):  # noqa: E501
        """Returns active values from a given dictionary.  # noqa: E501

        Returns active values from a given dictionary.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_active_by_type_with_http_info(type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str type: dictionary type (required)
        :param str name_equals: exact name of entity
        :return: DictionaryEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['type', 'name_equals']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_active_by_type" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'type' is set
        if ('type' not in params or
                params['type'] is None):
            raise ValueError("Missing the required parameter `type` when calling `get_active_by_type`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'type' in params:
            path_params['type'] = params['type']  # noqa: E501

        query_params = []
        if 'name_equals' in params:
            query_params.append(('nameEquals', params['name_equals']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/dictionaries/{type}/active', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DictionaryEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all1(self, **kwargs):  # noqa: E501
        """Returns dictionary entities for all types. Both active and not active ones.  # noqa: E501

        <div>   <p>     XTRF holds many user-defined dictionaries (ie. countries).     Each dictionary contains a set of values (ie. Poland or Germany).     A default value may be defined for a dictionary.   </p>   <p>     Dictionary values are identified using internal identifier which is constant and unique among other values from the same dictionary.     Please note that name used in dictionary values is presented in the locale of the current identity.     The same dictionary value can have different names, ie. \"Poland\" for one user, \"Polska\" for another one.   <p>   <p>     Possible dictionary types:     <ul>       <li>category</li>       <li>country</li>       <li>currency</li>       <li>industry</li>       <li>language</li>       <li>leadSource</li>       <li>personDepartment</li>       <li>personPosition</li>       <li>province</li>       <li>specialization</li>     </ul>   </p> </div>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all1(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ManyValuesPerTypeDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all1_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_all1_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_all1_with_http_info(self, **kwargs):  # noqa: E501
        """Returns dictionary entities for all types. Both active and not active ones.  # noqa: E501

        <div>   <p>     XTRF holds many user-defined dictionaries (ie. countries).     Each dictionary contains a set of values (ie. Poland or Germany).     A default value may be defined for a dictionary.   </p>   <p>     Dictionary values are identified using internal identifier which is constant and unique among other values from the same dictionary.     Please note that name used in dictionary values is presented in the locale of the current identity.     The same dictionary value can have different names, ie. \"Poland\" for one user, \"Polska\" for another one.   <p>   <p>     Possible dictionary types:     <ul>       <li>category</li>       <li>country</li>       <li>currency</li>       <li>industry</li>       <li>language</li>       <li>leadSource</li>       <li>personDepartment</li>       <li>personPosition</li>       <li>province</li>       <li>specialization</li>     </ul>   </p> </div>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all1_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ManyValuesPerTypeDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all1" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/dictionaries/all', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ManyValuesPerTypeDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all3(self, **kwargs):  # noqa: E501
        """Returns services list  # noqa: E501

        Returns workflows list. Both active and not active ones.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all3(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name_equals: exact name of entity
        :return: ServiceDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all3_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_all3_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_all3_with_http_info(self, **kwargs):  # noqa: E501
        """Returns services list  # noqa: E501

        Returns workflows list. Both active and not active ones.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all3_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name_equals: exact name of entity
        :return: ServiceDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name_equals']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all3" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name_equals' in params:
            query_params.append(('nameEquals', params['name_equals']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/services/all', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ServiceDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_active(self, **kwargs):  # noqa: E501
        """Returns active services list  # noqa: E501

        Returns active workflows list  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_active(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name_equals: exact name of entity
        :return: ServiceDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_active_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_all_active_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_all_active_with_http_info(self, **kwargs):  # noqa: E501
        """Returns active services list  # noqa: E501

        Returns active workflows list  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_active_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name_equals: exact name of entity
        :return: ServiceDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name_equals']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_active" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name_equals' in params:
            query_params.append(('nameEquals', params['name_equals']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/services/active', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ServiceDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_by_type(self, type, **kwargs):  # noqa: E501
        """Returns all values (both active and not active) from a given dictionary.  # noqa: E501

        Returns all values (both active and not active) from a given dictionary.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_by_type(type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str type: dictionary type (required)
        :param str name_equals: exact name of entity
        :return: DictionaryEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_by_type_with_http_info(type, **kwargs)  # noqa: E501
        else:
            (data) = self.get_all_by_type_with_http_info(type, **kwargs)  # noqa: E501
            return data

    def get_all_by_type_with_http_info(self, type, **kwargs):  # noqa: E501
        """Returns all values (both active and not active) from a given dictionary.  # noqa: E501

        Returns all values (both active and not active) from a given dictionary.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_by_type_with_http_info(type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str type: dictionary type (required)
        :param str name_equals: exact name of entity
        :return: DictionaryEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['type', 'name_equals']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_by_type" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'type' is set
        if ('type' not in params or
                params['type'] is None):
            raise ValueError("Missing the required parameter `type` when calling `get_all_by_type`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'type' in params:
            path_params['type'] = params['type']  # noqa: E501

        query_params = []
        if 'name_equals' in params:
            query_params.append(('nameEquals', params['name_equals']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/dictionaries/{type}/all', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DictionaryEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_by_type_and_id(self, type, id, **kwargs):  # noqa: E501
        """Returns specific value from a given dictionary.  # noqa: E501

        Returns specific value from a given dictionary.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_by_type_and_id(type, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str type: dictionary type (required)
        :param int id: dictionary value identifier (required)
        :return: DictionaryEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_by_type_and_id_with_http_info(type, id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_by_type_and_id_with_http_info(type, id, **kwargs)  # noqa: E501
            return data

    def get_by_type_and_id_with_http_info(self, type, id, **kwargs):  # noqa: E501
        """Returns specific value from a given dictionary.  # noqa: E501

        Returns specific value from a given dictionary.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_by_type_and_id_with_http_info(type, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str type: dictionary type (required)
        :param int id: dictionary value identifier (required)
        :return: DictionaryEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['type', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_by_type_and_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'type' is set
        if ('type' not in params or
                params['type'] is None):
            raise ValueError("Missing the required parameter `type` when calling `get_by_type_and_id`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_by_type_and_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'type' in params:
            path_params['type'] = params['type']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/dictionaries/{type}/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DictionaryEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
