# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class Twin(Model):
    """The state information for a device or module. This is implicitly created
    and deleted when the corresponding device/ module identity is created or
    deleted in the IoT Hub.

    :param device_id: The unique identifier of the device in the identity
     registry of the IoT Hub. It is a case-sensitive string (up to 128 char
     long) of ASCII 7-bit alphanumeric chars, and the following special
     characters {'-', ':', '.', '+', '%', '_', '#', '*', '?', '!', '(', ')',
     ',', '=', '@', ';', '$', '''}.
    :type device_id: str
    :param module_id: The unique identifier of the module in the identity
     registry of the IoT Hub. It is a case-sensitive string (up to 128 char
     long) of ASCII 7-bit alphanumeric chars, and the following special
     characters {'-', ':', '.', '+', '%', '_', '#', '*', '?', '!', '(', ')',
     ',', '=', '@', ';', '$', '''}.
    :type module_id: str
    :param tags: The collection of key-value pairs read and written by the
     solution back end. They are not visible to device apps. They keys are
     UTF-8 encoded, case-sensitive and up-to 1KB in length. Allowed characters
     exclude UNICODE control characters (segments C0 and C1), '.', '$' and
     space. The values are JSON objects, up-to 4KB in length.
    :type tags: dict[str, object]
    :param properties: The desired and reported properties of the twin.
    :type properties: ~protocol.models.TwinProperties
    :param etag: The string representing a ETag for the device twin, as per
     RFC7232.
    :type etag: str
    :param version: The version for the device twin including tags and desired
     properties
    :type version: long
    :param device_etag: The string representing a ETag for the device, as per
     RFC7232.
    :type device_etag: str
    :param status: The enabled status of the device. If disabled, the device
     cannot connect to the service. Possible values include: 'enabled',
     'disabled'
    :type status: str or ~protocol.models.enum
    :param status_reason: The reason for the current status of the device, if
     any.
    :type status_reason: str
    :param status_update_time: The date and time when the status of the device
     was last updated.
    :type status_update_time: datetime
    :param connection_state: The connection state of the device. Possible
     values include: 'Disconnected', 'Connected'
    :type connection_state: str or ~protocol.models.enum
    :param last_activity_time: The date and time when the device last
     connected or received or sent a message. The date and time is sepecified
     in ISO8601 datetime format in UTC, for example, 2015-01-28T16:24:48.789Z.
     This value is not updated if the device uses the HTTP/1 protocol to
     perform messaging operations.
    :type last_activity_time: datetime
    :param cloud_to_device_message_count: The number of cloud-to-device
     messages sent.
    :type cloud_to_device_message_count: int
    :param authentication_type: The authentication type used by the device.
     Possible values include: 'sas', 'selfSigned', 'certificateAuthority',
     'none'
    :type authentication_type: str or ~protocol.models.enum
    :param x509_thumbprint: The X509 thumbprint of the device.
    :type x509_thumbprint: ~protocol.models.X509Thumbprint
    :param capabilities:
    :type capabilities: ~protocol.models.DeviceCapabilities
    :param device_scope: The scope of the device.
    :type device_scope: str
    :param parent_scopes: The scopes of the upper level edge devices if
     applicable. Only available for edge devices.
    :type parent_scopes: list[str]
    """

    _attribute_map = {
        "device_id": {"key": "deviceId", "type": "str"},
        "module_id": {"key": "moduleId", "type": "str"},
        "tags": {"key": "tags", "type": "{object}"},
        "properties": {"key": "properties", "type": "TwinProperties"},
        "etag": {"key": "etag", "type": "str"},
        "version": {"key": "version", "type": "long"},
        "device_etag": {"key": "deviceEtag", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "status_reason": {"key": "statusReason", "type": "str"},
        "status_update_time": {"key": "statusUpdateTime", "type": "iso-8601"},
        "connection_state": {"key": "connectionState", "type": "str"},
        "last_activity_time": {"key": "lastActivityTime", "type": "iso-8601"},
        "cloud_to_device_message_count": {"key": "cloudToDeviceMessageCount", "type": "int"},
        "authentication_type": {"key": "authenticationType", "type": "str"},
        "x509_thumbprint": {"key": "x509Thumbprint", "type": "X509Thumbprint"},
        "capabilities": {"key": "capabilities", "type": "DeviceCapabilities"},
        "device_scope": {"key": "deviceScope", "type": "str"},
        "parent_scopes": {"key": "parentScopes", "type": "[str]"},
    }

    def __init__(self, **kwargs):
        super(Twin, self).__init__(**kwargs)
        self.device_id = kwargs.get("device_id", None)
        self.module_id = kwargs.get("module_id", None)
        self.tags = kwargs.get("tags", None)
        self.properties = kwargs.get("properties", None)
        self.etag = kwargs.get("etag", None)
        self.version = kwargs.get("version", None)
        self.device_etag = kwargs.get("device_etag", None)
        self.status = kwargs.get("status", None)
        self.status_reason = kwargs.get("status_reason", None)
        self.status_update_time = kwargs.get("status_update_time", None)
        self.connection_state = kwargs.get("connection_state", None)
        self.last_activity_time = kwargs.get("last_activity_time", None)
        self.cloud_to_device_message_count = kwargs.get("cloud_to_device_message_count", None)
        self.authentication_type = kwargs.get("authentication_type", None)
        self.x509_thumbprint = kwargs.get("x509_thumbprint", None)
        self.capabilities = kwargs.get("capabilities", None)
        self.device_scope = kwargs.get("device_scope", None)
        self.parent_scopes = kwargs.get("parent_scopes", None)
