import click


class NotRequiredIf(click.Option):
    """A class enabling click to specify arguments of which we require one or the other.
    https://stackoverflow.com/questions/11154946/require-either-of-two-arguments-using-argparse
    """

    def __init__(self, *args, **kwargs):
        self.not_required_if = kwargs.pop("not_required_if")
        assert self.not_required_if, "'not_required_if' parameter required"
        helper_text = f" NOTE: This argument is mutually exclusive with {self.not_required_if}"
        kwargs["help"] = (kwargs.get("help", "") + helper_text).strip()
        super(NotRequiredIf, self).__init__(*args, **kwargs)

    def handle_parse_result(self, ctx, opts, args):
        we_are_present = self.name in opts
        other_present = self.not_required_if in opts
        if other_present:
            if we_are_present:
                raise click.UsageError(
                    "Illegal usage: `%s` is mutually exclusive with `%s`" % (self.name, self.not_required_if)
                )
            else:
                self.prompt = None

        return super(NotRequiredIf, self).handle_parse_result(ctx, opts, args)
