# Generated by Django 2.1 on 2019-08-09 16:03

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import ripple.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('auth', '0009_alter_user_last_name_max_length'),
    ]

    operations = [
        migrations.CreateModel(
            name='User',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('password', models.CharField(max_length=128, verbose_name='password')),
                ('last_login', models.DateTimeField(blank=True, null=True, verbose_name='last login')),
                ('is_superuser', models.BooleanField(default=False, help_text='Designates that this user has all permissions without explicitly assigning them.', verbose_name='superuser status')),
                ('first_name', models.CharField(blank=True, max_length=30, verbose_name='first name')),
                ('last_name', models.CharField(blank=True, max_length=30, verbose_name='last name')),
                ('email', models.EmailField(max_length=254, unique=True, verbose_name='email address')),
                ('profile_pic', models.ImageField(blank=True, null=True, upload_to='')),
                ('is_staff', models.BooleanField(default=False, help_text='Designates whether the user can log into this admin site.', verbose_name='staff status')),
                ('is_active', models.BooleanField(default=True, help_text='Designates whether this user should be treated as active. Unselect this instead of deleting accounts.', verbose_name='active')),
                ('date_joined', models.DateTimeField(default=django.utils.timezone.now, verbose_name='date joined')),
                ('is_email_verified', models.BooleanField(default=False, help_text='Designates whether email has been verified ', verbose_name='email verified')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('groups', models.ManyToManyField(blank=True, help_text='The groups this user belongs to. A user will get all permissions granted to each of their groups.', related_name='user_set', related_query_name='user', to='auth.Group', verbose_name='groups')),
                ('user_permissions', models.ManyToManyField(blank=True, help_text='Specific permissions for this user.', related_name='user_set', related_query_name='user', to='auth.Permission', verbose_name='user permissions')),
            ],
            options={
                'verbose_name': 'user',
                'verbose_name_plural': 'users',
            },
            managers=[
                ('objects', ripple.models.UserManager()),
            ],
        ),
        migrations.CreateModel(
            name='Article',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('assetid', models.CharField(db_index=True, max_length=200)),
                ('module', models.CharField(blank=True, db_index=True, default='', max_length=200)),
                ('version', models.DateTimeField(auto_now=True)),
                ('published', models.BooleanField(default=False)),
                ('layout', models.CharField(blank=True, db_index=True, default='', max_length=200)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ArticleCollection',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('assetid', models.CharField(db_index=True, max_length=200)),
                ('module', models.CharField(blank=True, db_index=True, default='', max_length=200)),
                ('version', models.DateTimeField(auto_now=True)),
                ('published', models.BooleanField(default=False)),
                ('layout', models.CharField(blank=True, db_index=True, default='', max_length=200)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ArticleCollectionOrder',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('order', models.IntegerField()),
                ('article_collection', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='contained_articles', to='ripple.ArticleCollection')),
                ('container_article_collection', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='container_articles', to='ripple.ArticleCollection')),
            ],
        ),
        migrations.CreateModel(
            name='ArticleOrder',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('order', models.IntegerField()),
                ('article', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ripple.Article')),
                ('article_collection', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ripple.ArticleCollection')),
            ],
        ),
        migrations.CreateModel(
            name='ImageAsset',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('assetid', models.CharField(db_index=True, max_length=200)),
                ('module', models.CharField(blank=True, db_index=True, default='', max_length=200)),
                ('version', models.DateTimeField(auto_now=True)),
                ('published', models.BooleanField(default=False)),
                ('target', models.CharField(db_index=True, default='', max_length=200)),
                ('image', models.ImageField(upload_to='')),
                ('owner', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='RichTextAsset',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('assetid', models.CharField(db_index=True, max_length=200)),
                ('module', models.CharField(blank=True, db_index=True, default='', max_length=200)),
                ('version', models.DateTimeField(auto_now=True)),
                ('published', models.BooleanField(default=False)),
                ('text', models.TextField(blank=True, default='')),
                ('owner', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='TextAsset',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('assetid', models.CharField(db_index=True, max_length=200)),
                ('module', models.CharField(blank=True, db_index=True, default='', max_length=200)),
                ('version', models.DateTimeField(auto_now=True)),
                ('published', models.BooleanField(default=False)),
                ('text', models.CharField(blank=True, default='', max_length=1000)),
                ('owner', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='articlecollection',
            name='article_collections',
            field=models.ManyToManyField(through='ripple.ArticleCollectionOrder', to='ripple.ArticleCollection'),
        ),
        migrations.AddField(
            model_name='articlecollection',
            name='articles',
            field=models.ManyToManyField(through='ripple.ArticleOrder', to='ripple.Article'),
        ),
        migrations.AddField(
            model_name='articlecollection',
            name='image',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ripple.ImageAsset'),
        ),
        migrations.AddField(
            model_name='articlecollection',
            name='owner',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='articlecollection',
            name='text',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ripple.RichTextAsset'),
        ),
        migrations.AddField(
            model_name='articlecollection',
            name='title',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ripple.TextAsset'),
        ),
        migrations.AddField(
            model_name='article',
            name='image',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ripple.ImageAsset'),
        ),
        migrations.AddField(
            model_name='article',
            name='owner',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='article',
            name='text',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ripple.RichTextAsset'),
        ),
        migrations.AddField(
            model_name='article',
            name='title',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ripple.TextAsset'),
        ),
    ]
