# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['ytscraper', 'ytscraper.commands', 'ytscraper.helper']

package_data = \
{'': ['*']}

install_requires = \
['appdirs>=1.4.3,<2.0.0',
 'click>=7.1.1,<8.0.0',
 'google-api-python-client>=1.8.0,<2.0.0',
 'ratelimit>=2.2.1,<3.0.0',
 'toml>=0.10.0,<0.11.0']

entry_points = \
{'console_scripts': ['yt-scraper = ytscraper.app:run']}

setup_kwargs = {
    'name': 'yt-scraper',
    'version': '0.4.4',
    'description': 'Command line utility querying the YouTube API v3.',
    'long_description': '# YouTube Scraper\n> A simple command utility to extract information from the YouTube API v3 for scientific purposes.\n\n[![made-with-python](https://img.shields.io/badge/Made%20with-Python-1f425f.svg)](https://www.python.org/)\n[![GitHub license](https://img.shields.io/github/license/rattletat/yt-scraper)](https://github.com/rattletat/yt-scraper/blob/master/UNLICENSE)\n[![version](https://img.shields.io/pypi/v/yt-scraper)](https://pypi.org/project/yt-scraper/)\n\n## About\n\nThis Python based command line utility enables the easy extraction of information from the YouTube API (Version 3). Currently, it only supports a small subset of functions of the API interface and focuses on extracting related videos from a given starting point.\n\n\n## Installation\n\nInstall **yt-scraper** by using [pip][pip-url]:\n```sh\nsudo -H pip install yt-scraper\n```\n\nUpdate by adding the `--upgrade` flag:\n\n```sh\nsudo -H pip install --upgrade yt-scraper\n```\n\n## Usage\n### Commands\nCurrently, there is only one command supported by **yt-scraper**: *search*\n\n#### search\nThe search command starts a video search from a given starting point, such as a search term or a video itself.\n\nFor example the following command will return the first video when one searches for `cat`.\n\n```sh\n$ yt-scraper search term \'cat\'\n```\n> VideoNode(videoId=\'0A2R27kCeD4\', depth=0, rank=0, relatedVideos=(\'XewbmK0kmpI\',))\n\nOne can also provide a video id or a video url as a starting point, which is more interesting when used with the `--depth` option:\n\n```sh\n$ yt-scraper search id \'0A2R27kCeD4\' --depth 2\n```\n> VideoNode(videoId=\'0A2R27kCeD4\', depth=0, rank=0, relatedVideos=(\'XewbmK0kmpI\',))  \n> VideoNode(videoId=\'XewbmK0kmpI\', depth=1, rank=0, relatedVideos=(\'hJpfROXlaPc\',))  \n> VideoNode(videoId=\'hJpfROXlaPc\', depth=2, rank=0, relatedVideos=(\'dElQqMWhDgA\',))  \n\nAdditionally, one can specify the number of videos that should be returned on each level by using the `--number` option. For example the following command returns two related videos from a given video (specified by it\'s url) and then from each sibling only one related video:\n```sh\n$ yt-scraper search url \'https://www.youtube.com/watch?v=0A2R27kCeD4\' --depth 1 --number 2 -number 1\n```\n> VideoNode(videoId=\'0A2R27kCeD4\', depth=0, rank=0, relatedVideos=(\'XewbmK0kmpI\', \'U5KLMeFK_UY\'))  \n> VideoNode(videoId=\'XewbmK0kmpI\', depth=1, rank=0, relatedVideos=(\'hJpfROXlaPc\',))  \n> VideoNode(videoId=\'U5KLMeFK_UY\', depth=1, rank=1, relatedVideos=(\'nFrb-C6I6Ps\',))  \n\nFor the sake of brevity, you can shorten `--number` to `-n` and `--depth` to `-d`.\n\n##### Options\n\n| Search options    | Default    | Description                                                                             |\n|-------------------|------------|-----------------------------------------------------------------------------------------|\n| `-n`, `--number`  | 1          | Number of the videos fetched per level. Can be specified multiple times for each level. |\n| `-d`, `--depth`   | 0          | Number of recursion steps to perform.                                                   |\n| `-k`, `--api-key` | *Required* | The API key that should be used to query the YouTube API v3.                            |\n\n### Global Options\nGlobal options are specified before the command. For example, to get more output during the program execution, specify `-v` right after `yt-scraper`:\n\n```sh\n$ yt-scraper -v search term \'cat\'\n```\n\nAll global options:\n| Global options        | Default           | Description                                                                                                       |\n|-----------------------|-------------------|-------------------------------------------------------------------------------------------------------------------|\n| `-c`, `--config-path` | *System-specific* | Specifies a configuration file. For details, see [configuration](#Configuration). |\n| `-v`, `--verbose`     | False             | Shows more output during program execution.                                                                       |\n\n\n## Configuration\nInstead of repeatedly passing the same options to yt-scraper, one can specify these options in a `config.toml` file. These values will be used in all future queries as long as they are not get overwritten by actual command line options.\n\nFor example, to always use the API key `ABCDEFGH` and a search depth of 3, where on each level one video less is returned, just create following configuration file:\n\n**config.toml**\n```toml\napi_key = "ABCDEFGH"\nnumber = [ 4, 3, 2, 1 ]\ndepth = 3\n```\nA example toml is included: [config.toml.example][config-url]\n\nThen put this file in your standard configuration folder. Typically this folder can be found at the following system-specific locations:\n\n- Mac OS X: `~/Library/Application Support/YouTube Scraper`\n- Unix: `~/.config/youtube-scraper`\n- Windows: `C:\\Users\\<user>\\AppData\\Roaming\\YouTube Scraper`\n\nIf the folder does not exist, you may need to create it.\n\n\n## Release History\n\n* 0.2.6 \n    - Added [UNLICENSE](license-url) to project.\n* 0.3.0\n    - Uploaded to [PyPI][pypi-url]\n* 0.4.0\n    - Command *search* released\n\n\n## Roadmap\n\nEvery of these features is going to be a minor patch:\n\n- [ ] Add node video data attributes, such as title and description.\n- [ ] Add possibility to specify more than one API key to switch seamlessly.\n- [ ] Add possibility to query more than 50 videos on one level.\n- [ ] Add youtube-dl integration for downloading subtitles.\n- [ ] Add a testing suite.\n- [ ] Add export functionality to SQLlite or Pandas.\n \n\n## Contributing\nIf you found a bug or have a suggestion, \nplease don\'t hesitate to [file an issue][git-new-issue-url].\n\nContributions in any form are welcomed. \nI will accept pull-requests if they extent **yt-scraper**\'s functionality.\n\nTo set up the development environment, \nplease install [Poetry][poetry-url] and run `poetry install` inside the project.\nA test suite will be added soon.\n\nIn general, the contribution process is somehow like this:\n\n1. Fork it (`$ git clone https://github.com/rattletat/yt-scraper`)\n2. Create your feature branch (`$ git checkout -b feature/fooBar`)\n3. Commit your changes (`$ git commit -am \'Add some fooBar\'`)\n4. Push to the branch (`$ git push origin feature/fooBar`)\n5. Create a new Pull Request\n\n\n## Author\n**Michael Brauweiler**\n\n- GitHub: [@rattletat][me-twitter-url]\n- Email: [rattletat@posteo.me](mailto:rattletat@posteo.me)\n\n\n## License\nThis plugin is free and unemcumbered software released into the public domain. \n\nFor more information, see the included [UNLICENSE][license-url] file.\n\n<!-- Markdown link & img dfn\'s -->\n[pip-url]: https://pip.pypa.io/en/stable/\n[config-url]: data/config.toml.example\n[git-new-issue-url]: https://github.com/rattletat/yt-scraper/issues/new\n[poetry-url]: https://github.com/python-poetry/poetry\n[pypi-url]: https://pypi.org/project/yt-scraper/\n[me-github-url]: https://github.com/rattletat\n[me-twitter-url]: https://twitter.com/m_brauweiler\n[license-url]: UNLICENSE\n',
    'author': 'Michael Brauweiler',
    'author_email': 'rattletat@posteo.me',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
