"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnRecord = exports.CfnRecordPropsType = exports.toJson_CfnRecordProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnRecordProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnRecordProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Type': obj.type,
        'Meta': obj.meta,
        'Name': obj.name,
        'Ttl': obj.ttl,
        'ZoneId': obj.zoneId,
        'Content': obj.content,
        'Proxied': obj.proxied,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnRecordProps = toJson_CfnRecordProps;
/* eslint-enable max-len, quote-props */
/**
 * Record type
 *
 * @schema CfnRecordPropsType
 */
var CfnRecordPropsType;
(function (CfnRecordPropsType) {
    /** A */
    CfnRecordPropsType["A"] = "A";
    /** AAAA */
    CfnRecordPropsType["AAAA"] = "AAAA";
    /** CERT */
    CfnRecordPropsType["CERT"] = "CERT";
    /** CNAME */
    CfnRecordPropsType["CNAME"] = "CNAME";
    /** DNSKEY */
    CfnRecordPropsType["DNSKEY"] = "DNSKEY";
    /** DS */
    CfnRecordPropsType["DS"] = "DS";
    /** HTTPS */
    CfnRecordPropsType["HTTPS"] = "HTTPS";
    /** LOC */
    CfnRecordPropsType["LOC"] = "LOC";
    /** MX */
    CfnRecordPropsType["MX"] = "MX";
    /** NAPTR */
    CfnRecordPropsType["NAPTR"] = "NAPTR";
    /** NS */
    CfnRecordPropsType["NS"] = "NS";
    /** SMIMEA */
    CfnRecordPropsType["SMIMEA"] = "SMIMEA";
    /** SRV */
    CfnRecordPropsType["SRV"] = "SRV";
    /** SSHFP */
    CfnRecordPropsType["SSHFP"] = "SSHFP";
    /** SVCB */
    CfnRecordPropsType["SVCB"] = "SVCB";
    /** TLSA */
    CfnRecordPropsType["TLSA"] = "TLSA";
    /** TXT */
    CfnRecordPropsType["TXT"] = "TXT";
    /** URI */
    CfnRecordPropsType["URI"] = "URI";
})(CfnRecordPropsType = exports.CfnRecordPropsType || (exports.CfnRecordPropsType = {}));
/**
 * A CloudFormation `Cloudflare::Dns::Record`
 *
 * @cloudformationResource Cloudflare::Dns::Record
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-cloudflare-resource-providers.git
 */
class CfnRecord extends cdk.CfnResource {
    /**
     * Create a new `Cloudflare::Dns::Record`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnRecord.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnRecordProps(props) });
        this.props = props;
        this.attrId = cdk.Token.asString(this.getAtt('Id'));
        this.attrLocked = this.getAtt('Locked');
        this.attrModifiedOn = cdk.Token.asString(this.getAtt('ModifiedOn'));
        this.attrCreatedOn = cdk.Token.asString(this.getAtt('CreatedOn'));
        this.attrProxiable = this.getAtt('Proxiable');
        this.attrZoneName = cdk.Token.asString(this.getAtt('ZoneName'));
    }
}
exports.CfnRecord = CfnRecord;
_a = JSII_RTTI_SYMBOL_1;
CfnRecord[_a] = { fqn: "@cdk-cloudformation/cloudflare-dns-record.CfnRecord", version: "1.0.0-alpha.7" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnRecord.CFN_RESOURCE_TYPE_NAME = "Cloudflare::Dns::Record";
//# sourceMappingURL=data:application/json;base64,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