# AUTOGENERATED! DO NOT EDIT! File to edit: notebooks/pyramide_ages.ipynb (unless otherwise specified).

__all__ = [
    "config",
    "df",
    "df_all",
    "ref",
    "perimeter",
    "data",
    "pyramide",
    "file",
    "output",
    "output",
]

# Cell
# import time

import pandas as pd
from leximpact_socio_fisca_simu_etat.config import Configuration

from .aggregate import Aggregate, AggregateManager, Data, Perimeter, Reference

# from ruamel.yaml import YAML


config = Configuration(project_folder="leximpact-aggregates")

# Cell

df = pd.read_excel(
    "https://www.insee.fr/fr/statistiques/fichier/2381472/demo-pop-pyram.xlsx",
    skiprows=2,
    nrows=101,
)
df.columns
df.columns = ["an_naissance", "age", "nb_femmes", "nb_hommes", "all"]
df_all = df[["age", "nb_femmes", "nb_hommes", "all"]]

# Cell
ref = Reference(
    title="Estimations de population (INSEE)",
    href="https://www.insee.fr/fr/metadonnees/source/serie/s1169",
)
perimeter = Perimeter(entity="person", period="year", geographic="France entière")
data = Data(reference=[ref], date="2022", values=df_all.to_dict(orient="records"))
pyramide = Aggregate(
    description="Pyramide des âges",
    short_name="Pyramide des âges",
    ux_template="Parmi les français, {value} **sont âgés** de {label}.",
    openfisca_variable="age",
    source_variable="Ensemble",
    unit="person",
    perimeter=perimeter,
    data=data,
)

# Cell
file = AggregateManager(pyramide)
# Nom du jeu de données / Nom du fournisseur / Millésime / Nom de la colonne
output = config.get("AGREGATS") + "/INSEE/2022/pyramide_ages.yaml"
output
file.save_to_yaml(output)
output = config.get("AGREGATS") + "/INSEE/2022/age.json"
output
file.save_to_json(output)
