# AUTOGENERATED! DO NOT EDIT! File to edit: notebooks/aggregate.ipynb (unless otherwise specified).

__all__ = [
    "default_extraction_date",
    "yaml",
    "Perimeter",
    "Reference",
    "Data",
    "LabelKey",
    "Aggregate",
    "AggregateManager",
]

# Cell
import pathlib

# export
import time
from dataclasses import dataclass, field
from typing import Dict, List, Union

import ruamel.yaml
from dataclasses_json import dataclass_json

# from leximpact_socio_fisca_simu_etat.logger import logger

default_extraction_date = time.strftime("%Y-%m-%d")
yaml = ruamel.yaml.YAML()

# Cell


@dataclass_json
@dataclass
class Perimeter:
    entity: str = ""
    period: str = ""
    geographic: str = ""


@dataclass_json
@dataclass
class Reference:
    title: str
    href: str


@dataclass_json
@dataclass
class Data:
    reference: List[Reference] = field(default_factory=list)
    date: str = ""
    values: Union[List, Dict] = field(default_factory=Dict)


@dataclass_json
@dataclass
class LabelKey:
    key: str
    label: str


@dataclass_json
@dataclass
class Aggregate:
    description: str = ""
    short_name: str = ""
    ux_template: str = ""
    openfisca_variable: str = ""
    source_variable: str = ""
    unit: str = ""
    extraction_date: str = default_extraction_date
    perimeter: Perimeter = None
    label_of_keys: Dict[str, str] = None
    data: List[Data] = field(default_factory=list)


class AggregateManager:
    def __init__(self, aggregate: Aggregate):
        self.aggregate = aggregate
        yaml = ruamel.yaml.YAML()
        yaml.register_class(Perimeter)
        yaml.register_class(Reference)
        yaml.register_class(Data)
        yaml.register_class(Aggregate)
        self.__yaml = yaml

    def save_to_json(self, filename):
        path = pathlib.Path(filename)
        path.parent.mkdir(parents=True, exist_ok=True)
        # logger.debug(f"Writing to {path}")
        with open(path, mode="w") as file:
            file.write(self.aggregate.to_json(indent=2))

    def save_to_yaml(self, filename):
        path = pathlib.Path(filename)
        path.parent.mkdir(parents=True, exist_ok=True)
        # logger.debug(f"Writing to {path}")
        with open(path, mode="w") as file:
            ruamel.yaml.YAML().dump(self.aggregate, file)

    def load_from_yaml(self, filename):
        with open(filename) as file:
            self.aggregate = ruamel.yaml.YAML().load(file)
