from smart_module.module_system.header_common import *
from smart_module.module_system.header_presentations import *
from smart_module.module_system.header_mission_templates import *
from smart_module.module_system.ID_meshes import *
from smart_module.module_system.header_operations import *
from smart_module.module_system.header_triggers import *
from smart_module.module_system.module_constants import *
import string

####################################################################################################################
#  Each presentation record contains the following fields:
#  1) Presentation id: used for referencing presentations in other files. The prefix prsnt_ is automatically added before each presentation id.
#  2) Presentation flags. See header_presentations.py for a list of available flags
#  3) Presentation background mesh: See module_meshes.py for a list of available background meshes
#  4) Triggers: Simple triggers that are associated with the presentation
####################################################################################################################

presentations = [
  ("game_credits",prsntf_read_only,mesh_load_window,[
      (ti_on_presentation_load,
       [(assign, "$g_presentation_credits_obj_1", -1),
        (assign, "$g_presentation_credits_obj_2", -1),
        (assign, "$g_presentation_credits_obj_3", -1),
        (assign, "$g_presentation_credits_obj_4", -1),
        (assign, "$g_presentation_credits_obj_5", -1),
        (assign, "$g_presentation_credits_obj_6", -1),
        (assign, "$g_presentation_credits_obj_7", -1),
        (assign, "$g_presentation_credits_obj_8", -1),
        (assign, "$g_presentation_credits_obj_9", -1),
        (assign, "$g_presentation_credits_obj_10", -1),
        (assign, "$g_presentation_credits_obj_11", -1),
        (assign, "$g_presentation_credits_obj_12", -1),
        (assign, "$g_presentation_credits_obj_1_alpha", 0),
        (assign, "$g_presentation_credits_obj_2_alpha", 0),
        (assign, "$g_presentation_credits_obj_3_alpha", 0),
        (assign, "$g_presentation_credits_obj_4_alpha", 0),
        (assign, "$g_presentation_credits_obj_5_alpha", 0),
        (assign, "$g_presentation_credits_obj_6_alpha", 0),
        (assign, "$g_presentation_credits_obj_7_alpha", 0),
        (assign, "$g_presentation_credits_obj_8_alpha", 0),
        (assign, "$g_presentation_credits_obj_9_alpha", 0),
        ]),
      (ti_on_presentation_run,
       [
        (store_trigger_param_1, ":cur_time"),
        (set_fixed_point_multiplier, 1000),
        (presentation_set_duration, 1000000),
        (try_begin),
          (this_or_next|key_clicked, key_space),
          (this_or_next|key_clicked, key_enter),
          (this_or_next|key_clicked, key_escape),
          (this_or_next|key_clicked, key_back_space),
          (this_or_next|key_clicked, key_left_mouse_button),
          (this_or_next|key_clicked, key_right_mouse_button),
          (this_or_next|key_clicked, key_xbox_ltrigger),
		  (key_clicked, key_xbox_rtrigger),
          (presentation_set_duration, 0),
        (try_end),
        (try_begin),
          (lt, "$g_presentation_credits_obj_1", 0),
          (str_store_string, s1, "str_credits_1"),
          (create_text_overlay, "$g_presentation_credits_obj_1", s1, tf_center_justify|tf_double_space|tf_vertical_align_center),
          (overlay_set_color, "$g_presentation_credits_obj_1", 0),
          (overlay_set_alpha, "$g_presentation_credits_obj_1", 0),
          (position_set_x, pos1, 1500),
          (position_set_y, pos1, 1500),
          (overlay_set_size, "$g_presentation_credits_obj_1", pos1),
          (position_set_x, pos1, 500),
          (position_set_y, pos1, 375),
          (overlay_set_position, "$g_presentation_credits_obj_1", pos1),
          (overlay_animate_to_alpha, "$g_presentation_credits_obj_1", 1000, 0xFF),
        (else_try),
          (gt, ":cur_time", 2000),
          (eq, "$g_presentation_credits_obj_1_alpha", 0),
          (assign, "$g_presentation_credits_obj_1_alpha", 1),
          (overlay_animate_to_alpha, "$g_presentation_credits_obj_1", 1000, 0x00),
        (else_try),
          (gt, ":cur_time", 3500),
          (lt, "$g_presentation_credits_obj_2", 0),
          (str_store_string, s1, "str_credits_2"),
          (create_text_overlay, "$g_presentation_credits_obj_2", s1, tf_center_justify|tf_double_space|tf_vertical_align_center),
          (overlay_set_color, "$g_presentation_credits_obj_2", 0),
          (overlay_set_alpha, "$g_presentation_credits_obj_2", 0),
          (position_set_x, pos1, 1750),
          (position_set_y, pos1, 1750),
          (overlay_set_size, "$g_presentation_credits_obj_2", pos1),
          (position_set_x, pos1, 500),
          (position_set_y, pos1, 375),
          (overlay_set_position, "$g_presentation_credits_obj_2", pos1),
          (overlay_animate_to_alpha, "$g_presentation_credits_obj_2", 1000, 0xFF),
        (else_try),
          (gt, ":cur_time", 5500),
          (eq, "$g_presentation_credits_obj_2_alpha", 0),
          (assign, "$g_presentation_credits_obj_2_alpha", 1),
          (overlay_animate_to_alpha, "$g_presentation_credits_obj_2", 1000, 0x00),
        (else_try),
          (gt, ":cur_time", 7000),
          (lt, "$g_presentation_credits_obj_3", 0),
          (str_store_string, s1, "str_credits_3"),
          (create_text_overlay, "$g_presentation_credits_obj_3", s1, tf_center_justify|tf_double_space|tf_vertical_align_center),
          (overlay_set_color, "$g_presentation_credits_obj_3", 0),
          (overlay_set_alpha, "$g_presentation_credits_obj_3", 0),
          (position_set_x, pos1, 1750),
          (position_set_y, pos1, 1750),
          (overlay_set_size, "$g_presentation_credits_obj_3", pos1),
          (position_set_x, pos1, 500),
          (position_set_y, pos1, 375),
          (overlay_set_position, "$g_presentation_credits_obj_3", pos1),
          (overlay_animate_to_alpha, "$g_presentation_credits_obj_3", 1000, 0xFF),
        (else_try),
          (gt, ":cur_time", 9000),
          (eq, "$g_presentation_credits_obj_3_alpha", 0),
          (assign, "$g_presentation_credits_obj_3_alpha", 1),
          (overlay_animate_to_alpha, "$g_presentation_credits_obj_3", 1000, 0),
        (else_try),
          (gt, ":cur_time", 10500),
          (lt, "$g_presentation_credits_obj_4", 0),
          (str_store_string, s1, "str_credits_4"),
          (create_text_overlay, "$g_presentation_credits_obj_4", s1, tf_center_justify|tf_double_space|tf_vertical_align_center),
          (overlay_set_color, "$g_presentation_credits_obj_4", 0),
          (overlay_set_alpha, "$g_presentation_credits_obj_4", 0),
          (position_set_x, pos1, 1750),
          (position_set_y, pos1, 1750),
          (overlay_set_size, "$g_presentation_credits_obj_4", pos1),
          (position_set_x, pos1, 500),
          (position_set_y, pos1, 375),
          (overlay_set_position, "$g_presentation_credits_obj_4", pos1),
          (overlay_animate_to_alpha, "$g_presentation_credits_obj_4", 1000, 0xFF),
        (else_try),
          (gt, ":cur_time", 12500),
          (eq, "$g_presentation_credits_obj_4_alpha", 0),
          (assign, "$g_presentation_credits_obj_4_alpha", 1),
          (overlay_animate_to_alpha, "$g_presentation_credits_obj_4", 1000, 0),
        (else_try),
          (gt, ":cur_time", 14000),
          (lt, "$g_presentation_credits_obj_5", 0),
          (str_store_string, s1, "str_credits_5"),
          (create_text_overlay, "$g_presentation_credits_obj_5", s1, tf_center_justify|tf_double_space|tf_vertical_align_center),
          (overlay_set_color, "$g_presentation_credits_obj_5", 0),
          (overlay_set_alpha, "$g_presentation_credits_obj_5", 0),
          (position_set_x, pos1, 1750),
          (position_set_y, pos1, 1750),
          (overlay_set_size, "$g_presentation_credits_obj_5", pos1),
          (position_set_x, pos1, 500),
          (position_set_y, pos1, 375),
          (overlay_set_position, "$g_presentation_credits_obj_5", pos1),
          (overlay_animate_to_alpha, "$g_presentation_credits_obj_5", 1000, 0xFF),
        (else_try),
          (gt, ":cur_time", 16000),
          (eq, "$g_presentation_credits_obj_5_alpha", 0),
          (assign, "$g_presentation_credits_obj_5_alpha", 1),
          (overlay_animate_to_alpha, "$g_presentation_credits_obj_5", 1000, 0),
        (else_try),
          (gt, ":cur_time", 17500),
          (lt, "$g_presentation_credits_obj_6", 0),
          (str_store_string, s1, "str_credits_6"),
          (create_text_overlay, "$g_presentation_credits_obj_6", s1, tf_center_justify|tf_double_space|tf_vertical_align_center),
          (overlay_set_color, "$g_presentation_credits_obj_6", 0),
          (overlay_set_alpha, "$g_presentation_credits_obj_6", 0),
          (position_set_x, pos1, 1750),
          (position_set_y, pos1, 1750),
          (overlay_set_size, "$g_presentation_credits_obj_6", pos1),
          (position_set_x, pos1, 500),
          (position_set_y, pos1, 375),
          (overlay_set_position, "$g_presentation_credits_obj_6", pos1),
          (overlay_animate_to_alpha, "$g_presentation_credits_obj_6", 1000, 0xFF),
        (else_try),
          (gt, ":cur_time", 19500),
          (eq, "$g_presentation_credits_obj_6_alpha", 0),
          (assign, "$g_presentation_credits_obj_6_alpha", 1),
          (overlay_animate_to_alpha, "$g_presentation_credits_obj_6", 1000, 0),
        (else_try),
          (gt, ":cur_time", 21000),
          (lt, "$g_presentation_credits_obj_7", 0),
          (str_store_string, s1, "str_credits_7"),
          (create_text_overlay, "$g_presentation_credits_obj_7", s1, tf_center_justify|tf_double_space|tf_vertical_align_center),
          (overlay_set_color, "$g_presentation_credits_obj_7", 0),
          (overlay_set_alpha, "$g_presentation_credits_obj_7", 0),
          (position_set_x, pos1, 1750),
          (position_set_y, pos1, 1750),
          (overlay_set_size, "$g_presentation_credits_obj_7", pos1),
          (position_set_x, pos1, 500),
          (position_set_y, pos1, 375),
          (overlay_set_position, "$g_presentation_credits_obj_7", pos1),
          (overlay_animate_to_alpha, "$g_presentation_credits_obj_7", 1000, 0xFF),
        (else_try),
          (gt, ":cur_time", 23000),
          (eq, "$g_presentation_credits_obj_7_alpha", 0),
          (assign, "$g_presentation_credits_obj_7_alpha", 1),
          (overlay_animate_to_alpha, "$g_presentation_credits_obj_7", 1000, 0),
        (else_try),
          (gt, ":cur_time", 24500),
          (lt, "$g_presentation_credits_obj_8", 0),
          (str_store_string, s1, "str_credits_8"),
          (create_text_overlay, "$g_presentation_credits_obj_8", s1, tf_center_justify|tf_double_space|tf_vertical_align_center),
          (overlay_set_color, "$g_presentation_credits_obj_8", 0),
          (overlay_set_alpha, "$g_presentation_credits_obj_8", 0),
          (position_set_x, pos1, 1750),
          (position_set_y, pos1, 1750),
          (overlay_set_size, "$g_presentation_credits_obj_8", pos1),
          (position_set_x, pos1, 500),
          (position_set_y, pos1, 375),
          (overlay_set_position, "$g_presentation_credits_obj_8", pos1),
          (overlay_animate_to_alpha, "$g_presentation_credits_obj_8", 1000, 0xFF),
        (else_try),
          (gt, ":cur_time", 26500),
          (eq, "$g_presentation_credits_obj_8_alpha", 0),
          (assign, "$g_presentation_credits_obj_8_alpha", 1),
          (overlay_animate_to_alpha, "$g_presentation_credits_obj_8", 1000, 0),
        (else_try),
          (gt, ":cur_time", 28000),
          (lt, "$g_presentation_credits_obj_9", 0),
          (str_store_string, s1, "str_credits_10"),
          (create_text_overlay, "$g_presentation_credits_obj_9", s1, tf_center_justify|tf_double_space|tf_vertical_align_center),
          (overlay_set_color, "$g_presentation_credits_obj_9", 0),
          (overlay_set_alpha, "$g_presentation_credits_obj_9", 0),
          (position_set_x, pos1, 750),
          (position_set_y, pos1, 750),
          (overlay_set_size, "$g_presentation_credits_obj_9", pos1),
          (position_set_x, pos1, 250),
          (position_set_y, pos1, 485),
          (overlay_set_position, "$g_presentation_credits_obj_9", pos1),
          (overlay_animate_to_alpha, "$g_presentation_credits_obj_9", 1000, 0xFF),

          (str_store_string, s1, "str_credits_11"),
          (create_text_overlay, "$g_presentation_credits_obj_10", s1, tf_center_justify|tf_double_space|tf_vertical_align_center),
          (overlay_set_color, "$g_presentation_credits_obj_10", 0),
          (overlay_set_alpha, "$g_presentation_credits_obj_10", 0),
          (position_set_x, pos1, 750),
          (position_set_y, pos1, 750),
          (overlay_set_size, "$g_presentation_credits_obj_10", pos1),
          (position_set_x, pos1, 750),
          (position_set_y, pos1, 470),
          (overlay_set_position, "$g_presentation_credits_obj_10", pos1),
          (overlay_animate_to_alpha, "$g_presentation_credits_obj_10", 1000, 0xFF),

          (str_store_string, s1, "str_credits_12"),
          (create_text_overlay, "$g_presentation_credits_obj_11", s1, tf_center_justify|tf_double_space|tf_vertical_align_center),
          (overlay_set_color, "$g_presentation_credits_obj_11", 0),
          (overlay_set_alpha, "$g_presentation_credits_obj_11", 0),
          (position_set_x, pos1, 750),
          (position_set_y, pos1, 750),
          (overlay_set_size, "$g_presentation_credits_obj_11", pos1),
          (position_set_x, pos1, 500),
          (position_set_y, pos1, 105),
          (overlay_set_position, "$g_presentation_credits_obj_11", pos1),
          (overlay_animate_to_alpha, "$g_presentation_credits_obj_11", 1000, 0xFF),
        (else_try),
          (gt, ":cur_time", 34000),
          (eq, "$g_presentation_credits_obj_9_alpha", 0),
          (assign, "$g_presentation_credits_obj_9_alpha", 1),
          (overlay_animate_to_alpha, "$g_presentation_credits_obj_9", 1000, 0),
          (overlay_animate_to_alpha, "$g_presentation_credits_obj_10", 1000, 0),
          (overlay_animate_to_alpha, "$g_presentation_credits_obj_11", 1000, 0),
        (else_try),
          (gt, ":cur_time", 35500),
          (lt, "$g_presentation_credits_obj_12", 0),
          (str_store_string, s1, "str_credits_9"),
          (create_text_overlay, "$g_presentation_credits_obj_12", s1, tf_center_justify|tf_double_space),
          (overlay_set_color, "$g_presentation_credits_obj_12", 0),
          (overlay_set_alpha, "$g_presentation_credits_obj_12", 0xFF),
          (position_set_x, pos1, 1000),
          (position_set_y, pos1, 1000),
          (overlay_set_size, "$g_presentation_credits_obj_12", pos1),
          (position_set_x, pos1, 500),
          (position_set_y, pos1, -4800),
          (overlay_set_position, "$g_presentation_credits_obj_12", pos1),
          (position_set_x, pos1, 500),
          (position_set_y, pos1, 760),
          (overlay_animate_to_position, "$g_presentation_credits_obj_12", 70000, pos1),
        (else_try),
          (gt, ":cur_time", 105500),
          (presentation_set_duration, 0),
        (try_end),
        ]),
      ]),

  ("game_profile_banner_selection", 0, mesh_load_window, [
    (ti_on_presentation_load, [
      (set_fixed_point_multiplier, 1000),
      (str_store_string, s1, "str_profile_banner_selection_text"),
      (create_text_overlay, reg1, s1, tf_center_justify),
      (position_set_x, pos1, 500),
      (position_set_y, pos1, 600),
      (overlay_set_position, reg1, pos1),
      (overlay_set_text, reg1, s1),
      (create_button_overlay, "$g_presentation_obj_profile_banner_selection_1", "@Next Page", tf_center_justify),
      (position_set_x, pos1, 700),
      (position_set_y, pos1, 50),
      (overlay_set_position, "$g_presentation_obj_profile_banner_selection_1", pos1),

      (create_button_overlay, "$g_presentation_obj_profile_banner_selection_2", "str_use_default_banner", tf_center_justify),
      (position_set_x, pos1, 300),
      (position_set_y, pos1, 50),
      (overlay_set_position, "$g_presentation_obj_profile_banner_selection_2", pos1),

      (assign, ":x_pos", 150),
      (assign, ":y_pos", 575),
      (store_mul, ":starting_banner", 16, "$g_presentation_page_no"),
      (store_add, ":ending_banner", ":starting_banner", 16),
      (store_add, "$g_presentation_banner_start", "$g_presentation_obj_profile_banner_selection_2", 1),
      (assign, ":num_valid_banners", 0),
      (try_for_range, ":cur_banner_mesh", banner_meshes_begin, banner_meshes_end_minus_one),
        (assign, ":already_used", 0),
        (try_for_range, ":cur_faction", npc_kingdoms_begin, npc_kingdoms_end),
          (faction_slot_eq, ":cur_faction", slot_faction_banner, ":cur_banner_mesh"),
          (assign, ":already_used", 1),
        (try_end),
        (eq, ":already_used", 0),
        (val_add, ":num_valid_banners", 1),
        (gt, ":num_valid_banners", ":starting_banner"),
        (le, ":num_valid_banners", ":ending_banner"),
        (create_image_button_overlay, reg1, ":cur_banner_mesh", ":cur_banner_mesh"),
        (position_set_x, pos1, ":x_pos"),
        (position_set_y, pos1, ":y_pos"),
        (overlay_set_position, reg1, pos1),
        (position_set_x, pos1, 100),
        (position_set_y, pos1, 100),
        (overlay_set_size, reg1, pos1),
        (val_add, ":x_pos", 100),
        (ge, ":x_pos", 900),
        (assign, ":x_pos", 150),
        (val_sub, ":y_pos", 250),
      (try_end),
      (presentation_set_duration, 999999),
      ]),

    (ti_on_presentation_event_state_change, [
      (store_trigger_param_1, ":object"),
      (try_begin),
        (eq, ":object", "$g_presentation_obj_profile_banner_selection_1"),
        (val_add, "$g_presentation_page_no", 1),
        (val_mod, "$g_presentation_page_no", 8),
        (presentation_set_duration, 0),
        (start_presentation, "prsnt_game_profile_banner_selection"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_profile_banner_selection_2"),
        (profile_set_banner_id, -1),
        (presentation_set_duration, 0),
      (else_try),
        (store_sub, ":selected_banner", ":object", "$g_presentation_banner_start"),
        (store_mul, ":page_adder", 16, "$g_presentation_page_no"),
        (val_add, ":selected_banner", ":page_adder"),
        (assign, ":num_valid_banners", 0),
        (assign, ":end_cond", banner_meshes_end_minus_one),
        (try_for_range, ":cur_banner_mesh", banner_meshes_begin, ":end_cond"),
          (assign, ":already_used", 0),
          (try_for_range, ":cur_faction", npc_kingdoms_begin, npc_kingdoms_end),
            (faction_slot_eq, ":cur_faction", slot_faction_banner, ":cur_banner_mesh"),
            (assign, ":already_used", 1),
          (try_end),
          (eq, ":already_used", 0),
          (try_begin),
            (eq, ":selected_banner", ":num_valid_banners"),
            (store_sub, ":selected_banner_index", ":cur_banner_mesh", banner_meshes_begin),
            (profile_set_banner_id, ":selected_banner_index"),
            (assign, ":end_cond", 0), #break
          (try_end),
          (val_add, ":num_valid_banners", 1),
        (try_end),
        (presentation_set_duration, 0),
      (try_end),
      ]),
    ]),

  ("game_custom_battle_designer", prsntf_manual_end_only, mesh_cb_ui_main, [
    (ti_on_presentation_load,
     [(set_fixed_point_multiplier, 1000),

      (create_text_overlay, reg0, "str_player", tf_center_justify|tf_single_line|tf_with_outline),
      (overlay_set_color, reg0, 0xFFFFFFFF),
      (position_set_x, pos1, 1500),
      (position_set_y, pos1, 1500),
      (overlay_set_size, reg0, pos1),
      (position_set_x, pos1, 175),
      (position_set_y, pos1, 700),
      (overlay_set_position, reg0, pos1),

      (create_text_overlay, reg0, "str_enemy",  tf_center_justify|tf_single_line|tf_with_outline),
      (overlay_set_color, reg0, 0xFFFFFFFF),
      (position_set_x, pos1, 1500),
      (position_set_y, pos1, 1500),
      (overlay_set_size, reg0, pos1),
      (position_set_x, pos1, 820),
      (position_set_y, pos1, 700),
      (overlay_set_position, reg0, pos1),

      (create_text_overlay, reg0, "str_character", tf_center_justify),
      (position_set_x, pos1, 175),
      (position_set_y, pos1, 670),
      (overlay_set_position, reg0, pos1),

      (create_combo_label_overlay, "$g_presentation_obj_custom_battle_designer_18"),
      (position_set_x, pos1, 800),
      (position_set_y, pos1, 800),
      (overlay_set_size, "$g_presentation_obj_custom_battle_designer_18", pos1),
      (position_set_x, pos1, 175),
      (position_set_y, pos1, 635),
      (overlay_set_position, "$g_presentation_obj_custom_battle_designer_18", pos1),
      (try_for_range, ":cur_troop", quick_battle_troops_begin, quick_battle_troops_end),
        (str_store_troop_name, s0, ":cur_troop"),
        (overlay_add_item, "$g_presentation_obj_custom_battle_designer_18", s0),
      (try_end),
      (store_sub, ":cur_troop", "$g_quick_battle_troop", quick_battle_troops_begin),
      (overlay_set_val, "$g_presentation_obj_custom_battle_designer_18", ":cur_troop"),

      (store_mul, ":cur_troop", "$g_quick_battle_troop", 2), #with weapons
      (create_mesh_overlay_with_tableau_material, reg0, -1, "tableau_game_party_window", ":cur_troop"),
      (position_set_x, pos1, 25),
      (position_set_y, pos1, 370),
      (overlay_set_position, reg0, pos1),

      (try_begin),
        (eq, "$g_quick_battle_team_2_faction", "fac_kingdom_1"),
        (assign, ":cur_troop", "trp_swadian_knight"),
      (else_try),
        (eq, "$g_quick_battle_team_2_faction", "fac_kingdom_2"),
        (assign, ":cur_troop", "trp_vaegir_knight"),
      (else_try),
        (eq, "$g_quick_battle_team_2_faction", "fac_kingdom_3"),
        (assign, ":cur_troop", "trp_khergit_veteran_horse_archer"),
      (else_try),
        (eq, "$g_quick_battle_team_2_faction", "fac_kingdom_4"),
        (assign, ":cur_troop", "trp_nord_champion"),
      (else_try),
        (eq, "$g_quick_battle_team_2_faction", "fac_kingdom_5"),
        (assign, ":cur_troop", "trp_rhodok_sergeant"),
      (else_try),
        (eq, "$g_quick_battle_team_2_faction", "fac_kingdom_6"),
        (assign, ":cur_troop", "trp_sarranid_mamluke"),
      (else_try),
        (assign, ":cur_troop", "trp_taiga_bandit"),
      (try_end),
      (val_mul, ":cur_troop", 2), #with weapons
      (create_mesh_overlay_with_tableau_material, reg0, -1, "tableau_game_party_window", ":cur_troop"),
      (position_set_x, pos1, 670),
      (position_set_y, pos1, 370),
      (overlay_set_position, reg0, pos1),

      (create_text_overlay, reg0, "str_biography", tf_center_justify),
      (position_set_x, pos1, 500),
      (position_set_y, pos1, 700),
      (overlay_set_position, reg0, pos1),

      (store_sub, ":cur_troop_text", "$g_quick_battle_troop", quick_battle_troops_begin),
      (val_add, ":cur_troop_text", quick_battle_troop_texts_begin),
      (create_text_overlay, reg0, ":cur_troop_text", tf_scrollable),
      (position_set_x, pos1, 850),
      (position_set_y, pos1, 850),
      (overlay_set_size, reg0, pos1),
      (position_set_x, pos1, 320),
      (position_set_y, pos1, 560),
      (overlay_set_position, reg0, pos1),
      (position_set_x, pos1, 360),
      (position_set_y, pos1, 130),
      (overlay_set_area_size, reg0, pos1),

      (create_text_overlay, reg0, "str_map_basic", tf_center_justify),
      (overlay_set_color, reg0, 0xFFFFFF),
      (position_set_x, pos1, 1500),
      (position_set_y, pos1, 1500),
      (overlay_set_size, reg0, pos1),
      (position_set_x, pos1, 500),
      (position_set_y, pos1, 450),
      (overlay_set_position, reg0, pos1),

      (create_combo_label_overlay, "$g_presentation_obj_custom_battle_designer_1"),
      (position_set_x, pos1, 700),
      (position_set_y, pos1, 700),
      (overlay_set_size, "$g_presentation_obj_custom_battle_designer_1", pos1),
      (position_set_x, pos1, 500),
      (position_set_y, pos1, 415),
      (overlay_set_position, "$g_presentation_obj_custom_battle_designer_1", pos1),
      (try_begin),
        (eq, "$g_quick_battle_game_type", 0), #battle
        (try_for_range, ":cur_scene", quick_battle_battle_scenes_begin, quick_battle_battle_scenes_end),
          (store_sub, ":cur_scene_name", ":cur_scene", quick_battle_scenes_begin),
          (val_add, ":cur_scene_name", quick_battle_scene_names_begin),
          (overlay_add_item, "$g_presentation_obj_custom_battle_designer_1", ":cur_scene_name"),
        (try_end),
        (try_begin),
          (is_between, "$g_quick_battle_map", quick_battle_battle_scenes_begin, quick_battle_battle_scenes_end),
          (store_sub, ":cur_map", "$g_quick_battle_map", quick_battle_battle_scenes_begin),
          (overlay_set_val, "$g_presentation_obj_custom_battle_designer_1", ":cur_map"),
        (else_try),
          (overlay_set_val, "$g_presentation_obj_custom_battle_designer_1", 0),
          (assign, "$g_quick_battle_map", quick_battle_battle_scenes_begin),
        (try_end),
      (else_try),
        (try_for_range, ":cur_scene", quick_battle_siege_scenes_begin, quick_battle_siege_scenes_end),
          (store_sub, ":cur_scene_name", ":cur_scene", quick_battle_scenes_begin),
          (val_add, ":cur_scene_name", quick_battle_scene_names_begin),
          (overlay_add_item, "$g_presentation_obj_custom_battle_designer_1", ":cur_scene_name"),
        (try_end),
        (try_begin),
          (is_between, "$g_quick_battle_map", quick_battle_siege_scenes_begin, quick_battle_siege_scenes_end),
          (store_sub, ":cur_map", "$g_quick_battle_map", quick_battle_siege_scenes_begin),
          (overlay_set_val, "$g_presentation_obj_custom_battle_designer_1", ":cur_map"),
        (else_try),
          (overlay_set_val, "$g_presentation_obj_custom_battle_designer_1", 0),
          (assign, "$g_quick_battle_map", quick_battle_siege_scenes_begin),
        (try_end),
      (try_end),

      (store_sub, ":cur_mesh", "$g_quick_battle_map", quick_battle_scenes_begin),
      (val_add, ":cur_mesh", quick_battle_scene_images_begin),
      (create_mesh_overlay, reg0, ":cur_mesh"),
      (position_set_x, pos1, 700),
      (position_set_y, pos1, 700),
      (overlay_set_size, reg0, pos1),
      (position_set_x, pos1, 380),
      (position_set_y, pos1, 220),
      (overlay_set_position, reg0, pos1),

      (create_text_overlay, reg0, "str_game_type_basic", tf_center_justify),
      (overlay_set_color, reg0, 0xFFFFFF),
      (position_set_x, pos1, 1500),
      (position_set_y, pos1, 1500),
      (overlay_set_size, reg0, pos1),
      (position_set_x, pos1, 500),
      (position_set_y, pos1, 180),
      (overlay_set_position, reg0, pos1),

      (create_combo_label_overlay, "$g_presentation_obj_custom_battle_designer_23"),
      (position_set_x, pos1, 700),
      (position_set_y, pos1, 700),
      (overlay_set_size, "$g_presentation_obj_custom_battle_designer_23", pos1),
      (position_set_x, pos1, 500),
      (position_set_y, pos1, 150),
      (overlay_set_position, "$g_presentation_obj_custom_battle_designer_23", pos1),
      (overlay_add_item, "$g_presentation_obj_custom_battle_designer_23", "str_battle"),
      (overlay_add_item, "$g_presentation_obj_custom_battle_designer_23", "str_siege_offense"),
      (overlay_add_item, "$g_presentation_obj_custom_battle_designer_23", "str_siege_defense"),
      (overlay_set_val, "$g_presentation_obj_custom_battle_designer_23", "$g_quick_battle_game_type"),

      (create_game_button_overlay, "$g_presentation_obj_custom_battle_designer_24", "str_randomize"),
      (position_set_x, pos1, 500),
      (position_set_y, pos1, 60),
      (overlay_set_position, "$g_presentation_obj_custom_battle_designer_24", pos1),

      (assign, ":cur_y", 330),
      (assign, ":cur_y", 350),
      (assign, ":cur_y_adder", 40),

      (create_text_overlay, reg0, "str_faction", tf_center_justify),
      (position_set_x, pos1, 175),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_text_overlay, reg0, "str_faction", tf_center_justify),
      (position_set_x, pos1, 820),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),
      
      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_combo_label_overlay, "$g_presentation_obj_custom_battle_designer_4"),
##      (position_set_x, pos1, 800),
##      (position_set_y, pos1, 800),
##      (overlay_set_size, "$g_presentation_obj_custom_battle_designer_4", pos1),
      (position_set_x, pos1, 175),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_custom_battle_designer_4", pos1),
      (try_begin),
        (is_trial_version),
        (str_store_faction_name, s0, npc_kingdoms_begin),
        (overlay_add_item, "$g_presentation_obj_custom_battle_designer_4", s0),
        (store_add, ":cur_faction", npc_kingdoms_begin, 1),
        (str_store_faction_name, s0, ":cur_faction"),
        (overlay_add_item, "$g_presentation_obj_custom_battle_designer_4", s0),
      (else_try),
        (try_for_range, ":cur_faction", npc_kingdoms_begin, npc_kingdoms_end),
          (str_store_faction_name, s0, ":cur_faction"),
          (overlay_add_item, "$g_presentation_obj_custom_battle_designer_4", s0),
        (try_end),
        (str_store_faction_name, s0, "fac_outlaws"),
        (overlay_add_item, "$g_presentation_obj_custom_battle_designer_4", s0),
      (try_end),
      (try_begin),
        (eq, "$g_quick_battle_team_1_faction", "fac_outlaws"),
        (store_sub, ":overlay_value", npc_kingdoms_end, npc_kingdoms_begin),
        (overlay_set_val, "$g_presentation_obj_custom_battle_designer_4", ":overlay_value"),
      (else_try),
        (store_sub, ":team_1_faction", "$g_quick_battle_team_1_faction", npc_kingdoms_begin),
        (overlay_set_val, "$g_presentation_obj_custom_battle_designer_4", ":team_1_faction"),
      (try_end),

      (create_combo_label_overlay, "$g_presentation_obj_custom_battle_designer_5"),
##      (position_set_x, pos1, 800),
##      (position_set_y, pos1, 800),
##      (overlay_set_size, "$g_presentation_obj_custom_battle_designer_5", pos1),
      (position_set_x, pos1, 820),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_custom_battle_designer_5", pos1),
      (try_begin),
        (is_trial_version),
        (str_store_faction_name, s0, npc_kingdoms_begin),
        (overlay_add_item, "$g_presentation_obj_custom_battle_designer_5", s0),
        (store_add, ":cur_faction", npc_kingdoms_begin, 1),
        (str_store_faction_name, s0, ":cur_faction"),
        (overlay_add_item, "$g_presentation_obj_custom_battle_designer_5", s0),
      (else_try),
        (try_for_range, ":cur_faction", npc_kingdoms_begin, npc_kingdoms_end),
          (str_store_faction_name, s0, ":cur_faction"),
          (overlay_add_item, "$g_presentation_obj_custom_battle_designer_5", s0),
        (try_end),
        (str_store_faction_name, s0, "fac_outlaws"),
        (overlay_add_item, "$g_presentation_obj_custom_battle_designer_5", s0),
      (try_end),
      (try_begin),
        (eq, "$g_quick_battle_team_2_faction", "fac_outlaws"),
        (store_sub, ":overlay_value", npc_kingdoms_end, npc_kingdoms_begin),
        (overlay_set_val, "$g_presentation_obj_custom_battle_designer_5", ":overlay_value"),
      (else_try),
        (store_sub, ":team_2_faction", "$g_quick_battle_team_2_faction", npc_kingdoms_begin),
        (overlay_set_val, "$g_presentation_obj_custom_battle_designer_5", ":team_2_faction"),
      (try_end),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_text_overlay, reg0, "str_army_composition", tf_center_justify),
      (position_set_x, pos1, 175),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_text_overlay, reg0, "str_army_composition", tf_center_justify),
      (position_set_x, pos1, 820),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (try_begin),
        (eq, "$g_presentation_obj_custom_battle_designer_6_last_value", 0),
        (eq, "$g_presentation_obj_custom_battle_designer_7_last_value", 0),
        (eq, "$g_presentation_obj_custom_battle_designer_8_last_value", 0),
        (eq, "$g_presentation_obj_custom_battle_designer_9_last_value", 0),
        (eq, "$g_presentation_obj_custom_battle_designer_10_last_value", 0),
        (eq, "$g_presentation_obj_custom_battle_designer_11_last_value", 0),
        (assign, "$g_presentation_obj_custom_battle_designer_6_last_value", 34),
        (assign, "$g_presentation_obj_custom_battle_designer_7_last_value", 33),
        (assign, "$g_presentation_obj_custom_battle_designer_8_last_value", 33),
        (assign, "$g_presentation_obj_custom_battle_designer_9_last_value", 34),
        (assign, "$g_presentation_obj_custom_battle_designer_10_last_value", 33),
        (assign, "$g_presentation_obj_custom_battle_designer_11_last_value", 33),
        (assign, "$g_presentation_obj_custom_battle_designer_6_locked", 0),
        (assign, "$g_presentation_obj_custom_battle_designer_7_locked", 0),
        (assign, "$g_presentation_obj_custom_battle_designer_8_locked", 0),
        (assign, "$g_presentation_obj_custom_battle_designer_9_locked", 0),
        (assign, "$g_presentation_obj_custom_battle_designer_10_locked", 0),
        (assign, "$g_presentation_obj_custom_battle_designer_11_locked", 0),
      (try_end),

      (create_mesh_overlay, reg0, "mesh_cb_ui_icon_infantry"),
      (position_set_x, pos1, 5),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),
      (position_set_x, pos1, 400),
      (position_set_y, pos1, 400),
      (overlay_set_size, reg0, pos1),

      (create_mesh_overlay, reg0, "mesh_cb_ui_icon_infantry"),
      (position_set_x, pos1, 650),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),
      (position_set_x, pos1, 400),
      (position_set_y, pos1, 400),
      (overlay_set_size, reg0, pos1),

      (create_slider_overlay, "$g_presentation_obj_custom_battle_designer_6", 0, 100),
      (overlay_set_val, "$g_presentation_obj_custom_battle_designer_6", "$g_presentation_obj_custom_battle_designer_6_last_value"),
      (position_set_x, pos1, 900),
      (position_set_y, pos1, 1000),
      (overlay_set_size, "$g_presentation_obj_custom_battle_designer_6", pos1),
      (position_set_x, pos1, 175),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_custom_battle_designer_6", pos1),

      (assign, reg0, "$g_presentation_obj_custom_battle_designer_6_last_value"),
      (create_text_overlay, "$g_presentation_obj_custom_battle_designer_12", "str_reg0_percent", 0),
      (position_set_x, pos1, 295),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_custom_battle_designer_12", pos1),

      (create_slider_overlay, "$g_presentation_obj_custom_battle_designer_9", 0, 100),
      (overlay_set_val, "$g_presentation_obj_custom_battle_designer_9", "$g_presentation_obj_custom_battle_designer_9_last_value"),
      (position_set_x, pos1, 900),
      (position_set_y, pos1, 1000),
      (overlay_set_size, "$g_presentation_obj_custom_battle_designer_9", pos1),
      (position_set_x, pos1, 820),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_custom_battle_designer_9", pos1),

      (assign, reg0, "$g_presentation_obj_custom_battle_designer_9_last_value"),
      (create_text_overlay, "$g_presentation_obj_custom_battle_designer_15", "str_reg0_percent", 0),
      (position_set_x, pos1, 940),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_custom_battle_designer_15", pos1),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_mesh_overlay, reg0, "mesh_cb_ui_icon_archer"),
      (position_set_x, pos1, 15),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),
      (position_set_x, pos1, 400),
      (position_set_y, pos1, 400),
      (overlay_set_size, reg0, pos1),

      (create_mesh_overlay, reg0, "mesh_cb_ui_icon_archer"),
      (position_set_x, pos1, 660),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),
      (position_set_x, pos1, 400),
      (position_set_y, pos1, 400),
      (overlay_set_size, reg0, pos1),

      (create_slider_overlay, "$g_presentation_obj_custom_battle_designer_7", 0, 100),
      (overlay_set_val, "$g_presentation_obj_custom_battle_designer_7", "$g_presentation_obj_custom_battle_designer_7_last_value"),
      (position_set_x, pos1, 900),
      (position_set_y, pos1, 1000),
      (overlay_set_size, "$g_presentation_obj_custom_battle_designer_7", pos1),
      (position_set_x, pos1, 175),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_custom_battle_designer_7", pos1),

      (assign, reg0, "$g_presentation_obj_custom_battle_designer_7_last_value"),
      (create_text_overlay, "$g_presentation_obj_custom_battle_designer_13", "str_reg0_percent", 0),
      (position_set_x, pos1, 295),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_custom_battle_designer_13", pos1),

      (create_slider_overlay, "$g_presentation_obj_custom_battle_designer_10", 0, 100),
      (overlay_set_val, "$g_presentation_obj_custom_battle_designer_10", "$g_presentation_obj_custom_battle_designer_10_last_value"),
      (position_set_x, pos1, 900),
      (position_set_y, pos1, 1000),
      (overlay_set_size, "$g_presentation_obj_custom_battle_designer_10", pos1),
      (position_set_x, pos1, 820),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_custom_battle_designer_10", pos1),

      (assign, reg0, "$g_presentation_obj_custom_battle_designer_10_last_value"),
      (create_text_overlay, "$g_presentation_obj_custom_battle_designer_16", "str_reg0_percent", 0),
      (position_set_x, pos1, 940),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_custom_battle_designer_16", pos1),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_mesh_overlay, reg0, "mesh_cb_ui_icon_horseman"),
      (position_set_x, pos1, 10),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),
      (position_set_x, pos1, 400),
      (position_set_y, pos1, 400),
      (overlay_set_size, reg0, pos1),

      (create_mesh_overlay, reg0, "mesh_cb_ui_icon_horseman"),
      (position_set_x, pos1, 655),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),
      (position_set_x, pos1, 400),
      (position_set_y, pos1, 400),
      (overlay_set_size, reg0, pos1),

      (create_slider_overlay, "$g_presentation_obj_custom_battle_designer_8", 0, 100),
      (overlay_set_val, "$g_presentation_obj_custom_battle_designer_8", "$g_presentation_obj_custom_battle_designer_8_last_value"),
      (position_set_x, pos1, 900),
      (position_set_y, pos1, 1000),
      (overlay_set_size, "$g_presentation_obj_custom_battle_designer_8", pos1),
      (position_set_x, pos1, 175),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_custom_battle_designer_8", pos1),

      (assign, reg0, "$g_presentation_obj_custom_battle_designer_8_last_value"),
      (create_text_overlay, "$g_presentation_obj_custom_battle_designer_14", "str_reg0_percent", 0),
      (position_set_x, pos1, 295),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_custom_battle_designer_14", pos1),

      (create_slider_overlay, "$g_presentation_obj_custom_battle_designer_11", 0, 100),
      (overlay_set_val, "$g_presentation_obj_custom_battle_designer_11", "$g_presentation_obj_custom_battle_designer_11_last_value"),
      (position_set_x, pos1, 900),
      (position_set_y, pos1, 1000),
      (overlay_set_size, "$g_presentation_obj_custom_battle_designer_11", pos1),
      (position_set_x, pos1, 820),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_custom_battle_designer_11", pos1),

      (assign, reg0, "$g_presentation_obj_custom_battle_designer_11_last_value"),
      (create_text_overlay, "$g_presentation_obj_custom_battle_designer_17", "str_reg0_percent", 0),
      (position_set_x, pos1, 940),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_custom_battle_designer_17", pos1),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_text_overlay, reg0, "str_army_size", tf_center_justify),
      (position_set_x, pos1, 175),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_text_overlay, reg0, "str_army_size", tf_center_justify),
      (position_set_x, pos1, 820),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (try_begin),
        (is_trial_version),
        (val_min, "$g_quick_battle_army_1_size", 25),
        (val_min, "$g_quick_battle_army_2_size", 25),
      (try_end),

      (create_slider_overlay, "$g_presentation_obj_custom_battle_designer_2", 0, 100),
      (overlay_set_boundaries, "$g_presentation_obj_custom_battle_designer_2", 1000, 75000),
      (overlay_set_val, "$g_presentation_obj_custom_battle_designer_2", "$g_quick_battle_army_1_size"),
      (position_set_x, pos1, 900),
      (position_set_y, pos1, 1000),
      (overlay_set_size, "$g_presentation_obj_custom_battle_designer_2", pos1),
      (position_set_x, pos1, 135),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_custom_battle_designer_2", pos1),

      (call_script, "script_get_army_size_from_slider_value", "$g_quick_battle_army_1_size"),
      (create_text_overlay, "$g_presentation_obj_custom_battle_designer_21", "str_reg0_men", 0),
      (position_set_x, pos1, 255),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_custom_battle_designer_21", pos1),

      (create_slider_overlay, "$g_presentation_obj_custom_battle_designer_3", 200),
      (overlay_set_boundaries, "$g_presentation_obj_custom_battle_designer_3", 1000, 75000),
      (overlay_set_val, "$g_presentation_obj_custom_battle_designer_3", "$g_quick_battle_army_2_size"),
      (position_set_x, pos1, 900),
      (position_set_y, pos1, 1000),
      (overlay_set_size, "$g_presentation_obj_custom_battle_designer_3", pos1),
      (position_set_x, pos1, 780),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_custom_battle_designer_3", pos1),

      (call_script, "script_get_army_size_from_slider_value", "$g_quick_battle_army_2_size"),
      (create_text_overlay, "$g_presentation_obj_custom_battle_designer_22", "str_reg0_men", 0),
      (position_set_x, pos1, 900),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_custom_battle_designer_22", pos1),

      (create_game_button_overlay, "$g_presentation_obj_custom_battle_designer_19", "str_start", 0),
      (position_set_x, pos1, 415),
      (position_set_y, pos1, 10),
      (overlay_set_position, "$g_presentation_obj_custom_battle_designer_19", pos1),

      (create_game_button_overlay, "$g_presentation_obj_custom_battle_designer_20", "str_back", 0),
      (position_set_x, pos1, 585),
      (position_set_y, pos1, 10),
      (overlay_set_position, "$g_presentation_obj_custom_battle_designer_20", pos1),

      (presentation_set_duration, 999999),
      ]),
    
    (ti_on_presentation_event_state_change,
     [
       (store_trigger_param_1, ":object"),
       (store_trigger_param_2, ":value"),
       (try_begin),
         (eq, ":object", "$g_presentation_obj_custom_battle_designer_1"),
         (try_begin),
           (eq, "$g_quick_battle_game_type", 0),
           (store_add, "$g_quick_battle_map", ":value", quick_battle_battle_scenes_begin),
         (else_try),
           (store_add, "$g_quick_battle_map", ":value", quick_battle_siege_scenes_begin),
         (try_end),
         (presentation_set_duration, 0),
         (start_presentation, "prsnt_game_custom_battle_designer"),
       (else_try),
         (eq, ":object", "$g_presentation_obj_custom_battle_designer_23"),
         (assign, "$g_quick_battle_game_type", ":value"),
         (presentation_set_duration, 0),
         (start_presentation, "prsnt_game_custom_battle_designer"),
       (else_try),
         (eq, ":object", "$g_presentation_obj_custom_battle_designer_24"),
         (store_random_in_range, "$g_quick_battle_game_type", 0, 3),
         (store_random_in_range, "$g_quick_battle_troop", quick_battle_troops_begin, quick_battle_troops_end),
         (try_begin),
           (is_trial_version),
           (store_random_in_range, "$g_quick_battle_team_1_faction", 0, 2),
           (try_begin),
             (eq, "$g_quick_battle_team_1_faction", 0),
             (assign, "$g_quick_battle_team_2_faction", 1),
           (else_try),
             (assign, "$g_quick_battle_team_2_faction", 0),
           (try_end),
           (val_add, "$g_quick_battle_team_1_faction", npc_kingdoms_begin),
           (val_add, "$g_quick_battle_team_2_faction", npc_kingdoms_begin),
           (store_random_in_range, "$g_quick_battle_army_1_size", 10, 16),
           (store_random_in_range, ":random_army_size", 0, 6),
           (val_add, "$g_quick_battle_army_1_size", ":random_army_size"),
           (store_random_in_range, ":random_army_size", 0, 6),
           (val_add, "$g_quick_battle_army_1_size", ":random_army_size"),
         (else_try),
           (store_sub, ":num_factions", npc_kingdoms_end, npc_kingdoms_begin),
           (val_add, ":num_factions", 1),
           (store_random_in_range, "$g_quick_battle_team_1_faction", 0, ":num_factions"),
           (try_begin),
             (eq, "$g_quick_battle_team_1_faction", 0),
             (assign, "$g_quick_battle_team_1_faction", "fac_outlaws"),
           (else_try),
             (val_add, "$g_quick_battle_team_1_faction", npc_kingdoms_begin),
             (val_sub, "$g_quick_battle_team_1_faction", 1),
           (try_end),
           (assign, ":end_cond", 1000),
           (try_for_range, ":unused", 0, ":end_cond"),
             (store_random_in_range, "$g_quick_battle_team_2_faction", 0, ":num_factions"),
             (try_begin),
               (eq, "$g_quick_battle_team_2_faction", 0),
               (assign, "$g_quick_battle_team_2_faction", "fac_outlaws"),
             (else_try),
               (val_add, "$g_quick_battle_team_2_faction", npc_kingdoms_begin),
               (val_sub, "$g_quick_battle_team_2_faction", 1),
             (try_end),
             (neq, "$g_quick_battle_team_1_faction", "$g_quick_battle_team_2_faction"),
             (assign, ":end_cond", 0),
           (try_end),
           (store_random_in_range, "$g_quick_battle_army_1_size", 10, 21),
           (store_random_in_range, ":random_army_size", 0, 11),
           (val_add, "$g_quick_battle_army_1_size", ":random_army_size"),
           (store_random_in_range, ":random_army_size", 0, 11),
           (val_add, "$g_quick_battle_army_1_size", ":random_army_size"),
         (try_end),
         (assign, "$g_quick_battle_army_2_size", "$g_quick_battle_army_1_size"),
         (try_begin),
           (eq, "$g_quick_battle_game_type", 0), #battle
           (store_random_in_range, "$g_quick_battle_map", quick_battle_battle_scenes_begin, quick_battle_battle_scenes_end),
           (store_random_in_range, ":random_type", 0, 3),
           (store_random_in_range, ":random_type_2", 0, 2),
           (store_random_in_range, ":random_composition", 0, 100),
           (store_sub, ":left_max", 100, ":random_composition"),
           (store_random_in_range, ":random_composition_2", 0, ":left_max"),
           (store_sub, ":random_composition_3", ":left_max", ":random_composition_2"),
           (try_begin),
             (eq, ":random_type", 0),
             (assign, "$g_presentation_obj_custom_battle_designer_6_last_value", ":random_composition"),
             (try_begin),
               (eq, ":random_type_2", 0),
               (assign, "$g_presentation_obj_custom_battle_designer_7_last_value", ":random_composition_2"),
               (assign, "$g_presentation_obj_custom_battle_designer_8_last_value", ":random_composition_3"),
             (else_try),
               (assign, "$g_presentation_obj_custom_battle_designer_8_last_value", ":random_composition_2"),
               (assign, "$g_presentation_obj_custom_battle_designer_7_last_value", ":random_composition_3"),
             (try_end),
           (else_try),
             (eq, ":random_type", 1),
             (assign, "$g_presentation_obj_custom_battle_designer_7_last_value", ":random_composition"),
             (try_begin),
               (eq, ":random_type_2", 0),
               (assign, "$g_presentation_obj_custom_battle_designer_6_last_value", ":random_composition_2"),
               (assign, "$g_presentation_obj_custom_battle_designer_8_last_value", ":random_composition_3"),
             (else_try),
               (assign, "$g_presentation_obj_custom_battle_designer_8_last_value", ":random_composition_2"),
               (assign, "$g_presentation_obj_custom_battle_designer_6_last_value", ":random_composition_3"),
             (try_end),
           (else_try),
             (assign, "$g_presentation_obj_custom_battle_designer_8_last_value", ":random_composition"),
             (try_begin),
               (eq, ":random_type_2", 0),
               (assign, "$g_presentation_obj_custom_battle_designer_6_last_value", ":random_composition_2"),
               (assign, "$g_presentation_obj_custom_battle_designer_7_last_value", ":random_composition_3"),
             (else_try),
               (assign, "$g_presentation_obj_custom_battle_designer_7_last_value", ":random_composition_2"),
               (assign, "$g_presentation_obj_custom_battle_designer_6_last_value", ":random_composition_3"),
             (try_end),
           (try_end),
           (store_random_in_range, ":random_type", 0, 3),
           (store_random_in_range, ":random_type_2", 0, 2),
           (store_random_in_range, ":random_composition", 0, 100),
           (store_sub, ":left_max", 100, ":random_composition"),
           (store_random_in_range, ":random_composition_2", 0, ":left_max"),
           (store_sub, ":random_composition_3", ":left_max", ":random_composition_2"),
           (try_begin),
             (eq, ":random_type", 0),
             (assign, "$g_presentation_obj_custom_battle_designer_9_last_value", ":random_composition"),
             (try_begin),
               (eq, ":random_type_2", 0),
               (assign, "$g_presentation_obj_custom_battle_designer_10_last_value", ":random_composition_2"),
               (assign, "$g_presentation_obj_custom_battle_designer_11_last_value", ":random_composition_3"),
             (else_try),
               (assign, "$g_presentation_obj_custom_battle_designer_11_last_value", ":random_composition_2"),
               (assign, "$g_presentation_obj_custom_battle_designer_10_last_value", ":random_composition_3"),
             (try_end),
           (else_try),
             (eq, ":random_type", 1),
             (assign, "$g_presentation_obj_custom_battle_designer_10_last_value", ":random_composition"),
             (try_begin),
               (eq, ":random_type_2", 0),
               (assign, "$g_presentation_obj_custom_battle_designer_9_last_value", ":random_composition_2"),
               (assign, "$g_presentation_obj_custom_battle_designer_11_last_value", ":random_composition_3"),
             (else_try),
               (assign, "$g_presentation_obj_custom_battle_designer_11_last_value", ":random_composition_2"),
               (assign, "$g_presentation_obj_custom_battle_designer_9_last_value", ":random_composition_3"),
             (try_end),
           (else_try),
             (assign, "$g_presentation_obj_custom_battle_designer_11_last_value", ":random_composition"),
             (try_begin),
               (eq, ":random_type_2", 0),
               (assign, "$g_presentation_obj_custom_battle_designer_9_last_value", ":random_composition_2"),
               (assign, "$g_presentation_obj_custom_battle_designer_10_last_value", ":random_composition_3"),
             (else_try),
               (assign, "$g_presentation_obj_custom_battle_designer_10_last_value", ":random_composition_2"),
               (assign, "$g_presentation_obj_custom_battle_designer_9_last_value", ":random_composition_3"),
             (try_end),
           (try_end),
         (else_try),
           (eq, "$g_quick_battle_game_type", 1), #siege offense
           (store_random_in_range, "$g_quick_battle_map", quick_battle_siege_scenes_begin, quick_battle_siege_scenes_end),
           #defender is enemy
           (store_random_in_range, "$g_presentation_obj_custom_battle_designer_10_last_value", 30, 100), #min 30% archer
           (store_sub, "$g_presentation_obj_custom_battle_designer_9_last_value", 100, "$g_presentation_obj_custom_battle_designer_10_last_value"),
           (assign, "$g_presentation_obj_custom_battle_designer_11_last_value", 0), #no cavalry
           (store_random_in_range, "$g_presentation_obj_custom_battle_designer_6_last_value", 20, 100), #min 20% infantry
           (store_sub, "$g_presentation_obj_custom_battle_designer_7_last_value", 100, "$g_presentation_obj_custom_battle_designer_6_last_value"),
           (assign, "$g_presentation_obj_custom_battle_designer_8_last_value", 0), #no cavalry
         (else_try),
           #siege defense
           (store_random_in_range, "$g_quick_battle_map", quick_battle_siege_scenes_begin, quick_battle_siege_scenes_end),
           #defender is player
           (store_random_in_range, "$g_presentation_obj_custom_battle_designer_7_last_value", 30, 100), #min 30% archer
           (store_sub, "$g_presentation_obj_custom_battle_designer_6_last_value", 100, "$g_presentation_obj_custom_battle_designer_7_last_value"),
           (assign, "$g_presentation_obj_custom_battle_designer_8_last_value", 0), #no cavalry
           (store_random_in_range, "$g_presentation_obj_custom_battle_designer_9_last_value", 20, 100), #min 20% infantry
           (store_sub, "$g_presentation_obj_custom_battle_designer_10_last_value", 100, "$g_presentation_obj_custom_battle_designer_9_last_value"),
           (assign, "$g_presentation_obj_custom_battle_designer_11_last_value", 0), #no cavalry
         (try_end),
         (presentation_set_duration, 0),
         (start_presentation, "prsnt_game_custom_battle_designer"),
       (else_try),
         (eq, ":object", "$g_presentation_obj_custom_battle_designer_2"),
         (assign, "$g_quick_battle_army_1_size", ":value"),
         (try_begin),
           (is_trial_version),
           (gt, "$g_quick_battle_army_1_size", 25),
           (assign, "$g_quick_battle_army_1_size", 25),
           (overlay_set_val, "$g_presentation_obj_custom_battle_designer_2", 25),
         (try_end),
         (call_script, "script_get_army_size_from_slider_value", "$g_quick_battle_army_1_size"),
         (overlay_set_text, "$g_presentation_obj_custom_battle_designer_21", "str_reg0_men"),
       (else_try),
         (eq, ":object", "$g_presentation_obj_custom_battle_designer_3"),
         (assign, "$g_quick_battle_army_2_size", ":value"),
         (try_begin),
           (is_trial_version),
           (gt, "$g_quick_battle_army_2_size", 25),
           (assign, "$g_quick_battle_army_2_size", 25),
           (overlay_set_val, "$g_presentation_obj_custom_battle_designer_3", 25),
         (try_end),
         (call_script, "script_get_army_size_from_slider_value", "$g_quick_battle_army_2_size"),
         (overlay_set_text, "$g_presentation_obj_custom_battle_designer_22", "str_reg0_men"),
       (else_try),
         (eq, ":object", "$g_presentation_obj_custom_battle_designer_4"),
         (try_begin),
           (store_sub, ":outlaw_index", npc_kingdoms_end, npc_kingdoms_begin),
           (eq, ":value", ":outlaw_index"),
           (assign, "$g_quick_battle_team_1_faction", "fac_outlaws"),
         (else_try),
           (store_add, "$g_quick_battle_team_1_faction", ":value", npc_kingdoms_begin),
         (try_end),
       (else_try),
         (eq, ":object", "$g_presentation_obj_custom_battle_designer_5"),
         (try_begin),
           (store_sub, ":outlaw_index", npc_kingdoms_end, npc_kingdoms_begin),
           (eq, ":value", ":outlaw_index"),
           (assign, "$g_quick_battle_team_2_faction", "fac_outlaws"),
         (else_try),
           (store_add, "$g_quick_battle_team_2_faction", ":value", npc_kingdoms_begin),
         (try_end),
         (presentation_set_duration, 0),
         (start_presentation, "prsnt_game_custom_battle_designer"),
       (else_try),
         (eq, ":object", "$g_presentation_obj_custom_battle_designer_18"),
         (store_add, "$g_quick_battle_troop", ":value", quick_battle_troops_begin),
         (presentation_set_duration, 0),
         (start_presentation, "prsnt_game_custom_battle_designer"),
       (else_try),
         (eq, ":object", "$g_presentation_obj_custom_battle_designer_6"),
         (try_begin),
           (eq, "$g_presentation_obj_custom_battle_designer_6_locked", 1),
           (neq, ":value", "$g_presentation_obj_custom_battle_designer_6_last_value"),
           (overlay_set_val, "$g_presentation_obj_custom_battle_designer_6", "$g_presentation_obj_custom_battle_designer_6_last_value"),
         (else_try),
           (try_begin),
             (lt, ":value", "$g_presentation_obj_custom_battle_designer_6_last_value"),
             (store_sub, ":dif", "$g_presentation_obj_custom_battle_designer_6_last_value", ":value"),
             (try_begin),
               (eq, "$g_presentation_obj_custom_battle_designer_7_locked", 1),
               (assign, ":first_dif", 0),
               (assign, ":second_dif", ":dif"),
             (else_try),
               (eq, "$g_presentation_obj_custom_battle_designer_8_locked", 1),
               (assign, ":first_dif", ":dif"),
               (assign, ":second_dif", 0),
             (else_try),
               (store_div, ":first_dif", ":dif", 2),
               (store_sub, ":second_dif", ":dif", ":first_dif"),
               (try_begin),
                 (neq, ":first_dif", ":second_dif"),
                 (store_random_in_range, ":random_no", 0, 2),
                 (eq, ":random_no", 0),
                 (val_sub, ":second_dif", 1),
                 (val_add, ":first_dif", 1),
               (try_end),
             (try_end),
             (assign, "$g_presentation_obj_custom_battle_designer_6_last_value", ":value"),
             (val_add, "$g_presentation_obj_custom_battle_designer_7_last_value", ":first_dif"),
             (val_add, "$g_presentation_obj_custom_battle_designer_8_last_value", ":second_dif"),
             (try_begin),
               (gt, "$g_presentation_obj_custom_battle_designer_7_last_value", 100),
               (store_sub, ":dif", "$g_presentation_obj_custom_battle_designer_7_last_value", 100),
               (val_add, "$g_presentation_obj_custom_battle_designer_8_last_value", ":dif"),
               (assign, "$g_presentation_obj_custom_battle_designer_7_last_value", 100),
             (else_try),
               (gt, "$g_presentation_obj_custom_battle_designer_8_last_value", 100),
               (store_sub, ":dif", "$g_presentation_obj_custom_battle_designer_8_last_value", 100),
               (val_add, "$g_presentation_obj_custom_battle_designer_7_last_value", ":dif"),
               (assign, "$g_presentation_obj_custom_battle_designer_8_last_value", 100),
             (try_end),
             (overlay_set_val, "$g_presentation_obj_custom_battle_designer_7", "$g_presentation_obj_custom_battle_designer_7_last_value"),
             (overlay_set_val, "$g_presentation_obj_custom_battle_designer_8", "$g_presentation_obj_custom_battle_designer_8_last_value"),
           (else_try),
             (gt, ":value", "$g_presentation_obj_custom_battle_designer_6_last_value"),
             (store_sub, ":dif", ":value", "$g_presentation_obj_custom_battle_designer_6_last_value"),
             (try_begin),
               (eq, "$g_presentation_obj_custom_battle_designer_7_locked", 1),
               (assign, ":first_dif", 0),
               (assign, ":second_dif", ":dif"),
             (else_try),
               (eq, "$g_presentation_obj_custom_battle_designer_8_locked", 1),
               (assign, ":first_dif", ":dif"),
               (assign, ":second_dif", 0),
             (else_try),
               (store_div, ":first_dif", ":dif", 2),
               (store_sub, ":second_dif", ":dif", ":first_dif"),
               (try_begin),
                 (neq, ":first_dif", ":second_dif"),
                 (store_random_in_range, ":random_no", 0, 2),
                 (eq, ":random_no", 0),
                 (val_sub, ":second_dif", 1),
                 (val_add, ":first_dif", 1),
               (try_end),
             (try_end),
             (assign, "$g_presentation_obj_custom_battle_designer_6_last_value", ":value"),
             (val_sub, "$g_presentation_obj_custom_battle_designer_7_last_value", ":first_dif"),
             (val_sub, "$g_presentation_obj_custom_battle_designer_8_last_value", ":second_dif"),
             (try_begin),
               (lt, "$g_presentation_obj_custom_battle_designer_7_last_value", 0),
               (val_add, "$g_presentation_obj_custom_battle_designer_8_last_value", "$g_presentation_obj_custom_battle_designer_7_last_value"),
               (assign, "$g_presentation_obj_custom_battle_designer_7_last_value", 0),
             (else_try),
               (lt, "$g_presentation_obj_custom_battle_designer_8_last_value", 0),
               (val_add, "$g_presentation_obj_custom_battle_designer_7_last_value", "$g_presentation_obj_custom_battle_designer_8_last_value"),
               (assign, "$g_presentation_obj_custom_battle_designer_8_last_value", 0),
             (try_end),
             (overlay_set_val, "$g_presentation_obj_custom_battle_designer_7", "$g_presentation_obj_custom_battle_designer_7_last_value"),
             (overlay_set_val, "$g_presentation_obj_custom_battle_designer_8", "$g_presentation_obj_custom_battle_designer_8_last_value"),
           (try_end),
           (assign, reg0, "$g_presentation_obj_custom_battle_designer_6_last_value"),
           (overlay_set_text, "$g_presentation_obj_custom_battle_designer_12", "str_reg0_percent"),
           (assign, reg0, "$g_presentation_obj_custom_battle_designer_7_last_value"),
           (overlay_set_text, "$g_presentation_obj_custom_battle_designer_13", "str_reg0_percent"),
           (assign, reg0, "$g_presentation_obj_custom_battle_designer_8_last_value"),
           (overlay_set_text, "$g_presentation_obj_custom_battle_designer_14", "str_reg0_percent"),
         (try_end),
       (else_try),
         (eq, ":object", "$g_presentation_obj_custom_battle_designer_7"),
         (try_begin),
           (eq, "$g_presentation_obj_custom_battle_designer_7_locked", 1),
           (neq, ":value", "$g_presentation_obj_custom_battle_designer_7_last_value"),
           (overlay_set_val, "$g_presentation_obj_custom_battle_designer_7", "$g_presentation_obj_custom_battle_designer_7_last_value"),
         (else_try),
           (try_begin),
             (lt, ":value", "$g_presentation_obj_custom_battle_designer_7_last_value"),
             (store_sub, ":dif", "$g_presentation_obj_custom_battle_designer_7_last_value", ":value"),
             (try_begin),
               (eq, "$g_presentation_obj_custom_battle_designer_6_locked", 1),
               (assign, ":first_dif", 0),
               (assign, ":second_dif", ":dif"),
             (else_try),
               (eq, "$g_presentation_obj_custom_battle_designer_8_locked", 1),
               (assign, ":first_dif", ":dif"),
               (assign, ":second_dif", 0),
             (else_try),
               (store_div, ":first_dif", ":dif", 2),
               (store_sub, ":second_dif", ":dif", ":first_dif"),
               (try_begin),
                 (neq, ":first_dif", ":second_dif"),
                 (store_random_in_range, ":random_no", 0, 2),
                 (eq, ":random_no", 0),
                 (val_sub, ":second_dif", 1),
                 (val_add, ":first_dif", 1),
               (try_end),
             (try_end),
             (assign, "$g_presentation_obj_custom_battle_designer_7_last_value", ":value"),
             (val_add, "$g_presentation_obj_custom_battle_designer_6_last_value", ":first_dif"),
             (val_add, "$g_presentation_obj_custom_battle_designer_8_last_value", ":second_dif"),
             (try_begin),
               (gt, "$g_presentation_obj_custom_battle_designer_6_last_value", 100),
               (store_sub, ":dif", "$g_presentation_obj_custom_battle_designer_6_last_value", 100),
               (val_add, "$g_presentation_obj_custom_battle_designer_8_last_value", ":dif"),
               (assign, "$g_presentation_obj_custom_battle_designer_6_last_value", 100),
             (else_try),
               (gt, "$g_presentation_obj_custom_battle_designer_8_last_value", 100),
               (store_sub, ":dif", "$g_presentation_obj_custom_battle_designer_8_last_value", 100),
               (val_add, "$g_presentation_obj_custom_battle_designer_6_last_value", ":dif"),
               (assign, "$g_presentation_obj_custom_battle_designer_8_last_value", 100),
             (try_end),
             (overlay_set_val, "$g_presentation_obj_custom_battle_designer_6", "$g_presentation_obj_custom_battle_designer_6_last_value"),
             (overlay_set_val, "$g_presentation_obj_custom_battle_designer_8", "$g_presentation_obj_custom_battle_designer_8_last_value"),
           (else_try),
             (gt, ":value", "$g_presentation_obj_custom_battle_designer_7_last_value"),
             (store_sub, ":dif", ":value", "$g_presentation_obj_custom_battle_designer_7_last_value"),
             (try_begin),
               (eq, "$g_presentation_obj_custom_battle_designer_6_locked", 1),
               (assign, ":first_dif", 0),
               (assign, ":second_dif", ":dif"),
             (else_try),
               (eq, "$g_presentation_obj_custom_battle_designer_8_locked", 1),
               (assign, ":first_dif", ":dif"),
               (assign, ":second_dif", 0),
             (else_try),
               (store_div, ":first_dif", ":dif", 2),
               (store_sub, ":second_dif", ":dif", ":first_dif"),
               (try_begin),
                 (neq, ":first_dif", ":second_dif"),
                 (store_random_in_range, ":random_no", 0, 2),
                 (eq, ":random_no", 0),
                 (val_sub, ":second_dif", 1),
                 (val_add, ":first_dif", 1),
               (try_end),
             (try_end),
             (assign, "$g_presentation_obj_custom_battle_designer_7_last_value", ":value"),
             (val_sub, "$g_presentation_obj_custom_battle_designer_6_last_value", ":first_dif"),
             (val_sub, "$g_presentation_obj_custom_battle_designer_8_last_value", ":second_dif"),
             (try_begin),
               (lt, "$g_presentation_obj_custom_battle_designer_6_last_value", 0),
               (val_add, "$g_presentation_obj_custom_battle_designer_8_last_value", "$g_presentation_obj_custom_battle_designer_6_last_value"),
               (assign, "$g_presentation_obj_custom_battle_designer_6_last_value", 0),
             (else_try),
               (lt, "$g_presentation_obj_custom_battle_designer_8_last_value", 0),
               (val_add, "$g_presentation_obj_custom_battle_designer_6_last_value", "$g_presentation_obj_custom_battle_designer_8_last_value"),
               (assign, "$g_presentation_obj_custom_battle_designer_8_last_value", 0),
             (try_end),
             (overlay_set_val, "$g_presentation_obj_custom_battle_designer_6", "$g_presentation_obj_custom_battle_designer_6_last_value"),
             (overlay_set_val, "$g_presentation_obj_custom_battle_designer_8", "$g_presentation_obj_custom_battle_designer_8_last_value"),
           (try_end),
           (assign, reg0, "$g_presentation_obj_custom_battle_designer_6_last_value"),
           (overlay_set_text, "$g_presentation_obj_custom_battle_designer_12", "str_reg0_percent"),
           (assign, reg0, "$g_presentation_obj_custom_battle_designer_7_last_value"),
           (overlay_set_text, "$g_presentation_obj_custom_battle_designer_13", "str_reg0_percent"),
           (assign, reg0, "$g_presentation_obj_custom_battle_designer_8_last_value"),
           (overlay_set_text, "$g_presentation_obj_custom_battle_designer_14", "str_reg0_percent"),
         (try_end),
       (else_try),
         (eq, ":object", "$g_presentation_obj_custom_battle_designer_8"),
           (try_begin),
             (eq, "$g_presentation_obj_custom_battle_designer_8_locked", 1),
             (neq, ":value", "$g_presentation_obj_custom_battle_designer_8_last_value"),
             (overlay_set_val, "$g_presentation_obj_custom_battle_designer_8", "$g_presentation_obj_custom_battle_designer_8_last_value"),
           (else_try),
           (try_begin),
             (lt, ":value", "$g_presentation_obj_custom_battle_designer_8_last_value"),
             (store_sub, ":dif", "$g_presentation_obj_custom_battle_designer_8_last_value", ":value"),
             (try_begin),
               (eq, "$g_presentation_obj_custom_battle_designer_7_locked", 1),
               (assign, ":first_dif", 0),
               (assign, ":second_dif", ":dif"),
             (else_try),
               (eq, "$g_presentation_obj_custom_battle_designer_6_locked", 1),
               (assign, ":first_dif", ":dif"),
               (assign, ":second_dif", 0),
             (else_try),
               (store_div, ":first_dif", ":dif", 2),
               (store_sub, ":second_dif", ":dif", ":first_dif"),
               (try_begin),
                 (neq, ":first_dif", ":second_dif"),
                 (store_random_in_range, ":random_no", 0, 2),
                 (eq, ":random_no", 0),
                 (val_sub, ":second_dif", 1),
                 (val_add, ":first_dif", 1),
               (try_end),
             (try_end),
             (assign, "$g_presentation_obj_custom_battle_designer_8_last_value", ":value"),
             (val_add, "$g_presentation_obj_custom_battle_designer_7_last_value", ":first_dif"),
             (val_add, "$g_presentation_obj_custom_battle_designer_6_last_value", ":second_dif"),
             (try_begin),
               (gt, "$g_presentation_obj_custom_battle_designer_7_last_value", 100),
               (store_sub, ":dif", "$g_presentation_obj_custom_battle_designer_7_last_value", 100),
               (val_add, "$g_presentation_obj_custom_battle_designer_6_last_value", ":dif"),
               (assign, "$g_presentation_obj_custom_battle_designer_7_last_value", 100),
             (else_try),
               (gt, "$g_presentation_obj_custom_battle_designer_6_last_value", 100),
               (store_sub, ":dif", "$g_presentation_obj_custom_battle_designer_6_last_value", 100),
               (val_add, "$g_presentation_obj_custom_battle_designer_7_last_value", ":dif"),
               (assign, "$g_presentation_obj_custom_battle_designer_6_last_value", 100),
             (try_end),
             (overlay_set_val, "$g_presentation_obj_custom_battle_designer_7", "$g_presentation_obj_custom_battle_designer_7_last_value"),
             (overlay_set_val, "$g_presentation_obj_custom_battle_designer_6", "$g_presentation_obj_custom_battle_designer_6_last_value"),
           (else_try),
             (gt, ":value", "$g_presentation_obj_custom_battle_designer_8_last_value"),
             (store_sub, ":dif", ":value", "$g_presentation_obj_custom_battle_designer_8_last_value"),
             (try_begin),
               (eq, "$g_presentation_obj_custom_battle_designer_7_locked", 1),
               (assign, ":first_dif", 0),
               (assign, ":second_dif", ":dif"),
             (else_try),
               (eq, "$g_presentation_obj_custom_battle_designer_6_locked", 1),
               (assign, ":first_dif", ":dif"),
               (assign, ":second_dif", 0),
             (else_try),
               (store_div, ":first_dif", ":dif", 2),
               (store_sub, ":second_dif", ":dif", ":first_dif"),
               (try_begin),
                 (neq, ":first_dif", ":second_dif"),
                 (store_random_in_range, ":random_no", 0, 2),
                 (eq, ":random_no", 0),
                 (val_sub, ":second_dif", 1),
                 (val_add, ":first_dif", 1),
               (try_end),
             (try_end),
             (assign, "$g_presentation_obj_custom_battle_designer_8_last_value", ":value"),
             (val_sub, "$g_presentation_obj_custom_battle_designer_7_last_value", ":first_dif"),
             (val_sub, "$g_presentation_obj_custom_battle_designer_6_last_value", ":second_dif"),
             (try_begin),
               (lt, "$g_presentation_obj_custom_battle_designer_7_last_value", 0),
               (val_add, "$g_presentation_obj_custom_battle_designer_6_last_value", "$g_presentation_obj_custom_battle_designer_7_last_value"),
               (assign, "$g_presentation_obj_custom_battle_designer_7_last_value", 0),
             (else_try),
               (lt, "$g_presentation_obj_custom_battle_designer_6_last_value", 0),
               (val_add, "$g_presentation_obj_custom_battle_designer_7_last_value", "$g_presentation_obj_custom_battle_designer_6_last_value"),
               (assign, "$g_presentation_obj_custom_battle_designer_6_last_value", 0),
             (try_end),
             (overlay_set_val, "$g_presentation_obj_custom_battle_designer_7", "$g_presentation_obj_custom_battle_designer_7_last_value"),
             (overlay_set_val, "$g_presentation_obj_custom_battle_designer_6", "$g_presentation_obj_custom_battle_designer_6_last_value"),
           (try_end),
           (assign, reg0, "$g_presentation_obj_custom_battle_designer_6_last_value"),
           (overlay_set_text, "$g_presentation_obj_custom_battle_designer_12", "str_reg0_percent"),
           (assign, reg0, "$g_presentation_obj_custom_battle_designer_7_last_value"),
           (overlay_set_text, "$g_presentation_obj_custom_battle_designer_13", "str_reg0_percent"),
           (assign, reg0, "$g_presentation_obj_custom_battle_designer_8_last_value"),
           (overlay_set_text, "$g_presentation_obj_custom_battle_designer_14", "str_reg0_percent"),
         (try_end),
       (else_try),
         (eq, ":object", "$g_presentation_obj_custom_battle_designer_9"),
         (try_begin),
           (eq, "$g_presentation_obj_custom_battle_designer_9_locked", 1),
           (neq, ":value", "$g_presentation_obj_custom_battle_designer_9_last_value"),
           (overlay_set_val, "$g_presentation_obj_custom_battle_designer_9", "$g_presentation_obj_custom_battle_designer_9_last_value"),
         (else_try),
           (try_begin),
             (lt, ":value", "$g_presentation_obj_custom_battle_designer_9_last_value"),
             (store_sub, ":dif", "$g_presentation_obj_custom_battle_designer_9_last_value", ":value"),
             (try_begin),
               (eq, "$g_presentation_obj_custom_battle_designer_10_locked", 1),
               (assign, ":first_dif", 0),
               (assign, ":second_dif", ":dif"),
             (else_try),
               (eq, "$g_presentation_obj_custom_battle_designer_11_locked", 1),
               (assign, ":first_dif", ":dif"),
               (assign, ":second_dif", 0),
             (else_try),
               (store_div, ":first_dif", ":dif", 2),
               (store_sub, ":second_dif", ":dif", ":first_dif"),
               (try_begin),
                 (neq, ":first_dif", ":second_dif"),
                 (store_random_in_range, ":random_no", 0, 2),
                 (eq, ":random_no", 0),
                 (val_sub, ":second_dif", 1),
                 (val_add, ":first_dif", 1),
               (try_end),
             (try_end),
             (assign, "$g_presentation_obj_custom_battle_designer_9_last_value", ":value"),
             (val_add, "$g_presentation_obj_custom_battle_designer_10_last_value", ":first_dif"),
             (val_add, "$g_presentation_obj_custom_battle_designer_11_last_value", ":second_dif"),
             (try_begin),
               (gt, "$g_presentation_obj_custom_battle_designer_10_last_value", 100),
               (store_sub, ":dif", "$g_presentation_obj_custom_battle_designer_10_last_value", 100),
               (val_add, "$g_presentation_obj_custom_battle_designer_11_last_value", ":dif"),
               (assign, "$g_presentation_obj_custom_battle_designer_10_last_value", 100),
             (else_try),
               (gt, "$g_presentation_obj_custom_battle_designer_11_last_value", 100),
               (store_sub, ":dif", "$g_presentation_obj_custom_battle_designer_11_last_value", 100),
               (val_add, "$g_presentation_obj_custom_battle_designer_10_last_value", ":dif"),
               (assign, "$g_presentation_obj_custom_battle_designer_11_last_value", 100),
             (try_end),
             (overlay_set_val, "$g_presentation_obj_custom_battle_designer_10", "$g_presentation_obj_custom_battle_designer_10_last_value"),
             (overlay_set_val, "$g_presentation_obj_custom_battle_designer_11", "$g_presentation_obj_custom_battle_designer_11_last_value"),
           (else_try),
             (gt, ":value", "$g_presentation_obj_custom_battle_designer_9_last_value"),
             (store_sub, ":dif", ":value", "$g_presentation_obj_custom_battle_designer_9_last_value"),
             (try_begin),
               (eq, "$g_presentation_obj_custom_battle_designer_10_locked", 1),
               (assign, ":first_dif", 0),
               (assign, ":second_dif", ":dif"),
             (else_try),
               (eq, "$g_presentation_obj_custom_battle_designer_11_locked", 1),
               (assign, ":first_dif", ":dif"),
               (assign, ":second_dif", 0),
             (else_try),
               (store_div, ":first_dif", ":dif", 2),
               (store_sub, ":second_dif", ":dif", ":first_dif"),
               (try_begin),
                 (neq, ":first_dif", ":second_dif"),
                 (store_random_in_range, ":random_no", 0, 2),
                 (eq, ":random_no", 0),
                 (val_sub, ":second_dif", 1),
                 (val_add, ":first_dif", 1),
               (try_end),
             (try_end),
             (assign, "$g_presentation_obj_custom_battle_designer_9_last_value", ":value"),
             (val_sub, "$g_presentation_obj_custom_battle_designer_10_last_value", ":first_dif"),
             (val_sub, "$g_presentation_obj_custom_battle_designer_11_last_value", ":second_dif"),
             (try_begin),
               (lt, "$g_presentation_obj_custom_battle_designer_10_last_value", 0),
               (val_add, "$g_presentation_obj_custom_battle_designer_11_last_value", "$g_presentation_obj_custom_battle_designer_10_last_value"),
               (assign, "$g_presentation_obj_custom_battle_designer_10_last_value", 0),
             (else_try),
               (lt, "$g_presentation_obj_custom_battle_designer_11_last_value", 0),
               (val_add, "$g_presentation_obj_custom_battle_designer_10_last_value", "$g_presentation_obj_custom_battle_designer_11_last_value"),
               (assign, "$g_presentation_obj_custom_battle_designer_11_last_value", 0),
             (try_end),
             (overlay_set_val, "$g_presentation_obj_custom_battle_designer_10", "$g_presentation_obj_custom_battle_designer_10_last_value"),
             (overlay_set_val, "$g_presentation_obj_custom_battle_designer_11", "$g_presentation_obj_custom_battle_designer_11_last_value"),
           (try_end),
           (assign, reg0, "$g_presentation_obj_custom_battle_designer_9_last_value"),
           (overlay_set_text, "$g_presentation_obj_custom_battle_designer_15", "str_reg0_percent"),
           (assign, reg0, "$g_presentation_obj_custom_battle_designer_10_last_value"),
           (overlay_set_text, "$g_presentation_obj_custom_battle_designer_16", "str_reg0_percent"),
           (assign, reg0, "$g_presentation_obj_custom_battle_designer_11_last_value"),
           (overlay_set_text, "$g_presentation_obj_custom_battle_designer_17", "str_reg0_percent"),
         (try_end),
       (else_try),
         (eq, ":object", "$g_presentation_obj_custom_battle_designer_10"),
         (try_begin),
           (eq, "$g_presentation_obj_custom_battle_designer_10_locked", 1),
           (neq, ":value", "$g_presentation_obj_custom_battle_designer_10_last_value"),
           (overlay_set_val, "$g_presentation_obj_custom_battle_designer_10", "$g_presentation_obj_custom_battle_designer_10_last_value"),
         (else_try),
           (try_begin),
             (lt, ":value", "$g_presentation_obj_custom_battle_designer_10_last_value"),
             (store_sub, ":dif", "$g_presentation_obj_custom_battle_designer_10_last_value", ":value"),
             (try_begin),
               (eq, "$g_presentation_obj_custom_battle_designer_9_locked", 1),
               (assign, ":first_dif", 0),
               (assign, ":second_dif", ":dif"),
             (else_try),
               (eq, "$g_presentation_obj_custom_battle_designer_11_locked", 1),
               (assign, ":first_dif", ":dif"),
               (assign, ":second_dif", 0),
             (else_try),
               (store_div, ":first_dif", ":dif", 2),
               (store_sub, ":second_dif", ":dif", ":first_dif"),
               (try_begin),
                 (neq, ":first_dif", ":second_dif"),
                 (store_random_in_range, ":random_no", 0, 2),
                 (eq, ":random_no", 0),
                 (val_sub, ":second_dif", 1),
                 (val_add, ":first_dif", 1),
               (try_end),
             (try_end),
             (assign, "$g_presentation_obj_custom_battle_designer_10_last_value", ":value"),
             (val_add, "$g_presentation_obj_custom_battle_designer_9_last_value", ":first_dif"),
             (val_add, "$g_presentation_obj_custom_battle_designer_11_last_value", ":second_dif"),
             (try_begin),
               (gt, "$g_presentation_obj_custom_battle_designer_9_last_value", 100),
               (store_sub, ":dif", "$g_presentation_obj_custom_battle_designer_9_last_value", 100),
               (val_add, "$g_presentation_obj_custom_battle_designer_11_last_value", ":dif"),
               (assign, "$g_presentation_obj_custom_battle_designer_9_last_value", 100),
             (else_try),
               (gt, "$g_presentation_obj_custom_battle_designer_11_last_value", 100),
               (store_sub, ":dif", "$g_presentation_obj_custom_battle_designer_11_last_value", 100),
               (val_add, "$g_presentation_obj_custom_battle_designer_9_last_value", ":dif"),
               (assign, "$g_presentation_obj_custom_battle_designer_11_last_value", 100),
             (try_end),
             (overlay_set_val, "$g_presentation_obj_custom_battle_designer_9", "$g_presentation_obj_custom_battle_designer_9_last_value"),
             (overlay_set_val, "$g_presentation_obj_custom_battle_designer_11", "$g_presentation_obj_custom_battle_designer_11_last_value"),
           (else_try),
             (gt, ":value", "$g_presentation_obj_custom_battle_designer_10_last_value"),
             (store_sub, ":dif", ":value", "$g_presentation_obj_custom_battle_designer_10_last_value"),
             (try_begin),
               (eq, "$g_presentation_obj_custom_battle_designer_9_locked", 1),
               (assign, ":first_dif", 0),
               (assign, ":second_dif", ":dif"),
             (else_try),
               (eq, "$g_presentation_obj_custom_battle_designer_11_locked", 1),
               (assign, ":first_dif", ":dif"),
               (assign, ":second_dif", 0),
             (else_try),
               (store_div, ":first_dif", ":dif", 2),
               (store_sub, ":second_dif", ":dif", ":first_dif"),
               (try_begin),
                 (neq, ":first_dif", ":second_dif"),
                 (store_random_in_range, ":random_no", 0, 2),
                 (eq, ":random_no", 0),
                 (val_sub, ":second_dif", 1),
                 (val_add, ":first_dif", 1),
               (try_end),
             (try_end),
             (assign, "$g_presentation_obj_custom_battle_designer_10_last_value", ":value"),
             (val_sub, "$g_presentation_obj_custom_battle_designer_9_last_value", ":first_dif"),
             (val_sub, "$g_presentation_obj_custom_battle_designer_11_last_value", ":second_dif"),
             (try_begin),
               (lt, "$g_presentation_obj_custom_battle_designer_9_last_value", 0),
               (val_add, "$g_presentation_obj_custom_battle_designer_11_last_value", "$g_presentation_obj_custom_battle_designer_9_last_value"),
               (assign, "$g_presentation_obj_custom_battle_designer_9_last_value", 0),
             (else_try),
               (lt, "$g_presentation_obj_custom_battle_designer_11_last_value", 0),
               (val_add, "$g_presentation_obj_custom_battle_designer_9_last_value", "$g_presentation_obj_custom_battle_designer_11_last_value"),
               (assign, "$g_presentation_obj_custom_battle_designer_11_last_value", 0),
             (try_end),
             (overlay_set_val, "$g_presentation_obj_custom_battle_designer_9", "$g_presentation_obj_custom_battle_designer_9_last_value"),
             (overlay_set_val, "$g_presentation_obj_custom_battle_designer_11", "$g_presentation_obj_custom_battle_designer_11_last_value"),
           (try_end),
           (assign, reg0, "$g_presentation_obj_custom_battle_designer_9_last_value"),
           (overlay_set_text, "$g_presentation_obj_custom_battle_designer_15", "str_reg0_percent"),
           (assign, reg0, "$g_presentation_obj_custom_battle_designer_10_last_value"),
           (overlay_set_text, "$g_presentation_obj_custom_battle_designer_16", "str_reg0_percent"),
           (assign, reg0, "$g_presentation_obj_custom_battle_designer_11_last_value"),
           (overlay_set_text, "$g_presentation_obj_custom_battle_designer_17", "str_reg0_percent"),
         (try_end),
       (else_try),
         (eq, ":object", "$g_presentation_obj_custom_battle_designer_11"),
         (try_begin),
           (eq, "$g_presentation_obj_custom_battle_designer_11_locked", 1),
           (neq, ":value", "$g_presentation_obj_custom_battle_designer_11_last_value"),
           (overlay_set_val, "$g_presentation_obj_custom_battle_designer_11", "$g_presentation_obj_custom_battle_designer_11_last_value"),
         (else_try),
           (try_begin),
             (lt, ":value", "$g_presentation_obj_custom_battle_designer_11_last_value"),
             (store_sub, ":dif", "$g_presentation_obj_custom_battle_designer_11_last_value", ":value"),
             (try_begin),
               (eq, "$g_presentation_obj_custom_battle_designer_10_locked", 1),
               (assign, ":first_dif", 0),
               (assign, ":second_dif", ":dif"),
             (else_try),
               (eq, "$g_presentation_obj_custom_battle_designer_9_locked", 1),
               (assign, ":first_dif", ":dif"),
               (assign, ":second_dif", 0),
             (else_try),
               (store_div, ":first_dif", ":dif", 2),
               (store_sub, ":second_dif", ":dif", ":first_dif"),
               (try_begin),
                 (neq, ":first_dif", ":second_dif"),
                 (store_random_in_range, ":random_no", 0, 2),
                 (eq, ":random_no", 0),
                 (val_sub, ":second_dif", 1),
                 (val_add, ":first_dif", 1),
               (try_end),
             (try_end),
             (assign, "$g_presentation_obj_custom_battle_designer_11_last_value", ":value"),
             (val_add, "$g_presentation_obj_custom_battle_designer_10_last_value", ":first_dif"),
             (val_add, "$g_presentation_obj_custom_battle_designer_9_last_value", ":second_dif"),
             (try_begin),
               (gt, "$g_presentation_obj_custom_battle_designer_10_last_value", 100),
               (store_sub, ":dif", "$g_presentation_obj_custom_battle_designer_10_last_value", 100),
               (val_add, "$g_presentation_obj_custom_battle_designer_9_last_value", ":dif"),
               (assign, "$g_presentation_obj_custom_battle_designer_10_last_value", 100),
             (else_try),
               (gt, "$g_presentation_obj_custom_battle_designer_9_last_value", 100),
               (store_sub, ":dif", "$g_presentation_obj_custom_battle_designer_9_last_value", 100),
               (val_add, "$g_presentation_obj_custom_battle_designer_10_last_value", ":dif"),
               (assign, "$g_presentation_obj_custom_battle_designer_9_last_value", 100),
             (try_end),
             (overlay_set_val, "$g_presentation_obj_custom_battle_designer_10", "$g_presentation_obj_custom_battle_designer_10_last_value"),
             (overlay_set_val, "$g_presentation_obj_custom_battle_designer_9", "$g_presentation_obj_custom_battle_designer_9_last_value"),
           (else_try),
             (gt, ":value", "$g_presentation_obj_custom_battle_designer_11_last_value"),
             (store_sub, ":dif", ":value", "$g_presentation_obj_custom_battle_designer_11_last_value"),
             (try_begin),
               (eq, "$g_presentation_obj_custom_battle_designer_10_locked", 1),
               (assign, ":first_dif", 0),
               (assign, ":second_dif", ":dif"),
             (else_try),
               (eq, "$g_presentation_obj_custom_battle_designer_9_locked", 1),
               (assign, ":first_dif", ":dif"),
               (assign, ":second_dif", 0),
             (else_try),
               (store_div, ":first_dif", ":dif", 2),
               (store_sub, ":second_dif", ":dif", ":first_dif"),
               (try_begin),
                 (neq, ":first_dif", ":second_dif"),
                 (store_random_in_range, ":random_no", 0, 2),
                 (eq, ":random_no", 0),
                 (val_sub, ":second_dif", 1),
                 (val_add, ":first_dif", 1),
               (try_end),
             (try_end),
             (assign, "$g_presentation_obj_custom_battle_designer_11_last_value", ":value"),
             (val_sub, "$g_presentation_obj_custom_battle_designer_10_last_value", ":first_dif"),
             (val_sub, "$g_presentation_obj_custom_battle_designer_9_last_value", ":second_dif"),
             (try_begin),
               (lt, "$g_presentation_obj_custom_battle_designer_10_last_value", 0),
               (val_add, "$g_presentation_obj_custom_battle_designer_9_last_value", "$g_presentation_obj_custom_battle_designer_10_last_value"),
               (assign, "$g_presentation_obj_custom_battle_designer_10_last_value", 0),
             (else_try),
               (lt, "$g_presentation_obj_custom_battle_designer_9_last_value", 0),
               (val_add, "$g_presentation_obj_custom_battle_designer_10_last_value", "$g_presentation_obj_custom_battle_designer_9_last_value"),
               (assign, "$g_presentation_obj_custom_battle_designer_9_last_value", 0),
             (try_end),
             (overlay_set_val, "$g_presentation_obj_custom_battle_designer_10", "$g_presentation_obj_custom_battle_designer_10_last_value"),
             (overlay_set_val, "$g_presentation_obj_custom_battle_designer_9", "$g_presentation_obj_custom_battle_designer_9_last_value"),
           (try_end),
           (assign, reg0, "$g_presentation_obj_custom_battle_designer_9_last_value"),
           (overlay_set_text, "$g_presentation_obj_custom_battle_designer_15", "str_reg0_percent"),
           (assign, reg0, "$g_presentation_obj_custom_battle_designer_10_last_value"),
           (overlay_set_text, "$g_presentation_obj_custom_battle_designer_16", "str_reg0_percent"),
           (assign, reg0, "$g_presentation_obj_custom_battle_designer_11_last_value"),
           (overlay_set_text, "$g_presentation_obj_custom_battle_designer_17", "str_reg0_percent"),
         (try_end),
       (else_try),
         (eq, ":object", "$g_presentation_obj_custom_battle_designer_19"),
         (assign, "$g_is_quick_battle", 1),
         (assign, ":cur_scene", "$g_quick_battle_map"),
         (try_begin),
           (eq, "$g_quick_battle_game_type", 0), #battle
           (assign, ":cur_mission_template", "mt_quick_battle_battle"),
           (modify_visitors_at_site, ":cur_scene"),
           (call_script, "script_spawn_quick_battle_army", 0, "$g_quick_battle_team_1_faction", "$g_presentation_obj_custom_battle_designer_6_last_value", "$g_presentation_obj_custom_battle_designer_7_last_value", "$g_presentation_obj_custom_battle_designer_8_last_value", 0, 1),
           (call_script, "script_spawn_quick_battle_army", 16, "$g_quick_battle_team_2_faction", "$g_presentation_obj_custom_battle_designer_9_last_value", "$g_presentation_obj_custom_battle_designer_10_last_value", "$g_presentation_obj_custom_battle_designer_11_last_value", 0, 0),
         (else_try),
           (eq, "$g_quick_battle_game_type", 1), #siege offense
           (assign, ":cur_mission_template", "mt_quick_battle_siege"),
           (modify_visitors_at_site, ":cur_scene"),
           (call_script, "script_spawn_quick_battle_army", 16, "$g_quick_battle_team_1_faction", "$g_presentation_obj_custom_battle_designer_6_last_value", "$g_presentation_obj_custom_battle_designer_7_last_value", "$g_presentation_obj_custom_battle_designer_8_last_value", 0, 1),
           (call_script, "script_spawn_quick_battle_army", 0, "$g_quick_battle_team_2_faction", "$g_presentation_obj_custom_battle_designer_9_last_value", "$g_presentation_obj_custom_battle_designer_10_last_value", "$g_presentation_obj_custom_battle_designer_11_last_value", 1, 0),
         (else_try),
           #siege defense
           (assign, ":cur_mission_template", "mt_quick_battle_siege"),
           (modify_visitors_at_site, ":cur_scene"),
           (call_script, "script_spawn_quick_battle_army", 0, "$g_quick_battle_team_1_faction", "$g_presentation_obj_custom_battle_designer_6_last_value", "$g_presentation_obj_custom_battle_designer_7_last_value", "$g_presentation_obj_custom_battle_designer_8_last_value", 1, 1),
           (call_script, "script_spawn_quick_battle_army", 16, "$g_quick_battle_team_2_faction", "$g_presentation_obj_custom_battle_designer_9_last_value", "$g_presentation_obj_custom_battle_designer_10_last_value", "$g_presentation_obj_custom_battle_designer_11_last_value", 0, 0),
         (try_end),
         (set_jump_mission,":cur_mission_template"),
         (jump_to_menu, "mnu_custom_battle_end"),
         (jump_to_scene, ":cur_scene"),
         (change_screen_mission),
         (presentation_set_duration, 0),
       (else_try),
         (eq, ":object", "$g_presentation_obj_custom_battle_designer_20"),
         (presentation_set_duration, 0),
       (try_end),
      ]),
    (ti_on_presentation_mouse_enter_leave,
     [
       (store_trigger_param_1, ":object"),
       (store_trigger_param_2, ":enter_leave"),
       (this_or_next|eq, ":object", "$g_presentation_obj_custom_battle_designer_6"),
       (this_or_next|eq, ":object", "$g_presentation_obj_custom_battle_designer_7"),
       (this_or_next|eq, ":object", "$g_presentation_obj_custom_battle_designer_8"),
       (this_or_next|eq, ":object", "$g_presentation_obj_custom_battle_designer_9"),
       (this_or_next|eq, ":object", "$g_presentation_obj_custom_battle_designer_10"),
       (eq, ":object", "$g_presentation_obj_custom_battle_designer_11"),
       (try_begin),
         (eq, ":enter_leave", 1),
         (try_begin),
           (eq, ":object", "$g_presentation_obj_custom_battle_last_mouse_over_object"),
           (assign, "$g_presentation_obj_custom_battle_last_mouse_over_object", -1),
         (try_end),
       (else_try),
         (assign, "$g_presentation_obj_custom_battle_last_mouse_over_object", ":object"),
       (try_end),
       ]),
    (ti_on_presentation_run,
     [
      (try_begin),
        (this_or_next|key_clicked, key_escape),
		(key_clicked, key_xbox_start),
        (presentation_set_duration, 0),
      (else_try),
        (key_clicked, key_right_mouse_button),
        (neq, "$g_presentation_obj_custom_battle_last_mouse_over_object", -1),
        (try_begin),
          (eq, "$g_presentation_obj_custom_battle_last_mouse_over_object", "$g_presentation_obj_custom_battle_designer_6"),
          (try_begin),
            (eq, "$g_presentation_obj_custom_battle_designer_6_locked", 0),
            (assign, "$g_presentation_obj_custom_battle_designer_6_locked", 1),
            (assign, "$g_presentation_obj_custom_battle_designer_7_locked", 0),
            (assign, "$g_presentation_obj_custom_battle_designer_8_locked", 0),
          (else_try),
            (assign, "$g_presentation_obj_custom_battle_designer_6_locked", 0),
          (try_end),
        (else_try),
          (eq, "$g_presentation_obj_custom_battle_last_mouse_over_object", "$g_presentation_obj_custom_battle_designer_7"),
          (try_begin),
            (eq, "$g_presentation_obj_custom_battle_designer_7_locked", 0),
            (assign, "$g_presentation_obj_custom_battle_designer_6_locked", 0),
            (assign, "$g_presentation_obj_custom_battle_designer_7_locked", 1),
            (assign, "$g_presentation_obj_custom_battle_designer_8_locked", 0),
          (else_try),
            (assign, "$g_presentation_obj_custom_battle_designer_7_locked", 0),
          (try_end),
        (else_try),
          (eq, "$g_presentation_obj_custom_battle_last_mouse_over_object", "$g_presentation_obj_custom_battle_designer_8"),
          (try_begin),
            (eq, "$g_presentation_obj_custom_battle_designer_8_locked", 0),
            (assign, "$g_presentation_obj_custom_battle_designer_6_locked", 0),
            (assign, "$g_presentation_obj_custom_battle_designer_7_locked", 0),
            (assign, "$g_presentation_obj_custom_battle_designer_8_locked", 1),
          (else_try),
            (assign, "$g_presentation_obj_custom_battle_designer_8_locked", 0),
          (try_end),
        (else_try),
          (eq, "$g_presentation_obj_custom_battle_last_mouse_over_object", "$g_presentation_obj_custom_battle_designer_9"),
          (try_begin),
            (eq, "$g_presentation_obj_custom_battle_designer_9_locked", 0),
            (assign, "$g_presentation_obj_custom_battle_designer_9_locked", 1),
            (assign, "$g_presentation_obj_custom_battle_designer_10_locked", 0),
            (assign, "$g_presentation_obj_custom_battle_designer_11_locked", 0),
          (else_try),
            (assign, "$g_presentation_obj_custom_battle_designer_9_locked", 0),
          (try_end),
        (else_try),
          (eq, "$g_presentation_obj_custom_battle_last_mouse_over_object", "$g_presentation_obj_custom_battle_designer_10"),
          (try_begin),
            (eq, "$g_presentation_obj_custom_battle_designer_10_locked", 0),
            (assign, "$g_presentation_obj_custom_battle_designer_9_locked", 0),
            (assign, "$g_presentation_obj_custom_battle_designer_10_locked", 1),
            (assign, "$g_presentation_obj_custom_battle_designer_11_locked", 0),
          (else_try),
            (assign, "$g_presentation_obj_custom_battle_designer_10_locked", 0),
          (try_end),
        (else_try),
          (eq, "$g_presentation_obj_custom_battle_last_mouse_over_object", "$g_presentation_obj_custom_battle_designer_11"),
          (try_begin),
            (eq, "$g_presentation_obj_custom_battle_designer_11_locked", 0),
            (assign, "$g_presentation_obj_custom_battle_designer_9_locked", 0),
            (assign, "$g_presentation_obj_custom_battle_designer_10_locked", 0),
            (assign, "$g_presentation_obj_custom_battle_designer_11_locked", 1),
          (else_try),
            (assign, "$g_presentation_obj_custom_battle_designer_11_locked", 0),
          (try_end),
        (try_end),
      (try_end),
      ]),
    ]),

  ("game_multiplayer_admin_panel", prsntf_manual_end_only, 0, [
    (ti_on_presentation_load,
     [(set_fixed_point_multiplier, 1000),

      (try_begin),
        (eq, "$g_multiplayer_selected_map", "scn_multi_scene_1"),
        (assign, ":map_image", "mesh_mp_ui_host_maps_1"),
      (else_try),
        (eq, "$g_multiplayer_selected_map", "scn_multi_scene_2"),
        (assign, ":map_image", "mesh_mp_ui_host_maps_2"),
      (else_try),
        (eq, "$g_multiplayer_selected_map", "scn_multi_scene_3"),
        (assign, ":map_image", "mesh_mp_ui_host_maps_3"),
      (else_try),
        (eq, "$g_multiplayer_selected_map", "scn_multi_scene_4"),
        (assign, ":map_image", "mesh_mp_ui_host_maps_4"),
      (else_try),
        (eq, "$g_multiplayer_selected_map", "scn_multi_scene_5"),
        (assign, ":map_image", "mesh_mp_ui_host_maps_5"),
      (else_try),
        (eq, "$g_multiplayer_selected_map", "scn_multi_scene_6"),
        (assign, ":map_image", "mesh_mp_ui_host_maps_6"),
      (else_try),
        (eq, "$g_multiplayer_selected_map", "scn_multi_scene_7"),
        (assign, ":map_image", "mesh_mp_ui_host_maps_7"),
      (else_try),
        (eq, "$g_multiplayer_selected_map", "scn_multi_scene_8"),
        (assign, ":map_image", "mesh_mp_ui_host_maps_8"),
      (else_try),
        (eq, "$g_multiplayer_selected_map", "scn_multi_scene_9"),
        (assign, ":map_image", "mesh_mp_ui_host_maps_9"),
      (else_try),
        (eq, "$g_multiplayer_selected_map", "scn_multi_scene_10"),
        (assign, ":map_image", "mesh_mp_ui_host_maps_10"),
      (else_try),
        (eq, "$g_multiplayer_selected_map", "scn_multi_scene_11"),
        (assign, ":map_image", "mesh_mp_ui_host_maps_11"),
      (else_try),
        (eq, "$g_multiplayer_selected_map", "scn_multi_scene_12"),
        (assign, ":map_image", "mesh_mp_ui_host_maps_12"),
      (else_try),
        (eq, "$g_multiplayer_selected_map", "scn_multi_scene_13"),
        (assign, ":map_image", "mesh_mp_ui_host_maps_13"),
      (else_try),
        (eq, "$g_multiplayer_selected_map", "scn_multi_scene_14"),
        (assign, ":map_image", "mesh_mp_ui_host_maps_14"),
      (else_try),
        (eq, "$g_multiplayer_selected_map", "scn_multi_scene_15"),
        (assign, ":map_image", "mesh_mp_ui_host_maps_15"),
      (else_try),
        (eq, "$g_multiplayer_selected_map", "scn_multi_scene_16"),
        (assign, ":map_image", "mesh_mp_ui_host_maps_16"),
      (else_try),
        (eq, "$g_multiplayer_selected_map", "scn_multi_scene_17"),
        (assign, ":map_image", "mesh_mp_ui_host_maps_17"),
      (else_try),
        (eq, "$g_multiplayer_selected_map", "scn_multi_scene_18"),
        (assign, ":map_image", "mesh_mp_ui_host_maps_18"),
      (else_try),
        (eq, "$g_multiplayer_selected_map", "scn_multi_scene_19"),
        (assign, ":map_image", "mesh_mp_ui_host_maps_19"),
      (else_try),
        (eq, "$g_multiplayer_selected_map", "scn_multi_scene_20"),
        (assign, ":map_image", "mesh_mp_ui_host_maps_20"),
      (else_try),
        (this_or_next|eq, "$g_multiplayer_selected_map", "scn_random_multi_plain_medium"),
        (eq, "$g_multiplayer_selected_map", "scn_random_multi_plain_large"),
        (assign, ":map_image", "mesh_mp_ui_host_maps_randomp"),
      (else_try),
        (this_or_next|eq, "$g_multiplayer_selected_map", "scn_random_multi_steppe_medium"),
        (eq, "$g_multiplayer_selected_map", "scn_random_multi_steppe_large"),
        (assign, ":map_image", "mesh_mp_ui_host_maps_randoms"),
      (else_try),
        (assign, ":map_image", "mesh_mp_ui_host_maps_randomp"),
      (try_end),
      
      (create_mesh_overlay, reg0, ":map_image"),
      (position_set_x, pos1, -1),
      (position_set_y, pos1, 550),
      (overlay_set_position, reg0, pos1),
      (position_set_x, pos1, 1002),
      (position_set_y, pos1, 1002),
      (overlay_set_size, reg0, pos1),

      (create_mesh_overlay, reg0, "mesh_mp_ui_host_main"),
      (position_set_x, pos1, -1),
      (position_set_y, pos1, -1),
      (overlay_set_position, reg0, pos1),
      (position_set_x, pos1, 1002),
      (position_set_y, pos1, 1002),
      (overlay_set_size, reg0, pos1),

      (assign, ":cur_y", 1240),
      (assign, ":cur_y_adder", 40),

      (try_begin),
        (this_or_next|eq, "$g_multiplayer_game_type", multiplayer_game_type_team_deathmatch),
        (this_or_next|eq, "$g_multiplayer_game_type", multiplayer_game_type_battle),
        (this_or_next|eq, "$g_multiplayer_game_type", multiplayer_game_type_destroy),
        (this_or_next|eq, "$g_multiplayer_game_type", multiplayer_game_type_capture_the_flag),
        (this_or_next|eq, "$g_multiplayer_game_type", multiplayer_game_type_headquarters),
        (eq, "$g_multiplayer_game_type", multiplayer_game_type_siege),
        (val_add, ":cur_y", ":cur_y_adder"), #two more options for these mods (friendly fire options)
        (val_add, ":cur_y", ":cur_y_adder"),
        (this_or_next|eq, "$g_multiplayer_game_type", multiplayer_game_type_capture_the_flag),
        (this_or_next|eq, "$g_multiplayer_game_type", multiplayer_game_type_battle),
        (this_or_next|eq, "$g_multiplayer_game_type", multiplayer_game_type_destroy),
        (eq, "$g_multiplayer_game_type", multiplayer_game_type_siege),
        (val_add, ":cur_y", ":cur_y_adder"), #one more option for these mods
        (this_or_next|eq, "$g_multiplayer_game_type", multiplayer_game_type_battle),
        (this_or_next|eq, "$g_multiplayer_game_type", multiplayer_game_type_destroy),
        (eq, "$g_multiplayer_game_type", multiplayer_game_type_siege),
        (val_add, ":cur_y", ":cur_y_adder"), #one more option for these mods
        (this_or_next|eq, "$g_multiplayer_game_type", multiplayer_game_type_battle),
        (this_or_next|eq, "$g_multiplayer_game_type", multiplayer_game_type_destroy),
        (eq, "$g_multiplayer_game_type", multiplayer_game_type_siege),
        (val_add, ":cur_y", ":cur_y_adder"), #one more option for these mods
      (try_end),

      (str_clear, s0),
      (create_text_overlay, "$g_presentation_obj_admin_panel_container", s0, tf_scrollable),
      (position_set_x, pos1, 59),
      (position_set_y, pos1, 50),
      (overlay_set_position, "$g_presentation_obj_admin_panel_container", pos1),
      (position_set_x, pos1, 640),
      (position_set_y, pos1, 520),
      (overlay_set_area_size, "$g_presentation_obj_admin_panel_container", pos1),
      (set_container_overlay, "$g_presentation_obj_admin_panel_container"),


      (create_text_overlay, reg0, "str_add_to_official_game_servers_list", 0),
      (position_set_x, pos1, 30),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_check_box_overlay, "$g_presentation_obj_admin_panel_14", "mesh_checkbox_off", "mesh_checkbox_on"),
      (position_set_x, pos1, 7),
      (store_add, ":special_cur_y", ":cur_y", 7),
      (position_set_y, pos1, ":special_cur_y"),
      (overlay_set_position, "$g_presentation_obj_admin_panel_14", pos1),
      (server_get_add_to_game_servers_list, ":add_to_servers_list"),
      (overlay_set_val, "$g_presentation_obj_admin_panel_14", ":add_to_servers_list"),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_text_overlay, reg0, "str_enable_valve_anti_cheat", 0),
      (position_set_x, pos1, 30),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_check_box_overlay, "$g_presentation_obj_admin_panel_41", "mesh_checkbox_off", "mesh_checkbox_on"),
      (position_set_x, pos1, 7),
      (store_add, ":special_cur_y", ":cur_y", 7),
      (position_set_y, pos1, ":special_cur_y"),
      (overlay_set_position, "$g_presentation_obj_admin_panel_41", pos1),
      (server_get_anti_cheat, ":server_anti_cheat"),
      (overlay_set_val, "$g_presentation_obj_admin_panel_41", ":server_anti_cheat"),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_text_overlay, reg0, "str_server_name", 0),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (str_store_server_name, s0),
      (try_begin),
        (eq, "$g_multiplayer_renaming_server_allowed", 1),
        (create_simple_text_box_overlay, "$g_presentation_obj_admin_panel_20"),
        (position_set_x, pos1, 390),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, "$g_presentation_obj_admin_panel_20", pos1),
        (overlay_set_text, "$g_presentation_obj_admin_panel_20", s0),
      (else_try),
        (assign, "$g_presentation_obj_admin_panel_20", -1),
        (create_text_overlay, reg0, s0, 0),
        (position_set_x, pos1, 385),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg0, pos1),
      (try_end),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_text_overlay, reg0, "str_game_password", 0),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_simple_text_box_overlay, "$g_presentation_obj_admin_panel_9"),
      (position_set_x, pos1, 390),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_admin_panel_9", pos1),
      (str_store_server_password, s0),
      (overlay_set_text, "$g_presentation_obj_admin_panel_9", s0),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_text_overlay, reg0, "str_welcome_message", 0),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_simple_text_box_overlay, "$g_presentation_obj_admin_panel_32"),
      (position_set_x, pos1, 390),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_admin_panel_32", pos1),
      (str_store_welcome_message, s0),
      (overlay_set_text, "$g_presentation_obj_admin_panel_32", s0),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_text_overlay, reg0, "str_map", 0),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (call_script, "script_multiplayer_fill_map_game_types", "$g_multiplayer_game_type"),
      (assign, ":num_maps", reg0),
      (assign, ":selected_index", 0),

      (try_begin),
        (gt, ":num_maps", 12),
        (create_combo_label_overlay, "$g_presentation_obj_admin_panel_1"),
      (else_try),
        (create_combo_button_overlay, "$g_presentation_obj_admin_panel_1"),
      (try_end),
      (position_set_x, pos1, 800),
      (position_set_y, pos1, 800),
      (overlay_set_size, "$g_presentation_obj_admin_panel_1", pos1),
      (try_begin),
        (gt, ":num_maps", 14),
        (position_set_x, pos1, 465),
      (else_try),
        (position_set_x, pos1, 490),
      (try_end),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_admin_panel_1", pos1),
      (troop_get_slot, ":first_map", "trp_multiplayer_data", multi_data_maps_for_game_type_begin),
      (assign, ":selected_map_available", 0),
      (try_for_range, ":i_map", 0, ":num_maps"),
        (store_add, ":map_slot", ":i_map", multi_data_maps_for_game_type_begin),
        (troop_get_slot, ":map_no", "trp_multiplayer_data", ":map_slot"),
        (store_sub, ":string_index", ":map_no", multiplayer_scenes_begin),
        (val_add, ":string_index", multiplayer_scene_names_begin),
        (str_store_string, s0, ":string_index"),
        (overlay_add_item, "$g_presentation_obj_admin_panel_1", s0),
        (try_begin),
          (eq, ":map_no", "$g_multiplayer_selected_map"),
          (assign, ":selected_index", ":i_map"),
          (assign, ":selected_map_available", 1),
        (try_end),
      (try_end),
      (overlay_set_val, "$g_presentation_obj_admin_panel_1", ":selected_index"),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_text_overlay, reg0, "str_game_type", 0),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (try_begin),
        (eq, "$g_multiplayer_changing_game_type_allowed", 1),
        (create_combo_button_overlay, "$g_presentation_obj_admin_panel_10"),
        (position_set_x, pos1, 800),
        (position_set_y, pos1, 800),
        (overlay_set_size, "$g_presentation_obj_admin_panel_10", pos1),
        (position_set_x, pos1, 490),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, "$g_presentation_obj_admin_panel_10", pos1),
        (try_for_range, ":i_game_type", 0, multiplayer_num_game_types),
          (store_add, ":string_index", ":i_game_type", multiplayer_game_type_names_begin),
          (str_store_string, s0, ":string_index"),
          (overlay_add_item, "$g_presentation_obj_admin_panel_10", s0),
        (try_end),
        (overlay_set_val, "$g_presentation_obj_admin_panel_10", "$g_multiplayer_game_type"),
      (else_try),
        (assign, "$g_presentation_obj_admin_panel_10", -1),
        (store_add, ":string_index", "$g_multiplayer_game_type", multiplayer_game_type_names_begin),
        (str_store_string, s0, ":string_index"),
        (create_text_overlay, reg0, s0, 0),
        (position_set_x, pos1, 385),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg0, pos1),
      (try_end),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (assign, reg1, 1),
      (create_text_overlay, reg0, "str_team_reg1_faction", 0),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_combo_button_overlay, "$g_presentation_obj_admin_panel_11"),
      (position_set_x, pos1, 800),
      (position_set_y, pos1, 800),
      (overlay_set_size, "$g_presentation_obj_admin_panel_11", pos1),
      (position_set_x, pos1, 490),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_admin_panel_11", pos1),
      (call_script, "script_multiplayer_fill_available_factions_combo_button", "$g_presentation_obj_admin_panel_11", "$g_multiplayer_next_team_1_faction", "$g_multiplayer_next_team_2_faction"),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (assign, reg1, 2),
      (create_text_overlay, reg0, "str_team_reg1_faction", 0),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_combo_button_overlay, "$g_presentation_obj_admin_panel_12"),
      (position_set_x, pos1, 800),
      (position_set_y, pos1, 800),
      (overlay_set_size, "$g_presentation_obj_admin_panel_12", pos1),
      (position_set_x, pos1, 490),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_admin_panel_12", pos1),
      (call_script, "script_multiplayer_fill_available_factions_combo_button", "$g_presentation_obj_admin_panel_12", "$g_multiplayer_next_team_2_faction", "$g_multiplayer_next_team_1_faction"),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (assign, reg1, 1),
      (create_text_overlay, reg0, "str_max_number_of_players", 0),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_number_box_overlay, "$g_presentation_obj_admin_panel_21", 2, 201),
      (position_set_x, pos1, 390),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_admin_panel_21", pos1),
      (server_get_max_num_players, ":max_players"),
      (overlay_set_val, "$g_presentation_obj_admin_panel_21", ":max_players"),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (assign, reg1, 1),
      (create_text_overlay, reg0, "str_number_of_bots_in_team_reg1", 0),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_number_box_overlay, "$g_presentation_obj_admin_panel_3", 0, "$g_multiplayer_max_num_bots"),
      (position_set_x, pos1, 390),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_admin_panel_3", pos1),
      (overlay_set_val, "$g_presentation_obj_admin_panel_3", "$g_multiplayer_num_bots_team_1"),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (assign, reg1, 2),
      (create_text_overlay, reg0, "str_number_of_bots_in_team_reg1", 0),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_number_box_overlay, "$g_presentation_obj_admin_panel_4", 0, "$g_multiplayer_max_num_bots"),
      (position_set_x, pos1, 390),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_admin_panel_4", pos1),
      (overlay_set_val, "$g_presentation_obj_admin_panel_4", "$g_multiplayer_num_bots_team_2"),

      (try_begin),
        (neq, "$g_multiplayer_game_type", multiplayer_game_type_deathmatch),
        (neq, "$g_multiplayer_game_type", multiplayer_game_type_duel),
      
        (val_sub, ":cur_y", ":cur_y_adder"),

        (create_text_overlay, reg0, "str_allow_friendly_fire", 0),
        (position_set_x, pos1, 30),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg0, pos1),

        (create_check_box_overlay, "$g_presentation_obj_admin_panel_5", "mesh_checkbox_off", "mesh_checkbox_on"),
        (position_set_x, pos1, 7),
        (store_add, ":special_cur_y", ":cur_y", 7),
        (position_set_y, pos1, ":special_cur_y"),
        (overlay_set_position, "$g_presentation_obj_admin_panel_5", pos1),
        (server_get_friendly_fire, ":server_friendly_fire"),
        (overlay_set_val, "$g_presentation_obj_admin_panel_5", ":server_friendly_fire"),

        (val_sub, ":cur_y", ":cur_y_adder"),

        (create_text_overlay, reg0, "str_allow_melee_friendly_fire", 0),
        (position_set_x, pos1, 30),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg0, pos1),

        (create_check_box_overlay, "$g_presentation_obj_admin_panel_36", "mesh_checkbox_off", "mesh_checkbox_on"),
        (position_set_x, pos1, 7),
        (store_add, ":special_cur_y", ":cur_y", 7),
        (position_set_y, pos1, ":special_cur_y"),
        (overlay_set_position, "$g_presentation_obj_admin_panel_36", pos1),
        (server_get_melee_friendly_fire, ":melee_friendly_fire"),
        (overlay_set_val, "$g_presentation_obj_admin_panel_36", ":melee_friendly_fire"),
      (try_end),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_text_overlay, reg0, "str_friendly_fire_damage_self_ratio", 0),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_number_box_overlay, "$g_presentation_obj_admin_panel_37", 0, 101),
      (position_set_x, pos1, 390),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_admin_panel_37", pos1),
      (server_get_friendly_fire_damage_self_ratio, ":friendly_fire_damage_self_ratio"),
      (overlay_set_val, "$g_presentation_obj_admin_panel_37", ":friendly_fire_damage_self_ratio"),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_text_overlay, reg0, "str_friendly_fire_damage_friend_ratio", 0),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_number_box_overlay, "$g_presentation_obj_admin_panel_38", 0, 101),
      (position_set_x, pos1, 390),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_admin_panel_38", pos1),
      (server_get_friendly_fire_damage_friend_ratio, ":friendly_fire_damage_friend_ratio"),
      (overlay_set_val, "$g_presentation_obj_admin_panel_38", ":friendly_fire_damage_friend_ratio"),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_text_overlay, reg0, "str_spectator_camera", 0),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_combo_button_overlay, "$g_presentation_obj_admin_panel_19"),
      (position_set_x, pos1, 800),
      (position_set_y, pos1, 800),
      (overlay_set_size, "$g_presentation_obj_admin_panel_19", pos1),
      (position_set_x, pos1, 490),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_admin_panel_19", pos1),
      (overlay_add_item, "$g_presentation_obj_admin_panel_19", "str_free"),
      (overlay_add_item, "$g_presentation_obj_admin_panel_19", "str_stick_to_any_player"),
      (overlay_add_item, "$g_presentation_obj_admin_panel_19", "str_stick_to_team_members"),
      (overlay_add_item, "$g_presentation_obj_admin_panel_19", "str_stick_to_team_members_view"),
      (server_get_ghost_mode, ":server_ghost_mode"),
      (overlay_set_val, "$g_presentation_obj_admin_panel_19", ":server_ghost_mode"),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_text_overlay, reg0, "str_control_block_direction", 0),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_combo_button_overlay, "$g_presentation_obj_admin_panel_15"),
      (position_set_x, pos1, 800),
      (position_set_y, pos1, 800),
      (overlay_set_size, "$g_presentation_obj_admin_panel_15", pos1),
      (position_set_x, pos1, 490),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_admin_panel_15", pos1),
      (overlay_add_item, "$g_presentation_obj_admin_panel_15", "str_automatic"),
      (overlay_add_item, "$g_presentation_obj_admin_panel_15", "str_by_mouse_movement"),
      (server_get_control_block_dir, ":server_control_block_dir"),
      (overlay_set_val, "$g_presentation_obj_admin_panel_15", ":server_control_block_dir"),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_text_overlay, reg0, "str_combat_speed", 0),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_combo_button_overlay, "$g_presentation_obj_admin_panel_26"),
      (position_set_x, pos1, 800),
      (position_set_y, pos1, 800),
      (overlay_set_size, "$g_presentation_obj_admin_panel_26", pos1),
      (position_set_x, pos1, 490),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_admin_panel_26", pos1),
      (overlay_add_item, "$g_presentation_obj_admin_panel_26", "str_combat_speed_0"),
      (overlay_add_item, "$g_presentation_obj_admin_panel_26", "str_combat_speed_1"),
      (overlay_add_item, "$g_presentation_obj_admin_panel_26", "str_combat_speed_2"),
      (overlay_add_item, "$g_presentation_obj_admin_panel_26", "str_combat_speed_3"),
      (overlay_add_item, "$g_presentation_obj_admin_panel_26", "str_combat_speed_4"),
      (server_get_combat_speed, ":server_combat_speed"),
      (overlay_set_val, "$g_presentation_obj_admin_panel_26", ":server_combat_speed"),

      (try_begin),
        (neq, "$g_multiplayer_game_type", multiplayer_game_type_headquarters),

        (val_sub, ":cur_y", ":cur_y_adder"),

        (create_text_overlay, reg0, "str_map_time_limit", 0),
        (position_set_x, pos1, 0),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg0, pos1),

        (create_number_box_overlay, "$g_presentation_obj_admin_panel_7", 5, 121),
        (position_set_x, pos1, 390),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, "$g_presentation_obj_admin_panel_7", pos1),
        (overlay_set_val, "$g_presentation_obj_admin_panel_7", "$g_multiplayer_game_max_minutes"),
      (else_try),
        (assign, "$g_presentation_obj_admin_panel_7", -1),
      (try_end),

      (try_begin),
        (this_or_next|eq, "$g_multiplayer_game_type", multiplayer_game_type_battle),
        (this_or_next|eq, "$g_multiplayer_game_type", multiplayer_game_type_destroy),
        (eq, "$g_multiplayer_game_type", multiplayer_game_type_siege),
      
        (val_sub, ":cur_y", ":cur_y_adder"),

        (create_text_overlay, reg0, "str_round_time_limit", 0),
        (position_set_x, pos1, 0),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg0, pos1),

        (create_number_box_overlay, "$g_presentation_obj_admin_panel_16", multiplayer_round_max_seconds_min, multiplayer_round_max_seconds_max),
        (position_set_x, pos1, 390),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, "$g_presentation_obj_admin_panel_16", pos1),
        (overlay_set_val, "$g_presentation_obj_admin_panel_16", "$g_multiplayer_round_max_seconds"),
      (else_try),
        (assign, "$g_presentation_obj_admin_panel_16", -1),
      (try_end),

      (try_begin),
        (this_or_next|eq, "$g_multiplayer_game_type", multiplayer_game_type_battle),
        (eq, "$g_multiplayer_game_type", multiplayer_game_type_destroy),
      
        (val_sub, ":cur_y", ":cur_y_adder"),

        (create_text_overlay, reg0, "str_players_take_control_of_a_bot_after_death", 0),
        (position_set_x, pos1, 30),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg0, pos1),

        (create_check_box_overlay, "$g_presentation_obj_admin_panel_25", "mesh_checkbox_off", "mesh_checkbox_on"),
        (position_set_x, pos1, 7),
        (store_add, ":special_cur_y", ":cur_y", 7),
        (position_set_y, pos1, ":special_cur_y"),
        (overlay_set_position, "$g_presentation_obj_admin_panel_25", pos1),
        (overlay_set_val, "$g_presentation_obj_admin_panel_25", "$g_multiplayer_player_respawn_as_bot"),
      (else_try),
        (assign, "$g_presentation_obj_admin_panel_25", -1),
      (try_end),

      (try_begin),
        (eq, "$g_multiplayer_game_type", multiplayer_game_type_siege),
      
        (val_sub, ":cur_y", ":cur_y_adder"),

        (create_text_overlay, reg0, "str_defender_spawn_count_limit", 0),
        (position_set_x, pos1, 0),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg0, pos1),

        (create_combo_button_overlay, "$g_presentation_obj_admin_panel_27"),
        (position_set_x, pos1, 800),
        (position_set_y, pos1, 800),
        (overlay_set_size, "$g_presentation_obj_admin_panel_27", pos1),
        (position_set_x, pos1, 490),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, "$g_presentation_obj_admin_panel_27", pos1),
        (assign, reg0, 5),
        (overlay_add_item, "$g_presentation_obj_admin_panel_27", "str_reg0"),
        (assign, reg0, 4),
        (overlay_add_item, "$g_presentation_obj_admin_panel_27", "str_reg0"),
        (assign, reg0, 3),
        (overlay_add_item, "$g_presentation_obj_admin_panel_27", "str_reg0"),
        (assign, reg0, 2),
        (overlay_add_item, "$g_presentation_obj_admin_panel_27", "str_reg0"),
        (assign, reg0, 1),
        (overlay_add_item, "$g_presentation_obj_admin_panel_27", "str_reg0"),
        (overlay_add_item, "$g_presentation_obj_admin_panel_27", "str_unlimited"),

        (store_sub, ":value_to_set", 5, "$g_multiplayer_number_of_respawn_count"),
        (overlay_set_val, "$g_presentation_obj_admin_panel_27", ":value_to_set"),
        #(val_sub, ":cur_y", ":cur_y_adder"),      
      (else_try),
        (assign, "$g_presentation_obj_admin_panel_27", -1),
      (try_end),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_text_overlay, reg0, "str_team_points_limit", 0),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_number_box_overlay, "$g_presentation_obj_admin_panel_8", 3, 1001),
      (position_set_x, pos1, 390),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_admin_panel_8", pos1),
      (overlay_set_val, "$g_presentation_obj_admin_panel_8", "$g_multiplayer_game_max_points"),

      (try_begin),
        (eq, "$g_multiplayer_game_type", multiplayer_game_type_headquarters),
      
        (val_sub, ":cur_y", ":cur_y_adder"),

        (create_text_overlay, reg0, "str_point_gained_from_flags", 0),
        (position_set_x, pos1, 0),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg0, pos1),

        (create_number_box_overlay, "$g_presentation_obj_admin_panel_17", 25, 401),
        (position_set_x, pos1, 390),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, "$g_presentation_obj_admin_panel_17", pos1),
        (overlay_set_val, "$g_presentation_obj_admin_panel_17", "$g_multiplayer_point_gained_from_flags"),
      (else_try),
        (assign, "$g_presentation_obj_admin_panel_17", -1),
      (try_end),
      
      (try_begin),
        (eq, "$g_multiplayer_game_type", multiplayer_game_type_capture_the_flag),
      
        (val_sub, ":cur_y", ":cur_y_adder"),

        (create_text_overlay, reg0, "str_point_gained_from_capturing_flag", 0),
        (position_set_x, pos1, 0),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg0, pos1),

        (create_number_box_overlay, "$g_presentation_obj_admin_panel_18", 0, 11),
        (position_set_x, pos1, 390),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, "$g_presentation_obj_admin_panel_18", pos1),
        (overlay_set_val, "$g_presentation_obj_admin_panel_18", "$g_multiplayer_point_gained_from_capturing_flag"),
      (else_try),
        (assign, "$g_presentation_obj_admin_panel_18", -1),
      (try_end),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_text_overlay, reg0, "str_respawn_period", 0),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_number_box_overlay, "$g_presentation_obj_admin_panel_6", multiplayer_respawn_period_min, multiplayer_respawn_period_max),
      (position_set_x, pos1, 390),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_admin_panel_6", pos1),
      (overlay_set_val, "$g_presentation_obj_admin_panel_6", "$g_multiplayer_respawn_period"),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_text_overlay, reg0, "str_initial_gold_multiplier", 0),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_number_box_overlay, "$g_presentation_obj_admin_panel_33", 0, 1001),
      (position_set_x, pos1, 390),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_admin_panel_33", pos1),
      (overlay_set_val, "$g_presentation_obj_admin_panel_33", "$g_multiplayer_initial_gold_multiplier"),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_text_overlay, reg0, "str_battle_earnings_multiplier", 0),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_number_box_overlay, "$g_presentation_obj_admin_panel_34", 0, 1001),
      (position_set_x, pos1, 390),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_admin_panel_34", pos1),
      (overlay_set_val, "$g_presentation_obj_admin_panel_34", "$g_multiplayer_battle_earnings_multiplier"),

      (try_begin),
        (this_or_next|eq, "$g_multiplayer_game_type", multiplayer_game_type_battle),
        (this_or_next|eq, "$g_multiplayer_game_type", multiplayer_game_type_destroy),
        (eq, "$g_multiplayer_game_type", multiplayer_game_type_siege),

        (val_sub, ":cur_y", ":cur_y_adder"),

        (create_text_overlay, reg0, "str_round_earnings_multiplier", 0),
        (position_set_x, pos1, 0),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg0, pos1),

        (create_number_box_overlay, "$g_presentation_obj_admin_panel_35", 0, 1001),
        (position_set_x, pos1, 390),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, "$g_presentation_obj_admin_panel_35", pos1),
        (overlay_set_val, "$g_presentation_obj_admin_panel_35", "$g_multiplayer_round_earnings_multiplier"),
      (else_try),
        (assign, "$g_presentation_obj_admin_panel_35", -1),
      (try_end),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_text_overlay, reg0, "str_make_kick_voteable", 0),
      (position_set_x, pos1, 30),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_check_box_overlay, "$g_presentation_obj_admin_panel_28", "mesh_checkbox_off", "mesh_checkbox_on"),
      (position_set_x, pos1, 7),
      (store_add, ":special_cur_y", ":cur_y", 7),
      (position_set_y, pos1, ":special_cur_y"),
      (overlay_set_position, "$g_presentation_obj_admin_panel_28", pos1),
      (overlay_set_val, "$g_presentation_obj_admin_panel_28", "$g_multiplayer_kick_voteable"),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_text_overlay, reg0, "str_make_ban_voteable", 0),
      (position_set_x, pos1, 30),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_check_box_overlay, "$g_presentation_obj_admin_panel_29", "mesh_checkbox_off", "mesh_checkbox_on"),
      (position_set_x, pos1, 7),
      (store_add, ":special_cur_y", ":cur_y", 7),
      (position_set_y, pos1, ":special_cur_y"),
      (overlay_set_position, "$g_presentation_obj_admin_panel_29", pos1),
      (overlay_set_val, "$g_presentation_obj_admin_panel_29", "$g_multiplayer_ban_voteable"),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_text_overlay, reg0, "str_make_maps_voteable", 0),
      (position_set_x, pos1, 30),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_check_box_overlay, "$g_presentation_obj_admin_panel_24", "mesh_checkbox_off", "mesh_checkbox_on"),
      (position_set_x, pos1, 7),
      (store_add, ":special_cur_y", ":cur_y", 7),
      (position_set_y, pos1, ":special_cur_y"),
      (overlay_set_position, "$g_presentation_obj_admin_panel_24", pos1),
      (overlay_set_val, "$g_presentation_obj_admin_panel_24", "$g_multiplayer_maps_voteable"),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_text_overlay, reg0, "str_make_factions_voteable", 0),
      (position_set_x, pos1, 30),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_check_box_overlay, "$g_presentation_obj_admin_panel_23", "mesh_checkbox_off", "mesh_checkbox_on"),
      (position_set_x, pos1, 7),
      (store_add, ":special_cur_y", ":cur_y", 7),
      (position_set_y, pos1, ":special_cur_y"),
      (overlay_set_position, "$g_presentation_obj_admin_panel_23", pos1),
      (overlay_set_val, "$g_presentation_obj_admin_panel_23", "$g_multiplayer_factions_voteable"),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_text_overlay, reg0, "str_bots_upper_limit_for_votes", 0),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (assign, ":upper_limit", 51),
      (val_min, ":upper_limit", "$g_multiplayer_max_num_bots"),
      (create_number_box_overlay, "$g_presentation_obj_admin_panel_22", 0, ":upper_limit"),
      (position_set_x, pos1, 390),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_admin_panel_22", pos1),
      (overlay_set_val, "$g_presentation_obj_admin_panel_22", "$g_multiplayer_num_bots_voteable"),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_text_overlay, reg0, "str_valid_vote_ratio", 0),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_number_box_overlay, "$g_presentation_obj_admin_panel_30", 50, 101),
      (position_set_x, pos1, 390),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_admin_panel_30", pos1),
      (overlay_set_val, "$g_presentation_obj_admin_panel_30", "$g_multiplayer_valid_vote_ratio"),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_text_overlay, reg0, "str_auto_team_balance_limit", 0),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_combo_button_overlay, "$g_presentation_obj_admin_panel_31"),
      (position_set_x, pos1, 800),
      (position_set_y, pos1, 800),
      (overlay_set_size, "$g_presentation_obj_admin_panel_31", pos1),
      (position_set_x, pos1, 490),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_admin_panel_31", pos1),
      (overlay_add_item, "$g_presentation_obj_admin_panel_31", "str_unlimited"),
      (assign, reg0, 6),
      (overlay_add_item, "$g_presentation_obj_admin_panel_31", "str_reg0"),
      (assign, reg0, 5),
      (overlay_add_item, "$g_presentation_obj_admin_panel_31", "str_reg0"),
      (assign, reg0, 4),
      (overlay_add_item, "$g_presentation_obj_admin_panel_31", "str_reg0"),
      (assign, reg0, 3),
      (overlay_add_item, "$g_presentation_obj_admin_panel_31", "str_reg0"),
      (assign, reg0, 2),
      (overlay_add_item, "$g_presentation_obj_admin_panel_31", "str_reg0"),
      (try_begin),
        (ge, "$g_multiplayer_auto_team_balance_limit", 1000),
        (overlay_set_val, "$g_presentation_obj_admin_panel_31", 0),
      (else_try),
        (store_sub, ":set_value", 7, "$g_multiplayer_auto_team_balance_limit"),
        (overlay_set_val, "$g_presentation_obj_admin_panel_31", ":set_value"),
      (try_end),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_text_overlay, reg0, "str_allow_player_banners", 0),
      (position_set_x, pos1, 30),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_check_box_overlay, "$g_presentation_obj_admin_panel_39", "mesh_checkbox_off", "mesh_checkbox_on"),
      (position_set_x, pos1, 7),
      (store_add, ":special_cur_y", ":cur_y", 7),
      (position_set_y, pos1, ":special_cur_y"),
      (overlay_set_position, "$g_presentation_obj_admin_panel_39", pos1),
      (overlay_set_val, "$g_presentation_obj_admin_panel_39", "$g_multiplayer_allow_player_banners"),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_text_overlay, reg0, "str_disallow_ranged_weapons", 0),
      (position_set_x, pos1, 30),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_check_box_overlay, "$g_presentation_obj_admin_panel_42", "mesh_checkbox_off", "mesh_checkbox_on"),
      (position_set_x, pos1, 7),
      (store_add, ":special_cur_y", ":cur_y", 7),
      (position_set_y, pos1, ":special_cur_y"),
      (overlay_set_position, "$g_presentation_obj_admin_panel_42", pos1),
      (overlay_set_val, "$g_presentation_obj_admin_panel_42", "$g_multiplayer_disallow_ranged_weapons"),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_text_overlay, reg0, "str_force_default_armor", 0),
      (position_set_x, pos1, 30),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_check_box_overlay, "$g_presentation_obj_admin_panel_40", "mesh_checkbox_off", "mesh_checkbox_on"),
      (position_set_x, pos1, 7),
      (store_add, ":special_cur_y", ":cur_y", 7),
      (position_set_y, pos1, ":special_cur_y"),
      (overlay_set_position, "$g_presentation_obj_admin_panel_40", pos1),
      (overlay_set_val, "$g_presentation_obj_admin_panel_40", "$g_multiplayer_force_default_armor"),

      (set_container_overlay, -1),

      (create_button_overlay, "$g_presentation_obj_admin_panel_13", "str_back", tf_center_justify),
      (position_set_x, pos1, 825),
      (position_set_y, pos1, 50),
      (overlay_set_position, "$g_presentation_obj_admin_panel_13", pos1),
      (position_set_x, pos1, 1500),
      (position_set_y, pos1, 1500),
      (overlay_set_size, "$g_presentation_obj_admin_panel_13", pos1),

      (create_button_overlay, "$g_presentation_obj_admin_panel_2", "str_start_map", tf_center_justify),
      (position_set_x, pos1, 825),
      (position_set_y, pos1, 90),
      (overlay_set_position, "$g_presentation_obj_admin_panel_2", pos1),
      (position_set_x, pos1, 1500),
      (position_set_y, pos1, 1500),
      (overlay_set_size, "$g_presentation_obj_admin_panel_2", pos1),

      (presentation_set_duration, 999999),

      (try_begin),
        (eq, ":selected_map_available", 0),
        (assign, "$g_multiplayer_selected_map", ":first_map"),
        (presentation_set_duration, 0),
        (start_presentation, "prsnt_game_multiplayer_admin_panel"),
      (try_end),
      ]),
    
    (ti_on_presentation_event_state_change,
     [(store_trigger_param_1, ":object"),
      (store_trigger_param_2, ":value"),
      (try_begin),
        (eq, ":object", "$g_presentation_obj_admin_panel_1"),
        (store_add, ":slot_no", ":value", multi_data_maps_for_game_type_begin),
        (troop_get_slot, "$g_multiplayer_selected_map", "trp_multiplayer_data", ":slot_no"),
        (presentation_set_duration, 0),
        (start_presentation, "prsnt_game_multiplayer_admin_panel"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_2"),
        (multiplayer_send_2_int_to_server, multiplayer_event_admin_start_map, "$g_multiplayer_selected_map", "$g_multiplayer_game_type"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_3"),
        (multiplayer_send_2_int_to_server, multiplayer_event_admin_set_num_bots_in_team, 1, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_4"),
        (multiplayer_send_2_int_to_server, multiplayer_event_admin_set_num_bots_in_team, 2, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_5"),
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_friendly_fire, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_6"),
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_respawn_period, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_7"),
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_game_max_minutes, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_8"),
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_game_max_points, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_9"),
        (multiplayer_send_string_to_server, multiplayer_event_admin_set_game_password, s0),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_10"),
        (assign, "$g_multiplayer_game_type", ":value"),
        (presentation_set_duration, 0),
        (start_presentation, "prsnt_game_multiplayer_admin_panel"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_11"),
        (store_add, "$g_multiplayer_next_team_1_faction", ":value", npc_kingdoms_begin),
##        (try_begin),
##          (ge, "$g_multiplayer_next_team_1_faction", "$g_multiplayer_next_team_2_faction"),
##          (val_add, "$g_multiplayer_next_team_1_faction", 1),
##        (try_end),
        (multiplayer_send_2_int_to_server, multiplayer_event_admin_set_team_faction, 1, "$g_multiplayer_next_team_1_faction"),
        (presentation_set_duration, 0),
        (start_presentation, "prsnt_game_multiplayer_admin_panel"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_12"),
        (store_add, "$g_multiplayer_next_team_2_faction", ":value", npc_kingdoms_begin),
##        (try_begin),
##          (ge, "$g_multiplayer_next_team_2_faction", "$g_multiplayer_next_team_1_faction"),
##          (val_add, "$g_multiplayer_next_team_2_faction", 1),
##        (try_end),
        (multiplayer_send_2_int_to_server, multiplayer_event_admin_set_team_faction, 2, "$g_multiplayer_next_team_2_faction"),
        (presentation_set_duration, 0),
        (start_presentation, "prsnt_game_multiplayer_admin_panel"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_13"),
        (presentation_set_duration, 0),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_14"),
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_add_to_servers_list, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_15"),
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_control_block_dir, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_16"),
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_round_max_seconds, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_17"),
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_point_gained_from_flags, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_18"),
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_point_gained_from_capturing_flag, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_19"),
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_ghost_mode, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_20"),
        (multiplayer_send_string_to_server, multiplayer_event_admin_set_server_name, s0),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_21"),
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_max_num_players, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_22"),
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_num_bots_voteable, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_23"),
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_factions_voteable, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_24"),
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_maps_voteable, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_25"),
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_player_respawn_as_bot, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_26"),
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_combat_speed, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_27"),
        (store_sub, ":value_to_send", 5, ":value"), #opposite index of displayed list
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_respawn_count, ":value_to_send"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_28"),
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_kick_voteable, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_29"),
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_ban_voteable, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_30"),
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_valid_vote_ratio, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_31"),
        (try_begin),
          (eq, ":value", 0),
          (multiplayer_send_int_to_server, multiplayer_event_admin_set_auto_team_balance_limit, 1000),
        (else_try),
          (store_sub, ":value_to_send", 7, ":value"),
          (multiplayer_send_int_to_server, multiplayer_event_admin_set_auto_team_balance_limit, ":value_to_send"),
        (try_end),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_32"),
        (server_set_welcome_message, s0),
        (multiplayer_send_string_to_server, multiplayer_event_admin_set_welcome_message, s0),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_33"),
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_initial_gold_multiplier, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_34"),
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_battle_earnings_multiplier, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_35"),
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_round_earnings_multiplier, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_36"),
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_melee_friendly_fire, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_37"),
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_friendly_fire_damage_self_ratio, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_38"),
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_friendly_fire_damage_friend_ratio, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_39"),
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_allow_player_banners, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_40"),
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_force_default_armor, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_41"),
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_anti_cheat, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_42"),
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_disallow_ranged_weapons, ":value"),
      (try_end),
      ]),
    (ti_on_presentation_run,
     [
      (try_begin),
        (this_or_next|key_clicked, key_escape),
		(key_clicked, key_xbox_start),
        (presentation_set_duration, 0),
      (try_end),
      ]),
    ]),

  ("multiplayer_welcome_message", prsntf_manual_end_only, 0, [
    (ti_on_presentation_load,
     [(set_fixed_point_multiplier, 1000),
      (str_store_welcome_message, s0),
      (try_begin),
        (neg|str_is_empty, s0),
        (eq, "$g_multiplayer_welcome_message_shown", 0),
        (create_mesh_overlay, reg0, "mesh_mp_ui_welcome_panel"),
        (position_set_x, pos1, 200),
        (position_set_y, pos1, 400),
        (overlay_set_position, reg0, pos1),
        (create_text_overlay, reg0, s0, tf_scrollable),
        (overlay_set_color, reg0, 0xFFFFFF),
        (position_set_x, pos1, 230),
        (position_set_y, pos1, 425),
        (overlay_set_position, reg0, pos1),
        (position_set_x, pos1, 540),
        (position_set_y, pos1, 150),
        (overlay_set_area_size, reg0, pos1),

        (presentation_set_duration, 999999),
      (else_try),
        (eq, "$g_multiplayer_show_server_rules", 1),
        (create_mesh_overlay, reg0, "mesh_mp_ui_welcome_panel"),
        (position_set_x, pos1, 200),
        (position_set_y, pos1, 400),
        (overlay_set_position, reg0, pos1),
        (try_begin),
          (neg|str_is_empty, s0),
          (str_clear, s3),
          (str_store_string, s2, s0),
          (str_store_string, s2, "str_s2_s3"),
          (str_store_string, s2, "str_s2_s3"),
        (else_try),
          (str_clear, s2),
        (try_end),
        (str_store_string, s3, "@Game Rules:^"),
        (str_store_string, s2, "str_s2_s3"),
        (assign, ":end_cond", 1000),
        (call_script, "script_game_multiplayer_get_game_type_mission_template", "$g_multiplayer_game_type"),
        (assign, ":cur_mt", reg0),
        
        (str_store_server_name, s0),
        (str_store_string, s3, "str_server_name_s0"),
        (str_store_string, s2, "str_s2_s3"),        

        (try_begin),                
          (eq, "$g_multiplayer_game_type", multiplayer_game_type_deathmatch),
          (str_store_string, s0, "str_multi_game_type_1"),
        (else_try),
          (eq, "$g_multiplayer_game_type", multiplayer_game_type_team_deathmatch),
          (str_store_string, s0, "str_multi_game_type_2"),
        (else_try),
          (eq, "$g_multiplayer_game_type", multiplayer_game_type_battle),
          (str_store_string, s0, "str_multi_game_type_3"),
        (else_try),
          (eq, "$g_multiplayer_game_type", multiplayer_game_type_destroy),
          (str_store_string, s0, "str_multi_game_type_4"),
        (else_try),
          (eq, "$g_multiplayer_game_type", multiplayer_game_type_capture_the_flag),
          (str_store_string, s0, "str_multi_game_type_5"),
        (else_try),
          (eq, "$g_multiplayer_game_type", multiplayer_game_type_headquarters),
          (str_store_string, s0, "str_multi_game_type_6"),
        (else_try),
          (eq, "$g_multiplayer_game_type", multiplayer_game_type_siege),
          (str_store_string, s0, "str_multi_game_type_7"),
        (else_try),
          (eq, "$g_multiplayer_game_type", multiplayer_game_type_duel),
          (str_store_string, s0, "str_multi_game_type_8"),
        (try_end),
        (str_store_string, s3, "str_game_type_s0"),
        (str_store_string, s2, "str_s2_s3"),   
        
        (store_current_scene, ":cur_scene"),
        (val_sub, ":cur_scene", "scn_multi_scene_1"),
        (val_add, ":cur_scene", "str_multi_scene_1"),
        (str_store_string, s0, ":cur_scene"),
        (str_store_string, s3, "str_map_name_s0"),
        (str_store_string, s2, "str_s2_s3"),
        
        (store_mission_timer_a, ":mission_timer"),
        (val_add, ":mission_timer", "$server_mission_timer_while_player_joined"),
        (assign, reg0, ":mission_timer"),       
        (store_mul, "$g_multiplayer_game_max_seconds", "$g_multiplayer_game_max_minutes", 60),
        (store_sub, ":remaining_seconds", "$g_multiplayer_game_max_seconds", ":mission_timer"),
        (store_div, reg0, ":remaining_seconds", 60),
        (store_mod, reg1, ":remaining_seconds", 60),
        (try_begin),
          (ge, reg0, 10),
          (ge, reg1, 10),          
          (str_clear, s0),
          (str_clear, s1),
        (else_try),  
          (ge, reg0, 10),
          (str_clear, s0),
          (str_store_string, s1, "@0"),
        (else_try),  
          (ge, reg1, 10),
          (str_store_string, s0, "@0"),
          (str_clear, s1),
        (else_try),  
          (str_store_string, s0, "@0"),
          (str_store_string, s1, "@0"),
        (try_end),
        (str_store_string, s3, "str_remaining_time_s0reg0_s1reg1"),
        
        (str_store_string, s2, "str_s2_s3"),

        (try_for_range, ":cur_option", 0, ":end_cond"),
          (assign, reg0, -12345), #magic number
          (call_script, "script_game_get_multiplayer_server_option_for_mission_template", ":cur_mt", ":cur_option"),
          (try_begin),
            (eq, reg0, -12345),
            (assign, ":end_cond", 0),
          (else_try),
            (call_script, "script_game_multiplayer_server_option_for_mission_template_to_string", ":cur_mt", ":cur_option", reg0),
            (str_store_string, s3, s0),
            (str_store_string, s2, "str_s2_s3"),
          (try_end),
        (try_end),        
        (create_text_overlay, reg0, s2, tf_scrollable),
        (overlay_set_color, reg0, 0xFFFFFF),
        (position_set_x, pos1, 230),
        (position_set_y, pos1, 425),
        (overlay_set_position, reg0, pos1),
        (position_set_x, pos1, 540),
        (position_set_y, pos1, 150),
        (overlay_set_area_size, reg0, pos1),

        (presentation_set_duration, 999999),
      (try_end),
      ]),

    (ti_on_presentation_run,
     [
       (str_store_welcome_message, s0),
       (try_begin),
         (neq, "$g_multiplayer_show_server_rules", 1),
         (this_or_next|str_is_empty, s0),
         (eq, "$g_multiplayer_welcome_message_shown", 1),
         (presentation_set_duration, 0),
         (neg|is_presentation_active, "prsnt_multiplayer_escape_menu"),
         (neg|is_presentation_active, "prsnt_multiplayer_team_select"),
         (start_presentation, "prsnt_multiplayer_team_select"),
       (else_try),
         (store_mission_timer_a, ":mission_timer"),
         (gt, ":mission_timer", 1),
         (this_or_next|key_clicked, key_escape),
         (this_or_next|key_clicked, key_space),
         (this_or_next|key_clicked, key_enter),
         (this_or_next|key_clicked, key_left_mouse_button),
         (this_or_next|key_clicked, key_right_mouse_button),
         (this_or_next|key_clicked, key_xbox_ltrigger),
         (key_clicked, key_xbox_rtrigger),
         (assign, "$g_multiplayer_welcome_message_shown", 1),
         (presentation_set_duration, 0),
         (neg|is_presentation_active, "prsnt_multiplayer_escape_menu"),
         (neg|is_presentation_active, "prsnt_multiplayer_team_select"),
         (try_begin),
           (eq, "$g_multiplayer_show_server_rules", 1),
           (assign, "$g_multiplayer_show_server_rules", 0),
           (start_presentation, "prsnt_multiplayer_escape_menu"),
         (else_try),
           (start_presentation, "prsnt_multiplayer_team_select"),
         (try_end),
       (try_end),
      ]),
    ]),

  ("multiplayer_team_select", prsntf_manual_end_only, 0, [
    (ti_on_presentation_load,
     [(set_fixed_point_multiplier, 1000),

      (create_mesh_overlay, reg0, "mesh_mp_ingame_menu"),
      (position_set_x, pos1, 250),
      (position_set_y, pos1, 80),
      (overlay_set_position, reg0, pos1),
      (position_set_x, pos1, 1000),
      (position_set_y, pos1, 1000),
      (overlay_set_size, reg0, pos1),

      (str_clear, s0),
      (create_text_overlay, "$g_presentation_obj_team_select_container", s0, tf_scrollable_style_2),
      (position_set_x, pos1, 285),
      (position_set_y, pos1, 125),
      (overlay_set_position, "$g_presentation_obj_team_select_container", pos1),
      (position_set_x, pos1, 405),
      (position_set_y, pos1, 500),
      (overlay_set_area_size, "$g_presentation_obj_team_select_container", pos1),
      (set_container_overlay, "$g_presentation_obj_team_select_container"),

      (assign, ":cur_y", 450),

      (create_text_overlay, reg0, "str_choose_a_faction", 0),
      (overlay_set_color, reg0, 0xFFFFFF),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),
      (val_sub, ":cur_y", escape_menu_item_height),
      (position_set_y, pos1, ":cur_y"),
      (position_set_x, pos1, 100),

      (multiplayer_get_my_player, ":my_player_no"),
      (team_get_faction, ":faction_no", 0),
      (str_store_faction_name, s0, ":faction_no"),
      (create_button_overlay, "$g_presentation_obj_team_select_1", s0, 0),
      (try_begin),
        (call_script, "script_cf_multiplayer_team_is_available", ":my_player_no", 0),
        (overlay_set_color, "$g_presentation_obj_team_select_1", 0xFFFFFF),
        (overlay_set_hilight_color, "$g_presentation_obj_team_select_1", 0x55FF50),
        (assign, "$g_multiplayer_team_select_1_available", 1),
      (else_try),
        (overlay_set_color, "$g_presentation_obj_team_select_1", 0x888888),
        (overlay_set_hilight_color, "$g_presentation_obj_team_select_1", 0x888888),
        (assign, "$g_multiplayer_team_select_1_available", 0),
      (try_end),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_team_select_1", pos1),
      (val_sub, ":cur_y", escape_menu_item_height),
      (position_set_y, pos1, ":cur_y"),

      (team_get_faction, ":faction_no", 1),
      (str_store_faction_name, s0, ":faction_no"),
      (create_button_overlay, "$g_presentation_obj_team_select_2", s0, 0),
      (try_begin),
        (call_script, "script_cf_multiplayer_team_is_available", ":my_player_no", 1),
        (overlay_set_color, "$g_presentation_obj_team_select_2", 0xFFFFFF),
        (overlay_set_hilight_color, "$g_presentation_obj_team_select_2", 0x55FF50),
        (assign, "$g_multiplayer_team_select_2_available", 1),
      (else_try),
        (overlay_set_color, "$g_presentation_obj_team_select_2", 0x888888),
        (overlay_set_hilight_color, "$g_presentation_obj_team_select_2", 0x888888),
        (assign, "$g_multiplayer_team_select_2_available", 0),
      (try_end),
      (overlay_set_position, "$g_presentation_obj_team_select_2", pos1),
      (val_sub, ":cur_y", escape_menu_item_height),
      (position_set_y, pos1, ":cur_y"),

      (create_button_overlay, "$g_presentation_obj_team_select_3", "str_spectator", 0),
      (overlay_set_color, "$g_presentation_obj_team_select_3", 0xFFFFFF),
      (overlay_set_position, "$g_presentation_obj_team_select_3", pos1),
      (val_sub, ":cur_y", escape_menu_item_height),
      (position_set_y, pos1, ":cur_y"),

      (presentation_set_duration, 999999),
      ]),

    (ti_on_presentation_event_state_change,
     [(store_trigger_param_1, ":object"),
      (multiplayer_get_my_player, ":my_player_no"),
      (try_begin),
        (eq, "$g_waiting_for_confirmation_to_terminate", 0),
        (try_begin),
          (eq, ":object", "$g_presentation_obj_team_select_1"),
          (try_begin),
            (call_script, "script_cf_multiplayer_team_is_available", ":my_player_no", 0),
            (try_begin),
              (player_get_team_no, ":my_team", ":my_player_no"),
              (neq, ":my_team", 0),
              (assign, "$g_confirmation_result", 0),
              (assign, "$g_waiting_for_confirmation_to_terminate", 1),
              (player_get_troop_id, "$g_confirmation_troop_backup", ":my_player_no"),
              (player_get_team_no, "$g_confirmation_team_backup", ":my_player_no"),
              (player_set_troop_id, ":my_player_no", -1),
              (multiplayer_send_int_to_server, multiplayer_event_change_team_no, 0),
              (player_set_team_no, ":my_player_no", 0),
            (else_try),
              (presentation_set_duration, 0),
              (start_presentation, "prsnt_multiplayer_troop_select"),
            (try_end),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_team_select_2"),
          (try_begin),
            (call_script, "script_cf_multiplayer_team_is_available", ":my_player_no", 1),
            (try_begin),
              (player_get_team_no, ":my_team", ":my_player_no"),
              (neq, ":my_team", 1),
              (assign, "$g_confirmation_result", 0),
              (assign, "$g_waiting_for_confirmation_to_terminate", 1),
              (player_get_troop_id, "$g_confirmation_troop_backup", ":my_player_no"),
              (player_get_team_no, "$g_confirmation_team_backup", ":my_player_no"),
              (player_set_troop_id, ":my_player_no", -1),
              (multiplayer_send_int_to_server, multiplayer_event_change_team_no, 1),
              (player_set_team_no, ":my_player_no", 1),
            (else_try),
              (presentation_set_duration, 0),
              (start_presentation, "prsnt_multiplayer_troop_select"),
            (try_end),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_team_select_3"),
          (player_set_troop_id, ":my_player_no", -1),
          (multiplayer_send_int_to_server, multiplayer_event_change_team_no, multi_team_spectator),
          (player_set_team_no, ":my_player_no", multi_team_spectator),
          (presentation_set_duration, 0),
        (try_end),
      (try_end),
      ]),

    (ti_on_presentation_run,
     [
      (multiplayer_get_my_player, ":my_player_no"),
      (try_begin),
        (this_or_next|key_clicked, key_escape),
		(key_clicked, key_xbox_start),
        (eq, "$g_waiting_for_confirmation_to_terminate", 0),
        (multiplayer_get_my_team, ":my_team"),
        (try_begin),
          (eq, ":my_team", multi_team_unassigned),
          (player_set_troop_id, ":my_player_no", -1),
          (multiplayer_send_int_to_server, multiplayer_event_change_team_no, multi_team_spectator),
          (player_set_team_no, ":my_player_no", multi_team_spectator),
        (try_end),
        (presentation_set_duration, 0),
      (else_try),
        (eq, "$g_waiting_for_confirmation_to_terminate", 1),
        (eq, "$g_confirmation_result", 1),
        (assign, "$g_waiting_for_confirmation_to_terminate", 0),
        (assign, "$g_confirmation_result", 0),
        (presentation_set_duration, 0),
        (start_presentation, "prsnt_multiplayer_troop_select"),
      (else_try),
        (eq, "$g_waiting_for_confirmation_to_terminate", 1),
        (eq, "$g_confirmation_result", -1),
        #return troop and team back to the old state
        (player_set_troop_id, ":my_player_no", "$g_confirmation_troop_backup"),
        (player_set_team_no, ":my_player_no", "$g_confirmation_team_backup"),
        (assign, "$g_waiting_for_confirmation_to_terminate", 0),
        (assign, "$g_confirmation_result", 0),
        (presentation_set_duration, 0),
        (start_presentation, "prsnt_multiplayer_team_select"),
      (else_try),
        (assign, ":do_refresh", 0),
        (try_begin),
          (call_script, "script_cf_multiplayer_team_is_available", ":my_player_no", 0),
          (try_begin),
            (eq, "$g_multiplayer_team_select_1_available", 0),
            (assign, ":do_refresh", 1),
          (try_end),
        (else_try),
          #not available
          (try_begin),
            (eq, "$g_multiplayer_team_select_1_available", 1),
            (assign, ":do_refresh", 1),
          (try_end),
        (try_end),
        (try_begin),
          (call_script, "script_cf_multiplayer_team_is_available", ":my_player_no", 1),
          (try_begin),
            (eq, "$g_multiplayer_team_select_2_available", 0),
            (assign, ":do_refresh", 1),
          (try_end),
        (else_try),
          #not available
          (try_begin),
            (eq, "$g_multiplayer_team_select_2_available", 1),
            (assign, ":do_refresh", 1),
          (try_end),
        (try_end),
        (eq, ":do_refresh", 1),
        (presentation_set_duration, 0),
        (start_presentation, "prsnt_multiplayer_team_select"),
      (try_end),
      ]),
    ]),
  
  ("multiplayer_troop_select", prsntf_manual_end_only, 0, [
    (ti_on_presentation_load,
     [(set_fixed_point_multiplier, 1000),

      (create_mesh_overlay, reg0, "mesh_mp_ingame_menu"),
      (position_set_x, pos1, 250),
      (position_set_y, pos1, 80),
      (overlay_set_position, reg0, pos1),
      (position_set_x, pos1, 1000),
      (position_set_y, pos1, 1000),
      (overlay_set_size, reg0, pos1),

      (str_clear, s0),
      (create_text_overlay, "$g_presentation_obj_troop_select_container", s0, tf_scrollable_style_2),
      (position_set_x, pos1, 285),
      (position_set_y, pos1, 125),
      (overlay_set_position, "$g_presentation_obj_troop_select_container", pos1),
      (position_set_x, pos1, 405),
      (position_set_y, pos1, 500),
      (overlay_set_area_size, "$g_presentation_obj_troop_select_container", pos1),
      (set_container_overlay, "$g_presentation_obj_troop_select_container"),

      (assign, ":cur_y", 450),

      (create_text_overlay, reg0, "str_choose_a_troop", 0),
      (overlay_set_color, reg0, 0xFFFFFF),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),
      (val_sub, ":cur_y", escape_menu_item_height),
      (position_set_y, pos1, ":cur_y"),
      (position_set_x, pos1, 100),

      (multiplayer_get_my_player, ":my_player_no"),
      (player_get_team_no, ":my_team_no", ":my_player_no"),
      (team_get_faction, ":my_faction_no", ":my_team_no"),
      (try_for_range, ":i_multi", multi_data_troop_button_indices_begin, multi_data_troop_button_indices_end),
        (troop_set_slot, "trp_multiplayer_data", ":i_multi", -1),
      (try_end),

      (assign, ":cur_troop_index", 0),
      (try_for_range, ":troop_no", multiplayer_troops_begin, multiplayer_troops_end),
        (store_troop_faction, ":troop_faction", ":troop_no"),
        (eq, ":troop_faction", ":my_faction_no"),
        (str_store_troop_name, s1, ":troop_no"),
        (create_button_overlay, reg0, s1, 0),
        (overlay_set_color, reg0, 0xFFFFFF),
        (store_add, ":button_index_slot", ":cur_troop_index", multi_data_troop_button_indices_begin),
        (troop_set_slot, "trp_multiplayer_data", ":button_index_slot", reg0),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg0, pos1),
        (val_sub, ":cur_y", escape_menu_item_height),
        (position_set_y, pos1, ":cur_y"),
        (val_add, ":cur_troop_index", 1),
      (try_end),
      (presentation_set_duration, 999999),
      ]),
   
    (ti_on_presentation_event_state_change,
     [(store_trigger_param_1, ":object"),
      (multiplayer_get_my_player, ":my_player_no"),
      (player_get_team_no, ":my_team_no", ":my_player_no"),
      (team_get_faction, ":my_faction_no", ":my_team_no"),
      (assign, ":selected_troop_no", -1),
      (assign, ":end_cond", multi_data_troop_button_indices_end),
      (try_for_range, ":i_button", multi_data_troop_button_indices_begin, ":end_cond"),
        (troop_slot_eq, "trp_multiplayer_data", ":i_button", ":object"),
        (store_sub, ":selected_troop_index", ":i_button", multi_data_troop_button_indices_begin),
        (assign, ":end_cond_2", multiplayer_troops_end),
        (try_for_range, ":troop_no", multiplayer_troops_begin, ":end_cond_2"),
          (store_troop_faction, ":troop_faction", ":troop_no"),
          (eq, ":troop_faction", ":my_faction_no"),
          (val_sub, ":selected_troop_index", 1),
          (lt, ":selected_troop_index", 0),
          (assign, ":selected_troop_no", ":troop_no"),
          (assign, ":end_cond_2", 0), #break
        (try_end),
        (try_begin),
          (multiplayer_get_my_troop, ":troop_no"),
          (neq, ":troop_no", ":selected_troop_no"),
          (player_set_troop_id, ":my_player_no", ":selected_troop_no"),
          (multiplayer_send_int_to_server, multiplayer_event_change_troop_id, ":selected_troop_no"),
          (call_script, "script_multiplayer_set_default_item_selections_for_troop", ":selected_troop_no"),
          (call_script, "script_multiplayer_send_item_selections"),
        (try_end),
        (presentation_set_duration, 0),
        (assign, "$g_presentation_state", 0),
        (start_presentation, "prsnt_multiplayer_item_select"),
        (assign, ":end_cond", 0), #break
      (try_end),
      ]),
    (ti_on_presentation_run,
     [
      (try_begin),
        (this_or_next|key_clicked, key_escape),
		(key_clicked, key_xbox_start),
        (multiplayer_get_my_player, ":my_player_no"),
        (is_between, ":my_player_no", 0, multiplayer_max_possible_player_id),
        (multiplayer_get_my_troop, ":my_troop"),
        (try_begin),
          (neg|is_between, ":my_troop", multiplayer_troops_begin, multiplayer_troops_end),
          (player_set_troop_id, ":my_player_no", -1),
          (multiplayer_send_int_to_server, multiplayer_event_change_troop_id, -1),
          (multiplayer_send_int_to_server, multiplayer_event_change_team_no, multi_team_spectator),
          (player_set_team_no, ":my_player_no", multi_team_spectator),
        (try_end),
        (presentation_set_duration, 0),
      (try_end),
      ]),
    ]),

  ("multiplayer_item_select", prsntf_manual_end_only, 0, [
    (ti_on_presentation_load,
     [(set_fixed_point_multiplier, 1000),
      (multiplayer_get_my_player, ":my_player_no"),

      (assign, "$g_presentation_obj_item_select_1", -1),
      (assign, "$g_presentation_obj_item_select_2", -1),
      (assign, "$g_presentation_obj_item_select_3", -1),
      (assign, "$g_presentation_obj_item_select_4", -1),
      (assign, "$g_presentation_obj_item_select_5", -1),
      (assign, "$g_presentation_obj_item_select_6", -1),
      (assign, "$g_presentation_obj_item_select_7", -1),
      (assign, "$g_presentation_obj_item_select_8", -1),
      (assign, "$g_presentation_obj_item_select_9", -1),
      (assign, "$g_presentation_obj_item_select_10", -1),
      (assign, "$g_presentation_obj_item_select_11", -1),
      (assign, "$g_presentation_obj_item_select_12", -1),
      (assign, "$g_presentation_obj_item_select_13", -1),
      (assign, "$g_presentation_obj_item_select_14", -1),
      (assign, "$g_presentation_obj_item_select_15", -1),
      (assign, "$g_presentation_obj_item_select_16", -1),
      
      (try_begin),
        (neq, "$g_current_opened_item_details", -1),
        (close_item_details),
        (assign, "$g_current_opened_item_details", -1),
      (try_end),

      (store_add, ":selected_item_index", slot_player_selected_item_indices_begin, 0),
      (player_get_slot, ":selected_item_id", ":my_player_no", ":selected_item_index"),
      (try_begin),
        (ge, ":selected_item_id", 0),
        (create_image_button_overlay, "$g_presentation_obj_item_select_1", "mesh_mp_inventory_slot_empty", "mesh_mp_inventory_slot_empty"),
        (create_mesh_overlay_with_item_id, reg0, ":selected_item_id"),
        (position_set_x, pos1, 950),
        (position_set_y, pos1, 526),
        (overlay_set_position, reg0, pos1),
        (assign, "$g_inside_obj_1", reg0),
      (else_try),
        (create_image_button_overlay, "$g_presentation_obj_item_select_1", "mesh_mp_inventory_slot_equip", "mesh_mp_inventory_slot_equip"),
      (try_end),
      (position_set_x, pos1, 800),
      (position_set_y, pos1, 800),
      (overlay_set_size, "$g_presentation_obj_item_select_1", pos1),
      (position_set_x, pos1, 899),
      (position_set_y, pos1, 475),
      (overlay_set_position, "$g_presentation_obj_item_select_1", pos1),

      (store_add, ":selected_item_index", slot_player_selected_item_indices_begin, 1),
      (player_get_slot, ":selected_item_id", ":my_player_no", ":selected_item_index"),
      (try_begin),
        (ge, ":selected_item_id", 0),
        (create_image_button_overlay, "$g_presentation_obj_item_select_2", "mesh_mp_inventory_slot_empty", "mesh_mp_inventory_slot_empty"),
        (create_mesh_overlay_with_item_id, reg0, ":selected_item_id"),
        (position_set_x, pos1, 950),
        (position_set_y, pos1, 426),
        (overlay_set_position, reg0, pos1),
        (assign, "$g_inside_obj_2", reg0),
      (else_try),
        (create_image_button_overlay, "$g_presentation_obj_item_select_2", "mesh_mp_inventory_slot_equip", "mesh_mp_inventory_slot_equip"),
      (try_end),
      (position_set_x, pos1, 800),
      (position_set_y, pos1, 800),
      (overlay_set_size, "$g_presentation_obj_item_select_2", pos1),
      (position_set_x, pos1, 899),
      (position_set_y, pos1, 375),
      (overlay_set_position, "$g_presentation_obj_item_select_2", pos1),

      (store_add, ":selected_item_index", slot_player_selected_item_indices_begin, 2),
      (player_get_slot, ":selected_item_id", ":my_player_no", ":selected_item_index"),
      (try_begin),
        (ge, ":selected_item_id", 0),
        (create_image_button_overlay, "$g_presentation_obj_item_select_3", "mesh_mp_inventory_slot_empty", "mesh_mp_inventory_slot_empty"),
        (create_mesh_overlay_with_item_id, reg0, ":selected_item_id"),
        (position_set_x, pos1, 950),
        (position_set_y, pos1, 326),
        (overlay_set_position, reg0, pos1),
        (assign, "$g_inside_obj_3", reg0),
      (else_try),
        (create_image_button_overlay, "$g_presentation_obj_item_select_3", "mesh_mp_inventory_slot_equip", "mesh_mp_inventory_slot_equip"),
      (try_end),
      (position_set_x, pos1, 800),
      (position_set_y, pos1, 800),
      (overlay_set_size, "$g_presentation_obj_item_select_3", pos1),
      (position_set_x, pos1, 899),
      (position_set_y, pos1, 275),
      (overlay_set_position, "$g_presentation_obj_item_select_3", pos1),

      (store_add, ":selected_item_index", slot_player_selected_item_indices_begin, 3),
      (player_get_slot, ":selected_item_id", ":my_player_no", ":selected_item_index"),
      (try_begin),
        (ge, ":selected_item_id", 0),
        (create_image_button_overlay, "$g_presentation_obj_item_select_4", "mesh_mp_inventory_slot_empty", "mesh_mp_inventory_slot_empty"),
        (create_mesh_overlay_with_item_id, reg0, ":selected_item_id"),
        (position_set_x, pos1, 950),
        (position_set_y, pos1, 226),
        (overlay_set_position, reg0, pos1),
        (assign, "$g_inside_obj_4", reg0),
      (else_try),
        (create_image_button_overlay, "$g_presentation_obj_item_select_4", "mesh_mp_inventory_slot_equip", "mesh_mp_inventory_slot_equip"),
      (try_end),
      (position_set_x, pos1, 800),
      (position_set_y, pos1, 800),
      (overlay_set_size, "$g_presentation_obj_item_select_4", pos1),
      (position_set_x, pos1, 899),
      (position_set_y, pos1, 175),
      (overlay_set_position, "$g_presentation_obj_item_select_4", pos1),

      (store_add, ":selected_item_index", slot_player_selected_item_indices_begin, 4),
      (player_get_slot, ":selected_item_id", ":my_player_no", ":selected_item_index"),
      (try_begin),
        (ge, ":selected_item_id", 0),
        (create_image_button_overlay, "$g_presentation_obj_item_select_5", "mesh_mp_inventory_slot_empty", "mesh_mp_inventory_slot_empty"),
        (create_mesh_overlay_with_item_id, reg0, ":selected_item_id"),
        (position_set_x, pos1, 53),
        (position_set_y, pos1, 576),
        (overlay_set_position, reg0, pos1),
        (assign, "$g_inside_obj_5", reg0),
      (else_try),
        (create_image_button_overlay, "$g_presentation_obj_item_select_5", "mesh_mp_inventory_slot_helmet", "mesh_mp_inventory_slot_helmet"),
      (try_end),
      (position_set_x, pos1, 800),
      (position_set_y, pos1, 800),
      (overlay_set_size, "$g_presentation_obj_item_select_5", pos1),
      (position_set_x, pos1, 2),
      (position_set_y, pos1, 525),
      (overlay_set_position, "$g_presentation_obj_item_select_5", pos1),

      (store_add, ":selected_item_index", slot_player_selected_item_indices_begin, 5),
      (player_get_slot, ":selected_item_id", ":my_player_no", ":selected_item_index"),
      (try_begin),
        (ge, ":selected_item_id", 0),
        (create_image_button_overlay, "$g_presentation_obj_item_select_6", "mesh_mp_inventory_slot_empty", "mesh_mp_inventory_slot_empty"),
        (create_mesh_overlay_with_item_id, reg0, ":selected_item_id"),
        (position_set_x, pos1, 53),
        (position_set_y, pos1, 476),
        (overlay_set_position, reg0, pos1),
        (assign, "$g_inside_obj_6", reg0),
      (else_try),
        (create_image_button_overlay, "$g_presentation_obj_item_select_6", "mesh_mp_inventory_slot_armor", "mesh_mp_inventory_slot_armor"),
      (try_end),
      (position_set_x, pos1, 800),
      (position_set_y, pos1, 800),
      (overlay_set_size, "$g_presentation_obj_item_select_6", pos1),
      (position_set_x, pos1, 2),
      (position_set_y, pos1, 425),
      (overlay_set_position, "$g_presentation_obj_item_select_6", pos1),

      (store_add, ":selected_item_index", slot_player_selected_item_indices_begin, 6),
      (player_get_slot, ":selected_item_id", ":my_player_no", ":selected_item_index"),
      (try_begin),
        (ge, ":selected_item_id", 0),
        (create_image_button_overlay, "$g_presentation_obj_item_select_7", "mesh_mp_inventory_slot_empty", "mesh_mp_inventory_slot_empty"),
        (create_mesh_overlay_with_item_id, reg0, ":selected_item_id"),
        (position_set_x, pos1, 53),
        (position_set_y, pos1, 376),
        (overlay_set_position, reg0, pos1),
        (assign, "$g_inside_obj_7", reg0),
      (else_try),
        (create_image_button_overlay, "$g_presentation_obj_item_select_7", "mesh_mp_inventory_slot_boot", "mesh_mp_inventory_slot_boot"),
      (try_end),
      (position_set_x, pos1, 800),
      (position_set_y, pos1, 800),
      (overlay_set_size, "$g_presentation_obj_item_select_7", pos1),
      (position_set_x, pos1, 2),
      (position_set_y, pos1, 325),
      (overlay_set_position, "$g_presentation_obj_item_select_7", pos1),

      (store_add, ":selected_item_index", slot_player_selected_item_indices_begin, 7),
      (player_get_slot, ":selected_item_id", ":my_player_no", ":selected_item_index"),
      (try_begin),
        (ge, ":selected_item_id", 0),
        (create_image_button_overlay, "$g_presentation_obj_item_select_8", "mesh_mp_inventory_slot_empty", "mesh_mp_inventory_slot_empty"),
        (create_mesh_overlay_with_item_id, reg0, ":selected_item_id"),
        (position_set_x, pos1, 53),
        (position_set_y, pos1, 276),
        (overlay_set_position, reg0, pos1),
        (assign, "$g_inside_obj_8", reg0),
      (else_try),
        (create_image_button_overlay, "$g_presentation_obj_item_select_8", "mesh_mp_inventory_slot_glove", "mesh_mp_inventory_slot_glove"),
      (try_end),
      (position_set_x, pos1, 800),
      (position_set_y, pos1, 800),
      (overlay_set_size, "$g_presentation_obj_item_select_8", pos1),
      (position_set_x, pos1, 2),
      (position_set_y, pos1, 225),
      (overlay_set_position, "$g_presentation_obj_item_select_8", pos1),

      (store_add, ":selected_item_index", slot_player_selected_item_indices_begin, 8),
      (player_get_slot, ":selected_item_id", ":my_player_no", ":selected_item_index"),
      (try_begin),
        (ge, ":selected_item_id", 0),
        (eq, "$g_horses_are_avaliable", 1),
        (create_image_button_overlay, "$g_presentation_obj_item_select_9", "mesh_mp_inventory_slot_empty", "mesh_mp_inventory_slot_empty"),
        (create_mesh_overlay_with_item_id, reg0, ":selected_item_id"),
        (position_set_x, pos1, 53),
        (position_set_y, pos1, 176),
        (overlay_set_position, reg0, pos1),
        (assign, "$g_inside_obj_9", reg0),
      (else_try),
        (create_image_button_overlay, "$g_presentation_obj_item_select_9", "mesh_mp_inventory_slot_horse", "mesh_mp_inventory_slot_horse"),
      (try_end),
      (position_set_x, pos1, 800),
      (position_set_y, pos1, 800),
      (overlay_set_size, "$g_presentation_obj_item_select_9", pos1),
      (position_set_x, pos1, 2),
      (position_set_y, pos1, 125),
      (overlay_set_position, "$g_presentation_obj_item_select_9", pos1),

      (create_mesh_overlay, reg0, "mesh_mp_inventory_left"),
      (position_set_x, pos1, 800),
      (position_set_y, pos1, 800),
      (overlay_set_size, reg0, pos1),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, 14),
      (overlay_set_position, reg0, pos1),

      (create_mesh_overlay, reg0, "mesh_mp_inventory_right"),
      (position_set_x, pos1, 800),
      (position_set_y, pos1, 800),
      (overlay_set_size, reg0, pos1),
      (position_set_x, pos1, 894),
      (position_set_y, pos1, 65),
      (overlay_set_position, reg0, pos1),

      (create_in_game_button_overlay, "$g_presentation_obj_item_select_10", "str_reset_to_default", 0),
      (overlay_set_color, "$g_presentation_obj_item_select_10", 0xFFFFFF),
      (position_set_x, pos1, 605),
      (position_set_y, pos1, 25),
      (overlay_set_position, "$g_presentation_obj_item_select_10", pos1),

      (create_in_game_button_overlay, "$g_presentation_obj_item_select_11", "str_done", 0),
      (overlay_set_color, "$g_presentation_obj_item_select_11", 0xFFFFFF),
      (position_set_x, pos1, 395),
      (position_set_y, pos1, 25),
      (overlay_set_position, "$g_presentation_obj_item_select_11", pos1),

      (assign, ":cur_y", 725),
      (multiplayer_get_my_player, ":my_player_no"),
      (player_get_team_no, ":my_team_no", ":my_player_no"),
      (assign, ":has_bots", 0),
      (try_begin),
        (eq, ":my_team_no", 0),
        (try_begin),
          (gt, "$g_multiplayer_num_bots_team_1", 0),
          (assign, ":has_bots", 1),
        (try_end),
      (else_try),
        (try_begin),
          (gt, "$g_multiplayer_num_bots_team_2", 0),
          (assign, ":has_bots", 1),
        (try_end),
      (try_end),
      (team_get_faction, ":my_faction_no", ":my_team_no"),

      (try_begin),
        (eq, ":has_bots", 1),
        (neq, "$g_multiplayer_game_type", multiplayer_game_type_deathmatch),
        (neq, "$g_multiplayer_game_type", multiplayer_game_type_duel),

        (assign, ":num_lines", 0),
        (try_begin),
          (eq, ":has_bots", 1),
          (try_for_range, ":ai_troop_no", multiplayer_ai_troops_begin, multiplayer_ai_troops_end),
            (store_troop_faction, ":ai_troop_faction", ":ai_troop_no"),
            (eq, ":ai_troop_faction", ":my_faction_no"),
            (val_add, ":num_lines", 1),
          (try_end),
        (try_end),

        (store_mul, ":board_height", ":num_lines", 20),
        (val_add, ":board_height", 40),

        (create_mesh_overlay, reg0, "mesh_mp_ui_command_border_r"),
        (position_set_x, pos1, 280),
        (position_set_y, pos1, 680),
        (overlay_set_position, reg0, pos1),
        (position_set_x, pos1, 2500),
        (position_set_y, pos1, 2500),
        (overlay_set_size, reg0, pos1),

        (create_mesh_overlay, reg0, "mesh_mp_ui_command_border_l"),
        (position_set_x, pos1, 650),
        (position_set_y, pos1, 680),
        (overlay_set_position, reg0, pos1),
        (position_set_x, pos1, 2500),
        (position_set_y, pos1, 2500),
        (overlay_set_size, reg0, pos1),

        (create_mesh_overlay, reg0, "mesh_mp_ui_command_panel"),
        (position_set_x, pos1, 350),
        (store_sub, ":board_pos_y", 750, ":board_height"),
        (position_set_y, pos1, ":board_pos_y"),
        (overlay_set_position, reg0, pos1),
        (position_set_x, pos1, 3000),
        (position_set_y, pos1, 3000),
        (overlay_set_size, reg0, pos1),

        (create_text_overlay, reg0, "str_command", 0),
        (overlay_set_color, reg0, 0xFFFFFF),
        (position_set_x, pos1, 800),
        (position_set_y, pos1, 800),
        (overlay_set_size, reg0, pos1),
        (position_set_x, pos1, 370),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg0, pos1),
        (val_sub, ":cur_y", 20),

        (assign, ":cur_ai_troop_index", 0),
        (try_for_range, ":ai_troop_no", multiplayer_ai_troops_begin, multiplayer_ai_troops_end),
          (store_troop_faction, ":ai_troop_faction", ":ai_troop_no"),
          (eq, ":ai_troop_faction", ":my_faction_no"),

          (create_check_box_overlay, reg0, "mesh_checkbox_off", "mesh_checkbox_on"),
          (position_set_x, pos1, 800),
          (position_set_y, pos1, 800),
          (overlay_set_size, reg0, pos1),
          (position_set_x, pos1, 377),
          (store_add, ":special_cur_y", ":cur_y", 2),
          (position_set_y, pos1, ":special_cur_y"),
          (overlay_set_position, reg0, pos1),
          (try_begin),
            (eq, ":cur_ai_troop_index", 0),
            (overlay_set_val, reg0, "$g_multiplayer_bot_type_1_wanted"),
            (assign, "$g_presentation_obj_item_select_13", reg0),
          (else_try),
            (eq, ":cur_ai_troop_index", 1),
            (overlay_set_val, reg0, "$g_multiplayer_bot_type_2_wanted"),
            (assign, "$g_presentation_obj_item_select_14", reg0),
          (else_try),
            (eq, ":cur_ai_troop_index", 2),
            (overlay_set_val, reg0, "$g_multiplayer_bot_type_3_wanted"),
            (assign, "$g_presentation_obj_item_select_15", reg0),
          (else_try),
            (overlay_set_val, reg0, "$g_multiplayer_bot_type_4_wanted"),
            (assign, "$g_presentation_obj_item_select_16", reg0),
          (try_end),

          (str_store_troop_name, s0, ":ai_troop_no"),
          (create_text_overlay, reg0, "str_s0", 0),
          (overlay_set_color, reg0, 0xFFFFFF),
          (position_set_x, pos1, 800),
          (position_set_y, pos1, 800),
          (overlay_set_size, reg0, pos1),
          (position_set_x, pos1, 397),
          (position_set_y, pos1, ":cur_y"),
          (overlay_set_position, reg0, pos1),
          (val_sub, ":cur_y", 20),
          (val_add, ":cur_ai_troop_index", 1),
        (try_end),
        (val_sub, ":cur_y", 20),
      (try_end),

      (multiplayer_get_my_player, ":my_player_no"),
      (player_get_gold, ":player_gold", ":my_player_no"),
      (call_script, "script_multiplayer_calculate_cur_selected_items_cost", ":my_player_no", 1),
      (create_text_overlay, "$g_presentation_obj_item_select_12", "str_total_item_cost_reg0", tf_left_align|tf_single_line|tf_with_outline),
      (try_begin),
        (ge, ":player_gold", reg0),
        (overlay_set_color, "$g_presentation_obj_item_select_12", 0xFFFFFF),
      (else_try),
        (overlay_set_color, "$g_presentation_obj_item_select_12", 0xFF0000),
      (try_end),
      (position_set_x, pos1, 680),
      (position_set_y, pos1, 652),
      (overlay_set_position, "$g_presentation_obj_item_select_12", pos1),
      
      (store_add, "$g_presentation_obj_item_select_next", "$g_presentation_obj_item_select_12", 1),

      (player_get_troop_id, ":my_troop_no", ":my_player_no"),
      (try_begin),
        (eq, "$g_presentation_state", 1),
        (call_script, "script_multiplayer_display_available_items_for_troop_and_item_classes", ":my_troop_no", multi_item_class_type_weapons_begin, multi_item_class_type_weapons_end, 781, 474),
        (create_mesh_overlay, reg0, "mesh_mp_inventory_right_arrow"),
        (position_set_x, pos1, 800),
        (position_set_y, pos1, 800),
        (overlay_set_size, reg0, pos1),
        (position_set_x, pos1, 881),
        (position_set_y, pos1, 515),
        (overlay_set_position, reg0, pos1),
      (else_try),
        (eq, "$g_presentation_state", 2),
        (call_script, "script_multiplayer_display_available_items_for_troop_and_item_classes", ":my_troop_no", multi_item_class_type_weapons_begin, multi_item_class_type_weapons_end, 781, 374),
        (create_mesh_overlay, reg0, "mesh_mp_inventory_right_arrow"),
        (position_set_x, pos1, 800),
        (position_set_y, pos1, 800),
        (overlay_set_size, reg0, pos1),
        (position_set_x, pos1, 881),
        (position_set_y, pos1, 415),
        (overlay_set_position, reg0, pos1),
      (else_try),
        (eq, "$g_presentation_state", 3),
        (call_script, "script_multiplayer_display_available_items_for_troop_and_item_classes", ":my_troop_no", multi_item_class_type_weapons_begin, multi_item_class_type_weapons_end, 781, 274),
        (create_mesh_overlay, reg0, "mesh_mp_inventory_right_arrow"),
        (position_set_x, pos1, 800),
        (position_set_y, pos1, 800),
        (overlay_set_size, reg0, pos1),
        (position_set_x, pos1, 881),
        (position_set_y, pos1, 315),
        (overlay_set_position, reg0, pos1),
      (else_try),
        (eq, "$g_presentation_state", 4),
        (call_script, "script_multiplayer_display_available_items_for_troop_and_item_classes", ":my_troop_no", multi_item_class_type_weapons_begin, multi_item_class_type_weapons_end, 781, 174),
        (create_mesh_overlay, reg0, "mesh_mp_inventory_right_arrow"),
        (position_set_x, pos1, 800),
        (position_set_y, pos1, 800),
        (overlay_set_size, reg0, pos1),
        (position_set_x, pos1, 881),
        (position_set_y, pos1, 215),
        (overlay_set_position, reg0, pos1),
      (else_try),
        (eq, "$g_presentation_state", 5),
        (call_script, "script_multiplayer_display_available_items_for_troop_and_item_classes", ":my_troop_no", multi_item_class_type_heads_begin, multi_item_class_type_heads_end, 117, 524),
        (create_mesh_overlay, reg0, "mesh_mp_inventory_left_arrow"),
        (position_set_x, pos1, 800),
        (position_set_y, pos1, 800),
        (overlay_set_size, reg0, pos1),
        (position_set_x, pos1, 106),
        (position_set_y, pos1, 565),
        (overlay_set_position, reg0, pos1),
      (else_try),
        (eq, "$g_presentation_state", 6),
        (call_script, "script_multiplayer_display_available_items_for_troop_and_item_classes", ":my_troop_no", multi_item_class_type_bodies_begin, multi_item_class_type_bodies_end, 117, 424),
        (create_mesh_overlay, reg0, "mesh_mp_inventory_left_arrow"),
        (position_set_x, pos1, 800),
        (position_set_y, pos1, 800),
        (overlay_set_size, reg0, pos1),
        (position_set_x, pos1, 106),
        (position_set_y, pos1, 465),
        (overlay_set_position, reg0, pos1),
      (else_try),
        (eq, "$g_presentation_state", 7),
        (call_script, "script_multiplayer_display_available_items_for_troop_and_item_classes", ":my_troop_no", multi_item_class_type_feet_begin, multi_item_class_type_feet_end, 117, 324),
        (create_mesh_overlay, reg0, "mesh_mp_inventory_left_arrow"),
        (position_set_x, pos1, 800),
        (position_set_y, pos1, 800),
        (overlay_set_size, reg0, pos1),
        (position_set_x, pos1, 106),
        (position_set_y, pos1, 365),
        (overlay_set_position, reg0, pos1),
      (else_try),
        (eq, "$g_presentation_state", 8),
        (call_script, "script_multiplayer_display_available_items_for_troop_and_item_classes", ":my_troop_no", multi_item_class_type_gloves_begin, multi_item_class_type_gloves_end, 117, 224),
        (create_mesh_overlay, reg0, "mesh_mp_inventory_left_arrow"),
        (position_set_x, pos1, 800),
        (position_set_y, pos1, 800),
        (overlay_set_size, reg0, pos1),
        (position_set_x, pos1, 106),
        (position_set_y, pos1, 265),
        (overlay_set_position, reg0, pos1),
      (else_try),
        (eq, "$g_presentation_state", 9),
        (eq, "$g_horses_are_avaliable", 1),
        (call_script, "script_multiplayer_display_available_items_for_troop_and_item_classes", ":my_troop_no", multi_item_class_type_horses_begin, multi_item_class_type_horses_end, 117, 124),
        (create_mesh_overlay, reg0, "mesh_mp_inventory_left_arrow"),
        (position_set_x, pos1, 800),
        (position_set_y, pos1, 800),
        (overlay_set_size, reg0, pos1),
        (position_set_x, pos1, 106),
        (position_set_y, pos1, 165),
        (overlay_set_position, reg0, pos1),
      (try_end),
      (presentation_set_duration, 999999),
      ]),
    
    (ti_on_presentation_mouse_enter_leave,
       [(store_trigger_param_1, ":object"),
        (store_trigger_param_2, ":enter_leave"),

        (try_begin),
          (eq, "$g_close_equipment_selection", 0),
          (try_begin),
            (eq, ":enter_leave", 0),

            (assign, ":item_no", -1), 
            (try_begin),
              (ge, ":object", "$g_presentation_obj_item_select_next"),
              (store_sub, ":tested_object", ":object", "$g_presentation_obj_item_select_next"),
              (store_mod, ":mod_value", ":tested_object", 2),
              (store_sub, ":mod_value", 1, ":mod_value"),
              (val_div, ":tested_object", 2),
              (store_add, ":cur_slot", multi_data_item_button_indices_begin, ":tested_object"),
              (troop_get_slot, ":item_no", "trp_multiplayer_data", ":cur_slot"),

              (assign, ":target_obj", ":object"),
              (val_add, ":target_obj", ":mod_value"),
            (else_try),
              (eq, ":object", "$g_presentation_obj_item_select_1"),
              (store_add, ":player_slot_index", slot_player_selected_item_indices_begin, 1),
              (val_sub, ":player_slot_index", 1),
              (multiplayer_get_my_player, ":my_player_no"),
              (player_get_slot, ":item_no", ":my_player_no", ":player_slot_index"),
              (assign, ":target_obj", "$g_inside_obj_1"),
            (else_try),
              (eq, ":object", "$g_presentation_obj_item_select_2"),
              (store_add, ":player_slot_index", slot_player_selected_item_indices_begin, 2),
              (val_sub, ":player_slot_index", 1),
              (multiplayer_get_my_player, ":my_player_no"),
              (player_get_slot, ":item_no", ":my_player_no", ":player_slot_index"),
              (assign, ":target_obj", "$g_inside_obj_2"),
            (else_try),
              (eq, ":object", "$g_presentation_obj_item_select_3"),
              (store_add, ":player_slot_index", slot_player_selected_item_indices_begin, 3),
              (val_sub, ":player_slot_index", 1),
              (multiplayer_get_my_player, ":my_player_no"),
              (player_get_slot, ":item_no", ":my_player_no", ":player_slot_index"),
              (assign, ":target_obj", "$g_inside_obj_3"),
            (else_try),
              (eq, ":object", "$g_presentation_obj_item_select_4"),
              (store_add, ":player_slot_index", slot_player_selected_item_indices_begin, 4),
              (val_sub, ":player_slot_index", 1),
              (multiplayer_get_my_player, ":my_player_no"),
              (player_get_slot, ":item_no", ":my_player_no", ":player_slot_index"),
              (assign, ":target_obj", "$g_inside_obj_4"),
            (else_try),
              (eq, ":object", "$g_presentation_obj_item_select_5"),
              (store_add, ":player_slot_index", slot_player_selected_item_indices_begin, 5),
              (val_sub, ":player_slot_index", 1),
              (multiplayer_get_my_player, ":my_player_no"),
              (player_get_slot, ":item_no", ":my_player_no", ":player_slot_index"),
              (assign, ":target_obj", "$g_inside_obj_5"),
            (else_try),
              (eq, ":object", "$g_presentation_obj_item_select_6"),
              (store_add, ":player_slot_index", slot_player_selected_item_indices_begin, 6),
              (val_sub, ":player_slot_index", 1),
              (multiplayer_get_my_player, ":my_player_no"),
              (player_get_slot, ":item_no", ":my_player_no", ":player_slot_index"),
              (assign, ":target_obj", "$g_inside_obj_6"),
            (else_try),
              (eq, ":object", "$g_presentation_obj_item_select_7"),
              (store_add, ":player_slot_index", slot_player_selected_item_indices_begin, 7),
              (val_sub, ":player_slot_index", 1),
              (multiplayer_get_my_player, ":my_player_no"),
              (player_get_slot, ":item_no", ":my_player_no", ":player_slot_index"),
              (assign, ":target_obj", "$g_inside_obj_7"),
            (else_try),
              (eq, ":object", "$g_presentation_obj_item_select_8"),
              (store_add, ":player_slot_index", slot_player_selected_item_indices_begin, 8),
              (val_sub, ":player_slot_index", 1),
              (multiplayer_get_my_player, ":my_player_no"),
              (player_get_slot, ":item_no", ":my_player_no", ":player_slot_index"),   
              (assign, ":target_obj", "$g_inside_obj_8"),
            (else_try),
              (eq, ":object", "$g_presentation_obj_item_select_9"),
              (eq, "$g_horses_are_avaliable", 1),
              (store_add, ":player_slot_index", slot_player_selected_item_indices_begin, 9),
              (val_sub, ":player_slot_index", 1),
              (multiplayer_get_my_player, ":my_player_no"),
              (player_get_slot, ":item_no", ":my_player_no", ":player_slot_index"),
              (assign, ":target_obj", "$g_inside_obj_9"),
            (try_end),

            (try_begin),
              (ge, ":item_no", 0),
              (overlay_get_position, pos0, ":target_obj"),
              (multiplayer_get_my_player, ":my_player_no"),
              (player_get_troop_id, ":my_player_troop_no", ":my_player_no"),
              (try_begin),
                (call_script, "script_cf_multiplayer_is_item_default_for_troop", ":item_no", ":my_player_troop_no"),
                (show_item_details, ":item_no", pos0, 0),
              (else_try),
                (store_troop_faction, ":my_player_faction_no", ":my_player_troop_no"),
                (store_sub, ":faction_slot", ":my_player_faction_no", npc_kingdoms_begin),
                (val_add, ":faction_slot", slot_item_multiplayer_faction_price_multipliers_begin),
                (item_get_slot, ":price_multiplier", ":item_no", ":faction_slot"),
                (show_item_details, ":item_no", pos0, ":price_multiplier"),
              (try_end),
              (assign, "$g_current_opened_item_details", ":item_no"),
            (try_end),
          (else_try),
            (assign, ":item_no", -1), 
            (try_begin),
              (ge, ":object", "$g_presentation_obj_item_select_next"),
              (store_sub, ":tested_object", ":object", "$g_presentation_obj_item_select_next"),
              (val_div, ":tested_object", 2),
              (store_add, ":cur_slot", multi_data_item_button_indices_begin, ":tested_object"),
              (troop_get_slot, ":item_no", "trp_multiplayer_data", ":cur_slot"),
            (else_try),
              (eq, ":object", "$g_presentation_obj_item_select_1"),
              (store_add, ":player_slot_index", slot_player_selected_item_indices_begin, 1),
              (val_sub, ":player_slot_index", 1),
              (multiplayer_get_my_player, ":my_player_no"),
              (player_get_slot, ":item_no", ":my_player_no", ":player_slot_index"),
              (assign, ":target_obj", "$g_inside_obj_1"),
            (else_try),
              (eq, ":object", "$g_presentation_obj_item_select_2"),
              (store_add, ":player_slot_index", slot_player_selected_item_indices_begin, 2),
              (val_sub, ":player_slot_index", 1),
              (multiplayer_get_my_player, ":my_player_no"),
              (player_get_slot, ":item_no", ":my_player_no", ":player_slot_index"),
              (assign, ":target_obj", "$g_inside_obj_2"),
            (else_try),
              (eq, ":object", "$g_presentation_obj_item_select_3"),
              (store_add, ":player_slot_index", slot_player_selected_item_indices_begin, 3),
              (val_sub, ":player_slot_index", 1),
              (multiplayer_get_my_player, ":my_player_no"),
              (player_get_slot, ":item_no", ":my_player_no", ":player_slot_index"),
              (assign, ":target_obj", "$g_inside_obj_3"),
            (else_try),
              (eq, ":object", "$g_presentation_obj_item_select_4"),
              (store_add, ":player_slot_index", slot_player_selected_item_indices_begin, 4),
              (val_sub, ":player_slot_index", 1),
              (multiplayer_get_my_player, ":my_player_no"),
              (player_get_slot, ":item_no", ":my_player_no", ":player_slot_index"),
              (assign, ":target_obj", "$g_inside_obj_4"),
            (else_try),
              (eq, ":object", "$g_presentation_obj_item_select_5"),
              (store_add, ":player_slot_index", slot_player_selected_item_indices_begin, 5),
              (val_sub, ":player_slot_index", 1),
              (multiplayer_get_my_player, ":my_player_no"),
              (player_get_slot, ":item_no", ":my_player_no", ":player_slot_index"),
              (assign, ":target_obj", "$g_inside_obj_5"),
            (else_try),
              (eq, ":object", "$g_presentation_obj_item_select_6"),
              (store_add, ":player_slot_index", slot_player_selected_item_indices_begin, 6),
              (val_sub, ":player_slot_index", 1),
              (multiplayer_get_my_player, ":my_player_no"),
              (player_get_slot, ":item_no", ":my_player_no", ":player_slot_index"),
              (assign, ":target_obj", "$g_inside_obj_6"),
            (else_try),
              (eq, ":object", "$g_presentation_obj_item_select_7"),
              (store_add, ":player_slot_index", slot_player_selected_item_indices_begin, 7),
              (val_sub, ":player_slot_index", 1),
              (multiplayer_get_my_player, ":my_player_no"),
              (player_get_slot, ":item_no", ":my_player_no", ":player_slot_index"),
              (assign, ":target_obj", "$g_inside_obj_7"),
            (else_try),
              (eq, ":object", "$g_presentation_obj_item_select_8"),
              (store_add, ":player_slot_index", slot_player_selected_item_indices_begin, 8),
              (val_sub, ":player_slot_index", 1),
              (multiplayer_get_my_player, ":my_player_no"),
              (player_get_slot, ":item_no", ":my_player_no", ":player_slot_index"),   
              (assign, ":target_obj", "$g_inside_obj_8"),
            (else_try),
              (eq, ":object", "$g_presentation_obj_item_select_9"),
              (eq, "$g_horses_are_avaliable", 1),
              (store_add, ":player_slot_index", slot_player_selected_item_indices_begin, 9),
              (val_sub, ":player_slot_index", 1),
              (multiplayer_get_my_player, ":my_player_no"),
              (player_get_slot, ":item_no", ":my_player_no", ":player_slot_index"),
              (assign, ":target_obj", "$g_inside_obj_9"),
            (try_end),

            (try_begin),
              (eq, "$g_current_opened_item_details", ":item_no"),
              (close_item_details),
              (assign, "$g_current_opened_item_details", -1),
            (try_end),
          (try_end),
        (else_try),
          (assign, "$g_close_equipment_selection", 0),
          (presentation_set_duration, 0),
        (try_end),
      ]),
        
    (ti_on_presentation_event_state_change,
     [(store_trigger_param_1, ":object"),
      (store_trigger_param_2, ":value"),
      (multiplayer_get_my_player, ":my_player_no"),
      (player_get_troop_id, ":my_troop_no", ":my_player_no"),

      (try_begin),
        (eq, "$g_close_equipment_selection", 0),
        (try_begin),
          (eq, "$g_presentation_state", 0),
          (try_begin),
            (eq, ":object", "$g_presentation_obj_item_select_1"),
            (assign, "$g_presentation_state", 1),
            (presentation_set_duration, 0),
            (start_presentation, "prsnt_multiplayer_item_select"),
          (else_try),
            (eq, ":object", "$g_presentation_obj_item_select_2"),
            (assign, "$g_presentation_state", 2),
            (presentation_set_duration, 0),
            (start_presentation, "prsnt_multiplayer_item_select"),
          (else_try),
            (eq, ":object", "$g_presentation_obj_item_select_3"),
            (assign, "$g_presentation_state", 3),
            (presentation_set_duration, 0),
            (start_presentation, "prsnt_multiplayer_item_select"),
          (else_try),
            (eq, ":object", "$g_presentation_obj_item_select_4"),
            (assign, "$g_presentation_state", 4),
            (presentation_set_duration, 0),
            (start_presentation, "prsnt_multiplayer_item_select"),
          (else_try),
            (eq, ":object", "$g_presentation_obj_item_select_5"),
            (assign, "$g_presentation_state", 5),
            (presentation_set_duration, 0),
            (start_presentation, "prsnt_multiplayer_item_select"),
          (else_try),
            (eq, ":object", "$g_presentation_obj_item_select_6"),
            (assign, "$g_presentation_state", 6),
            (presentation_set_duration, 0),
            (start_presentation, "prsnt_multiplayer_item_select"),
          (else_try),
            (eq, ":object", "$g_presentation_obj_item_select_7"),
            (assign, "$g_presentation_state", 7),
            (presentation_set_duration, 0),
            (start_presentation, "prsnt_multiplayer_item_select"),
          (else_try),
            (eq, ":object", "$g_presentation_obj_item_select_8"),
            (assign, "$g_presentation_state", 8),
            (presentation_set_duration, 0),
            (start_presentation, "prsnt_multiplayer_item_select"),
          (else_try),
            (eq, ":object", "$g_presentation_obj_item_select_9"),
            (eq, "$g_horses_are_avaliable", 1),
            (assign, "$g_presentation_state", 9),
            (presentation_set_duration, 0),
            (start_presentation, "prsnt_multiplayer_item_select"),
          (try_end),
        (else_try),
          (gt, "$g_presentation_state", 0),        
          (store_sub, ":tested_object", ":object", "$g_presentation_obj_item_select_next"),
          (val_div, ":tested_object", 2),
          (assign, ":end_cond", multi_data_item_button_indices_end),
          (try_for_range, ":cur_slot", multi_data_item_button_indices_begin, ":end_cond"),
            (neg|troop_slot_eq, "trp_multiplayer_data", ":cur_slot", -1),
            (store_sub, ":button_id", ":cur_slot", multi_data_item_button_indices_begin),
            (eq, ":tested_object", ":button_id"),
            (troop_get_slot, ":item_no", "trp_multiplayer_data", ":cur_slot"),

            (store_add, ":player_slot_index", slot_player_selected_item_indices_begin, "$g_presentation_state"),
            (val_sub, ":player_slot_index", 1),
            (player_set_slot, ":my_player_no", ":player_slot_index", ":item_no"),

            (player_get_gold, ":player_gold", ":my_player_no"),
            (call_script, "script_multiplayer_calculate_cur_selected_items_cost", ":my_player_no", 1),
            (overlay_set_text, "$g_presentation_obj_item_select_12", "str_total_item_cost_reg0"),
            (try_begin),
              (ge, ":player_gold", reg0),
              (overlay_set_color, "$g_presentation_obj_item_select_12", 0xFFFFFF),
            (else_try),
              (overlay_set_color, "$g_presentation_obj_item_select_12", 0xFF0000),
            (try_end),
        
            (assign, ":end_cond", 0), #break
          (try_end),
          (presentation_set_duration, 0),
          (assign, "$g_presentation_state", 0),
          (start_presentation, "prsnt_multiplayer_item_select"),
        (try_end),
        (try_begin),
          (eq, ":object", "$g_presentation_obj_item_select_10"),
          (call_script, "script_multiplayer_set_default_item_selections_for_troop", ":my_troop_no"),
          (presentation_set_duration, 0),
          (assign, "$g_presentation_state", 0),
          (start_presentation, "prsnt_multiplayer_item_select"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_item_select_11"),
          (call_script, "script_multiplayer_send_item_selections"),
          (presentation_set_duration, 0),

          (try_begin),
            (try_begin),
              (eq, "$g_multiplayer_game_type", multiplayer_game_type_siege),
              (gt, "$g_multiplayer_number_of_respawn_count", 0),
          
              (ge, "$g_my_spawn_count", "$g_multiplayer_number_of_respawn_count"),
         
              (multiplayer_get_my_player, ":my_player_no"),
              (player_get_team_no, ":my_player_team", ":my_player_no"),

              (this_or_next|eq, ":my_player_team", 0),
              (ge, "$g_my_spawn_count", 999),
        
              (assign, "$g_show_no_more_respawns_remained", 1),
            (else_try),
              (assign, "$g_show_no_more_respawns_remained", 0),
            (try_end),

            (eq, "$g_show_no_more_respawns_remained", 1),

            (store_mission_timer_a, "$g_multiplayer_respawn_start_time"),
            (start_presentation, "prsnt_multiplayer_respawn_time_counter"),
          (try_end),      
        (else_try),
          (eq, ":object", "$g_presentation_obj_item_select_13"),
          (assign, "$g_multiplayer_bot_type_1_wanted", ":value"),
          (multiplayer_send_2_int_to_server, multiplayer_event_set_bot_selection, slot_player_bot_type_1_wanted, ":value"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_item_select_14"),
          (assign, "$g_multiplayer_bot_type_2_wanted", ":value"),
          (multiplayer_send_2_int_to_server, multiplayer_event_set_bot_selection, slot_player_bot_type_2_wanted, ":value"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_item_select_15"),
          (assign, "$g_multiplayer_bot_type_3_wanted", ":value"),
          (multiplayer_send_2_int_to_server, multiplayer_event_set_bot_selection, slot_player_bot_type_3_wanted, ":value"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_item_select_16"),
          (assign, "$g_multiplayer_bot_type_4_wanted", ":value"),
          (multiplayer_send_2_int_to_server, multiplayer_event_set_bot_selection, slot_player_bot_type_4_wanted, ":value"),
        (try_end),
      (else_try),
        (assign, "$g_close_equipment_selection", 0),
        (presentation_set_duration, 0),
      (try_end),
      ]),
    
    (ti_on_presentation_mouse_press,
     [(store_trigger_param_1, ":object"),
      (store_trigger_param_2, ":mouse_state"),

      (try_begin),
        (eq, "$g_close_equipment_selection", 0),
        (try_begin),
          (eq, ":mouse_state", 1), #right click (clears the item slot)
          (try_begin),
            (eq, "$g_presentation_state", 0),
            (multiplayer_get_my_player, ":my_player_no"),
            (try_begin),
              (eq, ":object", "$g_presentation_obj_item_select_1"),
              (store_add, ":selected_item_index", slot_player_selected_item_indices_begin, 0),
              (player_set_slot, ":my_player_no", ":selected_item_index", -1),
              (presentation_set_duration, 0),
              (assign, "$g_presentation_state", 0),
              (start_presentation, "prsnt_multiplayer_item_select"),
            (else_try),
              (eq, ":object", "$g_presentation_obj_item_select_2"),
              (store_add, ":selected_item_index", slot_player_selected_item_indices_begin, 1),
              (player_set_slot, ":my_player_no", ":selected_item_index", -1),
              (presentation_set_duration, 0),
              (assign, "$g_presentation_state", 0),
              (start_presentation, "prsnt_multiplayer_item_select"),
            (else_try),
              (eq, ":object", "$g_presentation_obj_item_select_3"),
              (store_add, ":selected_item_index", slot_player_selected_item_indices_begin, 2),
              (player_set_slot, ":my_player_no", ":selected_item_index", -1),
              (presentation_set_duration, 0),
              (assign, "$g_presentation_state", 0),
              (start_presentation, "prsnt_multiplayer_item_select"),
            (else_try),
              (eq, ":object", "$g_presentation_obj_item_select_4"),
              (store_add, ":selected_item_index", slot_player_selected_item_indices_begin, 3),
              (player_set_slot, ":my_player_no", ":selected_item_index", -1),
              (presentation_set_duration, 0),
              (assign, "$g_presentation_state", 0),
              (start_presentation, "prsnt_multiplayer_item_select"),
            (else_try),
              (eq, ":object", "$g_presentation_obj_item_select_5"),
              (store_add, ":selected_item_index", slot_player_selected_item_indices_begin, 4),
              (player_set_slot, ":my_player_no", ":selected_item_index", -1),
              (presentation_set_duration, 0),
              (assign, "$g_presentation_state", 0),
              (start_presentation, "prsnt_multiplayer_item_select"),
            (else_try),
              (eq, ":object", "$g_presentation_obj_item_select_6"),
              (store_add, ":selected_item_index", slot_player_selected_item_indices_begin, 5),
              (player_set_slot, ":my_player_no", ":selected_item_index", -1),
              (presentation_set_duration, 0),
              (assign, "$g_presentation_state", 0),
              (start_presentation, "prsnt_multiplayer_item_select"),
            (else_try),
              (eq, ":object", "$g_presentation_obj_item_select_7"),
              (store_add, ":selected_item_index", slot_player_selected_item_indices_begin, 6),
              (player_set_slot, ":my_player_no", ":selected_item_index", -1),
              (presentation_set_duration, 0),
              (assign, "$g_presentation_state", 0),
              (start_presentation, "prsnt_multiplayer_item_select"),
            (else_try),
              (eq, ":object", "$g_presentation_obj_item_select_8"),
              (store_add, ":selected_item_index", slot_player_selected_item_indices_begin, 7),
              (player_set_slot, ":my_player_no", ":selected_item_index", -1),
              (presentation_set_duration, 0),
              (assign, "$g_presentation_state", 0),
              (start_presentation, "prsnt_multiplayer_item_select"),
            (else_try),
              (eq, ":object", "$g_presentation_obj_item_select_9"),
              (eq, "$g_horses_are_avaliable", 1),
              (store_add, ":selected_item_index", slot_player_selected_item_indices_begin, 8),
              (player_set_slot, ":my_player_no", ":selected_item_index", -1),
              (presentation_set_duration, 0),
              (assign, "$g_presentation_state", 0),
              (start_presentation, "prsnt_multiplayer_item_select"),
            (try_end),
          (else_try),
            (gt, "$g_presentation_state", 0),
            (presentation_set_duration, 0),
            (assign, "$g_presentation_state", 0),
            (start_presentation, "prsnt_multiplayer_item_select"),      
          (try_end),
        (try_end),
      (else_try),
        (assign, "$g_close_equipment_selection", 0),
        (presentation_set_duration, 0),
      (try_end),      
      ]),
    
    (ti_on_presentation_run,
     [(store_trigger_param_1, ":cur_time"),

## this causes an error sometimes
##      (multiplayer_get_my_player, ":my_player_no"),
##      (player_get_gold, ":player_gold", ":my_player_no"),
##      (call_script, "script_multiplayer_calculate_cur_selected_items_cost", ":my_player_no", 1),      
##      (try_begin),
##        (ge, ":player_gold", reg0),
##        (overlay_set_color, "$g_presentation_obj_item_select_12", 0xFFFFFF),
##      (else_try),
##        (overlay_set_color, "$g_presentation_obj_item_select_12", 0xFF0000),
##      (try_end),

      (try_begin),
        (eq, "$g_close_equipment_selection", 0),
        (try_begin),
          (this_or_next|key_clicked, key_escape),
		  (key_clicked, key_xbox_start),
          (try_begin),
            (neq, "$g_current_opened_item_details", -1),
            (close_item_details),
            (assign, "$g_current_opened_item_details", -1),
          (try_end),
          (gt, ":cur_time", 200),
          (presentation_set_duration, 0),
        (try_end),
      (else_try),
        (assign, "$g_close_equipment_selection", 0),
        #daha sonra buraya siege modundaysa ve takimini yeni degistirdigi icin spawn olamiyorsa start_presentation, spawn_counter satirini ekle sdsd.
        (presentation_set_duration, 0),
      (try_end),
      ]),
    ]),

  ("multiplayer_message_1", prsntf_read_only|prsntf_manual_end_only, 0, [
    (ti_on_presentation_load, [
      (set_fixed_point_multiplier, 1000),
      (try_begin),
        (eq, "$g_multiplayer_message_type", multiplayer_message_type_round_result_in_battle_mode),
        (assign, ":winner_agent_team", "$g_multiplayer_message_value_1"),

        (try_begin),
          (eq, ":winner_agent_team", -1),
          (assign, ":text_font_color", 0xFFFFFFFF),

          (str_store_string, s0, "str_round_draw_no_one_remained"),
        (else_try),
          (try_begin), #for spectators initializing, we assume spectators are fan of team0 so coloring is applied as they are at team0.
            (eq, ":winner_agent_team", 0),
            (assign, ":text_font_color", 0xFF33DD11),
          (else_try),
            (assign, ":text_font_color", 0xFFFF4422),
          (try_end), #initializing ends
          (try_begin),
            (lt, "$my_team_at_start_of_round", 2),
            (try_begin),
              (eq, "$my_team_at_start_of_round", ":winner_agent_team"),
              (assign, ":text_font_color", 0xFF33DD11),
            (else_try),
              (assign, ":text_font_color", 0xFFFF4422),
            (try_end),
          (try_end),

          (team_get_faction, ":faction_of_winner_team", ":winner_agent_team"),
          (str_store_faction_name, s1, ":faction_of_winner_team"),
          (str_store_string, s0, "str_s1_won_round"),
        (try_end),

        (create_text_overlay, "$g_multiplayer_message_1", s0, tf_center_justify|tf_with_outline),
        (overlay_set_color, "$g_multiplayer_message_1", ":text_font_color"),
        (try_begin),
          (neq, ":winner_agent_team", -1),
          (position_set_x, pos1, 375), #375
        (else_try),
          (position_set_x, pos1, 400), #400
        (try_end),
        (position_set_x, pos1, 500), #new
        (position_set_y, pos1, 400),
        (overlay_set_position, "$g_multiplayer_message_1", pos1),
        (position_set_x, pos1, 2000),
        (position_set_y, pos1, 2000),
        (overlay_set_size, "$g_multiplayer_message_1", pos1),
        (presentation_set_duration, 300),
      (else_try),
        (eq, "$g_multiplayer_message_type", multiplayer_message_type_capture_the_flag_score),

        (agent_get_team, ":winner_agent_team", "$g_multiplayer_message_value_1"), #assign given agent's team to winner agent team.
        (team_get_faction, ":winner_agent_faction", ":winner_agent_team"),
        (str_store_faction_name, s1, ":winner_agent_faction"),

        (try_begin), #for spectators initializing, we assume spectators are fan of team0 so coloring is applied as they are at team0.
          (eq, ":winner_agent_team", 0),
          (assign, ":text_font_color", 0xFF33DD11),
        (else_try),
          (assign, ":text_font_color", 0xFFFF4422),
        (try_end), #initializing ends
        (multiplayer_get_my_player, ":my_player_no"),
        (try_begin),
          (ge, ":my_player_no", 0),
          (player_get_agent_id, ":my_player_agent", ":my_player_no"),
          (try_begin),
            (ge, ":my_player_agent", 0),
            (agent_get_team, ":my_player_team", ":my_player_agent"),
            (try_begin),
              (eq, ":my_player_team", ":winner_agent_team"),
              (assign, ":text_font_color", 0xFF33DD11),
              (play_sound, "snd_team_scored_a_point"),
            (else_try),
              (assign, ":text_font_color", 0xFFFF4422),
              (play_sound, "snd_enemy_scored_a_point"),
            (try_end),
          (try_end),
        (try_end),

        (str_store_string, s0, "str_s1_captured_flag"),
        (create_text_overlay, "$g_multiplayer_message_1", s0, tf_center_justify|tf_with_outline),
        (overlay_set_color, "$g_multiplayer_message_1", ":text_font_color"),
        (position_set_x, pos1, 350),
        (position_set_x, pos1, 500), #new
        (position_set_y, pos1, 400),
        (overlay_set_position, "$g_multiplayer_message_1", pos1),
        (position_set_x, pos1, 2000),
        (position_set_y, pos1, 2000),
        (overlay_set_size, "$g_multiplayer_message_1", pos1),
        (presentation_set_duration, 400),
      (else_try),
        (eq, "$g_multiplayer_message_type", multiplayer_message_type_flag_returned_home),

        (try_begin),
          (ge, "$g_multiplayer_message_value_1", 0),
          (agent_get_team, ":returned_flag_agent_team", "$g_multiplayer_message_value_1"), 
          (team_get_faction, ":returned_flag_agent_faction", ":returned_flag_agent_team"),
          (str_store_faction_name, s1, ":returned_flag_agent_faction"),
          (str_store_string, s0, "str_s1_returned_flag"),
        (else_try),
          (val_add, "$g_multiplayer_message_value_1", 1),
          (val_mul, "$g_multiplayer_message_value_1", -1),
          (assign, ":returned_flag_agent_team", "$g_multiplayer_message_value_1"),
          (team_get_faction, ":returned_flag_agent_faction", ":returned_flag_agent_team"),
          (str_store_faction_name, s1, ":returned_flag_agent_faction"),
          (str_store_string, s0, "str_s1_auto_returned_flag"),
        (try_end),

        (multiplayer_get_my_player, ":my_player_no"),
        (try_begin),
          (ge, ":my_player_no", 0),
          (player_get_agent_id, ":my_player_agent", ":my_player_no"),
          (try_begin),
            (ge, ":my_player_agent", 0),
            (play_sound, "snd_flag_returned"),
          (try_end),
        (try_end),
        (assign, ":text_font_color", 0xFFFFFFFF),

        (create_text_overlay, "$g_multiplayer_message_1", s0, tf_center_justify|tf_with_outline),
        (overlay_set_color, "$g_multiplayer_message_1", ":text_font_color"),
        (position_set_x, pos1, 325),
        (position_set_y, pos1, 400),
        (position_set_x, pos1, 500), #new
        (overlay_set_position, "$g_multiplayer_message_1", pos1),
        (position_set_x, pos1, 2000),
        (position_set_y, pos1, 2000),
        (overlay_set_size, "$g_multiplayer_message_1", pos1),
        (presentation_set_duration, 400),
      (else_try),
        (eq, "$g_multiplayer_message_type", multiplayer_message_type_capture_the_flag_stole),

        (agent_get_team, ":stolen_flag_agent_team", "$g_multiplayer_message_value_1"), 
        (team_get_faction, ":stolen_flag_agent_faction", ":stolen_flag_agent_team"),
        (str_store_faction_name, s1, ":stolen_flag_agent_faction"),

        (assign, ":text_font_color", 0xFFFFFFFF),

        (multiplayer_get_my_player, ":my_player_no"),
        (try_begin),
          (ge, ":my_player_no", 0),
          (player_get_agent_id, ":my_player_agent", ":my_player_no"),
          (try_begin),
            (ge, ":my_player_agent", 0),
            (agent_get_team, ":my_player_team", ":my_player_agent"),
            (try_begin),
              (eq, ":my_player_team", ":stolen_flag_agent_team"),
              (play_sound, "snd_enemy_flag_taken"),
            (else_try),
              (play_sound, "snd_your_flag_taken"),
            (try_end),
          (try_end),
        (try_end),

        (str_store_string, s0, "str_s1_taken_flag"),
        (create_text_overlay, "$g_multiplayer_message_1", s0, tf_center_justify|tf_with_outline),
        (overlay_set_color, "$g_multiplayer_message_1", ":text_font_color"),
        (position_set_x, pos1, 365),
        (position_set_x, pos1, 500), #new
        (position_set_y, pos1, 400),
        (overlay_set_position, "$g_multiplayer_message_1", pos1),
        (position_set_x, pos1, 2000),
        (position_set_y, pos1, 2000),
        (overlay_set_size, "$g_multiplayer_message_1", pos1),
        (presentation_set_duration, 400),
      (else_try),
        (eq, "$g_multiplayer_message_type", multiplayer_message_type_flag_captured),
      
        (store_div, ":winner_agent_team", "$g_multiplayer_message_value_1", 100),
        (store_mod, reg0, "$g_multiplayer_message_value_1", 100),
        (val_sub, ":winner_agent_team", 1),

        (try_begin), #for spectators initializing, we assume spectators are fan of team0 so coloring is applied as they are at team0.
          (eq, ":winner_agent_team", 0),
          (assign, ":text_font_color", 0xFF33DD11),
        (else_try),
          (assign, ":text_font_color", 0xFFFF4422),
        (try_end), #initializing ends
        (multiplayer_get_my_player, ":my_player_no"),
        (try_begin),
          (ge, ":my_player_no", 0),
          (player_get_agent_id, ":my_player_agent", ":my_player_no"),
          (try_begin),
            (ge, ":my_player_agent", 0),
            (agent_get_team, ":my_player_team", ":my_player_agent"),
            (try_begin),
              (eq, ":my_player_team", ":winner_agent_team"),
              (assign, ":text_font_color", 0xFF33DD11),
              (play_sound, "snd_team_scored_a_point"),
            (else_try),
              (assign, ":text_font_color", 0xFFFF4422),
              (play_sound, "snd_enemy_scored_a_point"),
            (try_end),
          (try_end),
        (try_end),

        (team_get_faction, ":winner_agent_faction", ":winner_agent_team"),
        (str_store_faction_name, s1, ":winner_agent_faction"),

        (str_store_string, s0, "str_s1_captured_flag_reg0"),
        (create_text_overlay, "$g_multiplayer_message_1", s0, tf_center_justify|tf_with_outline),
        (overlay_set_color, "$g_multiplayer_message_1", ":text_font_color"),
        (position_set_x, pos1, 345),
        (position_set_x, pos1, 500), #new
        (position_set_y, pos1, 400),
        (overlay_set_position, "$g_multiplayer_message_1", pos1),
        (position_set_x, pos1, 2000),
        (position_set_y, pos1, 2000),
        (overlay_set_size, "$g_multiplayer_message_1", pos1),
        (presentation_set_duration, 400),
      (else_try),
        (eq, "$g_multiplayer_message_type", multiplayer_message_type_flag_is_pulling),
      
        (store_div, ":winner_agent_team", "$g_multiplayer_message_value_1", 100),
        (store_mod, reg0, "$g_multiplayer_message_value_1", 100),
        (val_sub, ":winner_agent_team", 1),

        (multiplayer_get_my_player, ":my_player_no"),
        (try_begin),
          (ge, ":my_player_no", 0),
          (player_get_agent_id, ":my_player_agent", ":my_player_no"),
          (try_begin),
            (ge, ":my_player_agent", 0),
            (agent_get_team, ":my_player_team", ":my_player_agent"),
            (try_begin),
              (eq, ":my_player_team", ":winner_agent_team"),
              (play_sound, "snd_enemy_flag_taken"),
            (else_try),
              (play_sound, "snd_your_flag_taken"),
            (try_end),
          (try_end),
        (try_end),

        (assign, ":text_font_color", 0xFFFFFFFF),

        (team_get_faction, ":winner_agent_faction", ":winner_agent_team"),
        (str_store_faction_name, s1, ":winner_agent_faction"),      

        (str_store_string, s0, "str_s1_pulling_flag_reg0"),
        (create_text_overlay, "$g_multiplayer_message_1", s0, tf_center_justify|tf_with_outline),
        (overlay_set_color, "$g_multiplayer_message_1", ":text_font_color"),
        (position_set_x, pos1, 345),
        (position_set_x, pos1, 500), #new
        (position_set_y, pos1, 400),
        (overlay_set_position, "$g_multiplayer_message_1", pos1),
        (position_set_x, pos1, 2000),
        (position_set_y, pos1, 2000),
        (overlay_set_size, "$g_multiplayer_message_1", pos1),
        (presentation_set_duration, 400),
      (else_try),
        (eq, "$g_multiplayer_message_type", multiplayer_message_type_flag_neutralized),      

        (store_div, ":winner_agent_team", "$g_multiplayer_message_value_1", 100),
        (store_mod, reg0, "$g_multiplayer_message_value_1", 100),
        (val_sub, ":winner_agent_team", 1),

        (multiplayer_get_my_player, ":my_player_no"),
        (try_begin),
          (ge, ":my_player_no", 0),
          (player_get_agent_id, ":my_player_agent", ":my_player_no"),
          (try_begin),
            (ge, ":my_player_agent", 0),
            (play_sound, "snd_flag_returned"),
          (try_end),
        (try_end),

        (try_begin), #for spectators initializing, we assume spectators are fan of team0 so coloring is applied as they are at team0.
          (eq, ":winner_agent_team", 0),
          (assign, ":text_font_color", 0xFF33DD11),
        (else_try),
          (assign, ":text_font_color", 0xFFFF4422),
        (try_end), #initializing ends
        (multiplayer_get_my_player, ":my_player_no"),
        (try_begin),
          (ge, ":my_player_no", 0),
          (player_get_agent_id, ":my_player_agent", ":my_player_no"),
          (try_begin),
            (ge, ":my_player_agent", 0),
            (agent_get_team, ":my_player_team", ":my_player_agent"),
            (try_begin),
              (eq, ":my_player_team", ":winner_agent_team"),
              (assign, ":text_font_color", 0xFF33DD11),
            (else_try),
              (assign, ":text_font_color", 0xFFFF4422),
            (try_end),
          (try_end),
        (try_end),

        (team_get_faction, ":winner_agent_faction", ":winner_agent_team"),
        (str_store_faction_name, s1, ":winner_agent_faction"),

        (str_store_string, s0, "str_s1_neutralized_flag_reg0"),
        (create_text_overlay, "$g_multiplayer_message_1", s0, tf_center_justify|tf_with_outline),
        (overlay_set_color, "$g_multiplayer_message_1", ":text_font_color"),
        (position_set_x, pos1, 345),
        (position_set_x, pos1, 500), #new
        (position_set_y, pos1, 400),
        (overlay_set_position, "$g_multiplayer_message_1", pos1),
        (position_set_x, pos1, 2000),
        (position_set_y, pos1, 2000),
        (overlay_set_size, "$g_multiplayer_message_1", pos1),
        (presentation_set_duration, 400),
      (else_try),     
        (eq, "$g_multiplayer_message_type", multiplayer_message_type_round_result_in_siege_mode),      

        (assign, ":winner_agent_team", "$g_multiplayer_message_value_1"),

        (try_begin), #for spectators initializing, we assume spectators are fan of team0 so coloring is applied as they are at team0.
          (eq, ":winner_agent_team", 0),
          (assign, ":text_font_color", 0xFF33DD11),
        (else_try),
          (assign, ":text_font_color", 0xFFFF4422),
        (try_end), #initializing ends
        (multiplayer_get_my_player, ":my_player_no"),
        (try_begin),
          (ge, ":my_player_no", 0),
          (player_get_agent_id, ":my_player_agent", ":my_player_no"),
          (try_begin),
            (ge, ":my_player_agent", 0),
            (agent_get_team, ":my_player_team", ":my_player_agent"),
            (try_begin),
              (eq, ":my_player_team", ":winner_agent_team"),
              (assign, ":text_font_color", 0xFF33DD11),
            (else_try),
              (assign, ":text_font_color", 0xFFFF4422),
            (try_end),
          (try_end),
        (try_end),

        (try_begin),
          (eq, "$g_multiplayer_message_value_1", 0),
          (str_store_string, s0, "str_s1_defended_castle"),
        (else_try),
          (eq, "$g_multiplayer_message_value_1", 1),
          (str_store_string, s0, "str_s1_captured_castle"),
        (else_try),
          (str_store_string, s0, "str_round_draw"),
          (assign, ":text_font_color", 0xFFFFFFFF),
        (try_end),
      
        (create_text_overlay, "$g_multiplayer_message_1", s0, tf_center_justify|tf_with_outline),
        (overlay_set_color, "$g_multiplayer_message_1", ":text_font_color"),
        (try_begin),
          (neq, "$g_multiplayer_message_value_1", -1),
          (position_set_x, pos1, 325),
        (else_try),
          (position_set_x, pos1, 400),
        (try_end),
        (position_set_x, pos1, 500), #new
        (position_set_y, pos1, 400),
        (overlay_set_position, "$g_multiplayer_message_1", pos1),
        (position_set_x, pos1, 2000),
        (position_set_y, pos1, 2000),
        (overlay_set_size, "$g_multiplayer_message_1", pos1),
        (presentation_set_duration, 400),
      (else_try),
        (eq, "$g_multiplayer_message_type", multiplayer_message_type_round_draw),
      
        (assign, ":text_font_color", 0xFFFFFFFF),
        (str_store_string, s0, "str_round_draw"),
        (create_text_overlay, "$g_multiplayer_message_1", s0, tf_center_justify|tf_with_outline),
        (overlay_set_color, "$g_multiplayer_message_1", ":text_font_color"),
        (position_set_x, pos1, 375),
        (position_set_x, pos1, 500), #new
        (position_set_y, pos1, 400),
        (overlay_set_position, "$g_multiplayer_message_1", pos1),
        (position_set_x, pos1, 2000),
        (position_set_y, pos1, 2000),
        (overlay_set_size, "$g_multiplayer_message_1", pos1),
        (presentation_set_duration, 400),
      (else_try),
        (eq, "$g_multiplayer_message_type", multiplayer_message_type_start_death_mode),
      
        (assign, ":text_font_color", 0xFFFFFFFF),
        (str_store_string, s0, "str_death_mode_started"),
        (create_text_overlay, "$g_multiplayer_message_1", s0, tf_center_justify|tf_with_outline),
        (overlay_set_color, "$g_multiplayer_message_1", ":text_font_color"),
        (position_set_x, pos1, 350),
        (position_set_x, pos1, 500), #new
        (position_set_y, pos1, 400),
        (overlay_set_position, "$g_multiplayer_message_1", pos1),
        (position_set_x, pos1, 2000),
        (position_set_y, pos1, 2000),
        (overlay_set_size, "$g_multiplayer_message_1", pos1),
        (presentation_set_duration, 400),      
      (else_try),
        (eq, "$g_multiplayer_message_type", multiplayer_message_type_target_destroyed),

        (try_begin),
          (lt, "$g_multiplayer_message_value_1", 0),
          (val_mul, "$g_multiplayer_message_value_1", -1),
          (assign, ":scene_prop_team", 0),

          (team_get_faction, ":faction_of_winner_team", 1),
          (str_store_faction_name, s1, ":faction_of_winner_team"),
        (else_try),
          (assign, ":scene_prop_team", 1),

          (team_get_faction, ":faction_of_winner_team", 0),
          (str_store_faction_name, s1, ":faction_of_winner_team"),
        (try_end),

        (try_begin), #for spectators initializing, we assume spectators are fan of team0 so coloring is applied as they are at team0.
          (eq, "$g_multiplayer_message_value_1", 1),
          (assign, ":text_font_color", 0xFF33DD11),
        (else_try),
          (assign, ":text_font_color", 0xFFFF4422),
        (try_end), #initializing ends
        (multiplayer_get_my_player, ":my_player_no"),
        (try_begin),
          (ge, ":my_player_no", 0),
          (try_begin),
            (multiplayer_get_my_player, ":my_player_no"),
            (player_get_team_no, ":my_team_no", ":my_player_no"),
            (neq, ":scene_prop_team", ":my_team_no"), #if scene prop and I have different teams this means we won
            (assign, ":text_font_color", 0xFF33DD11),
          (else_try),
            (assign, ":text_font_color", 0xFFFF4422),
          (try_end),
        (try_end),

        (try_begin),
          (eq, "$g_multiplayer_message_value_1", 9),
          (str_store_string, s0, "str_s1_destroyed_all_targets"),
        (else_try),
          (eq, "$g_multiplayer_message_value_1", 1),
          (str_store_string, s0, "str_s1_destroyed_catapult"),
        (else_try),
          (eq, "$g_multiplayer_message_value_1", 2),
          (str_store_string, s0, "str_s1_destroyed_trebuchet"),
        (try_end),
      
        (create_text_overlay, "$g_multiplayer_message_1", s0, tf_center_justify|tf_with_outline),
        (overlay_set_color, "$g_multiplayer_message_1", ":text_font_color"),
        (position_set_x, pos1, 350),
        (position_set_x, pos1, 500), #new
        (position_set_y, pos1, 400),
        (overlay_set_position, "$g_multiplayer_message_1", pos1),
        (position_set_x, pos1, 2000),
        (position_set_y, pos1, 2000),
        (overlay_set_size, "$g_multiplayer_message_1", pos1),
        (presentation_set_duration, 400),
      (else_try),
        (eq, "$g_multiplayer_message_type", multiplayer_message_type_defenders_saved_n_targets),

        (try_begin), #for spectators initializing, we assume spectators are fan of team0 so coloring is applied as they are at team0.
          (eq, "$g_defender_team", 0),
          (assign, ":text_font_color", 0xFF33DD11),
        (else_try),
          (assign, ":text_font_color", 0xFFFF4422),
        (try_end), #initializing ends
        (multiplayer_get_my_player, ":my_player_no"),
        (try_begin),
          (ge, ":my_player_no", 0),
          (player_get_agent_id, ":my_player_agent", ":my_player_no"),
          (try_begin),
            (ge, ":my_player_agent", 0),
            (agent_get_team, ":my_player_team", ":my_player_agent"),
            (try_begin),
              (eq, ":my_player_team", "$g_defender_team"),
              (assign, ":text_font_color", 0xFF33DD11),
            (else_try),
              (assign, ":text_font_color", 0xFFFF4422),
            (try_end),
          (try_end),
        (try_end),

        (assign, ":num_targets_saved", "$g_multiplayer_message_value_1"),

        (team_get_faction, ":faction_of_winner_team", "$g_defender_team"),
        (str_store_faction_name, s1, ":faction_of_winner_team"),

        (try_begin),
          (eq, ":num_targets_saved", 1),
          (str_store_string, s0, "str_s1_saved_1_target"),
        (else_try),
          (eq, ":num_targets_saved", 2),
          (str_store_string, s0, "str_s1_saved_2_targets"),
        (try_end),
      
        (create_text_overlay, "$g_multiplayer_message_1", s0, tf_center_justify|tf_with_outline),
        (overlay_set_color, "$g_multiplayer_message_1", ":text_font_color"),
        (position_set_x, pos1, 350),
        (position_set_x, pos1, 500), #new
        (position_set_y, pos1, 400),
        (overlay_set_position, "$g_multiplayer_message_1", pos1),
        (position_set_x, pos1, 2000),
        (position_set_y, pos1, 2000),
        (overlay_set_size, "$g_multiplayer_message_1", pos1),
        (presentation_set_duration, 400),      
      (else_try),
        (eq, "$g_multiplayer_message_type", multiplayer_message_type_attackers_won_the_round),

        (assign, ":winner_agent_team", "$g_multiplayer_message_value_1"),

        (try_begin), #for spectators initializing, we assume spectators are fan of team0 so coloring is applied as they are at team0.
          (eq, ":winner_agent_team", 0),
          (assign, ":text_font_color", 0xFF33DD11),
        (else_try),
          (assign, ":text_font_color", 0xFFFF4422),
        (try_end), #initializing ends
        (multiplayer_get_my_player, ":my_player_no"),
        (try_begin),
          (ge, ":my_player_no", 0),
          (player_get_agent_id, ":my_player_agent", ":my_player_no"),
          (try_begin),
            (ge, ":my_player_agent", 0),
            (agent_get_team, ":my_player_team", ":my_player_agent"),
            (try_begin),
              (eq, ":my_player_team", ":winner_agent_team"),
              (assign, ":text_font_color", 0xFF33DD11),
            (else_try),
              (assign, ":text_font_color", 0xFFFF4422),
            (try_end),
          (try_end),
        (try_end),

        (try_begin),
          (eq, "$g_defender_team", 0),
          (team_get_faction, ":faction_of_winner_team", 1),
        (else_try),
          (team_get_faction, ":faction_of_winner_team", 0),
        (try_end),
        (str_store_faction_name, s1, ":faction_of_winner_team"),

        (str_store_string, s0, "str_s1_won_round"),
        (create_text_overlay, "$g_multiplayer_message_1", s0, tf_center_justify|tf_with_outline),
        (overlay_set_color, "$g_multiplayer_message_1", ":text_font_color"),
        (position_set_x, pos1, 350),
        (position_set_x, pos1, 500), #new
        (position_set_y, pos1, 400),
        (overlay_set_position, "$g_multiplayer_message_1", pos1),
        (position_set_x, pos1, 2000),
        (position_set_y, pos1, 2000),
        (overlay_set_size, "$g_multiplayer_message_1", pos1),
        (presentation_set_duration, 400),      
      (try_end),
      ]),
    (ti_on_presentation_run,
     [
       ]),
     ]),

  ("multiplayer_message_2", prsntf_read_only|prsntf_manual_end_only, 0, [
    (ti_on_presentation_load, [
      (set_fixed_point_multiplier, 1000),
      (try_begin),
        (eq, "$g_multiplayer_message_type", multiplayer_message_type_auto_team_balance_done),
        (assign, ":text_font_color", 0xFFFFFFFF),
        (str_store_string, s0, "str_auto_team_balance_done"),
        (create_text_overlay, "$g_multiplayer_message_2", s0, tf_center_justify|tf_with_outline),
        (overlay_set_color, "$g_multiplayer_message_2", ":text_font_color"),
        (position_set_x, pos1, 375),
        (position_set_x, pos1, 500), #new
        (position_set_y, pos1, 550),
        (overlay_set_position, "$g_multiplayer_message_2", pos1),
        (position_set_x, pos1, 2000),
        (position_set_y, pos1, 2000),
        (overlay_set_size, "$g_multiplayer_message_2", pos1),
        (presentation_set_duration, 300),
      (else_try),
        (eq, "$g_multiplayer_message_type", multiplayer_message_type_auto_team_balance_next),
        (assign, ":text_font_color", 0xFFFFFFFF),

        (try_begin),
          (neq, "$g_multiplayer_game_type", multiplayer_game_type_battle),
          (neq, "$g_multiplayer_game_type", multiplayer_game_type_destroy),
          (neq, "$g_multiplayer_game_type", multiplayer_game_type_siege),
          (str_store_string, s0, "str_auto_team_balance_in_20_seconds"),
          (position_set_x, pos1, 375),
        (else_try),
          (str_store_string, s0, "str_auto_team_balance_next_round"),
          (position_set_x, pos1, 375),
        (try_end),
      
        (create_text_overlay, "$g_multiplayer_message_2", s0, tf_center_justify|tf_with_outline),
        (overlay_set_color, "$g_multiplayer_message_2", ":text_font_color"),
        (position_set_y, pos1, 550),
        (position_set_x, pos1, 500), #new
        (overlay_set_position, "$g_multiplayer_message_2", pos1),
        (position_set_x, pos1, 2000),
        (position_set_y, pos1, 2000),
        (overlay_set_size, "$g_multiplayer_message_2", pos1),
        (presentation_set_duration, 300),
      (try_end),
      ]),
    (ti_on_presentation_run,
     [
       ]),
     ]),
      
  ("multiplayer_message_3", prsntf_read_only|prsntf_manual_end_only, 0, [
    (ti_on_presentation_load, [
      (set_fixed_point_multiplier, 1000),      
      (try_begin),
        (eq, "$g_multiplayer_message_type", multiplayer_message_type_poll_result),
      
        (assign, ":text_font_color", 0xFFFFFFFF),
        (try_begin),
          (eq, "$g_multiplayer_message_value_3", 1),
          (str_store_string, s0, "str_poll_result_yes"),
        (else_try),
          (str_store_string, s0, "str_poll_result_no"),
        (try_end),
        (create_text_overlay, "$g_multiplayer_message_3", s0, tf_center_justify|tf_with_outline),
        (overlay_set_color, "$g_multiplayer_message_3", ":text_font_color"),
        (position_set_x, pos1, 380),
        (position_set_x, pos1, 500), #new
        (position_set_y, pos1, 475),
        (overlay_set_position, "$g_multiplayer_message_3", pos1),
        (position_set_x, pos1, 2000),
        (position_set_y, pos1, 2000),
        (overlay_set_size, "$g_multiplayer_message_3", pos1),
        (presentation_set_duration, 400),
      (try_end),
      ]),
    (ti_on_presentation_run,
     [
       ]),
     ]),

  ("multiplayer_round_time_counter", prsntf_read_only|prsntf_manual_end_only, 0, [
    (ti_on_presentation_load, [
      (set_fixed_point_multiplier, 1000),
      (assign, "$g_multiplayer_last_round_time_counter_value", -1),
      (str_clear, s0),
      (create_text_overlay, "$g_multiplayer_round_time_counter_overlay", s0, tf_left_align|tf_single_line|tf_with_outline),
      (overlay_set_color, "$g_multiplayer_round_time_counter_overlay", 0xFFFFFF),
      (position_set_x, pos1, 900),
      (position_set_y, pos1, 690),
      (overlay_set_position, "$g_multiplayer_round_time_counter_overlay", pos1),
      (position_set_x, pos1, 2000),
      (position_set_y, pos1, 2000),
      (overlay_set_size, "$g_multiplayer_round_time_counter_overlay", pos1),
      (presentation_set_duration, 999999),
      ]),
    (ti_on_presentation_run,
     [(store_mission_timer_a, ":current_time"),
      (store_sub, ":seconds_past_in_round", ":current_time", "$g_round_start_time"),
      (store_sub, ":seconds_left_in_round", "$g_multiplayer_round_max_seconds", ":seconds_past_in_round"),
      (val_max, ":seconds_left_in_round", 0),
      (try_begin),
        (neq, "$g_multiplayer_last_round_time_counter_value", ":seconds_left_in_round"),
        (assign, "$g_multiplayer_last_round_time_counter_value", ":seconds_left_in_round"),
        (store_div, reg0, ":seconds_left_in_round", 60),
        (store_div, reg1, ":seconds_left_in_round", 10),
        (val_mod, reg1, 6),
        (assign, reg2, ":seconds_left_in_round"),
        (val_mod, reg2, 10),
        (str_store_string, s0, "str_reg0_dd_reg1reg2"),
        (overlay_set_text, "$g_multiplayer_round_time_counter_overlay", s0),
      (try_end),
      ]),
    ]),

  ("multiplayer_team_score_display", prsntf_read_only|prsntf_manual_end_only, 0, [
    (ti_on_presentation_load, [
      (set_fixed_point_multiplier, 1000),
      (assign, "$g_multiplayer_team_1_last_displayed_score", -1),
      (assign, "$g_multiplayer_team_2_last_displayed_score", -1),
      (str_clear, s0),
      (create_text_overlay, "$g_multiplayer_team_1_score_display_overlay", s0, tf_left_align|tf_single_line|tf_with_outline),
      (overlay_set_color, "$g_multiplayer_team_1_score_display_overlay", 0xFFFFFF),
      (position_set_x, pos1, 40),
      (position_set_y, pos1, 700),
      (overlay_set_position, "$g_multiplayer_team_1_score_display_overlay", pos1),
      (position_set_x, pos1, 1500),
      (position_set_y, pos1, 1500),
      (overlay_set_size, "$g_multiplayer_team_1_score_display_overlay", pos1),
      (create_text_overlay, "$g_multiplayer_team_2_score_display_overlay", s0, tf_left_align|tf_single_line|tf_with_outline),
      (overlay_set_color, "$g_multiplayer_team_2_score_display_overlay", 0xFFFFFF),
      (position_set_x, pos1, 40),
      (position_set_y, pos1, 645),
      (overlay_set_position, "$g_multiplayer_team_2_score_display_overlay", pos1),
      (position_set_x, pos1, 1500),
      (position_set_y, pos1, 1500),
      (overlay_set_size, "$g_multiplayer_team_2_score_display_overlay", pos1),

      (try_begin),
        (eq, "$g_multiplayer_team_1_faction", "fac_kingdom_4"),
        (create_mesh_overlay, reg0, "mesh_ui_kingdom_shield_1"),
      (else_try),
        (eq, "$g_multiplayer_team_1_faction", "fac_kingdom_2"),
        (create_mesh_overlay, reg0, "mesh_ui_kingdom_shield_2"),
      (else_try),
        (eq, "$g_multiplayer_team_1_faction", "fac_kingdom_3"),
        (create_mesh_overlay, reg0, "mesh_ui_kingdom_shield_3"),
      (else_try),
        (eq, "$g_multiplayer_team_1_faction", "fac_kingdom_5"),
        (create_mesh_overlay, reg0, "mesh_ui_kingdom_shield_4"),
      (else_try),
        (eq, "$g_multiplayer_team_1_faction", "fac_kingdom_6"),
        (create_mesh_overlay, reg0, "mesh_ui_kingdom_shield_5"),
      (else_try),
        (eq, "$g_multiplayer_team_1_faction", "fac_kingdom_1"),
        (create_mesh_overlay, reg0, "mesh_ui_kingdom_shield_6"),
      (try_end),

      (position_set_x, pos3, 25),
      (position_set_y, pos3, 715),
      (overlay_set_position, reg0, pos3),
      (position_set_x, pos1, 50),
      (position_set_y, pos1, 50),
      (overlay_set_size, reg0, pos1),      

      (try_begin),
        (eq, "$g_multiplayer_team_1_faction", "$g_multiplayer_team_2_faction"),
        (create_mesh_overlay, reg0, "mesh_ui_kingdom_shield_7"),
      (else_try),
        (eq, "$g_multiplayer_team_2_faction", "fac_kingdom_4"),
        (create_mesh_overlay, reg0, "mesh_ui_kingdom_shield_1"),
      (else_try),
        (eq, "$g_multiplayer_team_2_faction", "fac_kingdom_2"),
        (create_mesh_overlay, reg0, "mesh_ui_kingdom_shield_2"),
      (else_try),
        (eq, "$g_multiplayer_team_2_faction", "fac_kingdom_3"),
        (create_mesh_overlay, reg0, "mesh_ui_kingdom_shield_3"),
      (else_try),
        (eq, "$g_multiplayer_team_2_faction", "fac_kingdom_5"),
        (create_mesh_overlay, reg0, "mesh_ui_kingdom_shield_4"),
      (else_try),
        (eq, "$g_multiplayer_team_2_faction", "fac_kingdom_6"),
        (create_mesh_overlay, reg0, "mesh_ui_kingdom_shield_5"),
      (else_try),
        (eq, "$g_multiplayer_team_2_faction", "fac_kingdom_1"),
        (create_mesh_overlay, reg0, "mesh_ui_kingdom_shield_6"),
      (try_end),

      (position_set_x, pos3, 25),
      (position_set_y, pos3, 660),
      (overlay_set_position, reg0, pos3),
      (position_set_x, pos1, 50),
      (position_set_y, pos1, 50),
      (overlay_set_size, reg0, pos1),      

      (presentation_set_duration, 999999),
      ]),
    (ti_on_presentation_run, [
      (team_get_score, ":team_1_score", 0),
      (team_get_score, ":team_2_score", 1),
      (try_begin),
        (this_or_next|neq, ":team_1_score", "$g_multiplayer_team_1_last_displayed_score"),
        (neq, ":team_2_score", "$g_multiplayer_team_2_last_displayed_score"),
        (assign, "$g_multiplayer_team_1_last_displayed_score", ":team_1_score"),
        (assign, "$g_multiplayer_team_2_last_displayed_score", ":team_2_score"),
      
        (str_store_faction_name, s0, "$g_multiplayer_team_1_faction"),
        (assign, reg0, ":team_1_score"),
        (overlay_set_text, "$g_multiplayer_team_1_score_display_overlay", "str_reg0"),
        (str_store_faction_name, s0, "$g_multiplayer_team_2_faction"),
        (assign, reg0, ":team_2_score"),
        (overlay_set_text, "$g_multiplayer_team_2_score_display_overlay", "str_reg0"),

##        (str_store_faction_name, s0, "$g_multiplayer_team_1_faction"),
##        (assign, reg0, ":team_1_score"),
##        (overlay_set_text, "$g_multiplayer_team_1_score_display_overlay", "str_s0_dd_reg0"),
##        (str_store_faction_name, s0, "$g_multiplayer_team_2_faction"),
##        (assign, reg0, ":team_2_score"),
##        (overlay_set_text, "$g_multiplayer_team_2_score_display_overlay", "str_s0_dd_reg0"),
      (try_end),
      ]),
    ]),


  ("multiplayer_flag_projection_display", prsntf_read_only|prsntf_manual_end_only, 0, [
    (ti_on_presentation_load, 
    [
      (set_fixed_point_multiplier, 1000),

      (store_sub, ":flag_mesh", "$g_multiplayer_team_1_faction", npc_kingdoms_begin),
      (val_add, ":flag_mesh", multiplayer_flag_projections_begin),
      (create_mesh_overlay, "$g_presentation_obj_flag_projection_display_1", ":flag_mesh"),
      (val_sub, ":flag_mesh", multiplayer_flag_projections_begin),
      (val_add, ":flag_mesh", multiplayer_flag_taken_projections_begin),
      (create_mesh_overlay, "$g_presentation_obj_flag_projection_display_2", ":flag_mesh"),
      
      (try_begin),
        (neq, "$g_multiplayer_team_1_faction", "$g_multiplayer_team_2_faction"),
        (store_sub, ":flag_mesh", "$g_multiplayer_team_2_faction", npc_kingdoms_begin),
        (val_add, ":flag_mesh", multiplayer_flag_projections_begin),
        (create_mesh_overlay, "$g_presentation_obj_flag_projection_display_3", ":flag_mesh"),
        (val_sub, ":flag_mesh", multiplayer_flag_projections_begin),
        (val_add, ":flag_mesh", multiplayer_flag_taken_projections_begin),
        (create_mesh_overlay, "$g_presentation_obj_flag_projection_display_4", ":flag_mesh"),
      (else_try),
        (assign, ":flag_mesh", "mesh_flag_project_rb"),
        (create_mesh_overlay, "$g_presentation_obj_flag_projection_display_3", ":flag_mesh"),
        (assign, ":flag_mesh", "mesh_flag_project_rb_miss"),
        (create_mesh_overlay, "$g_presentation_obj_flag_projection_display_4", ":flag_mesh"),      
      (try_end),
      
      (position_set_x, pos1, 250),
      (position_set_y, pos1, 250),
      (overlay_set_size, "$g_presentation_obj_flag_projection_display_1", pos1),
      (overlay_set_size, "$g_presentation_obj_flag_projection_display_2", pos1),
      (overlay_set_size, "$g_presentation_obj_flag_projection_display_3", pos1),
      (overlay_set_size, "$g_presentation_obj_flag_projection_display_4", pos1),
      (overlay_set_display, "$g_presentation_obj_flag_projection_display_1", 0),
      (overlay_set_display, "$g_presentation_obj_flag_projection_display_2", 0),
      (overlay_set_display, "$g_presentation_obj_flag_projection_display_3", 0),
      (overlay_set_display, "$g_presentation_obj_flag_projection_display_4", 0),
      (presentation_set_duration, 999999),
      ]),
      
    (ti_on_presentation_run, 
    [
      (set_fixed_point_multiplier, 1000),
      
      (scene_prop_get_instance, ":flag_red_id", "$team_1_flag_scene_prop", 0),      
      (team_get_slot, ":team_0_flag_situation", 0, slot_team_flag_situation),      
      (try_begin),
        (neq, ":team_0_flag_situation", 1),
        (prop_instance_get_position, pos1, ":flag_red_id"), #hold position of flag of team 1 (red flag) at pos1
      (else_try),
        (entry_point_get_position, pos1, multi_base_point_team_1), #moved from above to here after auto-set position      
      (try_end),            
      (position_move_z, pos1, 200, 1),
      
      (scene_prop_get_instance, ":flag_blue_id", "$team_2_flag_scene_prop", 0),      
      (team_get_slot, ":team_1_flag_situation", 1, slot_team_flag_situation),            
      (try_begin),
        (neq, ":team_1_flag_situation", 1),
        (prop_instance_get_position, pos2, ":flag_blue_id"), #hold position of flag of team 1 (red flag) at pos1
      (else_try),
        (entry_point_get_position, pos2, multi_base_point_team_2), #moved from above to here after auto-set position      
      (try_end),      
      (position_move_z, pos2, 200, 1),
            
      (position_get_screen_projection, pos3, pos1),
      (position_get_x, ":x_pos", pos3),
      (position_get_y, ":y_pos", pos3),
      (position_set_y, pos3, ":y_pos"),
      (try_begin),
        (is_between, ":x_pos", -100, 1100),
        (is_between, ":y_pos", -100, 850),

        (multiplayer_get_my_player, ":my_player_number"),
        (try_begin),
          (ge, ":my_player_number", 0),
          (player_get_team_no, ":my_player_team", ":my_player_number"),
        (else_try),
          (assign, ":my_player_team", multi_team_spectator),
        (try_end),

        (try_begin),
          (neq, ":my_player_team", 1), #if I am at team 0 or spectator
          (try_begin),
            (neq, ":team_0_flag_situation", 1), #if our flag is not stolen
            (overlay_set_position, "$g_presentation_obj_flag_projection_display_1", pos3),
            (overlay_set_display, "$g_presentation_obj_flag_projection_display_1", 1),
            (overlay_set_display, "$g_presentation_obj_flag_projection_display_2", 0),
          (else_try), #if our flag is stolen
            (try_begin),
              (eq, ":my_player_team", 0), 
              (assign, ":our_base_entry_id", multi_base_point_team_1),
            (else_try), 
              (assign, ":our_base_entry_id", multi_base_point_team_2),
            (try_end),

            (entry_point_get_position, pos5, ":our_base_entry_id"), #moved from above to here after auto-set position
            (position_get_screen_projection, pos3, pos5),

            (overlay_set_position, "$g_presentation_obj_flag_projection_display_2", pos3),
            (overlay_set_display, "$g_presentation_obj_flag_projection_display_2", 1),
            (overlay_set_display, "$g_presentation_obj_flag_projection_display_1", 0),
          (try_end),
        (else_try),
          (try_begin),
            (neq, ":team_0_flag_situation", 1),
            (overlay_set_position, "$g_presentation_obj_flag_projection_display_1", pos3),
            (overlay_set_display, "$g_presentation_obj_flag_projection_display_1", 1),
            (overlay_set_display, "$g_presentation_obj_flag_projection_display_2", 0),
          (try_end),
        (try_end),      
      (else_try),
        (overlay_set_display, "$g_presentation_obj_flag_projection_display_1", 0),
        (overlay_set_display, "$g_presentation_obj_flag_projection_display_2", 0),
      (try_end),
      
      (position_get_screen_projection, pos3, pos2),
      (position_get_x, ":x_pos", pos3),
      (position_get_y, ":y_pos", pos3),
      (position_set_y, pos3, ":y_pos"),
      (try_begin),
        (is_between, ":x_pos", -100, 1100),
        (is_between, ":y_pos", -100, 850),

        (team_get_slot, ":team_1_flag_situation", 1, slot_team_flag_situation),

        (multiplayer_get_my_player, ":my_player_number"),
        (try_begin),
          (ge, ":my_player_number", 0),
          (player_get_team_no, ":my_player_team", ":my_player_number"),
        (else_try),
          (assign, ":my_player_team", multi_team_spectator),
        (try_end),

        (try_begin),
          (neq, ":my_player_team", 0), #if I am at team 0 or spectator
          (try_begin),
            (neq, ":team_1_flag_situation", 1), #if our flag is not stolen
            (overlay_set_position, "$g_presentation_obj_flag_projection_display_3", pos3),
            (overlay_set_display, "$g_presentation_obj_flag_projection_display_3", 1),
            (overlay_set_display, "$g_presentation_obj_flag_projection_display_4", 0),
          (else_try), #if our flag is stolen      
            (try_begin),
              (eq, ":my_player_team", 0), 
              (assign, ":our_base_entry_id", multi_base_point_team_1),
            (else_try), 
              (assign, ":our_base_entry_id", multi_base_point_team_2),
            (try_end),

            (entry_point_get_position, pos5, ":our_base_entry_id"), #moved from above to here after auto-set position
            (position_get_screen_projection, pos3, pos5),
      
            (overlay_set_position, "$g_presentation_obj_flag_projection_display_4", pos3),
            (overlay_set_display, "$g_presentation_obj_flag_projection_display_4", 1),
            (overlay_set_display, "$g_presentation_obj_flag_projection_display_3", 0),
          (try_end),
        (else_try),
          (try_begin),
            (neq, ":team_1_flag_situation", 1),
            (overlay_set_position, "$g_presentation_obj_flag_projection_display_3", pos3),
            (overlay_set_display, "$g_presentation_obj_flag_projection_display_3", 1),
            (overlay_set_display, "$g_presentation_obj_flag_projection_display_4", 0),
          (try_end),
        (try_end),
      (else_try),
        (overlay_set_display, "$g_presentation_obj_flag_projection_display_3", 0),
        (overlay_set_display, "$g_presentation_obj_flag_projection_display_4", 0),
      (try_end),
      ]),
    ]),

  ("multiplayer_flag_projection_display_bt", prsntf_read_only|prsntf_manual_end_only, 0, [ #this is for search and destroy death mode flags.
    (ti_on_presentation_load, [
      (set_fixed_point_multiplier, 1000),

      (store_sub, ":flag_mesh", "$g_multiplayer_team_1_faction", npc_kingdoms_begin),
      (val_add, ":flag_mesh", multiplayer_flag_projections_begin),
      (create_mesh_overlay, "$g_presentation_obj_flag_projection_display_1", ":flag_mesh"),

      (try_begin),
        (neq, "$g_multiplayer_team_1_faction", "$g_multiplayer_team_2_faction"),
        (store_sub, ":flag_mesh", "$g_multiplayer_team_2_faction", npc_kingdoms_begin),
        (val_add, ":flag_mesh", multiplayer_flag_projections_begin),
      (else_try),
        (assign, ":flag_mesh", "mesh_flag_project_rb"),
      (try_end),
      (create_mesh_overlay, "$g_presentation_obj_flag_projection_display_3", ":flag_mesh"),

      (position_set_x, pos1, 250),
      (position_set_y, pos1, 250),

      (overlay_set_size, "$g_presentation_obj_flag_projection_display_1", pos1),
      (overlay_set_size, "$g_presentation_obj_flag_projection_display_3", pos1),
      (overlay_set_display, "$g_presentation_obj_flag_projection_display_1", 0),
      (overlay_set_display, "$g_presentation_obj_flag_projection_display_3", 0),
      (presentation_set_duration, 999999),
      ]),
    (ti_on_presentation_run, [
      (try_begin),
        (eq, "$g_round_ended", 0),
        (set_fixed_point_multiplier, 1000),
        (scene_prop_get_instance, ":flag_1_id", "$team_1_flag_scene_prop", 0),
        (prop_instance_get_position, pos1, ":flag_1_id"), #hold position of flag of team 1 at pos1
        (position_move_z, pos1, 250, 1),
      
        (scene_prop_get_instance, ":flag_2_id", "$team_2_flag_scene_prop", 0),
        (prop_instance_get_position, pos2, ":flag_2_id"), #hold position of flag of team 2 at pos2
        (position_move_z, pos2, 250, 1),
      
        (position_get_screen_projection, pos3, pos1),
        (position_get_x, ":x_pos", pos3),
        (position_get_y, ":y_pos", pos3),
        (position_set_y, pos3, ":y_pos"),
        (try_begin),
          (is_between, ":x_pos", -100, 1100),
          (is_between, ":y_pos", -100, 850),

          (overlay_set_position, "$g_presentation_obj_flag_projection_display_1", pos3),
          (overlay_set_display, "$g_presentation_obj_flag_projection_display_1", 1),
        (else_try),
          (overlay_set_display, "$g_presentation_obj_flag_projection_display_1", 0),
        (try_end),
      
        (position_get_screen_projection, pos3, pos2),
        (position_get_x, ":x_pos", pos3),
        (position_get_y, ":y_pos", pos3),
        (position_set_y, pos3, ":y_pos"),
        (try_begin),
          (is_between, ":x_pos", -100, 1100),
          (is_between, ":y_pos", -100, 850),

          (overlay_set_position, "$g_presentation_obj_flag_projection_display_3", pos3),
          (overlay_set_display, "$g_presentation_obj_flag_projection_display_3", 1),
        (else_try),
          (overlay_set_display, "$g_presentation_obj_flag_projection_display_3", 0),
        (try_end),
      (else_try),
        (presentation_set_duration, 0),
      (try_end),
      ]),
    ]),

  ("multiplayer_destructible_targets_display", prsntf_read_only|prsntf_manual_end_only, 0, [ #this is for search and destroy death mode flags.
    (ti_on_presentation_load, [
      (set_fixed_point_multiplier, 1000),     

      (try_begin),
        (eq, "$g_defender_team", 0),
        (store_sub, ":flag_mesh", "$g_multiplayer_team_1_faction", npc_kingdoms_begin),
      (else_try),
        (store_sub, ":flag_mesh", "$g_multiplayer_team_2_faction", npc_kingdoms_begin),
      (try_end),
      
      (val_add, ":flag_mesh", multiplayer_flag_projections_begin),
      (create_mesh_overlay, "$g_presentation_obj_flag_projection_display_1", ":flag_mesh"),
      (create_mesh_overlay, "$g_presentation_obj_flag_projection_display_2", ":flag_mesh"),

      (position_set_x, pos1, 250),
      (position_set_y, pos1, 250),

      (overlay_set_size, "$g_presentation_obj_flag_projection_display_1", pos1),
      (overlay_set_size, "$g_presentation_obj_flag_projection_display_2", pos1),
      (overlay_set_display, "$g_presentation_obj_flag_projection_display_1", 0),
      (overlay_set_display, "$g_presentation_obj_flag_projection_display_2", 0),
      (presentation_set_duration, 999999),
      ]),
    (ti_on_presentation_run, [
      (try_begin),
        (eq, "$g_round_ended", 0),
        (set_fixed_point_multiplier, 1000),
        (scene_prop_get_instance, ":target_1_id", "$g_destructible_target_1", 0),
        (prop_instance_get_position, pos1, ":target_1_id"), 
        (prop_instance_get_position, pos1, ":target_1_id"), 
        (position_move_z, pos1, 250, 1),
        (scene_prop_get_instance, ":target_2_id", "$g_destructible_target_2", 0),
        (prop_instance_get_position, pos2, ":target_2_id"), 
        (prop_instance_get_position, pos2, ":target_2_id"), 
        (position_move_z, pos2, 250, 1),
      
        (position_get_screen_projection, pos3, pos1),
        (position_get_x, ":x_pos", pos3),
        (position_get_y, ":y_pos", pos3),
        (position_set_y, pos3, ":y_pos"),
        (try_begin),
          (is_between, ":x_pos", -100, 1100),
          (is_between, ":y_pos", -100, 850),
      
          (prop_instance_get_starting_position, pos0, ":target_1_id"),
          (prop_instance_get_position, pos1, ":target_1_id"),
          (get_sq_distance_between_positions_in_meters, ":dist", pos0, pos1),
          (le, ":dist", 2), #this can be 0 or 1 too.

          (overlay_set_position, "$g_presentation_obj_flag_projection_display_1", pos3),
          (overlay_set_display, "$g_presentation_obj_flag_projection_display_1", 1),
        (else_try),
          (overlay_set_display, "$g_presentation_obj_flag_projection_display_1", 0),
        (try_end),
      
        (position_get_screen_projection, pos3, pos2),
        (position_get_x, ":x_pos", pos3),
        (position_get_y, ":y_pos", pos3),
        (position_set_y, pos3, ":y_pos"),
        (try_begin),
          (is_between, ":x_pos", -100, 1100),
          (is_between, ":y_pos", -100, 850),

          (prop_instance_get_starting_position, pos0, ":target_2_id"),
          (prop_instance_get_position, pos1, ":target_2_id"),
          (get_sq_distance_between_positions_in_meters, ":dist", pos0, pos1),
          (le, ":dist", 2), #this can be 0 or 1 too.

          (overlay_set_position, "$g_presentation_obj_flag_projection_display_2", pos3),
          (overlay_set_display, "$g_presentation_obj_flag_projection_display_2", 1),
        (else_try),
          (overlay_set_display, "$g_presentation_obj_flag_projection_display_2", 0),
        (try_end),
      (else_try),
        (presentation_set_duration, 0),
      (try_end),
      ]),
    ]),

  ("multiplayer_respawn_time_counter", prsntf_read_only|prsntf_manual_end_only, 0, [
    (ti_on_presentation_load, [      
      (set_fixed_point_multiplier, 1000),

      (assign, "$g_multiplayer_respawn_counter_overlay", -1),
      (assign, "$g_multiplayer_respawn_remained_overlay", -1),
      
      (assign, ":do_not_show_respawn_counter", 0),
      (try_begin),
        (eq, "$g_multiplayer_message_type", multiplayer_message_type_round_result_in_siege_mode),
        (this_or_next|eq, "$g_round_ended", 1),
        (eq, "$g_flag_is_not_ready", 1),
        (assign, ":do_not_show_respawn_counter", 1),
      (try_end),
      (eq, ":do_not_show_respawn_counter", 0),

      (assign, "$g_multiplayer_last_respawn_counter_value", -1),
      (str_clear, s0),
      (create_text_overlay, "$g_multiplayer_respawn_counter_overlay", s0, tf_center_justify|tf_with_outline),
      (overlay_set_color, "$g_multiplayer_respawn_counter_overlay", 0xFFFFFF),
      (position_set_x, pos1, 500),
      (position_set_y, pos1, 600),
      (overlay_set_position, "$g_multiplayer_respawn_counter_overlay", pos1),
      (position_set_x, pos1, 2000),
      (position_set_y, pos1, 2000),
      (overlay_set_size, "$g_multiplayer_respawn_counter_overlay", pos1),

      (str_clear, s0),
      (create_text_overlay, "$g_multiplayer_respawn_remained_overlay", s0, tf_center_justify|tf_with_outline),
      (overlay_set_color, "$g_multiplayer_respawn_remained_overlay", 0xFFFFFF),
      (position_set_x, pos1, 500),
      (position_set_y, pos1, 570),
      (overlay_set_position, "$g_multiplayer_respawn_remained_overlay", pos1),
      (position_set_x, pos1, 1400),
      (position_set_y, pos1, 1400),
      (overlay_set_size, "$g_multiplayer_respawn_remained_overlay", pos1),

      #(store_mission_timer_a, "$g_multiplayer_respawn_start_time"),
      (presentation_set_duration, 999999),
      ]),
  
    (ti_on_presentation_run, [
      (ge, "$g_multiplayer_respawn_counter_overlay", 0),
      (multiplayer_get_my_player, ":my_player_no"),
      (try_begin),
        (ge, ":my_player_no", 0),
        (player_get_team_no, ":player_team", ":my_player_no"),
        (try_begin),
          (eq, ":player_team", multi_team_spectator),
          (presentation_set_duration, 0),
        (else_try),
          (store_mission_timer_a, ":current_time"),
          (store_sub, ":seconds_past_in_respawn", ":current_time", "$g_multiplayer_respawn_start_time"),
          (try_begin),
            (eq, "$g_show_no_more_respawns_remained", 0),
            (assign, ":total_respawn_time", "$g_multiplayer_respawn_period"),
            (try_begin),
              (eq, "$g_multiplayer_game_type", multiplayer_game_type_siege),
              (player_get_team_no, ":player_team", ":my_player_no"),
              (eq, ":player_team", 0),
              (val_add, ":total_respawn_time", multiplayer_siege_mod_defender_team_extra_respawn_time),
            (try_end),
          (else_try),
            (assign, ":total_respawn_time", 6),
          (try_end),
          (store_sub, ":seconds_left_in_respawn", ":total_respawn_time", ":seconds_past_in_respawn"),
          (try_begin),
            (le, ":seconds_left_in_respawn", 0),
            (presentation_set_duration, 0),
          (else_try),
            (neq, "$g_multiplayer_last_respawn_counter_value", ":seconds_left_in_respawn"),
            (assign, "$g_multiplayer_last_respawn_counter_value", ":seconds_left_in_respawn"),
            (try_begin),
              (eq, "$g_show_no_more_respawns_remained", 0),
              (assign, reg0, ":seconds_left_in_respawn"),
              (str_store_string, s0, "str_respawning_in_reg0_seconds"),
              (try_begin),
                (gt, "$g_multiplayer_number_of_respawn_count", 0),
                (store_sub, reg0, "$g_multiplayer_number_of_respawn_count", "$g_my_spawn_count"),

                (multiplayer_get_my_player, ":my_player_no"),
                (player_get_team_no, ":my_player_team", ":my_player_no"),
                (eq, ":my_player_team", 0),
      
                (try_begin),
                  (gt, reg0, 1),
                  (str_store_string, s1, "str_reg0_respawns_remained"),
                (else_try),
                  (str_store_string, s1, "str_this_is_your_last_respawn"),
                (try_end),
              (else_try),
                (str_clear, s1),                
              (try_end),
            (else_try),
              (eq, "$g_show_no_more_respawns_remained", 1),
              ##(assign, "$g_informed_about_no_more_respawns_remained", 1),
              (str_store_string, s0, "str_no_more_respawns_remained_this_round"),
              (str_clear, s1),
              (str_store_string, s1, "str_wait_next_round"),
            (try_end),
            (overlay_set_text, "$g_multiplayer_respawn_counter_overlay", s0),
            (overlay_set_text, "$g_multiplayer_respawn_remained_overlay", s1),
          (try_end),
        (try_end),
      (else_try),
        (presentation_set_duration, 0),
      (try_end),

      (try_begin),
        (eq, "$g_multiplayer_message_type", multiplayer_message_type_round_result_in_siege_mode),
        (this_or_next|eq, "$g_round_ended", 1),
        (eq, "$g_flag_is_not_ready", 1),
        (presentation_set_duration, 0),
      (try_end),
      ]),
    ]),

  ("multiplayer_stats_chart", prsntf_read_only|prsntf_manual_end_only, 0, [
    (ti_on_presentation_load,
     [(set_fixed_point_multiplier, 1000),

      (create_mesh_overlay, reg0, "mesh_mp_score_b"),
      (position_set_x, pos1, 100),
      (position_set_y, pos1, 100),
      (overlay_set_position, reg0, pos1),
      (position_set_x, pos1, 1000),
      (position_set_y, pos1, 1000),
      (overlay_set_size, reg0, pos1),

      (assign, ":team_1_rows", 0),
      (assign, ":team_2_rows", 0),
      (assign, ":spectator_rows", 0),
      (get_max_players, ":num_players"),
      (try_for_range, ":player_no", 0, ":num_players"),
        (store_add, ":slot_index", ":player_no", multi_data_player_index_list_begin),
        (try_begin),
          (player_is_active, ":player_no"),
          (troop_set_slot, "trp_multiplayer_data", ":slot_index", 1),
          (player_get_team_no, ":player_team", ":player_no"),
          (try_begin),
            (eq, ":player_team", 0),
            (val_add, ":team_1_rows", 1),
          (else_try),
            (eq, ":player_team", 1),
            (val_add, ":team_2_rows", 1),
          (else_try),
            (eq, ":player_team", multi_team_spectator),
            (val_add, ":spectator_rows", 1),
          (try_end),
        (else_try),
          (troop_set_slot, "trp_multiplayer_data", ":slot_index", 0),
        (try_end),
      (try_end),
      (try_begin),
        (gt, "$g_multiplayer_num_bots_team_1", 0),
        (val_add, ":team_1_rows", 1),
      (try_end),
      (try_begin),
        (gt, "$g_multiplayer_num_bots_team_2", 0),
        (val_add, ":team_2_rows", 1),
      (try_end),

      (assign, ":total_rows", ":team_1_rows"),
      (val_max, ":total_rows", ":team_2_rows"),
      (val_add, ":total_rows", ":spectator_rows"),

      (str_clear, s0),
      (create_text_overlay, "$g_presentation_obj_stats_chart_container", s0, tf_scrollable_style_2),
      (position_set_x, pos1, 100),
      (position_set_y, pos1, 120),#120
      (overlay_set_position, "$g_presentation_obj_stats_chart_container", pos1),
      (position_set_x, pos1, 746),
      (position_set_y, pos1, 530),#530
      (overlay_set_area_size, "$g_presentation_obj_stats_chart_container", pos1),
      (set_container_overlay, "$g_presentation_obj_stats_chart_container"),

      (store_mul, ":y_needed", ":total_rows", 20),
      (val_add, ":y_needed", 100),
      (try_begin),
        (gt, ":spectator_rows", 0),
        (val_add, ":y_needed", 70),
      (try_end),

      (multiplayer_get_my_player, ":my_player_no"),       

      (try_begin),
        (gt, ":y_needed", 490),
        (assign, "$g_stats_chart_update_period", 8),
      (else_try),
        (assign, "$g_stats_chart_update_period", 1),
      (try_end),

      (try_begin), #counting number of flags each team has.
        (eq, "$g_multiplayer_game_type", multiplayer_game_type_headquarters),
        (call_script, "script_get_headquarters_scores"),
        (assign, ":team_1_num_flags", reg0),
        (assign, ":team_2_num_flags", reg1),
      (try_end),

      #assuming only 2 teams in scene
      (try_for_range, ":i_team", 0, multi_team_spectator),
        (assign, ":number_of_players", 0),
        (get_max_players, ":num_players"),
        (try_for_range, ":player_no", 0, ":num_players"),
          (player_is_active, ":player_no"),
          (player_get_team_no, ":team_no", ":player_no"),
          (eq, ":team_no", ":i_team"),
          (val_add, ":number_of_players", 1),
        (try_end),
        (assign, reg0, ":number_of_players"),
        (try_begin),
          (neq, ":number_of_players", 1),
          (create_text_overlay, reg1, "str_reg0_players", 0),
        (else_try),
          (create_text_overlay, reg1, "str_reg0_player", 0),
        (try_end),

        (assign, ":cur_y", ":y_needed"),
        (team_get_faction, ":cur_faction", ":i_team"),
        (str_store_faction_name, s1, ":cur_faction"),
        (create_text_overlay, reg0, s1, 0),
        (try_begin),
          (eq, ":i_team", 0),
          (overlay_set_color, reg0, 0xFF0000),
          (overlay_set_color, reg1, 0xFF0000),
        (else_try),
          (overlay_set_color, reg0, 0x0099FF),
          (overlay_set_color, reg1, 0x0099FF),
        (try_end),
        (assign, ":distance_between_teams", 373),
        (store_mul, ":cur_x", ":distance_between_teams", ":i_team"),
        (val_add, ":cur_x", 42),
        (store_add, ":cur_x_add_15", ":cur_x", 15),
        (position_set_x, pos3, ":cur_x_add_15"),
        (position_set_y, pos3, ":cur_y"),
        (store_add, ":cur_x_add_35", ":cur_x", 35),
        (position_set_x, pos1, ":cur_x_add_35"),
        (position_set_y, pos1, ":cur_y"),
        (copy_position, pos2, pos1),
        (store_sub, ":cur_y_sub_10", ":cur_y", 10),
        (position_set_x, pos2, ":cur_x_add_35"),
        (position_set_y, pos2, ":cur_y_sub_10"),
        (overlay_set_position, reg0, pos1),
        (overlay_set_position, reg1, pos2),
        (position_set_x, pos1, 1000),
        (position_set_y, pos1, 1000),
        (position_set_x, pos2, 600),
        (position_set_y, pos2, 600),
        (overlay_set_size, reg0, pos1),
        (overlay_set_size, reg1, pos2),

        (team_get_faction, ":faction_of_team_1", 0),
        (team_get_faction, ":faction_of_team_2", 1),
          
        (try_begin),
          (eq, ":faction_of_team_1", ":faction_of_team_2"),
          (eq, ":i_team", 1),
          (create_mesh_overlay, reg0, "mesh_ui_kingdom_shield_7"),
        (else_try),
          (eq, ":cur_faction", "fac_kingdom_4"),
          (create_mesh_overlay, reg0, "mesh_ui_kingdom_shield_1"),
        (else_try),
          (eq, ":cur_faction", "fac_kingdom_2"),
          (create_mesh_overlay, reg0, "mesh_ui_kingdom_shield_2"),
        (else_try),
          (eq, ":cur_faction", "fac_kingdom_3"),
          (create_mesh_overlay, reg0, "mesh_ui_kingdom_shield_3"),
        (else_try),
          (eq, ":cur_faction", "fac_kingdom_5"),
          (create_mesh_overlay, reg0, "mesh_ui_kingdom_shield_4"),
        (else_try),
          (eq, ":cur_faction", "fac_kingdom_6"),
          (create_mesh_overlay, reg0, "mesh_ui_kingdom_shield_5"),
        (else_try),
          (eq, ":cur_faction", "fac_kingdom_1"),
          (create_mesh_overlay, reg0, "mesh_ui_kingdom_shield_6"),
        (try_end),
      
        (position_set_x, pos1, 100),
        (position_set_y, pos1, 100),
        (overlay_set_position, reg0, pos3),
        (position_set_x, pos1, 50),
        (position_set_y, pos1, 50),
        (overlay_set_size, reg0, pos1),      

        (team_get_score, reg0, ":i_team"),
        (create_text_overlay, reg0, "str_score_reg0", tf_right_align),
        (overlay_set_color, reg0, 0xFFFFFF),
        (store_add, ":sub_cur_x", ":cur_x", 325), #325
        (store_add, ":sub_cur_y", ":cur_y", 0),
        (position_set_x, pos1, ":sub_cur_x"),
        (position_set_y, pos1, ":sub_cur_y"),
        (overlay_set_position, reg0, pos1),
        (position_set_x, pos1, 1200),
        (position_set_y, pos1, 1200),
        (overlay_set_size, reg0, pos1),      

        (try_begin), #counting number of flags each team has only at hq mod.
          (eq, "$g_multiplayer_game_type", multiplayer_game_type_headquarters),
          (try_begin),
            (eq, ":i_team", 0),
            (assign, reg0, ":team_1_num_flags"),
          (else_try),
            (eq, ":i_team", 1),
            (assign, reg0, ":team_2_num_flags"),
          (try_end),
          (create_text_overlay, reg0, "str_flags_reg0", 0),
          (overlay_set_color, reg0, 0xFFFFFF),
          (store_add, ":sub_cur_x", ":cur_x", 258),
          (store_add, ":sub_cur_y", ":cur_y", -10),
          (position_set_x, pos1, ":sub_cur_x"),
          (position_set_y, pos1, ":sub_cur_y"),
          (overlay_set_position, reg0, pos1),
          (position_set_x, pos1, 600),
          (position_set_y, pos1, 600),
          (overlay_set_size, reg0, pos1),      
        (try_end),

        (val_sub, ":cur_y", 60),
      
        (create_text_overlay, reg0, "str_player_name", 0),
        (overlay_set_color, reg0, 0xFFFFFF),
        (position_set_x, pos1, ":cur_x"),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg0, pos1),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg0, pos1),

        (try_begin), #at headquarters and capture the flag write score instead before kill count
          (this_or_next|eq, "$g_multiplayer_game_type", multiplayer_game_type_capture_the_flag),
          (eq, "$g_multiplayer_game_type", multiplayer_game_type_headquarters),      
          (create_text_overlay, reg0, "str_score", 0),
          (overlay_set_color, reg0, 0xFFFFFF),
          (store_add, ":sub_cur_x", ":cur_x", 138),
          (position_set_x, pos1, ":sub_cur_x"),
          (position_set_y, pos1, ":cur_y"),
          (overlay_set_position, reg0, pos1),
          (position_set_x, pos1, 750),
          (position_set_y, pos1, 750),
          (overlay_set_size, reg0, pos1),
        (try_end),
      
        (create_text_overlay, reg0, "str_kills", tf_center_justify),
        (overlay_set_color, reg0, 0xFFFFFF),
        (store_add, ":sub_cur_x", ":cur_x", 206), #191
        (position_set_x, pos1, ":sub_cur_x"),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg0, pos1),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg0, pos1),

        (create_text_overlay, reg0, "str_deaths", tf_center_justify),
        (overlay_set_color, reg0, 0xFFFFFF),
        (store_add, ":sub_cur_x", ":cur_x", 260), #232
        (position_set_x, pos1, ":sub_cur_x"),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg0, pos1),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg0, pos1),
      
        (create_text_overlay, reg0, "str_ping", tf_center_justify),
        (overlay_set_color, reg0, 0xFFFFFF),
        (store_add, ":sub_cur_x", ":cur_x", 308), #291
        (position_set_x, pos1, ":sub_cur_x"),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg0, pos1),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg0, pos1),
      
        (create_mesh_overlay, reg0, "mesh_white_plane"),
        (overlay_set_color, reg0, 0xFFFFFF),
        (overlay_set_alpha, reg0, 0xD0),
        (store_add, ":sub_cur_x", ":cur_x", 0),
        (position_set_x, pos1, ":sub_cur_x"),
        (store_add, ":sub_cur_y", ":cur_y", -10),
        (position_set_y, pos1, ":sub_cur_y"),
        (overlay_set_position, reg0, pos1),
        (position_set_x, pos1, 16500),
        (position_set_y, pos1, 50),
        (overlay_set_size, reg0, pos1),

        (val_sub, ":cur_y", 35),
      
        (store_add, ":end_cond", ":num_players", 1),
        (try_for_range, ":unused", 0, ":end_cond"),
          (assign, ":max_score_plus_death", -30030),
          (assign, ":max_score_plus_death_player_no", -1),
          (try_for_range, ":player_no", 0, ":num_players"),            
            (store_add, ":slot_index", ":player_no", multi_data_player_index_list_begin),
            (troop_slot_eq, "trp_multiplayer_data", ":slot_index", 1),
            (player_get_team_no, ":player_team", ":player_no"),
            (eq, ":player_team", ":i_team"),

            (try_begin),
              (this_or_next|eq, "$g_multiplayer_game_type", multiplayer_game_type_capture_the_flag),
              (eq, "$g_multiplayer_game_type", multiplayer_game_type_headquarters),      
              (player_get_score, ":kill_count", ":player_no"), #get score in "capture the flag" or "headquarters"
            (else_try),
              (player_get_kill_count, ":kill_count", ":player_no"), #get kill count in "siege" or "battle" or "team deathmatch" or "deathmatch"
            (try_end),
      
            (player_get_death_count, ":death_count", ":player_no"), #get_death_count

            (store_mul, ":player_score_plus_death", ":kill_count", 1000),
            (val_sub, ":player_score_plus_death", ":death_count"),
      
            (this_or_next|gt, ":player_score_plus_death", ":max_score_plus_death"),
            (eq, ":player_score_plus_death", -30030),
      
            (assign, ":max_score_plus_death", ":player_score_plus_death"),
            (assign, ":max_score_plus_death_player_no", ":player_no"),
          (try_end),
          (try_begin),
            (ge, ":max_score_plus_death_player_no", 0),
            (store_add, ":slot_index", ":max_score_plus_death_player_no", multi_data_player_index_list_begin),
            (troop_set_slot, "trp_multiplayer_data", ":slot_index", 0),
      
            (try_begin),
              (eq, ":my_player_no", ":max_score_plus_death_player_no"),
              (create_mesh_overlay, reg0, "mesh_white_plane"),
              (overlay_set_color, reg0, 0xFFFFFF),
              (overlay_set_alpha, reg0, 0x35),
              (store_add, ":sub_cur_x", ":cur_x", 0),
              (position_set_x, pos1, ":sub_cur_x"),
              (store_add, ":sub_cur_y", ":cur_y", 0),
              (position_set_y, pos1, ":sub_cur_y"),
              (overlay_set_position, reg0, pos1),
              (position_set_x, pos1, 16500),
              (position_set_y, pos1, 1000),
              (overlay_set_size, reg0, pos1),
            (try_end),
  
            (try_begin), #at headquarters and capture the flag write score instead dead label before kill count
              (this_or_next|eq, "$g_multiplayer_game_type", multiplayer_game_type_capture_the_flag),
              (eq, "$g_multiplayer_game_type", multiplayer_game_type_headquarters),      

              (assign, ":font_color", 0xFFFFFF),
              (player_get_agent_id, ":max_score_plus_death_agent_id", ":max_score_plus_death_player_no"),
              (try_begin),
                (this_or_next|lt, ":max_score_plus_death_agent_id", 0),
                (neg|agent_is_alive, ":max_score_plus_death_agent_id"),
                (assign, ":font_color", 0xFF0000),
              (try_end),

              (player_get_score, reg0, ":max_score_plus_death_player_no"),
              (create_text_overlay, reg0, "str_reg0", tf_right_align),
              (overlay_set_color, reg0, ":font_color"),
              (position_set_x, pos1, 750),
              (position_set_y, pos1, 750),
              (overlay_set_size, reg0, pos1),      
              (store_add, ":sub_cur_x", ":cur_x", 165), #150
              (position_set_x, pos1, ":sub_cur_x"),
              (position_set_y, pos1, ":cur_y"),
              (overlay_set_position, reg0, pos1),
            (else_try),
              (assign, ":font_color", 0xFFFFFF),
              (player_get_agent_id, ":max_score_plus_death_agent_id", ":max_score_plus_death_player_no"),
              (try_begin),
                (this_or_next|lt, ":max_score_plus_death_agent_id", 0),
                (neg|agent_is_alive, ":max_score_plus_death_agent_id"),
                (assign, ":font_color", 0xFF0000),
                (create_text_overlay, reg0, "str_dead", 0),
                (overlay_set_color, reg0, ":font_color"),
                (position_set_x, pos1, 750),
                (position_set_y, pos1, 750),
                (overlay_set_size, reg0, pos1),
                (store_add, ":sub_cur_x", ":cur_x", 130),
                (position_set_x, pos1, ":sub_cur_x"),
                (position_set_y, pos1, ":cur_y"),
                (overlay_set_position, reg0, pos1),
              (try_end),
            (try_end),

            (str_store_player_username, s1, ":max_score_plus_death_player_no"),
            (create_text_overlay, reg0, s1, 0),
            (overlay_set_color, reg0, ":font_color"),
            (position_set_x, pos1, 750),
            (position_set_y, pos1, 750),
            (overlay_set_size, reg0, pos1),
            (position_set_x, pos1, ":cur_x"),
            (position_set_y, pos1, ":cur_y"),
            (overlay_set_position, reg0, pos1),
      
            (player_get_kill_count, reg0, ":max_score_plus_death_player_no"), #get_kill_count
            (create_text_overlay, reg0, "str_reg0", tf_right_align),
            (overlay_set_color, reg0, ":font_color"),
            (position_set_x, pos1, 750),
            (position_set_y, pos1, 750),
            (overlay_set_size, reg0, pos1),      
            (store_add, ":sub_cur_x", ":cur_x", 215), #200
            (position_set_x, pos1, ":sub_cur_x"),
            (position_set_y, pos1, ":cur_y"),
            (overlay_set_position, reg0, pos1),
      
            (player_get_death_count, reg0, ":max_score_plus_death_player_no"),
            (create_text_overlay, reg0, "str_reg0", tf_right_align),
            (overlay_set_color, reg0, ":font_color"),
            (position_set_x, pos1, 750),
            (position_set_y, pos1, 750),
            (overlay_set_size, reg0, pos1),      
            (store_add, ":sub_cur_x", ":cur_x", 265), #250
            (position_set_x, pos1, ":sub_cur_x"),
            (position_set_y, pos1, ":cur_y"),
            (overlay_set_position, reg0, pos1),
      
            (player_get_ping, reg0, ":max_score_plus_death_player_no"),
            (create_text_overlay, reg0, "str_reg0", tf_right_align),
            (overlay_set_color, reg0, ":font_color"),
            (position_set_x, pos1, 750),
            (position_set_y, pos1, 750),
            (overlay_set_size, reg0, pos1),
            (store_add, ":sub_cur_x", ":cur_x", 315), #300
            (position_set_x, pos1, ":sub_cur_x"),
            (position_set_y, pos1, ":cur_y"),
            (overlay_set_position, reg0, pos1),
            (val_sub, ":cur_y", 20),
          (else_try),
            (try_begin),
              (try_begin),
                (eq, ":i_team", 0),
                (assign, ":number_of_bots_in_cur_team", "$g_multiplayer_num_bots_team_1"),
              (else_try),
                (assign, ":number_of_bots_in_cur_team", "$g_multiplayer_num_bots_team_2"),
              (try_end),
             
              (team_get_bot_kill_count, reg0, ":i_team"),
              (team_get_bot_death_count, reg1, ":i_team"),
              (try_begin),
                (this_or_next|neq, reg0, 0),
                (this_or_next|neq, reg1, 0),
                (neq, ":number_of_bots_in_cur_team", 0),
                (assign, ":write_bot_informations_of_team", 1),
              (else_try),
                (assign, ":write_bot_informations_of_team", 0),
              (try_end),
      
              (eq, ":write_bot_informations_of_team", 1),

              (assign, ":number_of_alive_bots", 0),
              (try_for_agents, ":cur_agent"),
                (agent_is_non_player, ":cur_agent"),
                (agent_is_alive, ":cur_agent"),
                (agent_get_team, ":cur_agent_team", ":cur_agent"),
                (eq, ":cur_agent_team", ":i_team"),
                (val_add, ":number_of_alive_bots", 1),
              (try_end),
              (store_sub, ":number_of_dead_bots", ":number_of_bots_in_cur_team", ":number_of_alive_bots"),
              (try_begin),
                (eq, ":number_of_alive_bots", 0),
                (assign, ":font_color", 0xFF0000),
              (else_try),
                (assign, ":font_color", 0xD0D0D0),
              (try_end),

              (try_begin),
                (gt, ":number_of_dead_bots", 0),
                (try_begin),
                  (eq, ":number_of_bots_in_cur_team", 1),
                  (create_text_overlay, reg0, "str_dead", 0),
                  (store_add, ":sub_cur_x", ":cur_x", 130),
                (else_try),
                  (assign, reg0, ":number_of_dead_bots"),
                  (create_text_overlay, reg0, "str_reg0_dead", 0),
                  (store_add, ":sub_cur_x", ":cur_x", 123),
                (try_end),      
                (overlay_set_color, reg0, ":font_color"),
                (position_set_x, pos1, 750),
                (position_set_y, pos1, 750),
                (overlay_set_size, reg0, pos1),
                (position_set_x, pos1, ":sub_cur_x"),
                (position_set_y, pos1, ":cur_y"),
                (overlay_set_position, reg0, pos1),
              (try_end),

              (try_begin),
                (gt, ":number_of_bots_in_cur_team", 1),
                (assign, reg0, ":number_of_bots_in_cur_team"),
                (create_text_overlay, reg0, "str_bots_reg0_agents", 0),
              (else_try),
                (create_text_overlay, reg0, "str_bot_1_agent", 0),
              (try_end),
              (overlay_set_color, reg0, ":font_color"),
              (position_set_x, pos1, 750),
              (position_set_y, pos1, 750),
              (overlay_set_size, reg0, pos1),
              (position_set_x, pos1, ":cur_x"),
              (position_set_y, pos1, ":cur_y"),
              (overlay_set_position, reg0, pos1),
      
              (team_get_bot_kill_count, reg0, ":i_team"),
              (create_text_overlay, reg0, "str_reg0", tf_right_align),
              (overlay_set_color, reg0, ":font_color"),
              (position_set_x, pos1, 750),
              (position_set_y, pos1, 750),
              (overlay_set_size, reg0, pos1),
              (store_add, ":sub_cur_x", ":cur_x", 215), #200
              (position_set_x, pos1, ":sub_cur_x"),
              (position_set_y, pos1, ":cur_y"),
              (overlay_set_position, reg0, pos1),
      
              (team_get_bot_death_count, reg0, ":i_team"),
              (create_text_overlay, reg0, "str_reg0", tf_right_align),
              (overlay_set_color, reg0, ":font_color"),
              (position_set_x, pos1, 750),
              (position_set_y, pos1, 750),
              (overlay_set_size, reg0, pos1),
              (store_add, ":sub_cur_x", ":cur_x", 265), #250
              (position_set_x, pos1, ":sub_cur_x"),
              (position_set_y, pos1, ":cur_y"),
              (overlay_set_position, reg0, pos1),
              (val_sub, ":cur_y", 20),
            (try_end),
            (assign, ":end_cond", 0), #all players are written for this team, break
          (try_end),
        (try_end),

        (try_begin),
          (eq, ":i_team", 0),
          (assign, ":old_cur_y", ":cur_y"),
        (try_end),
      (try_end),

      (try_begin),
        (le, ":old_cur_y", ":cur_y"),
        (assign, ":cur_y", ":old_cur_y"),
      (try_end),

      (assign, ":cur_x", 42),

      #white line between playing players and spectators
      (create_mesh_overlay, reg0, "mesh_white_plane"),
      (overlay_set_color, reg0, 0xFFFFFF),
      (overlay_set_alpha, reg0, 0xD0),
      (store_add, ":sub_cur_x", ":cur_x", 0),
      (position_set_x, pos1, ":sub_cur_x"),
      (store_add, ":sub_cur_y", ":cur_y", 10),
      (position_set_y, pos1, ":sub_cur_y"),
      (overlay_set_position, reg0, pos1),
      (position_set_x, pos1, 36000),
      (position_set_y, pos1, 50),
      (overlay_set_size, reg0, pos1), 

      (try_begin),
        (gt, ":spectator_rows", 0),

        (assign, ":cur_x", 280),
        (val_sub, ":cur_y", 50),

        #"spectators" text 
        (create_text_overlay, reg0, "str_spectators", 0),
        (overlay_set_color, reg0, 0xFFFFFF),
        (position_set_x, pos1, ":cur_x"),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg0, pos1),
        (position_set_x, pos1, 1000),
        (position_set_y, pos1, 1000),
        (overlay_set_size, reg0, pos1),

        (create_text_overlay, reg0, "str_ping", tf_right_align),
        (overlay_set_color, reg0, 0xFFFFFF),
        (store_add, ":sub_cur_x", ":cur_x", 215), #200
        (position_set_x, pos1, ":sub_cur_x"),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg0, pos1),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg0, pos1),

        #white line for spectators list
        (create_mesh_overlay, reg0, "mesh_white_plane"),
        (overlay_set_color, reg0, 0xFFFFFF),
        (overlay_set_alpha, reg0, 0xD0),
        (store_add, ":sub_cur_x", ":cur_x", 0),
        (position_set_x, pos1, ":sub_cur_x"),
        (store_add, ":sub_cur_y", ":cur_y", -10),
        (position_set_y, pos1, ":sub_cur_y"),
        (overlay_set_position, reg0, pos1),
        (position_set_x, pos1, 12000),
        (position_set_y, pos1, 50),
        (overlay_set_size, reg0, pos1),

        (val_sub, ":cur_y", 30),

        (assign, ":font_color", 0xC0C0C0),

        (store_add, ":end_cond", ":num_players", 1),
        (try_for_range, ":player_no", 0, ":end_cond"),
          (store_add, ":slot_index", ":player_no", multi_data_player_index_list_begin),
          (troop_slot_eq, "trp_multiplayer_data", ":slot_index", 1),

          (player_get_team_no, ":player_team", ":player_no"),
          (eq, ":player_team", multi_team_spectator), #to not to allow dedicated server to pass below, dedicated servers have -1 for team_no not 2(multi_team_spectator).

          (troop_set_slot, "trp_multiplayer_data", ":slot_index", 1),

          (try_begin),
            (eq, ":my_player_no", ":player_no"),
            (create_mesh_overlay, reg0, "mesh_white_plane"),
            (overlay_set_color, reg0, 0xFFFFFF),
            (overlay_set_alpha, reg0, 0x35),
            (store_add, ":sub_cur_x", ":cur_x", 0),
            (position_set_x, pos1, ":sub_cur_x"),
            (store_add, ":sub_cur_y", ":cur_y", 0),
            (position_set_y, pos1, ":sub_cur_y"),
            (overlay_set_position, reg0, pos1),
            (position_set_x, pos1, 12000),
            (position_set_y, pos1, 1000),
            (overlay_set_size, reg0, pos1),
          (try_end),

          (str_store_player_username, s1, ":player_no"),
          (create_text_overlay, reg0, s1, 0),
          (overlay_set_color, reg0, ":font_color"),
          (position_set_x, pos1, 750),
          (position_set_y, pos1, 750),
          (overlay_set_size, reg0, pos1),
          (position_set_x, pos1, ":cur_x"),
          (position_set_y, pos1, ":cur_y"),
          (overlay_set_position, reg0, pos1),
          
          (player_get_ping, reg0, ":player_no"),
          (create_text_overlay, reg0, "str_reg0", tf_right_align),
          (overlay_set_color, reg0, ":font_color"),
          (position_set_x, pos1, 750),
          (position_set_y, pos1, 750),
          (overlay_set_size, reg0, pos1),
          (store_add, ":sub_cur_x", ":cur_x", 215), #200
          (position_set_x, pos1, ":sub_cur_x"),
          (position_set_y, pos1, ":cur_y"),
          (overlay_set_position, reg0, pos1),
          (val_sub, ":cur_y", 20),      
        (try_end),
      (try_end),

      (omit_key_once, key_mouse_scroll_up),
      (omit_key_once, key_mouse_scroll_down),
      
      (presentation_set_duration, 999999),
      ]),
    (ti_on_presentation_run,
     [(store_trigger_param_1, ":cur_time"),
      (try_begin),
        (this_or_next|key_clicked, key_mouse_scroll_up),
        (key_clicked, key_mouse_scroll_down),
        (omit_key_once, key_mouse_scroll_up),
        (omit_key_once, key_mouse_scroll_down),
      (try_end),
      (try_begin),
        (eq, "$g_multiplayer_stats_chart_opened_manually", 1),
        (neg|game_key_is_down, gk_leave),
        (assign, "$g_multiplayer_stats_chart_opened_manually", 0),
        (clear_omitted_keys),
        (presentation_set_duration, 0),
      (try_end),
      (try_begin),
        (store_mul, ":update_period_time_limit", "$g_stats_chart_update_period", 1000),
        (gt, ":cur_time", ":update_period_time_limit"),
        (clear_omitted_keys),
        (presentation_set_duration, 0),
        (start_presentation, "prsnt_multiplayer_stats_chart"),
      (try_end),
      ]),
    ]),

  #this score table is used in only deathmatch
  ("multiplayer_stats_chart_deathmatch", prsntf_read_only|prsntf_manual_end_only, 0, [ 
    (ti_on_presentation_load,
     [(set_fixed_point_multiplier, 1000),

      (create_mesh_overlay, reg0, "mesh_mp_score_a"),
      (position_set_x, pos1, 295),
      (position_set_y, pos1, 115),
      (overlay_set_position, reg0, pos1),
      (position_set_x, pos1, 1000),
      (position_set_y, pos1, 1000),
      (overlay_set_size, reg0, pos1),

      (assign, ":team_rows", 0),
      (assign, ":spectator_rows", 0),
      (get_max_players, ":num_players"),
      (try_for_range, ":player_no", 0, ":num_players"),
        (store_add, ":slot_index", ":player_no", multi_data_player_index_list_begin),
        (try_begin),
          (player_is_active, ":player_no"),
          (troop_set_slot, "trp_multiplayer_data", ":slot_index", 1),
          (player_get_team_no, ":player_team", ":player_no"),
          (try_begin),
            (this_or_next|eq, ":player_team", 0),
            (eq, ":player_team", 1),
            (val_add, ":team_rows", 1),
          (else_try),
            (eq, ":player_team", multi_team_spectator),
            (val_add, ":spectator_rows", 1),
          (try_end),
        (else_try),
          (troop_set_slot, "trp_multiplayer_data", ":slot_index", 0),
        (try_end),
      (try_end),
      (try_begin),
        (this_or_next|gt, "$g_multiplayer_num_bots_team_1", 0),
        (gt, "$g_multiplayer_num_bots_team_2", 0),
        (val_add, ":team_rows", 1),
      (try_end),

      (store_add, ":total_rows", ":team_rows", ":spectator_rows"),

      (str_clear, s0),
      (create_text_overlay, "$g_presentation_obj_stats_chart_deathmatch_container", s0, tf_scrollable_style_2),
      (position_set_x, pos1, 300),
      (position_set_y, pos1, 140),
      (overlay_set_position, "$g_presentation_obj_stats_chart_deathmatch_container", pos1),
      (position_set_x, pos1, 346),
      (position_set_y, pos1, 530),
      (overlay_set_area_size, "$g_presentation_obj_stats_chart_deathmatch_container", pos1),
      (set_container_overlay, "$g_presentation_obj_stats_chart_deathmatch_container"),

      (store_mul, ":y_needed", ":total_rows", 20),
      (val_add, ":y_needed", 80),
      (try_begin),
        (gt, ":spectator_rows", 0),
        (val_add, ":y_needed", 70),
      (try_end),

      (try_begin),
        (ge, ":total_rows", 17),
        (assign, "$g_stats_chart_update_period", 10),
      (else_try),
        (assign, "$g_stats_chart_update_period", 1),
      (try_end),

      (multiplayer_get_my_player, ":my_player_no"),

      #assuming only 2 teams in scene
      (assign, ":cur_y", ":y_needed"),
      (assign, ":cur_x", 42),
      
      (create_text_overlay, reg0, "str_player_name", 0),
      (overlay_set_color, reg0, 0xFFFFFF),
      (position_set_x, pos1, ":cur_x"),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),
      (position_set_x, pos1, 750),
      (position_set_y, pos1, 750),
      (overlay_set_size, reg0, pos1),
      
      (create_text_overlay, reg0, "str_kills", tf_center_justify),
      (overlay_set_color, reg0, 0xFFFFFF),
      (store_add, ":sub_cur_x", ":cur_x", 179), #164
      (position_set_x, pos1, ":sub_cur_x"),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),
      (position_set_x, pos1, 750),
      (position_set_y, pos1, 750),
      (overlay_set_size, reg0, pos1),
      
      (create_text_overlay, reg0, "str_deaths", tf_center_justify),
      (overlay_set_color, reg0, 0xFFFFFF),
      (store_add, ":sub_cur_x", ":cur_x", 233), #205
      (position_set_x, pos1, ":sub_cur_x"),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),
      (position_set_x, pos1, 750),
      (position_set_y, pos1, 750),
      (overlay_set_size, reg0, pos1),
      
      (create_text_overlay, reg0, "str_ping", tf_center_justify),
      (overlay_set_color, reg0, 0xFFFFFF),
      (store_add, ":sub_cur_x", ":cur_x", 282), #264
      (position_set_x, pos1, ":sub_cur_x"),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),
      (position_set_x, pos1, 750),
      (position_set_y, pos1, 750),
      (overlay_set_size, reg0, pos1),
      
      (create_mesh_overlay, reg0, "mesh_white_plane"),
      (overlay_set_color, reg0, 0xFFFFFF),
      (overlay_set_alpha, reg0, 0xD0),
      (store_add, ":sub_cur_x", ":cur_x", 0),
      (position_set_x, pos1, ":sub_cur_x"),
      (store_add, ":sub_cur_y", ":cur_y", -10),
      (position_set_y, pos1, ":sub_cur_y"),
      (overlay_set_position, reg0, pos1),
      (position_set_x, pos1, 15250),
      (position_set_y, pos1, 50),
      (overlay_set_size, reg0, pos1),

      (val_sub, ":cur_y", 35),
      
      (store_add, ":end_cond", ":num_players", 1),
      (try_for_range, ":unused", 0, ":end_cond"),
        (assign, ":max_score_plus_death", -30030),
        (assign, ":max_kills_player_no", -1),
        (try_for_range, ":player_no", 0, ":num_players"),
          (store_add, ":slot_index", ":player_no", multi_data_player_index_list_begin),
          (troop_slot_eq, "trp_multiplayer_data", ":slot_index", 1),
          (player_get_team_no, ":player_team", ":player_no"),
          (this_or_next|eq, ":player_team", 0),
          (eq, ":player_team", 1),

          (player_get_kill_count, ":kill_count", ":player_no"),
          (player_get_death_count, ":death_count", ":player_no"), #get_death_count
          (store_mul, ":player_score_plus_death", ":kill_count", 1000),
          (val_sub, ":player_score_plus_death", ":death_count"),
      
          (this_or_next|gt, ":player_score_plus_death", ":max_score_plus_death"),
          (eq, ":player_score_plus_death", -30030),
      
          (assign, ":max_score_plus_death", ":player_score_plus_death"),
          (assign, ":max_kills_player_no", ":player_no"),
        (try_end),
        (try_begin),
          (ge, ":max_kills_player_no", 0),
          (store_add, ":slot_index", ":max_kills_player_no", multi_data_player_index_list_begin),
          (troop_set_slot, "trp_multiplayer_data", ":slot_index", 0),
          (str_store_player_username, s1, ":max_kills_player_no"),
      
          (try_begin),
            (eq, ":my_player_no", ":max_kills_player_no"),
            (create_mesh_overlay, reg0, "mesh_white_plane"),
            (overlay_set_color, reg0, 0xFFFFFF),
            (overlay_set_alpha, reg0, 0x35),
            (store_add, ":sub_cur_x", ":cur_x", 0),
            (position_set_x, pos1, ":sub_cur_x"),
            (store_add, ":sub_cur_y", ":cur_y", 0),
            (position_set_y, pos1, ":sub_cur_y"),
            (overlay_set_position, reg0, pos1),
            (position_set_x, pos1, 16000),
            (position_set_y, pos1, 1000),
            (overlay_set_size, reg0, pos1),
          (try_end),

          (create_text_overlay, reg0, s1, 0),
          (overlay_set_color, reg0, 0xFFFFFF),
          (position_set_x, pos1, 750),
          (position_set_y, pos1, 750),
          (overlay_set_size, reg0, pos1),
          (position_set_x, pos1, ":cur_x"),
          (position_set_y, pos1, ":cur_y"),
          (overlay_set_position, reg0, pos1),
      
          (player_get_kill_count, reg0, ":max_kills_player_no"),
          (create_text_overlay, reg0, "str_reg0", tf_right_align),
          (overlay_set_color, reg0, 0xFFFFFF),
          (position_set_x, pos1, 750),
          (position_set_y, pos1, 750),
          (overlay_set_size, reg0, pos1),      
          (store_add, ":sub_cur_x", ":cur_x", 188), #173
          (position_set_x, pos1, ":sub_cur_x"),
          (position_set_y, pos1, ":cur_y"),
          (overlay_set_position, reg0, pos1),
      
          (player_get_death_count, reg0, ":max_kills_player_no"),
          (create_text_overlay, reg0, "str_reg0", tf_right_align),
          (overlay_set_color, reg0, 0xFFFFFF),
          (position_set_x, pos1, 750),
          (position_set_y, pos1, 750),
          (overlay_set_size, reg0, pos1),      
          (store_add, ":sub_cur_x", ":cur_x", 238), #223
          (position_set_x, pos1, ":sub_cur_x"),
          (position_set_y, pos1, ":cur_y"),
          (overlay_set_position, reg0, pos1),
      
          (player_get_ping, reg0, ":max_kills_player_no"),
          (create_text_overlay, reg0, "str_reg0", tf_right_align),
          (overlay_set_color, reg0, 0xFFFFFF),
          (position_set_x, pos1, 750),
          (position_set_y, pos1, 750),
          (overlay_set_size, reg0, pos1),
          (store_add, ":sub_cur_x", ":cur_x", 288), #273
          (position_set_x, pos1, ":sub_cur_x"),
          (position_set_y, pos1, ":cur_y"),
          (overlay_set_position, reg0, pos1),
          (val_sub, ":cur_y", 20),
        (else_try),
          (store_add, ":number_of_bots", "$g_multiplayer_num_bots_team_1", "$g_multiplayer_num_bots_team_2"),
          (ge, ":number_of_bots", 1),

          (try_begin),
            (gt, ":number_of_bots", 1),
            (assign, reg0, ":number_of_bots"),
            (create_text_overlay, reg0, "str_bots_reg0_agents", 0),
          (else_try),
            (create_text_overlay, reg0, "str_bot_1_agent", 0),
          (try_end),
      
          (overlay_set_color, reg0, 0xD0D0D0),
          (position_set_x, pos1, 750),
          (position_set_y, pos1, 750),
          (overlay_set_size, reg0, pos1),
          (position_set_x, pos1, ":cur_x"),
          (position_set_y, pos1, ":cur_y"),
          (overlay_set_position, reg0, pos1),
      
          (team_get_bot_kill_count, reg0, 0),
          (assign, ":bot_kill_count", reg0),
          (team_get_bot_kill_count, reg0, 1),
          (val_add, ":bot_kill_count", reg0),
          (assign, reg0, ":bot_kill_count"),
          (create_text_overlay, reg0, "str_reg0", tf_right_align),
          (overlay_set_color, reg0, 0xD0D0D0),
          (position_set_x, pos1, 750),
          (position_set_y, pos1, 750),
          (overlay_set_size, reg0, pos1),
          (store_add, ":sub_cur_x", ":cur_x", 188), #173
          (position_set_x, pos1, ":sub_cur_x"),
          (position_set_y, pos1, ":cur_y"),
          (overlay_set_position, reg0, pos1),
      
          (team_get_bot_death_count, reg0, 0),
          (assign, ":bot_death_count", reg0),
          (team_get_bot_death_count, reg0, 1),
          (val_add, ":bot_death_count", reg0),
          (assign, reg0, ":bot_death_count"),
          (create_text_overlay, reg0, "str_reg0", tf_right_align),
          (overlay_set_color, reg0, 0xD0D0D0),
          (position_set_x, pos1, 750),
          (position_set_y, pos1, 750),
          (overlay_set_size, reg0, pos1),
          (store_add, ":sub_cur_x", ":cur_x", 238), #223
          (position_set_x, pos1, ":sub_cur_x"),
          (position_set_y, pos1, ":cur_y"),
          (overlay_set_position, reg0, pos1),
          (val_sub, ":cur_y", 20),

          (assign, ":end_cond", 0), #all players are written, break
        (else_try),
          (assign, ":end_cond", 0), #all players are written, break
        (try_end),
      (try_end),

      (assign, ":cur_x", 42),

      #white line between playing players and spectators
      (create_mesh_overlay, reg0, "mesh_white_plane"),
      (overlay_set_color, reg0, 0xFFFFFF),
      (overlay_set_alpha, reg0, 0xD0),
      (store_add, ":sub_cur_x", ":cur_x", 0),
      (position_set_x, pos1, ":sub_cur_x"),
      (store_add, ":sub_cur_y", ":cur_y", 10),
      (position_set_y, pos1, ":sub_cur_y"),
      (overlay_set_position, reg0, pos1),
      (position_set_x, pos1, 15250),
      (position_set_y, pos1, 50),
      (overlay_set_size, reg0, pos1), 

      (try_begin),
        (gt, ":spectator_rows", 0),

        (assign, ":cur_x", 75),
        (val_sub, ":cur_y", 50),

        #"spectators" text
        (create_text_overlay, reg0, "str_spectators", 0),
        (overlay_set_color, reg0, 0xFFFFFF),
        (position_set_x, pos1, ":cur_x"),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg0, pos1),
        (position_set_x, pos1, 1000),
        (position_set_y, pos1, 1000),
        (overlay_set_size, reg0, pos1),

        (create_text_overlay, reg0, "str_ping", tf_center_justify),
        (overlay_set_color, reg0, 0xFFFFFF),
        (store_add, ":sub_cur_x", ":cur_x", 218), #200
        (position_set_x, pos1, ":sub_cur_x"),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg0, pos1),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg0, pos1),

        #white line for spectators list
        (create_mesh_overlay, reg0, "mesh_white_plane"),
        (overlay_set_color, reg0, 0xFFFFFF),
        (overlay_set_alpha, reg0, 0xD0),
        (store_add, ":sub_cur_x", ":cur_x", 0),
        (position_set_x, pos1, ":sub_cur_x"),
        (store_add, ":sub_cur_y", ":cur_y", -10),
        (position_set_y, pos1, ":sub_cur_y"),
        (overlay_set_position, reg0, pos1),
        (position_set_x, pos1, 12000),
        (position_set_y, pos1, 50),
        (overlay_set_size, reg0, pos1), 

        (val_sub, ":cur_y", 30),

        (assign, ":font_color", 0xC0C0C0),

        (store_add, ":end_cond", ":num_players", 1),
        (try_for_range, ":player_no", 0, ":end_cond"),
          (store_add, ":slot_index", ":player_no", multi_data_player_index_list_begin),
          (troop_slot_eq, "trp_multiplayer_data", ":slot_index", 1),

          (player_get_team_no, ":player_team", ":player_no"),
          (eq, ":player_team", multi_team_spectator), #to not to allow dedicated server to pass below, dedicated servers have -1 for team_no not 2(multi_team_spectator).

          (troop_set_slot, "trp_multiplayer_data", ":slot_index", 1),

          (try_begin),
            (eq, ":my_player_no", ":player_no"),
            (create_mesh_overlay, reg0, "mesh_white_plane"),
            (overlay_set_color, reg0, 0xFFFFFF),
            (overlay_set_alpha, reg0, 0x35),
            (store_add, ":sub_cur_x", ":cur_x", 0),
            (position_set_x, pos1, ":sub_cur_x"),
            (store_add, ":sub_cur_y", ":cur_y", 0),
            (position_set_y, pos1, ":sub_cur_y"),
            (overlay_set_position, reg0, pos1),
            (position_set_x, pos1, 12000), #16500
            (position_set_y, pos1, 1000),
            (overlay_set_size, reg0, pos1),
          (try_end),

          (str_store_player_username, s1, ":player_no"),
          (create_text_overlay, reg0, s1, 0),
          (overlay_set_color, reg0, ":font_color"),
          (position_set_x, pos1, 750),
          (position_set_y, pos1, 750),
          (overlay_set_size, reg0, pos1),
          (position_set_x, pos1, ":cur_x"),
          (position_set_y, pos1, ":cur_y"),
          (overlay_set_position, reg0, pos1),
          
          (player_get_ping, reg0, ":player_no"),
          (create_text_overlay, reg0, "str_reg0", tf_right_align),
          (overlay_set_color, reg0, ":font_color"),
          (position_set_x, pos1, 750),
          (position_set_y, pos1, 750),
          (overlay_set_size, reg0, pos1),
          (store_add, ":sub_cur_x", ":cur_x", 215), #200
          (position_set_x, pos1, ":sub_cur_x"),
          (position_set_y, pos1, ":cur_y"),
          (overlay_set_position, reg0, pos1),
          (val_sub, ":cur_y", 20),      
        (try_end),
      (try_end),

      (omit_key_once, key_mouse_scroll_up),
      (omit_key_once, key_mouse_scroll_down),
      
      (presentation_set_duration, 999999),
      ]),
    (ti_on_presentation_run,
     [(store_trigger_param_1, ":cur_time"),
      (try_begin),
        (this_or_next|key_clicked, key_mouse_scroll_up),
        (key_clicked, key_mouse_scroll_down),
        (omit_key_once, key_mouse_scroll_up),
        (omit_key_once, key_mouse_scroll_down),
      (try_end),
      (try_begin),
        (eq, "$g_multiplayer_stats_chart_opened_manually", 1),
        (neg|game_key_is_down, gk_leave),
        (assign, "$g_multiplayer_stats_chart_opened_manually", 0),
        (clear_omitted_keys),
        (presentation_set_duration, 0),
      (try_end),
      (try_begin),
        (store_mul, ":update_period_time_limit", "$g_stats_chart_update_period", 1000),
        (gt, ":cur_time", ":update_period_time_limit"),
        (clear_omitted_keys),
        (presentation_set_duration, 0),
        (start_presentation, "prsnt_multiplayer_stats_chart_deathmatch"),
      (try_end),
      ]),
    ]),

  ("multiplayer_escape_menu", prsntf_manual_end_only, 0, [
    (ti_on_presentation_load,
     [(set_fixed_point_multiplier, 1000),

      (create_mesh_overlay, reg0, "mesh_mp_ingame_menu"),
      (position_set_x, pos1, 250),
      (position_set_y, pos1, 80),
      (overlay_set_position, reg0, pos1),
      (position_set_x, pos1, 1000),
      (position_set_y, pos1, 1000),
      (overlay_set_size, reg0, pos1),

      (str_clear, s0),
      (create_text_overlay, "$g_presentation_obj_escape_menu_container", s0, tf_scrollable_style_2),
      (position_set_x, pos1, 285),
      (position_set_y, pos1, 75),
      (overlay_set_position, "$g_presentation_obj_escape_menu_container", pos1),
      (position_set_x, pos1, 405),
      (position_set_y, pos1, 550),
      (overlay_set_area_size, "$g_presentation_obj_escape_menu_container", pos1),
      (set_container_overlay, "$g_presentation_obj_escape_menu_container"),

      (assign, ":cur_y", 500),

      (create_text_overlay, reg0, "str_choose_an_option", 0),
      (overlay_set_color, reg0, 0xFFFFFF),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),
      (val_sub, ":cur_y", escape_menu_item_height),

      (create_button_overlay, "$g_presentation_obj_escape_menu_1", "str_choose_faction", 0),
      (overlay_set_color, "$g_presentation_obj_escape_menu_1", 0xFFFFFF),
      (multiplayer_get_my_team, ":my_team"),
      (assign, "$g_presentation_obj_escape_menu_2", -1),
      (assign, "$g_presentation_obj_escape_menu_3", -1),
      (assign, "$g_presentation_obj_escape_menu_6", -1),
      (assign, "$g_presentation_obj_escape_menu_7", -1),
      (assign, "$g_presentation_obj_escape_menu_8", -1),
      (assign, "$g_presentation_obj_escape_menu_9", -1),
      (assign, "$g_presentation_obj_escape_menu_10", -1),
      (assign, "$g_presentation_obj_escape_menu_11", -1),
      (assign, "$g_presentation_obj_escape_menu_12", -1),
      (assign, "$g_presentation_obj_escape_menu_13", -1),
      (try_begin),
        (lt, ":my_team", multi_team_spectator),
        (create_button_overlay, "$g_presentation_obj_escape_menu_2", "str_choose_troop", 0),
        (overlay_set_color, "$g_presentation_obj_escape_menu_2", 0xFFFFFF),
        (multiplayer_get_my_troop, ":my_troop"),
        (try_begin),
          (ge, ":my_troop", 0),
          (create_button_overlay, "$g_presentation_obj_escape_menu_3", "str_choose_items", 0),
          (overlay_set_color, "$g_presentation_obj_escape_menu_3", 0xFFFFFF),
        (try_end),
      (try_end),
      (create_button_overlay, "$g_presentation_obj_escape_menu_4", "str_options", 0),
      (overlay_set_color, "$g_presentation_obj_escape_menu_4", 0xFFFFFF),
      (create_button_overlay, "$g_presentation_obj_escape_menu_5", "str_redefine_keys", 0),
      (overlay_set_color, "$g_presentation_obj_escape_menu_5", 0xFFFFFF),

      (create_button_overlay, "$g_presentation_obj_escape_menu_13", "@Show game rules", 0),
      (overlay_set_color, "$g_presentation_obj_escape_menu_13", 0xFFFFFF),

      (multiplayer_get_my_player, ":my_player_no"),
      (try_begin),
        (this_or_next|eq, "$g_multiplayer_maps_voteable", 1),
        (this_or_next|eq, "$g_multiplayer_factions_voteable", 1),
        (this_or_next|gt, "$g_multiplayer_num_bots_voteable", 0),
        (this_or_next|eq, "$g_multiplayer_kick_voteable", 1),
        (eq, "$g_multiplayer_ban_voteable", 1),
        (create_button_overlay, "$g_presentation_obj_escape_menu_6", "str_submit_a_poll", 0),
        (overlay_set_color, "$g_presentation_obj_escape_menu_6", 0xFFFFFF),
        (assign, "$g_presentation_obj_escape_menu_6_available", 1),
        (try_begin),
          (ge, ":my_player_no", 0),
          (player_get_slot, ":last_poll_time", ":my_player_no", slot_player_poll_disabled_until_time),
          (store_mission_timer_a, ":mission_timer"),
          (lt, ":mission_timer", ":last_poll_time"),
          (overlay_set_color, "$g_presentation_obj_escape_menu_6", 0x888888),
          (overlay_set_hilight_color, "$g_presentation_obj_escape_menu_6", 0x888888),
          (assign, "$g_presentation_obj_escape_menu_6_available", 0),
        (try_end),
      (try_end),

      (try_begin),
        (ge, ":my_player_no", 0),
        (player_is_admin, ":my_player_no"),
        (create_button_overlay, "$g_presentation_obj_escape_menu_7", "str_administrator_panel", 0),
        (overlay_set_color, "$g_presentation_obj_escape_menu_7", 0xFFFFFF),
        (create_button_overlay, "$g_presentation_obj_escape_menu_8", "str_kick_player", 0),
        (overlay_set_color, "$g_presentation_obj_escape_menu_8", 0xFFFFFF),
        (create_button_overlay, "$g_presentation_obj_escape_menu_9", "str_ban_player", 0),
        (overlay_set_color, "$g_presentation_obj_escape_menu_9", 0xFFFFFF),
      (try_end),

      (create_button_overlay, "$g_presentation_obj_escape_menu_11", "str_mute_player", 0),
      (overlay_set_color, "$g_presentation_obj_escape_menu_11", 0xFFFFFF),

      (try_begin),
        (assign, "$g_presentation_obj_escape_menu_12", -1),
        (assign, ":any_muted", 0),
        (get_max_players, ":num_players"),
        (try_for_range, ":player_no", 0, ":num_players"),
          (player_is_active, ":player_no"),
          (player_get_is_muted, ":is_muted", ":player_no"),
          (eq, ":is_muted", 1),
          (assign, ":any_muted", 1),
        (try_end),
        (eq, ":any_muted", 1),
        (create_button_overlay, "$g_presentation_obj_escape_menu_12", "str_unmute_player", 0),
        (overlay_set_color, "$g_presentation_obj_escape_menu_12", 0xFFFFFF),
      (try_end),

      (create_button_overlay, "$g_presentation_obj_escape_menu_10", "str_quit", 0),
      (overlay_set_color, "$g_presentation_obj_escape_menu_10", 0xFFFFFF),

      (position_set_x, pos1, 130),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_escape_menu_1", pos1),
      (try_begin),
        (ge, "$g_presentation_obj_escape_menu_2", 0),
        (val_sub, ":cur_y", escape_menu_item_height),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, "$g_presentation_obj_escape_menu_2", pos1),
      (try_end),
      (try_begin),
        (ge, "$g_presentation_obj_escape_menu_3", 0),
        (val_sub, ":cur_y", escape_menu_item_height),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, "$g_presentation_obj_escape_menu_3", pos1),
      (try_end),
      (val_sub, ":cur_y", escape_menu_item_height),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_escape_menu_4", pos1),
      (val_sub, ":cur_y", escape_menu_item_height),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_escape_menu_5", pos1),
      (val_sub, ":cur_y", escape_menu_item_height),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_escape_menu_13", pos1),
      (try_begin),
        (ge, "$g_presentation_obj_escape_menu_6", 0),
        (val_sub, ":cur_y", escape_menu_item_height),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, "$g_presentation_obj_escape_menu_6", pos1),
      (try_end),
      (try_begin),
        (ge, "$g_presentation_obj_escape_menu_7", 0),
        (val_sub, ":cur_y", escape_menu_item_height),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, "$g_presentation_obj_escape_menu_7", pos1),
      (try_end),
      (try_begin),
        (ge, "$g_presentation_obj_escape_menu_8", 0),
        (val_sub, ":cur_y", escape_menu_item_height),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, "$g_presentation_obj_escape_menu_8", pos1),
      (try_end),
      (try_begin),
        (ge, "$g_presentation_obj_escape_menu_9", 0),
        (val_sub, ":cur_y", escape_menu_item_height),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, "$g_presentation_obj_escape_menu_9", pos1),
      (try_end),
      (val_sub, ":cur_y", escape_menu_item_height),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_escape_menu_11", pos1),
      (try_begin),
        (ge, "$g_presentation_obj_escape_menu_12", 0),
        (val_sub, ":cur_y", escape_menu_item_height),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, "$g_presentation_obj_escape_menu_12", pos1),
      (try_end),
      (val_sub, ":cur_y", escape_menu_item_height),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_escape_menu_10", pos1),
      (presentation_set_duration, 999999),
      ]),
    (ti_on_presentation_event_state_change,
     [(store_trigger_param_1, ":object"),
      (try_begin),
        (eq, ":object", "$g_presentation_obj_escape_menu_1"),
        (presentation_set_duration, 0),
        (start_presentation, "prsnt_multiplayer_team_select"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_escape_menu_2"),
        (presentation_set_duration, 0),
        (start_presentation, "prsnt_multiplayer_troop_select"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_escape_menu_3"),
        (presentation_set_duration, 0),
        (assign, "$g_presentation_state", 0),
        (start_presentation, "prsnt_multiplayer_item_select"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_escape_menu_4"),
        (presentation_set_duration, 0),
        (change_screen_options),
      (else_try),
        (eq, ":object", "$g_presentation_obj_escape_menu_5"),
        (presentation_set_duration, 0),
        (change_screen_controls),
      (else_try),
        (eq, ":object", "$g_presentation_obj_escape_menu_6"),
        (eq, "$g_presentation_obj_escape_menu_6_available", 1),
        (presentation_set_duration, 0),
        (start_presentation, "prsnt_multiplayer_poll_menu"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_escape_menu_7"),
        (presentation_set_duration, 0),
        (multiplayer_send_message_to_server, multiplayer_event_open_admin_panel),
      (else_try),
        (eq, ":object", "$g_presentation_obj_escape_menu_8"),
        (presentation_set_duration, 0),
        (assign, "$g_multiplayer_players_list_action_type", 3), #admin kick
        (start_presentation, "prsnt_multiplayer_show_players_list"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_escape_menu_9"),
        (presentation_set_duration, 0),
        (assign, "$g_multiplayer_players_list_action_type", 4), #admin ban
        (start_presentation, "prsnt_multiplayer_show_players_list"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_escape_menu_10"),
        (presentation_set_duration, 0),
        (finish_mission, 0),
      (else_try),
        (eq, ":object", "$g_presentation_obj_escape_menu_11"),
        (presentation_set_duration, 0),
        (assign, "$g_multiplayer_players_list_action_type", 5), #mute player
        (start_presentation, "prsnt_multiplayer_show_players_list"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_escape_menu_12"),
        (presentation_set_duration, 0),
        (assign, "$g_multiplayer_players_list_action_type", 6), #unmute player
        (start_presentation, "prsnt_multiplayer_show_players_list"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_escape_menu_13"),
        (presentation_set_duration, 0),
        (multiplayer_send_message_to_server, multiplayer_event_open_game_rules),
      (try_end),
      ]),
    (ti_on_presentation_run,
     [(store_trigger_param_1, ":cur_time"),
      (try_begin),
        (this_or_next|key_clicked, key_escape),
		(key_clicked, key_xbox_start),
        (gt, ":cur_time", 200),
        (presentation_set_duration, 0),
      (try_end),
      ]),
    ]),

  ("multiplayer_poll_menu", prsntf_manual_end_only, 0, [
    (ti_on_presentation_load,
     [(set_fixed_point_multiplier, 1000),

      (create_mesh_overlay, reg0, "mesh_mp_ingame_menu"),
      (position_set_x, pos1, 250),
      (position_set_y, pos1, 80),
      (overlay_set_position, reg0, pos1),
      (position_set_x, pos1, 1000),
      (position_set_y, pos1, 1000),
      (overlay_set_size, reg0, pos1),

      (str_clear, s0),
      (create_text_overlay, "$g_presentation_obj_poll_menu_container", s0, tf_scrollable_style_2),
      (position_set_x, pos1, 285),
      (position_set_y, pos1, 125),
      (overlay_set_position, "$g_presentation_obj_poll_menu_container", pos1),
      (position_set_x, pos1, 405),
      (position_set_y, pos1, 500),
      (overlay_set_area_size, "$g_presentation_obj_poll_menu_container", pos1),
      (set_container_overlay, "$g_presentation_obj_poll_menu_container"),

      (assign, "$g_presentation_obj_poll_menu_1", -1),
      (assign, "$g_presentation_obj_poll_menu_4", -1),
      (assign, "$g_presentation_obj_poll_menu_5", -1),

      (assign, ":cur_y", 450),

      (create_text_overlay, reg0, "str_choose_a_poll_type", 0),
      (overlay_set_color, reg0, 0xFFFFFF),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),
      (val_sub, ":cur_y", escape_menu_item_height),

      (position_set_x, pos1, 60),

      (try_begin),
        (eq, "$g_multiplayer_maps_voteable", 1),
        (create_button_overlay, "$g_presentation_obj_poll_menu_1", "str_poll_for_changing_the_map", 0),
        (overlay_set_color, "$g_presentation_obj_poll_menu_1", 0xFFFFFF),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, "$g_presentation_obj_poll_menu_1", pos1),
        (val_sub, ":cur_y", escape_menu_item_height),
      (try_end),
      (try_begin),
        (eq, "$g_multiplayer_factions_voteable", 1),
        (create_button_overlay, "$g_presentation_obj_poll_menu_4", "str_poll_for_changing_the_map_and_factions", 0),
        (overlay_set_color, "$g_presentation_obj_poll_menu_4", 0xFFFFFF),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, "$g_presentation_obj_poll_menu_4", pos1),
        (val_sub, ":cur_y", escape_menu_item_height),
      (try_end),
      (try_begin),
        (gt, "$g_multiplayer_num_bots_voteable", 0),
        (create_button_overlay, "$g_presentation_obj_poll_menu_5", "str_poll_for_changing_number_of_bots", 0),
        (overlay_set_color, "$g_presentation_obj_poll_menu_5", 0xFFFFFF),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, "$g_presentation_obj_poll_menu_5", pos1),
        (val_sub, ":cur_y", escape_menu_item_height),
      (try_end),
      (try_begin),
        (eq, "$g_multiplayer_kick_voteable", 1),
        (create_button_overlay, "$g_presentation_obj_poll_menu_2", "str_poll_for_kicking_a_player", 0),
        (overlay_set_color, "$g_presentation_obj_poll_menu_2", 0xFFFFFF),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, "$g_presentation_obj_poll_menu_2", pos1),
        (val_sub, ":cur_y", escape_menu_item_height),
      (try_end),
      (try_begin),
        (eq, "$g_multiplayer_ban_voteable", 1),
        (create_button_overlay, "$g_presentation_obj_poll_menu_3", "str_poll_for_banning_a_player", 0),
        (overlay_set_color, "$g_presentation_obj_poll_menu_3", 0xFFFFFF),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, "$g_presentation_obj_poll_menu_3", pos1),
      (try_end),

      (presentation_set_duration, 999999),
      ]),
    (ti_on_presentation_event_state_change,
     [(store_trigger_param_1, ":object"),
      (try_begin),
        (eq, ":object", "$g_presentation_obj_poll_menu_1"),
        (presentation_set_duration, 0),
        (assign, "$g_multiplayer_maps_list_action_type", 1), #poll map
        (start_presentation, "prsnt_multiplayer_show_maps_list"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_poll_menu_2"),
        (presentation_set_duration, 0),
        (assign, "$g_multiplayer_players_list_action_type", 1), #poll kick
        (start_presentation, "prsnt_multiplayer_show_players_list"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_poll_menu_3"),
        (presentation_set_duration, 0),
        (assign, "$g_multiplayer_players_list_action_type", 2), #poll ban
        (start_presentation, "prsnt_multiplayer_show_players_list"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_poll_menu_4"),
        (presentation_set_duration, 0),
        (assign, "$g_multiplayer_maps_list_action_type", 2), #poll map and factions
        (start_presentation, "prsnt_multiplayer_show_maps_list"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_poll_menu_5"),
        (presentation_set_duration, 0),
        (assign, "$g_multiplayer_number_of_bots_list_action_type", 1), #for team 1
        (start_presentation, "prsnt_multiplayer_show_number_of_bots_list"),
      (try_end),
      ]),
    (ti_on_presentation_run,
     [(store_trigger_param_1, ":cur_time"),
      (try_begin),
        (this_or_next|key_clicked, key_escape),
		(key_clicked, key_xbox_start),
        (gt, ":cur_time", 200),
        (presentation_set_duration, 0),
      (try_end),
      ]),
    ]),

  ("multiplayer_show_players_list", prsntf_manual_end_only, 0, [
    (ti_on_presentation_load,
     [(set_fixed_point_multiplier, 1000),

      (create_mesh_overlay, reg0, "mesh_mp_ingame_menu"),
      (position_set_x, pos1, 250),
      (position_set_y, pos1, 80),
      (overlay_set_position, reg0, pos1),
      (position_set_x, pos1, 1000),
      (position_set_y, pos1, 1000),
      (overlay_set_size, reg0, pos1),

      (str_clear, s0),
      (create_text_overlay, "$g_presentation_obj_show_players_1", s0, tf_scrollable_style_2),
      (position_set_x, pos1, 285),
      (position_set_y, pos1, 125),
      (overlay_set_position, "$g_presentation_obj_show_players_1", pos1),
      (position_set_x, pos1, 405),
      (position_set_y, pos1, 500),
      (overlay_set_area_size, "$g_presentation_obj_show_players_1", pos1),
      (set_container_overlay, "$g_presentation_obj_show_players_1"),

      #(assign, ":cur_y", 450),
      (multiplayer_get_my_player, ":my_player_no"),

      (assign, ":cur_y", 10),
      (get_max_players, ":num_players"),
      (try_for_range, ":player_no", 1, ":num_players"), #0 is server no need to write it
        (player_is_active, ":player_no"),

        (assign, ":continue", 0),
        (try_begin),
          (neq, "$g_multiplayer_players_list_action_type", 5),
          (neq, "$g_multiplayer_players_list_action_type", 6),
          (assign, ":continue", 1),
        (else_try),
          (eq, "$g_multiplayer_players_list_action_type", 5),
          (neq, ":player_no", ":my_player_no"),
          (player_get_is_muted, ":is_muted", ":player_no"),
          (eq, ":is_muted", 0),
          (assign, ":continue", 1),
        (else_try),
          (eq, "$g_multiplayer_players_list_action_type", 6),
          (neq, ":player_no", ":my_player_no"),
          (player_get_is_muted, ":is_muted", ":player_no"),
          (eq, ":is_muted", 1),
          (assign, ":continue", 1),
        (try_end),
        (eq, ":continue", 1),
      
        (val_add, ":cur_y", escape_menu_item_height),
      (try_end),

      (create_text_overlay, reg0, "str_choose_a_player", 0),
      (overlay_set_color, reg0, 0xFFFFFF),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),
      (val_sub, ":cur_y", escape_menu_item_height),

      (get_max_players, ":num_players"),
      (try_for_range, ":player_no", 1, ":num_players"), #0 is server no need to write it
        (player_is_active, ":player_no"),
        (player_set_slot, ":player_no", slot_player_button_index, -1),

        (assign, ":continue", 0),
        (try_begin),
          (neq, "$g_multiplayer_players_list_action_type", 5),
          (neq, "$g_multiplayer_players_list_action_type", 6),
          (assign, ":continue", 1),
        (else_try),
          (eq, "$g_multiplayer_players_list_action_type", 5),
          (neq, ":player_no", ":my_player_no"),
          (player_get_is_muted, ":is_muted", ":player_no"),
          (eq, ":is_muted", 0),
          (assign, ":continue", 1),
        (else_try),
          (eq, "$g_multiplayer_players_list_action_type", 6),
          (neq, ":player_no", ":my_player_no"),
          (player_get_is_muted, ":is_muted", ":player_no"),
          (eq, ":is_muted", 1),
          (assign, ":continue", 1),
        (try_end),
        (eq, ":continue", 1),
        (str_store_player_username, s0, ":player_no"),
      
        (create_button_overlay, ":overlay_id", s0, 0),
        (overlay_set_color, ":overlay_id", 0xFFFFFF),
        (position_set_x, pos1, 130),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, ":overlay_id", pos1),
        (val_sub, ":cur_y", escape_menu_item_height),
        (player_set_slot, ":player_no", slot_player_button_index, ":overlay_id"),
      (try_end),

      (presentation_set_duration, 999999),
      ]),
    (ti_on_presentation_event_state_change,
     [(store_trigger_param_1, ":object"),
      (get_max_players, ":num_players"),
      (try_for_range, ":player_no", 1, ":num_players"), #0 is server no need to write it
        (player_is_active, ":player_no"),
        (player_slot_eq, ":player_no", slot_player_button_index, ":object"),
        (try_begin),
          (is_between, "$g_multiplayer_players_list_action_type", 1, 3), #poll kick or poll ban
          (try_begin),
            (multiplayer_get_my_player, ":my_player_no"),
            (ge, ":my_player_no", 0),
            (multiplayer_send_2_int_to_server, multiplayer_event_start_new_poll, "$g_multiplayer_players_list_action_type", ":player_no"),
            (store_mission_timer_a, ":mission_timer"),
            (val_add, ":mission_timer", multiplayer_poll_disable_period),
            (player_set_slot, ":my_player_no", slot_player_poll_disabled_until_time, ":mission_timer"),
          (try_end),
        (else_try),
          (eq, "$g_multiplayer_players_list_action_type", 3), #admin kick
          (multiplayer_send_int_to_server, multiplayer_event_admin_kick_player, ":player_no"),
        (else_try),
          (eq, "$g_multiplayer_players_list_action_type", 4), #admin ban
          (multiplayer_send_int_to_server, multiplayer_event_admin_ban_player, ":player_no"),
        (else_try),
          (eq, "$g_multiplayer_players_list_action_type", 5), #mute player
          (player_set_is_muted, ":player_no", 1),
        (else_try),
          (eq, "$g_multiplayer_players_list_action_type", 6), #unmute player
          (player_set_is_muted, ":player_no", 0),
        (try_end),
        (assign, ":num_players", 0), #break
        (presentation_set_duration, 0),
      (try_end),
      ]),
    (ti_on_presentation_run,
     [(store_trigger_param_1, ":cur_time"),
      (try_begin),
        (this_or_next|key_clicked, key_escape),
		(key_clicked, key_xbox_start),
        (gt, ":cur_time", 200),
        (presentation_set_duration, 0),
      (try_end),
      ]),
    ]),

  ("multiplayer_show_maps_list", prsntf_manual_end_only, 0, [
    (ti_on_presentation_load,
     [(set_fixed_point_multiplier, 1000),

      (create_mesh_overlay, reg0, "mesh_mp_ingame_menu"),
      (position_set_x, pos1, 250),
      (position_set_y, pos1, 80),
      (overlay_set_position, reg0, pos1),
      (position_set_x, pos1, 1000),
      (position_set_y, pos1, 1000),
      (overlay_set_size, reg0, pos1),

      (str_clear, s0),
      (create_text_overlay, "$g_presentation_obj_show_maps_list_menu_container", s0, tf_scrollable_style_2),
      (position_set_x, pos1, 285),
      (position_set_y, pos1, 125),
      (overlay_set_position, "$g_presentation_obj_show_maps_list_menu_container", pos1),
      (position_set_x, pos1, 405),
      (position_set_y, pos1, 500),
      (overlay_set_area_size, "$g_presentation_obj_show_maps_list_menu_container", pos1),
      (set_container_overlay, "$g_presentation_obj_show_maps_list_menu_container"),

      (call_script, "script_multiplayer_fill_map_game_types", "$g_multiplayer_game_type"),
      (assign, ":num_maps", reg0),
      (store_mul, ":cur_y", ":num_maps", escape_menu_item_height),
      (val_add, ":cur_y", 10),

      (create_text_overlay, reg0, "str_choose_a_map", 0),
      (overlay_set_color, reg0, 0xFFFFFF),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),
      (val_sub, ":cur_y", escape_menu_item_height),

      (assign, ":overlay_id", -1),
      (try_for_range, ":i_map", 0, ":num_maps"),
        (store_add, ":map_slot", ":i_map", multi_data_maps_for_game_type_begin),
        (troop_get_slot, ":map_no", "trp_multiplayer_data", ":map_slot"),
        (store_sub, ":string_index", ":map_no", multiplayer_scenes_begin),
        (val_add, ":string_index", multiplayer_scene_names_begin),
        (str_store_string, s0, ":string_index"),
      
        (create_button_overlay, ":overlay_id", s0, 0),
        (overlay_set_color, ":overlay_id", 0xFFFFFF),
        (position_set_x, pos1, 100),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, ":overlay_id", pos1),
        (val_sub, ":cur_y", escape_menu_item_height),
      (try_end),
      (store_add, "$g_show_maps_list_button_list_end_index", ":overlay_id", 1),
      (store_sub, "$g_show_maps_list_button_list_first_index", "$g_show_maps_list_button_list_end_index", ":num_maps"),

      (presentation_set_duration, 999999),
      ]),
    (ti_on_presentation_event_state_change,
     [(store_trigger_param_1, ":object"),
      (try_for_range, ":i_button", "$g_show_maps_list_button_list_first_index", "$g_show_maps_list_button_list_end_index"),
        (eq, ":object", ":i_button"),
        (call_script, "script_multiplayer_fill_map_game_types", "$g_multiplayer_game_type"),
        (store_sub, ":map_slot", ":object", "$g_show_maps_list_button_list_first_index"),
        (val_add, ":map_slot", multi_data_maps_for_game_type_begin),
        (troop_get_slot, ":scene_id", "trp_multiplayer_data", ":map_slot"),
        (presentation_set_duration, 0),
        (try_begin),
          (eq, "$g_multiplayer_maps_list_action_type", 1), #vote for map
          (try_begin),
            (multiplayer_get_my_player, ":my_player_no"),
            (ge, ":my_player_no", 0),
            (multiplayer_send_2_int_to_server, multiplayer_event_start_new_poll, 0, ":scene_id"),
            (store_mission_timer_a, ":mission_timer"),
            (val_add, ":mission_timer", multiplayer_poll_disable_period),
            (player_set_slot, ":my_player_no", slot_player_poll_disabled_until_time, ":mission_timer"),
          (try_end),
        (else_try), #vote for map and factions
          (assign, "$g_multiplayer_factions_list_action_type", 1), #for team 1
          (assign, "$g_multiplayer_poll_for_map_and_faction_data_map", ":scene_id"),
          (start_presentation, "prsnt_multiplayer_show_factions_list"),
        (try_end),
        (assign, "$g_show_maps_list_button_list_end_index", 0), #break;
      (try_end),
      ]),
    (ti_on_presentation_run,
     [(store_trigger_param_1, ":cur_time"),
      (try_begin),
        (this_or_next|key_clicked, key_escape),
		(key_clicked, key_xbox_start),
        (gt, ":cur_time", 200),
        (presentation_set_duration, 0),
      (try_end),
      ]),
    ]),

  ("multiplayer_show_factions_list", prsntf_manual_end_only, 0, [
    (ti_on_presentation_load,
     [(set_fixed_point_multiplier, 1000),

      (create_mesh_overlay, reg0, "mesh_mp_ingame_menu"),
      (position_set_x, pos1, 250),
      (position_set_y, pos1, 80),
      (overlay_set_position, reg0, pos1),
      (position_set_x, pos1, 1000),
      (position_set_y, pos1, 1000),
      (overlay_set_size, reg0, pos1),

      (str_clear, s0),
      (create_text_overlay, "$g_presentation_obj_show_factions_list_menu_container", s0, tf_scrollable_style_2),
      (position_set_x, pos1, 285),
      (position_set_y, pos1, 125),
      (overlay_set_position, "$g_presentation_obj_show_factions_list_menu_container", pos1),
      (position_set_x, pos1, 405),
      (position_set_y, pos1, 500),
      (overlay_set_area_size, "$g_presentation_obj_show_factions_list_menu_container", pos1),
      (set_container_overlay, "$g_presentation_obj_show_factions_list_menu_container"),

      (store_sub, ":num_factions", npc_kingdoms_end, npc_kingdoms_begin),
      (try_begin),
        (eq, "$g_multiplayer_factions_list_action_type", 2),
        (val_sub, ":num_factions", 1),
      (try_end),
      (store_mul, ":cur_y", ":num_factions", escape_menu_item_height),
      (val_add, ":cur_y", 10),

      (assign, reg0, "$g_multiplayer_factions_list_action_type"),
      (create_text_overlay, reg0, "str_choose_a_faction_for_team_reg0", 0),
      (overlay_set_color, reg0, 0xFFFFFF),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),
      (val_sub, ":cur_y", escape_menu_item_height),

      (assign, ":overlay_id", -1),
      (try_for_range, ":i_faction", npc_kingdoms_begin, npc_kingdoms_end),
        (this_or_next|eq, "$g_multiplayer_factions_list_action_type", 1),
        (neq, "$g_multiplayer_poll_for_map_and_faction_data_faction_1", ":i_faction"),
        (str_store_faction_name, s0, ":i_faction"),
        (create_button_overlay, ":overlay_id", s0, 0),
        (overlay_set_color, ":overlay_id", 0xFFFFFF),
        (position_set_x, pos1, 100),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, ":overlay_id", pos1),
        (val_sub, ":cur_y", escape_menu_item_height),
      (try_end),
      (store_add, "$g_show_factions_list_button_list_end_index", ":overlay_id", 1),
      (store_sub, "$g_show_factions_list_button_list_first_index", "$g_show_factions_list_button_list_end_index", ":num_factions"),

      (presentation_set_duration, 999999),
      ]),
    (ti_on_presentation_event_state_change,
     [(store_trigger_param_1, ":object"),
      (try_for_range, ":i_button", "$g_show_factions_list_button_list_first_index", "$g_show_factions_list_button_list_end_index"),
        (eq, ":object", ":i_button"),
        (store_sub, ":faction_no", ":object", "$g_show_factions_list_button_list_first_index"),
        (val_add, ":faction_no", npc_kingdoms_begin),
        (presentation_set_duration, 0),
        (try_begin),
          (eq, "$g_multiplayer_factions_list_action_type", 2), #vote for second team
          (try_begin),
            (ge, ":faction_no", "$g_multiplayer_poll_for_map_and_faction_data_faction_1"),
            (val_add, ":faction_no", 1),
          (try_end),
          (try_begin),
            (multiplayer_get_my_player, ":my_player_no"),
            (ge, ":my_player_no", 0),
            (multiplayer_send_4_int_to_server, multiplayer_event_start_new_poll, 3, "$g_multiplayer_poll_for_map_and_faction_data_map", "$g_multiplayer_poll_for_map_and_faction_data_faction_1", ":faction_no"),
            (store_mission_timer_a, ":mission_timer"),
            (val_add, ":mission_timer", multiplayer_poll_disable_period),
            (player_set_slot, ":my_player_no", slot_player_poll_disabled_until_time, ":mission_timer"),
          (try_end),
        (else_try), #vote for first team
          (assign, "$g_multiplayer_factions_list_action_type", 2), #for team 2
          (assign, "$g_multiplayer_poll_for_map_and_faction_data_faction_1", ":faction_no"),
          (start_presentation, "prsnt_multiplayer_show_factions_list"),
        (try_end),
        (assign, "$g_show_factions_list_button_list_end_index", 0), #break;
      (try_end),
      ]),
    (ti_on_presentation_run,
     [(store_trigger_param_1, ":cur_time"),
      (try_begin),
        (this_or_next|key_clicked, key_escape),
		(key_clicked, key_xbox_start),
        (gt, ":cur_time", 200),
        (presentation_set_duration, 0),
      (try_end),
      ]),
    ]),

  ("multiplayer_show_number_of_bots_list", prsntf_manual_end_only, 0, [
    (ti_on_presentation_load,
     [(set_fixed_point_multiplier, 1000),

      (create_mesh_overlay, reg0, "mesh_mp_ingame_menu"),
      (position_set_x, pos1, 250),
      (position_set_y, pos1, 80),
      (overlay_set_position, reg0, pos1),
      (position_set_x, pos1, 1000),
      (position_set_y, pos1, 1000),
      (overlay_set_size, reg0, pos1),

      (str_clear, s0),
      (create_text_overlay, "$g_presentation_obj_show_number_of_bots_list_menu_container", s0, tf_scrollable_style_2),
      (position_set_x, pos1, 285),
      (position_set_y, pos1, 125),
      (overlay_set_position, "$g_presentation_obj_show_number_of_bots_list_menu_container", pos1),
      (position_set_x, pos1, 405),
      (position_set_y, pos1, 500),
      (overlay_set_area_size, "$g_presentation_obj_show_number_of_bots_list_menu_container", pos1),
      (set_container_overlay, "$g_presentation_obj_show_number_of_bots_list_menu_container"),

      (assign, ":num_options", 0),
      (store_add, ":end_cond", "$g_multiplayer_num_bots_voteable", 1),
      (try_for_range, ":i_number", 0, ":end_cond"),
        (assign, ":i_number_mod_5", ":i_number"),
        (val_mod, ":i_number_mod_5", 5),
        (this_or_next|lt, ":i_number", 10),
        (eq, ":i_number_mod_5", 0),
        (val_add, ":num_options", 1),
      (try_end),

      (store_mul, ":cur_y", ":num_options", escape_menu_item_height),
      (val_add, ":cur_y", 10),

      (assign, reg0, "$g_multiplayer_number_of_bots_list_action_type"),
      (create_text_overlay, reg0, "str_choose_number_of_bots_for_team_reg0", 0),
      (overlay_set_color, reg0, 0xFFFFFF),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),
      (val_sub, ":cur_y", escape_menu_item_height),

      (assign, ":overlay_id", -1),
      (try_for_range, ":i_number", 0, ":end_cond"),
        (assign, ":i_number_mod_5", ":i_number"),
        (val_mod, ":i_number_mod_5", 5),
        (this_or_next|lt, ":i_number", 10),
        (eq, ":i_number_mod_5", 0),
        (assign, reg0, ":i_number"),
        (str_store_string, s0, "str_reg0"),
        (create_button_overlay, ":overlay_id", s0, 0),
        (overlay_set_color, ":overlay_id", 0xFFFFFF),
        (position_set_x, pos1, 100),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, ":overlay_id", pos1),
        (val_sub, ":cur_y", escape_menu_item_height),
      (try_end),
      (store_add, "$g_show_number_of_bots_list_button_list_end_index", ":overlay_id", 1),
      (store_sub, "$g_show_number_of_bots_list_button_list_first_index", "$g_show_number_of_bots_list_button_list_end_index", ":num_options"),

      (presentation_set_duration, 999999),
      ]),
    (ti_on_presentation_event_state_change,
     [(store_trigger_param_1, ":object"),
      (try_for_range, ":i_button", "$g_show_number_of_bots_list_button_list_first_index", "$g_show_number_of_bots_list_button_list_end_index"),
        (eq, ":object", ":i_button"),
        (store_sub, ":value_index", ":object", "$g_show_number_of_bots_list_button_list_first_index"),
        (try_begin),
          (lt, ":value_index", 10),
          (assign, ":used_value", ":value_index"),
        (else_try),
          (store_sub, ":used_value", ":value_index", 8),
          (val_mul, ":used_value", 5),
        (try_end),
        (presentation_set_duration, 0),
        (try_begin),
          (eq, "$g_multiplayer_number_of_bots_list_action_type", 2), #vote for second team
          (try_begin),
            (multiplayer_get_my_player, ":my_player_no"),
            (ge, ":my_player_no", 0),
            (multiplayer_send_3_int_to_server, multiplayer_event_start_new_poll, 4, "$g_multiplayer_poll_number_of_bots_team_1", ":used_value"),
            (store_mission_timer_a, ":mission_timer"),
            (val_add, ":mission_timer", multiplayer_poll_disable_period),
            (player_set_slot, ":my_player_no", slot_player_poll_disabled_until_time, ":mission_timer"),
          (try_end),
        (else_try), #vote for first team
          (assign, "$g_multiplayer_number_of_bots_list_action_type", 2), #for team 2
          (assign, "$g_multiplayer_poll_number_of_bots_team_1", ":used_value"),
          (start_presentation, "prsnt_multiplayer_show_number_of_bots_list"),
        (try_end),
        (assign, "$g_show_number_of_bots_list_button_list_end_index", 0), #break;
      (try_end),
      ]),
    (ti_on_presentation_run,
     [(store_trigger_param_1, ":cur_time"),
      (try_begin),
        (this_or_next|key_clicked, key_escape),
		(key_clicked, key_xbox_start),
        (gt, ":cur_time", 200),
        (presentation_set_duration, 0),
      (try_end),
      ]),
    ]),

  ("multiplayer_poll", prsntf_read_only|prsntf_manual_end_only, 0, [
    (ti_on_presentation_load,
     [(set_fixed_point_multiplier, 1000),

      (create_mesh_overlay, reg0, "mesh_white_plane"),
      (overlay_set_color, reg0, 0x000000),
      (overlay_set_alpha, reg0, 0x44),
      (position_set_x, pos1, 50),
      (position_set_y, pos1, 50),
      (overlay_set_position, reg0, pos1),
      (position_set_x, pos1, 37500),
      (position_set_y, pos1, 4500),
      (overlay_set_size, reg0, pos1),

      (try_begin),
        (eq, "$g_multiplayer_poll_to_show", 0),
        (store_sub, ":string_index", "$g_multiplayer_poll_value_to_show", multiplayer_scenes_begin),
        (val_add, ":string_index", multiplayer_scene_names_begin),
        (str_store_string, s0, ":string_index"),
        (create_text_overlay, reg0, "str_poll_change_map", tf_center_justify),
      (else_try),
        (eq, "$g_multiplayer_poll_to_show", 1),
        (str_store_player_username, s0, "$g_multiplayer_poll_value_to_show"),
        (create_text_overlay, reg0, "str_poll_kick_player", tf_center_justify),
      (else_try),
        (eq, "$g_multiplayer_poll_to_show", 2),
        (str_store_player_username, s0, "$g_multiplayer_poll_value_to_show"),
        (create_text_overlay, reg0, "str_poll_ban_player", tf_center_justify),
      (else_try),
        (eq, "$g_multiplayer_poll_to_show", 3),
        (store_sub, ":string_index", "$g_multiplayer_poll_value_to_show", multiplayer_scenes_begin),
        (val_add, ":string_index", multiplayer_scene_names_begin),
        (str_store_string, s0, ":string_index"),
        (str_store_faction_name, s1, "$g_multiplayer_poll_value_2_to_show"),
        (str_store_faction_name, s2, "$g_multiplayer_poll_value_3_to_show"),
        (create_text_overlay, reg0, "str_poll_change_map_with_faction", tf_center_justify|tf_scrollable_style_2),
      (else_try),
        (assign, reg0, "$g_multiplayer_poll_value_to_show"),
        (assign, reg1, "$g_multiplayer_poll_value_2_to_show"),
        (str_store_faction_name, s0, "$g_multiplayer_team_1_faction"),
        (str_store_faction_name, s1, "$g_multiplayer_team_2_faction"),
        (create_text_overlay, reg0, "str_poll_change_number_of_bots", tf_center_justify|tf_scrollable_style_2),
      (try_end),
      (overlay_set_color, reg0, 0xFFFFFF),
      (try_begin),
        (neq, "$g_multiplayer_poll_to_show", 3),
        (neq, "$g_multiplayer_poll_to_show", 4),
        (position_set_x, pos1, 400),
        (position_set_y, pos1, 100),
        (overlay_set_position, reg0, pos1),
      (else_try),
        (position_set_x, pos1, 50),
        (position_set_y, pos1, 70),
        (overlay_set_position, reg0, pos1),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 60),
        (overlay_set_area_size, reg0, pos1),
      (try_end),

      (store_mission_timer_a, ":mission_timer"),
      (store_sub, "$g_multiplayer_poll_last_written_seconds_left", "$g_multiplayer_poll_client_end_time", ":mission_timer"),
      (assign, reg0, "$g_multiplayer_poll_last_written_seconds_left"),

      (create_text_overlay, "$g_presentation_obj_poll_1", "str_poll_time_left", tf_right_align|tf_single_line),
      (overlay_set_color, "$g_presentation_obj_poll_1", 0xFFFFFF),
      (position_set_x, pos1, 790),
      (position_set_y, pos1, 60),
      (overlay_set_position, "$g_presentation_obj_poll_1", pos1),

      (omit_key_once, key_1),
      (omit_key_once, key_2),
      (presentation_set_duration, 999999),
      ]),
    (ti_on_presentation_run,
     [(store_trigger_param_1, ":cur_time"),
      (try_begin),
        (this_or_next|key_clicked, key_escape),
		(this_or_next|key_clicked, key_xbox_start),
        (key_clicked, key_2),
        (gt, ":cur_time", 500),
        (multiplayer_send_int_to_server, multiplayer_event_answer_to_poll, 0),
        (clear_omitted_keys),
        (presentation_set_duration, 0),
      (else_try),
        (key_clicked, key_1),
        (gt, ":cur_time", 500),
        (multiplayer_send_int_to_server, multiplayer_event_answer_to_poll, 1),
        (clear_omitted_keys),
        (presentation_set_duration, 0),
      (try_end),
      (store_mission_timer_a, ":mission_timer"),
      (store_sub, ":time_left", "$g_multiplayer_poll_client_end_time", ":mission_timer"),
      (try_begin),
        (neq, ":time_left", "$g_multiplayer_poll_last_written_seconds_left"),
        (try_begin),
          (lt, ":time_left", 0),
          (clear_omitted_keys),
          (presentation_set_duration, 0),
        (else_try),
          (assign, "$g_multiplayer_poll_last_written_seconds_left", ":time_left"),
          (assign, reg0, "$g_multiplayer_poll_last_written_seconds_left"),
          (overlay_set_text, "$g_presentation_obj_poll_1", "str_poll_time_left"),
        (try_end),
      (try_end),
      ]),
    ]),

  ("tutorial_show_mouse_movement",prsntf_read_only|prsntf_manual_end_only,0,[
      (ti_on_presentation_load,
       [
         (try_begin),
           (this_or_next|eq, "$g_tutorial_mouse_dir", -1),
           (eq, "$g_tutorial_mouse_click", -1),
           (presentation_set_duration, 0),
         (else_try),
           (set_fixed_point_multiplier, 1000),
           (assign, "$g_tutorial_displayed_mouse_dir", "$g_tutorial_mouse_dir"),
           (assign, "$g_tutorial_displayed_mouse_click", "$g_tutorial_mouse_click"),
           (store_add, ":arrow_mesh", "$g_tutorial_mouse_dir", "mesh_mouse_arrow_down"),
           (create_mesh_overlay, reg0, ":arrow_mesh"),
           (position_set_x, pos1, 800),
           (position_set_y, pos1, 800),
           (overlay_set_size, reg0, pos1),
           (position_set_x, pos1, 380),
           (position_set_y, pos1, 500),
           (overlay_set_position, reg0, pos1),
           (try_begin),
             (eq, "$g_tutorial_mouse_click", 0),
             (create_mesh_overlay, reg0, "mesh_mouse_left_click"),
           (else_try),
             (create_mesh_overlay, reg0, "mesh_mouse_right_click"),
           (try_end),
           (position_set_x, pos1, 800),
           (position_set_y, pos1, 800),
           (overlay_set_size, reg0, pos1),
           (position_set_x, pos1, 540),
           (position_set_y, pos1, 500),
           (overlay_set_position, reg0, pos1),
           (create_mesh_overlay, reg0, "mesh_mouse_arrow_plus"),
           (overlay_set_color, reg0, 0xFFFFFF),
           (position_set_x, pos1, 600),
           (position_set_y, pos1, 600),
           (overlay_set_size, reg0, pos1),
           (position_set_x, pos1, 470),
           (position_set_y, pos1, 510),
           (overlay_set_position, reg0, pos1),
           (presentation_set_duration, 999999),
         (try_end),
        ]),
      (ti_on_presentation_run,
       [(try_begin),
          (this_or_next|neq, "$g_tutorial_displayed_mouse_dir", "$g_tutorial_mouse_dir"),
          (neq, "$g_tutorial_displayed_mouse_click", "$g_tutorial_mouse_click"),
          (presentation_set_duration, 0),
          (try_begin),
            (ge, "$g_tutorial_mouse_dir", 0),
            (ge, "$g_tutorial_mouse_click", 0),
            (start_presentation, "prsnt_tutorial_show_mouse_movement"),
          (try_end),
        (try_end),
        ]),
      ]),

  ("name_kingdom",0,mesh_load_window,[
      (ti_on_presentation_load,
       [(set_fixed_point_multiplier, 1000),
        (str_store_string, s1, "str_name_kingdom_text"),
        (create_text_overlay, reg1, s1, tf_center_justify),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, 500),
        (overlay_set_position, reg1, pos1),
        (overlay_set_text, reg1, s1),
        (create_simple_text_box_overlay, "$g_presentation_obj_name_kingdom_1"),
        (position_set_x, pos1, 400),
        (position_set_y, pos1, 400),
        (overlay_set_position, "$g_presentation_obj_name_kingdom_1", pos1),
        (try_begin),
          (eq, "$players_kingdom_name_set", 1),
          (str_store_faction_name, s7, "fac_player_supporters_faction"),
          (overlay_set_text, "$g_presentation_obj_name_kingdom_1", s7),
        (else_try),
          (str_store_troop_name, s0, "trp_player"),
          (overlay_set_text, "$g_presentation_obj_name_kingdom_1", "str_default_kingdom_name"),
          (str_store_string, s7, "str_default_kingdom_name"),
        (try_end),
        
        (create_button_overlay, "$g_presentation_obj_name_kingdom_2", "@Continue...", tf_center_justify),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, 300),
        (overlay_set_position, "$g_presentation_obj_name_kingdom_2", pos1),
        (presentation_set_duration, 999999),
        ]),
      (ti_on_presentation_event_state_change,
       [(store_trigger_param_1, ":object"),
        (try_begin),
          (eq, ":object", "$g_presentation_obj_name_kingdom_1"),
          (str_store_string, s7, s0),
        (else_try),
          (eq, ":object", "$g_presentation_obj_name_kingdom_2"),
          (faction_set_name, "fac_player_supporters_faction", s7),
          (faction_set_color, "fac_player_supporters_faction", 0xFF0000),
          (assign, "$players_kingdom_name_set", 1),
          (presentation_set_duration, 0),
        (try_end),
        ]),
      ]),
  
  ("banner_selection",0,mesh_load_window,[
      (ti_on_presentation_load,
       [(set_fixed_point_multiplier, 1000),
        (str_store_string, s1, "str_banner_selection_text"),
        (create_text_overlay, reg1, s1, tf_center_justify),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, 600),
        (overlay_set_position, reg1, pos1),
        (overlay_set_text, reg1, s1),
        (create_button_overlay, "$g_presentation_obj_banner_selection_1", "@Next Page", tf_center_justify),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, 50),
        (overlay_set_position, "$g_presentation_obj_banner_selection_1", pos1),

        (assign, ":x_pos", 150),
        (assign, ":y_pos", 575),
        (assign, ":try_end", banner_meshes_end_minus_one),
        (store_sub, ":num_npc_kingdoms", npc_kingdoms_end, npc_kingdoms_begin),
        (val_sub, ":try_end", ":num_npc_kingdoms"), #do not allow kingdom banners to be selected
        (store_mul, ":begin_mesh", 16, "$g_presentation_page_no"),
        (val_add, ":begin_mesh", banner_meshes_begin),
        (store_add, ":try_end_2", ":begin_mesh", 16),
        (val_min, ":try_end", ":try_end_2"),
        (store_add, "$g_presentation_banner_start", "$g_presentation_obj_banner_selection_1", 1),
        (try_for_range, ":cur_banner_mesh", ":begin_mesh", ":try_end"),
          (create_image_button_overlay, reg1, ":cur_banner_mesh", ":cur_banner_mesh"),
          (position_set_x, pos1, ":x_pos"),
          (position_set_y, pos1, ":y_pos"),
          (overlay_set_position, reg1, pos1),
          (position_set_x, pos1, 100),
          (position_set_y, pos1, 100),
          (overlay_set_size, reg1, pos1),
          (val_add, ":x_pos", 100),
          (ge, ":x_pos", 900),
          (assign, ":x_pos", 150),
          (val_sub, ":y_pos", 250),
        (try_end),
        (presentation_set_duration, 999999),
        ]),
      (ti_on_presentation_event_state_change,
       [(store_trigger_param_1, ":object"),
        (try_begin),
          (eq, ":object", "$g_presentation_obj_banner_selection_1"),
          (val_add, "$g_presentation_page_no", 1),
          (val_mod, "$g_presentation_page_no", 8),
          (start_presentation, "prsnt_banner_selection"),
        (else_try),
          (store_sub, ":selected_banner", ":object", "$g_presentation_banner_start"),
          (store_mul, ":page_adder", 16, "$g_presentation_page_no"),
          (val_add, ":selected_banner", ":page_adder"),
          (store_add, ":selected_banner_map_icon", ":selected_banner", banner_map_icons_begin),
          (party_set_banner_icon, "p_main_party", ":selected_banner_map_icon"),
          (store_add, ":selected_banner_spr", ":selected_banner", banner_scene_props_begin),
          (troop_set_slot, "trp_player", slot_troop_banner_scene_prop, ":selected_banner_spr"),
                    
          #Correcting banners according to the player banner
          #(assign, ":end_cond", active_npcs_end),
          #(try_for_range, ":cur_troop", original_kingdom_heroes_begin, ":end_cond"),
          #  (troop_slot_eq, ":cur_troop", slot_troop_banner_scene_prop, ":selected_banner_spr"),
          #  (str_store_troop_name, s7, ":cur_troop"),
          #  (display_message, "@DEBUGS : {s7}'s banner is changed"),
          #  (troop_set_slot, ":cur_troop", slot_troop_banner_scene_prop, banner_scene_props_end_minus_one),
          #  (assign, ":end_cond", 0),
          #(try_end),
                    
          (presentation_set_duration, 0),
          (assign, ":troop_to_change", 0),
          (assign, ":end_cond", active_npcs_end),
          (try_for_range, ":cur_troop", active_npcs_begin, ":end_cond"),
            (troop_slot_eq, ":cur_troop", slot_troop_banner_scene_prop, ":selected_banner_spr"),
            (assign, ":troop_to_change", ":cur_troop"),
            (assign, ":end_cond", 0),
            (troop_set_slot, ":cur_troop", slot_troop_banner_scene_prop, banner_scene_props_end_minus_one),
            (troop_get_slot, ":cur_party", ":cur_troop", slot_troop_leaded_party),
            (gt, ":cur_party", 0),
            (party_set_banner_icon, ":cur_party", banner_map_icons_end_minus_one),             
          (try_end),
          (try_for_range, ":cur_center", walled_centers_begin, walled_centers_end),
            (try_begin),
              (party_slot_eq, ":cur_center", slot_town_lord, "trp_player"),
              (party_set_banner_icon, ":cur_center", ":selected_banner_map_icon"),
            (else_try),
              (party_slot_eq, ":cur_center", slot_town_lord, ":troop_to_change"),
              (party_set_banner_icon, ":cur_center", banner_map_icons_end_minus_one), 
            (try_end),
          (try_end),
        (try_end),
        ]),
      (ti_on_presentation_run,
       [(try_begin),
          (this_or_next|key_clicked, key_space),
          (this_or_next|key_clicked, key_enter),
          (this_or_next|key_clicked, key_escape),
          (this_or_next|key_clicked, key_back_space),
		  (this_or_next|key_clicked, key_xbox_ltrigger),
          (key_clicked, key_xbox_rtrigger),
          (presentation_set_duration, 0),
        (try_end),

        ]),
      ]),

  ("custom_banner", 0, mesh_load_window,
   [
     (ti_on_presentation_load,
      [
        (set_fixed_point_multiplier, 1000),
        (troop_get_slot, ":flag_type", "trp_player", slot_troop_custom_banner_flag_type),
        (val_max, ":flag_type", 0),
        (val_add, ":flag_type", custom_banner_flag_types_begin),
        (troop_get_slot, ":map_flag_type", "trp_player", slot_troop_custom_banner_map_flag_type),
        (val_max, ":map_flag_type", 0),
        (val_add, ":map_flag_type", custom_banner_flag_map_types_begin),
##        (create_mesh_overlay_with_tableau_material, "$g_presentation_obj_custom_banner_1", ":flag_type", "tableau_custom_banner_square", "trp_player"),
        (troop_get_slot, ":bg_color_1", "trp_player", slot_troop_custom_banner_bg_color_1),
        (troop_get_slot, ":bg_color_2", "trp_player", slot_troop_custom_banner_bg_color_2),
        
        (create_text_overlay, reg1, "str_color_no_1", 0),
        (position_set_x, pos1, 40),
        (position_set_y, pos1, 550),
        (overlay_set_position, reg1, pos1),
        (create_text_overlay, reg1, "str_color_no_2", 0),
        (position_set_x, pos1, 40),
        (position_set_y, pos1, 500),
        (overlay_set_position, reg1, pos1),

        (create_image_button_overlay_with_tableau_material, "$g_presentation_obj_custom_banner_22", "mesh_color_picker", "tableau_color_picker", ":bg_color_1"),
        (create_image_button_overlay_with_tableau_material, "$g_presentation_obj_custom_banner_23", "mesh_color_picker", "tableau_color_picker", ":bg_color_2"),
        (position_set_x, pos1, 200),
        (position_set_y, pos1, 565),
        (overlay_set_position, "$g_presentation_obj_custom_banner_22", pos1),
        (position_set_y, pos1, 515),
        (overlay_set_position, "$g_presentation_obj_custom_banner_23", pos1),
        (position_set_x, pos1, 250),
        (position_set_y, pos1, 250),
        (overlay_set_size, "$g_presentation_obj_custom_banner_22", pos1),
        (overlay_set_size, "$g_presentation_obj_custom_banner_23", pos1),
        
        (create_button_overlay, "$g_presentation_obj_custom_banner_2", "str_change", tf_center_justify),
        (create_button_overlay, "$g_presentation_obj_custom_banner_3", "str_change", tf_center_justify),
        (create_button_overlay, "$g_presentation_obj_custom_banner_4", "str_change_background", tf_center_justify),
        (create_button_overlay, "$g_presentation_obj_custom_banner_5", "str_change", tf_center_justify),
        (create_button_overlay, "$g_presentation_obj_custom_banner_19", "str_change", tf_center_justify),
        (create_button_overlay, "$g_presentation_obj_custom_banner_20", "str_accept", tf_center_justify),
        (troop_get_slot, ":num_charges", "trp_player", slot_troop_custom_banner_num_charges),
        (create_button_overlay, "$g_presentation_obj_custom_banner_16", "str_randomize", tf_center_justify),
        (create_image_button_overlay_with_tableau_material, "$g_presentation_obj_custom_banner_17", ":flag_type", "tableau_custom_banner_default", "trp_player"),
        (try_begin),
          (eq, ":map_flag_type", "mesh_custom_map_banner_01"),
          (create_image_button_overlay_with_tableau_material, "$g_presentation_obj_custom_banner_18", ":map_flag_type", "tableau_custom_banner_square", "trp_player"),
        (else_try),
          (eq, ":map_flag_type", "mesh_custom_map_banner_02"),
          (create_image_button_overlay_with_tableau_material, "$g_presentation_obj_custom_banner_18", ":map_flag_type", "tableau_custom_banner_short", "trp_player"),
        (else_try),
          (create_image_button_overlay_with_tableau_material, "$g_presentation_obj_custom_banner_18", ":map_flag_type", "tableau_custom_banner_tall", "trp_player"),
        (try_end),
        (create_image_button_overlay_with_tableau_material, "$g_presentation_obj_custom_banner_1", -1, "tableau_custom_banner_square_no_mesh", "trp_player"),
        (create_text_overlay, reg1, "str_sample_banner", tf_center_justify),
        (position_set_x, pos1, 825),
        (position_set_y, pos1, 650),
        (overlay_set_position, reg1, pos1),
        (create_text_overlay, reg1, "str_sample_map_banner", tf_center_justify),
        (position_set_y, pos1, 500),
        (overlay_set_position, reg1, pos1),

        (position_set_x, pos1, 800),
        (position_set_y, pos1, 640),
        (overlay_set_position, "$g_presentation_obj_custom_banner_17", pos1),
        (position_set_x, pos1, 780),
        (position_set_y, pos1, 315),
        (overlay_set_position, "$g_presentation_obj_custom_banner_18", pos1),
        (position_set_x, pos1, 50),
        (position_set_y, pos1, 50),
        (overlay_set_size, "$g_presentation_obj_custom_banner_17", pos1),
        (position_set_x, pos1, 50),
        (position_set_y, pos1, 50),
        (overlay_set_size, "$g_presentation_obj_custom_banner_18", pos1),
        

        (create_text_overlay, reg1, "str_number_of_charges", 0),
        (position_set_x, pos1, 40),
        (position_set_y, pos1, 350),
        (overlay_set_position, reg1, pos1),

        (assign, reg1, ":num_charges"),
        (create_text_overlay, reg2, "str_reg1", tf_center_justify),
        (position_set_x, pos1, 350),
        (position_set_y, pos1, 350),
        (overlay_set_position, reg2, pos1),
        (try_begin),
          (lt, ":num_charges", 4),
          (create_button_overlay, "$g_presentation_obj_custom_banner_15", "str_plus", tf_center_justify),
          (position_set_x, pos1, 385),
          (position_set_y, pos1, 350),
          (overlay_set_position, "$g_presentation_obj_custom_banner_15", pos1),
        (else_try),
          (assign, "$g_presentation_obj_custom_banner_15", -1),
        (try_end),
        (try_begin),
          (gt, ":num_charges", 0),
          (create_button_overlay, "$g_presentation_obj_custom_banner_21", "str_minus", tf_center_justify),
          (position_set_x, pos1, 370),
          (position_set_y, pos1, 350),
          (overlay_set_position, "$g_presentation_obj_custom_banner_21", pos1),
        (else_try),
          (assign, "$g_presentation_obj_custom_banner_21", -1),
        (try_end),

        (try_begin),
          (ge, ":num_charges", 1),
          (create_text_overlay, reg1, "str_charge", tf_center_justify),
          (position_set_x, pos1, 300),
          (position_set_y, pos1, 300),
          (overlay_set_position, reg1, pos1),
          (create_text_overlay, reg1, "str_color", tf_center_justify),
          (position_set_x, pos1, 550),
          (position_set_y, pos1, 300),
          (overlay_set_position, reg1, pos1),
          (create_button_overlay, "$g_presentation_obj_custom_banner_14", "str_change_charge_position", tf_center_justify),
          (position_set_y, pos1, 350),
          (position_set_x, pos1, 550),
          (overlay_set_position, "$g_presentation_obj_custom_banner_14", pos1),

          (create_text_overlay, reg1, "str_charge_no_1", 0),
          (position_set_x, pos1, 40),
          (position_set_y, pos1, 240),
          (overlay_set_position, reg1, pos1),
          (create_button_overlay, "$g_presentation_obj_custom_banner_6", "str_change", 0),
          (position_set_x, pos1, 310),
          (overlay_set_position, "$g_presentation_obj_custom_banner_6", pos1),
          (create_button_overlay, "$g_presentation_obj_custom_banner_7", "str_change", 0),
          (position_set_x, pos1, 560),
          (overlay_set_position, "$g_presentation_obj_custom_banner_7", pos1),
          (troop_get_slot, ":cur_charge", "trp_player", slot_troop_custom_banner_charge_type_1),
          (val_mod, ":cur_charge", 256),
          (val_add, ":cur_charge", custom_banner_charges_begin),
          (create_image_button_overlay, "$g_presentation_obj_custom_banner_24", ":cur_charge", ":cur_charge"),
          (position_set_x, pos1, 260),
          (position_set_y, pos1, 255),
          (overlay_set_position, "$g_presentation_obj_custom_banner_24", pos1),
          (position_set_x, pos1, 50),
          (position_set_y, pos1, 50),
          (overlay_set_size, "$g_presentation_obj_custom_banner_24", pos1),
          (troop_get_slot, ":cur_charge_color", "trp_player", slot_troop_custom_banner_charge_color_1),
          (create_image_button_overlay_with_tableau_material, "$g_presentation_obj_custom_banner_28", "mesh_color_picker", "tableau_color_picker", ":cur_charge_color"),
          (position_set_x, pos1, 530),
          (position_set_y, pos1, 255),
          (overlay_set_position, "$g_presentation_obj_custom_banner_28", pos1),
          (position_set_x, pos1, 250),
          (position_set_y, pos1, 250),
          (overlay_set_size, "$g_presentation_obj_custom_banner_28", pos1),

          (create_button_overlay, "$g_presentation_obj_custom_banner_32", "str_flip_horizontal", 0),
          (position_set_x, pos1, 700),
          (position_set_y, pos1, 240),
          (overlay_set_position, "$g_presentation_obj_custom_banner_32", pos1),
          (create_button_overlay, "$g_presentation_obj_custom_banner_33", "str_flip_vertical", 0),
          (position_set_x, pos1, 800),
          (overlay_set_position, "$g_presentation_obj_custom_banner_33", pos1),
        (try_end),
        (try_begin),
          (ge, ":num_charges", 2),
          (create_text_overlay, reg1, "str_charge_no_2", 0),
          (position_set_x, pos1, 40),
          (position_set_y, pos1, 180),
          (overlay_set_position, reg1, pos1),
          (create_button_overlay, "$g_presentation_obj_custom_banner_8", "str_change", 0),
          (position_set_x, pos1, 310),
          (overlay_set_position, "$g_presentation_obj_custom_banner_8", pos1),
          (create_button_overlay, "$g_presentation_obj_custom_banner_9", "str_change", 0),
          (position_set_x, pos1, 560),
          (overlay_set_position, "$g_presentation_obj_custom_banner_9", pos1),
          (troop_get_slot, ":cur_charge", "trp_player", slot_troop_custom_banner_charge_type_2),
          (val_mod, ":cur_charge", 256),
          (val_add, ":cur_charge", custom_banner_charges_begin),
          (create_image_button_overlay, "$g_presentation_obj_custom_banner_25", ":cur_charge", ":cur_charge"),
          (position_set_x, pos1, 260),
          (position_set_y, pos1, 195),
          (overlay_set_position, "$g_presentation_obj_custom_banner_25", pos1),
          (position_set_x, pos1, 50),
          (position_set_y, pos1, 50),
          (overlay_set_size, "$g_presentation_obj_custom_banner_25", pos1),
          (troop_get_slot, ":cur_charge_color", "trp_player", slot_troop_custom_banner_charge_color_2),
          (create_image_button_overlay_with_tableau_material, "$g_presentation_obj_custom_banner_29", "mesh_color_picker", "tableau_color_picker", ":cur_charge_color"),
          (position_set_x, pos1, 530),
          (position_set_y, pos1, 195),
          (overlay_set_position, "$g_presentation_obj_custom_banner_29", pos1),
          (position_set_x, pos1, 250),
          (position_set_y, pos1, 250),
          (overlay_set_size, "$g_presentation_obj_custom_banner_29", pos1),

          (create_button_overlay, "$g_presentation_obj_custom_banner_34", "str_flip_horizontal", 0),
          (position_set_x, pos1, 700),
          (position_set_y, pos1, 180),
          (overlay_set_position, "$g_presentation_obj_custom_banner_34", pos1),
          (create_button_overlay, "$g_presentation_obj_custom_banner_35", "str_flip_vertical", 0),
          (position_set_x, pos1, 800),
          (overlay_set_position, "$g_presentation_obj_custom_banner_35", pos1),
        (try_end),
        (try_begin),
          (ge, ":num_charges", 3),
          (create_text_overlay, reg1, "str_charge_no_3", 0),
          (position_set_x, pos1, 40),
          (position_set_y, pos1, 120),
          (overlay_set_position, reg1, pos1),
          (create_button_overlay, "$g_presentation_obj_custom_banner_10", "str_change", 0),
          (position_set_x, pos1, 310),
          (overlay_set_position, "$g_presentation_obj_custom_banner_10", pos1),
          (create_button_overlay, "$g_presentation_obj_custom_banner_11", "str_change", 0),
          (position_set_x, pos1, 560),
          (overlay_set_position, "$g_presentation_obj_custom_banner_11", pos1),
          (troop_get_slot, ":cur_charge", "trp_player", slot_troop_custom_banner_charge_type_3),
          (val_mod, ":cur_charge", 256),
          (val_add, ":cur_charge", custom_banner_charges_begin),
          (create_image_button_overlay, "$g_presentation_obj_custom_banner_26", ":cur_charge", ":cur_charge"),
          (position_set_x, pos1, 260),
          (position_set_y, pos1, 135),
          (overlay_set_position, "$g_presentation_obj_custom_banner_26", pos1),
          (position_set_x, pos1, 50),
          (position_set_y, pos1, 50),
          (overlay_set_size, "$g_presentation_obj_custom_banner_26", pos1),
          (troop_get_slot, ":cur_charge_color", "trp_player", slot_troop_custom_banner_charge_color_3),
          (create_image_button_overlay_with_tableau_material, "$g_presentation_obj_custom_banner_30", "mesh_color_picker", "tableau_color_picker", ":cur_charge_color"),
          (position_set_x, pos1, 530),
          (position_set_y, pos1, 135),
          (overlay_set_position, "$g_presentation_obj_custom_banner_30", pos1),
          (position_set_x, pos1, 250),
          (position_set_y, pos1, 250),
          (overlay_set_size, "$g_presentation_obj_custom_banner_30", pos1),

          (create_button_overlay, "$g_presentation_obj_custom_banner_36", "str_flip_horizontal", 0),
          (position_set_x, pos1, 700),
          (position_set_y, pos1, 120),
          (overlay_set_position, "$g_presentation_obj_custom_banner_36", pos1),
          (create_button_overlay, "$g_presentation_obj_custom_banner_37", "str_flip_vertical", 0),
          (position_set_x, pos1, 800),
          (overlay_set_position, "$g_presentation_obj_custom_banner_37", pos1),
        (try_end),
        (try_begin),
          (ge, ":num_charges", 4),
          (create_text_overlay, reg1, "str_charge_no_4", 0),
          (position_set_x, pos1, 40),
          (position_set_y, pos1, 60),
          (overlay_set_position, reg1, pos1),
          (create_button_overlay, "$g_presentation_obj_custom_banner_12", "str_change", 0),
          (position_set_x, pos1, 310),
          (overlay_set_position, "$g_presentation_obj_custom_banner_12", pos1),
          (create_button_overlay, "$g_presentation_obj_custom_banner_13", "str_change", 0),
          (position_set_x, pos1, 560),
          (overlay_set_position, "$g_presentation_obj_custom_banner_13", pos1),
          (troop_get_slot, ":cur_charge", "trp_player", slot_troop_custom_banner_charge_type_4),
          (val_mod, ":cur_charge", 256),
          (val_add, ":cur_charge", custom_banner_charges_begin),
          (create_image_button_overlay, "$g_presentation_obj_custom_banner_27", ":cur_charge", ":cur_charge"),
          (position_set_x, pos1, 260),
          (position_set_y, pos1, 75),
          (overlay_set_position, "$g_presentation_obj_custom_banner_27", pos1),
          (position_set_x, pos1, 50),
          (position_set_y, pos1, 50),
          (overlay_set_size, "$g_presentation_obj_custom_banner_27", pos1),
          (troop_get_slot, ":cur_charge_color", "trp_player", slot_troop_custom_banner_charge_color_4),
          (create_image_button_overlay_with_tableau_material, "$g_presentation_obj_custom_banner_31", "mesh_color_picker", "tableau_color_picker", ":cur_charge_color"),
          (position_set_x, pos1, 530),
          (position_set_y, pos1, 75),
          (overlay_set_position, "$g_presentation_obj_custom_banner_31", pos1),
          (position_set_x, pos1, 250),
          (position_set_y, pos1, 250),
          (overlay_set_size, "$g_presentation_obj_custom_banner_31", pos1),

          (create_button_overlay, "$g_presentation_obj_custom_banner_38", "str_flip_horizontal", 0),
          (position_set_x, pos1, 700),
          (position_set_y, pos1, 60),
          (overlay_set_position, "$g_presentation_obj_custom_banner_38", pos1),
          (create_button_overlay, "$g_presentation_obj_custom_banner_39", "str_flip_vertical", 0),
          (position_set_x, pos1, 800),
          (overlay_set_position, "$g_presentation_obj_custom_banner_39", pos1),
        (try_end),
        
        (position_set_x, pos1, 350),
        (position_set_y, pos1, 400),
        (overlay_set_position, "$g_presentation_obj_custom_banner_1", pos1),
        (position_set_x, pos1, 275),
        (position_set_y, pos1, 550),
        (overlay_set_position, "$g_presentation_obj_custom_banner_2", pos1),
        (position_set_y, pos1, 500),
        (overlay_set_position, "$g_presentation_obj_custom_banner_3", pos1),
        (position_set_x, pos1, 175),
        (position_set_y, pos1, 600),
        (overlay_set_position, "$g_presentation_obj_custom_banner_4", pos1),
        (position_set_x, pos1, 880),
        (position_set_y, pos1, 575),
        (overlay_set_position, "$g_presentation_obj_custom_banner_5", pos1),
        (position_set_y, pos1, 400),
        (overlay_set_position, "$g_presentation_obj_custom_banner_19", pos1),
        (position_set_y, pos1, 650),
        (position_set_x, pos1, 175),
        (overlay_set_position, "$g_presentation_obj_custom_banner_16", pos1),
        (position_set_y, pos1, 150),
        (position_set_x, pos1, 850),
        (overlay_set_position, "$g_presentation_obj_custom_banner_20", pos1),
        (presentation_set_duration, 999999),
        ]),
     (ti_on_presentation_event_state_change,
      [
        (store_trigger_param_1, ":object"),
        (troop_get_slot, ":num_charges", "trp_player", slot_troop_custom_banner_num_charges),
        (try_begin),
          (this_or_next|eq, ":object", "$g_presentation_obj_custom_banner_2"),
          (eq, ":object", "$g_presentation_obj_custom_banner_22"),
          (assign, "$g_presentation_next_presentation", "prsnt_custom_banner"),
          (assign, "$g_presentation_output_slot", slot_troop_custom_banner_bg_color_1),
          (start_presentation, "prsnt_color_selection"),
        (else_try),
          (this_or_next|eq, ":object", "$g_presentation_obj_custom_banner_3"),
          (eq, ":object", "$g_presentation_obj_custom_banner_23"),
          (assign, "$g_presentation_next_presentation", "prsnt_custom_banner"),
          (assign, "$g_presentation_output_slot", slot_troop_custom_banner_bg_color_2),
          (start_presentation, "prsnt_color_selection"),
        (else_try),
          (this_or_next|eq, ":object", "$g_presentation_obj_custom_banner_4"),
          (eq, ":object", "$g_presentation_obj_custom_banner_1"),
          (assign, "$g_presentation_next_presentation", "prsnt_custom_banner"),
          (start_presentation, "prsnt_banner_background_selection"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_custom_banner_5"),
          (assign, "$g_presentation_next_presentation", "prsnt_custom_banner"),
          (start_presentation, "prsnt_banner_flag_type_selection"),
        (else_try),
          (ge, ":num_charges", 1),
          (this_or_next|eq, ":object", "$g_presentation_obj_custom_banner_6"),
          (eq, ":object", "$g_presentation_obj_custom_banner_24"),
          (assign, "$g_presentation_next_presentation", "prsnt_custom_banner"),
          (assign, "$g_presentation_output_slot", slot_troop_custom_banner_charge_type_1),
          (start_presentation, "prsnt_banner_charge_selection"),
        (else_try),
          (ge, ":num_charges", 1),
          (this_or_next|eq, ":object", "$g_presentation_obj_custom_banner_7"),
          (eq, ":object", "$g_presentation_obj_custom_banner_28"),
          (assign, "$g_presentation_next_presentation", "prsnt_custom_banner"),
          (assign, "$g_presentation_output_slot", slot_troop_custom_banner_charge_color_1),
          (start_presentation, "prsnt_color_selection"),
        (else_try),
          (ge, ":num_charges", 2),
          (this_or_next|eq, ":object", "$g_presentation_obj_custom_banner_8"),
          (eq, ":object", "$g_presentation_obj_custom_banner_25"),
          (assign, "$g_presentation_next_presentation", "prsnt_custom_banner"),
          (assign, "$g_presentation_output_slot", slot_troop_custom_banner_charge_type_2),
          (start_presentation, "prsnt_banner_charge_selection"),
        (else_try),
          (ge, ":num_charges", 2),
          (this_or_next|eq, ":object", "$g_presentation_obj_custom_banner_9"),
          (eq, ":object", "$g_presentation_obj_custom_banner_29"),
          (assign, "$g_presentation_next_presentation", "prsnt_custom_banner"),
          (assign, "$g_presentation_output_slot", slot_troop_custom_banner_charge_color_2),
          (start_presentation, "prsnt_color_selection"),
        (else_try),
          (ge, ":num_charges", 3),
          (this_or_next|eq, ":object", "$g_presentation_obj_custom_banner_10"),
          (eq, ":object", "$g_presentation_obj_custom_banner_26"),
          (assign, "$g_presentation_next_presentation", "prsnt_custom_banner"),
          (assign, "$g_presentation_output_slot", slot_troop_custom_banner_charge_type_3),
          (start_presentation, "prsnt_banner_charge_selection"),
        (else_try),
          (ge, ":num_charges", 3),
          (this_or_next|eq, ":object", "$g_presentation_obj_custom_banner_11"),
          (eq, ":object", "$g_presentation_obj_custom_banner_30"),
          (assign, "$g_presentation_next_presentation", "prsnt_custom_banner"),
          (assign, "$g_presentation_output_slot", slot_troop_custom_banner_charge_color_3),
          (start_presentation, "prsnt_color_selection"),
        (else_try),
          (ge, ":num_charges", 4),
          (this_or_next|eq, ":object", "$g_presentation_obj_custom_banner_12"),
          (eq, ":object", "$g_presentation_obj_custom_banner_27"),
          (assign, "$g_presentation_next_presentation", "prsnt_custom_banner"),
          (assign, "$g_presentation_output_slot", slot_troop_custom_banner_charge_type_4),
          (start_presentation, "prsnt_banner_charge_selection"),
        (else_try),
          (ge, ":num_charges", 4),
          (this_or_next|eq, ":object", "$g_presentation_obj_custom_banner_13"),
          (eq, ":object", "$g_presentation_obj_custom_banner_31"),
          (assign, "$g_presentation_next_presentation", "prsnt_custom_banner"),
          (assign, "$g_presentation_output_slot", slot_troop_custom_banner_charge_color_4),
          (start_presentation, "prsnt_color_selection"),
        (else_try),
          (ge, ":num_charges", 1),
          (eq, ":object", "$g_presentation_obj_custom_banner_14"),
          (assign, "$g_presentation_next_presentation", "prsnt_custom_banner"),
          (start_presentation, "prsnt_banner_charge_positioning"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_custom_banner_15"),
          (troop_get_slot, ":num_charges", "trp_player", slot_troop_custom_banner_num_charges),
          (val_add, ":num_charges", 1),
          (val_clamp, ":num_charges", 0, 5),
          (troop_set_slot, "trp_player", slot_troop_custom_banner_num_charges, ":num_charges"),
          (start_presentation, "prsnt_custom_banner"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_custom_banner_21"),
          (troop_get_slot, ":num_charges", "trp_player", slot_troop_custom_banner_num_charges),
          (val_sub, ":num_charges", 1),
          (val_clamp, ":num_charges", 0, 5),
          (troop_set_slot, "trp_player", slot_troop_custom_banner_num_charges, ":num_charges"),
          (start_presentation, "prsnt_custom_banner"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_custom_banner_16"),
          (call_script, "script_get_random_custom_banner", "trp_player"),
          (start_presentation, "prsnt_custom_banner"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_custom_banner_17"),
          (assign, "$g_presentation_next_presentation", "prsnt_custom_banner"),
          (start_presentation, "prsnt_banner_flag_type_selection"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_custom_banner_18"),
          (assign, "$g_presentation_next_presentation", "prsnt_custom_banner"),
          (start_presentation, "prsnt_banner_flag_map_type_selection"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_custom_banner_19"),
          (assign, "$g_presentation_next_presentation", "prsnt_custom_banner"),
          (start_presentation, "prsnt_banner_flag_map_type_selection"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_custom_banner_32"),
          (troop_get_slot, ":charge_type", "trp_player", slot_troop_custom_banner_charge_type_1),
          (store_mod, ":charge_type_base", ":charge_type", 256),
          (val_div, ":charge_type", 256),
          (store_mod, ":flag", ":charge_type", 2),
          (val_div, ":charge_type", 2), #remove flag
          (val_add, ":flag", 1),
          (val_mod, ":flag", 2), #switch flag
          (val_mul, ":charge_type", 2),
          (val_add, ":charge_type", ":flag"),
          (val_mul, ":charge_type", 256),
          (val_add, ":charge_type", ":charge_type_base"),
          (troop_set_slot, "trp_player", slot_troop_custom_banner_charge_type_1, ":charge_type"),
          (start_presentation, "prsnt_custom_banner"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_custom_banner_34"),
          (troop_get_slot, ":charge_type", "trp_player", slot_troop_custom_banner_charge_type_2),
          (store_mod, ":charge_type_base", ":charge_type", 256),
          (val_div, ":charge_type", 256),
          (store_mod, ":flag", ":charge_type", 2),
          (val_div, ":charge_type", 2), #remove flag
          (val_add, ":flag", 1),
          (val_mod, ":flag", 2), #switch flag
          (val_mul, ":charge_type", 2),
          (val_add, ":charge_type", ":flag"),
          (val_mul, ":charge_type", 256),
          (val_add, ":charge_type", ":charge_type_base"),
          (troop_set_slot, "trp_player", slot_troop_custom_banner_charge_type_2, ":charge_type"),
          (start_presentation, "prsnt_custom_banner"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_custom_banner_36"),
          (troop_get_slot, ":charge_type", "trp_player", slot_troop_custom_banner_charge_type_3),
          (store_mod, ":charge_type_base", ":charge_type", 256),
          (val_div, ":charge_type", 256),
          (store_mod, ":flag", ":charge_type", 2),
          (val_div, ":charge_type", 2), #remove flag
          (val_add, ":flag", 1),
          (val_mod, ":flag", 2), #switch flag
          (val_mul, ":charge_type", 2),
          (val_add, ":charge_type", ":flag"),
          (val_mul, ":charge_type", 256),
          (val_add, ":charge_type", ":charge_type_base"),
          (troop_set_slot, "trp_player", slot_troop_custom_banner_charge_type_3, ":charge_type"),
          (start_presentation, "prsnt_custom_banner"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_custom_banner_38"),
          (troop_get_slot, ":charge_type", "trp_player", slot_troop_custom_banner_charge_type_4),
          (store_mod, ":charge_type_base", ":charge_type", 256),
          (val_div, ":charge_type", 256),
          (store_mod, ":flag", ":charge_type", 2),
          (val_div, ":charge_type", 2), #remove flag
          (val_add, ":flag", 1),
          (val_mod, ":flag", 2), #switch flag
          (val_mul, ":charge_type", 2),
          (val_add, ":charge_type", ":flag"),
          (val_mul, ":charge_type", 256),
          (val_add, ":charge_type", ":charge_type_base"),
          (troop_set_slot, "trp_player", slot_troop_custom_banner_charge_type_4, ":charge_type"),
          (start_presentation, "prsnt_custom_banner"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_custom_banner_33"),
          (troop_get_slot, ":charge_type", "trp_player", slot_troop_custom_banner_charge_type_1),
          (store_div, ":flag", ":charge_type", 512),
          (val_add, ":flag", 1),
          (val_mod, ":flag", 2), #switch flag
          (val_mul, ":flag", 512),
          (val_mod, ":charge_type", 512), #remove flag
          (val_add, ":charge_type", ":flag"),
          (troop_set_slot, "trp_player", slot_troop_custom_banner_charge_type_1, ":charge_type"),
          (start_presentation, "prsnt_custom_banner"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_custom_banner_35"),
          (troop_get_slot, ":charge_type", "trp_player", slot_troop_custom_banner_charge_type_2),
          (store_div, ":flag", ":charge_type", 512),
          (val_add, ":flag", 1),
          (val_mod, ":flag", 2), #switch flag
          (val_mul, ":flag", 512),
          (val_mod, ":charge_type", 512), #remove flag
          (val_add, ":charge_type", ":flag"),
          (troop_set_slot, "trp_player", slot_troop_custom_banner_charge_type_2, ":charge_type"),
          (start_presentation, "prsnt_custom_banner"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_custom_banner_37"),
          (troop_get_slot, ":charge_type", "trp_player", slot_troop_custom_banner_charge_type_3),
          (store_div, ":flag", ":charge_type", 512),
          (val_add, ":flag", 1),
          (val_mod, ":flag", 2), #switch flag
          (val_mul, ":flag", 512),
          (val_mod, ":charge_type", 512), #remove flag
          (val_add, ":charge_type", ":flag"),
          (troop_set_slot, "trp_player", slot_troop_custom_banner_charge_type_3, ":charge_type"),
          (start_presentation, "prsnt_custom_banner"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_custom_banner_39"),
          (troop_get_slot, ":charge_type", "trp_player", slot_troop_custom_banner_charge_type_4),
          (store_div, ":flag", ":charge_type", 512),
          (val_add, ":flag", 1),
          (val_mod, ":flag", 2), #switch flag
          (val_mul, ":flag", 512),
          (val_mod, ":charge_type", 512), #remove flag
          (val_add, ":charge_type", ":flag"),
          (troop_set_slot, "trp_player", slot_troop_custom_banner_charge_type_4, ":charge_type"),
          (start_presentation, "prsnt_custom_banner"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_custom_banner_20"),
          (troop_get_slot, ":flag_icon", "trp_player", slot_troop_custom_banner_map_flag_type),
          (try_begin),
            (ge, ":flag_icon", 0),
            (val_add, ":flag_icon", custom_banner_map_icons_begin),
            (party_set_banner_icon, "p_main_party", ":flag_icon"),
          (try_end),
          (presentation_set_duration, 0),
        (try_end),
        ]),
##     (ti_on_presentation_run,
##      [(try_begin),
##         (this_or_next|key_clicked, key_space),
##         (this_or_next|key_clicked, key_enter),
##         (this_or_next|key_clicked, key_escape),
##         (key_clicked, key_back_space),
##         (presentation_set_duration, 0),
##       (try_end),
##       ]),
     ]),

  ("banner_charge_positioning", 0, mesh_load_window,
   [
     (ti_on_presentation_load,
      [
        (set_fixed_point_multiplier, 1000),
        (create_text_overlay, reg1, "str_choose_position", tf_center_justify),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, 600),
        (overlay_set_position, reg1, pos1),
        (assign, ":pos_x", 125),
        (assign, ":pos_y", 400),
        (call_script, "script_get_troop_custom_banner_num_positionings", "trp_player"),
        (assign, ":num_positionings", reg0),
        (store_mul, ":x_needed", ":num_positionings", 125),
        (val_sub, ":x_needed", 25),
        (store_div, ":pos_x", ":x_needed", 2),
        (store_sub, ":pos_x", 500, ":pos_x"),
        (try_for_range, ":cur_positioning", 0, ":num_positionings"),
          (create_image_button_overlay_with_tableau_material, reg1, -1, "tableau_positioning_selection", ":cur_positioning"),
          (position_set_x, pos1, ":pos_x"),
          (position_set_y, pos1, ":pos_y"),
          (val_add, ":pos_x", 125),
          (overlay_set_position, reg1, pos1),
          (troop_set_slot, "trp_temp_array_a", ":cur_positioning", reg1),
        (try_end),
        (presentation_set_duration, 999999),
        ]),
     (ti_on_presentation_event_state_change,
      [
        (store_trigger_param_1, ":object"),
        (call_script, "script_get_troop_custom_banner_num_positionings", "trp_player"),
        (assign, ":num_positionings", reg0),
        (try_for_range, ":trp_slot_index", 0, ":num_positionings"),
          (troop_slot_eq, "trp_temp_array_a", ":trp_slot_index", ":object"),
          (troop_set_slot, "trp_player", slot_troop_custom_banner_positioning, ":trp_slot_index"),
          (assign, ":num_positionings", 0),
        (try_end),
        (try_begin),
          (gt, "$g_presentation_next_presentation", 0),
          (start_presentation, "$g_presentation_next_presentation"),
        (else_try),
          (presentation_set_duration, 0),
        (try_end),
        ]),
     ]),

  ("banner_charge_selection", 0, mesh_load_window,
   [
     (ti_on_presentation_load,
      [
        (set_fixed_point_multiplier, 1000),
        (create_text_overlay, reg1, "str_choose_charge", tf_center_justify),

        (position_set_x, pos1, 500),
        (position_set_y, pos1, 650),
        (overlay_set_position, reg1, pos1),
        (assign, ":pos_x", 100),
        (assign, ":pos_y", 600),
        (try_for_range, ":cur_charge", custom_banner_charges_begin, custom_banner_charges_end),
          (create_image_button_overlay, reg1, ":cur_charge", ":cur_charge"),
          (position_set_x, pos1, ":pos_x"),
          (position_set_y, pos1, ":pos_y"),
          (val_add, ":pos_x", 100),
          (try_begin),
            (gt, ":pos_x", 900),
            (assign, ":pos_x", 100),
            (val_sub, ":pos_y", 100),
          (try_end),
          (overlay_set_position, reg1, pos1),
          (position_set_x, pos1, 80),
          (position_set_y, pos1, 80),
          (overlay_set_size, reg1, pos1),
          (store_sub, ":slot_index", ":cur_charge", custom_banner_charges_begin),
          (troop_set_slot, "trp_temp_array_a", ":slot_index", reg1),
        (try_end),
        (presentation_set_duration, 999999),
        ]),
     (ti_on_presentation_event_state_change,
      [
        (store_trigger_param_1, ":object"),
        (assign, ":end_cond", custom_banner_charges_end),
        (val_sub, ":end_cond", custom_banner_charges_begin),
        (try_for_range, ":trp_slot_index", 0, ":end_cond"),
          (troop_slot_eq, "trp_temp_array_a", ":trp_slot_index", ":object"),
          (troop_set_slot, "trp_player", "$g_presentation_output_slot", ":trp_slot_index"),
          (assign, ":end_cond", 0),
        (try_end),
        (try_begin),
          (gt, "$g_presentation_next_presentation", 0),
          (start_presentation, "$g_presentation_next_presentation"),
        (else_try),
          (presentation_set_duration, 0),
        (try_end),
        ]),
     ]),

  ("banner_background_selection", 0, mesh_load_window,
   [
     (ti_on_presentation_load,
      [
        (set_fixed_point_multiplier, 1000),
        (create_text_overlay, reg1, "str_choose_background", tf_center_justify),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, 600),
        (overlay_set_position, reg1, pos1),
        (assign, ":pos_x", 75),
        (assign, ":pos_y", 450),
        (try_for_range, ":cur_banner", custom_banner_backgrounds_begin, custom_banner_backgrounds_end),
          (store_sub, ":slot_index", ":cur_banner", custom_banner_backgrounds_begin),
          (create_image_button_overlay_with_tableau_material, reg1, -1, "tableau_background_selection", ":slot_index"),
          (position_set_x, pos1, ":pos_x"),
          (position_set_y, pos1, ":pos_y"),
          (val_add, ":pos_x", 125),
          (try_begin),
            (gt, ":pos_x", 900),
            (assign, ":pos_x", 75),
            (val_sub, ":pos_y", 125),
          (try_end),
          (overlay_set_position, reg1, pos1),
          (troop_set_slot, "trp_temp_array_a", ":slot_index", reg1),
        (try_end),
        (presentation_set_duration, 999999),
        ]),
     (ti_on_presentation_event_state_change,
      [
        (store_trigger_param_1, ":object"),
        (assign, ":end_cond", custom_banner_backgrounds_end),
        (val_sub, ":end_cond", custom_banner_backgrounds_begin),
        (try_for_range, ":trp_slot_index", 0, ":end_cond"),
          (troop_slot_eq, "trp_temp_array_a", ":trp_slot_index", ":object"),
          (troop_set_slot, "trp_player", slot_troop_custom_banner_bg_type, ":trp_slot_index"),
          (assign, ":end_cond", 0),
        (try_end),
        (try_begin),
          (gt, "$g_presentation_next_presentation", 0),
          (start_presentation, "$g_presentation_next_presentation"),
        (else_try),
          (presentation_set_duration, 0),
        (try_end),
        ]),
     ]),

  ("banner_flag_type_selection", 0, mesh_load_window,
   [
     (ti_on_presentation_load,
      [
        (set_fixed_point_multiplier, 1000),
        (create_text_overlay, reg1, "str_choose_flag_type", tf_center_justify),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, 600),
        (overlay_set_position, reg1, pos1),

        (assign, ":pos_x", 435),
        (assign, ":pos_y", 450),
        (try_for_range, ":cur_flag", custom_banner_flag_types_begin, custom_banner_flag_types_end),
          (store_sub, ":slot_index", ":cur_flag", custom_banner_flag_types_begin),
          (troop_set_slot, "trp_player", slot_troop_custom_banner_flag_type, ":slot_index"),
          (create_image_button_overlay_with_tableau_material, reg1, ":cur_flag", "tableau_custom_banner_default", "trp_player"),
          (position_set_x, pos1, ":pos_x"),
          (position_set_y, pos1, ":pos_y"),
          (val_add, ":pos_x", 130),
          (overlay_set_position, reg1, pos1),
          (position_set_x, pos1, 100),
          (position_set_y, pos1, 100),
          (overlay_set_size, reg1, pos1),
          (troop_set_slot, "trp_temp_array_a", ":slot_index", reg1),
        (try_end),
        (presentation_set_duration, 999999),
        ]),
     (ti_on_presentation_event_state_change,
      [
        (store_trigger_param_1, ":object"),
        (assign, ":end_cond", custom_banner_flag_types_end),
        (val_sub, ":end_cond", custom_banner_flag_types_begin),
        (try_for_range, ":trp_slot_index", 0, ":end_cond"),
          (troop_slot_eq, "trp_temp_array_a", ":trp_slot_index", ":object"),
          (troop_set_slot, "trp_player", slot_troop_custom_banner_flag_type, ":trp_slot_index"),
          (assign, ":end_cond", 0),
        (try_end),
        (try_begin),
          (gt, "$g_presentation_next_presentation", 0),
          (start_presentation, "$g_presentation_next_presentation"),
        (else_try),
          (presentation_set_duration, 0),
        (try_end),
        ]),
     ]),

  ("banner_flag_map_type_selection", 0, mesh_load_window,
   [
     (ti_on_presentation_load,
      [
        (set_fixed_point_multiplier, 1000),
        (create_text_overlay, reg1, "str_choose_map_flag_type", tf_center_justify),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, 600),
        (overlay_set_position, reg1, pos1),
        (troop_get_slot, ":bg_type", "trp_player", slot_troop_custom_banner_bg_type),
        (val_add, ":bg_type", custom_banner_backgrounds_begin),
        (assign, ":pos_x", 250),
        (assign, ":pos_y", 150),
        (try_for_range, ":cur_flag", custom_banner_flag_map_types_begin, custom_banner_flag_map_types_end),
          (store_sub, ":slot_index", ":cur_flag", custom_banner_flag_map_types_begin),
          (troop_set_slot, "trp_player", slot_troop_custom_banner_map_flag_type, ":slot_index"),
          (try_begin),
            (eq, ":cur_flag", "mesh_custom_map_banner_01"),
            (create_image_button_overlay_with_tableau_material, reg1, ":cur_flag", "tableau_custom_banner_square", "trp_player"),
          (else_try),
            (eq, ":cur_flag", "mesh_custom_map_banner_02"),
            (create_image_button_overlay_with_tableau_material, reg1, ":cur_flag", "tableau_custom_banner_short", "trp_player"),
          (else_try),
            (create_image_button_overlay_with_tableau_material, reg1, ":cur_flag", "tableau_custom_banner_tall", "trp_player"),
          (try_end),
          (position_set_x, pos1, ":pos_x"),
          (position_set_y, pos1, ":pos_y"),
          (val_add, ":pos_x", 200),
          (overlay_set_position, reg1, pos1),
          (position_set_x, pos1, 100),
          (position_set_y, pos1, 100),
          (overlay_set_size, reg1, pos1),
          (troop_set_slot, "trp_temp_array_a", ":slot_index", reg1),
        (try_end),
        (presentation_set_duration, 999999),
        ]),
     (ti_on_presentation_event_state_change,
      [
        (store_trigger_param_1, ":object"),
        (assign, ":end_cond", custom_banner_flag_map_types_end),
        (val_sub, ":end_cond", custom_banner_flag_map_types_begin),
        (try_for_range, ":trp_slot_index", 0, ":end_cond"),
          (troop_slot_eq, "trp_temp_array_a", ":trp_slot_index", ":object"),
          (troop_set_slot, "trp_player", slot_troop_custom_banner_map_flag_type, ":trp_slot_index"),
          (assign, ":end_cond", 0),
        (try_end),
        (try_begin),
          (gt, "$g_presentation_next_presentation", 0),
          (start_presentation, "$g_presentation_next_presentation"),
        (else_try),
          (presentation_set_duration, 0),
        (try_end),
        ]),
     ]),

  ("color_selection", 0, mesh_load_window,
   [
     (ti_on_presentation_load,
      [
        (set_fixed_point_multiplier, 1000),
        (create_text_overlay, reg1, "str_choose_color", tf_center_justify),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, 600),
        (overlay_set_position, reg1, pos1),

        (assign, ":pos_x", 125),
        (assign, ":pos_y", 450),
        (try_for_range, ":i_color", 0, 42),
          (call_script, "script_get_custom_banner_color_from_index", ":i_color"),
          (assign, ":cur_color", reg0),
          (create_image_button_overlay_with_tableau_material, reg1, "mesh_color_picker", "tableau_color_picker", ":cur_color"),
          (position_set_x, pos1, ":pos_x"),
          (position_set_y, pos1, ":pos_y"),
          (val_add, ":pos_x", 50),
          (try_begin),
            (store_mod, ":mod_i_color", ":i_color", 7),
            (eq, ":mod_i_color", 6),
            (assign, ":pos_x", 125),
            (val_sub, ":pos_y", 50),
          (try_end),
          (overlay_set_position, reg1, pos1),
          (position_set_x, pos1, 500),
          (position_set_y, pos1, 500),
          (overlay_set_size, reg1, pos1),
          (store_mul, ":trp_slot_index", ":i_color", 2),
          (store_add, ":trp_slot_color", ":trp_slot_index", 1),
          (troop_set_slot, "trp_temp_array_a", ":trp_slot_index", reg1),
          (troop_set_slot, "trp_temp_array_a", ":trp_slot_color", ":cur_color"),
        (try_end),
        (presentation_set_duration, 999999),
        ]),
     (ti_on_presentation_event_state_change,
      [
        (store_trigger_param_1, ":object"),
        (assign, ":end_cond", 64),
        (try_for_range, ":i_color", 0, ":end_cond"),
          (store_mul, ":trp_slot_index", ":i_color", 2),
          (troop_slot_eq, "trp_temp_array_a", ":trp_slot_index", ":object"),
          (store_add, ":trp_slot_color", ":trp_slot_index", 1),
          (troop_get_slot, ":output_color", "trp_temp_array_a", ":trp_slot_color"),
          (troop_set_slot, "trp_player", "$g_presentation_output_slot", ":output_color"),
          (assign, ":end_cond", 0),
        (try_end),
        (try_begin),
          (gt, "$g_presentation_next_presentation", 0),
          (start_presentation, "$g_presentation_next_presentation"),
        (else_try),
          (presentation_set_duration, 0),
        (try_end),
        ]),
     ]),

  ("marshall_selection", 0, mesh_load_window,
   [
     (ti_on_presentation_load,
      [
        (assign, "$g_presentation_obj_marshall_selection_1", -1),
        (assign, "$g_presentation_obj_marshall_selection_2", -1),
        (assign, "$g_presentation_obj_marshall_selection_3", -1),
        (set_fixed_point_multiplier, 1000),
        (assign, "$g_presentation_next_presentation", -1),

        (store_add, ":total_renown", "$g_presentation_marshall_selection_max_renown_1", "$g_presentation_marshall_selection_max_renown_2"),
        (faction_get_slot, ":king", "$players_kingdom", slot_faction_leader),

        (str_store_troop_name, s1, "$g_presentation_marshall_selection_max_renown_1_troop"),
        (create_text_overlay, reg1, "@Candidate #1: {s1}", tf_center_justify),
        (position_set_x, pos1, 200),
        (position_set_y, pos1, 600),
        (overlay_set_position, reg1, pos1),
        (str_store_troop_name, s1, "$g_presentation_marshall_selection_max_renown_2_troop"),
        (create_text_overlay, reg1, "@Candidate #2: {s1}", tf_center_justify),
        (position_set_x, pos1, 800),
        (position_set_y, pos1, 600),
        (overlay_set_position, reg1, pos1),
        (create_mesh_overlay_with_tableau_material, reg1, -1, "tableau_troop_note_mesh", "$g_presentation_marshall_selection_max_renown_1_troop"),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, 500),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 100),
        (position_set_y, pos1, 300),
        (overlay_set_position, reg1, pos1),
        (create_mesh_overlay_with_tableau_material, reg1, -1, "tableau_troop_note_mesh", "$g_presentation_marshall_selection_max_renown_2_troop"),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, 500),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 700),
        (position_set_y, pos1, 300),
        (overlay_set_position, reg1, pos1),

        (assign, ":lord_index", "$g_presentation_input"),
        (val_add, "$g_presentation_input", 1),

        (try_begin),
          (lt, ":lord_index", 0),
          (str_store_troop_name, s1, "$g_presentation_marshall_selection_max_renown_1_troop"),
          (str_store_troop_name, s2, "$g_presentation_marshall_selection_max_renown_2_troop"),
          (str_store_troop_name, s3, ":king"),
          (str_store_faction_name, s4, "$players_kingdom"),
          (create_text_overlay, reg1, "@{s3} of {s4} wishes to select a new marshall and invites his vassals for a counsel. {s1} and {s2} are the likely candidates.", tf_center_justify),
          (position_set_x, pos1, 500),
          (position_set_y, pos1, 200),
          (overlay_set_position, reg1, pos1),

          (create_button_overlay, "$g_presentation_obj_marshall_selection_1", "@Continue...", tf_center_justify),
          (position_set_x, pos1, 500),
          (position_set_y, pos1, 100),
          (overlay_set_position, "$g_presentation_obj_marshall_selection_1", pos1),
          (assign, "$g_presentation_next_presentation", "prsnt_marshall_selection"),
        (else_try),
          (assign, ":cur_index", ":lord_index"),
          (try_for_range_backwards, ":loop_var", "trp_kingdom_heroes_including_player_begin", active_npcs_end),
            (ge, ":cur_index", 0),
            (assign, ":cur_troop", ":loop_var"),
            (assign, ":continue", 0),
            (try_begin),
              (eq, ":loop_var", "trp_kingdom_heroes_including_player_begin"),
              (assign, ":cur_troop", "trp_player"),
              (try_begin),
                (eq, "$g_player_is_captive", 0),
                (assign, ":continue", 1),
              (try_end),
            (else_try),
              (store_troop_faction, ":cur_troop_faction", ":cur_troop"),
              (eq, "$players_kingdom", ":cur_troop_faction"),
              #(troop_slot_eq, ":cur_troop", slot_troop_is_prisoner, 0),
              (neg|troop_slot_ge, ":cur_troop", slot_troop_prisoner_of_party, 0),
              (troop_slot_ge, ":cur_troop", slot_troop_leaded_party, 1),
              (troop_slot_eq, ":cur_troop", slot_troop_occupation, slto_kingdom_hero),
              (neg|faction_slot_eq, ":cur_troop_faction", slot_faction_leader, ":cur_troop"),
              (assign, ":continue", 1),
            (try_end),
            (eq, ":continue", 1),

            (neq, "$g_presentation_marshall_selection_max_renown_1_troop", ":cur_troop"),
            (neq, "$g_presentation_marshall_selection_max_renown_2_troop", ":cur_troop"),

            (val_sub, ":cur_index", 1),
            (lt, ":cur_index", 0),

            (assign, "$g_presentation_next_presentation", "prsnt_marshall_selection"),

            (create_mesh_overlay_with_tableau_material, reg1, -1, "tableau_troop_note_mesh", ":cur_troop"),
            (position_set_x, pos1, 300),
            (position_set_y, pos1, 300),
            (overlay_set_size, reg1, pos1),
            (position_set_x, pos1, 440),
            (position_set_y, pos1, 400),
            (overlay_set_position, reg1, pos1),

            (try_begin),
              (eq, ":cur_troop", "trp_player"),
              (create_text_overlay, reg1, "@Who do you wish to support?", tf_center_justify),
              (position_set_x, pos1, 500),
              (position_set_y, pos1, 200),
              (overlay_set_position, reg1, pos1),
              (str_store_troop_name, s1, "$g_presentation_marshall_selection_max_renown_1_troop"),
              (create_button_overlay, "$g_presentation_obj_marshall_selection_2", "@{!}{s1}", tf_center_justify),
              (position_set_x, pos1, 300),
              (position_set_y, pos1, 100),
              (overlay_set_position, "$g_presentation_obj_marshall_selection_2", pos1),
              (str_store_troop_name, s1, "$g_presentation_marshall_selection_max_renown_2_troop"),
              (create_button_overlay, "$g_presentation_obj_marshall_selection_3", "@{!}{s1}", tf_center_justify),
              (position_set_x, pos1, 700),
              (position_set_y, pos1, 100),
              (overlay_set_position, "$g_presentation_obj_marshall_selection_3", pos1),
            (else_try),
              (str_store_troop_name, s1, ":cur_troop"),
              (store_random_in_range, ":random_renown", 0, ":total_renown"),
              (val_sub, ":random_renown", "$g_presentation_marshall_selection_max_renown_1"),
              (try_begin),
                (lt, ":random_renown", 0),
                (val_add, "$g_presentation_marshall_selection_1_vote", 1),
                (str_store_troop_name, s2, "$g_presentation_marshall_selection_max_renown_1_troop"),
              (else_try),
                (val_add, "$g_presentation_marshall_selection_2_vote", 1),
                (str_store_troop_name, s2, "$g_presentation_marshall_selection_max_renown_2_troop"),
              (try_end),
              (create_text_overlay, reg1, "@{s1} gives his support to {s2}.", tf_center_justify),
              (position_set_x, pos1, 500),
              (position_set_y, pos1, 200),
              (overlay_set_position, reg1, pos1),

              (create_button_overlay, "$g_presentation_obj_marshall_selection_1", "@Continue...", tf_center_justify),
              (position_set_x, pos1, 500),
              (position_set_y, pos1, 100),
              (overlay_set_position, "$g_presentation_obj_marshall_selection_1", pos1),
            (try_end),
          (try_end),
        (try_end),

        (assign, reg0, "$g_presentation_marshall_selection_1_vote"),
        (create_text_overlay, reg1, "@Number of Supporters: {reg0}", tf_center_justify),
        (position_set_x, pos1, 200),
        (position_set_y, pos1, 550),
        (overlay_set_position, reg1, pos1),
        (assign, reg0, "$g_presentation_marshall_selection_2_vote"),
        (create_text_overlay, reg1, "@Number of Supporters: {reg0}", tf_center_justify),
        (position_set_x, pos1, 800),
        (position_set_y, pos1, 550),
        (overlay_set_position, reg1, pos1),

        (try_begin),
          (lt, "$g_presentation_next_presentation", 0),
          (try_begin),
            (gt, "$g_presentation_marshall_selection_2_vote", "$g_presentation_marshall_selection_1_vote"),
            (assign, ":local_temp", "$g_presentation_marshall_selection_max_renown_1_troop"),
            (assign, "$g_presentation_marshall_selection_max_renown_1_troop", "$g_presentation_marshall_selection_max_renown_2_troop"),
            (assign, "$g_presentation_marshall_selection_max_renown_2_troop", ":local_temp"),
          (try_end),
          #Winner is set to g_presentation_marshall_selection_max_renown_1_troop
          (str_store_troop_name, s1, "$g_presentation_marshall_selection_max_renown_1_troop"),
          (str_store_troop_name, s2, ":king"),
          (str_store_faction_name, s3, "$players_kingdom"),
          (create_text_overlay, reg1, "@{s2} has heard his vassals' counsel. He selects {s1} as the marshall of {s3}.", tf_center_justify),
          (position_set_x, pos1, 500),
          (position_set_y, pos1, 200),
          (overlay_set_position, reg1, pos1),
          (create_button_overlay, "$g_presentation_obj_marshall_selection_1", "@Continue...", tf_center_justify),
          (position_set_x, pos1, 500),
          (position_set_y, pos1, 100),
          (overlay_set_position, "$g_presentation_obj_marshall_selection_1", pos1),
        (try_end),

        (presentation_set_duration, 999999),
        ]),
     (ti_on_presentation_event_state_change,
      [
        (store_trigger_param_1, ":object"),
        (try_begin),
          (eq, ":object", "$g_presentation_obj_marshall_selection_2"),
          (val_add, "$g_presentation_marshall_selection_1_vote", 1),
          (call_script, "script_change_player_relation_with_troop", "$g_presentation_marshall_selection_max_renown_1_troop", 2),
          (call_script, "script_change_player_relation_with_troop", "$g_presentation_marshall_selection_max_renown_2_troop", -2),
        (else_try),
          (eq, ":object", "$g_presentation_obj_marshall_selection_3"),
          (val_add, "$g_presentation_marshall_selection_2_vote", 1),
          (call_script, "script_change_player_relation_with_troop", "$g_presentation_marshall_selection_max_renown_1_troop", -2),
          (call_script, "script_change_player_relation_with_troop", "$g_presentation_marshall_selection_max_renown_2_troop", 2),
        (try_end),
        (try_begin),
          (this_or_next|eq, ":object", "$g_presentation_obj_marshall_selection_1"),
          (this_or_next|eq, ":object", "$g_presentation_obj_marshall_selection_2"),
          (eq, ":object", "$g_presentation_obj_marshall_selection_3"),
          (try_begin),
            (ge, "$g_presentation_next_presentation", 0),
            (start_presentation, "$g_presentation_next_presentation"),
          (else_try),
            (try_begin),
              (neg|faction_slot_eq, "$players_kingdom", slot_faction_marshall, "$g_presentation_marshall_selection_max_renown_1_troop"),
              (call_script, "script_check_and_finish_active_army_quests_for_faction", "$players_kingdom"),
            (try_end),

           (faction_get_slot, ":old_marshall", "$players_kingdom", slot_faction_marshall),
           (try_begin),
             (ge, ":old_marshall", 0),
             (party_is_active, ":old_marshall"),
             (party_set_marshall, ":old_marshall", 0),
           (try_end),  

            (faction_set_slot, "$players_kingdom", slot_faction_marshall, "$g_presentation_marshall_selection_max_renown_1_troop"),
            (try_begin),
              (eq, "$g_presentation_marshall_selection_max_renown_1_troop", "trp_player"),
              (call_script, "script_change_player_relation_with_troop", "$g_presentation_marshall_selection_max_renown_2_troop", -3),
            (try_end),
            (assign, "$g_recalculate_ais", 1),
            (assign, "$g_presentation_marshall_selection_ended", 1),
            (presentation_set_duration, 0),
          (try_end),
        (try_end),
        ]),
     ]),
  
  ("battle",0,0,[
      (ti_on_presentation_load,
       [(set_fixed_point_multiplier, 1000),
        (assign, "$g_formation_group0_selected", 0),
        (assign, "$g_formation_group1_selected", 0),
        (assign, "$g_formation_group2_selected", 0),
        (assign, "$g_formation_group3_selected", 0),
        (assign, "$g_formation_group4_selected", 0),
        (assign, "$g_formation_group5_selected", 0),
        (assign, "$g_formation_group6_selected", 0),
        (assign, "$g_formation_group7_selected", 0),
        (assign, "$g_formation_group8_selected", 0),
        (assign, "$g_presentation_obj_battle_but0", -1),
        (assign, "$g_presentation_obj_battle_but1", -1),
        (assign, "$g_presentation_obj_battle_but2", -1),
        (assign, "$g_presentation_obj_battle_but3", -1),
        (assign, "$g_presentation_obj_battle_but4", -1),
        (assign, "$g_presentation_obj_battle_but5", -1),
        (assign, "$g_presentation_obj_battle_but6", -1),
        (assign, "$g_presentation_obj_battle_but7", -1),
        (assign, "$g_presentation_obj_battle_but8", -1),
        (str_clear, s7),

        (try_for_agents, ":agent_no"),
          (agent_set_slot, ":agent_no", slot_agent_map_overlay_id, 0),
        (try_end),

        (get_player_agent_no, ":player_agent"),
        (agent_get_troop_id, ":player_troop_id", ":player_agent"),

        (position_set_y, pos1, 700),
        (create_text_overlay, reg1, "@Action", tf_center_justify|tf_single_line|tf_with_outline),
        (overlay_set_color, reg1, 0xFFAAAAAA),
        (position_set_x, pos1, 270),
        (overlay_set_position, reg1, pos1),
        (create_text_overlay, reg1, "@Mount", tf_center_justify|tf_single_line|tf_with_outline),
        (overlay_set_color, reg1, 0xFFAAAAAA),
        (position_set_x, pos1, 410),
        (overlay_set_position, reg1, pos1),
        (create_text_overlay, reg1, "@Attack Type", tf_center_justify|tf_single_line|tf_with_outline),
        (overlay_set_color, reg1, 0xFFAAAAAA),
        (position_set_x, pos1, 550),
        (overlay_set_position, reg1, pos1),

        (assign, "$group0_has_troops", 0),
        (assign, "$group1_has_troops", 0),
        (assign, "$group2_has_troops", 0),
        (assign, "$group3_has_troops", 0),
        (assign, "$group4_has_troops", 0),
        (assign, "$group5_has_troops", 0),
        (assign, "$group6_has_troops", 0),
        (assign, "$group7_has_troops", 0),
        (assign, "$group8_has_troops", 0),
        (party_get_num_companion_stacks, ":num_stacks", "p_main_party"),
        (assign, "$num_classes", 0),
        (try_for_range, ":troop_iterator", 0, ":num_stacks"),
          (party_stack_get_troop_id, ":cur_troop_id", "p_main_party", ":troop_iterator"),
          (troop_get_class, ":troop_class", ":cur_troop_id"),
          (neq, ":player_troop_id", ":cur_troop_id"),
          (try_begin),
            (eq, ":troop_class", 0),
            (try_begin),
              (neq, "$group0_has_troops", 1),
              (val_add, "$num_classes", 1),
            (try_end),
            (assign, "$group0_has_troops", 1),
          (else_try),
            (eq, ":troop_class", 1),
            (try_begin),
              (neq, "$group1_has_troops", 1),
              (val_add, "$num_classes", 1),
            (try_end),
            (assign, "$group1_has_troops", 1),
          (else_try),
            (eq, ":troop_class", 2),
            (try_begin),
              (neq, "$group2_has_troops", 1),
              (val_add, "$num_classes", 1),
            (try_end),
            (assign, "$group2_has_troops", 1),
          (else_try),
            (eq, ":troop_class", 3),
            (try_begin),
              (neq, "$group3_has_troops", 1),
              (val_add, "$num_classes", 1),
            (try_end),
            (assign, "$group3_has_troops", 1),
          (else_try),
            (eq, ":troop_class", 4),
            (try_begin),
              (neq, "$group4_has_troops", 1),
              (val_add, "$num_classes", 1),
            (try_end),
            (assign, "$group4_has_troops", 1),
          (else_try),
            (eq, ":troop_class", 5),
            (try_begin),
              (neq, "$group5_has_troops", 1),
              (val_add, "$num_classes", 1),
            (try_end),
            (assign, "$group5_has_troops", 1),
          (else_try),
            (eq, ":troop_class", 6),
            (try_begin),
              (neq, "$group6_has_troops", 1),
              (val_add, "$num_classes", 1),
            (try_end),
            (assign, "$group6_has_troops", 1),
          (else_try),
            (eq, ":troop_class", 7),
            (try_begin),
              (neq, "$group7_has_troops", 1),
              (val_add, "$num_classes", 1),
            (try_end),
            (assign, "$group7_has_troops", 1),
          (else_try),
            (eq, ":troop_class", 8),
            (try_begin),
              (neq, "$group8_has_troops", 1),
              (val_add, "$num_classes", 1),
            (try_end),
            (assign, "$group8_has_troops", 1),
          (try_end),
        (try_end),

        (assign, ":stat_position_x", 0),
        (assign, ":stat_position_y", 653),
        (assign, ":stat_position_check_x", 20),
        (assign, ":stat_position_check_y", 662),
        (assign, ":stat_position_name_x", 50),
        (assign, ":stat_position_name_y", 660),
        (try_begin),
          (eq, "$group0_has_troops", 1),
          (create_image_button_overlay, "$g_presentation_obj_battle_but0", "mesh_white_plane", "mesh_white_plane"),
          (position_set_x, pos1, ":stat_position_x"),
          (position_set_y, pos1, ":stat_position_y"),
          (overlay_set_position, "$g_presentation_obj_battle_but0", pos1),
          (val_add, ":stat_position_y", -40),

          (position_set_x, pos1, 32500),
          (position_set_y, pos1, 2000),
          (overlay_set_size, "$g_presentation_obj_battle_but0", pos1),
          (overlay_set_alpha, "$g_presentation_obj_battle_but0", 0),
          (overlay_set_color, "$g_presentation_obj_battle_but0", 0xFFFF00),

          (create_check_box_overlay, "$g_presentation_obj_battle_check0", "mesh_checkbox_off", "mesh_checkbox_on"),
          (position_set_x, pos2, ":stat_position_check_x"),
          (position_set_y, pos2, ":stat_position_check_y"),
          (overlay_set_position, "$g_presentation_obj_battle_check0", pos2),
          (val_add, ":stat_position_check_y", -40),

          (create_text_overlay, "$g_presentation_obj_battle_name0", s7, 0),
          (position_set_x, pos3, ":stat_position_name_x"),
          (position_set_y, pos3, ":stat_position_name_y"),
          (overlay_set_position, "$g_presentation_obj_battle_name0", pos3),
        
          (val_add, ":stat_position_name_y", -40),

          (create_text_overlay, "$g_presentation_but0_movement", s7, tf_center_justify),
          (create_text_overlay, "$g_presentation_but0_riding", s7, tf_center_justify),
          (create_text_overlay, "$g_presentation_but0_weapon_usage", s7, tf_center_justify),
        (try_end),
        (try_begin),
          (eq, "$group1_has_troops", 1),
          (create_image_button_overlay, "$g_presentation_obj_battle_but1", "mesh_white_plane", "mesh_white_plane"),
          (position_set_x, pos1, ":stat_position_x"),
          (position_set_y, pos1, ":stat_position_y"),
          (overlay_set_position, "$g_presentation_obj_battle_but1", pos1),
          (val_add, ":stat_position_y", -40),

          (position_set_x, pos1, 32500),
          (position_set_y, pos1, 2000),
          (overlay_set_size, "$g_presentation_obj_battle_but1", pos1),
          (overlay_set_alpha, "$g_presentation_obj_battle_but1", 0),
          (overlay_set_color, "$g_presentation_obj_battle_but1", 0xFFFF00),

          (create_check_box_overlay, "$g_presentation_obj_battle_check1", "mesh_checkbox_off", "mesh_checkbox_on"),
          (position_set_x, pos2, ":stat_position_check_x"),
          (position_set_y, pos2, ":stat_position_check_y"),
          (overlay_set_position, "$g_presentation_obj_battle_check1", pos2),
          (val_add, ":stat_position_check_y", -40),        

          (create_text_overlay, "$g_presentation_obj_battle_name1", s7, 0),
          (position_set_x, pos3, ":stat_position_name_x"),
          (position_set_y, pos3, ":stat_position_name_y"),
          (overlay_set_position, "$g_presentation_obj_battle_name1", pos3),
          (val_add, ":stat_position_name_y", -40),

          (create_text_overlay, "$g_presentation_but1_movement", s7, tf_center_justify),
          (create_text_overlay, "$g_presentation_but1_riding", s7, tf_center_justify),
          (create_text_overlay, "$g_presentation_but1_weapon_usage", s7, tf_center_justify),
        (try_end),
        (try_begin),
          (eq, "$group2_has_troops", 1),
          (create_image_button_overlay, "$g_presentation_obj_battle_but2", "mesh_white_plane", "mesh_white_plane"),
          (position_set_x, pos1, ":stat_position_x"),
          (position_set_y, pos1, ":stat_position_y"),
          (overlay_set_position, "$g_presentation_obj_battle_but2", pos1),
          (val_add, ":stat_position_y", -40),

          (position_set_x, pos1, 32500),
          (position_set_y, pos1, 2000),
          (overlay_set_size, "$g_presentation_obj_battle_but2", pos1),
          (overlay_set_alpha, "$g_presentation_obj_battle_but2", 0),
          (overlay_set_color, "$g_presentation_obj_battle_but2", 0xFFFF00),

          (create_check_box_overlay, "$g_presentation_obj_battle_check2", "mesh_checkbox_off", "mesh_checkbox_on"),          
          (position_set_x, pos2, ":stat_position_check_x"),
          (position_set_y, pos2, ":stat_position_check_y"),
          (overlay_set_position, "$g_presentation_obj_battle_check2", pos2),
          (val_add, ":stat_position_check_y", -40),        

          (create_text_overlay, "$g_presentation_obj_battle_name2", s7, 0),
          (position_set_x, pos3, ":stat_position_name_x"),
          (position_set_y, pos3, ":stat_position_name_y"),
          (overlay_set_position, "$g_presentation_obj_battle_name2", pos3),
          (val_add, ":stat_position_name_y", -40),

          (create_text_overlay, "$g_presentation_but2_movement", s7, tf_center_justify),
          (create_text_overlay, "$g_presentation_but2_riding", s7, tf_center_justify),
          (create_text_overlay, "$g_presentation_but2_weapon_usage", s7, tf_center_justify),
        (try_end),
        (try_begin),
          (eq, "$group3_has_troops", 1),
          (create_image_button_overlay, "$g_presentation_obj_battle_but3", "mesh_white_plane", "mesh_white_plane"),
          (position_set_x, pos1, ":stat_position_x"),
          (position_set_y, pos1, ":stat_position_y"),
          (overlay_set_position, "$g_presentation_obj_battle_but3", pos1),
          (val_add, ":stat_position_y", -40),

          (position_set_x, pos1, 32500),
          (position_set_y, pos1, 2000),
          (overlay_set_size, "$g_presentation_obj_battle_but3", pos1),
          (overlay_set_alpha, "$g_presentation_obj_battle_but3", 0),
          (overlay_set_color, "$g_presentation_obj_battle_but3", 0xFFFF00),

          (create_check_box_overlay, "$g_presentation_obj_battle_check3", "mesh_checkbox_off", "mesh_checkbox_on"),          
          (position_set_x, pos2, ":stat_position_check_x"),
          (position_set_y, pos2, ":stat_position_check_y"),
          (overlay_set_position, "$g_presentation_obj_battle_check3", pos2),
          (val_add, ":stat_position_check_y", -40),        

          (create_text_overlay, "$g_presentation_obj_battle_name3", s7, 0),
          (position_set_x, pos3, ":stat_position_name_x"),
          (position_set_y, pos3, ":stat_position_name_y"),
          (overlay_set_position, "$g_presentation_obj_battle_name3", pos3),
          (val_add, ":stat_position_name_y", -40),

          (create_text_overlay, "$g_presentation_but3_movement", s7, tf_center_justify),
          (create_text_overlay, "$g_presentation_but3_riding", s7, tf_center_justify),
          (create_text_overlay, "$g_presentation_but3_weapon_usage", s7, tf_center_justify),
        (try_end),
        (try_begin),
          (eq, "$group4_has_troops", 1),
          (create_image_button_overlay, "$g_presentation_obj_battle_but4", "mesh_white_plane", "mesh_white_plane"),
          (position_set_x, pos1, ":stat_position_x"),
          (position_set_y, pos1, ":stat_position_y"),
          (overlay_set_position, "$g_presentation_obj_battle_but4", pos1),
          (val_add, ":stat_position_y", -40),

          (position_set_x, pos1, 32500),
          (position_set_y, pos1, 2000),
          (overlay_set_size, "$g_presentation_obj_battle_but4", pos1),
          (overlay_set_alpha, "$g_presentation_obj_battle_but4", 0),
          (overlay_set_color, "$g_presentation_obj_battle_but4", 0xFFFF00),

          (create_check_box_overlay, "$g_presentation_obj_battle_check4", "mesh_checkbox_off", "mesh_checkbox_on"),          
          (position_set_x, pos2, ":stat_position_check_x"),
          (position_set_y, pos2, ":stat_position_check_y"),
          (overlay_set_position, "$g_presentation_obj_battle_check4", pos2),
          (val_add, ":stat_position_check_y", -40),        

          (create_text_overlay, "$g_presentation_obj_battle_name4", s7, 0),
          (position_set_x, pos3, ":stat_position_name_x"),
          (position_set_y, pos3, ":stat_position_name_y"),
          (overlay_set_position, "$g_presentation_obj_battle_name4", pos3),
          (val_add, ":stat_position_name_y", -40),
        
          (create_text_overlay, "$g_presentation_but4_movement", s7, tf_center_justify),
          (create_text_overlay, "$g_presentation_but4_riding", s7, tf_center_justify),
          (create_text_overlay, "$g_presentation_but4_weapon_usage", s7, tf_center_justify),
        (try_end),
        (try_begin),
          (eq, "$group5_has_troops", 1),
          (create_image_button_overlay, "$g_presentation_obj_battle_but5", "mesh_white_plane", "mesh_white_plane"),
          (position_set_x, pos1, ":stat_position_x"),
          (position_set_y, pos1, ":stat_position_y"),
          (overlay_set_position, "$g_presentation_obj_battle_but5", pos1),
          (val_add, ":stat_position_y", -40),

          (position_set_x, pos1, 32500),
          (position_set_y, pos1, 2000),
          (overlay_set_size, "$g_presentation_obj_battle_but5", pos1),
          (overlay_set_alpha, "$g_presentation_obj_battle_but5", 0),
          (overlay_set_color, "$g_presentation_obj_battle_but5", 0xFFFF00),

          (create_check_box_overlay, "$g_presentation_obj_battle_check5", "mesh_checkbox_off", "mesh_checkbox_on"),          
          (position_set_x, pos2, ":stat_position_check_x"),
          (position_set_y, pos2, ":stat_position_check_y"),
          (overlay_set_position, "$g_presentation_obj_battle_check5", pos2),
          (val_add, ":stat_position_check_y", -40),        

          (create_text_overlay, "$g_presentation_obj_battle_name5", s7, 0),
          (position_set_x, pos3, ":stat_position_name_x"),
          (position_set_y, pos3, ":stat_position_name_y"),
          (overlay_set_position, "$g_presentation_obj_battle_name5", pos3),
          (val_add, ":stat_position_name_y", -40),

          (create_text_overlay, "$g_presentation_but5_movement", s7, tf_center_justify),
          (create_text_overlay, "$g_presentation_but5_riding", s7, tf_center_justify),
          (create_text_overlay, "$g_presentation_but5_weapon_usage", s7, tf_center_justify),
        (try_end),
        (try_begin),
          (eq, "$group6_has_troops", 1),
          (create_image_button_overlay, "$g_presentation_obj_battle_but6", "mesh_white_plane", "mesh_white_plane"),
          (position_set_x, pos1, ":stat_position_x"),
          (position_set_y, pos1, ":stat_position_y"),
          (overlay_set_position, "$g_presentation_obj_battle_but6", pos1),
          (val_add, ":stat_position_y", -40),

          (position_set_x, pos1, 32500),
          (position_set_y, pos1, 2000),
          (overlay_set_size, "$g_presentation_obj_battle_but6", pos1),
          (overlay_set_alpha, "$g_presentation_obj_battle_but6", 0),
          (overlay_set_color, "$g_presentation_obj_battle_but6", 0xFFFF00),

          (create_check_box_overlay, "$g_presentation_obj_battle_check6", "mesh_checkbox_off", "mesh_checkbox_on"),          
          (position_set_x, pos2, ":stat_position_check_x"),
          (position_set_y, pos2, ":stat_position_check_y"),
          (overlay_set_position, "$g_presentation_obj_battle_check6", pos2),
          (val_add, ":stat_position_check_y", -40),        

          (create_text_overlay, "$g_presentation_obj_battle_name6", s7, 0),
          (position_set_x, pos3, ":stat_position_name_x"),
          (position_set_y, pos3, ":stat_position_name_y"),
          (overlay_set_position, "$g_presentation_obj_battle_name6", pos3),
          (val_add, ":stat_position_name_y", -40),

          (create_text_overlay, "$g_presentation_but6_movement", s7, tf_center_justify),
          (create_text_overlay, "$g_presentation_but6_riding", s7, tf_center_justify),
          (create_text_overlay, "$g_presentation_but6_weapon_usage", s7, tf_center_justify),
        (try_end),
        (try_begin),
          (eq, "$group7_has_troops", 1),
          (create_image_button_overlay, "$g_presentation_obj_battle_but7", "mesh_white_plane", "mesh_white_plane"),
          (position_set_x, pos1, ":stat_position_x"),
          (position_set_y, pos1, ":stat_position_y"),
          (overlay_set_position, "$g_presentation_obj_battle_but7", pos1),
          (val_add, ":stat_position_y", -40),

          (position_set_x, pos1, 32500),
          (position_set_y, pos1, 2000),
          (overlay_set_size, "$g_presentation_obj_battle_but7", pos1),
          (overlay_set_alpha, "$g_presentation_obj_battle_but7", 0),
          (overlay_set_color, "$g_presentation_obj_battle_but7", 0xFFFF00),

          (create_check_box_overlay, "$g_presentation_obj_battle_check7", "mesh_checkbox_off", "mesh_checkbox_on"),          
          (position_set_x, pos2, ":stat_position_check_x"),
          (position_set_y, pos2, ":stat_position_check_y"),
          (overlay_set_position, "$g_presentation_obj_battle_check7", pos2),
          (val_add, ":stat_position_check_y", -40),        

          (create_text_overlay, "$g_presentation_obj_battle_name7", s7, 0),
          (position_set_x, pos3, ":stat_position_name_x"),
          (position_set_y, pos3, ":stat_position_name_y"),
          (overlay_set_position, "$g_presentation_obj_battle_name7", pos3),
          (val_add, ":stat_position_name_y", -40),

          (create_text_overlay, "$g_presentation_but7_movement", s7, tf_center_justify),
          (create_text_overlay, "$g_presentation_but7_riding", s7, tf_center_justify),
          (create_text_overlay, "$g_presentation_but7_weapon_usage", s7, tf_center_justify),
        (try_end),
        (try_begin),
          (eq, "$group8_has_troops", 1),
          (create_image_button_overlay, "$g_presentation_obj_battle_but8", "mesh_white_plane", "mesh_white_plane"),
          (position_set_x, pos1, ":stat_position_x"),
          (position_set_y, pos1, ":stat_position_y"),
          (overlay_set_position, "$g_presentation_obj_battle_but8", pos1),
          (val_add, ":stat_position_y", -40),

          (position_set_x, pos1, 32500),
          (position_set_y, pos1, 2000),
          (overlay_set_size, "$g_presentation_obj_battle_but8", pos1),
          (overlay_set_alpha, "$g_presentation_obj_battle_but8", 0),
          (overlay_set_color, "$g_presentation_obj_battle_but8", 0xFFFF00),

          (create_check_box_overlay, "$g_presentation_obj_battle_check8", "mesh_checkbox_off", "mesh_checkbox_on"),          
          (position_set_x, pos2, ":stat_position_check_x"),
          (position_set_y, pos2, ":stat_position_check_y"),
          (overlay_set_position, "$g_presentation_obj_battle_check8", pos2),
          (val_add, ":stat_position_check_y", -40),        

          (create_text_overlay, "$g_presentation_obj_battle_name8", s7, 0),
          (position_set_x, pos3, ":stat_position_name_x"),
          (position_set_y, pos3, ":stat_position_name_y"),
          (overlay_set_position, "$g_presentation_obj_battle_name8", pos3),
          (val_add, ":stat_position_name_y", -40),

          (create_text_overlay, "$g_presentation_but8_movement", s7, tf_center_justify),
          (create_text_overlay, "$g_presentation_but8_riding", s7, tf_center_justify),
          (create_text_overlay, "$g_presentation_but8_weapon_usage", s7, tf_center_justify),
        (try_end),
        
        (get_player_agent_no, ":player_agent"),
        (agent_get_team, ":player_team", ":player_agent"),
        
        (call_script, "script_update_order_panel", ":player_team"),

        #(create_button_overlay, "$g_presentation_obj_battle_10", "@Hold This Position", tf_center_justify),
        #(create_button_overlay, "$g_presentation_obj_battle_11", "@Follow Me", tf_center_justify),
        #(create_button_overlay, "$g_presentation_obj_battle_12", "@Charge", tf_center_justify),
        #(create_button_overlay, "$g_presentation_obj_battle_13", "@Advance", tf_center_justify),
        #(create_button_overlay, "$g_presentation_obj_battle_14", "@Fall Back", tf_center_justify),
        #(create_button_overlay, "$g_presentation_obj_battle_15", "@Stand Closer", tf_center_justify),
        #(create_button_overlay, "$g_presentation_obj_battle_16", "@Spread Out", tf_center_justify),
        #(create_button_overlay, "$g_presentation_obj_battle_17", "@Stand Ground", tf_center_justify),
        #(create_button_overlay, "$g_presentation_obj_battle_18", "@Mount", tf_center_justify),
        #(create_button_overlay, "$g_presentation_obj_battle_19", "@Dismount", tf_center_justify),
        #(create_button_overlay, "$g_presentation_obj_battle_20", "@Use Any Weapon", tf_center_justify),
        #(create_button_overlay, "$g_presentation_obj_battle_21", "@Use Blunt Weapons", tf_center_justify),
        #(create_button_overlay, "$g_presentation_obj_battle_28", "@Hold Your Fire", tf_center_justify),
        #(create_button_overlay, "$g_presentation_obj_battle_29", "@Fire At Will", tf_center_justify),
        
        (assign, ":y_position_for_order_buttons", 640),
        (assign, ":addition_y_position", "$num_classes"),
        (val_mul, ":addition_y_position", -40),
        (val_add, ":y_position_for_order_buttons", ":addition_y_position"),

        (create_listbox_overlay, "$g_presentation_obj_battle_10", "str_space", 0),
        (create_listbox_overlay, "$g_presentation_obj_battle_11", "str_space", 0),
        (create_listbox_overlay, "$g_presentation_obj_battle_12", "str_space", 0),
        (create_listbox_overlay, "$g_presentation_obj_battle_13", "str_space", 0),
        
        (overlay_add_item, "$g_presentation_obj_battle_10", "@Stand Ground"),
        ##(overlay_add_item, "$g_presentation_obj_battle_10", "@Spread Out"),
        ##(overlay_add_item, "$g_presentation_obj_battle_10", "@Stand Closer"),
        ##(overlay_add_item, "$g_presentation_obj_battle_10", "@Fall Back"),
        ##(overlay_add_item, "$g_presentation_obj_battle_10", "@Advance"),
        (overlay_add_item, "$g_presentation_obj_battle_10", "@Charge"),
        (overlay_add_item, "$g_presentation_obj_battle_10", "@Follow Me"),
        (overlay_add_item, "$g_presentation_obj_battle_10", "@Hold This Position"),

        (create_button_overlay, "$g_presentation_obj_battle_14", "@Spread Out", tf_center_justify|tf_single_line|tf_with_outline),
        (overlay_set_color, "$g_presentation_obj_battle_14", 0xFFFFFFFF),
        (create_button_overlay, "$g_presentation_obj_battle_15", "@Stand Closer", tf_center_justify|tf_single_line|tf_with_outline),
        (overlay_set_color, "$g_presentation_obj_battle_15", 0xFFFFFFFF),
        (create_button_overlay, "$g_presentation_obj_battle_16", "@Fall Back", tf_center_justify|tf_single_line|tf_with_outline),
        (overlay_set_color, "$g_presentation_obj_battle_16", 0xFFFFFFFF),
        (create_button_overlay, "$g_presentation_obj_battle_17", "@Advance", tf_center_justify|tf_single_line|tf_with_outline),
        (overlay_set_color, "$g_presentation_obj_battle_17", 0xFFFFFFFF),
        
        (position_set_x, pos1, 600),
        (position_set_y, pos1, 600),
        (overlay_set_size, "$g_presentation_obj_battle_10", pos1),

        (val_add, ":y_position_for_order_buttons", -35),
        (position_set_x, pos1, 205),
        (position_set_y, pos1, ":y_position_for_order_buttons"),
        (val_add, ":y_position_for_order_buttons", 35),
        (overlay_set_position, "$g_presentation_obj_battle_10", pos1),
        (overlay_set_alpha, "$g_presentation_obj_battle_10", 0x60),
        (overlay_set_val, "$g_presentation_obj_battle_10", "$g_latest_order_1"),

        (val_add, ":y_position_for_order_buttons", -40), #new
        (position_set_x, pos1, 130), #new
        (position_set_y, pos1, ":y_position_for_order_buttons"), #new
        (val_add, ":y_position_for_order_buttons", 40), #new
        (overlay_set_position, "$g_presentation_obj_battle_14", pos1), #new
        #(overlay_set_alpha, "$g_presentation_obj_battle_14", 0x60), #new

        (val_add, ":y_position_for_order_buttons", -20), #new
        (position_set_x, pos1, 130), #new
        (position_set_y, pos1, ":y_position_for_order_buttons"), #new
        (val_add, ":y_position_for_order_buttons", 20), #new
        (overlay_set_position, "$g_presentation_obj_battle_15", pos1), #new
        #(overlay_set_alpha, "$g_presentation_obj_battle_15", 0x60), #new

        (val_add, ":y_position_for_order_buttons", -0), #new
        (position_set_x, pos1, 130), #new
        (position_set_y, pos1, ":y_position_for_order_buttons"), #new
        (val_add, ":y_position_for_order_buttons", 0), #new
        (overlay_set_position, "$g_presentation_obj_battle_16", pos1), #new
        #(overlay_set_alpha, "$g_presentation_obj_battle_16", 0x60), #new

        (val_add, ":y_position_for_order_buttons", 20), #new
        (position_set_x, pos1, 130), #new
        (position_set_y, pos1, ":y_position_for_order_buttons"), #new
        (val_add, ":y_position_for_order_buttons", -20), #new
        (overlay_set_position, "$g_presentation_obj_battle_17", pos1), #new
        #(overlay_set_alpha, "$g_presentation_obj_battle_17", 0x60), #new



        (overlay_add_item, "$g_presentation_obj_battle_11", "@Dismount"),
        (overlay_add_item, "$g_presentation_obj_battle_11", "@Mount"),
        
        (position_set_x, pos1, 600),
        (position_set_y, pos1, 600),
        (overlay_set_size, "$g_presentation_obj_battle_11", pos1),

        (position_set_x, pos1, 350),
        (position_set_y, pos1, ":y_position_for_order_buttons"),
        (overlay_set_position, "$g_presentation_obj_battle_11", pos1),

        (overlay_set_alpha, "$g_presentation_obj_battle_11", 0x60),
        (overlay_set_val, "$g_presentation_obj_battle_11", "$g_latest_order_2"),



        (overlay_add_item, "$g_presentation_obj_battle_12", "@Fire At Will"),
        (overlay_add_item, "$g_presentation_obj_battle_12", "@Hold Your Fire"),
        
        (position_set_x, pos1, 600),
        (position_set_y, pos1, 600),
        (overlay_set_size, "$g_presentation_obj_battle_12", pos1),

        (position_set_x, pos1, 495),
        (position_set_y, pos1, ":y_position_for_order_buttons"),
        (overlay_set_position, "$g_presentation_obj_battle_12", pos1),

        (overlay_set_alpha, "$g_presentation_obj_battle_12", 0x60),
        (overlay_set_val, "$g_presentation_obj_battle_12", "$g_latest_order_3"),



        (overlay_add_item, "$g_presentation_obj_battle_13", "@Use Blunt Weapons"),
        (overlay_add_item, "$g_presentation_obj_battle_13", "@Use Any Weapon"),
        
        (position_set_x, pos1, 600),
        (position_set_y, pos1, 600),
        (overlay_set_size, "$g_presentation_obj_battle_13", pos1),

        (val_add, ":y_position_for_order_buttons", -35),
        (position_set_x, pos1, 495),
        (position_set_y, pos1, ":y_position_for_order_buttons"),
        (val_add, ":y_position_for_order_buttons", 35),
        (overlay_set_position, "$g_presentation_obj_battle_13", pos1),

        (overlay_set_alpha, "$g_presentation_obj_battle_13", 0x60),
        (overlay_set_val, "$g_presentation_obj_battle_13", "$g_latest_order_4"),



        (create_text_overlay, "$g_presentation_obj_battle_22", "str_us_", 0),
        (create_text_overlay, "$g_presentation_obj_battle_23", "str_allies_", 0),
        (create_text_overlay, "$g_presentation_obj_battle_24", "str_enemies_", 0),
        (create_text_overlay, "$g_presentation_obj_battle_25", "@Ready", tf_center_justify),
        (create_text_overlay, "$g_presentation_obj_battle_26", "@Wounded", tf_center_justify),
        (create_text_overlay, "$g_presentation_obj_battle_28", "str_routed", tf_center_justify),
        (create_text_overlay, "$g_presentation_obj_battle_27", "@Dead", tf_center_justify),

        (create_text_overlay, "$g_battle_us_ready", s7, tf_center_justify),
        (create_text_overlay, "$g_battle_us_wounded", s7, tf_center_justify),
        (create_text_overlay, "$g_battle_us_routed", s7, tf_center_justify),
        (create_text_overlay, "$g_battle_us_dead", s7, tf_center_justify),
        
        (create_text_overlay, "$g_battle_enemies_ready", s7, tf_center_justify),
        (create_text_overlay, "$g_battle_enemies_wounded", s7, tf_center_justify),
        (create_text_overlay, "$g_battle_enemies_routed", s7, tf_center_justify),
        (create_text_overlay, "$g_battle_enemies_dead", s7, tf_center_justify),

        (create_text_overlay, "$g_battle_allies_ready", s7, tf_center_justify),
        (create_text_overlay, "$g_battle_allies_wounded", s7, tf_center_justify),
        (create_text_overlay, "$g_battle_allies_routed", s7, tf_center_justify),
        (create_text_overlay, "$g_battle_allies_dead", s7, tf_center_justify),


        (create_image_button_overlay, "$g_battle_report_plane", "mesh_white_plane", "mesh_white_plane"),
        (overlay_set_color, "$g_battle_report_plane", 0),
        (position_set_x, pos1, 15500),
        (position_set_y, pos1, 6000),
        (overlay_set_size, "$g_battle_report_plane", pos1),
        (position_set_x, pos1, 672),
        (position_set_y, pos1, 275),
        (overlay_set_position, "$g_battle_report_plane", pos1),
        (overlay_set_alpha, "$g_battle_report_plane", 0x44),
        (overlay_set_color, "$g_battle_report_plane", 0x1166BB),


        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),

        (overlay_set_size, "$g_presentation_obj_battle_14", pos1), #new
        (overlay_set_size, "$g_presentation_obj_battle_15", pos1), #new
        (overlay_set_size, "$g_presentation_obj_battle_16", pos1), #new
        (overlay_set_size, "$g_presentation_obj_battle_17", pos1), #new

        (overlay_set_size, "$g_presentation_obj_battle_22", pos1),
        (overlay_set_size, "$g_presentation_obj_battle_23", pos1),
        (overlay_set_size, "$g_presentation_obj_battle_24", pos1),
        (overlay_set_size, "$g_presentation_obj_battle_25", pos1),
        (overlay_set_size, "$g_presentation_obj_battle_26", pos1),
        (overlay_set_size, "$g_presentation_obj_battle_27", pos1),
        (overlay_set_size, "$g_presentation_obj_battle_28", pos1),
        (overlay_set_size, "$g_battle_us_ready", pos1),
        (overlay_set_size, "$g_battle_us_wounded", pos1),
        (overlay_set_size, "$g_battle_us_routed", pos1),
        (overlay_set_size, "$g_battle_us_dead", pos1),
        (overlay_set_size, "$g_battle_enemies_ready", pos1),
        (overlay_set_size, "$g_battle_enemies_wounded", pos1),
        (overlay_set_size, "$g_battle_enemies_routed", pos1),
        (overlay_set_size, "$g_battle_enemies_dead", pos1),
        (overlay_set_size, "$g_battle_allies_ready", pos1),        
        (overlay_set_size, "$g_battle_allies_wounded", pos1),
        (overlay_set_size, "$g_battle_allies_routed", pos1),
        (overlay_set_size, "$g_battle_allies_dead", pos1),

        (assign, ":stat_position_x", 675),
        (assign, ":stat_position_y", 280),

        (val_add, ":stat_position_x", 70),
        (val_add, ":stat_position_y", 90),
        (position_set_x, pos1, ":stat_position_x"),
        (position_set_y, pos1, ":stat_position_y"),
        (overlay_set_position, "$g_presentation_obj_battle_25", pos1),
        (val_add, ":stat_position_x", 70),
        (position_set_x, pos1, ":stat_position_x"),
        (overlay_set_position, "$g_presentation_obj_battle_26", pos1),
        (val_add, ":stat_position_x", 70),
        (position_set_x, pos1, ":stat_position_x"),
        (overlay_set_position, "$g_presentation_obj_battle_28", pos1),
        (val_add, ":stat_position_x", 70),
        (position_set_x, pos1, ":stat_position_x"),
        (overlay_set_position, "$g_presentation_obj_battle_27", pos1),

        (val_add, ":stat_position_x", -280),
        (val_add, ":stat_position_y", -30),
        (position_set_x, pos1, ":stat_position_x"),
        (position_set_y, pos1, ":stat_position_y"),
        (overlay_set_position, "$g_presentation_obj_battle_22", pos1),
        (val_add, ":stat_position_y", -30),
        (position_set_y, pos1, ":stat_position_y"),
        (overlay_set_position, "$g_presentation_obj_battle_23", pos1),
        (val_add, ":stat_position_y", -30),
        (position_set_y, pos1, ":stat_position_y"),
        (overlay_set_position, "$g_presentation_obj_battle_24", pos1),

        (get_scene_boundaries, pos2, pos3),
        (position_transform_position_to_local, pos4, pos2, pos3),
        (set_fixed_point_multiplier, 1000),
        (position_get_x, ":map_width", pos4),
        (position_get_y, ":map_height", pos4),
        (set_fixed_point_multiplier, 1000),
        (store_div, ":map_ratio", ":map_height", 100),
        (store_div, ":map_ratio", ":map_width", ":map_ratio"),
        (try_begin),
          (gt, ":map_ratio", 100),
          (assign, "$g_battle_map_width", 300),
          (store_div, "$g_battle_map_scale", ":map_width", "$g_battle_map_width"),
          (store_div, "$g_battle_map_height", ":map_height", "$g_battle_map_scale"),
        (else_try),
          (assign, "$g_battle_map_height", 300),
          (store_div, "$g_battle_map_scale", ":map_height", "$g_battle_map_height"),
          (store_div, "$g_battle_map_width", ":map_width", "$g_battle_map_scale"),
        (try_end),
        
        (create_image_button_overlay, "$g_battle_map_plane", "mesh_white_plane", "mesh_white_plane"),
        (overlay_set_color, "$g_battle_map_plane", 0),
        (store_add, ":map_bordered_width", "$g_battle_map_width", 20),
        (store_add, ":map_bordered_height", "$g_battle_map_height", 20),
        (store_mul, ":map_scale_x", ":map_bordered_width", 50),
        (store_mul, ":map_scale_y", ":map_bordered_height", 50),
        (position_set_x, pos1, ":map_scale_x"),
        (position_set_y, pos1, ":map_scale_y"),
        (overlay_set_size, "$g_battle_map_plane", pos1),
        (store_sub, ":map_pos_x", 990, ":map_bordered_width"),
        (store_sub, ":map_pos_y", 740, ":map_bordered_height"),
        (position_set_x, pos1, ":map_pos_x"),
        (position_set_y, pos1, ":map_pos_y"),
        (overlay_set_position, "$g_battle_map_plane", pos1),
        (overlay_set_alpha, "$g_battle_map_plane", 0x44),

        (create_mesh_overlay, "$g_battle_map_infantry_order_flag", "mesh_flag_infantry"),
        (create_mesh_overlay, "$g_battle_map_archers_order_flag", "mesh_flag_archers"),
        (create_mesh_overlay, "$g_battle_map_cavalry_order_flag", "mesh_flag_cavalry"),
        (overlay_set_alpha, "$g_battle_map_infantry_order_flag", 0),
        (overlay_set_alpha, "$g_battle_map_archers_order_flag", 0),
        (overlay_set_alpha, "$g_battle_map_cavalry_order_flag", 0),

        (call_script, "script_update_order_panel_checked_classes"),
        (call_script, "script_update_order_panel_statistics_and_map"),

        (presentation_set_duration, 999999),
        ]),
      (ti_on_presentation_event_state_change,
       [(store_trigger_param_1, ":object"),
        (store_trigger_param_2, ":value"),
        (get_player_agent_no, ":player_agent"),
        (agent_get_team, ":player_team", ":player_agent"),

        (assign, ":update_listeners", 0),
        (try_begin),
          (eq, "$group0_has_troops", 1),
          (eq, ":object", "$g_presentation_obj_battle_check0"),
          (assign, ":update_listeners", 1),
          (assign, "$g_formation_group0_selected", ":value"),
          (try_begin),
            (eq, ":value", 1),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but0", 250, 0x44),
          (else_try),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but0", 250, 0),
          (try_end),
        (else_try),
          (eq, "$group1_has_troops", 1),
          (eq, ":object", "$g_presentation_obj_battle_check1"),
          (assign, ":update_listeners", 1),
          (assign, "$g_formation_group1_selected", ":value"),
          (try_begin),
            (eq, ":value", 1),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but1", 250, 0x44),
          (else_try),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but1", 250, 0),
          (try_end),
        (else_try),
          (eq, "$group2_has_troops", 1),
          (eq, ":object", "$g_presentation_obj_battle_check2"),
          (assign, ":update_listeners", 1),
          (assign, "$g_formation_group2_selected", ":value"),
          (try_begin),
            (eq, ":value", 1),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but2", 250, 0x44),
          (else_try),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but2", 250, 0),
          (try_end),
        (else_try),
          (eq, "$group3_has_troops", 1),
          (eq, ":object", "$g_presentation_obj_battle_check3"),
          (assign, ":update_listeners", 1),
          (assign, "$g_formation_group3_selected", ":value"),
          (try_begin),
            (eq, ":value", 1),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but3", 250, 0x44),
          (else_try),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but3", 250, 0),
          (try_end),
        (else_try),
          (eq, "$group4_has_troops", 1),
          (eq, ":object", "$g_presentation_obj_battle_check4"),
          (assign, ":update_listeners", 1),
          (assign, "$g_formation_group4_selected", ":value"),
          (try_begin),
            (eq, ":value", 1),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but4", 250, 0x44),
          (else_try),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but4", 250, 0),
          (try_end),
        (else_try),
          (eq, "$group5_has_troops", 1),
          (eq, ":object", "$g_presentation_obj_battle_check5"),
          (assign, ":update_listeners", 1),
          (assign, "$g_formation_group5_selected", ":value"),
          (try_begin),
            (eq, ":value", 1),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but5", 250, 0x44),
          (else_try),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but5", 250, 0),
          (try_end),
        (else_try),
          (eq, "$group6_has_troops", 1),
          (eq, ":object", "$g_presentation_obj_battle_check6"),
          (assign, ":update_listeners", 1),
          (assign, "$g_formation_group6_selected", ":value"),
          (try_begin),
            (eq, ":value", 1),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but6", 250, 0x44),
          (else_try),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but6", 250, 0),
          (try_end),
        (else_try),
          (eq, "$group7_has_troops", 1),
          (eq, ":object", "$g_presentation_obj_battle_check7"),
          (assign, ":update_listeners", 1),
          (assign, "$g_formation_group7_selected", ":value"),
          (try_begin),
            (eq, ":value", 1),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but7", 250, 0x44),
          (else_try),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but7", 250, 0),
          (try_end),
        (else_try),
          (eq, "$group8_has_troops", 1),
          (eq, ":object", "$g_presentation_obj_battle_check8"),
          (assign, ":update_listeners", 1),
          (assign, "$g_formation_group8_selected", ":value"),
          (try_begin),
            (eq, ":value", 1),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but8", 250, 0x44),
          (else_try),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but8", 250, 0),
          (try_end),        
        (else_try),
          (eq, ":object", "$g_presentation_obj_battle_but0"),
          (assign, ":update_listeners", 1),
        
          (assign, "$g_formation_group0_selected", 1),
          (overlay_animate_to_alpha, "$g_presentation_obj_battle_but0", 250, 0x44),
          (overlay_set_val, "$g_presentation_obj_battle_check0", 1),

          (try_begin),
            (eq, "$group1_has_troops", 1),
            (assign, "$g_formation_group1_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check1", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but1", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group2_has_troops", 1),
            (assign, "$g_formation_group2_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check2", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but2", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group3_has_troops", 1),
            (assign, "$g_formation_group3_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check3", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but3", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group4_has_troops", 1),
            (assign, "$g_formation_group4_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check4", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but4", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group5_has_troops", 1),
            (assign, "$g_formation_group5_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check5", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but5", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group6_has_troops", 1),
            (assign, "$g_formation_group6_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check6", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but6", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group7_has_troops", 1),
            (assign, "$g_formation_group7_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check7", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but7", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group8_has_troops", 1),
            (assign, "$g_formation_group8_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check8", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but8", 250, 0),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_battle_but1"),
          (assign, ":update_listeners", 1),

          (assign, "$g_formation_group1_selected", 1),
          (overlay_animate_to_alpha, "$g_presentation_obj_battle_but1", 250, 0x44),
          (overlay_set_val, "$g_presentation_obj_battle_check1", 1),

          (try_begin),
            (eq, "$group0_has_troops", 1),
            (assign, "$g_formation_group0_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check0", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but0", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group2_has_troops", 1),
            (assign, "$g_formation_group2_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check2", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but2", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group3_has_troops", 1),
            (assign, "$g_formation_group3_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check3", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but3", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group4_has_troops", 1),
            (assign, "$g_formation_group4_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check4", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but4", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group5_has_troops", 1),
            (assign, "$g_formation_group5_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check5", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but5", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group6_has_troops", 1),
            (assign, "$g_formation_group6_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check6", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but6", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group7_has_troops", 1),
            (assign, "$g_formation_group7_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check7", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but7", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group8_has_troops", 1),
            (assign, "$g_formation_group8_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check8", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but8", 250, 0),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_battle_but2"),
          (assign, ":update_listeners", 1),

          (assign, "$g_formation_group2_selected", 1),
          (overlay_animate_to_alpha, "$g_presentation_obj_battle_but2", 250, 0x44),
          (overlay_set_val, "$g_presentation_obj_battle_check2", 1),

          (try_begin),
            (eq, "$group0_has_troops", 1),
            (assign, "$g_formation_group0_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check0", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but0", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group1_has_troops", 1),
            (assign, "$g_formation_group1_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check1", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but1", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group3_has_troops", 1),
            (assign, "$g_formation_group3_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check3", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but3", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group4_has_troops", 1),
            (assign, "$g_formation_group4_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check4", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but4", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group5_has_troops", 1),
            (assign, "$g_formation_group5_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check5", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but5", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group6_has_troops", 1),
            (assign, "$g_formation_group6_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check6", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but6", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group7_has_troops", 1),
            (assign, "$g_formation_group7_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check7", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but7", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group8_has_troops", 1),
            (assign, "$g_formation_group8_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check8", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but8", 250, 0),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_battle_but3"),
          (assign, ":update_listeners", 1),

          (assign, "$g_formation_group3_selected", 1),
          (overlay_animate_to_alpha, "$g_presentation_obj_battle_but3", 250, 0x44),
          (overlay_set_val, "$g_presentation_obj_battle_check3", 1),

          (try_begin),
            (eq, "$group0_has_troops", 1),
            (assign, "$g_formation_group0_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check0", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but0", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group1_has_troops", 1),
            (assign, "$g_formation_group1_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check1", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but1", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group2_has_troops", 1),
            (assign, "$g_formation_group2_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check2", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but2", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group4_has_troops", 1),
            (assign, "$g_formation_group4_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check4", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but4", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group5_has_troops", 1),
            (assign, "$g_formation_group5_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check5", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but5", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group6_has_troops", 1),
            (assign, "$g_formation_group6_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check6", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but6", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group7_has_troops", 1),
            (assign, "$g_formation_group7_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check7", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but7", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group8_has_troops", 1),
            (assign, "$g_formation_group8_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check8", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but8", 250, 0),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_battle_but4"),
          (assign, ":update_listeners", 1),

          (assign, "$g_formation_group4_selected", 1),
          (overlay_animate_to_alpha, "$g_presentation_obj_battle_but4", 250, 0x44),
          (overlay_set_val, "$g_presentation_obj_battle_check4", 1),

          (try_begin),
            (eq, "$group0_has_troops", 1),
            (assign, "$g_formation_group0_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check0", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but0", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group1_has_troops", 1),
            (assign, "$g_formation_group1_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check1", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but1", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group2_has_troops", 1),
            (assign, "$g_formation_group2_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check2", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but2", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group3_has_troops", 1),
            (assign, "$g_formation_group3_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check3", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but3", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group5_has_troops", 1),
            (assign, "$g_formation_group5_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check5", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but5", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group6_has_troops", 1),
            (assign, "$g_formation_group6_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check6", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but6", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group7_has_troops", 1),
            (assign, "$g_formation_group7_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check7", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but7", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group8_has_troops", 1),
            (assign, "$g_formation_group8_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check8", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but8", 250, 0),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_battle_but5"),
          (assign, ":update_listeners", 1),

          (assign, "$g_formation_group5_selected", 1),
          (overlay_animate_to_alpha, "$g_presentation_obj_battle_but5", 250, 0x44),
          (overlay_set_val, "$g_presentation_obj_battle_check5", 1),

          (try_begin),
            (eq, "$group0_has_troops", 1),
            (assign, "$g_formation_group0_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check0", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but0", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group1_has_troops", 1),
            (assign, "$g_formation_group1_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check1", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but1", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group2_has_troops", 1),
            (assign, "$g_formation_group2_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check2", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but2", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group3_has_troops", 1),
            (assign, "$g_formation_group3_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check3", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but3", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group4_has_troops", 1),
            (assign, "$g_formation_group4_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check4", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but4", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group6_has_troops", 1),
            (assign, "$g_formation_group6_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check6", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but6", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group7_has_troops", 1),
            (assign, "$g_formation_group7_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check7", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but7", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group8_has_troops", 1),
            (assign, "$g_formation_group8_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check8", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but8", 250, 0),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_battle_but6"),
          (assign, ":update_listeners", 1),

          (assign, "$g_formation_group6_selected", 1),
          (overlay_animate_to_alpha, "$g_presentation_obj_battle_but6", 250, 0x44),
          (overlay_set_val, "$g_presentation_obj_battle_check6", 1),

          (try_begin),
            (eq, "$group0_has_troops", 1),
            (assign, "$g_formation_group0_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check0", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but0", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group1_has_troops", 1),
            (assign, "$g_formation_group1_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check1", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but1", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group2_has_troops", 1),
            (assign, "$g_formation_group2_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check2", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but2", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group3_has_troops", 1),
            (assign, "$g_formation_group3_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check3", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but3", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group4_has_troops", 1),
            (assign, "$g_formation_group4_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check4", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but4", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group5_has_troops", 1),
            (assign, "$g_formation_group5_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check5", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but5", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group7_has_troops", 1),
            (assign, "$g_formation_group7_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check7", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but7", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group8_has_troops", 1),
            (assign, "$g_formation_group8_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check8", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but8", 250, 0),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_battle_but7"),
          (assign, ":update_listeners", 1),

          (assign, "$g_formation_group7_selected", 1),
          (overlay_animate_to_alpha, "$g_presentation_obj_battle_but7", 250, 0x44),
          (overlay_set_val, "$g_presentation_obj_battle_check7", 1),

          (try_begin),
            (eq, "$group0_has_troops", 1),
            (assign, "$g_formation_group0_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check0", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but0", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group1_has_troops", 1),
            (assign, "$g_formation_group1_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check1", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but1", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group2_has_troops", 1),
            (assign, "$g_formation_group2_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check2", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but2", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group3_has_troops", 1),
            (assign, "$g_formation_group3_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check3", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but3", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group4_has_troops", 1),
            (assign, "$g_formation_group4_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check4", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but4", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group5_has_troops", 1),
            (assign, "$g_formation_group5_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check5", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but5", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group6_has_troops", 1),
            (assign, "$g_formation_group6_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check6", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but6", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group8_has_troops", 1),
            (assign, "$g_formation_group8_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check8", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but8", 250, 0),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_battle_but8"),
          (assign, ":update_listeners", 1),

          (assign, "$g_formation_group8_selected", 1),
          (overlay_animate_to_alpha, "$g_presentation_obj_battle_but8", 250, 0x44),
          (overlay_set_val, "$g_presentation_obj_battle_check8", 1),

          (try_begin),
            (eq, "$group0_has_troops", 1),
            (assign, "$g_formation_group0_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check0", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but0", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group1_has_troops", 1),
            (assign, "$g_formation_group1_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check1", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but1", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group2_has_troops", 1),
            (assign, "$g_formation_group2_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check2", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but2", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group3_has_troops", 1),
            (assign, "$g_formation_group3_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check3", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but3", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group4_has_troops", 1),
            (assign, "$g_formation_group4_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check4", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but4", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group5_has_troops", 1),
            (assign, "$g_formation_group5_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check5", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but5", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group6_has_troops", 1),
            (assign, "$g_formation_group6_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check6", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but6", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group7_has_troops", 1),
            (assign, "$g_formation_group7_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check7", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but7", 250, 0),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_battle_14"),
          (call_script, "script_team_give_order_from_order_panel", ":player_agent", mordr_spread_out),
        (else_try),
          (eq, ":object", "$g_presentation_obj_battle_15"),
          (call_script, "script_team_give_order_from_order_panel", ":player_agent", mordr_stand_closer),
        (else_try),
          (eq, ":object", "$g_presentation_obj_battle_16"),
          (call_script, "script_team_give_order_from_order_panel", ":player_agent", mordr_fall_back),
        (else_try),
          (eq, ":object", "$g_presentation_obj_battle_17"),
          (call_script, "script_team_give_order_from_order_panel", ":player_agent", mordr_advance),
        (else_try),
          (eq, ":object", "$g_presentation_obj_battle_10"),
          (try_begin),
            (eq, ":value", 3),
            (call_script, "script_team_give_order_from_order_panel", ":player_agent", mordr_hold),
            (call_script, "script_update_order_panel", ":player_team"),
            (assign, "$g_latest_order_1", 3),
          (else_try),
            (eq, ":value", 2),
            (call_script, "script_team_give_order_from_order_panel", ":player_agent", mordr_follow),
            (call_script, "script_update_order_panel", ":player_team"),
            (assign, "$g_latest_order_1", 2),
          (else_try),
            (eq, ":value", 1),
            (call_script, "script_team_give_order_from_order_panel", ":player_agent", mordr_charge),
            (call_script, "script_update_order_panel", ":player_team"),
##          (else_try),
##            (eq, ":value", 4),
##            (call_script, "script_team_give_order_from_order_panel", ":player_agent", mordr_advance),
##            (call_script, "script_update_order_panel", ":player_team"),
##          (else_try),
##            (eq, ":value", 3),
##            (call_script, "script_team_give_order_from_order_panel", ":player_agent", mordr_fall_back),
##            (call_script, "script_update_order_panel", ":player_team"),
##          (else_try),
##            (eq, ":value", 2),
##            (call_script, "script_team_give_order_from_order_panel", ":player_agent", mordr_stand_closer),
##            (call_script, "script_update_order_panel", ":player_team"),
##          (else_try),
##            (eq, ":value", 1),
##            (call_script, "script_team_give_order_from_order_panel", ":player_agent", mordr_spread_out),
##            (call_script, "script_update_order_panel", ":player_team"),
            (assign, "$g_latest_order_1", 1),
          (else_try),
            (eq, ":value", 0),
            (call_script, "script_team_give_order_from_order_panel", ":player_agent", mordr_stand_ground),
            (call_script, "script_update_order_panel", ":player_team"),
            (assign, "$g_latest_order_1", 0),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_battle_11"),
          (try_begin),
            (eq, ":value", 1),
            (call_script, "script_team_give_order_from_order_panel", ":player_agent", mordr_mount),
            (call_script, "script_update_order_panel", ":player_team"),
            (assign, "$g_latest_order_2", 1),
          (else_try),
            (eq, ":value", 0),
            (call_script, "script_team_give_order_from_order_panel", ":player_agent", mordr_dismount),
            (call_script, "script_update_order_panel", ":player_team"),
            (assign, "$g_latest_order_2", 0),
          (try_end),        
        (else_try),
          (eq, ":object", "$g_presentation_obj_battle_12"),
          (try_begin),
            (eq, ":value", 1),
            (call_script, "script_team_give_order_from_order_panel", ":player_agent", mordr_hold_fire),
            (call_script, "script_update_order_panel", ":player_team"),
            (assign, "$g_latest_order_3", 1),
          (else_try),
            (eq, ":value", 0),
            (call_script, "script_team_give_order_from_order_panel", ":player_agent", mordr_fire_at_will),
            (call_script, "script_update_order_panel", ":player_team"),
            (assign, "$g_latest_order_3", 0),
          (try_end),        
        (else_try),
          (eq, ":object", "$g_presentation_obj_battle_13"),
          (try_begin),
            (eq, ":value", 1),
            (call_script, "script_team_give_order_from_order_panel", ":player_agent", mordr_use_any_weapon),
            (call_script, "script_update_order_panel", ":player_team"),
            (assign, "$g_latest_order_4", 1),
          (else_try),
            (eq, ":value", 0),
            (call_script, "script_team_give_order_from_order_panel", ":player_agent", mordr_use_blunt_weapons),
            (call_script, "script_update_order_panel", ":player_team"),
            (assign, "$g_latest_order_4", 0),
          (try_end),
        (else_try),
          (eq, ":object", "$g_battle_map_plane"),
          (get_scene_boundaries, pos2, pos3),
          (mouse_get_position, pos1),
          (set_fixed_point_multiplier, 1000),
          (position_get_x, ":mouse_x", pos1),
          (position_get_y, ":mouse_y", pos1),
          (store_sub, ":map_x", 980, "$g_battle_map_width"),
          (store_sub, ":map_y", 730, "$g_battle_map_height"),
          (val_sub, ":mouse_x", ":map_x"),
          (val_sub, ":mouse_y", ":map_y"),
          (val_clamp, ":mouse_x", 0, "$g_battle_map_width"),
          (val_clamp, ":mouse_y", 0, "$g_battle_map_height"),
          (val_mul, ":mouse_x", "$g_battle_map_scale"),
          (val_mul, ":mouse_y", "$g_battle_map_scale"),
          (set_fixed_point_multiplier, 1000),
          (position_set_x, pos1, ":mouse_x"),
          (position_set_y, pos1, ":mouse_y"),
          (position_transform_position_to_parent, pos3, pos2, pos1),
          (try_begin),
            (eq, "$g_formation_group0_selected", 1),
            (team_give_order, ":player_team", 0, mordr_hold),
            (team_set_order_position, ":player_team", 0, pos3),
          (try_end),
          (try_begin),
            (eq, "$g_formation_group1_selected", 1),
            (team_give_order, ":player_team", 1, mordr_hold),
            (team_set_order_position, ":player_team", 1, pos3),
          (try_end),
          (try_begin),
            (eq, "$g_formation_group2_selected", 1),
            (team_give_order, ":player_team", 2, mordr_hold),
            (team_set_order_position, ":player_team", 2, pos3),
          (try_end),
          (try_begin),
            (eq, "$g_formation_group3_selected", 1),
            (team_give_order, ":player_team", 3, mordr_hold),
            (team_set_order_position, ":player_team", 3, pos3),
          (try_end),
          (try_begin),
            (eq, "$g_formation_group4_selected", 1),
            (team_give_order, ":player_team", 4, mordr_hold),
            (team_set_order_position, ":player_team", 4, pos3),
          (try_end),
          (try_begin),
            (eq, "$g_formation_group5_selected", 1),
            (team_give_order, ":player_team", 5, mordr_hold),
            (team_set_order_position, ":player_team", 5, pos3),
          (try_end),
          (try_begin),
            (eq, "$g_formation_group6_selected", 1),
            (team_give_order, ":player_team", 6, mordr_hold),
            (team_set_order_position, ":player_team", 6, pos3),
          (try_end),
          (try_begin),
            (eq, "$g_formation_group7_selected", 1),
            (team_give_order, ":player_team", 7, mordr_hold),
            (team_set_order_position, ":player_team", 7, pos3),
          (try_end),
          (try_begin),
            (eq, "$g_formation_group8_selected", 1),
            (team_give_order, ":player_team", 8, mordr_hold),
            (team_set_order_position, ":player_team", 8, pos3),
          (try_end),        
          (call_script, "script_update_order_flags_on_map"),
          (call_script, "script_update_order_panel", ":player_team"),
        (try_end),
        
        (try_begin),
          (eq, ":update_listeners", 1),
          (team_set_order_listener, ":player_team", -1),
          (try_begin),
            (this_or_next|eq, "$g_formation_group0_selected", 1),
            (eq, "$group0_has_troops", 0),
            (this_or_next|eq, "$g_formation_group1_selected", 1),
            (eq, "$group1_has_troops", 0),
            (this_or_next|eq, "$g_formation_group2_selected", 1),
            (eq, "$group2_has_troops", 0),
            (this_or_next|eq, "$g_formation_group3_selected", 1),
            (eq, "$group3_has_troops", 0),
            (this_or_next|eq, "$g_formation_group4_selected", 1),
            (eq, "$group4_has_troops", 0),
            (this_or_next|eq, "$g_formation_group5_selected", 1),
            (eq, "$group5_has_troops", 0),
            (this_or_next|eq, "$g_formation_group6_selected", 1),
            (eq, "$group6_has_troops", 0),
            (this_or_next|eq, "$g_formation_group7_selected", 1),
            (eq, "$group7_has_troops", 0),
            (this_or_next|eq, "$g_formation_group8_selected", 1),
            (eq, "$group8_has_troops", 0),
            (team_set_order_listener, ":player_team", grc_everyone),
          (else_try),
            (eq, "$g_formation_group0_selected", 1),
            (team_set_order_listener, ":player_team", 0, 1),
          (else_try),
            (eq, "$g_formation_group1_selected", 1),
            (team_set_order_listener, ":player_team", 1, 1),
          (else_try),
            (eq, "$g_formation_group2_selected", 1),
            (team_set_order_listener, ":player_team", 2, 1),
          (else_try),
            (eq, "$g_formation_group3_selected", 1),
            (team_set_order_listener, ":player_team", 3, 1),
          (else_try),
            (eq, "$g_formation_group4_selected", 1),
            (team_set_order_listener, ":player_team", 4, 1),
          (else_try),
            (eq, "$g_formation_group5_selected", 1),
            (team_set_order_listener, ":player_team", 5, 1),
          (else_try),
            (eq, "$g_formation_group6_selected", 1),
            (team_set_order_listener, ":player_team", 6, 1),
          (else_try),
            (eq, "$g_formation_group7_selected", 1),
            (team_set_order_listener, ":player_team", 7, 1),
          (else_try),
            (eq, "$g_formation_group8_selected", 1),
            (team_set_order_listener, ":player_team", 8, 1),
          (try_end),
        (try_end),
        ]),
      (ti_on_presentation_mouse_enter_leave,
       [(store_trigger_param_1, ":object"),
        (store_trigger_param_2, ":enter_leave"),
        (try_begin),
          (eq, ":object", "$g_presentation_obj_battle_but0"),
          (try_begin),
            (eq, ":enter_leave", 0),
            (overlay_animate_to_color, "$g_presentation_but0_movement", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_but0_riding", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_but0_weapon_usage", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_obj_battle_name0", 250, 0xFFFFFF),
          (else_try),
            (overlay_animate_to_color, "$g_presentation_but0_movement", 250, 0),
            (overlay_animate_to_color, "$g_presentation_but0_riding", 250, 0),
            (overlay_animate_to_color, "$g_presentation_but0_weapon_usage", 250, 0),
            (overlay_animate_to_color, "$g_presentation_obj_battle_name0", 250, 0),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_battle_but1"),
          (try_begin),
            (eq, ":enter_leave", 0),
            (overlay_animate_to_color, "$g_presentation_but1_movement", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_but1_riding", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_but1_weapon_usage", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_obj_battle_name1", 250, 0xFFFFFF),
          (else_try),
            (overlay_animate_to_color, "$g_presentation_but1_movement", 250, 0),
            (overlay_animate_to_color, "$g_presentation_but1_riding", 250, 0),
            (overlay_animate_to_color, "$g_presentation_but1_weapon_usage", 250, 0),
            (overlay_animate_to_color, "$g_presentation_obj_battle_name1", 250, 0),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_battle_but2"),
          (try_begin),
            (eq, ":enter_leave", 0),
            (overlay_animate_to_color, "$g_presentation_but2_movement", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_but2_riding", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_but2_weapon_usage", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_obj_battle_name2", 250, 0xFFFFFF),
          (else_try),
            (overlay_animate_to_color, "$g_presentation_but2_movement", 250, 0),
            (overlay_animate_to_color, "$g_presentation_but2_riding", 250, 0),
            (overlay_animate_to_color, "$g_presentation_but2_weapon_usage", 250, 0),
            (overlay_animate_to_color, "$g_presentation_obj_battle_name2", 250, 0),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_battle_but3"),
          (try_begin),
            (eq, ":enter_leave", 0),
            (overlay_animate_to_color, "$g_presentation_but3_movement", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_but3_riding", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_but3_weapon_usage", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_obj_battle_name3", 250, 0xFFFFFF),
          (else_try),
            (overlay_animate_to_color, "$g_presentation_but3_movement", 250, 0),
            (overlay_animate_to_color, "$g_presentation_but3_riding", 250, 0),
            (overlay_animate_to_color, "$g_presentation_but3_weapon_usage", 250, 0),
            (overlay_animate_to_color, "$g_presentation_obj_battle_name3", 250, 0),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_battle_but4"),
          (try_begin),
            (eq, ":enter_leave", 0),
            (overlay_animate_to_color, "$g_presentation_but4_movement", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_but4_riding", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_but4_weapon_usage", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_obj_battle_name4", 250, 0xFFFFFF),
          (else_try),
            (overlay_animate_to_color, "$g_presentation_but4_movement", 250, 0),
            (overlay_animate_to_color, "$g_presentation_but4_riding", 250, 0),
            (overlay_animate_to_color, "$g_presentation_but4_weapon_usage", 250, 0),
            (overlay_animate_to_color, "$g_presentation_obj_battle_name4", 250, 0),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_battle_but5"),
          (try_begin),
            (eq, ":enter_leave", 0),
            (overlay_animate_to_color, "$g_presentation_but5_movement", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_but5_riding", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_but5_weapon_usage", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_obj_battle_name5", 250, 0xFFFFFF),
          (else_try),
            (overlay_animate_to_color, "$g_presentation_but5_movement", 250, 0),
            (overlay_animate_to_color, "$g_presentation_but5_riding", 250, 0),
            (overlay_animate_to_color, "$g_presentation_but5_weapon_usage", 250, 0),
            (overlay_animate_to_color, "$g_presentation_obj_battle_name5", 250, 0),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_battle_but6"),
          (try_begin),
            (eq, ":enter_leave", 0),
            (overlay_animate_to_color, "$g_presentation_but6_movement", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_but6_riding", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_but6_weapon_usage", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_obj_battle_name6", 250, 0xFFFFFF),
          (else_try),
            (overlay_animate_to_color, "$g_presentation_but6_movement", 250, 0),
            (overlay_animate_to_color, "$g_presentation_but6_riding", 250, 0),
            (overlay_animate_to_color, "$g_presentation_but6_weapon_usage", 250, 0),
            (overlay_animate_to_color, "$g_presentation_obj_battle_name6", 250, 0),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_battle_but7"),
          (try_begin),
            (eq, ":enter_leave", 0),
            (overlay_animate_to_color, "$g_presentation_but7_movement", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_but7_riding", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_but7_weapon_usage", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_obj_battle_name7", 250, 0xFFFFFF),
          (else_try),
            (overlay_animate_to_color, "$g_presentation_but7_movement", 250, 0),
            (overlay_animate_to_color, "$g_presentation_but7_riding", 250, 0),
            (overlay_animate_to_color, "$g_presentation_but7_weapon_usage", 250, 0),
            (overlay_animate_to_color, "$g_presentation_obj_battle_name7", 250, 0),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_battle_but8"),
          (try_begin),
            (eq, ":enter_leave", 0),
            (overlay_animate_to_color, "$g_presentation_but8_movement", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_but8_riding", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_but8_weapon_usage", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_obj_battle_name8", 250, 0xFFFFFF),
          (else_try),
            (overlay_animate_to_color, "$g_presentation_but8_movement", 250, 0),
            (overlay_animate_to_color, "$g_presentation_but8_riding", 250, 0),
            (overlay_animate_to_color, "$g_presentation_but8_weapon_usage", 250, 0),
            (overlay_animate_to_color, "$g_presentation_obj_battle_name8", 250, 0),
          (try_end),
        (try_end),
        ]),
      (ti_on_presentation_run,
       [(store_trigger_param_1, ":cur_time"),
        (try_begin),
          (this_or_next|game_key_clicked, gk_group0_hear),
          (this_or_next|game_key_clicked, gk_group1_hear),
          (this_or_next|game_key_clicked, gk_group2_hear),
          (this_or_next|game_key_clicked, gk_group3_hear),
          (this_or_next|game_key_clicked, gk_group4_hear),
          (this_or_next|game_key_clicked, gk_group5_hear),
          (this_or_next|game_key_clicked, gk_group6_hear),
          (this_or_next|game_key_clicked, gk_group7_hear),
          (this_or_next|game_key_clicked, gk_group8_hear),
          (this_or_next|game_key_clicked, gk_everyone_hear),
          (game_key_clicked, gk_reverse_order_group),
          (call_script, "script_update_order_panel_checked_classes"),
        (try_end),
        (try_begin),
          (this_or_next|game_key_clicked, gk_order_1),
          (this_or_next|game_key_clicked, gk_order_2),
          (this_or_next|game_key_clicked, gk_order_3),
          (this_or_next|game_key_clicked, gk_order_4),
          (this_or_next|game_key_clicked, gk_order_5),
          (game_key_clicked, gk_order_6),
          (get_player_agent_no, ":player_agent"),
          (agent_get_team, ":player_team", ":player_agent"),
          (call_script, "script_update_order_panel", ":player_team"),
        (try_end),
        (try_begin),
          (gt, ":cur_time", 200),
          (game_key_clicked, gk_view_orders),
          (try_for_agents, ":cur_agent"),
            (agent_set_slot, ":cur_agent", slot_agent_map_overlay_id, 0),
          (try_end),
          (presentation_set_duration, 0),
        (try_end),
        ]),
      ]),


    ("sliders",0,0,[
      (ti_on_presentation_load,
       [(set_fixed_point_multiplier, 1000),
        (create_slider_overlay, "$g_presentation_obj_sliders_1", 0, 100),
        (create_slider_overlay, "$g_presentation_obj_sliders_2", 0, 100),
        (create_slider_overlay, "$g_presentation_obj_sliders_3", 0, 100),
        (create_slider_overlay, "$g_presentation_obj_sliders_4", 0, 100),
        (assign, reg1, 25),
        (str_store_string, s1, "str_reg1"),
        (create_text_overlay, "$g_presentation_obj_sliders_5", s1),
        (create_text_overlay, "$g_presentation_obj_sliders_6", s1),
        (create_text_overlay, "$g_presentation_obj_sliders_7", s1),
        (create_text_overlay, "$g_presentation_obj_sliders_8", s1),
        (assign, "$g_presentation_obj_sliders_1_val", 25),
        (overlay_set_val, "$g_presentation_obj_sliders_1", 25),
        (assign, "$g_presentation_obj_sliders_2_val", 25),
        (overlay_set_val, "$g_presentation_obj_sliders_2", 25),
        (assign, "$g_presentation_obj_sliders_3_val", 25),
        (overlay_set_val, "$g_presentation_obj_sliders_3", 25),
        (assign, "$g_presentation_obj_sliders_4_val", 25),
        (overlay_set_val, "$g_presentation_obj_sliders_4", 25),
        (position_set_x, pos1, 600),
        (position_set_y, pos1, 200),
        (overlay_set_position, "$g_presentation_obj_sliders_1", pos1),
        (position_set_y, pos1, 300),
        (overlay_set_position, "$g_presentation_obj_sliders_2", pos1),
        (position_set_y, pos1, 400),
        (overlay_set_position, "$g_presentation_obj_sliders_3", pos1),
        (position_set_y, pos1, 500),
        (overlay_set_position, "$g_presentation_obj_sliders_4", pos1),
        (position_set_x, pos1, 800),
        (position_set_y, pos1, 200),
        (overlay_set_position, "$g_presentation_obj_sliders_5", pos1),
        (position_set_y, pos1, 300),
        (overlay_set_position, "$g_presentation_obj_sliders_6", pos1),
        (position_set_y, pos1, 400),
        (overlay_set_position, "$g_presentation_obj_sliders_7", pos1),
        (position_set_y, pos1, 500),
        (overlay_set_position, "$g_presentation_obj_sliders_8", pos1),
        (position_set_x, pos1, 500),
        (overlay_set_size, "$g_presentation_obj_sliders_3", pos1),
        ]),
      (ti_on_presentation_run,
       [
        ]),
      (ti_on_presentation_event_state_change,
       [(store_trigger_param_1, ":object"),
        (store_trigger_param_2, ":value"),
        (assign, ":val_changed", 0),
        (try_begin),
          (eq, ":object", "$g_presentation_obj_sliders_1"),
          (try_begin),
            (neq, "$g_presentation_obj_sliders_1_val", ":value"),
            (assign, "$g_presentation_obj_sliders_1_val", ":value"),
            (assign, ":val_changed", 1),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_sliders_2"),
          (try_begin),
            (neq, "$g_presentation_obj_sliders_2_val", ":value"),
            (assign, "$g_presentation_obj_sliders_2_val", ":value"),
            (assign, ":val_changed", 1),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_sliders_3"),
          (try_begin),
            (neq, "$g_presentation_obj_sliders_3_val", ":value"),
            (assign, "$g_presentation_obj_sliders_3_val", ":value"),
            (assign, ":val_changed", 1),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_sliders_4"),
          (try_begin),
            (neq, "$g_presentation_obj_sliders_4_val", ":value"),
            (assign, "$g_presentation_obj_sliders_4_val", ":value"),
            (assign, ":val_changed", 1),
          (try_end),
        (try_end),
        (try_begin),
          (eq, ":val_changed", 1),
          (assign, ":sum_values", 0),
          (val_add, ":sum_values", "$g_presentation_obj_sliders_1_val"),
          (val_add, ":sum_values", "$g_presentation_obj_sliders_2_val"),
          (val_add, ":sum_values", "$g_presentation_obj_sliders_3_val"),
          (val_add, ":sum_values", "$g_presentation_obj_sliders_4_val"),
          (store_sub, ":difference", 100, ":sum_values"),
          (assign, ":obj_1_new_val", "$g_presentation_obj_sliders_1_val"),
          (assign, ":obj_2_new_val", "$g_presentation_obj_sliders_2_val"),
          (assign, ":obj_3_new_val", "$g_presentation_obj_sliders_3_val"),
          (assign, ":obj_4_new_val", "$g_presentation_obj_sliders_4_val"),
          (assign, ":adder", 1),
          (assign, ":between_1", 0),
          (assign, ":between_2", 100),
          (try_begin),
            (lt, ":difference", 0),
            (val_mul, ":difference", -1),
            (assign, ":adder", -1),
            (assign, ":between_1", 1),
            (assign, ":between_2", 101),
          (try_end),
          (store_sub, ":sum_non_changed_values", ":sum_values", ":value"),
          (val_add, ":sum_non_changed_values", 30),
          (try_for_range, ":unused", 0, ":difference"),
            (store_random_in_range, ":random_no", 0, ":sum_non_changed_values"),
            (try_begin),
              (neq, ":object", "$g_presentation_obj_sliders_1"),
              (val_sub, ":random_no", "$g_presentation_obj_sliders_1_val"),
              (val_sub, ":random_no", 10),
              (lt, ":random_no", 0),
              (is_between, ":obj_1_new_val", ":between_1", ":between_2"),
              (val_add, ":obj_1_new_val", ":adder"),
            (else_try),
              (neq, ":object", "$g_presentation_obj_sliders_2"),
              (val_sub, ":random_no", "$g_presentation_obj_sliders_2_val"),
              (val_sub, ":random_no", 10),
              (lt, ":random_no", 0),
              (is_between, ":obj_2_new_val", ":between_1", ":between_2"),
              (val_add, ":obj_2_new_val", ":adder"),
            (else_try),
              (neq, ":object", "$g_presentation_obj_sliders_3"),
              (val_sub, ":random_no", "$g_presentation_obj_sliders_3_val"),
              (val_sub, ":random_no", 10),
              (lt, ":random_no", 0),
              (is_between, ":obj_3_new_val", ":between_1", ":between_2"),
              (val_add, ":obj_3_new_val", ":adder"),
            (else_try),
              (is_between, ":obj_4_new_val", ":between_1", ":between_2"),
              (val_add, ":obj_4_new_val", ":adder"),
            (else_try),
              (val_add, ":difference", 1),
            (try_end),
          (try_end),
          (assign, "$g_presentation_obj_sliders_1_val", ":obj_1_new_val"),
          (assign, "$g_presentation_obj_sliders_2_val", ":obj_2_new_val"),
          (assign, "$g_presentation_obj_sliders_3_val", ":obj_3_new_val"),
          (assign, "$g_presentation_obj_sliders_4_val", ":obj_4_new_val"),
        (try_end),
        (overlay_set_val, "$g_presentation_obj_sliders_1", "$g_presentation_obj_sliders_1_val"),
        (overlay_set_val, "$g_presentation_obj_sliders_2", "$g_presentation_obj_sliders_2_val"),
        (overlay_set_val, "$g_presentation_obj_sliders_3", "$g_presentation_obj_sliders_3_val"),
        (overlay_set_val, "$g_presentation_obj_sliders_4", "$g_presentation_obj_sliders_4_val"),
        (assign, reg1, "$g_presentation_obj_sliders_1_val"),
        (str_store_string, s1, "str_reg1"),
        (overlay_set_text, "$g_presentation_obj_sliders_5", s1),
        (assign, reg1, "$g_presentation_obj_sliders_2_val"),
        (str_store_string, s1, "str_reg1"),
        (overlay_set_text, "$g_presentation_obj_sliders_6", s1),
        (assign, reg1, "$g_presentation_obj_sliders_3_val"),
        (str_store_string, s1, "str_reg1"),
        (overlay_set_text, "$g_presentation_obj_sliders_7", s1),
        (assign, reg1, "$g_presentation_obj_sliders_4_val"),
        (str_store_string, s1, "str_reg1"),
        (overlay_set_text, "$g_presentation_obj_sliders_8", s1),
        ]),
      ]),

  ("arena_training", prsntf_read_only|prsntf_manual_end_only, 0, [
      (ti_on_presentation_load,
       [(presentation_set_duration, 999999),
        (set_fixed_point_multiplier, 1000),
        (get_player_agent_no, ":player_agent"),
        (agent_get_kill_count, reg1, ":player_agent", 1),
        (str_store_string, s1, "@Number of men knocked down: {reg1}"),
        (create_text_overlay, "$g_presentation_obj_arena_training_1", s1),
        (overlay_set_color, "$g_presentation_obj_arena_training_1", 0xFFFFFF),
        (position_set_x, pos1, 10),
        (position_set_y, pos1, 700),
        (overlay_set_position, "$g_presentation_obj_arena_training_1", pos1),
        (assign, reg1, 0),
        (str_store_string, s1, "@Number of men left: {reg1}"),
        (create_text_overlay, "$g_presentation_obj_arena_training_2", s1),
        (overlay_set_color, "$g_presentation_obj_arena_training_2", 0xFFFFFF),
        (position_set_x, pos1, 10),
        (position_set_y, pos1, 670),
        (overlay_set_position, "$g_presentation_obj_arena_training_2", pos1),
        ]),
      (ti_on_presentation_run,
       [(get_player_agent_no, ":player_agent"),
        (agent_get_kill_count, reg1, ":player_agent", 1),
        (str_store_string, s1, "@Opponents Beaten: {reg1}"),
        (overlay_set_text, "$g_presentation_obj_arena_training_1", s1),
        (assign, ":num_left", "$g_arena_training_max_opponents"),
        (try_for_agents, ":agent_no"),
          (agent_is_human, ":agent_no"),
          (neg|agent_is_alive, ":agent_no"),
          (neq, ":agent_no", ":player_agent"),
          (val_sub, ":num_left", 1),
        (try_end),
        (assign, reg1, ":num_left"),
        (str_store_string, s1, "@Opponents Remaining: {reg1}"),
        (overlay_set_text, "$g_presentation_obj_arena_training_2", s1),
        ]),
      ]),

  ("retirement", 0, mesh_load_window,
   [
     (ti_on_presentation_load,
      [
        (presentation_set_duration, 999999),
        (set_fixed_point_multiplier, 1000),
        (create_button_overlay, "$g_presentation_obj_retirement_1", "@Remain in retirement.", tf_center_justify),
        (create_button_overlay, "$g_presentation_obj_retirement_2", "@Go back to the adventuring.", tf_center_justify),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, 80),
        (overlay_set_position, "$g_presentation_obj_retirement_1", pos1),
        (position_set_y, pos1, 40),
        (overlay_set_position, "$g_presentation_obj_retirement_2", pos1),
        (assign, ":total_effect", 0),
        #wealth
        (store_troop_gold, ":wealth", "trp_player"),
        (store_div, ":wealth_effect", ":wealth", 200),
        (val_add, ":total_effect", ":wealth_effect"),
        #ruled centers and friendly/enemy centers
        (assign, ":num_towns", 0),
        (assign, ":num_castles", 0),
        (assign, ":num_villages", 0),
        (assign, ":num_friendly_towns", 0),
        (assign, ":num_friendly_villages", 0),
        (assign, ":num_enemy_towns", 0),
        (assign, ":num_enemy_villages", 0),
        (try_for_range, ":center_no", centers_begin, centers_end),
          (party_get_slot, ":type", ":center_no", slot_party_type),
          (try_begin),
            (party_slot_eq, ":center_no", slot_town_lord, "trp_player"),
            (try_begin),
              (eq, ":type", spt_town),
              (val_add, ":num_towns", 1),
            (else_try),
              (eq, ":type", spt_castle),
              (val_add, ":num_castles", 1),
            (else_try),
              (val_add, ":num_villages", 1),
            (try_end),
          (try_end),
          (party_get_slot, ":relation", ":center_no", slot_center_player_relation),
          (try_begin),
            (ge, ":relation", 40),
            (try_begin),
              (eq, ":type", spt_town),
              (val_add, ":num_friendly_towns", 1),
            (else_try),
              (eq, ":type", spt_village),
              (val_add, ":num_friendly_villages", 1),
            (try_end),
          (else_try),
            (le, ":relation", -40),
            (try_begin),
              (eq, ":type", spt_town),
              (val_add, ":num_enemy_towns", 1),
            (else_try),
              (eq, ":type", spt_village),
              (val_add, ":num_enemy_villages", 1),
            (try_end),
          (try_end),
        (try_end),
        (store_mul, ":num_towns_effect", ":num_towns", 100),
        (store_mul, ":num_castles_effect", ":num_castles", 50),
        (store_mul, ":num_villages_effect", ":num_villages", 20),
        (store_add, ":num_centers", ":num_towns", ":num_castles"),
        (val_add, ":num_centers", ":num_villages"),
        (store_add, ":ruled_centers_effect", ":num_towns_effect", ":num_castles_effect"),
        (val_add, ":ruled_centers_effect", ":num_villages_effect"),
        (val_add, ":total_effect", ":ruled_centers_effect"),
        (store_mul, ":num_friendly_towns_effect", ":num_friendly_towns", 20),
        (store_mul, ":num_friendly_villages_effect", ":num_friendly_villages", 4),
        (store_add, ":num_friendly_centers", ":num_friendly_towns", ":num_friendly_villages"),
        (store_add, ":friendly_centers_effect", ":num_friendly_towns_effect", ":num_friendly_villages_effect"),
        (val_add, ":total_effect", ":friendly_centers_effect"),
        (store_mul, ":num_enemy_towns_effect", ":num_enemy_towns", -40),
        (store_mul, ":num_enemy_villages_effect", ":num_enemy_villages", -8),
        (store_add, ":num_enemy_centers", ":num_enemy_towns", ":num_enemy_villages"),
        (store_add, ":enemy_centers_effect", ":num_enemy_towns_effect", ":num_enemy_villages_effect"),
        (val_add, ":total_effect", ":enemy_centers_effect"),
        #inventory
        (assign, ":total_item_value", 0),
        (troop_get_inventory_capacity, ":capacity", "trp_player"),
        (try_for_range, ":i_inv", 0, ":capacity"),
          (troop_get_inventory_slot, ":item", "trp_player", ":i_inv"),
          (ge, ":item", 0),
          (store_item_value, ":item_value", ":item"),
          (val_add, ":total_item_value", ":item_value"),
        (try_end),
        (store_div, ":total_item_value_effect", ":total_item_value", 200),
        (val_add, ":total_effect", ":total_item_value_effect"),
        #renown
        (troop_get_slot, ":renown", "trp_player", slot_troop_renown),
        (store_div, ":renown_effect", ":renown", 1),
        (val_add, ":total_effect", ":renown_effect"),
        #enemies and friends
        (assign, ":num_enemies", 0),
        (assign, ":num_friends", 0),
        (try_for_range, ":troop_no", heroes_begin, heroes_end),
          (this_or_next|troop_slot_eq, ":troop_no", slot_troop_occupation, slto_kingdom_hero),
          (troop_slot_eq, ":troop_no", slot_troop_occupation, slto_kingdom_lady),
          (call_script, "script_troop_get_player_relation", ":troop_no"),
          (assign, ":relation", reg0),
          #(troop_get_slot, ":relation", ":troop_no", slot_troop_player_relation),
          (try_begin),
            (ge, ":relation", 40),
            (val_add, ":num_friends", 1),
          (else_try),
            (le, ":relation", -40),
            (val_add, ":num_enemies", 1),
          (try_end),
        (try_end),
        (store_mul, ":num_friends_effect", ":num_friends", 10),
        (val_add, ":total_effect", ":num_friends_effect"),
        (store_mul, ":num_enemies_effect", ":num_enemies", -10),
        (val_add, ":total_effect", ":num_enemies_effect"),
        #current day
        (store_current_day, ":cur_day"),
        (store_div, ":cur_day_effect", ":cur_day", -1),
        (val_add, ":total_effect", ":cur_day_effect"),
        #g_total_victories
        (store_mul, ":total_victories_effect", "$g_total_victories", 2),
        (val_add, ":total_effect", ":total_victories_effect"),
        #g_total_defeats
        (store_mul, ":total_defeats_effect", "$g_total_defeats", -3),
        (val_add, ":total_effect", ":total_defeats_effect"),
        #g_total_quests_completed
        (store_mul, ":total_quests_completed_effect", "$g_total_quests_completed", 4),
        (val_add, ":total_effect", ":total_quests_completed_effect"),
        #xp
        (troop_get_xp, ":xp", "trp_player"),
        (store_div, ":xp_effect", ":xp", 5000),
        (val_add, ":total_effect", ":xp_effect"),
        #companions joined / departed
        (assign, ":num_companions_joined", 0),
        (assign, ":num_companions_departed", 0),
        (try_for_range, ":troop_no", companions_begin, companions_end),
          (try_begin),
            (troop_slot_eq, ":troop_no", slot_troop_occupation, slto_player_companion),
            (val_add, ":num_companions_joined", 1),
          (else_try),
            (troop_slot_ge, ":troop_no", slot_troop_playerparty_history, 1),
            (val_add, ":num_companions_departed", 1),
          (try_end),
        (try_end),
        (store_div, ":num_companions_joined_effect", ":num_companions_joined", 2),
        (val_add, ":total_effect", ":num_companions_joined_effect"),
        (store_div, ":num_companions_departed_effect", ":num_companions_departed", -4),
        (val_add, ":total_effect", ":num_companions_departed_effect"),
        #difficulty
        (get_average_game_difficulty, ":difficulty"),
        (assign, ":difficulty_effect", ":total_effect"),
        (val_mul, ":total_effect", ":difficulty"),
        (val_div, ":total_effect", 75),
        (val_mul, ":total_effect", ":difficulty"),
        (val_div, ":total_effect", 75),
        (store_sub, ":difficulty_effect", ":total_effect", ":difficulty_effect"),

        (assign, reg5, ":cur_day"),
        (store_character_level, reg4, "trp_player"),
        (create_text_overlay, reg1, "@You have retired at level {reg4} after {reg5} days of adventuring.", tf_center_justify),
        (position_set_x, pos1, 700),
        (position_set_y, pos1, 700),
        (overlay_set_position, reg1, pos1),
        (position_set_x, pos1, 950),
        (position_set_y, pos1, 950),
        (overlay_set_size, reg1, pos1),
##        (overlay_set_color, reg1, 0),
        (create_text_overlay, reg2, "@Effect on Score", tf_center_justify),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg2, pos1),
        (position_set_x, pos1, 850),
        (position_set_y, pos1, 670),
        (overlay_set_position, reg2, pos1),
        (assign, reg0, ":num_centers"),
        (create_text_overlay, reg1, "@Settlements owned by you: {reg0}", 0),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 600),
        (position_set_y, pos1, 650),
        (overlay_set_position, reg1, pos1),
        (assign, reg0, ":ruled_centers_effect"),
        (create_text_overlay, reg1, "@{!}{reg0?+:}{reg0}", tf_center_justify),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 850),
        (position_set_y, pos1, 650),
        (overlay_set_position, reg1, pos1),
        (try_begin),
          (gt, reg0, 0),
          (overlay_set_color, reg1, 0x00AA00),
        (try_end),

        (assign, reg0, ":num_friendly_centers"),
        (create_text_overlay, reg1, "@Friendly Settlements: {reg0}", 0),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 600),
        (position_set_y, pos1, 630),
        (overlay_set_position, reg1, pos1),
        (assign, reg0, ":friendly_centers_effect"),
        (create_text_overlay, reg1, "@{!}{reg0?+:}{reg0}", tf_center_justify),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 850),
        (position_set_y, pos1, 630),
        (overlay_set_position, reg1, pos1),
        (try_begin),
          (gt, reg0, 0),
          (overlay_set_color, reg1, 0x00AA00),
        (try_end),

        (assign, reg0, ":num_enemy_centers"),
        (create_text_overlay, reg1, "@Hostile Settlements: {reg0}", 0),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 600),
        (position_set_y, pos1, 610),
        (overlay_set_position, reg1, pos1),
        (assign, reg0, ":enemy_centers_effect"),
        (create_text_overlay, reg1, "@{!}{reg0}", tf_center_justify),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 850),
        (position_set_y, pos1, 610),
        (overlay_set_position, reg1, pos1),
        (try_begin),
          (lt, reg0, 0),
          (overlay_set_color, reg1, 0xFF0000),
        (try_end),

        (assign, reg0, ":num_friends"),
        (create_text_overlay, reg1, "@Friendly Lords: {reg0}", 0),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 600),
        (position_set_y, pos1, 590),
        (overlay_set_position, reg1, pos1),
        (assign, reg0, ":num_friends_effect"),
        (create_text_overlay, reg1, "@{!}{reg0?+:}{reg0}", tf_center_justify),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 850),
        (position_set_y, pos1, 590),
        (overlay_set_position, reg1, pos1),
        (try_begin),
          (gt, reg0, 0),
          (overlay_set_color, reg1, 0x00AA00),
        (try_end),

        (assign, reg0, ":num_enemies"),
        (create_text_overlay, reg1, "@Enemy Lords: {reg0}", 0),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 600),
        (position_set_y, pos1, 570),
        (overlay_set_position, reg1, pos1),
        (assign, reg0, ":num_enemies_effect"),
        (create_text_overlay, reg1, "@{!}{reg0}", tf_center_justify),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 850),
        (position_set_y, pos1, 570),
        (overlay_set_position, reg1, pos1),
        (try_begin),
          (lt, reg0, 0),
          (overlay_set_color, reg1, 0xFF0000),
        (try_end),

        (assign, reg0, "$g_total_victories"),
        (create_text_overlay, reg1, "@Victories: {reg0}", 0),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 600),
        (position_set_y, pos1, 550),
        (overlay_set_position, reg1, pos1),
        (assign, reg0, ":total_victories_effect"),
        (create_text_overlay, reg1, "@{!}{reg0?+:}{reg0}", tf_center_justify),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 850),
        (position_set_y, pos1, 550),
        (overlay_set_position, reg1, pos1),
        (try_begin),
          (gt, reg0, 0),
          (overlay_set_color, reg1, 0x00AA00),
        (try_end),

        (assign, reg0, "$g_total_defeats"),
        (create_text_overlay, reg1, "@Defeats: {reg0}", 0),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 600),
        (position_set_y, pos1, 530),
        (overlay_set_position, reg1, pos1),
        (assign, reg0, ":total_defeats_effect"),
        (create_text_overlay, reg1, "@{!}{reg0}", tf_center_justify),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 850),
        (position_set_y, pos1, 530),
        (overlay_set_position, reg1, pos1),
        (try_begin),
          (lt, reg0, 0),
          (overlay_set_color, reg1, 0xFF0000),
        (try_end),

        (assign, reg0, "$g_total_quests_completed"),
        (create_text_overlay, reg1, "@Quests Completed: {reg0}", 0),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 600),
        (position_set_y, pos1, 510),
        (overlay_set_position, reg1, pos1),
        (assign, reg0, ":total_quests_completed_effect"),
        (create_text_overlay, reg1, "@{!}{reg0?+:}{reg0}", tf_center_justify),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 850),
        (position_set_y, pos1, 510),
        (overlay_set_position, reg1, pos1),
        (try_begin),
          (gt, reg0, 0),
          (overlay_set_color, reg1, 0x00AA00),
        (try_end),

        (assign, reg0, ":num_companions_joined"),
        (create_text_overlay, reg1, "@Companions Found: {reg0}", 0),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 600),
        (position_set_y, pos1, 490),
        (overlay_set_position, reg1, pos1),
        (assign, reg0, ":num_companions_joined_effect"),
        (create_text_overlay, reg1, "@{!}{reg0?+:}{reg0}", tf_center_justify),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 850),
        (position_set_y, pos1, 490),
        (overlay_set_position, reg1, pos1),
        (try_begin),
          (gt, reg0, 0),
          (overlay_set_color, reg1, 0x00AA00),
        (try_end),

        (assign, reg0, ":num_companions_departed"),
        (create_text_overlay, reg1, "@Companions Lost/Departed: {reg0}", 0),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 600),
        (position_set_y, pos1, 470),
        (overlay_set_position, reg1, pos1),
        (assign, reg0, ":num_companions_departed_effect"),
        (create_text_overlay, reg1, "@{!}{reg0}", tf_center_justify),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 850),
        (position_set_y, pos1, 470),
        (overlay_set_position, reg1, pos1),
        (try_begin),
          (lt, reg0, 0),
          (overlay_set_color, reg1, 0xFF0000),
        (try_end),

        (assign, reg0, ":wealth"),
        (create_text_overlay, reg1, "@Wealth: {reg0} denars", 0),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 600),
        (position_set_y, pos1, 450),
        (overlay_set_position, reg1, pos1),
        (assign, reg0, ":wealth_effect"),
        (create_text_overlay, reg1, "@{!}{reg0?+:}{reg0}", tf_center_justify),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 850),
        (position_set_y, pos1, 450),
        (overlay_set_position, reg1, pos1),
        (try_begin),
          (gt, reg0, 0),
          (overlay_set_color, reg1, 0x00AA00),
        (try_end),

        (assign, reg0, ":total_item_value"),
        (create_text_overlay, reg1, "@Inventory: {reg0} denars", 0),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 600),
        (position_set_y, pos1, 430),
        (overlay_set_position, reg1, pos1),
        (assign, reg0, ":total_item_value_effect"),
        (create_text_overlay, reg1, "@{!}{reg0?+:}{reg0}", tf_center_justify),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 850),
        (position_set_y, pos1, 430),
        (overlay_set_position, reg1, pos1),
        (try_begin),
          (gt, reg0, 0),
          (overlay_set_color, reg1, 0x00AA00),
        (try_end),

        (assign, reg0, ":renown"),
        (create_text_overlay, reg1, "@Renown: {reg0}", 0),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 600),
        (position_set_y, pos1, 410),
        (overlay_set_position, reg1, pos1),
        (assign, reg0, ":renown_effect"),
        (create_text_overlay, reg1, "@{!}{reg0?+:}{reg0}", tf_center_justify),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 850),
        (position_set_y, pos1, 410),
        (overlay_set_position, reg1, pos1),
        (try_begin),
          (gt, reg0, 0),
          (overlay_set_color, reg1, 0x00AA00),
        (try_end),

        (assign, reg0, ":xp"),
        (create_text_overlay, reg1, "@Experience: {reg0}", 0),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 600),
        (position_set_y, pos1, 390),
        (overlay_set_position, reg1, pos1),
        (assign, reg0, ":xp_effect"),
        (create_text_overlay, reg1, "@{!}{reg0?+:}{reg0}", tf_center_justify),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 850),
        (position_set_y, pos1, 390),
        (overlay_set_position, reg1, pos1),
        (try_begin),
          (gt, reg0, 0),
          (overlay_set_color, reg1, 0x00AA00),
        (try_end),

        (assign, reg0, ":cur_day"),
        (create_text_overlay, reg1, "@Days Passed: {reg0}", 0),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 600),
        (position_set_y, pos1, 370),
        (overlay_set_position, reg1, pos1),
        (assign, reg0, ":cur_day_effect"),
        (create_text_overlay, reg1, "@{!}{reg0}", tf_center_justify),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 850),
        (position_set_y, pos1, 370),
        (overlay_set_position, reg1, pos1),
        (try_begin),
          (lt, reg0, 0),
          (overlay_set_color, reg1, 0xFF0000),
        (try_end),

        (assign, reg0, ":difficulty"),
        (create_text_overlay, reg1, "@Difficulty: {reg0}%", 0),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 600),
        (position_set_y, pos1, 350),
        (overlay_set_position, reg1, pos1),
        (assign, reg0, ":difficulty_effect"),
        (assign, reg3, reg0),
        (val_max, reg3, 0),
        (create_text_overlay, reg1, "@{!}{reg3?+:}{reg0}", tf_center_justify),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 850),
        (position_set_y, pos1, 350),
        (overlay_set_position, reg1, pos1),
        (try_begin),
          (gt, reg0, 0),
          (overlay_set_color, reg1, 0x00AA00),
        (else_try),
          (lt, reg0, 0),
          (overlay_set_color, reg1, 0xFF0000),
        (try_end),

        (assign, reg0, ":total_effect"),
        (create_text_overlay, reg1, "@TOTAL SCORE: {reg0}", tf_center_justify),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 320),
        (overlay_set_position, reg1, pos1),

        (assign, ":total_villages", 0),
        (assign, ":total_castles", 0),
        (assign, ":total_towns", 0),
        (assign, ":total_village_rels", 0),
        (assign, ":total_castle_rels", 0),
        (assign, ":total_town_rels", 0),
        (try_for_range, ":cur_center_no", centers_begin, centers_end),
          (try_begin),
            (party_slot_eq, ":cur_center_no", slot_town_lord, "trp_player"),
            (try_begin),
              (party_slot_eq, ":cur_center_no", slot_party_type, spt_town),
              (val_add, ":total_towns", 1),
            (else_try),
              (party_slot_eq, ":cur_center_no", slot_party_type, spt_castle),
              (val_add, ":total_castles", 1),
            (else_try),
              (val_add, ":total_villages", 1),
            (try_end),
          (else_try),
            (party_get_slot, ":center_relation", ":cur_center_no", slot_center_player_relation),
            (gt, ":center_relation", 0),
            (try_begin),
              (party_slot_eq, ":cur_center_no", slot_party_type, spt_town),
              (val_add, ":total_town_rels", ":center_relation"),
            (else_try),
              (party_slot_eq, ":cur_center_no", slot_party_type, spt_castle),
              (val_add, ":total_castle_rels", ":center_relation"),
            (else_try),
              (val_add, ":total_village_rels", ":center_relation"),
            (try_end),
          (try_end),
        (try_end),
        (try_begin),
          (gt, ":total_towns", 0),
          (store_random_in_range, ":random_town", 0, ":total_towns"),
          (try_for_range, ":cur_center_no", towns_begin, towns_end),
            (party_slot_eq, ":cur_center_no", slot_town_lord, "trp_player"),
            (val_sub, ":random_town", 1),
            (lt, ":random_town", 0),
            (str_store_party_name, s9, ":cur_center_no"),
          (try_end),
        (else_try),
          (gt, ":total_town_rels", 0),
          (store_random_in_range, ":random_town_rel", 0, ":total_town_rels"),
          (try_for_range, ":cur_center_no", towns_begin, towns_end),
            (party_get_slot, ":center_relation", ":cur_center_no", slot_center_player_relation),
            (gt, ":center_relation", 0),
            (val_sub, ":random_town_rel", ":center_relation"),
            (lt, ":random_town_rel", 0),
            (str_store_party_name, s9, ":cur_center_no"),
          (try_end),
        (else_try),
          (store_random_in_range, ":random_town", towns_begin, towns_end),
          (str_store_party_name, s9, ":random_town"),
        (try_end),
        (try_begin),
          (gt, ":total_castles", 0),
          (store_random_in_range, ":random_castle", 0, ":total_castles"),
          (try_for_range, ":cur_center_no", castles_begin, castles_end),
            (party_slot_eq, ":cur_center_no", slot_town_lord, "trp_player"),
            (val_sub, ":random_castle", 1),
            (lt, ":random_castle", 0),
            (str_store_party_name, s8, ":cur_center_no"),
          (try_end),
        (else_try),
          (gt, ":total_castle_rels", 0),
          (store_random_in_range, ":random_castle_rel", 0, ":total_castle_rels"),
          (try_for_range, ":cur_center_no", castles_begin, castles_end),
            (party_get_slot, ":center_relation", ":cur_center_no", slot_center_player_relation),
            (gt, ":center_relation", 0),
            (val_sub, ":random_castle_rel", ":center_relation"),
            (lt, ":random_castle_rel", 0),
            (str_store_party_name, s8, ":cur_center_no"),
          (try_end),
        (else_try),
          (store_random_in_range, ":random_castle", castles_begin, castles_end),
          (str_store_party_name, s8, ":random_castle"),
        (try_end),
        (try_begin),
          (gt, ":total_villages", 0),
          (store_random_in_range, ":random_village", 0, ":total_villages"),
          (try_for_range, ":cur_center_no", villages_begin, villages_end),
            (party_slot_eq, ":cur_center_no", slot_town_lord, "trp_player"),
            (val_sub, ":random_village", 1),
            (lt, ":random_village", 0),
            (str_store_party_name, s7, ":cur_center_no"),
          (try_end),
        (else_try),
          (gt, ":total_village_rels", 0),
          (store_random_in_range, ":random_village_rel", 0, ":total_village_rels"),
          (try_for_range, ":cur_center_no", villages_begin, villages_end),
            (party_get_slot, ":center_relation", ":cur_center_no", slot_center_player_relation),
            (gt, ":center_relation", 0),
            (val_sub, ":random_village_rel", ":center_relation"),
            (lt, ":random_village_rel", 0),
            (str_store_party_name, s7, ":cur_center_no"),
          (try_end),
        (else_try),
          (store_random_in_range, ":random_village", villages_begin, villages_end),
          (str_store_party_name, s7, ":random_village"),
        (try_end),

        (try_begin),
          (lt, ":total_effect", 100),
          (create_mesh_overlay_with_tableau_material, reg1, -1, "tableau_retirement_troop", 0),
          (str_store_string, s0, "str_retirement_text_1"),
        (else_try),
          (lt, ":total_effect", 200),
          (create_mesh_overlay_with_tableau_material, reg1, -1, "tableau_retirement_troop", 1),
          (str_store_string, s0, "str_retirement_text_2"),
        (else_try),
          (lt, ":total_effect", 400),
          (create_mesh_overlay_with_tableau_material, reg1, -1, "tableau_retirement_troop", 2),
          (str_store_string, s0, "str_retirement_text_3"),
        (else_try),
          (lt, ":total_effect", 700),
          (create_mesh_overlay_with_tableau_material, reg1, -1, "tableau_retirement_troop", 3),
          (str_store_string, s0, "str_retirement_text_4"),
        (else_try),
          (lt, ":total_effect", 1200),
          (create_mesh_overlay_with_tableau_material, reg1, -1, "tableau_retirement_troop", 4),
          (str_store_string, s0, "str_retirement_text_5"),
        (else_try),
          (lt, ":total_effect", 1850),
          (create_mesh_overlay_with_tableau_material, reg1, -1, "tableau_retirement_troop", 5),
          (str_store_string, s0, "str_retirement_text_6"),
        (else_try),
          (lt, ":total_effect", 2500),
          (create_mesh_overlay_with_tableau_material, reg1, -1, "tableau_retirement_troop", 6),
          (str_store_string, s0, "str_retirement_text_7"),
        (else_try),
          (lt, ":total_effect", 3500),
          (create_mesh_overlay_with_tableau_material, reg1, -1, "tableau_retirement_troop", 7),
          (str_store_string, s0, "str_retirement_text_8"),
        (else_try),
          (lt, ":total_effect", 5000),
          (create_mesh_overlay_with_tableau_material, reg1, -1, "tableau_retirement_troop", 8),
          (str_store_string, s0, "str_retirement_text_9"),
        (else_try),
          (create_mesh_overlay_with_tableau_material, reg1, -1, "tableau_retirement_troop", 9),
          (str_store_string, s0, "str_retirement_text_10"),
        (try_end),
        (position_set_x, pos1, 0),
        (position_set_y, pos1, 120),
        (overlay_set_position, reg1, pos1),

        (create_text_overlay, reg1, s0, tf_double_space|tf_scrollable),
        (position_set_x, pos1, 600),
        (position_set_y, pos1, 120),
        (overlay_set_position, reg1, pos1),
        (position_set_x, pos1, 360),
        (position_set_y, pos1, 190),
        (overlay_set_area_size, reg1, pos1),
        (position_set_x, pos1, 800),
        (position_set_y, pos1, 800),
        (overlay_set_size, reg1, pos1),
        ]),
     (ti_on_presentation_event_state_change,
      [
        (store_trigger_param_1, ":object"),
        (try_begin),
          (eq, ":object", "$g_presentation_obj_retirement_1"),
          (jump_to_menu, "mnu_end_game"),
          (start_presentation, "prsnt_game_credits"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_retirement_2"),
          (presentation_set_duration, 0),
          (change_screen_return),
        (try_end),
        ]),
     ]),

  ("budget_report", 0, mesh_load_window,
   [(ti_on_presentation_load,
     [(presentation_set_duration, 999999),
      (set_fixed_point_multiplier, 1000),
      
      (create_mesh_overlay, reg1, "mesh_pic_payment"),
      (position_set_x, pos1, 800),
      (position_set_y, pos1, 800),
      (overlay_set_size, reg1, pos1),
      (position_set_x, pos1, 170),
      (position_set_y, pos1, 0),
      (overlay_set_position, reg1, pos1),
      
      (create_text_overlay, reg1, "str_weekly_budget", tf_center_justify),
      (position_set_x, pos1, 1500),
      (position_set_y, pos1, 1500),
      (overlay_set_size, reg1, pos1),
      (position_set_x, pos1, 260),
      (position_set_y, pos1, 650),
      (overlay_set_position, reg1, pos1),

      (str_clear, s0),
      (create_text_overlay, "$g_presentation_obj_bugdet_report_container", s0, tf_scrollable_style_2),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, 100),
      (overlay_set_position, "$g_presentation_obj_bugdet_report_container", pos1),
      (position_set_x, pos1, 505),
      (position_set_y, pos1, 500),
      (overlay_set_area_size, "$g_presentation_obj_bugdet_report_container", pos1),
      (set_container_overlay, "$g_presentation_obj_bugdet_report_container"),

      (game_get_reduce_campaign_ai, ":reduce_campaign_ai"),      
      (try_begin),
        (eq, ":reduce_campaign_ai", 0), #hard
        (assign, ":num_centers_needed_for_efficiency_loss", 2),
        (assign, ":tax_efficiency_loss_ratio_per_center", 5),
      (else_try),  
        (eq, ":reduce_campaign_ai", 1), #medium
        (assign, ":num_centers_needed_for_efficiency_loss", 4),
        (assign, ":tax_efficiency_loss_ratio_per_center", 4),
      (else_try),  
        (eq, ":reduce_campaign_ai", 2), #easy
        (assign, ":num_centers_needed_for_efficiency_loss", 6),
        (assign, ":tax_efficiency_loss_ratio_per_center", 3),
      (try_end),  

      (assign, ":num_lines", 0),
      (assign, ":num_owned_center_values_for_tax_efficiency", 0),
      (assign, ":all_centers_accumulated_total", 0),
      (assign, ":all_centers_accumulated_taxes_and_rents", 0),
      (try_for_range, ":center_no", centers_begin, centers_end),	  
	    (try_begin),
		  (party_slot_ge, ":center_no", slot_center_player_enterprise, 1),		  
		  (val_add, ":num_lines", 1),
	    (try_end),	  
	  
        (party_slot_eq, ":center_no", slot_town_lord, "trp_player"),
        (val_add, ":num_lines", 1),
        (val_add, ":num_owned_center_values_for_tax_efficiency", 1),
        (try_begin),
          (is_between, ":center_no", towns_begin, towns_end),
          (val_add, ":num_lines", 1),
          (val_add, ":num_owned_center_values_for_tax_efficiency", 1),
        (try_end),
      (try_end),
      (try_begin),
        (gt, "$players_kingdom", 0),
        (neq, "$players_kingdom", "fac_player_supporters_faction"),
        (neq, "$players_kingdom", "fac_player_faction"),
        (eq, "$player_has_homage", 0),
        (val_add, ":num_lines", 1),
      (try_end),
      (try_begin),      
        (gt, ":num_owned_center_values_for_tax_efficiency", ":num_centers_needed_for_efficiency_loss"),
      #gt accumulated total is ignored
        (val_add, ":num_lines", 1),
      (try_end),
      (try_for_parties, ":party_no"),
        (assign, ":garrison_troop", 0),
        (try_begin),
          (this_or_next|party_slot_eq, ":party_no", slot_party_type, spt_town),
			(party_slot_eq, ":party_no", slot_party_type, spt_castle),
          (party_slot_eq, ":party_no", slot_town_lord, "trp_player"),
          (assign, ":garrison_troop", 1),
        (else_try),
          (this_or_next|party_slot_eq, ":party_no", slot_party_type, spt_town),
			(party_slot_eq, ":party_no", slot_party_type, spt_castle),
          (neg|party_slot_ge, ":party_no", slot_town_lord, 1), #unassigned
		  (store_faction_of_party, ":center_faction", ":party_no"),
		  (eq, ":center_faction", "fac_player_supporters_faction"),
		  (faction_slot_eq, "fac_player_supporters_faction", slot_faction_leader, "trp_player"),
          (assign, ":garrison_troop", 1),		  
		(try_end),
		
        (this_or_next|eq, ":party_no", "p_main_party"),
			(eq, ":garrison_troop", 1),
        (val_add, ":num_lines", 1), #include empty towns/castles
      (try_end),
      (try_begin),
        (gt, "$g_player_debt_to_party_members", 0),
        (val_add, ":num_lines", 2), #include new debt line
      (try_end),
      (val_add, ":num_lines", 3),
      (store_mul, ":cur_y", 27, ":num_lines"),
      (assign, ":net_change", 0), #this is the amount added
      (try_for_range, ":center_no", centers_begin, centers_end),		
		#Enterprise
        (try_begin),
		  (party_get_slot, ":enterprise_output", ":center_no", slot_center_player_enterprise),
		  (gt, ":enterprise_output", 1),
		  (neg|party_slot_ge, ":center_no", slot_center_player_enterprise_days_until_complete, 1),
		  
          (str_store_party_name, s0, ":center_no"),
		  
		  (call_script, "script_process_player_enterprise", ":enterprise_output", ":center_no"),
		  (assign, ":net_profit", reg0),
		  (assign, ":price_of_single_output", reg4),
		  (assign, ":price_of_single_input", reg5),
		  (assign, ":price_of_secondary_input", reg10),
		  
		  (store_sub, ":town_order", ":center_no", towns_begin),
		  (store_add, ":craftsman_troop", ":town_order", "trp_town_1_master_craftsman"),

		  (item_get_slot, ":outputs_added_to_market", ":enterprise_output", slot_item_output_per_run),
		  (assign, ":outputs_added_to_warehouse", 0),
		  
		  #Enterprise impact of outputs
		  (try_begin),
		    #output placed in inventory: deduct selling price and add one good
			(party_slot_eq, ":center_no", slot_center_player_enterprise_production_order, 1),
			
			#Count empty slots
			(assign, ":empty_slots", 0),
			(troop_get_inventory_capacity, ":total_capacity", ":craftsman_troop"),
			(try_for_range, ":capacity_iterator", 0, ":total_capacity"),
				(troop_get_inventory_slot, ":slot", ":craftsman_troop", ":capacity_iterator"),
				(lt, ":slot", 1),
				(val_add, ":empty_slots", 1),
			(try_end),
			
			(assign, ":outputs_added_to_warehouse", ":outputs_added_to_market"),
			(val_min, ":outputs_added_to_warehouse",  ":empty_slots"),
			(gt, ":outputs_added_to_warehouse", 0),
			
			(store_mul, ":cancelled_sales", ":price_of_single_output", ":outputs_added_to_warehouse"),
			(val_sub, ":net_profit", ":cancelled_sales"),
			(val_sub, ":outputs_added_to_market", ":outputs_added_to_warehouse"),
		  (try_end),
		  
		  #If the transaction is for real, and not just a budget check
		  (try_begin),
		    (eq, "$g_apply_budget_report_to_gold", 1),
			(troop_add_items, ":craftsman_troop", ":enterprise_output", ":outputs_added_to_warehouse"),

			#Affect prices by outputs added to market
			(store_sub, ":item_slot_no", ":enterprise_output", trade_goods_begin),
			(val_add, ":item_slot_no", slot_town_trade_good_prices_begin),
			(party_get_slot, ":current_index", ":center_no", ":item_slot_no"),			
			(store_mul, ":impact_on_price", ":outputs_added_to_market", 15),
			(val_sub, ":current_index", ":impact_on_price"),
			(party_set_slot, ":center_no", ":item_slot_no",":current_index"),			
						
			(gt, "$cheat_mode", 0),
			(str_store_troop_name, s3, ":craftsman_troop"),
			(assign, reg3, ":outputs_added_to_warehouse"),
			(display_message, "@{!}DEBUG -- Adding {reg3} items to {s3}"),
		  (try_end),
		  
		  #Enterprise impact of outputs
		  (item_get_slot, ":inputs_taken_from_market", ":enterprise_output", slot_item_input_number),		  
		  (try_begin),
			(item_slot_ge, ":enterprise_output", slot_item_secondary_raw_material, 1),
		    (assign, ":2ary_inputs_taken_from_market", ":inputs_taken_from_market"),
		  (else_try),
		    (assign, ":2ary_inputs_taken_from_market", 0),
		  (try_end),
		  
		  (assign, ":inputs_taken_from_warehouse", 0),
		  (assign, ":2ary_inputs_taken_from_warehouse", 0),
		  
		  (try_begin),
		    #input present in inventory: reimburse for input cost and remove one good
			(troop_get_inventory_capacity, ":total_capacity", ":craftsman_troop"),
			(try_for_range, ":capacity_iterator", 0, ":total_capacity"),
				(troop_get_inventory_slot, ":item_in_slot", ":craftsman_troop", ":capacity_iterator"),
			
				(lt, ":inputs_taken_from_warehouse", ":inputs_taken_from_market"),
				(item_slot_eq, ":enterprise_output", slot_item_primary_raw_material, ":item_in_slot"),
                #(troop_inventory_slot_get_item_amount, ":item_ammo", ":craftsman_troop", ":capacity_iterator"),
                #(troop_inventory_slot_get_item_max_amount, ":item_max_ammo", ":craftsman_troop", ":capacity_iterator"),
                #(eq, ":item_ammo", ":item_max_ammo"),
				
				(val_add, ":inputs_taken_from_warehouse", 1),
			(else_try),	
				(lt, ":2ary_inputs_taken_from_warehouse", ":2ary_inputs_taken_from_market"),
				(item_slot_eq, ":enterprise_output", slot_item_secondary_raw_material, ":item_in_slot"),
                #(troop_inventory_slot_get_item_amount, ":item_ammo", ":craftsman_troop", ":capacity_iterator"),
                #(troop_inventory_slot_get_item_max_amount, ":item_max_ammo", ":craftsman_troop", ":capacity_iterator"),
                #(eq, ":item_ammo", ":item_max_ammo"),

				(val_add, ":2ary_inputs_taken_from_warehouse", 1),
			(try_end),
		  
		    (try_begin),
				(gt, ":inputs_taken_from_warehouse", 0),
				(val_sub, ":inputs_taken_from_market", ":inputs_taken_from_warehouse"),
				(store_mul, ":savings_from_warehoused_inputs",	":price_of_single_input", ":inputs_taken_from_warehouse"),
				(val_add, ":net_profit", ":savings_from_warehoused_inputs"),
			(try_end),	
		    (try_begin),
				(gt, ":2ary_inputs_taken_from_warehouse", 0),
				(val_sub, ":2ary_inputs_taken_from_market", ":2ary_inputs_taken_from_warehouse"),
				(assign, ":savings_from_warehoused_inputs",	":price_of_secondary_input"),
				(val_add, ":net_profit", ":savings_from_warehoused_inputs"),
			(try_end),					
		  (try_end),
		  
		  #If the transaction is for real, and not just a budget check
		  (try_begin),
		    (eq, "$g_apply_budget_report_to_gold", 1),
			(item_get_slot, ":raw_material", ":enterprise_output", slot_item_primary_raw_material),
			(troop_remove_items, ":craftsman_troop", ":raw_material", ":inputs_taken_from_warehouse"),
			(item_get_slot, ":secondary_raw_material", ":enterprise_output", slot_item_secondary_raw_material),
			(troop_remove_items, ":craftsman_troop", ":secondary_raw_material", ":2ary_inputs_taken_from_warehouse"),
			
			#Affect prices by intputs added to market
			(store_sub, ":item_slot_no", ":raw_material", trade_goods_begin),
			(val_add, ":item_slot_no", slot_town_trade_good_prices_begin),
			(party_get_slot, ":current_index", ":center_no", ":item_slot_no"),			
			(store_mul, ":impact_on_price", ":outputs_added_to_market", 15),
			(val_add, ":current_index", ":impact_on_price"),
			(party_set_slot, ":center_no", ":item_slot_no",":current_index"),			
			
			(try_begin),
				(gt, ":2ary_inputs_taken_from_market", 0),
				(store_sub, ":item_slot_no", ":secondary_raw_material", trade_goods_begin),
				(val_add, ":item_slot_no", slot_town_trade_good_prices_begin),
				(party_get_slot, ":current_index", ":center_no", ":item_slot_no"),			
				(val_add, ":current_index", 15),
				(party_set_slot, ":center_no", ":item_slot_no",":current_index"),			
			(try_end),
		  (try_end),		  
		  		  
		  (call_script, "script_get_enterprise_name", ":enterprise_output"),
		  (str_store_string, s5, reg0),
		  
          (create_text_overlay, reg1, "str_enterprise_s5_at_s0", 0),
          (position_set_x, pos1, 900),
          (position_set_y, pos1, 900),
          (overlay_set_size, reg1, pos1),
          (position_set_x, pos1, 25),
          (position_set_y, pos1, ":cur_y"),
          (overlay_set_position, reg1, pos1),
		  
          (assign, reg0, ":net_profit"),
		  
		  #Enterprise revenue strings
          (try_begin),
     	    (store_faction_of_party, ":faction_no", ":center_no"),
		    (store_relation, ":relation", ":faction_no", "$players_kingdom"),
		    (lt, ":relation", 0),
		    (assign, reg0, 0), 
		    (assign, ":net_profit", 0), 
		  
            (create_text_overlay, reg1, "str_under_sequestration", tf_right_align|tf_single_line),
            (overlay_set_color, reg1, 0xFF0000),		  
		  (else_try),
		    (ge, reg0, 0), 
            (create_text_overlay, reg1, "@{!}{reg0}", tf_right_align|tf_single_line),
            (overlay_set_color, reg1, 0x00AA00),
          (else_try),
            (create_text_overlay, reg1, "@{!}{reg0}", tf_right_align|tf_single_line),
            (overlay_set_color, reg1, 0xFF0000),
          (try_end),
		  
          (val_add, ":all_centers_accumulated_total", ":net_profit"),
          (val_add, ":net_change", ":net_profit"),		  
		  
          (position_set_x, pos1, 900),
          (position_set_y, pos1, 900),
          (overlay_set_size, reg1, pos1),
          (position_set_x, pos1, 500),
          (position_set_y, pos1, ":cur_y"),
          (overlay_set_position, reg1, pos1),
          (val_sub, ":cur_y", 27),
        (try_end),

		#Enterprise ends, taxes begin
        (party_slot_eq, ":center_no", slot_town_lord, "trp_player"),
        (party_get_slot, ":accumulated_rents", ":center_no", slot_center_accumulated_rents),
        (party_get_slot, ":accumulated_tariffs", ":center_no", slot_center_accumulated_tariffs),
		
        (store_add, ":accumulated_total", ":accumulated_rents", ":accumulated_tariffs"),
        (val_add, ":all_centers_accumulated_total", ":accumulated_total"),
        (val_add, ":all_centers_accumulated_taxes_and_rents", ":accumulated_total"),
        (val_add, ":net_change", ":accumulated_total"),
        (str_store_party_name, s0, ":center_no"),
        (create_text_overlay, reg1, "str_rents_from_s0", 0),
        (position_set_x, pos1, 900),
        (position_set_y, pos1, 900),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 25),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg1, pos1),
        (try_begin),
          (gt, ":accumulated_rents", 0),
          (assign, reg0, ":accumulated_rents"),
          (create_text_overlay, reg1, "@{!}{reg0}", tf_right_align|tf_single_line),
          (overlay_set_color, reg1, 0x00AA00),
        (else_try),
          (create_text_overlay, reg1, "@None", tf_right_align|tf_single_line),
        (try_end),
        (position_set_x, pos1, 900),
        (position_set_y, pos1, 900),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg1, pos1),
        (val_sub, ":cur_y", 27),
		
        (try_begin),
          (is_between, ":center_no", towns_begin, towns_end),
          (create_text_overlay, reg1, "str_tariffs_from_s0", 0),
          (position_set_x, pos1, 900),
          (position_set_y, pos1, 900),
          (overlay_set_size, reg1, pos1),
          (position_set_x, pos1, 25),
          (position_set_y, pos1, ":cur_y"),
          (overlay_set_position, reg1, pos1),
          (try_begin),
            (gt, ":accumulated_tariffs", 0),
            (assign, reg0, ":accumulated_tariffs"),
            (create_text_overlay, reg1, "@{!}{reg0}", tf_right_align|tf_single_line),
            (overlay_set_color, reg1, 0x00AA00),
          (else_try),
            (create_text_overlay, reg1, "@None", tf_right_align|tf_single_line),
          (try_end),
          (position_set_x, pos1, 900),
          (position_set_y, pos1, 900),
          (overlay_set_size, reg1, pos1),
          (position_set_x, pos1, 500),
          (position_set_y, pos1, ":cur_y"),
          (overlay_set_position, reg1, pos1),
          (val_sub, ":cur_y", 27),
        (try_end),								
      (try_end),

      (try_begin),
        (gt, "$players_kingdom", 0),
        (neq, "$players_kingdom", "fac_player_supporters_faction"),
        (neq, "$players_kingdom", "fac_player_faction"),
        (eq, "$player_has_homage", 0),
        (str_store_faction_name, s0, "$players_kingdom"),
        (create_text_overlay, reg1, "str_mercenary_payment_from_s0", 0),
        (position_set_x, pos1, 900),
        (position_set_y, pos1, 900),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 25),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg1, pos1),
        (call_script, "script_party_calculate_strength", "p_main_party", 0),
        (assign, ":offer_value", reg0),
        (val_div, ":offer_value", 2),
        (val_add, ":offer_value", 30),
        (call_script, "script_round_value", ":offer_value"),
        (val_add, ":net_change", reg0),
        (create_text_overlay, reg1, "@{!}{reg0}", tf_right_align|tf_single_line),
        (position_set_x, pos1, 900),
        (position_set_y, pos1, 900),
        (overlay_set_size, reg1, pos1),
        (overlay_set_color, reg1, 0x00AA00),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg1, pos1),
        (val_sub, ":cur_y", 27),
      (try_end),
      
      (try_begin),
        (gt, ":num_owned_center_values_for_tax_efficiency", ":num_centers_needed_for_efficiency_loss"),
        (gt, ":all_centers_accumulated_total", 0),
        (store_sub, ":ratio_lost", ":num_owned_center_values_for_tax_efficiency", ":num_centers_needed_for_efficiency_loss"),
        (val_mul, ":ratio_lost", ":tax_efficiency_loss_ratio_per_center"),
        (val_min, ":ratio_lost", 65),
                
        #(store_mul, ":tax_lost", ":all_centers_accumulated_total", ":ratio_lost"),
        (store_mul, ":tax_lost", ":all_centers_accumulated_taxes_and_rents", ":ratio_lost"),
        (val_div, ":tax_lost", 100),
        (val_sub, ":net_change", ":tax_lost"),
        (create_text_overlay, reg1, "str_loss_due_to_tax_inefficiency", 0),
        (position_set_x, pos1, 25),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg1, pos1),
        (position_set_x, pos1, 900),
        (position_set_y, pos1, 900),
        (overlay_set_size, reg1, pos1),
        (store_mul, reg0, ":tax_lost", -1),
        (create_text_overlay, reg1, "@{!}{reg0}", tf_right_align|tf_single_line),
        (position_set_x, pos1, 900),
        (position_set_y, pos1, 900),
        (overlay_set_size, reg1, pos1),
        (overlay_set_color, reg1, 0xFF0000),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg1, pos1),
        (val_sub, ":cur_y", 27),
      (try_end),

      (try_for_parties, ":party_no"),
        (assign, ":garrison_troop", 0),
        (try_begin),
          (this_or_next|party_slot_eq, ":party_no", slot_party_type, spt_town),
          (party_slot_eq, ":party_no", slot_party_type, spt_castle),
          (party_slot_eq, ":party_no", slot_town_lord, "trp_player"),
          (assign, ":garrison_troop", 1),
		(else_try),  
          (this_or_next|party_slot_eq, ":party_no", slot_party_type, spt_town),
			(party_slot_eq, ":party_no", slot_party_type, spt_castle),
          (neg|party_slot_ge, ":party_no", slot_town_lord, 1), #unassigned
		  (store_faction_of_party, ":center_faction", ":party_no"),
		  (eq, ":center_faction", "fac_player_supporters_faction"),
		  (faction_slot_eq, "fac_player_supporters_faction", slot_faction_leader, "trp_player"),
          (assign, ":garrison_troop", 1),			  
        (try_end),
		
        (this_or_next|eq, ":party_no", "p_main_party"),
			(eq, ":garrison_troop", 1),
        (assign, ":total_wage", 0),
        (party_get_num_companion_stacks, ":num_stacks", ":party_no"),
        (try_for_range, ":i_stack", 0, ":num_stacks"),
          (party_stack_get_troop_id, ":stack_troop", ":party_no", ":i_stack"),
          (party_stack_get_size, ":stack_size", ":party_no", ":i_stack"),
          (call_script, "script_game_get_troop_wage", ":stack_troop", ":party_no"),
          (assign, ":cur_wage", reg0),
          (val_mul, ":cur_wage", ":stack_size"),
          (val_add, ":total_wage", ":cur_wage"),
        (try_end),
        (try_begin),
          (eq, ":garrison_troop", 1),
          (val_div, ":total_wage", 2), #Half payment for garrisons
        (else_try),
          (eq, ":party_no", "p_main_party"),
          (store_sub, ":total_payment_ratio", 14, "$g_cur_week_half_daily_wage_payments"), #between 0 and 7
          (val_mul, ":total_wage", ":total_payment_ratio"),
          (val_div, ":total_wage", 14),
        (try_end),
##        (gt, ":total_wage", 0),
        (val_mul, ":total_wage", -1),
        (val_add, ":net_change", ":total_wage"),
        (str_store_party_name, s0, ":party_no"),
        (try_begin),
          (eq, ":party_no", "p_main_party"),
          (str_store_string, s0, "str_s0s_party"),
        (try_end),
        (create_text_overlay, reg1, "str_wages_for_s0", 0),
        (position_set_x, pos1, 900),
        (position_set_y, pos1, 900),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 25),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg1, pos1),
        (try_begin),
          (lt, ":total_wage", 0),
          (assign, reg0, ":total_wage"),
          (create_text_overlay, reg1, "@{!}{reg0}", tf_right_align|tf_single_line),
          (overlay_set_color, reg1, 0xFF0000),
        (else_try),
          (create_text_overlay, reg1, "@None", tf_right_align|tf_single_line),
        (try_end),
        (position_set_x, pos1, 900),
        (position_set_y, pos1, 900),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg1, pos1),
        (val_sub, ":cur_y", 27),
      (try_end),

      (try_begin),
        (gt, "$g_player_debt_to_party_members", 0),
        (val_sub, ":net_change", "$g_player_debt_to_party_members"),
        (create_text_overlay, reg1, "str_earlier_debts", 0),
        (position_set_x, pos1, 900),
        (position_set_y, pos1, 900),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 25),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg1, pos1),
        (store_mul, reg0, "$g_player_debt_to_party_members", -1),
        (create_text_overlay, reg1, "@{!}{reg0}", tf_right_align|tf_single_line),
        (position_set_x, pos1, 900),
        (position_set_y, pos1, 900),
        (overlay_set_size, reg1, pos1),
        (overlay_set_color, reg1, 0xFF0000),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg1, pos1),
        (val_sub, ":cur_y", 27),
      (try_end),
      (create_mesh_overlay, reg1, "mesh_white_plane"),
      (overlay_set_color, reg1, 0x000000),
      (position_set_x, pos1, 24000),
      (position_set_y, pos1, 50),
      (overlay_set_size, reg1, pos1),
      (position_set_x, pos1, 25),
      (store_add, ":line_y", ":cur_y", 25),
      (position_set_y, pos1, ":line_y"),
      (overlay_set_position, reg1, pos1),
      (create_text_overlay, reg1, "str_net_change", 0),
      (position_set_x, pos1, 900),
      (position_set_y, pos1, 900),
      (overlay_set_size, reg1, pos1),
      (position_set_x, pos1, 25),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg1, pos1),
      (assign, reg0, ":net_change"),
      (create_text_overlay, reg1, "@{!}{reg0}", tf_right_align|tf_single_line),
      (position_set_x, pos1, 900),
      (position_set_y, pos1, 900),
      (overlay_set_size, reg1, pos1),
      (try_begin),
        (gt, reg0, 0),
        (overlay_set_color, reg1, 0x00AA00),
      (else_try),
        (lt, reg0, 0),
        (overlay_set_color, reg1, 0xFF0000),
      (try_end),
      (position_set_x, pos1, 500),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg1, pos1),
      (val_sub, ":cur_y", 27),
      (create_text_overlay, reg1, "str_earlier_wealth", 0),
      (position_set_x, pos1, 900),
      (position_set_y, pos1, 900),
      (overlay_set_size, reg1, pos1),
      (position_set_x, pos1, 25),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg1, pos1),
      (store_troop_gold, ":player_wealth", "trp_player"),
      (assign, reg0, ":player_wealth"),
      (create_text_overlay, reg1, "@{!}{reg0}", tf_right_align|tf_single_line),
      (position_set_x, pos1, 900),
      (position_set_y, pos1, 900),
      (overlay_set_size, reg1, pos1),
      (position_set_x, pos1, 500),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg1, pos1),
      (val_sub, ":cur_y", 27),
      (val_mul, ":net_change", -1),
      (try_begin),
        (ge, ":player_wealth", ":net_change"),
        (assign, ":player_wealth_dif", ":net_change"),
        (assign, ":player_new_debt_to_party_members", 0),
      (else_try),
        (assign, ":player_wealth_dif", ":player_wealth"),
        (store_sub, ":player_new_debt_to_party_members", ":net_change", ":player_wealth"),
      (try_end),
      (create_text_overlay, reg1, "str_new_wealth", 0),
      (position_set_x, pos1, 900),
      (position_set_y, pos1, 900),
      (overlay_set_size, reg1, pos1),
      (position_set_x, pos1, 25),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg1, pos1),
      (store_sub, reg0, ":player_wealth", ":player_wealth_dif"),
      (create_text_overlay, reg1, "@{!}{reg0}", tf_right_align|tf_single_line),
      (position_set_x, pos1, 900),
      (position_set_y, pos1, 900),
      (overlay_set_size, reg1, pos1),
      (position_set_x, pos1, 500),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg1, pos1),
      (val_sub, ":cur_y", 27),

      (try_begin),
        (gt, ":player_new_debt_to_party_members", 0),
        (create_text_overlay, reg1, "str_new_debts", 0),
        (position_set_x, pos1, 900),
        (position_set_y, pos1, 900),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 25),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg1, pos1),
        (assign, reg0, ":player_new_debt_to_party_members"),
        (create_text_overlay, reg1, "@{!}{reg0}", tf_right_align|tf_single_line),
        (position_set_x, pos1, 900),
        (position_set_y, pos1, 900),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg1, pos1),
        (val_sub, ":cur_y", 27),
        (neq, "$g_apply_budget_report_to_gold", 0),
        (call_script, "script_objectionable_action", tmt_egalitarian, "str_men_unpaid"),
      (try_end),

      (set_container_overlay, -1),

      (create_button_overlay, "$g_presentation_obj_budget_report_1", "@Continue..."),
      (position_set_x, pos1, 225),
      (position_set_y, pos1, 60),
      (overlay_set_position, "$g_presentation_obj_budget_report_1", pos1),

      (try_begin),
        (eq, "$g_apply_budget_report_to_gold", 1),
        (assign, "$g_player_debt_to_party_members", ":player_new_debt_to_party_members"),
        (try_begin),
          (gt, ":player_wealth_dif", 0),
          (troop_remove_gold, "trp_player", ":player_wealth_dif"),
        (else_try),
          (val_mul, ":player_wealth_dif", -1),
          (troop_add_gold, "trp_player", ":player_wealth_dif"),
        (try_end),
        (try_for_range, ":center_no", centers_begin, centers_end),
          (party_slot_eq, ":center_no", slot_town_lord, "trp_player"),
          (party_set_slot, ":center_no", slot_center_accumulated_rents, 0),
          (party_set_slot, ":center_no", slot_center_accumulated_tariffs, 0),
        (try_end),
        (assign, "$g_cur_week_half_daily_wage_payments", 0),#Reseting the weekly half wage payments
      (try_end),
      ]),
    (ti_on_presentation_event_state_change,
     [(store_trigger_param_1, ":object"),
      (try_begin),
        (eq, ":object", "$g_presentation_obj_budget_report_1"),
        (presentation_set_duration, 0),
      (try_end),
      ]),
    ]),

  ("game_before_quit", 0, mesh_load_window,
   [
     (ti_on_presentation_load,
      [
        (try_begin),
          (is_trial_version),
          (set_fixed_point_multiplier, 1000),
          (create_mesh_overlay, reg0, "mesh_quit_adv"),
          (position_set_x, pos1, -1),
          (position_set_y, pos1, -1),
          (overlay_set_position, reg0, pos1),
          (position_set_x, pos1, 1002),
          (position_set_y, pos1, 1002),
          (overlay_set_size, reg0, pos1),
          (assign, "$g_game_before_quit_state", 0),
          (presentation_set_duration, 999999),
        (try_end),
      ]),
     (ti_on_presentation_run,
       [
        (store_trigger_param_1, ":cur_time"),
        (gt, ":cur_time", 500),
        (try_begin),
          (this_or_next|key_clicked, key_space),
          (this_or_next|key_clicked, key_enter),
          (this_or_next|key_clicked, key_escape),
          (this_or_next|key_clicked, key_back_space),
          (this_or_next|key_clicked, key_left_mouse_button),
          (this_or_next|key_clicked, key_right_mouse_button),
          (this_or_next|key_clicked, key_xbox_ltrigger),
          (key_clicked, key_xbox_rtrigger),
          (try_begin),
            (eq, "$g_game_before_quit_state", 0),
            (val_add, "$g_game_before_quit_state", 1),
            (create_mesh_overlay, reg0, "mesh_quit_adv_b"),
            (position_set_x, pos1, -1),
            (position_set_y, pos1, -1),
            (overlay_set_position, reg0, pos1),
            (position_set_x, pos1, 1002),
            (position_set_y, pos1, 1002),
            (overlay_set_size, reg0, pos1),
          (else_try),
            (presentation_set_duration, 0),
          (try_end),
        (try_end),
        ]),
     ]),

  ("multiplayer_duel_start_counter", prsntf_read_only|prsntf_manual_end_only, 0, [
    (ti_on_presentation_load, [      
      (set_fixed_point_multiplier, 1000),

      (assign, "$g_multiplayer_duel_start_counter_overlay", -1),
      (assign, "$g_multiplayer_last_duel_start_counter_value", -1),

      (str_clear, s0),
      (create_text_overlay, "$g_multiplayer_duel_start_counter_overlay", s0, tf_center_justify|tf_with_outline),
      (overlay_set_color, "$g_multiplayer_duel_start_counter_overlay", 0xFFFFFF),
      (position_set_x, pos1, 500),
      (position_set_y, pos1, 600),
      (overlay_set_position, "$g_multiplayer_duel_start_counter_overlay", pos1),
      (position_set_x, pos1, 2000),
      (position_set_y, pos1, 2000),
      (overlay_set_size, "$g_multiplayer_duel_start_counter_overlay", pos1),

      (presentation_set_duration, 999999),
      ]),
  
    (ti_on_presentation_run, [
      (ge, "$g_multiplayer_duel_start_counter_overlay", 0),
      (store_mission_timer_a, ":current_time"),
      (store_sub, ":seconds_past_in_duel_start", ":current_time", "$g_multiplayer_duel_start_time"),
      (store_sub, ":seconds_left_in_duel_start", 3, ":seconds_past_in_duel_start"),
      (try_begin),
        (le, ":seconds_left_in_duel_start", 0),
        (presentation_set_duration, 0),
      (else_try),
        (neq, "$g_multiplayer_last_duel_start_counter_value", ":seconds_left_in_duel_start"),
        (assign, "$g_multiplayer_last_duel_start_counter_value", ":seconds_left_in_duel_start"),
        (assign, reg0, ":seconds_left_in_duel_start"),
        (str_store_string, s0, "str_duel_starts_in_reg0_seconds"),
        (overlay_set_text, "$g_multiplayer_duel_start_counter_overlay", s0),
      (try_end),
      ]),
    ]),
  ]
