#coding=utf-8
###################################################
# header_operations.py
# This file cfontains opcode declarations
# DO NOT EDIT THIS FILE!
###################################################

#--------------------------------------------------------------------------
# CONTROL OPERATIONS
#--------------------------------------------------------------------------
###调用脚本
call_script       = 1 # (call_script,<script_id>),
###废弃的命令，使用下面的try_end
end_try           = 3 # deprecated, use try_end instead
###判断结束
try_end           = 3 # (try_end),
###判断开始
try_begin         = 4 # (try_begin),
###废弃的命令，使用下面的else_try
else_try_begin    = 5 # deprecated, use else_try instead
###判断分支
else_try          = 5 # (else_try),

###正顺序循环全部
try_for_range     = 6 # Works like a for loop from lower-bound up to (upper-bound - 1)
		      # (try_for_range,<destination>,<lower_bound>,<upper_bound>),
###倒顺序循环全部
try_for_range_backwards = 7	# Same as above but starts from (upper-bound - 1) down-to lower bound.
				# (try_for_range_backwards,<destination>,<lower_bound>,<upper_bound>),
###循环所有队伍
try_for_parties   = 11          # (try_for_parties,<destination>),
###循环所有agent
try_for_agents    = 12		# (try_for_agents,<destination>),

###只能在Script里使用，读取第一个参数
store_script_param_1 = 21       # (store_script_param_1,<destination>),  --(Within a script) stores the first script parameter.
###只能在Script里使用，读取第二个参数
store_script_param_2 = 22       # (store_script_param_2,<destination>),  --(Within a script) stores the second script parameter.
###只能在Script里使用，读取第<script_param_no>个参数，例：
###(store_script_param, ":size_x", 1), 读取参数1
###(store_script_param, ":size_y", 2), 读取参数2
store_script_param   = 23       # (store_script_param,<destination>,<script_param_no>), --(Within a script) stores <script_param_no>th script parameter.

#--------------------------------------------------------------------------
# CONDITION OPERATIONS
#--------------------------------------------------------------------------
###大于等于
ge           = 30  # greater than or equal to -- (ge,<value>,<value>),
###等于
eq           = 31  # equal to		      -- (eq,<value>,<value>),
###大于
gt           = 32  # greater than	      -- (gt,<value>,<value>),

###在两个之间
is_between   = 33  # (is_between,<value>,<lower_bound>,<upper_bound>), #greater than or equal to lower bound and less than upper bound

###进入城镇
entering_town   = 36 # (entering_town,<town_id>),
###在大地图上是自由的,就是说,如果你被人俘虏以及在旅馆睡觉都不符合此条件,此条以下的操作就不会被触发
map_free        = 37  # (map_free),
###遇到攻击,如果不是遇到攻击而是主动追上对方则此条以下的操作就不会被触发
encountered_party_is_attacker     = 39  # (encountered_party_is_attacker),
###在mission_template中判断是否在对话    #只能使用在module_mission_templates.py里
conversation_screen_is_active     = 42  # (conversation_screen_active), #used in mission template triggers only

###废弃的命令,不要使用
in_meta_mission = 44 # deprecated, do not use.

###让玩家操纵troop，troop不需要一定是NPC,可以为普通的兵种  
set_player_troop                = 47 # (set_player_troop,<troop_id>),

###储存重复对象                              格式: (store_repeat_object, <value>),# 储存重复的对话选项
###例:对话时以每个王国英雄为对象重复出现选项     
###在某个对话的条件里加上       
###     (store_repeat_object, ":troop_no"),
###     (troop_slot_eq, ":troop_no", slot_troop_occupation, slto_kingdom_hero),
###打下封地后出现的询问如何分封的对话中,分给每个领主的选项其实只是同一句对话,重复出现就是通过此条实现的.
store_repeat_object             = 50  # stores the index of a repeated dialog option for repeat_for_factions, etc...

###设置结果的字符串(显示的文字)
set_result_string               = 60  # sets the result string for game scripts that need one (set_result_string, <string_id>),

###按下特定按键，和key_clicked的区别在于主要用于一直按下某键，持续代码一直执行
###例:按下H键 (key_is_down, key_h),        [所有的key_按键都可以在header_triggers.py查到]
key_is_down                     = 70  # fails if the key is not currently down (key_is_down, <key_id>),

###按下并松开特定按键，主要用于判断按了一次按键，而不是一直按住某键。
###扩展:按下H键即补充满玩家的血  
###(key_clicked, key_h),
###(get_player_agent_no,":player"),
###(agent_set_hit_points,":player",100),
key_clicked                     = 71  # fails if the key is not clicked on the specific frame (key_clicked, <key_id>),

###按下游戏按键
###例:按下跳跃键 (game_key_is_down, gk_jump),    [所有的gk_按键都可以在header_triggers.py查到]
game_key_is_down                = 72  # fails if the game key is not currently down (key_is_down, <game_key_id>),

###按下并松开游戏按键
###扩展:跳跃即补充满玩家的血  
###(game_key_clicked, gk_jump), 
###(get_player_agent_no,":player"),
###(agent_set_hit_points,":player",100),
game_key_clicked                = 73  # fails if the game key is not clicked on the specific frame (key_clicked, <game_key_id>),

###获得鼠标在屏幕上的位置
mouse_get_position	             = 75  # (mouse_get_position, <position_no>), #x and y values of position are filled
###屏蔽一次序列号
omit_key_once                   = 77  # game omits any bound action for the key once (omit_key_once, <key_id>),
###清除屏蔽的序列号
clear_omitted_keys              = 78  # (clear_omitted_keys),

###获取雨数量
get_global_cloud_amount         = 90  # (get_global_cloud_amount, <destination>), #returns a value between 0-100
###设置雨数量
set_global_cloud_amount         = 91  # (set_global_cloud_amount, <value>), #value is clamped to 0-100
###获取雾数量
get_global_haze_amount          = 92  # (get_global_haze_amount, <destination>), #returns a value between 0-100
###设置雾数量
set_global_haze_amount          = 93  # (set_global_haze_amount, <value>), #value is clamped to 0-100

###检查NPC能否加入，[party_id]可以省略,省略则默认为玩家部队
hero_can_join                   = 101 # (hero_can_join, [party_id]),
###检查NPC能否作为俘虏加入，[party_id]可以省略,省略则默认为玩家部队
hero_can_join_as_prisoner       = 102 # (hero_can_join_as_prisoner, [party_id]),
###检查对话部队或对战部队能否加入到玩家部队
party_can_join                  = 103 # (party_can_join),
###检查对话部队或对战部队能否加入到玩家部队的俘虏列表
party_can_join_as_prisoner      = 104 # (party_can_join_as_prisoner),
###(玩家部队)有足够的空位
###例: (玩家部队)有15个以上的空位 (troops_can_join,15),
troops_can_join                 = 105 # (troops_can_join,<value>),
###(玩家部队)有足够的俘虏空位   格式: (troops_can_join_as_prisoner,数值),
###例: (玩家部队)有15个以上的俘虏空位       (troops_can_join_as_prisoner,15),
troops_can_join_as_prisoner     = 106 # (troops_can_join_as_prisoner,<value>),
###特定party(部队)有大于将加入party的人数的空位
###格式: (party_can_join_party, "将加入的party的ID", "接收的party的ID",数值0-1), 
###[最后的数值为0则不计算俘虏,为1则连同俘虏的数量一起计算是否有足够的俘虏空位]
party_can_join_party            = 107 # (party_can_join_party, <joiner_party_id>, <host_party_id>,[flip_prisoners]),
party_end_battle                = 108 # (party_end_battle,<party_no>),

###玩家部队拥有特定troop(兵种)              格式: (main_party_has_troop,"trp_兵种ID"),
###例:玩家部队拥有麽麽茶                    (main_party_has_troop,"trp_npc1"),
main_party_has_troop            = 110 # (main_party_has_troop,<troop_id>),
###特定party(部队)在特定城镇            格式: (party_is_in_town,"部队的ID","p_城镇的ID"),
###例:玩家部队在萨哥斯                  (party_is_in_town,"p_main_party","p_town_1"),
party_is_in_town                = 130 # (party_is_in_town,<party_id_1>,<party_id_2>),
###特定party(部队)在任何城镇         格式: (party_is_in_any_town,<party_id>),
###例:玩家部队在任意城镇             (party_is_in_any_town,"p_main_party"),
party_is_in_any_town            = 131 # (party_is_in_any_town,<party_id>),
###party(部队)是活跃的(在地图上含有实例的部队)   格式: (party_is_active,<party_id>),
party_is_active                 = 132 # (party_is_active,<party_id>),
###玩家拥有特定item(物品)                     格式: (player_has_item,"itm_物品ID"),
###例:玩家拥有战争之剑                         (player_has_item,"itm_sword_of_war"),
player_has_item                 = 150 # (player_has_item,<item_id>),
troop_has_item_equipped         = 151 # (troop_has_item_equipped,<troop_id>,<item_id>),
###特定troop(兵种)是骑兵      格式: (troop_is_mounted,"trp_兵种id"),
###例:职业杀手是骑兵          (troop_is_mounted,"trp_hired_blade"),
troop_is_mounted                = 152 # (troop_is_mounted,<troop_id>),
###特定troop(兵种)保障不等
troop_is_guarantee_ranged       = 153 # (troop_is_guarantee_ranged, <troop_id>),
###特定troop(兵种)保障马匹(一定骑马)  格式: (troop_is_guarantee_horse, trp_兵种id"),
###例:让职业杀手一定骑马              (troop_is_guarantee_horse, trp_hired_blade"),
troop_is_guarantee_horse        = 154 # (troop_is_guarantee_horse, <troop_id>),

###检查任务<quest_id>是否正在执行
check_quest_active              = 200 # (check_quest_active,<quest_id>),
###检查任务<quest_id>是否已经完成
check_quest_finished            = 201 # (check_quest_finished,<quest_id>),
###检查任务<quest_id>是否已经成功
check_quest_succeeded           = 202 # (check_quest_succeeded,<quest_id>),
###检查任务<quest_id>是否已经失败
check_quest_failed              = 203 # (check_quest_failed,<quest_id>),
###检查任务<quest_id>是否已经终止
check_quest_concluded           = 204 # (check_quest_concluded,<quest_id>),

###是否试验版本
is_trial_version                = 250 # (is_trial_version),
###编辑模式是否开启
is_edit_mode_enabled            = 255 # (is_edit_mode_enabled),

###获取玩家游戏难度
options_get_damage_to_player    = 260 # (options_get_damage_to_player, <destination>), #0 = 1/4, 1 = 1/2, 2 = 1/1
###设定玩家游戏难度
options_set_damage_to_player    = 261 # (options_set_damage_to_player, <value>), #0 = 1/4, 1 = 1/2, 2 = 1/1
###获取朋友游戏难度
options_get_damage_to_friends   = 262 # (options_get_damage_to_friends, <destination>), #0 = 1/2, 1 = 3/4, 2 = 1/1
###设定朋友游戏难度
options_set_damage_to_friends   = 263 # (options_set_damage_to_friends, <value>), #0 = 1/2, 1 = 3/4, 2 = 1/1
###获取战斗AI（0好 1正常 2不好）
options_get_combat_ai           = 264 # (options_get_combat_ai, <destination>), #0 = good, 1 = average, 2 = poor
###设置战斗AI（0好 1正常 2不好）
options_set_combat_ai           = 265 # (options_set_combat_ai, <value>), #0 = good, 1 = average, 2 = poor
###获取战役AI（0好 1正常 2不好）
options_get_campaign_ai         = 266 # (options_get_campaign_ai, <destination>), #0 = good, 1 = average, 2 = poor
###设置战役AI（0好 1正常 2不好）
options_set_campaign_ai         = 267 # (options_set_campaign_ai, <value>), #0 = good, 1 = average, 2 = poor
###获取战斗速度（0最慢 1慢 2 正常 3快速 4最快）
options_get_combat_speed        = 268 # (options_get_combat_speed, <destination>), #0 = slowest, 1 = slower, 2 = normal, 3 = faster, 4 = fastest
###设置战斗速度（0最慢 1慢 2 正常 3快速 4最快）
options_set_combat_speed        = 269 # (options_set_combat_speed, <value>), #0 = slowest, 1 = slower, 2 = normal, 3 = faster, 4 = fastest

###获取旗帜ID
profile_get_banner_id                = 350 # (profile_get_banner_id, <destination>),
###设置旗帜ID
profile_set_banner_id                = 351 # (profile_set_banner_id, <value>),

###获取成绩
get_achievement_stat                 = 370 # (get_achievement_stat, <destination>, <achievement_id>, <stat_index>),
###设置成绩
set_achievement_stat                 = 371 # (set_achievement_stat, <achievement_id>, <stat_index>, <value>),
###解锁成绩
unlock_achievement                   = 372 # (unlock_achievement, <achievement_id>),

###发送消息到网页
send_message_to_url                  = 380 # (send_message_to_url, <string_id>, <encode_url>), #result will be returned to script_game_receive_url_response



######################################联网命令
# multiplayer
multiplayer_send_message_to_server   = 388 # (multiplayer_send_int_to_server, <message_type>),
multiplayer_send_int_to_server       = 389 # (multiplayer_send_int_to_server, <message_type>, <value>),
multiplayer_send_2_int_to_server     = 390 # (multiplayer_send_2_int_to_server, <message_type>, <value>, <value>),
multiplayer_send_3_int_to_server     = 391 # (multiplayer_send_3_int_to_server, <message_type>, <value>, <value>, <value>),
multiplayer_send_4_int_to_server     = 392 # (multiplayer_send_4_int_to_server, <message_type>, <value>, <value>, <value>, <value>),
multiplayer_send_string_to_server    = 393 # (multiplayer_send_string_to_server, <message_type>, <string_id>),
multiplayer_send_message_to_player   = 394 # (multiplayer_send_message_to_player, <player_id>, <message_type>),
multiplayer_send_int_to_player       = 395 # (multiplayer_send_int_to_player, <player_id>, <message_type>, <value>),
multiplayer_send_2_int_to_player     = 396 # (multiplayer_send_2_int_to_player, <player_id>, <message_type>, <value>, <value>),
multiplayer_send_3_int_to_player     = 397 # (multiplayer_send_3_int_to_player, <player_id>, <message_type>, <value>, <value>, <value>),
multiplayer_send_4_int_to_player     = 398 # (multiplayer_send_4_int_to_player, <player_id>, <message_type>, <value>, <value>, <value>, <value>),
multiplayer_send_string_to_player    = 399 # (multiplayer_send_string_to_player, <player_id>, <message_type>, <string_id>),
get_max_players                      = 400 # (get_max_players, <destination>),
player_is_active                     = 401 # (player_is_active, <player_id>),
player_get_team_no                   = 402 # (player_get_team_no,  <destination>, <player_id>),
player_set_team_no                   = 403 # (player_get_team_no,  <destination>, <player_id>),
player_get_troop_id                  = 404 # (player_get_troop_id, <destination>, <player_id>),
player_set_troop_id                  = 405 # (player_get_troop_id, <destination>, <player_id>),
player_get_agent_id                  = 406 # (player_get_agent_id, <destination>, <player_id>),
player_get_gold                      = 407 # (player_get_gold, <destination>, <player_id>),
player_set_gold                      = 408 # (player_set_gold, <player_id>, <value>, <max_value>), #set max_value to 0 if no limit is wanted
player_spawn_new_agent               = 409 # (player_spawn_new_agent, <player_id>, <entry_point>),
player_add_spawn_item                = 410 # (player_add_spawn_item, <player_id>, <item_slot_no>, <item_id>),
multiplayer_get_my_team              = 411 # (multiplayer_get_my_team, <destination>),
multiplayer_get_my_troop             = 412 # (multiplayer_get_my_troop, <destination>),
multiplayer_set_my_troop             = 413 # (multiplayer_get_my_troop, <destination>),
multiplayer_get_my_gold              = 414 # (multiplayer_get_my_gold, <destination>),
multiplayer_get_my_player            = 415 # (multiplayer_get_my_player, <destination>),
multiplayer_clear_scene              = 416 # (multiplayer_clear_scene),
multiplayer_is_server                = 417 # (multiplayer_is_server),
multiplayer_is_dedicated_server      = 418 # (multiplayer_is_dedicated_server),
game_in_multiplayer_mode             = 419 # (game_in_multiplayer_mode),
multiplayer_make_everyone_enemy      = 420 # (multiplayer_make_everyone_enemy),
player_control_agent                 = 421 # (player_control_agent, <player_id>, <agent_id>),
player_get_item_id                   = 422 # (player_get_item_id, <destination>, <player_id>, <item_slot_no>) #only for server
player_get_banner_id                 = 423 # (player_get_banner_id, <destination>, <player_id>),
###获取战役难度ai
game_get_reduce_campaign_ai          = 424 # (game_get_reduce_campaign_ai, <destination>), #depreciated, use options_get_campaign_ai instead
multiplayer_find_spawn_point         = 425 # (multiplayer_find_spawn_point, <destination>, <team_no>, <examine_all_spawn_points>, <is_horseman>), 
set_spawn_effector_scene_prop_kind   = 426 # (set_spawn_effector_scene_prop_kind <team_no> <scene_prop_kind_no>)
set_spawn_effector_scene_prop_id     = 427 # (set_spawn_effector_scene_prop_id <scene_prop_id>)

player_set_is_admin                  = 429 # (player_set_is_admin, <player_id>, <value>), #value is 0 or 1
player_is_admin                      = 430 # (player_is_admin, <player_id>),
player_get_score                     = 431 # (player_get_score, <destination>, <player_id>),
player_set_score                     = 432 # (player_set_score,<player_id>, <value>),
player_get_kill_count                = 433 # (player_get_kill_count, <destination>, <player_id>),
player_set_kill_count                = 434 # (player_set_kill_count,<player_id>, <value>),
player_get_death_count               = 435 # (player_get_death_count, <destination>, <player_id>),
player_set_death_count               = 436 # (player_set_death_count, <player_id>, <value>),
player_get_ping                      = 437 # (player_get_ping, <destination>, <player_id>),
player_is_busy_with_menus            = 438 # (player_is_busy_with_menus, <player_id>),
player_get_is_muted                  = 439 # (player_get_is_muted, <destination>, <player_id>),
player_set_is_muted                  = 440 # (player_set_is_muted, <player_id>, <value>, [mute_for_everyone]), #mute_for_everyone optional parameter should be set to 1 if player is muted for everyone (this works only on server).
player_get_unique_id                 = 441 # (player_get_unique_id, <destination>, <player_id>), #can only bew used on server side
player_get_gender                    = 442 # (player_get_gender, <destination>, <player_id>),

team_get_bot_kill_count              = 450 # (team_get_bot_kill_count, <destination>, <team_id>),
team_set_bot_kill_count              = 451 # (team_get_bot_kill_count, <destination>, <team_id>),
team_get_bot_death_count             = 452 # (team_get_bot_death_count, <destination>, <team_id>),
team_set_bot_death_count             = 453 # (team_get_bot_death_count, <destination>, <team_id>),
team_get_kill_count                  = 454 # (team_get_kill_count, <destination>, <team_id>),
team_get_score                       = 455 # (team_get_score, <destination>, <team_id>),
team_set_score                       = 456 # (team_set_score, <team_id>, <value>),
team_set_faction                     = 457 # (team_set_faction, <team_id>, <faction_id>),
team_get_faction                     = 458 # (team_get_faction, <destination>, <team_id>),
player_save_picked_up_items_for_next_spawn  = 459 # (player_save_picked_up_items_for_next_spawn, <player_id>),
player_get_value_of_original_items   = 460 # (player_get_value_of_original_items, <player_id>), #this operation returns values of the items, but default troop items will be counted as zero (except horse)
player_item_slot_is_picked_up        = 461 # (player_item_slot_is_picked_up, <player_id>, <item_slot_no>), #item slots are overriden when player picks up an item and stays alive until the next round

kick_player                          = 465 # (kick_player, <player_id>),
ban_player                           = 466 # (ban_player, <player_id>, <value>, <player_id>), #set value = 1 for banning temporarily, assign 2nd player id as the administrator player id if banning is permanent
save_ban_info_of_player              = 467 # (save_ban_info_of_player, <player_id>),
ban_player_using_saved_ban_info      = 468 # (ban_player_using_saved_ban_info),

start_multiplayer_mission            = 470 # (start_multiplayer_mission, <mission_template_id>, <scene_id>, <started_manually>),

server_add_message_to_log            = 473 # (server_add_message_to_log, <string_id>),

server_get_renaming_server_allowed   = 475 # (server_get_renaming_server_allowed, <destination>), #0-1
server_get_changing_game_type_allowed= 476 # (server_get_changing_game_type_allowed, <destination>), #0-1
##477 used for: server_set_anti_cheat                = 477 # (server_set_anti_cheat, <value>), #0 = off, 1 = on
server_get_combat_speed              = 478 # (server_get_combat_speed, <destination>), #0-2
server_set_combat_speed              = 479 # (server_set_combat_speed, <value>), #0-2
server_get_friendly_fire             = 480 # (server_get_friendly_fire, <destination>),
server_set_friendly_fire             = 481 # (server_set_friendly_fire, <value>), #0 = off, 1 = on
server_get_control_block_dir         = 482 # (server_get_control_block_dir, <destination>),
server_set_control_block_dir         = 483 # (server_set_control_block_dir, <value>), #0 = automatic, 1 = by mouse movement
server_set_password                  = 484 # (server_set_password, <string_id>),
server_get_add_to_game_servers_list  = 485 # (server_get_add_to_game_servers_list, <destination>),
server_set_add_to_game_servers_list  = 486 # (server_set_add_to_game_servers_list, <value>),
server_get_ghost_mode                = 487 # (server_get_ghost_mode, <destination>),
server_set_ghost_mode                = 488 # (server_set_ghost_mode, <value>),
server_set_name                      = 489 # (server_set_name, <string_id>),
server_get_max_num_players           = 490 # (server_get_max_num_players, <destination>),
server_set_max_num_players           = 491 # (server_set_max_num_players, <value>),
server_set_welcome_message           = 492 # (server_set_welcome_message, <string_id>),
server_get_melee_friendly_fire       = 493 # (server_get_melee_friendly_fire, <destination>),
server_set_melee_friendly_fire       = 494 # (server_set_melee_friendly_fire, <value>), #0 = off, 1 = on
server_get_friendly_fire_damage_self_ratio   = 495 # (server_get_friendly_fire_damage_self_ratio, <destination>),
server_set_friendly_fire_damage_self_ratio   = 496 # (server_set_friendly_fire_damage_self_ratio, <value>), #0-100
server_get_friendly_fire_damage_friend_ratio = 497 # (server_get_friendly_fire_damage_friend_ratio, <destination>),
server_set_friendly_fire_damage_friend_ratio = 498 # (server_set_friendly_fire_damage_friend_ratio, <value>), #0-100
server_get_anti_cheat                = 499 # (server_get_anti_cheat, <destination>),
server_set_anti_cheat                = 477 # (server_set_anti_cheat, <value>), #0 = off, 1 = on
###############################联网命令结束



#########下面是关于slot的操作.每个小块都有8个函数,其实作用类似,只是所针对的对象的类型不一样
###troop开头的是针对兵种类型的.
###party开头的是针对城堡,城镇,村子等建筑物类型的.
###faction开头的是针对阵营的.
###scene开头的是针对场景的.
###party_template开头的是针对大地图上的部队的.
###agent开头的是针对战场里人(和马?)的.
###quest开头的是针对任务的.
###item开头是是针对物品的.

## Set_slot operations. These assign a value to a slot. 
### 设置slot的操作,下面这些将把一个值赋给对象的相应slot.
troop_set_slot                  = 500 # (troop_set_slot,<troop_id>,<slot_no>,<value>),
party_set_slot                  = 501 # (party_set_slot,<party_id>,<slot_no>,<value>),
faction_set_slot                = 502 # (faction_set_slot,<faction_id>,<slot_no>,<value>),
scene_set_slot                  = 503 # (scene_set_slot,<scene_id>,<slot_no>,<value>),
party_template_set_slot         = 504 # (party_template_set_slot,<party_template_id>,<slot_no>,<value>),
agent_set_slot                  = 505 # (agent_set_slot,<agent_id>,<slot_no>,<value>),
quest_set_slot                  = 506 # (quest_set_slot,<quest_id>,<slot_no>,<value>),
item_set_slot                   = 507 # (item_set_slot,<item_id>,<slot_no>,<value>),
player_set_slot                 = 508 # (player_set_slot,<player_id>,<slot_no>,<value>),
team_set_slot                   = 509 # (team_set_slot,<team_id>,<slot_no>,<value>),
scene_prop_set_slot             = 510 # (scene_prop_set_slot,<scene_prop_instance_id>,<slot_no>,<value>),

## Get_slot operations. These retrieve the value of a slot. 
### 设置slot的操作,下面这些将把一个值赋给对象的相应slot.
troop_get_slot                  = 520 # (troop_get_slot,<destination>,<troop_id>,<slot_no>),
party_get_slot                  = 521 # (party_get_slot,<destination>,<party_id>,<slot_no>),
faction_get_slot                = 522 # (faction_get_slot,<destination>,<faction_id>,<slot_no>),
scene_get_slot                  = 523 # (scene_get_slot,<destination>,<scene_id>,<slot_no>),
party_template_get_slot         = 524 # (party_template_get_slot,<destination>,<party_template_id>,<slot_no>),
agent_get_slot                  = 525 # (agent_get_slot,<destination>,<agent_id>,<slot_no>),
quest_get_slot                  = 526 # (quest_get_slot,<destination>,<quest_id>,<slot_no>),
item_get_slot                   = 527 # (item_get_slot,<destination>,<item_id>,<slot_no>),
player_get_slot                 = 528 # (player_get_slot,<destination>,<player_id>,<slot_no>),
team_get_slot                   = 529 # (team_get_slot,<destination>,<player_id>,<slot_no>),
scene_prop_get_slot             = 530 # (scene_prop_get_slot,<destination>,<scene_prop_instance_id>,<slot_no>),

## slot_eq operations. These check whether the value of a slot is equal to a given value.
### 判断对象相应slot里的值与给定的值是否相等的操作
troop_slot_eq                   = 540 # (troop_slot_eq,<troop_id>,<slot_no>,<value>),
party_slot_eq                   = 541 # (party_slot_eq,<party_id>,<slot_no>,<value>),
faction_slot_eq                 = 542 # (faction_slot_eq,<faction_id>,<slot_no>,<value>),
scene_slot_eq                   = 543 # (scene_slot_eq,<scene_id>,<slot_no>,<value>),
party_template_slot_eq          = 544 # (party_template_slot_eq,<party_template_id>,<slot_no>,<value>),
agent_slot_eq                   = 545 # (agent_slot_eq,<agent_id>,<slot_no>,<value>),
quest_slot_eq                   = 546 # (quest_slot_eq,<quest_id>,<slot_no>,<value>),
item_slot_eq                    = 547 # (item_slot_eq,<item_id>,<slot_no>,<value>),
player_slot_eq                  = 548 # (player_slot_eq,<player_id>,<slot_no>,<value>),
team_slot_eq                    = 549 # (team_slot_eq,<team_id>,<slot_no>,<value>),
scene_prop_slot_eq              = 550 # (scene_prop_slot_eq,<scene_prop_instance_id>,<slot_no>,<value>),

## slot_ge operations. These check whether the value of a slot is greater than or equal to a given value.
### 判断对象相应slot里的值是否大于或等于给定的值的操作
troop_slot_ge                   = 560 # (troop_slot_ge,<troop_id>,<slot_no>,<value>),
party_slot_ge                   = 561 # (party_slot_ge,<party_id>,<slot_no>,<value>),
faction_slot_ge                 = 562 # (faction_slot_ge,<faction_id>,<slot_no>,<value>),
scene_slot_ge                   = 563 # (scene_slot_ge,<scene_id>,<slot_no>,<value>),
party_template_slot_ge          = 564 # (party_template_slot_ge,<party_template_id>,<slot_no>,<value>),
agent_slot_ge                   = 565 # (agent_slot_ge,<agent_id>,<slot_no>,<value>),
quest_slot_ge                   = 566 # (quest_slot_ge,<quest_id>,<slot_no>,<value>),
item_slot_ge                    = 567 # (item_slot_ge,<item_id>,<slot_no>,<value>),
player_slot_ge                  = 568 # (player_slot_ge,<player_id>,<slot_no>,<value>),
team_slot_ge                    = 569 # (team_slot_ge,<team_id>,<slot_no>,<value>),
scene_prop_slot_ge              = 570 # (scene_prop_slot_ge,<scene_prop_instance_id>,<slot_no>,<value>),


###########################音乐声效命令
###播放音效在坐标
play_sound_at_position          = 599 # (play_sound_at_position, <sound_id>, <position_no>, [options]),
###播放音效
play_sound                      = 600 # (play_sound,<sound_id>,[options]),
###播放音乐
play_track                      = 601 # (play_track,<track_id>, [options]), # 0 = default, 1 = fade out current track, 2 = stop current track
###立即播放特定音乐
###例:立即播放 "宁静的夜晚" 音乐(原版的calm_night_2.ogg)        (play_cue_track,"track_calm_night_2"),
play_cue_track                  = 602 # (play_cue_track,<track_id>), #starts immediately
###音乐设置情况
music_set_situation             = 603 # (music_set_situation, <situation_type>),
###音乐设置文化
music_set_culture               = 604 # (music_set_culture, <culture_type>),
###停止所有的声音 [options]0 = 默认方法?, 1 = 淡出, 2 = 直接卡掉
stop_all_sounds                 = 609 # (stop_all_sounds, [options]), # 0 = stop only looping sounds, 1 = stop all sounds
###保存最后音效频道
store_last_sound_channel        = 615 # (store_last_sound_channel, <destination>),
###停止音效频道
stop_sound_channel              = 616 # (stop_sound_channel, <sound_channel_no>),


#########################坐标相关命令
###复制坐标
copy_position                   = 700 # copies position_no_2 to position_no_1
				      # (copy_position,<position_no_1>,<position_no_2>),
###初始化坐标
init_position                   = 701 # (init_position,<position_no>),
###获取触发器对象坐标
get_trigger_object_position     = 702 # (get_trigger_object_position,<position_no>),

###获取两点间的角度
get_angle_between_positions     = 705 # (get_angle_between_positions, <destination_fixed_point>, <position_no_1>, <position_no_2>),

###坐标到坐标画线？
position_has_line_of_sight_to_position = 707 # (position_has_line_of_sight_to_position, <position_no_1>, <position_no_2>),

###获得两点间的距离
get_distance_between_positions  = 710 # gets distance in centimeters. # (get_distance_between_positions,<destination>,<position_no_1>,<position_no_2>),
###获得两点间的距离，单位为米
get_distance_between_positions_in_meters  = 711 # gets distance in meters. # (get_distance_between_positions_in_meters,<destination>,<position_no_1>,<position_no_2>),
###获取两点间距离的平方
get_sq_distance_between_positions = 712 # gets squared distance in centimeters # (get_sq_distance_between_positions,<destination>,<position_no_1>,<position_no_2>),
###获得两点间的距离的平方，单位为米
get_sq_distance_between_positions_in_meters = 713 # gets squared distance in meters # (get_sq_distance_between_positions_in_meters,<destination>,<position_no_1>,<position_no_2>),

### 判断<position_no_1>在<position_no_2>后面
position_is_behind_position     = 714 # (position_is_behind_position,<position_no_1>,<position_no_2>),
###获得两点间的海拔距离平方
get_sq_distance_between_position_heights = 715 # gets squared distance in centimeters # (get_sq_distance_between_position_heights,<destination>,<position_no_1>,<position_no_2>),

###改变坐标起点
position_transform_position_to_parent = 716 # (position_transform_position_to_parent,<dest_position_no>,<position_no>,<position_no_to_be_transformed>),
###改变局部坐标
position_transform_position_to_local  = 717 # (position_transform_position_to_local, <dest_position_no>,<position_no>,<position_no_to_be_transformed>),

###复制坐标角度
position_copy_rotation          = 718 # (position_copy_rotation,<position_no_1>,<position_no_2>), copies rotation of position_no_2 to position_no_1
###复制坐标起点
position_copy_origin            = 719 # (position_copy_origin,<position_no_1>,<position_no_2>), copies origin of position_no_2 to position_no_1

###这部分是位置坐标的移动 <movement>是按厘米来计算的, [value]的值[0 = 在本地坐标上操作; 1=在全局坐标]
position_move_x                 = 720 # movement is in cms, [0 = local; 1=global]
				      # (position_move_x,<position_no>,<movement>,[value]),
position_move_y                 = 721 # (position_move_y,<position_no>,<movement>,[value]),
position_move_z                 = 722 # (position_move_z,<position_no>,<movement>,[value]),

###这部分是位置坐标的旋转,<angle>是角度
position_rotate_x               = 723 # (position_rotate_x,<position_no>,<angle>),
position_rotate_y               = 724 # (position_rotate_y,<position_no>,<angle>),
position_rotate_z               = 725 # (position_rotate_z,<position_no>,<angle>,[use_global_z_axis]), # set use_global_z_axis as 1 if needed, otherwise you don't have to give that.

###这部分是位置坐标的位置分量的读取,返回值要被修整成标准的单位,才有意义
position_get_x                  = 726 # (position_get_x,<destination_fixed_point>,<position_no>), #x position in meters * fixed point multiplier is returned
position_get_y                  = 727 # (position_get_y,<destination_fixed_point>,<position_no>), #y position in meters * fixed point multiplier is returned
position_get_z                  = 728 # (position_get_z,<destination_fixed_point>,<position_no>), #z position in meters * fixed point multiplier is returned

###这部分是位置坐标的位置分量的设置,设定值值要乘以修正值才有意义
position_set_x                  = 729 # (position_set_x,<position_no>,<value_fixed_point>), #meters / fixed point multiplier is set
position_set_y                  = 730 # (position_set_y,<position_no>,<value_fixed_point>), #meters / fixed point multiplier is set
position_set_z                  = 731 # (position_set_z,<position_no>,<value_fixed_point>), #meters / fixed point multiplier is set

###这部分是位置坐标的尺度分量的读取,也就是比例尺
position_get_scale_x            = 735 # (position_get_scale_x,<destination_fixed_point>,<position_no>), #x scale in meters * fixed point multiplier is returned
position_get_scale_y            = 736 # (position_get_scale_y,<destination_fixed_point>,<position_no>), #y scale in meters * fixed point multiplier is returned
position_get_scale_z            = 737 # (position_get_scale_z,<destination_fixed_point>,<position_no>), #z scale in meters * fixed point multiplier is returned

###坐标x轴和y轴旋转浮点数
position_rotate_x_floating      = 738 # (position_rotate_x_floating,<position_no>,<angle>), #angle in degree * fixed point multiplier 
position_rotate_y_floating      = 739 # (position_rotate_y_floating,<position_no>,<angle>), #angle in degree * fixed point multiplier 

###获取坐标旋转z轴返回角度
position_get_rotation_around_z  = 740 # (position_get_rotation_around_z,<destination>,<position_no>), #rotation around z axis is returned as angle
###坐标起点标准化
position_normalize_origin       = 741 # (position_normalize_origin,<destination_fixed_point>,<position_no>),
                                                                      # destination = convert_to_fixed_point(length(position.origin)) 指定=旋转到固定点(长度(起点))
                                                                      # position.origin *= 1/length(position.origin) #so it normalizes the origin vector恢复正常，原点矢量

###获取坐标旋转x轴返回角度
position_get_rotation_around_x  = 742 # (position_get_rotation_around_x, <destination>, <position_no>), #rotation around x axis is returned as angle
###获取坐标旋转y轴返回角度
position_get_rotation_around_y  = 743 # (position_get_rotation_around_y, <destination>, <position_no>), #rotation around y axis is returned as angle


###这部分是位置坐标的尺度分量的设定
position_set_scale_x            = 744 # (position_set_scale_x, <position_no>, <value_fixed_point>), #x scale in meters / fixed point multiplier is set
position_set_scale_y            = 745 # (position_set_scale_y, <position_no>, <value_fixed_point>), #y scale in meters / fixed point multiplier is set
position_set_scale_z            = 746 # (position_set_scale_z, <position_no>, <value_fixed_point>), #z scale in meters / fixed point multiplier is set

###获取屏幕设计坐标
position_get_screen_projection  = 750 # (position_get_screen_projection, <position_no_1>, <position_no_2>), returns screen projection of position_no_2 to position_no_1

###设置z到地面水平线
position_set_z_to_ground_level  = 791 # (position_set_z_to_ground_level, <position_no>), #only works during a mission
###获取地面距离，只能在一个触发器
position_get_distance_to_terrain= 792 # (position_get_distance_to_terrain, <destination>, <position_no>), #only works during a mission
###获取地面水平线距离，只能在一个触发器
position_get_distance_to_ground_level = 793 # (position_get_distance_to_ground_level, <destination>, <position_no>), #only works during a mission



#######################背景按钮相关命令
#功能：用来启动presentation的命令。
#格式：(start_presentation, "prsnt_battle"),　
#说明："prsnt_battle"是需要启动的presentation的id。"prsnt"是必需的前缀，"battle"是其在presentations.py中的id名称（战场小地图）。
#说明2：两个不同id的presentation不能被同时启动，即启动后一个时前一个会自动关闭。
start_presentation		                      = 900 # (start_presentation, <presentation_id>),

#功能：只能在game_menus.py中使用，从字面意思看就是用一个presentation来当作菜单的背景。
#格式：(start_background_presentation, "prsnt_background"),　
#问题：搞这么麻烦~我直接把背景的贴图改掉不就得了？
#回答：利用这个可以更灵活的控制背景图案的变化，甚至可以为菜单做一个动态的背景图。
start_background_presentation	            = 901 # (start_background_presentation, <presentation_id>), #can only be used in game menus

#功能：设置当前presentation的运行时间。
#格式：(presentation_set_duration, 999999), 
#说明：时间单位为百分之一秒。特殊的操作是将时间设为0，则会立即停止当前的presentation。一般情况下这个时间都设置为一个较大的值如999999，必要时利用0值的设置即可关闭之。
presentation_set_duration	                = 902 # (presentation_set_duration, <duration-in-1/100-seconds>), #there must be an active presentation

###检测presentation是否已经启动激活
is_presentation_active                    = 903 # (is_presentation_active, <presentation_id),

#功能：建立一个文本对象
#格式：(create_text_overlay, reg1, "str_sample_banner", tf_center_justify),
#说明：当前创建的对象在presentation中的id会储存在reg1中，也可以使用自定的全局变量"$xxx"代替reg1。"str_sample_banner"是文字的内容，也可以使用如"@...."这样的快捷字符串，或者事先将文字内容存在诸如"s1"等此类字符串变量中在这里直接调用s1。
#tf_center_justify为文字的排版格式，详见第二部分
create_text_overlay	                      = 910 # (create_text_overlay, <destination>, <string_id>), #returns overlay id

#功能：建立一个网格（模型）对象。
#格式：(create_mesh_overlay, reg1, "mesh_flag_infantry"),
#说明：创建的对象id储存在reg1中。 "mesh_flag_infantry"是所用的mesh，需要事先在module_meshes.py做好定义。不确定是否支持带有骨骼的mesh，这个我没试过。
create_mesh_overlay		                     = 911 # (create_mesh_overlay, <destination>, <mesh_id>), #returns overlay id

#功能：建立一个文本按钮。
#格式：(create_button_overlay, reg1 , "@Next Page", tf_center_justify),
#说明：创建的按钮对象id储存在reg1中。这样的按钮在鼠标滑过时会高亮显示，点击可以触发关联内容，本文第二部分会详细介绍。
create_button_overlay                     = 912 # (create_button_overlay, <destination>, <string_id>), #returns overlay id

#功能：建立一个图形按钮。
#格式：(create_image_button_overlay, reg1, "mesh_banner_1", "mesh_banner_1_down"),
#说明：创建的按钮对象id储存在reg1中。"mesh_banner_1"为所用的mesh，"mesh_banner_1_down"是当点击此按钮时替换显示的mesh以表现按钮下沉的效果。两处也可以使用相同的mesh。和上面的create_button_overlay同样都能生成一个button，不同的是这里用图形代替了文字当作按钮。例如挑选旗帜时那些旗帜的图案都是image_button
create_image_button_overlay	              = 913 # (create_image_button_overlay, <destination>, <mesh_id>, <mesh_id>), #returns overlay id. second mesh is the pressed button mesh

#功能：建立一个滑动条。
#格式： (create_slider_overlay, reg1, 0, 100),
#说明：滑动条对象id储存在reg1中，0是滑动条最左端的值（最小），100是最右端的值（最大）。如编辑人物脸型时那些滑动条。
create_slider_overlay                     = 914 # (create_slider_overlay, <destination>, <min_value>, <max_value>), #returns overlay id

#功能：建立一个进度条，如开始游戏读取数据时的进度条。
#格式：(create_progress_overlay, reg1, 0, 100),　
#说明：同create_slider_overlay
create_progress_overlay		                 = 915 # (create_progress_overlay, <destination>, <min_value>, <max_value>), #returns overlay id

#功能：创建一个下拉多选框
create_combo_button_overlay              	= 916 # (create_combo_button_overlay, <destination>), #returns overlay id

#功能：创建一个文本的输入框，例如创建角色时用于输入玩家名字的那个文本框
create_text_box_overlay                   = 917 # (create_text_box_overlay, <destination>), #returns overlay id

#功能：建立一个选择块。
#格式：(create_check_box_overlay, reg1, "mesh_checkbox_off", "mesh_checkbox_on"),
#说明：选择块对象id储存在reg1中，"mesh_checkbox_off"是未被选中时的mesh，"mesh_checkbox_on"是被选中后的mesh。两个mesh可以相同，但为了方便区别其状态还是用不同的mesh吧。
create_check_box_overlay                  = 918 # (create_check_box_overlay, <destination>), #returns overlay id
create_simple_text_box_overlay            = 919 # (create_simple_text_box_overlay, <destination>), #returns overlay id

#功能：还没用过，应该是给某已经创建的对象贴上文字。
#格式：(overlay_set_text, reg1, "str_wc"),
#说明：reg1是目标对象的id，"str_wc"是文字内容。
overlay_set_text	                        	= 920 # (overlay_set_text, <overlay_id>, <string_id>),

#功能：为指定对象设置颜色。
#格式：(overlay_set_color, "$flag", 0xff0000), 
#说明："$flag"是目标对象的id，0xff0000是16进制的颜色单位，当前为红色。本帖后面会附上一个简单的16进制色码表方便大家查色。如果你有photoshop，点击工具栏下端的颜色块打开调色框，调色框下方就有当前颜色的16进制码。
#特别注意：如果给mesh对象设置颜色，则该mesh在brfedit中mat选项卡里的shader类型和下方那些勾选项必须是特定类型。这方面我不太熟悉，根据自己的经验，只发现了simple_shader＋201326593的组合可以被overlay_set_color应用颜色，其它设置还没成功过。如果你有自己的发现，请跟帖说明，谢谢分享。见注①。
overlay_set_color	                       	= 921 # (overlay_set_color, <overlay_id>, <color>), #color in RGB format like 0xRRGGBB (put hexadecimal values for RR GG and BB parts)

#功能：为指定对象设置alpha值。alpha值得两个极端为0x00（对象完全消失）和0xff（对象完全显示）
#格式： (overlay_set_alpha, "$flag", 0xff), 
#说明："$flag"为目标对象id，0xff为alpha值（完全显示）
#特别注意：和overlay_set_color一样，同样需要特别注意的是如果应用对象是mesh，该mesh必须有特定的设置，否则功能无效。见注①。
overlay_set_alpha                         = 922 # (overlay_set_alpha, <overlay_id>, <alpha>), #alpha in A format like 0xAA (put hexadecimal values for AA part)

#功能：没有仔细测试过效果，看字面意思就是给指定的对象设置高光色彩
#格式：(overlay_set_hilight_color, "$flag",0xff0000), 
#说明："$flag"为目标对象id，0xff0000高光颜色
overlay_set_hilight_color	                = 923 # (overlay_set_hilight_color, <overlay_id>, <color>), #color in RGB format like 0xRRGGBB (put hexadecimal values for RR GG and BB parts)

#功能：同上没有测试过效果，字面意思是给指定的对象设置高光alpha值（透明色）
#格式： (overlay_set_hilight_alpha, "$flag", 0xff), 
#说明："$flag"为目标对象id，0xff为alpha值
overlay_set_hilight_alpha                 = 924 # (overlay_set_hilight_alpha, <overlay_id>, <alpha>), #alpha in A format like 0xAA (put hexadecimal values for AA part)

#功能：设置对象尺寸
#格式：(overlay_set_size, reg1, pos1), 
#说明：reg1是目标对象的id，pos1的x,y坐标值为该目标对象在屏幕中的宽和高。通常在overlay_set_size之前会先用(position_set_x, pos1, 100),(position_set_y, pos1, 100),来设置需要的宽和高。
#说明2：这种缩放是以目标对象的几何中心为原点行进的，当对象的size发生变化时其自身原点所在位置也会改变。
#求助：关于度量的单位我也有点拿不准，似乎是像素点。视平面的左下角是坐标原点，x轴坐标值向右增大，y轴坐标值向上增大。反向则为负值。整个视平面的宽和高似乎是1000x1000，但有时又比较小像是800x800的。这里我的确还比较晕，还在靠不断目测来调整定位对象。请各位路过的高手暂停锻炼 指点迷津！
overlay_set_size		                        = 925 # (overlay_set_size, <overlay_id>, <position_no>), #position's x and y values are used

#功能：设置对象在视平面中的位置，会使指定对象的原点和pos1重叠。
#格式：(overlay_set_position, reg1, pos1), 
#说明：reg1是目标对象的id，其原点位置在创建此模型时的全局坐标原点。pos1的x,y坐标值对应视平面上的坐标位置。
overlay_set_position                     	= 926 # (overlay_set_position, <overlay_id>, <position_no>), #position's x and y values are used

#功能：设置对象的值，只用于sliders, combo buttons和check boxes
#格式：(overlay_set_val, reg1, 0),
#说明：reg1是目标对象的id。0是当前设置的值，以目标对象的取值范围为准。
overlay_set_val                          	= 927 # (overlay_set_val, <overlay_id>, <value>), #can be used for sliders, combo buttons and check boxes

#功能：没用过，效果不明。
#格式：(overlay_set_boundaries, reg1, 0, 100),
#说明：reg1是目标对象的id，0是最小值，100是最大值。
overlay_set_boundaries                   	= 928 # (overlay_set_boundaries, <overlay_id>, <min_value>, <max_value>),

#功能：没用过效果不明。
#格式：(overlay_set_area_size, reg1, pos1), 
#说明：pos1的x,y坐标值为设定的宽和高。
overlay_set_area_size                   		= 929 # (overlay_set_area_size, <overlay_id>, <position_no>), #position's x and y values are used

#功能：旋转目标对象
#格式：(overlay_set_mesh_rotation, “$fan”, pos1), 
#说明： “$fan”为目标对象id，pos1的x,y,z均可作为旋转轴。
#说明2：通常需要在之前用比如(position_rotate_x,pos1,30),来在对应坐标轴上旋转pos1，30是旋转的角度。这样当使用(overlay_set_mesh_rotation, “$fan”, pos1), 之后，"$fan”就会以自己的x坐标轴为轴旋转30度。
overlay_set_mesh_rotation                 = 930 # (overlay_set_mesh_rotation, <overlay_id>, <position_no>), #position's rotation values are used for rotations around x, y and z axis

#功能：给下拉菜单添加选项。
#格式： (overlay_add_item, "$house", "str_wc"), 
#说明："$house"是目标对象的id，"str_wc"是文字内容。
overlay_add_item	                         = 931 # (overlay_add_item, <overlay_id>, <string_id>), # adds an item to the combo box

#功能：使指定对象在指定时间内渐变到指定颜色，动画效果。
#格式：(overlay_animate_to_color, reg1, 1000, 0xff0000),
#说明：reg1是目标对象的id。1000是花费时间，单位为1/1000秒，即当前为1秒。0xff0000是最终变化到的颜色。
#特别注意：如果对象是mesh，需要有特定的shader和勾选项设置，否则变色指令无效。
overlay_animate_to_color                  = 932 # (overlay_animate_to_color, <overlay_id>, <duration-in-1/1000-seconds>, <color>), #alpha value will not be used

#功能：使指定对象在指定时间内渐变其alpha值。动画效果。
#格式：(overlay_animate_to_alpha, reg1, 1000, 0x00),
#说明：reg1是目标对象的id。1000是花费时间，单位为1/1000秒，即当前为1秒。0x00是最终渐变到的alpha值，0x00为全部隐藏，指定对象会失去光泽变为全黑。0xff为全部显示，指定对象色彩饱满。
#特别注意：如果对象是mesh，需要有特定的shader和勾选项设置，否则变色指令无效。
overlay_animate_to_alpha	                 = 933 # (overlay_animate_to_alpha, <overlay_id>, <duration-in-1/1000-seconds>, <color>), #only alpha value will be used

#功能：使指定对象在指定时间内渐变到高亮色彩。动画效果。
#格式：(overlay_animate_to_highlight_color, reg1, 1000, 0xff0000),
#说明：reg1是目标对象的id。1000是花费时间，单位为1/1000秒，即当前为1秒。
#特别注意：如果对象是mesh，需要有特定的shader和勾选项设置，否则变色指令无效。
overlay_animate_to_highlight_color        = 934 # (overlay_animate_to_highlight_color, <overlay_id>, <duration-in-1/1000-seconds>, <color>), #alpha value will not be used

#功能：使指定对象在指定时间内渐变高光alpha值（透明色）。动画效果。
#格式：(overlay_animate_to_highlight_alpha, reg1, 1000, 0x00),
#说明：reg1是目标对象的id。1000是花费时间，单位为1/1000秒，即当前为1秒。
#特别注意：如果对象是mesh，需要有特定的shader和勾选项设置，否则变色指令无效。
overlay_animate_to_highlight_alpha        = 935 # (overlay_animate_to_highlight_alpha, <overlay_id>, <duration-in-1/1000-seconds>, <color>), #only alpha value will be used

#功能：使指定对象在指定时间内渐变到指定大小。动画效果。
#格式：(overlay_animate_to_size, reg1, 1000, pos1),
#说明：reg1是目标对象的id。1000是花费时间，单位为1/1000秒，即当前为1秒。pos1的x,y值为目标对象最终达到的宽和高。
#说明2：这种缩放是以目标对象的几何中心为原点行进的，当对象的size发生变化时其自身原点所在位置也会改变。
overlay_animate_to_size		                 = 936 # (overlay_animate_to_size, <overlay_id>, <duration-in-1/1000-seconds>, <position_no>), #position's x and y values are used as

#功能：使指定对象在指定时间内逐渐移动到指定位置。动画效果。
#格式：(overlay_animate_to_size, reg1, 1000, pos1),
#说明：reg1是目标对象的id。1000是花费时间，单位为1/1000秒，即当前为1秒。pos1的x,y值为目标对象最终到达的坐标位置。最终目标对象自身原点与pos1位置重叠。
overlay_animate_to_position              	= 937 # (overlay_animate_to_position, <overlay_id>, <duration-in-1/1000-seconds>, <position_no>), #position's x and y values are used as

#功能：建立一个图案基于纹理材料的图形按钮。
#格式：(create_image_button_overlay_with_tableau_material, reg1, "mesh_color_picker", "tableau_color_picker", 0xff0000),
#说明：新建对象的id储存在reg1中，"mesh_color_picker"是此对象使用的mesh，"tableau_color_picker"是应用在"mesh_color_picker"上的图案，0xff0000为该对象的颜色。
#说明2：如果"mesh_color_picker"部分值为-1，即没有指定mesh，则系统会自动生成一个mesh和tableau_material匹配。
create_image_button_overlay_with_tableau_material = 938 # (create_image_button_overlay_with_tableau_material, <destination>, <mesh_id>, <tableau_material_id>, <value>), #returns overlay id. value is passed to tableau_material
                                                        # when mesh_id is -1, a default mesh is generated automatically

#功能：建立一个图案基于纹理材料的图形对象。
#格式：(create_mesh_overlay_with_tableau_material, reg1, "mesh_color_picker", "tableau_color_picker", 0xff0000),
#说明：新建对象的id储存在reg1中，"mesh_color_picker"是此对象使用的mesh，"tableau_color_picker"是应用在"mesh_color_picker"上的图案，0xff0000为该对象的颜色。
#说明2：如果"mesh_color_picker"部分值为-1，即没有指定mesh，则系统会自动生成一个mesh和tableau_material匹配。
create_mesh_overlay_with_tableau_material         = 939 # (create_mesh_overlay_with_tableau_material, <destination>, <mesh_id>, <tableau_material_id>, <value>), #returns overlay id. value is passed to tableau_material
                                                        # when mesh_id is -1, a default mesh is generated automatically

#功能：似乎和create_button_overlay的效果类似，不知道有什么区别。
#格式：(create_game_button_overlay, reg1, "str_push_ups"), 
#说明：新建对象的id储存在reg1中，"str_push_ups"为文字内容。
create_game_button_overlay                = 940 # (create_game_button_overlay, <destination>, <string_id>), #returns overlay id
###创建游戏按钮纹理
create_in_game_button_overlay             = 941 # (create_in_game_button_overlay, <destination>, <string_id>), #returns overlay id

###创建数值框
create_number_box_overlay                 = 942 # (create_number_box_overlay, <destination>, <min_value>, <max_value>), #returns overlay id

###创建列表框
create_listbox_overlay                    = 943 # (create_list_box_overlay, <destination> #returns overlay id

###创建物品id模型框
create_mesh_overlay_with_item_id          = 944 # (create_mesh_overlay_with_item_id, <destination>, <item_id>), #returns overlay id.

###设置容器框
set_container_overlay                     = 945 # (set_container_overlay, <overlay_id>), #sets the container overlay that new overlays will attach to. give -1 to reset

###获取单位坐标
overlay_get_position                      = 946 # (overlay_get_position, <destination>, <overlay_id>)

###设置单位显示隐藏
overlay_set_display                       = 947 # (overlay_set_display, <overlay_id>, <value>), #shows/hides overlay (1 = show, 0 = hide)

###创建下拉标签
create_combo_label_overlay                = 948 # (create_combo_label_overlay, <destination>), #returns overlay id

###单位获得焦点
overlay_obtain_focus                      = 949 # (overlay_obtain_focus, <overlay_id>), #works for textboxes only

###设置单位文本说明
overlay_set_tooltip                       = 950 # (overlay_set_tooltip, <overlay_id>, <string_id>),

###设置容器
overlay_set_container_overlay            	= 951 # (overlay_set_container_overlay, <overlay_id>, <container_overlay_id>) # -1 to reset

###设置单位额外的高度
overlay_set_additional_render_height	  = 952 # (overlay_set_additional_render_height, <overlay_id>, <height_adder>),

###显示对象单位细节
show_object_details_overlay               = 960 # (show_object_details_overlay, <value>), #0 = hide, 1 = show

###显示item细节
show_item_details                         = 970 # (show_item_details, <item_id>, <position_no>, <show_default_text_or_not>) #show_default_text_or_not should be 1 for showing "default" for default item costs

###关闭item细节
close_item_details                        = 971 # (close_item_details)
###显示物品细节调节器 show_default_text_or_not为1显示“默认”的默认项目费用
show_item_details_with_modifier           = 972 # (show_item_details_with_modifier, <item_id>, <item_modifier>, <position_no>, <show_default_text_or_not>) #show_default_text_or_not should be 1 for showing "default" for default item costs

###下拉菜单添加item项
context_menu_add_item       = 980 # (right_mouse_menu_add_item, <string_id>, <value>), #must be called only inside script_game_right_mouse_menu_get_buttons

###获取游戏平均难度
get_average_game_difficulty = 990 # (get_average_game_difficulty, <destination>),

###获取等级范围
get_level_boundary = 991 # (get_level_boundary, <destination>, <level_no>),


#-------------------------
# Mission Condition types
###触发器条件相关命令
#-------------------------
### 所有敌人都被击败
### 参数0-x为team，可以根据触发器开始设定的team进行相关操作
### 例如触发器设定1,mtef_defenders|mtef_team_0，mtef_team_0就是守城军队
### 则在此触发器下使用(all_enemies_defeated,0)，就是判断守城军队是否都死了。
all_enemies_defeated      = 1003 # (all_enemies_defeated),
### 玩家完成竞赛
race_completed_by_player  = 1004 # (race_completed_by_player),
### 有效的队伍数
num_active_teams_le       = 1005 # (num_active_teams_le,<value>),
### 主角挂了
main_hero_fallen          = 1006 # (main_hero_fallen),


#----------------------------
# NEGATIONS 判断命令
#----------------------------
###否定，not，非|操作
neg          = 0x80000000	 # (neg|<operation>),
###这个或下一个
this_or_next = 0x40000000	 # (this_or_next|<operation>),


#小于 = 不大于
lt           = neg | ge # less than		-- (lt,<value>,<value>),
#不等于
neq          = neg | eq # not equal to		-- (neq,<value>,<value>),
#小于或等于
le           = neg | gt # less or equal to	-- (le,<value>,<value>),

#-------------------------------------------------------------------------------------------
# CONSEQUENCE OPERATIONS 运算结果                                                          -
#-------------------------------------------------------------------------------------------
finish_party_battle_mode        = 1019 # (finish_party_battle_mode),
###进入战斗状态
set_party_battle_mode           = 1020 # (set_party_battle_mode),

###大地图上的视角跟随
set_camera_follow_party         = 1021 # (set_camera_follow_party,<party_id>), #Works on map only.
###大地图上进入队伍页面的交谈功能
start_map_conversation          = 1025 # (start_map_conversation,<troop_id>),
###停留休息一段时间
###最后后两位参数可省略，取默认值。
###例：休息一段时间（3小时，5倍速，可以被攻击）：(rest_for_hours, 3, 5, 1), 
###      停止休息：(rest_for_hours, 0, 0, 0),
rest_for_hours                  = 1030 # (rest_for_hours,<rest_period>,[time_speed],[remain_attackable]),
###停留一段时间（行动中，比如建攻城塔） 
###最后后两位参数可省略，取默认值。
###例：收税任务中（1000小时，5倍速，不能被攻击）：(rest_for_hours_interactive, 1000, 5, 0),
### remain_attackable  1.可攻击  0.不能攻击
rest_for_hours_interactive      = 1031 # (rest_for_hours_interactive,<rest_period>,[time_speed],[remain_attackable]),

###给兵种加经验值
add_xp_to_troop                 = 1062 # (add_xp_to_troop,<value>,[troop_id]),
###将钱作为经验加上去？不明白，期待高手解答。
add_gold_as_xp                  = 1063 # (add_gold_as_xp,<value>,[troop_id]),
###奖励经验值
add_xp_as_reward                = 1064 # (add_xp_as_reward,<value>),

###添加金钱给队伍
add_gold_to_party               = 1070 # party_id should be different from 0
			       # (add_gold_to_party,<value>,<party_id>),

###设置创建队伍随机人数上限 script_update_party_creation_random_limits使用了一次
set_party_creation_random_limits= 1080 # (set_party_creation_random_limits, <min_value>, <max_value>), (values should be between 0, 100)

###设置可用的troop信息(1可用 0不可用)
troop_set_note_available        = 1095 # (troop_set_note_available, <troop_id>, <value>), #1 = available, 0 = not available
###设置可用的阵营信息(1可用 0不可用)
faction_set_note_available      = 1096 # (faction_set_note_available, <faction_id>, <value>), #1 = available, 0 = not available
###设置可用的队伍信息(1可用 0不可用)
party_set_note_available        = 1097 # (party_set_note_available, <party_id>, <value>), #1 = available, 0 = not available
###设置可用的任务信息(1可用 0不可用)
quest_set_note_available        = 1098 # (quest_set_note_available, <quest_id>, <value>), #1 = available, 0 = not available



#1090-1091-1092 is taken, see below (info_page)
###生成模板队伍
###例：(spawn_around_party,"p_zendar","pt_new_template"),
###在 p_zendar 附近生成了一个队伍模版 pt_new_template。
spawn_around_party              = 1100 # ID of spawned party is put into reg(0)
			       # (spawn_around_party,<party_id>,<party_template_id>),
###生成（部队的）半径；每次你要生成一个队伍的时候你都有做这个，否则队伍将会在最近一次设置的半径中生成
###例：(set_spawn_radius,0),
set_spawn_radius                = 1103 # (set_spawn_radius,<value>),

###显示调试消息
display_debug_message           = 1104 # (display_debug_message,<string_id>,[hex_colour_code]), #displays message only in debug mode, but writes to rgl_log.txt in both release and debug modes when edit mode is enabled
###显示日志消息
display_log_message             = 1105 # (display_log_message,<string_id>,[hex_colour_code]),
###显示消息
display_message                 = 1106 # (display_message,<string_id>,[hex_colour_code]),
###设置显示消息
set_show_messages               = 1107 # (set_show_messages,<value>), #0 disables window messages 1 re-enables them.

###添加troop信息静态画面模组（领主+旗帜静态画面）
###例：(add_troop_note_tableau_mesh, ":troop_no", "tableau_troop_note_mesh"),
add_troop_note_tableau_mesh     = 1108 # (add_troop_note_tableau_mesh,<troop_id>,<tableau_material_id>),
###添加阵营信息静态画面模组(国家的狮子、盾牌那些图片)
###例：(add_faction_note_tableau_mesh, ":faction_no", "tableau_faction_note_mesh"),
add_faction_note_tableau_mesh   = 1109 # (add_faction_note_tableau_mesh,<faction_id>,<tableau_material_id>),
###添加队伍信息静态画面模组
###例：(add_party_note_tableau_mesh, ":center_no", "tableau_center_note_mesh"),
add_party_note_tableau_mesh     = 1110 # (add_party_note_tableau_mesh,<party_id>,<tableau_material_id>),
###增加任务信息静态画面模组
add_quest_note_tableau_mesh     = 1111 # (add_quest_note_tableau_mesh,<quest_id>,<tableau_material_id>),
###增加信息页面静态画面模组
add_info_page_note_tableau_mesh = 1090 # (add_info_page_note_tableau_mesh,<info_page_id>,<tableau_material_id>),
###添加troop记录到对话框
add_troop_note_from_dialog      = 1114 # (add_troop_note_from_dialog,<troop_id>,<note_slot_no>, <value>), #There are maximum of 8 slots. value = 1 -> shows when the note is added
###添加阵营记录到对话框
add_faction_note_from_dialog    = 1115 # (add_faction_note_from_dialog,<faction_id>,<note_slot_no>, <value>), #There are maximum of 8 slots value = 1 -> shows when the note is added
###添加队伍记录到对话框
add_party_note_from_dialog      = 1116 # (add_party_note_from_dialog,<party_id>,<note_slot_no>, <value>), #There are maximum of 8 slots value = 1 -> shows when the note is added
###添加任务记录到对话框
add_quest_note_from_dialog      = 1112 # (add_quest_note_from_dialog,<quest_id>,<note_slot_no>, <value>), #There are maximum of 8 slots value = 1 -> shows when the note is added
###添加信息页面记录到对话框
add_info_page_note_from_dialog  = 1091 # (add_info_page_note_from_dialog,<info_page_id>,<note_slot_no>, <value>), #There are maximum of 8 slots value = 1 -> shows when the note is added
###添加troop消息到寄存器，有最多8个通道= 1 - >显示时注意是增加方式
add_troop_note_from_sreg        = 1117 # (add_troop_note_from_sreg,<troop_id>,<note_slot_no>,<string_id>, <value>), #There are maximum of 8 slots value = 1 -> shows when the note is added
###添加阵营消息到寄存器，有最多8个通道= 1 - >显示时注意是增加方式
add_faction_note_from_sreg      = 1118 # (add_faction_note_from_sreg,<faction_id>,<note_slot_no>,<string_id>, <value>), #There are maximum of 8 slots value = 1 -> shows when the note is added
###添加队伍消息到寄存器，有最多8个通道= 1 - >显示时注意是增加方式
add_party_note_from_sreg        = 1119 # (add_party_note_from_sreg,<party_id>,<note_slot_no>,<string_id>, <value>), #There are maximum of 8 slots value = 1 -> shows when the note is added
###添加任务消息到寄存器，有最多8个通道= 1 - >显示时注意是增加方式
add_quest_note_from_sreg        = 1113 # (add_quest_note_from_sreg,<quest_id>,<note_slot_no>,<string_id>, <value>), #There are maximum of 8 slots value = 1 -> shows when the note is added
###添加页面信息消息到寄存器，有最多8个通道= 1 - >显示时注意是增加方式
add_info_page_note_from_sreg    = 1092 # (add_info_page_note_from_sreg,<info_page_id>,<note_slot_no>,<string_id>, <value>), #There are maximum of 8 slots value = 1 -> shows when the note is added

###教程框
tutorial_box                    = 1120 # (tutorial_box,<string_id>,<string_id>), #deprecated use dialog_box instead.
###对话框
dialog_box                      = 1120 # (tutorial_box,<text_string_id>,<title_string_id>),
###问题框
question_box                    = 1121 # (question_box,<string_id>, [<yes_string_id>], [<no_string_id>]),
###教程消息
tutorial_message                = 1122 # (tutorial_message,<string_id>, <color>, <auto_close_time>), #set string_id = -1 for hiding the message
###教程消息设置坐标
tutorial_message_set_position   = 1123 # (tutorial_message_set_position, <position_x>, <position_y>), 
###教程消息设置大小
tutorial_message_set_size       = 1124 # (tutorial_message_set_size, <size_x>, <size_y>), 
###教程消息设置版面中心
tutorial_message_set_center_justify = 1125 # (tutorial_message_set_center_justify, <val>), #set not 0 for center justify, 0 for not center justify
###教程消息设置背景
tutorial_message_set_background = 1126 # (tutorial_message_set_background, <value>), #1 = on, 0 = off, default is off

###设置提示文本
set_tooltip_text                = 1130 #  (set_tooltip_text, <string_id>),

###重置价格比率
reset_price_rates               = 1170 # (reset_price_rates),
###设定物品价格比例
set_price_rate_for_item         = 1171 # (set_price_rate_for_item,<item_id>,<value_percentage>),
###设定物品类型价格比例
set_price_rate_for_item_type    = 1172 # (set_price_rate_for_item_type,<item_type_id>,<value_percentage>),

###队伍加入
party_join                      = 1201 # (party_join),
###队伍加入囚犯
party_join_as_prisoner          = 1202 # (party_join_as_prisoner),
###troop加入队伍
troop_join                      = 1203 # (troop_join,<troop_id>),
###troop加入队伍囚犯
troop_join_as_prisoner          = 1204 # (troop_join_as_prisoner,<troop_id>),

remove_member_from_party        = 1210 # (remove_member_from_party,<troop_id>,[party_id]),
###移除正规囚犯
remove_regular_prisoners        = 1211 # (remove_regular_prisoners,<party_id>),
remove_troops_from_companions   = 1215 # (remove_troops_from_companions,<troop_id>,<value>),
###从囚犯中移除troop
remove_troops_from_prisoners    = 1216 # (remove_troops_from_prisoners,<troop_id>,<value>),

###恢复队伍所有成员生命
heal_party                      = 1225 # (heal_party,<party_id>),

###隐藏队伍
disable_party                   = 1230 # (disable_party,<party_id>),
###显示队伍
enable_party                    = 1231 # (enable_party,<party_id>),
###移除队伍
remove_party                    = 1232 # (remove_party,<party_id>),
###添加同伴到队伍
add_companion_party             = 1233 # (add_companion_party,<troop_id_hero>),


###########################场景刷新点相关命令
###添加troop到刷新点
add_troop_to_site               = 1250 # (add_troop_to_site,<troop_id>,<scene_id>,<entry_no>),
###从刷新点移除troop
remove_troop_from_site          = 1251 # (remove_troop_from_site,<troop_id>,<scene_id>),
###改变场景刷新点访问者
modify_visitors_at_site         = 1261 # (modify_visitors_at_site,<scene_id>),
###重置(清空)访问者
reset_visitors                  = 1262 # (reset_visitors),
###设置访问者
set_visitor                     = 1263 # (set_visitor,<entry_no>,<troop_id>,[<dna>]),
###设置多个访问者
set_visitors                    = 1264 # (set_visitors,<entry_no>,<troop_id>,<number_of_troops>),
###添加访问者到当前场景，默认team为单机模式
add_visitors_to_current_scene   = 1265 # (add_visitors_to_current_scene,<entry_no>,<troop_id>,<number_of_troops>, <team_no>, <group_no>), #team no and group no are used in multiplayer mode only. default team in entry is used in single player mode
###场景设置时间,值为小时（0 - 23），要求必须在ti_before_mission_start触发器
scene_set_day_time              = 1266 # (scene_set_day_time, <value>), #value in hours (0-23), must be called within ti_before_mission_start triggers

###设置阵营关系
###例：        (set_relation,<fac_kingdom_1>,<fac_kingdom_2>,<50>), 将 Swadia 和 Vaegirs 的关系设定为 50
set_relation                    = 1270 # (set_relation,<faction_id>,<faction_id>,<value>),
###设置阵营名字
###例：        (faction_set_name, "fac_kingdom_1", "@china"),       将 Swadia 的名字改为 china
faction_set_name                = 1275 # (faction_set_name, <faction_id>, <string_id>),
###设置阵营颜色
###例：          (faction_set_color, "fac_kingdom_1", 0x0000FF),     将 Swadia 的颜色改为 深蓝
faction_set_color               = 1276 # (faction_set_color, <faction_id>, <value>),
###获取阵营颜色
faction_get_color               = 1277 # (faction_get_color, <color>, <faction_id>)


#Quest stuff
#################任务相关命令
###启动任务
start_quest              = 1280 # (start_quest,<quest_id>),
###任务完成
complete_quest           = 1281 # (complete_quest,<quest_id>),
###任务成功
succeed_quest            = 1282 # (succeed_quest,<quest_id>), #also concludes the quest
###任务失败
fail_quest               = 1283 # (fail_quest,<quest_id>), #also concludes the quest
###取消任务
cancel_quest             = 1284 # (cancel_quest,<quest_id>),

###设置任务进展，用处似乎不大
set_quest_progression    = 1285 # (set_quest_progression,<quest_id>,<value>),

###结束任务
conclude_quest           = 1286 # (conclude_quest,<quest_id>),

###计划任务文本
setup_quest_text         = 1290 # (setup_quest_text,<quest_id>),
###计划任务给与者
setup_quest_giver        = 1291 # (setup_quest_giver,<quest_id>, <string_id>),


#encounter outcomes.
#############################遭遇结果
###启动遭遇
start_encounter            = 1300 # (start_encounter,<party_id>),
###离开遭遇
leave_encounter            = 1301 # (leave_encounter),
###遭遇攻击
encounter_attack           = 1302 # (encounter_attack),
###选择敌人
select_enemy               = 1303 # (select_enemy,<value>),
###设置菜单通行(也可能是屏蔽相关菜单无法按TAB返回)
set_passage_menu           = 1304 # (set_passage_menu,<value>),
###作用不明，找不到使用过这个命令的代码
auto_set_meta_mission_at_end_commited = 1305 # (auto_set_meta_mission_at_end_commited),

#simulate_battle            = 1305 # (simulate_battle,<value>),
###结束当前战斗？找不到使用过这个命令的代码
end_current_battle         = 1307 # (end_current_battle),


###设定队伍商品来源?module_dialogs.py屏蔽的代码中用到一次
set_mercenary_source_party = 1320 # selects party from which to buy mercenaries选择购买商品的队伍？
				   # (set_mercenary_source_party,<party_id>),


###设定商品质量，refresh_center_inventories 		###刷新杂货商人用到
set_merchandise_modifier_quality = 1490	        # Quality rate in percentage (average quality = 100),质量百分比（平均= 100），
						# (set_merchandise_modifier_quality,<value>),
###设定商品最大数量？找不到使用过这个命令的代码
set_merchandise_max_value = 1491		# (set_merchandise_max_value,<value>),
###重置物品概率
reset_item_probabilities = 1492		        # (reset_item_probabilities),
###设定商品中的物品概率
set_item_probability_in_merchandise = 1493	# (set_item_probability_in_merchandise,<itm_id>,<value>),


###################活跃的troop相关命令
#active Troop
#set_active_troop                       = 1050
###设置troop称号，script_troop_set_title_according_to_faction设定troop相应的阵营称号
troop_set_name                         = 1501   # (troop_set_name, <troop_id>, <string_no>),
###设置troop复数的称号
troop_set_plural_name                  = 1502   # (troop_set_plural_name, <troop_id>, <string_no>),
###设置troop当前轮廓的脸部代码
troop_set_face_key_from_current_profile= 1503   # (troop_set_face_key_from_current_profile, <troop_id>),
###设置troop性别
troop_set_type                         = 1505	# (troop_set_type,<troop_id>,<gender>),
###获取troop性别
troop_get_type                         = 1506   # (troop_get_type,<destination>,<troop_id>),
###troop是英雄类别
troop_is_hero                          = 1507   # (troop_is_hero,<troop_id>),
###troop是伤员(只能用在英雄)
troop_is_wounded                       = 1508   # (troop_is_wounded,<troop_id>), #only for heroes!
###设置troop的自动装备
troop_set_auto_equip                   = 1509   # (troop_set_auto_equip,<troop_id>,<value>),#disables otr enables auto-equipping
###确保troop的物品栏空间,例：(troop_ensure_inventory_space, ":merchant_troop", 80),
troop_ensure_inventory_space           = 1510	# (troop_ensure_inventory_space,<troop_id>,<value>),
###给特定的troop(兵种)的物品栏排序(按价格)  
troop_sort_inventory                   = 1511	# (troop_sort_inventory,<troop_id>),
###troop添加商品
troop_add_merchandise                  = 1512	# (troop_add_merchandise,<troop_id>,<item_type_id>,<value>),
###troop添加商品从阵营 # faction_id是检查队伍有资格生产物品
troop_add_merchandise_with_faction     = 1513	# (troop_add_merchandise_with_faction,<troop_id>,<faction_id>,<item_type_id>,<value>), #faction_id is given to check if troop is eligible to produce that item
###获取troop的经验值
troop_get_xp                           = 1515   # (troop_get_xp, <destination>, <troop_id>),
###获取troop的类别
troop_get_class                        = 1516   # (troop_get_class, <destination>, <troop_id>),
###设置troop的类别
troop_set_class                        = 1517 # (troop_set_class, <troop_id>, <value>),

###提高troop属性
troop_raise_attribute                  = 1520	# (troop_raise_attribute,<troop_id>,<attribute_id>,<value>),
###提高troop技能
troop_raise_skill                      = 1521	# (troop_raise_skill,<troop_id>,<skill_id>,<value>),
###提高troop熟练度
troop_raise_proficiency                = 1522	# (troop_raise_proficiency,<troop_id>,<proficiency_no>,<value>),
###提高troop熟练度水平线，提高武器的水平线不受武器掌握技能
troop_raise_proficiency_linear         = 1523	# raises weapon proficiencies linearly without being limited by weapon master skill
						# (troop_raise_proficiency,<troop_id>,<proficiency_no>,<value>),

###增加troop熟练点
troop_add_proficiency_points           = 1525   # (troop_add_proficiency_points,<troop_id>,<value>),					
###troop添加钱
troop_add_gold                         = 1528	# (troop_add_gold,<troop_id>,<value>),
###troop减少钱
troop_remove_gold                      = 1529	# (troop_remove_gold,<troop_id>,<value>),
###troop添加物品
troop_add_item                         = 1530	# (troop_add_item,<troop_id>,<item_id>,[modifier]),
###troop移除物品
troop_remove_item                      = 1531	# (troop_remove_item,<troop_id>,<item_id>),
###troop清除物品栏所有物品
troop_clear_inventory                  = 1532	# (troop_clear_inventory,<troop_id>),
###troop装备物品，装备的物品要在物品栏里
troop_equip_items		       = 1533   # (troop_equip_items,<troop_id>), #equips the items in the inventory automatically
###从troop物品栏slot里设置物品数量, script_consume_food消耗食物
troop_inventory_slot_set_item_amount   = 1534   # (troop_inventory_slot_set_item_amount,<troop_id>,<inventory_slot_no>,<value>),
###从troop物品栏slot里获取物品数量, script_consume_food消耗食物
troop_inventory_slot_get_item_amount   = 1537   # (troop_inventory_slot_get_item_amount,<destination>,<troop_id>,<inventory_slot_no>),
###从troop物品栏slot里获取物品叠加上限?
troop_inventory_slot_get_item_max_amount= 1538  # (troop_inventory_slot_get_item_max_amount,<destination>,<troop_id>,<inventory_slot_no>),

###troop添加多个物品
troop_add_items                        = 1535	# (troop_add_items,<troop_id>,<item_id>,<number>),
###troop移除多个物品
troop_remove_items                     = 1536	# puts cost of items to reg0
                                                # (troop_remove_items,<troop_id>,<item_id>,<number>),
###troop掠夺troop，script_party_calculate_loot计算掠夺战利品
troop_loot_troop                       = 1539	# (troop_loot_troop,<target_troop>,<source_troop_id>,<probability>), 

###获取troop物品栏(最大)容量
troop_get_inventory_capacity           = 1540	# (troop_get_inventory_capacity,<destination>,<troop_id>),
###获取物品栏slot
troop_get_inventory_slot               = 1541	# (troop_get_inventory_slot,<destination>,<troop_id>,<inventory_slot_no>),
###获取物品栏slot调节器
troop_get_inventory_slot_modifier      = 1542	# (troop_get_inventory_slot_modifier,<destination>,<troop_id>,<inventory_slot_no>),
###设置物品栏slot
troop_set_inventory_slot               = 1543	# (troop_set_inventory_slot,<troop_id>,<inventory_slot_no>,<value>),
###设置物物品栏slot调节器
troop_set_inventory_slot_modifier      = 1544	# (troop_set_inventory_slot_modifier,<troop_id>,<inventory_slot_no>,<value>),
###设置troop阵营
troop_set_faction                      = 1550 # (troop_set_faction,<troop_id>,<faction_id>),
###设置troop年龄
troop_set_age                          = 1555 # (troop_set_age, <troop_id>, <age_slider_pos>),  #Enter a value between 0..100
###设置troop生命值(百分比？)
troop_set_health                       = 1560	# (troop_set_health,<troop_id>,<relative health (0-100)>),

###获取troop升级树上的高级兵种 （0=第一个节点，1=第二个节点，-1为不可用）
###参考script_update_volunteer_troops_in_village更新村庄志愿兵
troop_get_upgrade_troop                = 1561   # (troop_get_upgrade_troop,<destination>,<troop_id>,<upgrade_path>), #upgrade_path can be: 0 = get first node, 1 = get second node (returns -1 if not available)



######################物品类相关命令
#Items...
###获取物品类型 #返回的值被列在header_items.py（itp_type_）
item_get_type                          = 1570   # (item_get_type, <destination>, <item_id>), #returned values are listed at header_items.py (values starting with itp_type_)


######################party相关命令
#Parties...
###获取队伍同伴数（村庄的守卫或城堡的守军）
party_get_num_companions               = 1601	# (party_get_num_companions,<destination>,<party_id>),
###获取囚犯总数
party_get_num_prisoners                = 1602	# (party_get_num_prisoners,<destination>,<party_id>),

###设置party属性
###【pf_default_behavior默认设置行动】
###【pf_quest_party任务队伍】
###【pf_icon_mask】
###【pf_disabled隐藏队伍】
###【pf_limit_members玩家部队人数限制，0为无效，1为有效】
party_set_flags                        = 1603   # (party_set_flag, <party_id>, <flag>, <clear_or_set>), #sets flags like pf_default_behavior. see header_parties.py for flags.

###设置元帅队伍？
party_set_marshall                     = 1604   # (party_set_marshall, <party_id>, <value>)
###设置队伍额外的文本（ 被 掠 夺 中 ）（ 已 被 洗 劫 ）（ 陷 入 包 围 ）
party_set_extra_text                   = 1605   # (party_set_extra_text,<party_id>, <string>)
###设置队伍进攻性
party_set_aggressiveness               = 1606   # (party_set_aggressiveness, <party_id>, <number>),
###设置队伍勇气胆量
party_set_courage                      = 1607   # (party_set_courage, <party_id>, <number>),
###获取队伍所处位置的地形
###【rt_water水】
party_get_current_terrain              = 1608	# (party_get_current_terrain,<destination>,<party_id>),
###获取部队模板ID
party_get_template_id                  = 1609	# (party_get_template_id,<destination>,<party_id>),

###部队添加多个troop
party_add_members                      = 1610	# (party_add_members,<party_id>,<troop_id>,<number>), #returns number added in reg0
###队伍添加囚犯
party_add_prisoners                    = 1611	# (party_add_prisoners,<party_id>,<troop_id>,<number>),#returns number added in reg0
###队伍添加英雄
party_add_leader                       = 1612	# (party_add_leader,<party_id>,<troop_id>,[<number>]),
###队伍强行添加troop
party_force_add_members                = 1613	# (party_force_add_members,<party_id>,<troop_id>,<number>),
###队伍强行添加囚犯
party_force_add_prisoners              = 1614	# (party_force_add_prisoners,<party_id>,<troop_id>,<number>),

###队伍移除troop
party_remove_members                   = 1615	# stores number removed to reg0
						# (party_remove_members,<party_id>,<troop_id>,<number>),
###队伍移除囚犯
party_remove_prisoners                 = 1616	# stores number removed to reg0
						# (party_remove_members,<party_id>,<troop_id>,<number>),
###清空队伍
party_clear                            = 1617	# (party_clear,<party_id>),
###设置队伍兵种伤员
party_wound_members                    = 1618	# (party_wound_members,<party_id>,<troop_id>,<number>),
###优先移除伤员
party_remove_members_wounded_first     = 1619	# stores number removed to reg0
						# (party_remove_members_wounded_first,<party_id>,<troop_id>,<number>),

###设置队伍阵营
party_set_faction                      = 1620	# (party_set_faction,<party_id>,<faction_id>),
###使队伍1靠近目标队伍
###(party_relocate_near_party,<队伍1>,<目标队伍>,<刷新半径>),
###例：(party_relocate_near_party, "p_main_party", ":starting_training_ground", 3), ###使玩家队伍刷新到随机训练场旁边
party_relocate_near_party              = 1623	# (party_relocate_near_party,<party_id>,<target_party_id>,<value_spawn_radius>),

###得到队伍坐标
party_get_position                     = 1625	# (party_get_position,<position_no>,<party_id>),
###设置队伍坐标
party_set_position                     = 1626	# (party_set_position,<party_id>,<position_no>),
###获取地图随机场景位置坐标
map_get_random_position_around_position= 1627	# (map_get_random_position_around_position,<dest_position_no>,<source_position_no>,<radius>),
###获取地图陆地场景位置坐标
map_get_land_position_around_position  = 1628	# (map_get_land_position_around_position,<dest_position_no>,<source_position_no>,<radius>),
###获取地图河流场景位置坐标
map_get_water_position_around_position = 1629	# (map_get_water_position_around_position,<dest_position_no>,<source_position_no>,<radius>),


###计算队伍成员类型数量
party_count_members_of_type            = 1630	# (party_count_members_of_type,<destination>,<party_id>,<troop_id>),
###计算队伍同伴类型数量
party_count_companions_of_type         = 1631	# (party_count_companions_of_type,<destination>,<party_id>,<troop_id>),
###计算囚犯类型数量
party_count_prisoners_of_type          = 1632	# (party_count_prisoners_of_type,<destination>,<party_id>,<troop_id>),

###获取队伍可以招募的同伴自由空间
party_get_free_companions_capacity     = 1633   # (party_get_free_companions_capacity,<destination>,<party_id>),
###获取队伍可以俘虏的自由空间
party_get_free_prisoners_capacity      = 1634   # (party_get_free_prisoners_capacity,<destination>,<party_id>),

###获取队伍的攻击性值，value值在0-100之间
party_get_ai_initiative                = 1638	# (party_get_ai_initiative,<destination>,<party_id>), #result is between 0-100
###获取队伍的攻击性值，value值在0-100之间
party_set_ai_initiative                = 1639	# (party_set_ai_initiative,<party_id>,<value>), #value is between 0-100

###设置部队行为
###【ai_bhvr_track_party跟随】【ai_bhvr_attack_party攻击】【ai_bhvr_hold控制】【ai_bhvr_travel_to_party移动到目标】
party_set_ai_behavior                  = 1640	# (party_set_ai_behavior,<party_id>,<ai_bhvr>),
###设置部队行动目标
party_set_ai_object                    = 1641	# (party_set_ai_object,<party_id>,<party_id>),

###设置队伍AI攻击坐标
party_set_ai_target_position           = 1642	# (party_set_ai_target_position,<party_id>,<position_no>),
###设置队伍巡逻半径
party_set_ai_patrol_radius             = 1643	# (party_set_ai_patrol_radius,<party_id>,<radius_in_km>),
###队伍忽视玩家，就是设置敌人不要长时间追赶玩家
party_ignore_player                    = 1644   # (party_ignore_player, <party_id>,<duration_in_hours>), #don't pursue player party for this duration

###设置队伍对土匪的吸引力，值范围(0..100)
###例：(party_set_bandit_attraction, "p_main_party", ":bandit_attraction"),
party_set_bandit_attraction            = 1645   # (party_set_bandit_attraction, <party_id>,<attaraction>), #set how attractive a target the party is for bandits (0..100)
###获取队伍友善值
party_get_helpfulness                  = 1646   # (party_get_helpfulness,<destination>,<party_id>),
###设置队伍友善值，倾向于帮助各方友好的攻击（0-10000, 默认100）
party_set_helpfulness                  = 1647   # (party_set_helpfulness, <party_id>, <number>), #tendency to help friendly parties under attack. (0-10000, 100 default.)


###获取队伍兵种数量
party_get_num_companion_stacks         = 1650   # (party_get_num_companion_stacks,<destination>,<party_id>),
###获取队伍囚犯兵种数量
party_get_num_prisoner_stacks          = 1651   # (party_get_num_prisoner_stacks, <destination>,<party_id>),
###获取队伍首领id
party_stack_get_troop_id               = 1652   # (party_stack_get_troop_id,      <destination>,<party_id>,<stack_no>),
###获取队伍的人数
party_stack_get_size                   = 1653   # (party_stack_get_size,          <destination>,<party_id>,<stack_no>),
###获取队伍伤员兵种人数
party_stack_get_num_wounded            = 1654   # (party_stack_get_num_wounded,   <destination>,<party_id>,<stack_no>),
###获取队伍首领dna复制品（使用dna可以省去移除首领加入首领等操作？）
party_stack_get_troop_dna              = 1655   # (party_stack_get_troop_dna,     <destination>,<party_id>,<stack_no>),
###获取队伍首领囚犯id
party_prisoner_stack_get_troop_id      = 1656   # (party_get_prisoner_stack_troop,<destination>,<party_id>,<stack_no>),
###获取队伍囚犯大小
party_prisoner_stack_get_size          = 1657   # (party_get_prisoner_stack_size, <destination>,<party_id>,<stack_no>),
###获取首领囚犯dna复制品（使用dna可以省去移除首领加入首领等操作？）
party_prisoner_stack_get_troop_dna     = 1658   # (party_prisoner_stack_get_troop_dna, <destination>,<party_id>,<stack_no>),


###队伍加入队伍，一般用于队伍和城镇的兵合并
party_attach_to_party                  = 1660   # (party_attach_to_party, <party_id>, <party_id to attach to>),
###队伍分离
party_detach                           = 1661   # (party_detach, <party_id>),
###队伍集合附加到队伍
party_collect_attachments_to_party     = 1662   # (party_collect_attachments_to_party, <party_id>, <destination party_id>),
###队伍快速附加到当前战斗
party_quick_attach_to_current_battle   = 1663   # (party_quick_attach_to_current_battle, <party_id>, <side (0:players side, 1:enemy side)>),

###获取队伍当前城镇
party_get_cur_town                     = 1665   # (party_get_cur_town, <destination>, <party_id>),

###队伍离开当前战斗
party_leave_cur_battle                 = 1666   # (party_leave_cur_battle, <party_id>),
###设置队伍下次战斗模拟时间
party_set_next_battle_simulation_time  = 1667   # (party_set_next_battle_simulation_time,<party_id>,<next_simulation_time_in_hours>),

###设置队伍名称
party_set_name                         = 1669   # (party_set_name, <party_id>, <string_no>),

###添加经验到兵种
party_add_xp_to_stack                  = 1670   # (party_add_xp_to_stack, <party_id>, <stack_no>, <xp_amount>),

###获取队伍士气
party_get_morale                       = 1671   # (party_get_morale, <destination>,<party_id>),
###设置队伍士气，范围0-100
party_set_morale                       = 1672   # (party_set_morale, <party_id>, <value>), #value is clamped to range [0...100].

###队伍经验提高（0随机选择 1第一选择 2第二选择）
party_upgrade_with_xp                  = 1673   # (party_upgrade_with_xp, <party_id>, <xp_amount>, <upgrade_path>), #upgrade_path can be: #0 = choose random, 1 = choose first, 2 = choose second
###队伍增加经验
party_add_xp                           = 1674   # (party_add_xp, <party_id>, <xp_amount>),

###队伍增加模版，参考script_cf_reinforce_party队伍补充士兵
party_add_template                     = 1675   # (party_add_template, <party_id>, <party_template_id>, [reverse_prisoner_status]),

###设置队伍icon
party_set_icon                         = 1676   # (party_set_icon, <party_id>, <map_icon_id>),
###设置队伍旗帜
party_set_banner_icon                  = 1677   # (party_set_banner_icon, <party_id>, <map_icon_id>),
###队伍添加粒子系统
###psys_map_village_fire 村庄火
###psys_map_village_fire_smoke 村庄烟火
###psys_map_village_looted_smoke 掠夺村庄粒子效果
party_add_particle_system              = 1678   # (party_add_particle_system, <party_id>, <particle_system_id>),
###队伍清除粒子系统
party_clear_particle_systems           = 1679   # (party_clear_particle_systems, <party_id>),

###获取对手战斗
party_get_battle_opponent              = 1680   # (party_get_battle_opponent, <destination>, <party_id>)
###获取队伍icon
party_get_icon                         = 1681   # (party_get_icon, <destination>, <party_id>),
###设置额外的icon，频率是每秒多少转数
party_set_extra_icon                   = 1682   # (party_set_extra_icon, <party_id>, <map_icon_id>, <up_down_distance_fixed_point>, <up_down_frequency_fixed_point>, <rotate_frequency_fixed_point>, <fade_in_out_frequency_fixed_point>), #frequencies are in number of revolutions per second

###获取队伍技能等级
party_get_skill_level                  = 1685   # (party_get_skill_level, <destination>, <party_id>, <skill_no>),
###获取agent速度，返回速度x和y坐标
agent_get_speed                        = 1689   # (agent_get_speed, <position_no>, <agent_id>), #will return speed in x and y
###得到战斗优势
get_battle_advantage                   = 1690   # (get_battle_advantage, <destination>),
###设置战斗优势
set_battle_advantage                   = 1691   # (set_battle_advantage, <value>),

###恢复agent盾牌打击点数
agent_refill_wielded_shield_hit_points = 1692   # (agent_refill_wielded_shield_hit_points, <agent_id>),
###agent是特殊模式
agent_is_in_special_mode               = 1693   # (agent_is_in_special_mode,<agent_id>),
###获取队伍附加到的目标
party_get_attached_to                  = 1694   # (party_get_attached_to, <destination>, <party_id>),
###获取队伍附加的队伍数量（获得攻击方或防守方参与的部队数量）
party_get_num_attached_parties         = 1695   # (party_get_num_attached_parties, <destination>, <party_id>),
###获取附加队伍的排列（多个部队同时参与战斗时，会产生两个军队列表，第一个是攻击方，第二个是防守方，每一个列表中都保存同盟军队，攻击方列表中第一个部队就是最先发起攻击的队伍，防守方列表中第一个就是首先被攻击的那个部队，可以通过列表中的第一个位置判断玩家是不是发起攻击者，或被攻击者）
party_get_attached_party_with_rank     = 1696   # (party_get_attached_party_with_rank, <destination>, <party_id>, <attached_party_no>),
###强制伤亡到集团军
inflict_casualties_to_party_group      = 1697   # (inflict_casualties_to_party, <parent_party_id>, <attack_rounds>, <party_id_to_add_causalties_to>), 
###分配队伍到集团军
distribute_party_among_party_group     = 1698   # (distribute_party_among_party_group, <party_to_be_distributed>, <group_root_party>),



##############################agent相关命令
###agent被打败
agent_is_routed                        = 1699   # (agent_is_routed,<agent_id>),

#Agents

#store_distance_between_positions,
#position_is_behind_poisiton,
###获取玩家agent
get_player_agent_no                    = 1700	# (get_player_agent_no,<destination>),
###获取玩家agent杀人数量，有get_wounded参数则加上受伤者
get_player_agent_kill_count            = 1701	# (get_player_agent_kill_count,<destination>,[get_wounded]), #Set second value to non-zero to get wounded count. returns lifetime kill counts

###agent是存活的，(neg|agent_is_alive, ":cur_agent")就是非存活的
agent_is_alive                         = 1702	# (agent_is_alive,<agent_id>),
###agent是伤兵
agent_is_wounded                       = 1703	# (agent_is_wounded,<agent_id>),
###agent是人类，非马匹
agent_is_human                         = 1704	# (agent_is_human,<agent_id>),

###获取玩家agent特有troop杀人数量，有get_wounded参数则加上受伤者
get_player_agent_own_troop_kill_count  = 1705   # (get_player_agent_own_troop_kill_count,<destination>,[get_wounded]), #Set second value to non-zero to get wounded count

###agent是盟军士兵
agent_is_ally                          = 1706	# (agent_is_ally,<agent_id>),
###agent不是玩家
agent_is_non_player                    = 1707   # (agent_is_non_player, <agent_id>),
###agent是守城士兵
agent_is_defender                      = 1708	# (agent_is_defender,<agent_id>),
###agent是激活有效的
agent_is_active                        = 1712   # (agent_is_active,<agent_id>),
#agent_is_routed                        = 1699   # (agent_is_routed,<agent_id>),
#agent_is_in_special_mode               = 1693   # (agent_is_in_special_mode,<agent_id>),

###获取agent视点坐标
agent_get_look_position                = 1709   # (agent_get_look_position, <position_no>, <agent_id>),
###获取agent坐标
agent_get_position                     = 1710	# (agent_get_position,<position_no>,<agent_id>),
###设置agent坐标
agent_set_position                     = 1711	# (agent_set_position,<agent_id>,<position_no>),
#agent_get_speed                        = 1689   # (agent_get_speed, <position_no>, <agent_id>), #will return speed in x and y
#agent_is_active                        = 1712   # (agent_is_active,<agent_id>),
###设置agent视野内的优先攻击目标
agent_set_look_target_agent            = 1713 # (agent_set_look_target_agent, <agent_id>, <agent_id>), #second agent_id is the target
###获取马agent
agent_get_horse                        = 1714	# (agent_get_horse,<destination>,<agent_id>),
###获取骑手agent
agent_get_rider                        = 1715	# (agent_get_rider,<destination>,<agent_id>),
###获取agent的队伍id
agent_get_party_id                     = 1716	# (agent_get_party_id,<destination>,<agent_id>),
###获取agent的入口点
agent_get_entry_no                     = 1717	# (agent_get_entry_no,<destination>,<agent_id>),
###获取agent的troop id
agent_get_troop_id                     = 1718	# (agent_get_troop_id,<destination>, <agent_id>),
###获取agent的物品id，只为马，否则返回- 1
agent_get_item_id                      = 1719	# (agent_get_item_id,<destination>, <agent_id>), (works only for horses, returns -1 otherwise)

###调取指定agent的血量
###举例(store_agent_hit_points,“:hp”,":myself",1),其中[absolute]不写的话则是调取百分比
store_agent_hit_points                 = 1720	# set absolute to 1 to retrieve actual hps, otherwise will return relative hp in range [0..100]
						# (store_agent_hit_points,<destination>,<agent_id>,[absolute]),

###设定agent血量
agent_set_hit_points                   = 1721	# set absolute to 1 if value is absolute, otherwise value will be treated as relative number in range [0..100]
						# (agent_set_hit_points,<agent_id>,<value>,[absolute]),

###让一个agent对另外一个agent输出武器伤害
agent_deliver_damage_to_agent          = 1722	# (agent_deliver_damage_to_agent, <agent_id_deliverer>, <agent_id>, <value>, [item_id]), #if value <= 0, then damage will be calculated using the weapon item. # item_id is the item that the damage is delivered. can be ignored.

###获取agent的杀人数量
agent_get_kill_count                   = 1723   # (agent_get_kill_count,<destination>,<agent_id>,[get_wounded]), #Set second value to non-zero to get wounded count

###得到agent的玩家id
agent_get_player_id                    = 1724   # (agent_get_player_id,<destination>,<agent_id>),
###设置agent无敌保护
agent_set_invulnerable_shield          = 1725 # (agent_set_invulnerable_shield, <agent_id>),
###获取agent当前装备的武器
agent_get_wielded_item                 = 1726	# (agent_get_wielded_item,<destination>,<agent_id>,<hand_no>),
###获取agent弹药
agent_get_ammo                         = 1727	# (agent_get_ammo,<destination>,<agent_id>, <value>), #value = 1 gets ammo for wielded item, value = 0 gets ammo for all items
#agent_get_ammo_for_slot                = 1825	# (agent_get_ammo_for_slot, <destination>, <agent_id>, <slot_no>), #slot no can be between 0-3
###填充agent弹药
agent_refill_ammo                      = 1728	# (agent_refill_ammo,<agent_id>),
#agent_refill_wielded_shield_hit_points = 1692   # (agent_refill_wielded_shield_hit_points, <agent_id>),
###检测agent是否装备某个物品
agent_has_item_equipped                = 1729	# (agent_has_item_equipped,<agent_id>,<item_id>),


###设置agent脚本目标，auto_set_z_to_ground_level可以是0（假）或1个（真）
agent_set_scripted_destination         = 1730	# (agent_set_scripted_destination,<agent_id>,<position_no>,<auto_set_z_to_ground_level>), #auto_set_z_to_ground_level can be 0 (false) or 1 (true)
###获取agent脚本目标
agent_get_scripted_destination         = 1731   # (agent_get_scripted_destination,<position_no>,<agent_id>),
###强制agent重新思考
agent_force_rethink                    = 1732 # (agent_force_rethink, <agent_id>),
###设置agent没有死亡仅仅倒下？0关闭 1开启
agent_set_no_death_knock_down_only     = 1733 # (agent_set_no_death_knock_down_only, <agent_id>, <value>), #0 for disable, 1 for enable
###设置马速度因子
agent_set_horse_speed_factor           = 1734 # (agent_set_horse_speed_factor, <agent_id>, <speed_multiplier-in-1/100>),
###清除agent脚本模式
agent_clear_scripted_mode              = 1735	# (agent_clear_scripted_mode,<agent_id>),
###设置agent速度限制，仅影响AI
###(agent_set_speed_limit,<agent_id>,<speed_limit(公里/小时)>)
agent_set_speed_limit                  = 1736   # (agent_set_speed_limit,<agent_id>,<speed_limit(kilometers/hour)>), #Affects AI only 
###设置agent混战ai总是攻击（用于围攻使agent不要等待的阶梯上。）
agent_ai_set_always_attack_in_melee    = 1737   # (agent_ai_set_always_attack_in_melee, <agent_id>,<value>), #to be used in sieges so that agents don't wait on the ladder.
###获取agent简单行为，常数在header_mission_templates.py，开始与aisb_
agent_get_simple_behavior              = 1738   # (agent_get_simple_behavior, <destination>, <agent_id>), #constants are written in header_mission_templates.py, starting with aisb_
###获取agent战斗状态
agent_get_combat_state                 = 1739   # (agent_get_combat_state, <destination>, <agent_id>),

###设置agent动作，channel_no默认值是0。只有动作应该channel_no值为1。
agent_set_animation                    = 1740   # (agent_set_animation, <agent_id>, <anim_id>, [channel_no]), #channel_no default is 0. Top body only animations should have channel_no value as 1.
###设置agent站立动作
agent_set_stand_animation              = 1741   # (agent_set_stand_action, <agent_id>, <anim_id>),
###设置agent步行冲锋动作
agent_set_walk_forward_animation       = 1742   # (agent_set_walk_forward_action, <agent_id>, <anim_id>),
###设置agent前进动作，值是0到1之间（如固定点）
agent_set_animation_progress           = 1743   # (agent_set_animation_progress, <agent_id>, <value_fixed_point>), #value should be between 0-1 (as fixed point)
###设置agent瞄准坐标
agent_set_look_target_position         = 1744   # (agent_set_look_target_position, <agent_id>, <position_no>),
###设置agent攻击行为，#值：-2 =清除任何攻击行动，0 =刺，1 = 挥砍，2 = 左砍 3 = 二值过冲 0 = 准备和释放 1 = 准备和控制
agent_set_attack_action                = 1745   # (agent_set_attack_action, <agent_id>, <value>, <value>), #value: -2 = clear any attack action, 0 = thrust, 1 = slashright, 2 = slashleft, 3 = overswing - second value 0 = ready and release, 1 = ready and hold
###设置agent防守行为 #值：-2 =清除任何攻击行动，0=防守下 1=防守右 2防守左 3防守上
agent_set_defend_action                = 1746   # (agent_set_defend_action, <agent_id>, <value>, <duration-in-1/1000-seconds>), #value_1: -2 = clear any defend action, 0 = defend_down, 1 = defend_right, 2 = defend_left, 3 = defend_up
###设置agent装备物品
agent_set_wielded_item                 = 1747   # (agent_set_wielded_item, <agent_id>, <item_id>),
###设置没有攻击的脚本目标
agent_set_scripted_destination_no_attack = 1748	# (agent_set_scripted_destination_no_attack,<agent_id>,<position_no>,<auto_set_z_to_ground_level>), #auto_set_z_to_ground_level can be 0 (false) or 1 (true)
###设置agent渐隐？
agent_fade_out                         = 1749   # (agent_fade_out, <agent_id>),
###设置agent音效
agent_play_sound                       = 1750   # (agent_play_sound, <agent_id>, <sound_id>),
###agent开始逃跑（如果没有进入位置，将逃到那个位置。pos0是不被允许的（将被忽略）。）
agent_start_running_away               = 1751   # (agent_start_running_away, <agent_id>, [position_no]), # if position no is entered, agent will run away to that location. pos0 is not allowed (will be ignored).
###agent停止逃跑
agent_stop_running_away                = 1752   # (agent_stop_run_away, <agent_id>),
###设置agent的ai进攻性（100是默认的侵略性。更高的值，不太可能跑回来）
agent_ai_set_aggressiveness            = 1753   # (agent_ai_set_aggressiveness, <agent_id>, <value>), #100 is the default aggressiveness. higher the value, less likely to run back
###设置agent是否允许用脚踢，0关闭 1允许
agent_set_kick_allowed                 = 1754   # (agent_set_kick_allowed, <agent_id>, <value>), #0 for disable, 1 for allow

###移除agent
remove_agent                           = 1755   # (remove_agent, <agent_id>),

###获取agent附加的场景道具
agent_get_attached_scene_prop          = 1756   # (agent_get_attached_scene_prop, <destination>, <agent_id>)
###设置agent附加的场景道具
agent_set_attached_scene_prop          = 1757   # (agent_set_attached_scene_prop, <agent_id>, <scene_prop_id>)
###设置agent附加的场景道具x坐标
agent_set_attached_scene_prop_x        = 1758   # (agent_set_attached_scene_prop_x, <agent_id>, <value>)
#agent_set_attached_scene_prop_y        = 1809   # (agent_set_attached_scene_prop_y, <agent_id>, <value>)
###设置agent附加的场景道具y坐标
agent_set_attached_scene_prop_z        = 1759   # (agent_set_attached_scene_prop_z, <agent_id>, <value>)

###获取agent离开以后经过的时间
agent_get_time_elapsed_since_removed   = 1760   # (agent_get_time_elapsed_since_dead, <destination>, <agent_id>),
###获取agent后面跟随的敌人数量
agent_get_number_of_enemies_following  = 1761   # (agent_get_number_of_enemies_following, <destination>, <agent_id>),

###设置agent动力学，0关闭 1开启（需要过场动画）
agent_set_no_dynamics                  = 1762   # (agent_set_no_dynamics, <agent_id>, <value>), #0 = turn dynamics off, 1 = turn dynamics on (required for cut-scenes)

###获取agent攻击行动 0自由 1准备攻击 2释放攻击 3完成打击后进攻 4攻击闪避 5装弹 6释放 7取消攻击
agent_get_attack_action                = 1763   # (agent_get_attack_action, <destination>, <agent_id>), #returned values: free = 0, readying_attack = 1, releasing_attack = 2, completing_attack_after_hit = 3, attack_parried = 4, reloading = 5, after_release = 6, cancelling_attack = 7
###获取agent防守行动，0自由 1闪避 2盾挡？
agent_get_defend_action                = 1764   # (agent_get_defend_action, <destination>, <agent_id>), #returned values: free = 0, parrying = 1, blocking = 2

###获取agent分队，此命令用于联机模式
agent_get_group                        = 1765   # (agent_get_group, <destination>, <agent_id>),
###设定agent分队，此命令用于联机模式
agent_set_group                        = 1766   # (agent_set_group, <agent_id>, <value>),

###获取agent动作列表 -1无效的 0下 1右 2左 3上
agent_get_action_dir                   = 1767   # (agent_get_action_dir, <destination>, <agent_id>), #invalid = -1, down = 0, right = 1, left = 2, up = 3
###获取agent动作动画 0身体下部 1身体上部
agent_get_animation                    = 1768   # (agent_get_animation, <destination>, <agent_id>, <body_part), #0 = lower body part, 1 = upper body part
###agent躲避动作动画
agent_is_in_parried_animation          = 1769   # (agent_is_in_parried_animation, <agent_id>),

###获取agent组，team用于区分我军，敌军，友军，在module_mission_templates.py触发器设置mtef_team_0，mtef_team_1这些
agent_get_team                         = 1770   # (agent_get_team  ,<destination>, <agent_id>),
###设置agent组，team用于区分我军，敌军，友军，在module_mission_templates.py触发器设置mtef_team_0，mtef_team_1这些
agent_set_team                         = 1771   # (agent_set_team  , <agent_id>, <value>),

###获取agent兵种类别（grc_everyone所有 grc_infantry步兵 grc_archers弓箭手 grc_cavalry骑兵）
agent_get_class                        = 1772   # (agent_get_class ,<destination>, <agent_id>),
###获取agent分隔？
agent_get_division                     = 1773   # (agent_get_division ,<destination>, <agent_id>),
###agent取下物品，weapon_slot_no是可选的，并且可以1 - 4间（仅用于武器，没有装甲）。在任何情况下，item_id已设置正确。
agent_unequip_item                     = 1774	  # (agent_unequip_item, <agent_id>, <item_id>, [weapon_slot_no]), #weapon_slot_no is optional, and can be between 1-4 (used only for weapons, not armor). in either case, item_id has to be set correctly.

###类接收命令，用于script_update_order_panel_checked_classes更新命令面板选中类别
class_is_listening_order               = 1775   # (class_is_listening_order, <team_no>, <sub_class>),
###设置agent弹药，0-最大弹药数
agent_set_ammo                         = 1776   # (agent_set_ammo,<agent_id>,<item_id>,<value>), #value = a number between 0 and maximum ammo

###似乎是联机命令，检测超时
agent_add_offer_with_timeout           = 1777   # (agent_add_offer_with_timeout, <agent_id>, <agent_id>, <duration-in-1/1000-seconds>), #second agent_id is offerer, 0 value for duration is an infinite offer
###联机命令
agent_check_offer_from_agent           = 1778   # (agent_check_offer_from_agent, <agent_id>, <agent_id>), #second agent_id is offerer

###agent装备物品，武器，需有一个空的武器槽。weapon_slot_no是可选的，并且可以1 - 4间（仅用于武器，没有装甲）。
agent_equip_item                       = 1779	  # (agent_equip_item, <agent_id>, <item_id>, [weapon_slot_no]), #for weapons, agent needs to have an empty weapon slot. weapon_slot_no is optional, and can be between 1-4 (used only for weapons, not armor).

###获取刷新点坐标
entry_point_get_position               = 1780   # (entry_point_get_position, <position_no>, <entry_no>),
###设置刷新点坐标
entry_point_set_position               = 1781   # (entry_point_set_position, <entry_no>, <position_no>),
###刷新点是自动产生
entry_point_is_auto_generated          = 1782  	# (entry_point_is_auto_generated, <entry_no>),

###设置agent分隔，找不到那里用过此命令
agent_set_division                     = 1783   # (agent_set_division, <agent_id>, <value>),



############################组命令
###获取组停火命令
###获得步兵的攻击命令    (team_get_hold_fire_order, ":cur_hold_fire", ":team_no", "grc_infantry"),
###（grc_everyone所有 grc_infantry步兵 grc_archers弓箭手 grc_cavalry骑兵）
team_get_hold_fire_order               = 1784   # (team_get_hold_fire_order, <destination>, <team_no>, <sub_class>),
###获取组移动命令
team_get_movement_order                = 1785   # (team_get_movement_order, <destination>, <team_no>, <sub_class>),
###获取组骑马命令
team_get_riding_order                  = 1786   # (team_get_riding_order, <destination>, <team_no>, <sub_class>),
###获取组武器选择命令（例如钝器）
team_get_weapon_usage_order            = 1787   # (team_get_weapon_usage_order, <destination>, <team_no>, <sub_class>),
###组是敌军
teams_are_enemies                      = 1788   # (teams_are_enemies, <team_no>, <team_no_2>), 

###给与组命令
###(team_give_order, <组编号>, <步兵、骑兵、射手还是所有人类别>, <命令>),
###例如 (team_give_order, 1, grc_everyone, mordr_charge), 组1所有人进攻
###mordr_hold跟随 mordr_stand_closer聚拢 mordr_stand_ground坚守 mordr_charge进攻 mordr_spread_out散开
team_give_order                        = 1790   # (team_give_order, <team_no>, <sub_class>, <order_id>),

###设置组命令坐标
team_set_order_position                = 1791   # (team_set_order_position, <team_no>, <sub_class>, <position_no>),
###获取组首领
team_get_leader                        = 1792   # (team_get_leader, <destination>, <team_no>),
###设置组首领
team_set_leader                        = 1793   # (team_set_leader, <team_no>, <new_leader_agent_id>),
###获取组命令坐标
team_get_order_position                = 1794   # (team_get_order_position, <position_no>, <team_no>, <sub_class>),
###设置组命令听众，#如果值是非零与老听众合并 #如果sub_class小于零清除听众
team_set_order_listener                = 1795   # (team_set_order_listener, <team_no>, <sub_class>, <value>), #merge with old listeners if value is non-zero #clear listeners if sub_class is less than zero
###设置组关系 -1敌人 1朋友 0中立
team_set_relation                      = 1796   # (team_set_relation, <team_no>, <team_no_2>, <value>), # -1 for enemy, 1 for friend, 0 for neutral

###设置雨 1雨 2雪，值0 - 100
set_rain                               = 1797   # (set_rain,<rain-type>,<strength>), (rain_type: 1= rain, 2=snow ; strength: 0 - 100)
###设置雾距离
set_fog_distance                       = 1798   # (set_fog_distance, <distance_in_meters>, [fog_color]),
###获取场景分界线
get_scene_boundaries                   = 1799   # (get_scene_boundaries, <position_min>, <position_max>),

###联机命令
scene_prop_enable_after_time           = 1800   # (scene_prop_enable_after_time, <scene_prop_id>, <value>)
###联机命令
scene_prop_has_agent_on_it             = 1801   # (scene_prop_has_agent_on_it, <scene_prop_id>, <agent_id>)

###清除2个agent间的关系
agent_clear_relations_with_agents      = 1802   # (agent_clear_relations_with_agents, <agent_id>),
###两个agent之间添加关系 -1敌人 0中性（不友好攻击所有人） 1同盟友军
agent_add_relation_with_agent          = 1803   # (agent_add_relation_with_agent, <agent_id>, <agent_id>, <value>), #-1 = enemy, 0 = neutral (no friendly fire at all), 1 = ally

###获取agent物品slot，值为0-7，武器1，武器2，武器3，武器4，头护甲，身体护甲，脚护甲，手护甲
agent_get_item_slot                    = 1804   # (agent_get_item_slot, <destination>, <agent_id>, <value>), value between 0-7, order is weapon1, weapon2, weapon3, weapon4, head_armor, body_armor, leg_armor, hand_armor
###ai脸模组显示隐藏，1显示，0隐藏
ai_mesh_face_group_show_hide           = 1805   # (ai_mesh_face_group_show_hide, <group_no>, <value>), # 1 for enable, 0 for disable

###agent在惊慌？
agent_is_alarmed                       = 1806   # (agent_is_alarmed, <agent_id>),
###设置agent惊慌，1开启，0关闭
agent_set_is_alarmed                   = 1807   # (agent_set_is_alarmed, <agent_id>, <value>), # 1 for enable, 0 for disable
###停止agent音效
agent_stop_sound                       = 1808   # (agent_stop_sound, <agent_id>),
###设置攻击场景坐标y
agent_set_attached_scene_prop_y        = 1809   # (agent_set_attached_scene_prop_y, <agent_id>, <value>)

###获取场景道具实例数量
scene_prop_get_num_instances           = 1810	# (scene_prop_get_num_instances, <destination>, <scene_prop_id>),
###获取场景道具实例
scene_prop_get_instance                = 1811	# (scene_prop_get_instance, <destination>, <scene_prop_id>, <instance_no>),
###获取场景道具可视距离
scene_prop_get_visibility              = 1812   # (scene_prop_get_visibility, <destination>, <scene_prop_id>),
###设置场景道具可视距离
scene_prop_set_visibility              = 1813   # (scene_prop_set_visibility, <scene_prop_id>, <value>),
###设置场景道具打击点
scene_prop_set_hit_points              = 1814   # (scene_prop_set_hit_points, <scene_prop_id>, <value>),
###获取场景道具打击点
scene_prop_get_hit_points              = 1815   # (scene_prop_get_hit_points, <destination>, <scene_prop_id>),
###设置场景道具最大打击点
scene_prop_get_max_hit_points          = 1816   # (scene_prop_get_max_hit_points, <destination>, <scene_prop_id>),
###获取场景道具组别
scene_prop_get_team                    = 1817   # (scene_prop_get_team, <value>, <scene_prop_id>),
###设置场景道具组别
scene_prop_set_team                    = 1818   # (scene_prop_set_team, <scene_prop_id>, <value>),
###设置场景道具删除时间,删除时间只能设置对象已经在删除队列。静止的物体不受此操作。
scene_prop_set_prune_time              = 1819   # (scene_prop_set_prune_time, <scene_prop_id>, <value>), # prune time can only be set to objects that are already on the prune queue. static objects are not affected by this operation.
###设置场景道具当前打击点
scene_prop_set_cur_hit_points          = 1820   # (scene_prop_set_cur_hit_points, <scene_prop_id>, <value>),

###场景道具渐隐
scene_prop_fade_out                    = 1822   # (scene_prop_fade_out, <scene_prop_id>, <fade_out_time>)
###场景道具渐显
scene_prop_fade_in                     = 1823   # (scene_prop_fade_in, <scene_prop_id>, <fade_in_time>)

###获取agent弹药slot，插槽不可以0 - 3之间
agent_get_ammo_for_slot                = 1825	# (agent_get_ammo_for_slot, <destination>, <agent_id>, <slot_no>), #slot no can be between 0-3
###agent是瞄准线上的，不使用旋转的位置寄存器
agent_is_in_line_of_sight              = 1826 # (agent_is_in_line_of_sight, <agent_id>, <position_no>), # rotation of the position register is not used.


###加强版本的传递伤害！制作群伤者的福音
###(agent_deliver_damage_to_agent_advanced, <变量>, <射手agent的id>, <agent_id>, <值>, [物品_id]),
###例：  (agent_deliver_damage_to_agent_advanced, ":delivered", ":shooter_agent_no", ":agent_no", ":damage"),
###如果值小于等于0，将计算使用的武器项目。# item_id是项目的损害是交付。可以被忽略 #这种先进模式有2个不同agent_deliver_damage_to_agent
###1 -交付损害返回。
###2 -损害交付完成后，检查agent的关系。这可能不造成损害，甚至由于友军炮火损坏射手。
agent_deliver_damage_to_agent_advanced = 1827	# (agent_deliver_damage_to_agent_advanced, <destination>, <agent_id_deliverer>, <agent_id>, <value>, [item_id]), #if value <= 0, then damage will be calculated using the weapon item. # item_id is the item that the damage is delivered. can be ignored.
#this advanced mode of agent_deliver_damage_to_agent has 2 differences. 1- the delivered damage is returned. 2- the damage delivery is done after checking the relationship between agents. this might cause no damage, or even damage to the shooter agent because of a friendly fire.
team_get_gap_distance				   = 1828   # (team_get_gap_distance, <destination>, <team_no>, <sub_class>),


###添加投射物，连射，陷阱，天上射出各种乱箭不是梦想了
###(add_missile, <agent_id>, <起始坐标>, <起始速度固定点>, <武器物品id>, <武器物品调节器>, <物品触发器id>, <物品触发器调节器>),
add_missile                            = 1829	# (add_missile, <agent_id>, <starting_position>, <starting_speed_fixed_point>, <weapon_item_id>, <weapon_item_modifier>, <missile_item_id>, <missile_item_modifier>), # starting position also contains the direction of the arrow 起始位置也包含箭头方向


###获得场景物品实例数量
scene_item_get_num_instances           = 1830	# (scene_item_get_num_instances, <destination>, <item_id>),
###获得场景物品实例
scene_item_get_instance                = 1831	# (scene_item_get_instance, <destination>, <item_id>, <instance_no>),
###获取场景重生点的物品实例数量
scene_spawned_item_get_num_instances   = 1832	# (scene_spawned_item_get_num_instances, <destination>, <item_id>),
###获取场景重生点的物品实例
scene_spawned_item_get_instance        = 1833	# (scene_spawned_item_get_instance, <destination>, <item_id>, <instance_no>),
###场景是否允许骑马单位
scene_allows_mounted_units             = 1834   # (scene_allows_mounted_units),

###设置类名称
class_set_name                         = 1837 # (class_set_name, <sub_class>, <string_id>),

###有效的道具实例
prop_instance_is_valid                 = 1838 # (prop_instance_is_valid, <scene_prop_id>),
###获取有效的道具实例ID
prop_instance_get_variation_id         = 1840	# (prop_instance_get_variation_id, <destination>, <scene_prop_id>),
###获取有效的道具实例ID2
prop_instance_get_variation_id_2       = 1841	# (prop_instance_get_variation_id_2, <destination>, <scene_prop_id>),


###获取道具实例坐标
prop_instance_get_position             = 1850	# (prop_instance_get_position, <position_no>, <scene_prop_id>),
###获取道具实例开始坐标
prop_instance_get_starting_position    = 1851	# (prop_instance_get_starting_position, <position_no>, <scene_prop_id>),
###获取道具实例比例
prop_instance_get_scale                = 1852	# (prop_instance_get_scale, <position_no>, <scene_prop_id>),
###获取场景道具实例的同类道具
prop_instance_get_scene_prop_kind      = 1853   # (prop_instance_get_scene_prop_type, <destination>, <scene_prop_id>)
###设置道具实例比例
prop_instance_set_scale                = 1854 # (prop_instance_set_scale, <scene_prop_id>, <value_x_fixed_point>, <value_y_fixed_point>, <value_z_fixed_point>),
###设置道具实例坐标
###dont_send_to_clients参数默认为0，因此，发送给客户。如果你只是做一些物理测试场景道具，然后不要给他们的客户
prop_instance_set_position             = 1855	# (prop_instance_set_position, <scene_prop_id>, <position_no>, [dont_send_to_clients]),
#dont_send_to_clients default is 0, therefore it is sent to clients. if you are just doing some physics checks with scene props, then don't send them to clients
###道具实例动作到坐标
prop_instance_animate_to_position      = 1860	# (prop_instance_animate_to_position, <scene_prop_id>, position, <duration-in-1/100-seconds>),
###道具实例停止动作
prop_instance_stop_animating           = 1861	# (prop_instance_stop_animating, <scene_prop_id>),
###道具实例是动作的
prop_instance_is_animating             = 1862   # (prop_instance_is_animating, <destination>, <scene_prop_id>),
###获取道具实例动作触发坐标
prop_instance_get_animation_target_position = 1863    # (prop_instance_get_animation_target_position, <pos>, <scene_prop_id>)
###道具实例使用物理学，0关闭，1开启
prop_instance_enable_physics           = 1864   # (prop_instance_enable_physics, <scene_prop_id>, <value>) #0 for disable, 1 for enable
###道具实例选择到坐标
prop_instance_rotate_to_position       = 1865	# (prop_instance_rotate_to_position, <scene_prop_id>, position, <duration-in-1/100-seconds>, <total_rotate_angle>),
###道具实例初始旋转角度
prop_instance_initialize_rotation_angles = 1866   # (prop_instance_initialize_rotation_angles, <scene_prop_id>),
###道具实例恢复打击点
prop_instance_refill_hit_points        = 1870 # (prop_instance_refill_hit_points, <scene_prop_id>), 

###设置道具实例动力学特性
prop_instance_dynamics_set_properties  = 1871 # (prop_instance_dynamics_set_properties,<scene_prop_id>,mass_friction),
###设置道具实例动力学速度
prop_instance_dynamics_set_velocity    = 1872 # (prop_instance_dynamics_set_velocity,<scene_prop_id>,linear_velocity),
###设置道具实例动力学结果
prop_instance_dynamics_set_omega       = 1873 # (prop_instance_dynamics_set_omega,<scene_prop_id>,angular_velocity),
###道具实例动力学推动应用
prop_instance_dynamics_apply_impulse   = 1874 # (prop_instance_dynamics_apply_impulse,<scene_prop_id>,impulse_force),

###道具实例接收损伤
prop_instance_receive_damage           = 1877 # (prop_instance_receive_damage, <scene_prop_id>, <agent_id>, <damage_value>),

###道具实例和道具实例交叉
prop_instance_intersects_with_prop_instance = 1880 # (prop_instance_intersects_with_prop_instance, <scene_prop_id>, <scene_prop_id>), #give second scene_prop_id as -1 to check all scene props.
#cannot check polygon-to-polygon physics models, but can check any other combinations between sphere, capsule and polygon physics models.

###道具实例播放音效
prop_instance_play_sound               = 1881 # (prop_instance_play_sound, <scene_prop_id>, <sound_id>, [flags]), # sound flags can be given
###道具实例停止音效
prop_instance_stop_sound               = 1882 # (prop_instance_stop_sound, <scene_prop_id>),

###清除道具实例上投射物
prop_instance_clear_attached_missiles  = 1885 # (prop_instance_clear_attached_missiles, <scene_prop_id>), # Works only with dynamic scene props (non-retrievable missiles)

###道具实例增加粒子效果
prop_instance_add_particle_system      = 1886 # (prop_instance_add_particle_system, <scene_prop_id>, <par_sys_id>, <position_no>), # position is local, not global.
###道具实例停止粒子效果
prop_instance_stop_all_particle_systems= 1887 # (prop_instance_stop_all_particle_systems, <scene_prop_id>),


###替换道具实例
replace_prop_instance                  = 1889   # (replace_prop_instance, <scene_prop_id>, <new_scene_prop_id>),
###替换场景道具
replace_scene_props                    = 1890   # (replace_scene_props, <old_scene_prop_id>,<new_scene_prop_id>),
###替换场景物品与场景道具
replace_scene_items_with_scene_props   = 1891   # (replace_scene_items_with_scene_props, <old_item_id>,<new_scene_prop_id>),



#---------------------------
# Mission Consequence types
#---------------------------
# 触发器结果相关命令
#---------------------------

###设置触发器结果
set_mission_result                     = 1906	# (set_mission_result,<value>),
###结束触发器
finish_mission                         = 1907	# (finish_mission, <delay_in_seconds>),
###跳转场景
jump_to_scene                          = 1910	# (jump_to_scene,<scene_id>,<entry_no>),
###设置跳转触发器
set_jump_mission                       = 1911	# (set_jump_mission,<mission_template_id>),
###设置跳转入口
set_jump_entry                         = 1912	# (set_jump_entry,<entry_no>),
###开始触发器对话
start_mission_conversation             = 1920	# (start_mission_conversation,<troop_id>),
###增加援军到入口
add_reinforcements_to_entry            = 1930	# (add_reinforcements_to_entry,<mission_template_entry_no>,<value>),

###谈话触发器开启
mission_enable_talk                    = 1935   # (mission_enable_talk), #can talk with troops during battles
###谈话触发器关闭
mission_disable_talk                   = 1936   # (mission_disable_talk), #disables talk option for the mission

###设置入口佣金参数
mission_tpl_entry_set_override_flags   = 1940   # (mission_entry_set_override_flags, <mission_template_id>, <entry_no>, <value>),
###清除入口佣金物品
mission_tpl_entry_clear_override_items = 1941   # (mission_entry_clear_override_items, <mission_template_id>, <entry_no>),
###增加入口佣金物品
mission_tpl_entry_add_override_item    = 1942   # (mission_entry_add_override_item, <mission_template_id>, <entry_no>, <item_kind_id>),

###设置现在的颜色
set_current_color                      = 1950	# red, green, blue: a value of 255 means 100%
					          # (set_current_color,<value>,<value>,<value>),
###设置坐标变量
set_position_delta                     = 1955	# x, y, z
                                                  # (set_position_delta,<value>,<value>,<value>),

###增加灯光点
add_point_light                        = 1960	# (add_point_light,[flicker_magnitude],[flicker_interval]), #flicker_magnitude between 0 and 100, flicker_interval is in 1/100 seconds
###增加灯光点到实体
add_point_light_to_entity              = 1961	# (add_point_light_to_entity,[flicker_magnitude],[flicker_interval]), #flicker_magnitude between 0 and 100, flicker_interval is in 1/100 seconds
###增加新粒子系统
particle_system_add_new                = 1965	# (particle_system_add_new,<par_sys_id>,[position_no]),
###粒子系统发射
particle_system_emit                   = 1968	# (particle_system_emit,<par_sys_id>,<value_num_particles>,<value_period>),
###粒子系统爆炸
particle_system_burst                  = 1969	# (particle_system_burst,<par_sys_id>,<position_no>,[percentage_burst_strength]),

###设置重生点坐标
set_spawn_position                     = 1970   # (set_spawn_position, <position_no>) 
###物品重生点
spawn_item                             = 1971   # (spawn_item, <item_kind_id>, <item_modifier>, [seconds_before_pruning]) #if seconds_before_pruning = 0 then item never gets pruned
###agent重生点
spawn_agent                            = 1972	# (spawn_agent,<troop_id>), (stores agent_id in reg0)
###马重生点
spawn_horse                            = 1973	# (spawn_horse,<item_kind_id>, <item_modifier>)  (stores agent_id in reg0)
##场景道具重生点
spawn_scene_prop                       = 1974   # (spawn_scene_prop, <scene_prop_id>)  (stores prop_instance_id in reg0) not yet.

######粒子系统爆炸没有sync
particle_system_burst_no_sync		   = 1975	# (particle_system_burst_without_sync,<par_sys_id>,<position_no>,[percentage_burst_strength]),

###野外再生物品重生点
spawn_item_without_refill              = 1976   # (spawn_item_without_refill, <item_kind_id>, <item_modifier>, [seconds_before_pruning]) #if seconds_before_pruning = 0 then item never gets pruned

###得到当前agent弹药量
agent_get_item_cur_ammo                = 1977	# (agent_get_item_cur_ammo, <destination>, <agent_id>, <slot_no>)

###添加模组纹理到当前纹理
cur_tableau_add_tableau_mesh           = 1980   # (cur_tableau_add_tableau_mesh, <tableau_material_id>, <value>, <position_register_no>), #value is passed to tableau_material
###设置当前物品的纹理
cur_item_set_tableau_material          = 1981   # (cur_item_set_tableu_material, <tableau_material_id>, <instance_code>), #only call inside ti_on_init_item in module_items
###设置当前场景道具的纹理
cur_scene_prop_set_tableau_material    = 1982   # (cur_scene_prop_set_tableau_material, <tableau_material_id>, <instance_code>), #only call inside ti_on_init_scene_prop in module_scene_props
###设置当前大地图icon的纹理
cur_map_icon_set_tableau_material      = 1983   # (cur_map_icon_set_tableau_material, <tableau_material_id>, <instance_code>), #only call inside ti_on_init_map_icon in module_scene_props
###纹理底层透明通道
cur_tableau_render_as_alpha_mask       = 1984   # (cur_tableau_render_as_alpha_mask)
###设置纹理背景颜色
cur_tableau_set_background_color       = 1985   # (cur_tableau_set_background_color, <value>),
###设置当前agent旗帜纹理
cur_agent_set_banner_tableau_material  = 1986   # (cur_agent_set_banner_tableau_material, <tableau_material_id>)
###设置灯光环境纹理
cur_tableau_set_ambient_light          = 1987   # (cur_tableau_set_ambient_light, <red_fixed_point>, <green_fixed_point>, <blue_fixed_point>),
cur_tableau_set_camera_position        = 1988   # (cur_tableau_set_camera_position, <position_no>),
cur_tableau_set_camera_parameters      = 1989   # (cur_tableau_set_camera_parameters, <is_perspective>, <camera_width_times_1000>, <camera_height_times_1000>, <camera_near_times_1000>, <camera_far_times_1000>),
###增加灯光点纹理
cur_tableau_add_point_light            = 1990   # (cur_tableau_add_point_light, <map_icon_id>, <position_no>, <red_fixed_point>, <green_fixed_point>, <blue_fixed_point>),
###增加太阳光纹理
cur_tableau_add_sun_light              = 1991   # (cur_tableau_add_sun_light, <map_icon_id>, <position_no>, <red_fixed_point>, <green_fixed_point>, <blue_fixed_point>),
###模组添加纹理
cur_tableau_add_mesh                   = 1992   # (cur_tableau_add_mesh, <mesh_id>, <position_no>, <value_fixed_point>, <value_fixed_point>),
                                                # first value fixed point is the scale factor, second value fixed point is alpha. use 0 for default values
###模组纹理顶点颜色
cur_tableau_add_mesh_with_vertex_color = 1993   # (cur_tableau_add_mesh_with_vertex_color, <mesh_id>, <position_no>, <value_fixed_point>, <value_fixed_point>, <value>),
                                                # first value fixed point is the scale factor, second value fixed point is alpha. value is vertex color. use 0 for default values. vertex_color has no default value.

###添加大地图icon纹理
cur_tableau_add_map_icon               = 1994   # (cur_tableau_add_map_icon, <map_icon_id>, <position_no>, <value_fixed_point>),
                                                # value fixed point is the scale factor
                                                
###添加troop纹理
cur_tableau_add_troop                  = 1995   # (cur_tableau_add_troop, <troop_id>, <position_no>, <animation_id>, <instance_no>), #if instance_no value is 0 or less, then the face is not generated randomly (important for heroes)
###添加马纹理
cur_tableau_add_horse                  = 1996   # (cur_tableau_add_horse, <item_id>, <position_no>, <animation_id>),
###设置雇佣信息纹理
cur_tableau_set_override_flags         = 1997   # (cur_tableau_set_override_flags, <value>),
###清除雇佣物品纹理
cur_tableau_clear_override_items       = 1998   # (cur_tableau_clear_override_items),
###添加雇佣物品纹理
cur_tableau_add_override_item          = 1999   # (cur_tableau_add_override_item, <item_kind_id>),
cur_tableau_add_mesh_with_scale_and_vertex_color = 2000   # (cur_tableau_add_mesh_with_scale_and_vertex_color, <mesh_id>, <position_no>, <position_no>, <value_fixed_point>, <value>),
                                                # second position_no is x,y,z scale factors (with fixed point values). value fixed point is alpha. value is vertex color. use 0 for default values. scale and vertex_color has no default values.

 
###设置触发器镜头模式
###离开时，手动模式，持续时间定义的动画时间从起始位置到新位置。设为0即时相机位置更新
###如果值=0，然后将摄像机线性速度。它将是非线性的
mission_cam_set_mode                   = 2001   # (mission_cam_set_mode, <mission_cam_mode>, <duration-in-1/1000-seconds>, <value>) # when leaving manual mode, duration defines the animation time from the initial position to the new position. set as 0 for instant camera position update
# if value = 0, then camera velocity will be linear. else it will be non-linear


###获取触发器加速时间
mission_get_time_speed                 = 2002   # (mission_get_time_speed, <destination_fixed_point>),
###设置触发器加速时间
mission_set_time_speed                 = 2003   # (mission_set_time_speed, <value_fixed_point>) #this works only when cheat mode is enabled
###加速时间移动到变量触发器
mission_time_speed_move_to_value       = 2004   # (mission_speed_move_to_value, <value_fixed_point>, <duration-in-1/1000-seconds>) #this works only when cheat mode is enabled
###设置触发器决斗模式（0关闭 1开启）
mission_set_duel_mode                  = 2006   # (mission_set_duel_mode, <value>), #value: 0 = off, 1 = on

###设置触发器镜头屏幕颜色
mission_cam_set_screen_color           = 2008   #(mission_cam_set_screen_color, <value>), #value is color together with alpha
###触发器镜头驱动到屏幕颜色
mission_cam_animate_to_screen_color    = 2009   #(mission_cam_animate_to_screen_color, <value>, <duration-in-1/1000-seconds>), #value is color together with alpha

###获取触发器镜头坐标
mission_cam_get_position               = 2010   # (mission_cam_get_position, <position_register_no>)
###设置触发器镜头坐标
mission_cam_set_position               = 2011   # (mission_cam_set_position, <position_register_no>)
###触发器镜头驱动到坐标
mission_cam_animate_to_position        = 2012   # (mission_cam_animate_to_position, <position_register_no>, <duration-in-1/1000-seconds>, <value>) # if value = 0, then camera velocity will be linear. else it will be non-linear
###获取触发器镜头光圈
mission_cam_get_aperture               = 2013   # (mission_cam_get_aperture, <destination>)
###设置触发器镜头光圈
mission_cam_set_aperture               = 2014   # (mission_cam_set_aperture, <value>)
###触发器镜头驱动到光圈
mission_cam_animate_to_aperture        = 2015   # (mission_cam_animate_to_aperture, <value>, <duration-in-1/1000-seconds>, <value>) # if value = 0, then camera velocity will be linear. else it will be non-linear
###触发器镜头驱动到坐标和光圈
mission_cam_animate_to_position_and_aperture = 2016   # (mission_cam_animate_to_position_and_aperture, <position_register_no>, <value>, <duration-in-1/1000-seconds>, <value>) # if value = 0, then camera velocity will be linear. else it will be non-linear
###设置触发器镜头触发agent
mission_cam_set_target_agent           = 2017   # (mission_cam_set_target_agent, <agent_id>, <value>) #if value = 0 then do not use agent's rotation, else use agent's rotation
###清除触发器镜头触发agent
mission_cam_clear_target_agent         = 2018   # (mission_cam_clear_target_agent)
###设置触发器镜头动画
mission_cam_set_animation              = 2019   # (mission_cam_set_animation, <anim_id>),

###显示隐藏谈话信息面板（即谈话时鼠标移动到npc框出现一个关系好感面板） 0隐藏，1显示
###参考script_setup_talk_info
talk_info_show                         = 2020   # (talk_info_show, <hide_or_show>) :0=hide 1=show
###设置谈话信息好感条，集合关系到- 100到100之间的值，输入一个无效的值隐藏好感条。
talk_info_set_relation_bar             = 2021   # (talk_info_set_relation_bar, <value>) :set relation bar to a value between -100 to 100, enter an invalid value to hide the bar.
###设置谈话信息行 (talk_info_set_line, <在第几行输出文本内容>, <具体文本内容>)
talk_info_set_line                     = 2022   # (talk_info_set_line, <line_no>, <string_no>)

#mesh related
###设置背景图片模组（图片查看module_meshes.py文件）
set_background_mesh                    = 2031   # (set_background_mesh, <mesh_id>),
###设置游戏菜单画面模组，相关模组参考ID_tableau_materials.py
set_game_menu_tableau_mesh             = 2032   # (set_game_menu_tableau_mesh, <tableau_material_id>, <value>, <position_register_no>), #value is passed to tableau_material
                                                # position contains the following information: x = x position of the mesh, y = y position of the mesh, z = scale of the mesh


############################改变场景类型
#change_window types.
###屏幕切换回上一个
change_screen_return                   = 2040	# (change_screen_return),
###屏幕切换到掠夺<troop_id>的界面
change_screen_loot                     = 2041	# (change_screen_loot, <troop_id>),
###屏幕切换到交易界面
change_screen_trade                    = 2042	# (change_screen_trade, <troop_id>),
###屏幕切换到交换队伍成员的界面，第2个参数，为0，那么就不交换队伍的首领，为1就可以交换队伍的首领
change_screen_exchange_members         = 2043 # (change_screen_exchange_members, [0,1 = exchange_leader], [party_id]), #if party id is not given, current party will be used
###屏幕切换到交易俘虏的界面
change_screen_trade_prisoners          = 2044	# (change_screen_trade_prisoners),
###屏幕切换到买雇佣兵的界面
change_screen_buy_mercenaries          = 2045	# (change_screen_buy_mercenaries),
###屏幕切换到查看角色情况的界面
change_screen_view_character           = 2046	# (change_screen_view_character),
###屏幕切换到训练的界面
change_screen_training                 = 2047	# (change_screen_training),
###屏幕切换到开战的界面
change_screen_mission                  = 2048	# (change_screen_mission),
###屏幕切换到地图上对话的界面
change_screen_map_conversation         = 2049   # (change_screen_map_conversation, <troop_id>),
###屏幕切换到与<party_id>交换队伍成员的界面
change_screen_exchange_with_party      = 2050   # (change_screen_exchange_with_party, <party_id>),
###屏幕切换到给<troop_id>换装备的界面
change_screen_equip_other              = 2051	# (change_screen_equip_other, <troop_id>),
###屏幕切换到大地图
change_screen_map                      = 2052
###屏幕切换到对象的注释说明上。 <object_id>是对象的ID。 <note_type>是对象的类型，它的值可以是1（兵种），2（阵营），3（部队，城堡，城镇，村子），4（任务），5（页面信息）。
change_screen_notes                    = 2053   # (change_screen_notes, <note_type>, <object_id>), #Note type can be 1 = troops, 2 = factions, 3 = parties, 4 = quests, 5 = info_pages

###返回到游戏开始主界面
change_screen_quit                     = 2055   # (change_screen_quit),
###屏幕切换到给出自己部队的成员(只能给不能取)，用于给领主士兵。
change_screen_give_members             = 2056   # (change_screen_give_members, [party_id]), #if party id is not given, current party will be used
###游戏按键设置界面
change_screen_controls                 = 2057   # (change_screen_controls),
###游戏选项设置界面
change_screen_options                  = 2058   # (change_screen_options),


###跳到<menu_id>这个菜单
jump_to_menu                           = 2060	# (jump_to_menu,<menu_id>),
###禁用菜单的选项
disable_menu_option                    = 2061   # (disable_menu_option),

###存储调用触发器时的第x个参数。
store_trigger_param    = 2070  # (store_trigger_param, <destination>, <trigger_param_no>),
###存储调用触发器时的第1个参数。
store_trigger_param_1  = 2071  # (store_trigger_param_1,<destination>),
###存储调用触发器时的第2个参数。
store_trigger_param_2  = 2072  # (store_trigger_param_2,<destination>),
###存储调用触发器时的第3个参数。
store_trigger_param_3  = 2073  # (store_trigger_param_3,<destination>),
###设定触发器的返回值
set_trigger_result     = 2075  # (set_trigger_result, <value>),

###获取agent瞄准攻击ai
agent_ai_get_look_target               = 2080 # (agent_ai_get_look_target, <destination>, <agent_id>),
###获取agent移动攻击ai
agent_ai_get_move_target               = 2081 # (agent_ai_get_move_target, <destination>, <agent_id>),
###获取agent攻击行为ai
agent_ai_get_behavior_target           = 2082 # (agent_ai_get_behavior_target, <destination>, <agent_id>),
###设置可以蹲下ai，0关闭 1开启
agent_ai_set_can_crouch                = 2083 # (agent_ai_set_can_crouch, <agent_id>, <value>), # 0 for false, 1 for true.

###设置agent最大打击点
agent_set_max_hit_points               = 2090	# set absolute to 1 if value is absolute, otherwise value will be treated as relative number in range [0..100]
						# (agent_set_max_hit_points,<agent_id>,<value>,[absolute]),

###设置agent伤害调节器（值是百分比，默认值100）
agent_set_damage_modifier              = 2091   # (agent_set_damage_modifier, <agent_id>, <value>), # value is in percentage, 100 is default

###设置agent射击精确度调节器（值是百分比，默认值100，范围0-1000）
agent_set_accuracy_modifier            = 2092   # (agent_set_accuracy_modifier, <agent_id>, <value>), # value is in percentage, 100 is default, value can be between [0..1000]

###设置agetn速度调节器（值是百分比，默认值100，范围0-1000）
agent_set_speed_modifier               = 2093   # (agent_set_speed_modifier, <agent_id>, <value>), # value is in percentage, 100 is default, value can be between [0..1000]

###设置agetn再装填速度调节器（值是百分比，默认值100，范围0-1000）
agent_set_reload_speed_modifier        = 2094   # (agent_set_reload_speed_modifier, <agent_id>, <value>), # value is in percentage, 100 is default, value can be between [0..1000]

###设置agent使用速度调节器（值是百分比，默认值100，范围0-1000）
agent_set_use_speed_modifier           = 2095   # (agent_set_use_speed_modifier, <agent_id>, <value>), # value is in percentage, 100 is default, value can be between [0..1000]

###agent设置隐藏（0隐匿的 1看得见的）
agent_set_visibility                   = 2096   # (agent_set_visibility, <agent_id>, <value>), # 0 for invisible, 1 for visible.

###agent获取蹲伏模式
agent_get_crouch_mode                  = 2097   # (agent_ai_get_crouch_mode, <destination>, <agent_id>),
###agent设置蹲伏模式
agent_set_crouch_mode                  = 2098   # (agent_ai_set_crouch_mode, <agent_id>, <value>), # 0-1

###左shift键值？
val_lshift             = 2100 # (val_lshift, <destination>, <value>), # shifts the bits of destination to left by value amount.
###右shift键值？
val_rshift             = 2101 # (val_rshift, <destination>, <value>), # shifts the bits of destination to right by value amount.

###值的 + 操作
val_add                = 2105	#dest, operand ::       dest = dest + operand
				# (val_add,<destination>,<value>),
###值的 - 操作
val_sub                = 2106	#dest, operand ::       dest = dest + operand
				# (val_sub,<destination>,<value>),
###值的 × 操作
val_mul                = 2107	#dest, operand ::       dest = dest * operand
				# (val_mul,<destination>,<value>),
###值的 / 操作
val_div                = 2108	#dest, operand ::       dest = dest / operand
				# (val_div,<destination>,<value>),
###值的取余数操作
val_mod                = 2109	#dest, operand ::       dest = dest mod operand
				# (val_mod,<destination>,<value>),
###值的取较小的数的操作
val_min                = 2110	#dest, operand ::       dest = min(dest, operand)
				# (val_min,<destination>,<value>),
###值的取较大的数的操作
val_max                = 2111	#dest, operand ::       dest = max(dest, operand)
				# (val_max,<destination>,<value>),
###值的取中间大小的数的操作
###(val_clamp,<变量>,<下限>, <上限>)
val_clamp              = 2112	#dest, operand ::       dest = max(min(dest,<upper_bound> - 1),<lower_bound>)
				# (val_clamp,<destination>,<lower_bound>, <upper_bound>),
###值的取绝对值的操作
val_abs                = 2113  #dest          ::       dest = abs(dest)
                                # (val_abs,<destination>),

###逻辑或操作 
val_or                 = 2114   #dest, operand ::       dest = dest | operand
				# (val_or,<destination>,<value>),
###逻辑与操作
val_and                = 2115   #dest, operand ::       dest = dest & operand
				# (val_and,<destination>,<value>),
###储存或的操作结果到
store_or               = 2116   #dest, op1, op2 :      dest = op1 | op2
                                # (store_or,<destination>,<value>,<value>),
###储存与的操作结果到
store_and              = 2117   #dest, op1, op2 :      dest = op1 & op2
                                # (store_or,<destination>,<value>,<value>),

###储存取余数操作的结果到
store_mod              = 2119	#dest, op1, op2 :      dest = op1 % op2
				# (store_mod,<destination>,<value>,<value>),
###储存值相加的结果到
store_add              = 2120	#dest, op1, op2 :      dest = op1 + op2
				# (store_add,<destination>,<value>,<value>),
###储存值相减的结果到
store_sub              = 2121	#dest, op1, op2 :      dest = op1 - op2
				# (store_sub,<destination>,<value>,<value>),
###储存值相乘的结果到
store_mul              = 2122	#dest, op1, op2 :      dest = op1 * op2
				# (store_mul,<destination>,<value>,<value>),
###储存值相除的结果到
store_div              = 2123	#dest, op1, op2 :      dest = op1 / op2
				# (store_div,<destination>,<value>,<value>),

###设置乘数固定点(缩放比率，数值越大对象越小)
set_fixed_point_multiplier      = 2124 # (set_fixed_point_multiplier, <value>),
                                        # sets the precision of the values that are named as value_fixed_point or destination_fixed_point.
                                        # Default is 1 (every fixed point value will be regarded as an integer)

###存储平方根
store_sqrt             = 2125  # (store_sqrt, <destination_fixed_point>, <value_fixed_point>), takes square root of the value
###存储幂次
store_pow              = 2126  # (store_pow, <destination_fixed_point>, <value_fixed_point>, <value_fixed_point), takes square root of the value
                                #dest, op1, op2 :      dest = op1 ^ op2
###存储正弦
store_sin              = 2127  # (store_sin, <destination_fixed_point>, <value_fixed_point>), takes sine of the value that is in degrees
###存储余弦
store_cos              = 2128  # (store_cos, <destination_fixed_point>, <value_fixed_point>), takes cosine of the value that is in degrees
###存储正切
store_tan              = 2129  # (store_tan, <destination_fixed_point>, <value_fixed_point>), takes tangent of the value that is in degrees

###旋转到固定点
convert_to_fixed_point = 2130  # (convert_to_fixed_point, <destination_fixed_point>), multiplies the value with the fixed point multiplier
###从固定点旋转
convert_from_fixed_point= 2131 # (convert_from_fixed_point, <destination>), divides the value with the fixed point multiplier

###变量赋值命令
assign                 = 2133	# had to put this here so that it can be called from conditions.
				# (assign,<destination>,<value>),
###重置随机
shuffle_range          = 2134	# (shuffle_range,<reg_no>,<reg_no>),

###获取一个随机数
store_random           = 2135	# deprecated, use store_random_in_range instead.
###在设定范围内获取一个随机数
###(store_random_in_range,变量,最小值,最大值)
store_random_in_range  = 2136	# gets random number in range [range_low,range_high] excluding range_high 
				# (store_random_in_range,<destination>,<range_low>,<range_high>),

###反正弦值
store_asin             = 2140  # (store_asin, <destination_fixed_point>, <value_fixed_point>),
###反余弦值
store_acos             = 2141  # (store_acos, <destination_fixed_point>, <value_fixed_point>),
###反正切值
store_atan             = 2142  # (store_atan, <destination_fixed_point>, <value_fixed_point>),
###反正切值2
store_atan2            = 2143  # (store_atan2, <destination_fixed_point>, <value_fixed_point>, <value_fixed_point>), #first value is y, second is x

###获取troop有多少钱
store_troop_gold       = 2149	# (store_troop_gold,<destination>,<troop_id>),

###获取队伍还能容纳的兵种数量，一个队伍兵种限制是24种
store_num_free_stacks           = 2154 # (store_num_free_stacks,<destination>,<party_id>),
###获取队伍还能容纳的囚犯兵种数量
store_num_free_prisoner_stacks  = 2155 # (store_num_free_prisoner_stacks,<destination>,<party_id>),

###获取队伍人数（包括俘虏）
store_party_size                = 2156	# (store_party_size,<destination>,[party_id]),
###获取队伍人数（不包括俘虏）
store_party_size_wo_prisoners   = 2157	# (store_party_size_wo_prisoners,<destination>,[party_id]),
###获取troop类型数量。废弃，使用 party_count_members_of_type 命令
store_troop_kind_count          = 2158 # deprecated, use party_count_members_of_type instead
###存储正规军囚犯数
store_num_regular_prisoners     = 2159	# (store_mum_regular_prisoners,<destination>,<party_id>),

###存储troop同伴数
store_troop_count_companions    = 2160	# (store_troop_count_companions,<destination>,<troop_id>,[party_id]),
###存储troop囚犯数
store_troop_count_prisoners     = 2161	# (store_troop_count_prisoners,<destination>,<troop_id>,[party_id]),

###获取物品相同种类数量
store_item_kind_count           = 2165	# (store_item_kind_count,<destination>,<item_id>,[troop_id]),

###存储自由的物品栏容量
store_free_inventory_capacity   = 2167	# (store_free_inventory_capacity,<destination>,[troop_id]),

###获取技能等级
store_skill_level               = 2170	# (store_skill_level,<destination>,<skill_id>,[troop_id]),
###获取人物等级
store_character_level           = 2171	# (store_character_level,<destination>,[troop_id]),
###获取属性等级
### store_attribute_level,<变量>,<troop_id>,<属性id>
store_attribute_level           = 2172	# (store_attribute_level,<destination>,<troop_id>,<attribute_id>),

###设定troop势力 (store_troop_faction,"fac_player_supporters_faction","trp_player"),
store_troop_faction             = 2173	# (store_troop_faction,<destination>,<troop_id>),
###获取troop属于那个势力
store_faction_of_troop          = 2173	# (store_troop_faction,<destination>,<troop_id>),
###获取troop生命值
store_troop_health              = 2175	# (store_troop_health,<destination>,<troop_id>,[absolute]),

                                        # set absolute to 1 to get actual health; otherwise this will return percentage health in range (0-100)

###存储熟练度等级
store_proficiency_level         = 2176	# (store_proficiency_level,<destination>,<troop_id>,<attribute_id>),

					# (store_troop_health,<destination>,<troop_id>,[absolute]),
###存储2个阵营的好感关系到变量
store_relation                  = 2190	# (store_relation,<destination>,<faction_id_1>,<faction_id_2>),
###设置要对话的troop
set_conversation_speaker_troop  = 2197  # (set_conversation_speaker_troop, <troop_id>),
###设置要对话的agent
set_conversation_speaker_agent  = 2198  # (set_conversation_speaker_troop, <agent_id>),
###存储正在对话的agent ID
store_conversation_agent        = 2199 # (store_conversation_agent,<destination>),
###存储正在对话的troop ID
store_conversation_troop        = 2200 # (store_conversation_troop,<destination>),
###存储同伴阵营
store_partner_faction           = 2201 # (store_partner_faction,<destination>),
###存储遭遇的队伍
store_encountered_party         = 2202 # (store_encountered_party,<destination>),
###存储遭遇的队伍2
store_encountered_party2        = 2203 # (store_encountered_party2,<destination>),
###存储队伍的阵营
store_faction_of_party          = 2204 # (store_faction_of_party, <destination>, <party_id>),
###设置遭遇队伍
set_encountered_party           = 2205 # (set_encountered_party,<destination>),


#store_current_town              = 2210 # deprecated, use store_current_scene instead
#store_current_site              = 2211 # deprecated, use store_current_scene instead
###存储当前场景
store_current_scene             = 2211 # (store_current_scene,<destination>),

###存储缩放数
store_zoom_amount               = 2220 # (store_zoom_amount, <destination_fixed_point>),
###设置缩放数
set_zoom_amount                 = 2221 # (set_zoom_amount, <value_fixed_point>),
###判断缩放是否关闭
is_zoom_disabled                = 2222 # (is_zoom_disabled),

###存储物品id值
store_item_value                = 2230 # (store_item_value,<destination>,<item_id>),
###存储troop的id值
store_troop_value               = 2231 # (store_troop_value,<destination>,<troop_id>),

###同伴任务
store_partner_quest             = 2240 # (store_partner_quest,<destination>),
###随机任务
store_random_quest_in_range     = 2250 # (store_random_quest_in_range,<destination>,<lower_bound>,<upper_bound>),
###随机troop提升
store_random_troop_to_raise     = 2251 # (store_random_troop_to_raise,<destination>,<lower_bound>,<upper_bound>),
###随机troop捕获
store_random_troop_to_capture   = 2252	# (store_random_troop_to_capture,<destination>,<lower_bound>,<upper_bound>),
###随机队伍
store_random_party_in_range     = 2254	# (store_random_party_in_range,<destination>,<lower_bound>,<upper_bound>),
###随机多个队伍
store01_random_parties_in_range = 2255 # stores two random, different parties in a range to reg0 and reg1.
					# (store01_random_parties_in_range,<lower_bound>,<upper_bound>),
###存储随机马匹
store_random_horse              = 2257	# (store_random_horse,<destination>)
###随机装备
store_random_equipment          = 2258	# (store_random_equipment,<destination>)
###随机盔甲
store_random_armor              = 2259	# (store_random_armor,<destination>)
###任务数量
store_quest_number              = 2261 # (store_quest_number,<destination>,<quest_id>),
###任务物品
store_quest_item                = 2262	# (store_quest_item,<destination>,<item_id>),
###任务troop
store_quest_troop               = 2263	# (store_quest_troop,<destination>,<troop_id>),

###存储当前小时
store_current_hours             = 2270 # (store_current_hours,<destination>),
###时间日期
store_time_of_day               = 2271	# (store_time_of_day,<destination>),
###当前日期
store_current_day               = 2272	# (store_current_day,<destination>),
###当前是否晚上
is_currently_night              = 2273	# (is_currently_night),

###两只队伍的距离
store_distance_to_party_from_party = 2281	# (store_distance_to_party_from_party,<destination>,<party_id>,<party_id>),

###获取队伍ai行为
get_party_ai_behavior                 = 2290	# (get_party_ai_behavior,<destination>,<party_id>),
###获取队伍ai对象
get_party_ai_object                   = 2291	# (get_party_ai_object,<destination>,<party_id>),
###获取队伍ai触发坐标
party_get_ai_target_position          = 2292	# (party_get_ai_target_position,<position_no>,<party_id>),
###获取队伍ai当前行为
get_party_ai_current_behavior         = 2293   # (get_party_ai_current_behavior,<destination>,<party_id>),
###获取队伍ai当前对象
get_party_ai_current_object           = 2294	# (get_party_ai_current_object,<destination>,<party_id>),


###存储创建多个队伍数
store_num_parties_created             = 2300	# (store_num_parties_created,<destination>,<party_template_id>),
###存储销毁多个队伍数
store_num_parties_destroyed           = 2301	# (store_num_parties_destroyed,<destination>,<party_template_id>),
###存储销毁多个队伍数从玩家
store_num_parties_destroyed_by_player = 2302	# (store_num_parties_destroyed_by_player,<destination>,<party_template_id>),


# Searching operations.搜索操作
###存储模版队伍数量
store_num_parties_of_template   = 2310	# (store_num_parties_of_template,<destination>,<party_template_id>),
###存储随机模版队伍
store_random_party_of_template  = 2311	# fails if no party exists with tempolate_id (expensive)
					# (store_random_party_of_template,<destination>,<party_template_id>),

###判断字符串是否为空
str_is_empty                    = 2318 # (str_is_empty, <string_register>),
###清空字符串
str_clear                       = 2319 # (str_clear, <string_register>)
###存储字符串
str_store_string                = 2320	# (str_store_string,<string_register>,<string_id>),
###存储字符串到寄存器
str_store_string_reg            = 2321	# (str_store_string,<string_register>,<string_no>), #copies one string register to another.

###存储不带链接的troop的名称
str_store_troop_name            = 2322	# (str_store_troop_name,<string_register>,<troop_id>),
###存储不带链接的troop复数名称
str_store_troop_name_plural     = 2323	# (str_store_troop_name_plural,<string_register>,<troop_id>),
###存储不带链接的troop总数名称
str_store_troop_name_by_count   = 2324	# (str_store_troop_name_by_count,<string_register>,<troop_id>,<number>),
###存储不带链接的物品名称
str_store_item_name             = 2325	# (str_store_item_name,<string_register>,<item_id>),
###存储不带链接的物品复数名称
str_store_item_name_plural      = 2326	# (str_store_item_name_plural,<string_register>,<item_id>),
###存储不带链接的物品总数名称
str_store_item_name_by_count    = 2327	# (str_store_item_name_by_count,<string_register>,<item_id>),
###存储不带链接的party名称
str_store_party_name            = 2330	# (str_store_party_name,<string_register>,<party_id>),
###存储不带链接的agent名称
str_store_agent_name            = 2332	# (str_store_agent_name,<string_register>,<agent_id>),
###存储不带链接的阵营名称
str_store_faction_name          = 2335	# (str_store_faction_name,<string_register>,<faction_id>),
###存储不带链接的任务名称
str_store_quest_name            = 2336	# (str_store_quest_name,<string_register>,<quest_id>),
###存储不带链接的信息页面名称
str_store_info_page_name        = 2337	# (str_store_info_page_name,<string_register>,<info_page_id>),
###字符串转换日期
str_store_date                  = 2340 # (str_store_date,<string_register>,<number_of_hours_to_add_to_the_current_date>),

###存储带有链接的troop的名称
str_store_troop_name_link       = 2341 # (str_store_troop_name_link,<string_register>,<troop_id>),
###存储带有链接的party名称
str_store_party_name_link       = 2342 # (str_store_party_name_link,<string_register>,<party_id>),
###存储带有链接的阵营名称
str_store_faction_name_link     = 2343 # (str_store_faction_name_link,<string_register>,<faction_id>),
###存储带有链接的任务名称
str_store_quest_name_link       = 2344 # (str_store_quest_name_link,<string_register>,<quest_id>),
###存储带有链接的信息页面名称
str_store_info_page_name_link   = 2345 # (str_store_info_page_name_link,<string_register>,<info_page_id>),

###存储类别名称
str_store_class_name            = 2346 # (str_store_class_name,<stribg_register>,<class_id>)
###存储玩家名称
str_store_player_username       = 2350 # (str_store_player_username,<string_register>,<player_id>), #used in multiplayer mode only
###存储服务器密码
str_store_server_password       = 2351 # (str_store_server_password, <string_register>),
###存储服务器名称
str_store_server_name           = 2352 # (str_store_server_name, <string_register>),
###存储欢迎信息
str_store_welcome_message       = 2353 # (str_store_welcome_message, <string_register>),




###发送字符编码
str_encode_url                  = 2355 # (str_encode_url, <string_register>),

#mission ones:
###存储剩余team编号
store_remaining_team_no         = 2360	# (store_remaining_team_no,<destination>),

###存储触发器时间a毫秒
store_mission_timer_a_msec = 2365	# (store_mission_timer_a_msec,<destination>),
###存储触发器时间b毫秒
store_mission_timer_b_msec = 2366	# (store_mission_timer_b_msec,<destination>),
###存储触发器时间c毫秒
store_mission_timer_c_msec = 2367	# (store_mission_timer_c_msec,<destination>),

###存储触发器时间a（单位秒）
store_mission_timer_a = 2370	# (store_mission_timer_a,<destination>),
###存储触发器时间b（单位秒）
store_mission_timer_b = 2371	# (store_mission_timer_b,<destination>),
###存储触发器时间c（单位秒）
store_mission_timer_c = 2372	# (store_mission_timer_c,<destination>),

###重置触发器时间a（单位秒）
reset_mission_timer_a = 2375	# (reset_mission_timer_a),
###重置触发器时间b（单位秒）
reset_mission_timer_b = 2376	# (reset_mission_timer_b),
###重置触发器时间c（单位秒）
reset_mission_timer_c = 2377	# (reset_mission_timer_c),

###设置欢呼在没有敌人(0不喝彩 1喝彩)
set_cheer_at_no_enemy = 2379    # (set_cheer_at_no_enemy, <value>), # values:0->do not cheer (do as commander says), 1->cheer


########################以下似乎为联网命令

###存储仇敌数
store_enemy_count     = 2380 # (store_enemy_count,<destination>),
###存储朋友数
store_friend_count    = 2381 # (store_friend_count,<destination>),
###存储同盟数
store_ally_count      = 2382 # (store_ally_count,<destination>),
###存储防御数
store_defender_count  = 2383 # (store_defender_count,<destination>),
###存储进攻数
store_attacker_count  = 2384 # (store_attacker_count,<destination>),
###存储正常团组数
store_normalized_team_count = 2385 #(store_normalized_team_count,<destination>, <team_no>), #Counts the number of agents belonging to a team
                                                                                            # and normalizes the result regarding battle_size and advantage.
###设置点
set_postfx                  = 2386
###设置河流着色器到mud
set_river_shader_to_mud     = 2387 #changes river material for muddy env

###显示troop各种细节
show_troop_details          = 2388 #(show_troop_details, <troop_id>, <position>, <troop_price>)
###设置天空效果
set_skybox                  = 2389 #(set_skybox, <non_hdr_skybox_index>, <hdr_skybox_index>)	#forces selected skybox for a scene, use -1 to disable 
###设置启动阳光
set_startup_sun_light       = 2390 #(set_startup_sun_light, <r>, <g>, <b>)	#changes the sun light color
###设置启动环境光
set_startup_ambient_light   = 2391 #(set_startup_ambient_light, <r>, <g>, <b>)	#changes the ambient light color
###设置启动战场环境光
set_startup_ground_ambient_light = 2392 #(set_startup_ground_ambient_light, <r>, <g>, <b>)	#changes the ground ambient light color
###恢复地图阴影
rebuild_shadow_map			= 2393 #(rebuild_shadow_map),

###设置着色器数值
set_shader_param_int			= 2400 # (set_shader_param_int, <parameter_name>, <value>),	#Sets the int shader parameter <parameter_name> to <value>
###设置着色器浮点值
set_shader_param_float			= 2401 # (set_shader_param_float, <parameter_name>, <value>),	#Sets the float shader parameter <parameter_name> to <value>
###设置着色器浮点值4
set_shader_param_float4			= 2402 # (set_shader_param_float4, <parameter_name>, <valuex>, <valuey>, <valuez>, <valuew>),	#Sets the float4 shader parameter <parameter_name> to <valuex/y/z/w>
###设置着色器浮点值4x4
set_shader_param_float4x4		= 2403 # (set_shader_param_float4x4, <parameter_name>, [0][0], [0][1], [0][2], [1][0], [1][1], [1][2], [2][0], [2][1], [2][2], [3][0], [3][1], [3][2]),	#Sets the float4x4 shader parameter <parameter_name> to the given values .w components are 0001 by default

#-------------------------------------------


lhs_operations = [try_for_range,
                  try_for_range_backwards,
                  try_for_parties,
                  try_for_agents,
                  store_script_param_1,
                  store_script_param_2,
                  store_script_param,
                  store_repeat_object,
                  get_global_cloud_amount,
                  get_global_haze_amount,
                  options_get_damage_to_player,
                  options_get_damage_to_friends,
                  options_get_combat_ai,
                  options_get_campaign_ai,
                  options_get_combat_speed,
                  profile_get_banner_id,
                  get_achievement_stat,
                  get_max_players,
                  player_get_team_no,
                  player_get_troop_id,
                  player_get_agent_id,
                  player_get_gold,
                  multiplayer_get_my_team,
                  multiplayer_get_my_troop,
                  multiplayer_get_my_gold,
                  multiplayer_get_my_player,
                  player_get_score,
                  player_get_kill_count,
                  player_get_death_count,
                  player_get_ping,
                  player_get_is_muted,
                  player_get_unique_id,
                  player_get_gender,
                  player_get_item_id,
                  player_get_banner_id,
                  game_get_reduce_campaign_ai,
                  multiplayer_find_spawn_point,
                  team_get_bot_kill_count,
                  team_get_bot_death_count,
                  team_get_kill_count,
                  team_get_score,
                  team_get_faction,
                  player_get_value_of_original_items,
                  server_get_renaming_server_allowed,
                  server_get_changing_game_type_allowed,
                  server_get_friendly_fire,
                  server_get_control_block_dir,
                  server_get_combat_speed,
                  server_get_add_to_game_servers_list,
                  server_get_ghost_mode,
                  server_get_max_num_players,
                  server_get_melee_friendly_fire,
                  server_get_friendly_fire_damage_self_ratio,
                  server_get_friendly_fire_damage_friend_ratio,
                  server_get_anti_cheat,
                  troop_get_slot,
                  party_get_slot,
                  faction_get_slot,
                  scene_get_slot,
                  party_template_get_slot,
                  agent_get_slot,
                  quest_get_slot,
                  item_get_slot,
                  player_get_slot,
                  team_get_slot,
                  scene_prop_get_slot,
                  store_last_sound_channel,
                  get_angle_between_positions,
                  get_distance_between_positions,
                  get_distance_between_positions_in_meters,
                  get_sq_distance_between_positions,
                  get_sq_distance_between_positions_in_meters,
                  get_sq_distance_between_position_heights,                  
                  position_get_x,
                  position_get_y,
                  position_get_z,
                  position_get_scale_x,
                  position_get_scale_y,
                  position_get_scale_z,
                  position_get_rotation_around_z,
                  position_normalize_origin,
                  position_get_rotation_around_x,
                  position_get_rotation_around_y,
                  position_get_distance_to_terrain,
                  position_get_distance_to_ground_level,
                  create_text_overlay,
                  create_mesh_overlay,
                  create_button_overlay,
                  create_image_button_overlay,
                  create_slider_overlay,
                  create_progress_overlay,
                  create_combo_button_overlay,
                  create_text_box_overlay,
                  create_check_box_overlay,
                  create_simple_text_box_overlay,
                  create_image_button_overlay_with_tableau_material,
                  create_mesh_overlay_with_tableau_material,
                  create_game_button_overlay,
                  create_in_game_button_overlay,
                  create_number_box_overlay, 
                  create_listbox_overlay,
                  create_mesh_overlay_with_item_id,
                  overlay_get_position,
                  create_combo_label_overlay,
                  get_average_game_difficulty,
                  get_level_boundary,
                  faction_get_color,
                  troop_get_type,
                  troop_get_xp,
                  troop_get_class,
                  troop_inventory_slot_get_item_amount,
                  troop_inventory_slot_get_item_max_amount,
                  troop_get_inventory_capacity,
                  troop_get_inventory_slot,
                  troop_get_inventory_slot_modifier,
                  troop_get_upgrade_troop,
                  item_get_type,
                  party_get_num_companions,
                  party_get_num_prisoners,
                  party_get_current_terrain,
                  party_get_template_id,
                  party_count_members_of_type,
                  party_count_companions_of_type,
                  party_count_prisoners_of_type,
                  party_get_free_companions_capacity,
                  party_get_free_prisoners_capacity,
                  party_get_helpfulness,
                  party_get_ai_initiative,
                  party_get_num_companion_stacks,
                  party_get_num_prisoner_stacks,
                  party_stack_get_troop_id,
                  party_stack_get_size,
                  party_stack_get_num_wounded,
                  party_stack_get_troop_dna,
                  party_prisoner_stack_get_troop_id,
                  party_prisoner_stack_get_size,
                  party_prisoner_stack_get_troop_dna,
                  party_get_cur_town,
                  party_get_morale,
                  party_get_battle_opponent,
                  party_get_icon,
                  party_get_skill_level,
                  get_battle_advantage,
                  party_get_attached_to,
                  party_get_num_attached_parties,
                  party_get_attached_party_with_rank,
                  get_player_agent_no,
                  get_player_agent_kill_count,
                  get_player_agent_own_troop_kill_count,
                  agent_get_horse,
                  agent_get_rider,
                  agent_get_party_id,
                  agent_get_entry_no,
                  agent_get_troop_id,
                  agent_get_item_id,
                  store_agent_hit_points,
                  agent_get_kill_count,
                  agent_get_player_id,
                  agent_get_wielded_item,
                  agent_get_ammo,
                  agent_get_simple_behavior,
                  agent_get_combat_state,
                  agent_get_attached_scene_prop,
                  agent_get_time_elapsed_since_removed,
                  agent_get_number_of_enemies_following,
                  agent_get_attack_action,
                  agent_get_defend_action,
                  agent_get_group,
                  agent_get_action_dir,
                  agent_get_animation,
                  agent_get_team,
                  agent_get_class,
                  agent_get_division,                  
                  team_get_hold_fire_order,
                  team_get_movement_order,
                  team_get_riding_order,
                  team_get_weapon_usage_order,
                  team_get_leader,
                  agent_get_item_slot,
                  scene_prop_get_num_instances,
                  scene_prop_get_instance,
                  scene_prop_get_visibility,
                  scene_prop_get_hit_points,
                  scene_prop_get_max_hit_points,
                  scene_prop_get_team,
                  agent_get_ammo_for_slot,
                  agent_deliver_damage_to_agent_advanced,
                  team_get_gap_distance,
                  add_missile,
                  scene_item_get_num_instances,
                  scene_item_get_instance,
                  scene_spawned_item_get_num_instances,
                  scene_spawned_item_get_instance,
                  prop_instance_get_variation_id,
                  prop_instance_get_variation_id_2,
                  prop_instance_get_position,
                  prop_instance_get_starting_position,
                  prop_instance_get_scale,
                  prop_instance_get_scene_prop_kind,
                  prop_instance_is_animating,
                  prop_instance_get_animation_target_position,
                  agent_get_item_cur_ammo,
                  mission_get_time_speed,
                  mission_cam_get_aperture,
                  store_trigger_param,
                  store_trigger_param_1,
                  store_trigger_param_2,
                  store_trigger_param_3,
                  agent_ai_get_look_target,
                  agent_ai_get_move_target,
                  agent_ai_get_behavior_target,
                  agent_get_crouch_mode,
                  store_or,
                  store_and,
                  store_mod,
                  store_add,
                  store_sub,
                  store_mul,
                  store_div,
                  store_sqrt,
                  store_pow,
                  store_sin,
                  store_cos,
                  store_tan,
                  assign,
                  store_random,
                  store_random_in_range,
                  store_asin,
                  store_acos,
                  store_atan,
                  store_atan2,
                  store_troop_gold,
                  store_num_free_stacks,
                  store_num_free_prisoner_stacks,
                  store_party_size,
                  store_party_size_wo_prisoners,
                  store_troop_kind_count,
                  store_num_regular_prisoners,
                  store_troop_count_companions,
                  store_troop_count_prisoners,
                  store_item_kind_count,
                  store_free_inventory_capacity,
                  store_skill_level,
                  store_character_level,
                  store_attribute_level,
                  store_troop_faction,
                  store_troop_health,
                  store_proficiency_level,
                  store_relation,
                  store_conversation_agent,
                  store_conversation_troop,
                  store_partner_faction,
                  store_encountered_party,
                  store_encountered_party2,
                  store_faction_of_party,
                  store_current_scene,
                  store_zoom_amount,
                  store_item_value,
                  store_troop_value,
                  store_partner_quest,
                  store_random_quest_in_range,
                  store_random_troop_to_raise,
                  store_random_troop_to_capture,
                  store_random_party_in_range,
                  store_random_horse,
                  store_random_equipment,
                  store_random_armor,
                  store_quest_number,
                  store_quest_item,
                  store_quest_troop,
                  store_current_hours,
                  store_time_of_day,
                  store_current_day,
                  store_distance_to_party_from_party,
                  get_party_ai_behavior,
                  get_party_ai_object,
                  get_party_ai_current_behavior,
                  get_party_ai_current_object,
                  store_num_parties_created,
                  store_num_parties_destroyed,
                  store_num_parties_destroyed_by_player,
                  store_num_parties_of_template,
                  store_random_party_of_template,
                  store_remaining_team_no,
                  store_mission_timer_a_msec,
                  store_mission_timer_b_msec,
                  store_mission_timer_c_msec,
                  store_mission_timer_a,
                  store_mission_timer_b,
                  store_mission_timer_c,
                  store_enemy_count,
                  store_friend_count,
                  store_ally_count,
                  store_defender_count,
                  store_attacker_count,
                  store_normalized_team_count,
                  ]
global_lhs_operations = [val_lshift,
                         val_rshift,
                         val_add,
                         val_sub,
                         val_mul,
                         val_div,
                         val_max,
                         val_min,
                         val_mod
                         ]

can_fail_operations = [ge,
                       eq,
                       gt,
                       is_between,
                       entering_town,
                       map_free,
                       encountered_party_is_attacker,
                       conversation_screen_is_active,
                       in_meta_mission,
                       troop_is_hero,
                       troop_is_wounded,
                       key_is_down,
                       key_clicked,
                       game_key_is_down,
                       game_key_clicked,
                       hero_can_join,
                       hero_can_join_as_prisoner,
                       party_can_join,
                       party_can_join_as_prisoner,
                       troops_can_join,
                       troops_can_join_as_prisoner,
                       party_can_join_party,
                       main_party_has_troop,
                       party_is_in_town,
                       party_is_in_any_town,
                       party_is_active,
                       player_has_item,
                       troop_has_item_equipped,
                       troop_is_mounted,
                       troop_is_guarantee_ranged,
                       troop_is_guarantee_horse,
                       player_is_active,
                       multiplayer_is_server,
                       multiplayer_is_dedicated_server,
                       game_in_multiplayer_mode,
                       player_is_admin,
                       player_is_busy_with_menus,
                       player_item_slot_is_picked_up,
                       check_quest_active,
                       check_quest_finished,
                       check_quest_succeeded,
                       check_quest_failed,
                       check_quest_concluded,
                       is_trial_version,
                       is_edit_mode_enabled,
                       troop_slot_eq,
                       party_slot_eq,
                       faction_slot_eq,
                       scene_slot_eq,
                       party_template_slot_eq,
                       agent_slot_eq,
                       quest_slot_eq,
                       item_slot_eq,
                       player_slot_eq,
                       team_slot_eq,
                       scene_prop_slot_eq,
                       troop_slot_ge,
                       party_slot_ge,
                       faction_slot_ge,
                       scene_slot_ge,
                       party_template_slot_ge,
                       agent_slot_ge,
                       quest_slot_ge,
                       item_slot_ge,
                       player_slot_ge,
                       team_slot_ge,
                       scene_prop_slot_ge,
                       position_has_line_of_sight_to_position,
                       position_is_behind_position,
                       is_presentation_active,
                       all_enemies_defeated,
                       race_completed_by_player,
                       num_active_teams_le,
                       main_hero_fallen,
                       lt,
                       neq,
                       le,
                       teams_are_enemies,
                       agent_is_alive,
                       agent_is_wounded,
                       agent_is_human,
                       agent_is_ally,
                       agent_is_non_player,
                       agent_is_defender,
                       agent_is_active,
                       agent_is_routed,
                       agent_is_in_special_mode,
                       agent_is_in_parried_animation,
                       class_is_listening_order,
                       agent_check_offer_from_agent,
                       entry_point_is_auto_generated,
                       scene_prop_has_agent_on_it,
                       agent_is_alarmed,
                       agent_is_in_line_of_sight,
                       scene_prop_get_instance,
                       scene_item_get_instance,
                       scene_allows_mounted_units,
                       prop_instance_is_valid,
                       prop_instance_intersects_with_prop_instance,
                       agent_has_item_equipped,
                       map_get_land_position_around_position,
                       map_get_water_position_around_position,
                       is_zoom_disabled,
                       is_currently_night,
                       store_random_party_of_template,
                       str_is_empty
                       ]
