import * as cloudwatch from 'aws-cdk-lib/aws-cloudwatch';
import * as iam from 'aws-cdk-lib/aws-iam';
import * as firehose from 'aws-cdk-lib/aws-kinesisfirehose';
import * as s3 from 'aws-cdk-lib/aws-s3';
import * as secretsmanager from 'aws-cdk-lib/aws-secretsmanager';
import { Construct } from 'constructs';
import { BaseStack, BaseStackProps } from '../stack';
export declare const NEW_RELIC_AWS_ACCOUNT_ID = "754728514883";
export declare enum EndpointType {
    METRICS = "metrics",
    LOGS = "logs"
}
export declare enum EndpointUrlLogs {
    EU_LOGS = "https://aws-api.eu.newrelic.com/firehose/v1",
    US_LOGS = "https://aws-api.newrelic.com/firehose/v1"
}
export declare enum EndpointUrlMetrics {
    EU_METRICS = "https://aws-api.eu01.nr-data.net/cloudwatch-metrics/v1",
    US_METRICS = "https://aws-api.newrelic.com/cloudwatch-metrics/v1"
}
export interface NewRelicStackProps extends BaseStackProps {
    readonly newRelicLicenseKey: string;
    readonly newRelicAccountId: string;
    readonly newRelicBucketName: string;
    readonly newRelicApiUrlMetrics: EndpointUrlMetrics;
    readonly newRelicApiUrlLogs: EndpointUrlLogs;
}
export declare class NewRelicStack extends BaseStack {
    newRelicSecret: secretsmanager.ISecret;
    newRelicBucket: s3.IBucket;
    newRelicIntegrationRole: iam.IRole;
    newRelicFirehoseRole: iam.IRole;
    newRelicFirehoseMetrics?: firehose.CfnDeliveryStream;
    newRelicFirehoseLogs?: firehose.CfnDeliveryStream;
    newRelicCloudwatchLogsStreamRole?: iam.IRole;
    constructor(scope: Construct, id: string, props: NewRelicStackProps);
    createCloudwatchMetricStream(roleArn: string, firehoseArn: string): cloudwatch.CfnMetricStream;
    createCloudwatchLogsStreamRole(): iam.IRole;
    createNewRelicRole(newRelicAccountId: string): iam.IRole;
    createFirehoseStream(newRelicBucket: s3.IBucket, role: iam.IRole, endpointType: EndpointType, endpointUrl: string, newRelicLicenseLey: string): firehose.CfnDeliveryStream;
    createSecrets(newRelicAccountId: string, newRelicLicenseLey: string): secretsmanager.Secret;
    createFirehoseBucket(newRelicBucketName: string): s3.IBucket;
    createFirehoseRole(newRelicFirehoseBucket: s3.IBucket): iam.IRole;
}
