# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['inventory',
 'inventory.admin',
 'inventory.management',
 'inventory.management.commands',
 'inventory.migrations',
 'inventory.models',
 'inventory.tests',
 'inventory.tests.fixtures',
 'inventory_project',
 'inventory_project.settings',
 'inventory_project.tests']

package_data = \
{'': ['*'],
 'inventory': ['locale/ca/LC_MESSAGES/*',
               'locale/de/LC_MESSAGES/*',
               'locale/en/LC_MESSAGES/*',
               'locale/es/LC_MESSAGES/*',
               'static/*',
               'templates/admin/item/*',
               'templates/admin/location/*'],
 'inventory_project': ['templates/admin/*']}

install_requires = \
['bx_django_utils',
 'bx_py_utils',
 'colorlog',
 'django',
 'django-admin-sortable2',
 'django-axes',
 'django-ckeditor<=6.3.0',
 'django-dbbackup',
 'django-debug-toolbar',
 'django-import-export',
 'django-processinfo',
 'django-reversion-compare',
 'django-tagulous',
 'django-tools>=0.49.0',
 'gunicorn',
 'pillow',
 'requests']

extras_require = \
{'docker': ['docker-compose'],
 'postgres-binary': ['psycopg2-binary'],
 'psycopg2-source': ['psycopg2']}

entry_points = \
{'console_scripts': ['devshell = inventory_project.dev_shell:devshell_cmdloop',
                     'run_testserver = '
                     'inventory_project.manage:start_test_server']}

setup_kwargs = {
    'name': 'pyinventory',
    'version': '0.17.0',
    'description': 'Web based management to catalog things including state and location etc. using Python/Django.',
    'long_description': '# PyInventory\n\nWeb based management to catalog things including state and location etc. using Python/Django.\nStore information in WYSIWYG-HTML-Editor field and tag them and add Files, Images and Links to them.\n\n[![Test](https://github.com/jedie/PyInventory/actions/workflows/ci.yml/badge.svg?branch=main)](https://github.com/jedie/PyInventory/actions/workflows/ci.yml)\n[![Coverage Status on codecov.io](https://codecov.io/gh/jedie/PyInventory/branch/main/graph/badge.svg)](https://codecov.io/gh/jedie/PyInventory)\n[![PyInventory @ PyPi](https://img.shields.io/pypi/v/PyInventory?label=PyInventory%20%40%20PyPi)](https://pypi.org/project/PyInventory/)\n[![Python Versions](https://img.shields.io/pypi/pyversions/PyInventory)](https://github.com/jedie/PyInventory/blob/main/pyproject.toml)\n[![License GPL](https://img.shields.io/pypi/l/PyInventory)](https://github.com/jedie/PyInventory/blob/main/LICENSE)\n\n[![Install PyInventory with YunoHost](https://install-app.yunohost.org/install-with-yunohost.svg)](https://install-app.yunohost.org/?app=pyinventory)\n\n> [pyinventory_ynh](https://github.com/YunoHost-Apps/pyinventory_ynh) allows you to install PyInventory quickly and simply on a YunoHost server. If you don\'t have YunoHost, please consult [the guide](https://yunohost.org/#/install) to learn how to install it.\n\nPull requests welcome!\n\n## about\n\nThe focus of this project is on the management of retro computing hardware.\n\nCurrent features:\n\n\n* Web-based\n* Multiuser ready (Every user see and manage only his own entries)\n* Chaotic warehousing\n  * Grouped "Items" e.g.: Graphics card Foo is in computer Bar\n* Data structure kept as general as possible\n* Manage information to every item:\n  * Description: free WYSIWYG-HTML-Editor field\n  * Storage location\n  * State\n  * Images, Files and Web-Links\n  * receiving and delivering (when, from whom, at what price, etc.)\n* Manage "Memos" (Information independent of item/location):\n  * A free WYSIWYG-HTML-Editor field\n  * Tags\n  * Images, Files and Web-Links\n\nFuture ideas:\n\n\n* Information: Publicly visible yes/no\n  * A public list of existing items (think about it, you can set in your profile if you want to)\n  * administration a wish & exchange list\n\nany many more... ;)\n\n\n\n\n## Screenshots\n\nMore screenshots are here: [jedie.github.io/tree/master/screenshots/PyInventory](https://github.com/jedie/jedie.github.io/blob/master/screenshots/PyInventory/README.creole)\n\n![PyInventory v0.2.0 screenshot 1.png](https://raw.githubusercontent.com/jedie/jedie.github.io/master/screenshots/PyInventory/PyInventory%20v0.2.0%20screenshot%201.png "PyInventory v0.2.0 screenshot 1.png")\n\n----\n\n![PyInventory v0.11.0 screenshot memo 1.png](https://raw.githubusercontent.com/jedie/jedie.github.io/master/screenshots/PyInventory/PyInventory%20v0.11.0%20screenshot%20memo%201.png "PyInventory v0.11.0 screenshot memo 1.png")\n\n----\n\n![PyInventory v0.1.0 screenshot 2.png](https://raw.githubusercontent.com/jedie/jedie.github.io/master/screenshots/PyInventory/PyInventory%20v0.1.0%20screenshot%202.png "PyInventory v0.1.0 screenshot 2.png")\n\n----\n\n![PyInventory v0.1.0 screenshot 3.png](https://raw.githubusercontent.com/jedie/jedie.github.io/master/screenshots/PyInventory/PyInventory%20v0.1.0%20screenshot%203.png "PyInventory v0.1.0 screenshot 3.png")\n\n----\n\n## Multi user support\n\nPyInventory supports multiple users. The idea:\n\n\n* Every normal user sees only his own created database entries\n* All users used the Django admin\n\nNote: All created Tags are shared for all existing users!\n\nSo setup a normal user:\n\n\n* Set "Staff status"\n* Unset "Superuser status"\n* Add user to "normal_user" group\n* Don\'t add any additional permissions\n\ne.g.:\n\n![normal user example](https://raw.githubusercontent.com/jedie/jedie.github.io/master/screenshots/PyInventory/PyInventory%20normal%20user%20example.png "normal user example")\n\nMore screenshots are here: [jedie.github.io/tree/master/screenshots/PyInventory](https://github.com/jedie/jedie.github.io/blob/master/screenshots/PyInventory/README.creole)\n\n\n## local development installation\n\ne.g.:\n```\n# Clone project (Use your fork SSH url!):\n~$ git clone https://github.com/jedie/PyInventory.git\n~$ cd PyInventory\n~/PyInventory$ ./devshell.py\n```\n\nHelpful for writing and debugging unittests is to run a local test server.\ne.g.:\n```\n~/PyInventory$ ./devshell.py run_testserver\n```\n\nThe web page is available via: `http://127.0.0.1:8000/`\n\nYou can also pass a other port number or `ipaddr:port` combination. See: `./devshell.py run_testserver --help`\n\nRun tests, e.g.:\n```\n~/PyInventory$ ./devshell.py pytest\n```\n\nCall manage commands from test project, e.g.:\n```\n~/PyInventory$ ./devshell.py manage --help\n```\n\n## Backwards-incompatible changes\n\n### v0.7.0\n\nDocker-Compose usage: The MEDIA files was not stored on a docker volumes.\n\nYou should backup rhe media files **before** update the containers!\n\ne.g.:\n```\n~/PyInventory/deployment$ make shell_inventory\nroot@inventory:/django# cp -Rfv /media/ /django_volumes/media/\n```\n\nThe files are stored locally here:\n```\n~/PyInventory/deployment$ ls -la volumes/django/media/\n```\n\nNow, update the containers and copy the files back.\n\n### v0.5.0\n\nGit branches "main" and "deployment" was merged into one.\nFiles are separated into: "/src/" and "/development/"\n\n## history\n\n\n* [**dev**](https://github.com/jedie/PyInventory/compare/0.17.0...main)\n  * tbc\n* [v0.17.0 - 03.10.2022](https://github.com/jedie/PyInventory/compare/v0.16.0...0.17.0)\n  * NEW: List all related objects on `item` change page with edit links.\n  * Change `parent` and `location` fields on `item` change page to a autocompele field.\n  * Add search to `location`\n  * NEW: List number of item on `location` change list\n* [v0.16.0 - 14.09.2022](https://github.com/jedie/PyInventory/compare/v0.15.0...0.16.0)\n  * Update requirements\n  * Bugfix missing CK-Editor\n  * Replace Creole base README with markdown\n  * Remove Docker stuff from README\n* [v0.15.0 - 19.08.2022](https://github.com/jedie/PyInventory/compare/v0.14.0...v0.15.0)\n  * Speedup item change list by prefetch "location"\n  * Better changelists for super users\n  * Add `./devsetup.py manage seed_data` command to fill the database for development\n  * Update requirements\n  * Update project setup\n* [v0.14.0 - 24.07.2022](https://github.com/jedie/PyInventory/compare/v0.13.1...v0.14.0)\n  * [Fix #102](https://github.com/jedie/PyInventory/issues/102) by remove limitation of item parents.\n  * Remove "Group Items" functionality\n  * Replace "Group Items" change list filter by "Limit tree depth" for Item and Location.\n  * Display Item and Location as a tree.\n* [v0.13.1 - 21.07.2022](https://github.com/jedie/PyInventory/compare/v0.13.0...v0.13.1)\n  * Rename git "master" branch into "main"\n  * Update CI/Test setup:\n    * Use darker and pytest-darker as code formatter\n    * Run tests with Python 3.10, too and update requirements\n    * Replace Selenium tests with Playwright\n* [v0.13.0 - 01.01.2022](https://github.com/jedie/PyInventory/compare/v0.12.0...v0.13.0)\n  * [Update requirements, e.g.: Django v3.2](https://github.com/jedie/PyInventory/pull/83)\n* [v0.12.0 - 22.11.2021](https://github.com/jedie/PyInventory/compare/v0.11.0...v0.12.0)\n  * NEW: [Protect user to overwrite newer Item/Memo/Location with a older one (e.g.: in other browser TAB)](https://github.com/jedie/PyInventory/pull/78)\n  * update requirements\n* [v0.11.0 - 09.10.2021](https://github.com/jedie/PyInventory/compare/v0.10.1...v0.11.0)\n  * NEW: Memo model/admin: Store Information (incl. images/files/links) independent of items/locations\n  * Bugfix CKEditor sizes and fix toolbar (e.g.: remove useless pdf generator button and add sourcecode function)\n* [v0.10.1 - 09.10.2021](https://github.com/jedie/PyInventory/compare/v0.10.0...v0.10.1)\n  * Update to Django 3.1.x\n  * Don\'t make requests to the a name for a Link, if we already have one or if last request was not long ago.\n* [v0.10.0 - 29.09.2021](https://github.com/jedie/PyInventory/compare/v0.9.4...v0.10.0)\n  * Group item: default "automatic" mode and can be disabled by filter action\n* [v0.9.4 - 15.09.2021](https://github.com/jedie/PyInventory/compare/v0.9.3...v0.9.4)\n  * Pin `psycopg < 2.9` because of [https://github.com/psycopg/psycopg2/issues/1293](https://github.com/psycopg/psycopg2/issues/1293)\n* [v0.9.3 - 15.09.2021](https://github.com/jedie/PyInventory/compare/v0.9.2...v0.9.3)\n  * Optimize "items" changelist queries\n  * Update requirements\n  * Expand `run_testserver` command and recognize address and port argument\n* [v0.9.2 - 11.05.2021](https://github.com/jedie/PyInventory/compare/v0.9.1...v0.9.2)\n  * Update requirements\n  * [Fix error handling if item link is broken](https://github.com/jedie/PyInventory/issues/50)\n* [v0.9.1 - 28.04.2021](https://github.com/jedie/PyInventory/compare/v0.9.0...v0.9.1)\n* NEW: Besides images, it\'s now possible to add file(s) to items, too.\n* Add a auto login if Django dev. server is used.\n* [v0.9.0 - 11.04.2021](https://github.com/jedie/PyInventory/compare/v0.8.4...v0.9.0)\n  * Use [https://github.com/jedie/dev-shell](https://github.com/jedie/dev-shell) for development\n* [v0.8.4 - 19.01.2021](https://github.com/jedie/PyInventory/compare/v0.8.3...v0.8.4)\n  * Search items in change list by "kind" and "tags", too\n  * update requirements\n* [v0.8.3 - 29.12.2020](https://github.com/jedie/PyInventory/compare/v0.8.2...v0.8.3)\n  * update requirements\n  * remove colorama from direct dependencies\n  * Small project setup changes\n* [v0.8.2 - 20.12.2020](https://github.com/jedie/PyInventory/compare/v0.8.1...v0.8.2)\n  * Bugfix [#33](https://github.com/jedie/PyInventory/issues/33): Upload images to new created Items\n* [v0.8.1 - 09.12.2020](https://github.com/jedie/PyInventory/compare/v0.8.0...v0.8.1)\n  * Fix migration: Don\'t create "/media/migrate.log" if there is nothing to migrate\n  * Fix admin redirect by using the url pattern name\n  * YunoHost app package created\n  * update requirements\n* [v0.8.0 - 06.12.2020](https://github.com/jedie/PyInventory/compare/v0.7.0...v0.8.0)\n  * Outsource the "MEDIA file serve" part into [django.tools.serve_media_app](https://github.com/jedie/django-tools/tree/master/django_tools/serve_media_app#readme)\n* [v0.7.0 - 23.11.2020](https://github.com/jedie/PyInventory/compare/v0.6.0...v0.7.0)\n  * Change deployment setup:\n    * Replace uwsgi with gunicorn\n    * make deploy setup more generic by renaming "inventory" to "django"\n    * Bugfix MEDIA path: store the files on a docker volumes\n    * run app server as normal user and not root\n    * pull all docker images before build\n* [v0.6.0 - 15.11.2020](https://github.com/jedie/PyInventory/compare/v0.5.0...v0.6.0)\n  * User can store images to every item: The image can only be accessed by the same user.\n* [v0.5.0 - 14.11.2020](https://github.com/jedie/PyInventory/compare/v0.4.2...v0.5.0)\n  * Merge separate git branches into one: "/src/" and "/development/" [#19](https://github.com/jedie/PyInventory/issues/19)\n* [v0.4.2 - 13.11.2020](https://github.com/jedie/PyInventory/compare/v0.4.1...v0.4.2)\n  * Serve static files by Caddy\n  * Setup CKEditor file uploads: Store files into random sub directory\n  * reduce CKEditor plugins\n* [v0.4.1 - 2.11.2020](https://github.com/jedie/PyInventory/compare/v0.4.0...v0.4.1)\n  * Small bugfixes\n* [v0.4.0 - 1.11.2020](https://github.com/jedie/PyInventory/compare/v0.3.2...v0.4.0)\n  * Move docker stuff and production use information into separate git branch\n  * Add django-axes: keeping track of suspicious logins and brute-force attack blocking\n  * Add django-processinfo: collect information about the running server processes\n* [v0.3.2 - 26.10.2020](https://github.com/jedie/PyInventory/compare/v0.3.0...v0.3.2)\n  * Bugfix missing translations\n* [v0.3.0 - 26.10.2020](https://github.com/jedie/PyInventory/compare/v0.2.0...v0.3.0)\n  * setup production usage:\n    * Use [caddy server](https://caddyserver.com/) as reverse proxy\n    * Use uWSGI as application server\n    * autogenerate `secret.txt` file for `settings.SECRET_KEY`\n    * Fix settings\n  * split settings for local development and production use\n  * Bugfix init: move "setup user group" from checks into "post migrate" signal handler\n  * Bugfix for using manage commands `dumpdata` and `loaddata`\n* [v0.2.0 - 24.10.2020](https://github.com/jedie/PyInventory/compare/v0.1.0...v0.2.0)\n  * Simplify item change list by nested item\n  * Activate Django-Import/Export\n  * Implement multi user usage\n  * Add Django-dbbackup\n  * Add docker-compose usage\n* [v0.1.0 - 17.10.2020](https://github.com/jedie/PyInventory/compare/v0.0.1...v0.1.0)\n  * Enhance models, admin and finish project setup\n* v0.0.1 - 14.10.2020\n  * Just create a pre-alpha release to save the PyPi package name ;)\n\n## links\n\n|          |                                                                                |\n|----------|--------------------------------------------------------------------------------|\n| Homepage | [http://github.com/jedie/PyInventory](http://github.com/jedie/PyInventory)     |\n| PyPi     | [https://pypi.org/project/PyInventory/](https://pypi.org/project/PyInventory/) |\n\nDiscuss here:\n\n\n* [vogons.org Forum Thread (en)](https://www.vogons.org/viewtopic.php?f=5&t=77285)\n* [Python-Forum (de)](https://www.python-forum.de/viewtopic.php?f=9&t=50024)\n* [VzEkC e. V. Forum Thread (de)](https://forum.classic-computing.de/forum/index.php?thread/21738-opensource-projekt-pyinventory-web-basierte-verwaltung-um-seine-dinge-zu-katalog/)\n* [dosreloaded.de Forum Thread (de)](https://dosreloaded.de/forum/index.php?thread/3702-pyinventory-retro-sammlung-katalogisieren/)\n\n## donation\n\n\n* [paypal.me/JensDiemer](https://www.paypal.me/JensDiemer)\n* [Flattr This!](https://flattr.com/submit/auto?uid=jedie&url=https%3A%2F%2Fgithub.com%2Fjedie%2FPyInventory%2F)\n* Send [Bitcoins](http://www.bitcoin.org/) to [1823RZ5Md1Q2X5aSXRC5LRPcYdveCiVX6F](https://blockexplorer.com/address/1823RZ5Md1Q2X5aSXRC5LRPcYdveCiVX6F)\n',
    'author': 'JensDiemer',
    'author_email': 'git@jensdiemer.de',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/jedie/PyInventory',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0.0',
}


setup(**setup_kwargs)
