import pathlib
import typing
from contextlib import asynccontextmanager

from playwright.async_api import Page, ViewportSize, Geolocation, HttpCredentials, ProxySettings, StorageState


@asynccontextmanager
async def get_new_page(
        *,
        name: str | None = None, use_store: bool = True, save_store: bool = True,
        viewport: ViewportSize | None = None,
        screen: ViewportSize | None = None,
        no_viewport: bool | None = None,
        ignore_https_errors: bool | None = None,
        java_script_enabled: bool | None = None,
        bypass_csp: bool | None = None,
        user_agent: str | None = None,
        locale: str | None = None,
        timezone_id: str | None = None,
        geolocation: Geolocation | None = None,
        permissions: typing.Sequence[str] | None = None,
        extra_http_headers: dict[str, str] | None = None,
        offline: bool | None = None,
        http_credentials: HttpCredentials | None = None,
        device_scale_factor: float | None = None,
        is_mobile: bool | None = None,
        has_touch: bool | None = None,
        color_scheme: typing.Literal["dark", "light", "no-preference", "null"] | None = None,
        forced_colors: typing.Literal["active", "none", "null"] | None = None,
        reduced_motion: typing.Literal["no-preference", "null", "reduce"] | None = None,
        accept_downloads: bool | None = None,
        default_browser_type: str | None = None,
        proxy: ProxySettings | None = None,
        record_har_path: str | pathlib.Path | None = None,
        record_har_omit_content: bool | None = None,
        record_video_dir: str | pathlib.Path | None = None,
        record_video_size: ViewportSize | None = None,
        storage_state: StorageState | str | pathlib.Path | None = None,
        base_url: str | None = None,
        strict_selectors: bool | None = None,
        service_workers: typing.Literal["allow", "block"] | None = None,
        record_har_url_filter: str | typing.Pattern[str] | None = None,
        record_har_mode: typing.Literal["full", "minimal"] | None = None,
        record_har_content: typing.Literal["attach", "embed", "omit"] | None = None
) -> typing.AsyncGenerator[Page, None]:
    ...


async def GetNewPage(
        *,
        name: str | None = None, use_store: bool = True, save_store: bool = True,
        viewport: ViewportSize | None = None,
        screen: ViewportSize | None = None,
        no_viewport: bool | None = None,
        ignore_https_errors: bool | None = None,
        java_script_enabled: bool | None = None,
        bypass_csp: bool | None = None,
        user_agent: str | None = None,
        locale: str | None = None,
        timezone_id: str | None = None,
        geolocation: Geolocation | None = None,
        permissions: typing.Sequence[str] | None = None,
        extra_http_headers: dict[str, str] | None = None,
        offline: bool | None = None,
        http_credentials: HttpCredentials | None = None,
        device_scale_factor: float | None = None,
        is_mobile: bool | None = None,
        has_touch: bool | None = None,
        color_scheme: typing.Literal["dark", "light", "no-preference", "null"] | None = None,
        forced_colors: typing.Literal["active", "none", "null"] | None = None,
        reduced_motion: typing.Literal["no-preference", "null", "reduce"] | None = None,
        accept_downloads: bool | None = None,
        default_browser_type: str | None = None,
        proxy: ProxySettings | None = None,
        record_har_path: str | pathlib.Path | None = None,
        record_har_omit_content: bool | None = None,
        record_video_dir: str | pathlib.Path | None = None,
        record_video_size: ViewportSize | None = None,
        storage_state: StorageState | str | pathlib.Path | None = None,
        base_url: str | None = None,
        strict_selectors: bool | None = None,
        service_workers: typing.Literal["allow", "block"] | None = None,
        record_har_url_filter: str | typing.Pattern[str] | None = None,
        record_har_mode: typing.Literal["full", "minimal"] | None = None,
        record_har_content: typing.Literal["attach", "embed", "omit"] | None = None
):
    ...


async def NewPage(
        *,
        name: str | None = None, use_store: bool = True, save_store: bool = True,
        viewport: ViewportSize | None = None,
        screen: ViewportSize | None = None,
        no_viewport: bool | None = None,
        ignore_https_errors: bool | None = None,
        java_script_enabled: bool | None = None,
        bypass_csp: bool | None = None,
        user_agent: str | None = None,
        locale: str | None = None,
        timezone_id: str | None = None,
        geolocation: Geolocation | None = None,
        permissions: typing.Sequence[str] | None = None,
        extra_http_headers: dict[str, str] | None = None,
        offline: bool | None = None,
        http_credentials: HttpCredentials | None = None,
        device_scale_factor: float | None = None,
        is_mobile: bool | None = None,
        has_touch: bool | None = None,
        color_scheme: typing.Literal["dark", "light", "no-preference", "null"] | None = None,
        forced_colors: typing.Literal["active", "none", "null"] | None = None,
        reduced_motion: typing.Literal["no-preference", "null", "reduce"] | None = None,
        accept_downloads: bool | None = None,
        default_browser_type: str | None = None,
        proxy: ProxySettings | None = None,
        record_har_path: str | pathlib.Path | None = None,
        record_har_omit_content: bool | None = None,
        record_video_dir: str | pathlib.Path | None = None,
        record_video_size: ViewportSize | None = None,
        storage_state: StorageState | str | pathlib.Path | None = None,
        base_url: str | None = None,
        strict_selectors: bool | None = None,
        service_workers: typing.Literal["allow", "block"] | None = None,
        record_har_url_filter: str | typing.Pattern[str] | None = None,
        record_har_mode: typing.Literal["full", "minimal"] | None = None,
        record_har_content: typing.Literal["attach", "embed", "omit"] | None = None
):
    ...
