from prepars.verb import verbProcessing
import pytest


@pytest.mark.parametrize(
    "input, expected",
    [
        ("میخورد", "می‌خورد"),
        ("میخورد", "می‌خورد"),
        ("میرفت", "می‌رفت"),
        ("می‌رفت", "می‌رفت"),
        ("داشتندمیرفتند", "داشتند می‌رفتند"),
        ("داشتند می رفتند", "داشتند می‌رفتند"),
        ("میآجیدم", "می‌آجیدم"),
        ("آراستهاست","آراسته‌است"),
        ("داشتیممیخوردیم", "داشتیم می‌خوردیم"),
        ("داشتیم میخوردیم", "داشتیم می‌خوردیم"),
        ("نمیرفتهاست", "نمی‌رفته‌است"),
        ("نرفتهاند", "نرفته‌اند"),
        ("داشتهاست", "داشته‌است"),
        ("داشتممیرفتم", "داشتم می‌رفتم"),
        ("می آزرده بوده اند", "می‌آزرده‌بوده‌اند"),
        ("رفتهبودم", "رفته‌بودم"),
        ("رفتهبودهام", "رفته‌بوده‌ام"),
        ("میرفتهبودهام", "می‌رفته‌بوده‌ام"),
        ("خواهیمرفت", "خواهیم رفت"),
        ("می رفته باشم", "می‌رفته‌باشم"),
        ("نرفتهبودهباشد","نرفته‌بوده‌باشد")
    ],
)
def test_verbs(input, expected):
    assert verbProcessing().fixVerbs(input) == expected