'''
This script uses python's subprocess library to run instances of SDTrimSP.
Individual files generated by this script will containing the results of many 
impacts for a single ion/energy/angle/composition profile.

Currently, the script sweeps over the parameter of ion irradiate angle.  In
the future, it will perform parameter sweeps over a variety of parameters.

  Usage:  python run-simulations.py [$executable]

where [$executable] is the location of the executable file.
'''

# Filesystem basics
import sys
import os

# PyCraters basics
import pycraters.wrappers.TRI3DST as wrap
import pycraters.schedulers.condor as condor

# get the location of the TrimSP executable
exec_location = sys.argv[1]
wrapper = wrap.TRI3DST_Wrapper(exec_location)
params  = wrap.TRI3DST_Parameters()

# set up things over which to iterate
#targets  = [ [["C_d", 1.0]], [["Si", 1.0]], [["Ge", 1.0]], [["Sn", 1.0]], [["Pb", 1.0]] ]
#beams    = ["He", "Ne", "Ar", "Kr", "Xe"]
#angles   = range(0, 90, 5)
#energies = [100, 200, 500, 1000, 2000, 5000]
#impacts  = 1000


# set up things over which to iterate
targets  = [  [["Si", 1.0]] ]
beams    = [ "Ar" ]
angles   = list(range(0, 90, 5))
energies = [1000]
impacts  = 1000



# iterate over things, and build list of parameter objects
params_list = []

for tt in targets:
  for bb in beams:
    for ee in energies:
      for aa in angles:

        # assign specific parameters
        params = wrap.TRI3DST_Parameters()
        params.target = tt
        params.beam = bb
        params.angle = aa
        params.energy = ee
        params.impacts = impacts

        params_list.append(params)



condor.write_condor_files(wrapper, params_list)
#condor.run_condor_jobs(wrapper, params_list)


