# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/19_cli.ipynb.

# %% auto 0
__all__ = ['fastrl_make_requirements', 'proc_nbs', 'fastrl_nbdev_docs', 'fastrl_nbdev_test']

# %% ../nbs/19_cli.ipynb 3
# Python native modules
import os
import shutil
# Third party libs
from fastcore.all import *
# Local modules
from nbdev.quarto import _nbglob_docs,_sprun,_pre_docs,nbdev_readme,move,proc_nbs
from nbdev.test import test_nb,_keep_file

# %% ../nbs/19_cli.ipynb 6
@call_parse
def fastrl_make_requirements(
    path:Path=None, # The path to a dir with the settings.ini, if none, cwd.
    project_file:str='settings.ini', # The file to load for reading the requirements
    out_path:Path=None, # The output path (can be relative to `path`)
    verbose:bool=False # Output to stdout
):
    requirement_types = ['','dev_','pip_']
    path = ifnone(path, Path.cwd())/project_file

    if not path.exists(): raise OSError(f'File {path} does not exist')

    out_path = ifnone(out_path, Path('extra'))
    out_path = out_path if out_path.is_absolute() else path.parent/out_path
    out_path.mkdir(parents=True, exist_ok=True)
    if verbose: print('Outputting to path: ',out_path)
    config = Config(path.parent,path.name)

    for req in requirement_types:
        requirements = config[req+'requirements']
        requirements = requirements.replace(' ','\n')
        Path(out_path/(req+'requirements.txt')).write_text(requirements)

# %% ../nbs/19_cli.ipynb 7
from nbdev.config import *
from nbdev.doclinks import *

from fastcore.utils import *
from fastcore.script import call_parse
from fastcore.shutil import rmtree,move,copytree
from fastcore.meta import delegates
from nbdev.serve import proc_nbs,_proc_file
from nbdev import serve_drv
from nbdev.quarto import _ensure_quarto
from nbdev.quarto import *
import nbdev

# %% ../nbs/19_cli.ipynb 8
@call_parse
@delegates(nbglob_cli)
def proc_nbs(
    path:str='', # Path to notebooks
    n_workers:int=defaults.cpus,  # Number of workers
    force:bool=False,  # Ignore cache and build all
    file_glob:str='', # Only include files matching glob
    verbose:bool=False, # verbose outputs
    one2one:bool=True, # Run 1 notebook per process instance.
    **kwargs):
    "Process notebooks in `path` for docs rendering"
    cfg = get_config()
    cache = cfg.config_path/'_proc'
    path = Path(path or cfg.nbs_path)
    files = nbglob(path, func=Path, file_glob=file_glob, **kwargs)
    if (path/'_quarto.yml').exists(): files.append(path/'_quarto.yml')

    # If settings.ini or filter script newer than cache folder modified, delete cache
    chk_mtime = max(cfg.config_file.stat().st_mtime, Path(__file__).stat().st_mtime)
    cache.mkdir(parents=True, exist_ok=True)
    cache_mtime = cache.stat().st_mtime
    if force or (cache.exists and cache_mtime<chk_mtime): rmtree(cache)

    files = files.map(_proc_file, mtime=cache_mtime, cache=cache, path=path).filter()
    kw = {} if IN_NOTEBOOK else {'method':'spawn'}
    if verbose: print('Using n_workers: ',n_workers,'IN_NOTEBOOK: ',IN_NOTEBOOK,kw)
    if one2one:
        for chunk in chunked(files,chunk_sz=max(n_workers,1)):
            parallel(nbdev.serve_drv.main, chunk, n_workers=n_workers, pause=0.01, **kw)
    else:
        parallel(nbdev.serve_drv.main, files, n_workers=n_workers, pause=0.01, **kw)
    if cache.exists(): cache.touch()
    return cache

def _pre_docs(
        path, 
        n_workers:int=defaults.cpus, 
        verbose:bool=False,
        one2one:bool=True, # Run 1 notebook per process instance.
        **kwargs
    ):
    cfg = get_config()
    path = Path(path) if path else cfg.nbs_path
    _ensure_quarto()
    refresh_quarto_yml()
    import nbdev.doclinks
    nbdev.doclinks._build_modidx()
    nbdev_sidebar.__wrapped__(path=path, **kwargs)
    cache = proc_nbs.__wrapped__(path, n_workers=n_workers, verbose=verbose, one2one=one2one)
    return cache,cfg,path

@call_parse
@delegates(_nbglob_docs)
def fastrl_nbdev_docs(
    path:str=None, # Path to notebooks
    n_workers:int=defaults.cpus,  # Number of workers
    verbose:bool=False, # verbose outputs
    one2one:bool=True, # Run 1 notebook per process instance.
    **kwargs):
    "Create Quarto docs and README.md"
    cache,cfg,path = _pre_docs(path, n_workers=n_workers, verbose=verbose, one2one=one2one, **kwargs)
    nbdev_readme.__wrapped__(path=path, chk_time=True)
    _sprun(f'cd "{cache}" && quarto render --no-cache')
    shutil.rmtree(cfg.doc_path, ignore_errors=True)
    move(cache/cfg.doc_path.name, cfg.config_path)

# %% ../nbs/19_cli.ipynb 9
@call_parse
@delegates(nbglob_cli)
def fastrl_nbdev_test(
    path:str=None,  # A notebook name or glob to test
    flags:str='',  # Space separated list of test flags to run that are normally ignored
    n_workers:int=None,  # Number of workers
    timing:bool=False,  # Time each notebook to see which are slow
    do_print:bool=False, # Print start and end of each notebook
    pause:float=0.01,  # Pause time (in seconds) between notebooks to avoid race conditions
    ignore_fname:str='.notest', # Filename that will result in siblings being ignored
    one2one:bool=True, # Run 1 notebook per process instance.
    **kwargs):
    "Test in parallel notebooks matching `path`, passing along `flags`"
    skip_flags = get_config().tst_flags.split()
    force_flags = flags.split()
    files = nbglob(path, as_path=True, **kwargs)
    files = [f.absolute() for f in sorted(files) if _keep_file(f, ignore_fname)]
    if len(files)==0: return print('No files were eligible for testing')

    if n_workers is None: n_workers = 0 if len(files)==1 else min(num_cpus(), 8)
    if IN_NOTEBOOK: kw = {'method':'spawn'} if os.name=='nt' else {'method':'forkserver'}
    else: kw = {} # {'method':'spawn'}
    with working_directory(get_config().nbs_path):
        if one2one:
            results = []
            for chunk in chunked(files,chunk_sz=max(n_workers,1)):
                results.extend(parallel(test_nb, chunk, skip_flags=skip_flags, force_flags=force_flags, n_workers=n_workers,
                                basepath=get_config().config_path, pause=pause, do_print=do_print, **kw))
        else:
            results = parallel(test_nb, files, skip_flags=skip_flags, force_flags=force_flags, n_workers=n_workers,
                            basepath=get_config().config_path, pause=pause, do_print=do_print, **kw)
    passed,times = zip(*results)
    if all(passed): print("Success.")
    else: 
        _fence = '='*50
        failed = '\n\t'.join(f.name for p,f in zip(passed,files) if not p)
        sys.stderr.write(f"\nnbdev Tests Failed On The Following Notebooks:\n{_fence}\n\t{failed}\n")
        sys.exit(1)
    if timing:
        for i,t in sorted(enumerate(times), key=lambda o:o[1], reverse=True): print(f"{files[i].name}: {int(t)} secs")
