# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['DestinationArgs', 'Destination']

@pulumi.input_type
class DestinationArgs:
    def __init__(__self__, *,
                 destination_policy: pulumi.Input[str],
                 role_arn: pulumi.Input[str],
                 target_arn: pulumi.Input[str],
                 destination_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Destination resource.
        """
        pulumi.set(__self__, "destination_policy", destination_policy)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "target_arn", target_arn)
        if destination_name is not None:
            pulumi.set(__self__, "destination_name", destination_name)

    @property
    @pulumi.getter(name="destinationPolicy")
    def destination_policy(self) -> pulumi.Input[str]:
        return pulumi.get(self, "destination_policy")

    @destination_policy.setter
    def destination_policy(self, value: pulumi.Input[str]):
        pulumi.set(self, "destination_policy", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[str]:
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="targetArn")
    def target_arn(self) -> pulumi.Input[str]:
        return pulumi.get(self, "target_arn")

    @target_arn.setter
    def target_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_arn", value)

    @property
    @pulumi.getter(name="destinationName")
    def destination_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "destination_name")

    @destination_name.setter
    def destination_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_name", value)


warnings.warn("""Destination is not yet supported by AWS Native, so its creation will currently fail. Please use the classic AWS provider, if possible.""", DeprecationWarning)


class Destination(pulumi.CustomResource):
    warnings.warn("""Destination is not yet supported by AWS Native, so its creation will currently fail. Please use the classic AWS provider, if possible.""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 destination_name: Optional[pulumi.Input[str]] = None,
                 destination_policy: Optional[pulumi.Input[str]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 target_arn: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::Logs::Destination

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DestinationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::Logs::Destination

        :param str resource_name: The name of the resource.
        :param DestinationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DestinationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 destination_name: Optional[pulumi.Input[str]] = None,
                 destination_policy: Optional[pulumi.Input[str]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 target_arn: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        pulumi.log.warn("""Destination is deprecated: Destination is not yet supported by AWS Native, so its creation will currently fail. Please use the classic AWS provider, if possible.""")
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DestinationArgs.__new__(DestinationArgs)

            __props__.__dict__["destination_name"] = destination_name
            if destination_policy is None and not opts.urn:
                raise TypeError("Missing required property 'destination_policy'")
            __props__.__dict__["destination_policy"] = destination_policy
            if role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'role_arn'")
            __props__.__dict__["role_arn"] = role_arn
            if target_arn is None and not opts.urn:
                raise TypeError("Missing required property 'target_arn'")
            __props__.__dict__["target_arn"] = target_arn
            __props__.__dict__["arn"] = None
        super(Destination, __self__).__init__(
            'aws-native:logs:Destination',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Destination':
        """
        Get an existing Destination resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = DestinationArgs.__new__(DestinationArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["destination_name"] = None
        __props__.__dict__["destination_policy"] = None
        __props__.__dict__["role_arn"] = None
        __props__.__dict__["target_arn"] = None
        return Destination(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="destinationName")
    def destination_name(self) -> pulumi.Output[str]:
        return pulumi.get(self, "destination_name")

    @property
    @pulumi.getter(name="destinationPolicy")
    def destination_policy(self) -> pulumi.Output[str]:
        return pulumi.get(self, "destination_policy")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[str]:
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="targetArn")
    def target_arn(self) -> pulumi.Output[str]:
        return pulumi.get(self, "target_arn")

