"""
    VRChat API Documentation


    The version of the OpenAPI document: 1.7.1
    Contact: me@ariesclark.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from vrchatapi.api_client import ApiClient, Endpoint as _Endpoint
from vrchatapi.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from vrchatapi.model.create_world_request import CreateWorldRequest
from vrchatapi.model.error import Error
from vrchatapi.model.instance import Instance
from vrchatapi.model.limited_world import LimitedWorld
from vrchatapi.model.update_world_request import UpdateWorldRequest
from vrchatapi.model.world import World
from vrchatapi.model.world_metadata import WorldMetadata
from vrchatapi.model.world_publish_status import WorldPublishStatus


class WorldsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_world_endpoint = _Endpoint(
            settings={
                'response_type': (World,),
                'auth': [],
                'endpoint_path': '/worlds',
                'operation_id': 'create_world',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'create_world_request',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'create_world_request':
                        (CreateWorldRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'create_world_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.delete_world_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'apiKeyCookie',
                    'authCookie'
                ],
                'endpoint_path': '/worlds/{worldId}',
                'operation_id': 'delete_world',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'world_id',
                ],
                'required': [
                    'world_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'world_id':
                        (str,),
                },
                'attribute_map': {
                    'world_id': 'worldId',
                },
                'location_map': {
                    'world_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_active_worlds_endpoint = _Endpoint(
            settings={
                'response_type': ([LimitedWorld],),
                'auth': [
                    'apiKeyCookie',
                    'authCookie'
                ],
                'endpoint_path': '/worlds/active',
                'operation_id': 'get_active_worlds',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'featured',
                    'sort',
                    'n',
                    'order',
                    'offset',
                    'search',
                    'tag',
                    'notag',
                    'release_status',
                    'max_unity_version',
                    'min_unity_version',
                    'platform',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'sort',
                    'order',
                    'release_status',
                ],
                'validation': [
                    'n',
                    'offset',
                ]
            },
            root_map={
                'validations': {
                    ('n',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                    ('offset',): {

                        'inclusive_minimum': 0,
                    },
                },
                'allowed_values': {
                    ('sort',): {

                        "POPULARITY": "popularity",
                        "HEAT": "heat",
                        "TRUST": "trust",
                        "SHUFFLE": "shuffle",
                        "RANDOM": "random",
                        "FAVORITES": "favorites",
                        "REPORTSCORE": "reportScore",
                        "REPORTCOUNT": "reportCount",
                        "PUBLICATIONDATE": "publicationDate",
                        "LABSPUBLICATIONDATE": "labsPublicationDate",
                        "CREATED": "created",
                        "_CREATED_AT": "_created_at",
                        "UPDATED": "updated",
                        "_UPDATED_AT": "_updated_at",
                        "ORDER": "order",
                        "RELEVANCE": "relevance",
                        "MAGIC": "magic",
                        "NAME": "name"
                    },
                    ('order',): {

                        "ASCENDING": "ascending",
                        "DESCENDING": "descending"
                    },
                    ('release_status',): {

                        "PUBLIC": "public",
                        "PRIVATE": "private",
                        "HIDDEN": "hidden",
                        "ALL": "all"
                    },
                },
                'openapi_types': {
                    'featured':
                        (str,),
                    'sort':
                        (str,),
                    'n':
                        (int,),
                    'order':
                        (str,),
                    'offset':
                        (int,),
                    'search':
                        (str,),
                    'tag':
                        (str,),
                    'notag':
                        (str,),
                    'release_status':
                        (str,),
                    'max_unity_version':
                        (str,),
                    'min_unity_version':
                        (str,),
                    'platform':
                        (str,),
                },
                'attribute_map': {
                    'featured': 'featured',
                    'sort': 'sort',
                    'n': 'n',
                    'order': 'order',
                    'offset': 'offset',
                    'search': 'search',
                    'tag': 'tag',
                    'notag': 'notag',
                    'release_status': 'releaseStatus',
                    'max_unity_version': 'maxUnityVersion',
                    'min_unity_version': 'minUnityVersion',
                    'platform': 'platform',
                },
                'location_map': {
                    'featured': 'query',
                    'sort': 'query',
                    'n': 'query',
                    'order': 'query',
                    'offset': 'query',
                    'search': 'query',
                    'tag': 'query',
                    'notag': 'query',
                    'release_status': 'query',
                    'max_unity_version': 'query',
                    'min_unity_version': 'query',
                    'platform': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_favorited_worlds_endpoint = _Endpoint(
            settings={
                'response_type': ([LimitedWorld],),
                'auth': [
                    'apiKeyCookie',
                    'authCookie'
                ],
                'endpoint_path': '/worlds/favorites',
                'operation_id': 'get_favorited_worlds',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'featured',
                    'sort',
                    'n',
                    'order',
                    'offset',
                    'search',
                    'tag',
                    'notag',
                    'release_status',
                    'max_unity_version',
                    'min_unity_version',
                    'platform',
                    'user_id',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'sort',
                    'order',
                    'release_status',
                ],
                'validation': [
                    'n',
                    'offset',
                ]
            },
            root_map={
                'validations': {
                    ('n',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                    ('offset',): {

                        'inclusive_minimum': 0,
                    },
                },
                'allowed_values': {
                    ('sort',): {

                        "POPULARITY": "popularity",
                        "HEAT": "heat",
                        "TRUST": "trust",
                        "SHUFFLE": "shuffle",
                        "RANDOM": "random",
                        "FAVORITES": "favorites",
                        "REPORTSCORE": "reportScore",
                        "REPORTCOUNT": "reportCount",
                        "PUBLICATIONDATE": "publicationDate",
                        "LABSPUBLICATIONDATE": "labsPublicationDate",
                        "CREATED": "created",
                        "_CREATED_AT": "_created_at",
                        "UPDATED": "updated",
                        "_UPDATED_AT": "_updated_at",
                        "ORDER": "order",
                        "RELEVANCE": "relevance",
                        "MAGIC": "magic",
                        "NAME": "name"
                    },
                    ('order',): {

                        "ASCENDING": "ascending",
                        "DESCENDING": "descending"
                    },
                    ('release_status',): {

                        "PUBLIC": "public",
                        "PRIVATE": "private",
                        "HIDDEN": "hidden",
                        "ALL": "all"
                    },
                },
                'openapi_types': {
                    'featured':
                        (str,),
                    'sort':
                        (str,),
                    'n':
                        (int,),
                    'order':
                        (str,),
                    'offset':
                        (int,),
                    'search':
                        (str,),
                    'tag':
                        (str,),
                    'notag':
                        (str,),
                    'release_status':
                        (str,),
                    'max_unity_version':
                        (str,),
                    'min_unity_version':
                        (str,),
                    'platform':
                        (str,),
                    'user_id':
                        (str,),
                },
                'attribute_map': {
                    'featured': 'featured',
                    'sort': 'sort',
                    'n': 'n',
                    'order': 'order',
                    'offset': 'offset',
                    'search': 'search',
                    'tag': 'tag',
                    'notag': 'notag',
                    'release_status': 'releaseStatus',
                    'max_unity_version': 'maxUnityVersion',
                    'min_unity_version': 'minUnityVersion',
                    'platform': 'platform',
                    'user_id': 'userId',
                },
                'location_map': {
                    'featured': 'query',
                    'sort': 'query',
                    'n': 'query',
                    'order': 'query',
                    'offset': 'query',
                    'search': 'query',
                    'tag': 'query',
                    'notag': 'query',
                    'release_status': 'query',
                    'max_unity_version': 'query',
                    'min_unity_version': 'query',
                    'platform': 'query',
                    'user_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_recent_worlds_endpoint = _Endpoint(
            settings={
                'response_type': ([LimitedWorld],),
                'auth': [
                    'apiKeyCookie',
                    'authCookie'
                ],
                'endpoint_path': '/worlds/recent',
                'operation_id': 'get_recent_worlds',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'featured',
                    'sort',
                    'n',
                    'order',
                    'offset',
                    'search',
                    'tag',
                    'notag',
                    'release_status',
                    'max_unity_version',
                    'min_unity_version',
                    'platform',
                    'user_id',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'sort',
                    'order',
                    'release_status',
                ],
                'validation': [
                    'n',
                    'offset',
                ]
            },
            root_map={
                'validations': {
                    ('n',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                    ('offset',): {

                        'inclusive_minimum': 0,
                    },
                },
                'allowed_values': {
                    ('sort',): {

                        "POPULARITY": "popularity",
                        "HEAT": "heat",
                        "TRUST": "trust",
                        "SHUFFLE": "shuffle",
                        "RANDOM": "random",
                        "FAVORITES": "favorites",
                        "REPORTSCORE": "reportScore",
                        "REPORTCOUNT": "reportCount",
                        "PUBLICATIONDATE": "publicationDate",
                        "LABSPUBLICATIONDATE": "labsPublicationDate",
                        "CREATED": "created",
                        "_CREATED_AT": "_created_at",
                        "UPDATED": "updated",
                        "_UPDATED_AT": "_updated_at",
                        "ORDER": "order",
                        "RELEVANCE": "relevance",
                        "MAGIC": "magic",
                        "NAME": "name"
                    },
                    ('order',): {

                        "ASCENDING": "ascending",
                        "DESCENDING": "descending"
                    },
                    ('release_status',): {

                        "PUBLIC": "public",
                        "PRIVATE": "private",
                        "HIDDEN": "hidden",
                        "ALL": "all"
                    },
                },
                'openapi_types': {
                    'featured':
                        (str,),
                    'sort':
                        (str,),
                    'n':
                        (int,),
                    'order':
                        (str,),
                    'offset':
                        (int,),
                    'search':
                        (str,),
                    'tag':
                        (str,),
                    'notag':
                        (str,),
                    'release_status':
                        (str,),
                    'max_unity_version':
                        (str,),
                    'min_unity_version':
                        (str,),
                    'platform':
                        (str,),
                    'user_id':
                        (str,),
                },
                'attribute_map': {
                    'featured': 'featured',
                    'sort': 'sort',
                    'n': 'n',
                    'order': 'order',
                    'offset': 'offset',
                    'search': 'search',
                    'tag': 'tag',
                    'notag': 'notag',
                    'release_status': 'releaseStatus',
                    'max_unity_version': 'maxUnityVersion',
                    'min_unity_version': 'minUnityVersion',
                    'platform': 'platform',
                    'user_id': 'userId',
                },
                'location_map': {
                    'featured': 'query',
                    'sort': 'query',
                    'n': 'query',
                    'order': 'query',
                    'offset': 'query',
                    'search': 'query',
                    'tag': 'query',
                    'notag': 'query',
                    'release_status': 'query',
                    'max_unity_version': 'query',
                    'min_unity_version': 'query',
                    'platform': 'query',
                    'user_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_world_endpoint = _Endpoint(
            settings={
                'response_type': (World,),
                'auth': [
                    'apiKeyCookie'
                ],
                'endpoint_path': '/worlds/{worldId}',
                'operation_id': 'get_world',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'world_id',
                ],
                'required': [
                    'world_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'world_id':
                        (str,),
                },
                'attribute_map': {
                    'world_id': 'worldId',
                },
                'location_map': {
                    'world_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_world_instance_endpoint = _Endpoint(
            settings={
                'response_type': (Instance,),
                'auth': [
                    'apiKeyCookie',
                    'authCookie'
                ],
                'endpoint_path': '/worlds/{worldId}/{instanceId}',
                'operation_id': 'get_world_instance',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'world_id',
                    'instance_id',
                ],
                'required': [
                    'world_id',
                    'instance_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'world_id':
                        (str,),
                    'instance_id':
                        (str,),
                },
                'attribute_map': {
                    'world_id': 'worldId',
                    'instance_id': 'instanceId',
                },
                'location_map': {
                    'world_id': 'path',
                    'instance_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_world_metadata_endpoint = _Endpoint(
            settings={
                'response_type': (WorldMetadata,),
                'auth': [
                    'apiKeyCookie',
                    'authCookie'
                ],
                'endpoint_path': '/worlds/{worldId}/metadata',
                'operation_id': 'get_world_metadata',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'world_id',
                ],
                'required': [
                    'world_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'world_id':
                        (str,),
                },
                'attribute_map': {
                    'world_id': 'worldId',
                },
                'location_map': {
                    'world_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_world_publish_status_endpoint = _Endpoint(
            settings={
                'response_type': (WorldPublishStatus,),
                'auth': [
                    'apiKeyCookie',
                    'authCookie'
                ],
                'endpoint_path': '/worlds/{worldId}/publish',
                'operation_id': 'get_world_publish_status',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'world_id',
                ],
                'required': [
                    'world_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'world_id':
                        (str,),
                },
                'attribute_map': {
                    'world_id': 'worldId',
                },
                'location_map': {
                    'world_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.publish_world_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'apiKeyCookie',
                    'authCookie'
                ],
                'endpoint_path': '/worlds/{worldId}/publish',
                'operation_id': 'publish_world',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'world_id',
                ],
                'required': [
                    'world_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'world_id':
                        (str,),
                },
                'attribute_map': {
                    'world_id': 'worldId',
                },
                'location_map': {
                    'world_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.search_worlds_endpoint = _Endpoint(
            settings={
                'response_type': ([LimitedWorld],),
                'auth': [
                    'apiKeyCookie',
                    'authCookie'
                ],
                'endpoint_path': '/worlds',
                'operation_id': 'search_worlds',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'featured',
                    'sort',
                    'user',
                    'user_id',
                    'n',
                    'order',
                    'offset',
                    'search',
                    'tag',
                    'notag',
                    'release_status',
                    'max_unity_version',
                    'min_unity_version',
                    'platform',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'sort',
                    'user',
                    'order',
                    'release_status',
                ],
                'validation': [
                    'n',
                    'offset',
                ]
            },
            root_map={
                'validations': {
                    ('n',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                    ('offset',): {

                        'inclusive_minimum': 0,
                    },
                },
                'allowed_values': {
                    ('sort',): {

                        "POPULARITY": "popularity",
                        "HEAT": "heat",
                        "TRUST": "trust",
                        "SHUFFLE": "shuffle",
                        "RANDOM": "random",
                        "FAVORITES": "favorites",
                        "REPORTSCORE": "reportScore",
                        "REPORTCOUNT": "reportCount",
                        "PUBLICATIONDATE": "publicationDate",
                        "LABSPUBLICATIONDATE": "labsPublicationDate",
                        "CREATED": "created",
                        "_CREATED_AT": "_created_at",
                        "UPDATED": "updated",
                        "_UPDATED_AT": "_updated_at",
                        "ORDER": "order",
                        "RELEVANCE": "relevance",
                        "MAGIC": "magic",
                        "NAME": "name"
                    },
                    ('user',): {

                        "ME": "me"
                    },
                    ('order',): {

                        "ASCENDING": "ascending",
                        "DESCENDING": "descending"
                    },
                    ('release_status',): {

                        "PUBLIC": "public",
                        "PRIVATE": "private",
                        "HIDDEN": "hidden",
                        "ALL": "all"
                    },
                },
                'openapi_types': {
                    'featured':
                        (str,),
                    'sort':
                        (str,),
                    'user':
                        (str,),
                    'user_id':
                        (str,),
                    'n':
                        (int,),
                    'order':
                        (str,),
                    'offset':
                        (int,),
                    'search':
                        (str,),
                    'tag':
                        (str,),
                    'notag':
                        (str,),
                    'release_status':
                        (str,),
                    'max_unity_version':
                        (str,),
                    'min_unity_version':
                        (str,),
                    'platform':
                        (str,),
                },
                'attribute_map': {
                    'featured': 'featured',
                    'sort': 'sort',
                    'user': 'user',
                    'user_id': 'userId',
                    'n': 'n',
                    'order': 'order',
                    'offset': 'offset',
                    'search': 'search',
                    'tag': 'tag',
                    'notag': 'notag',
                    'release_status': 'releaseStatus',
                    'max_unity_version': 'maxUnityVersion',
                    'min_unity_version': 'minUnityVersion',
                    'platform': 'platform',
                },
                'location_map': {
                    'featured': 'query',
                    'sort': 'query',
                    'user': 'query',
                    'user_id': 'query',
                    'n': 'query',
                    'order': 'query',
                    'offset': 'query',
                    'search': 'query',
                    'tag': 'query',
                    'notag': 'query',
                    'release_status': 'query',
                    'max_unity_version': 'query',
                    'min_unity_version': 'query',
                    'platform': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.unpublish_world_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'apiKeyCookie',
                    'authCookie'
                ],
                'endpoint_path': '/worlds/{worldId}/publish',
                'operation_id': 'unpublish_world',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'world_id',
                ],
                'required': [
                    'world_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'world_id':
                        (str,),
                },
                'attribute_map': {
                    'world_id': 'worldId',
                },
                'location_map': {
                    'world_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.update_world_endpoint = _Endpoint(
            settings={
                'response_type': (World,),
                'auth': [
                    'apiKeyCookie',
                    'authCookie'
                ],
                'endpoint_path': '/worlds/{worldId}',
                'operation_id': 'update_world',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'world_id',
                    'update_world_request',
                ],
                'required': [
                    'world_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'world_id':
                        (str,),
                    'update_world_request':
                        (UpdateWorldRequest,),
                },
                'attribute_map': {
                    'world_id': 'worldId',
                },
                'location_map': {
                    'world_id': 'path',
                    'update_world_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def create_world(
        self,
        **kwargs
    ):
        """Create World  # noqa: E501

        Create a new world. This endpoint requires `assetUrl` to be a valid File object with `.vrcw` file extension, and `imageUrl` to be a valid File object with an image file extension.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_world(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            create_world_request (CreateWorldRequest): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            World
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.create_world_endpoint.call_with_http_info(**kwargs)

    def delete_world(
        self,
        world_id,
        **kwargs
    ):
        """Delete World  # noqa: E501

        Delete a world. Notice a world is never fully \"deleted\", only its ReleaseStatus is set to \"hidden\" and the linked Files are deleted. The WorldID is permanently reserved.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_world(world_id, async_req=True)
        >>> result = thread.get()

        Args:
            world_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['world_id'] = \
            world_id
        return self.delete_world_endpoint.call_with_http_info(**kwargs)

    def get_active_worlds(
        self,
        **kwargs
    ):
        """List Active Worlds  # noqa: E501

        Search and list currently Active worlds by query filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_active_worlds(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            featured (str): Filters on featured results.. [optional]
            sort (str): [optional] if omitted the server will use the default value of "popularity"
            n (int): The number of objects to return.. [optional] if omitted the server will use the default value of 60
            order (str): [optional] if omitted the server will use the default value of "descending"
            offset (int): A zero-based offset from the default object sorting from where search results start.. [optional]
            search (str): Filters by world name.. [optional]
            tag (str): Tags to include (comma-separated). Any of the tags needs to be present.. [optional]
            notag (str): Tags to exclude (comma-separated).. [optional]
            release_status (str): Filter by ReleaseStatus.. [optional] if omitted the server will use the default value of "public"
            max_unity_version (str): The maximum Unity version supported by the asset.. [optional]
            min_unity_version (str): The minimum Unity version supported by the asset.. [optional]
            platform (str): The platform the asset supports.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [LimitedWorld]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.get_active_worlds_endpoint.call_with_http_info(**kwargs)

    def get_favorited_worlds(
        self,
        **kwargs
    ):
        """List Favorited Worlds  # noqa: E501

        Search and list favorited worlds by query filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_favorited_worlds(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            featured (str): Filters on featured results.. [optional]
            sort (str): [optional] if omitted the server will use the default value of "popularity"
            n (int): The number of objects to return.. [optional] if omitted the server will use the default value of 60
            order (str): [optional] if omitted the server will use the default value of "descending"
            offset (int): A zero-based offset from the default object sorting from where search results start.. [optional]
            search (str): Filters by world name.. [optional]
            tag (str): Tags to include (comma-separated). Any of the tags needs to be present.. [optional]
            notag (str): Tags to exclude (comma-separated).. [optional]
            release_status (str): Filter by ReleaseStatus.. [optional] if omitted the server will use the default value of "public"
            max_unity_version (str): The maximum Unity version supported by the asset.. [optional]
            min_unity_version (str): The minimum Unity version supported by the asset.. [optional]
            platform (str): The platform the asset supports.. [optional]
            user_id (str): Target user to see information on, admin-only.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [LimitedWorld]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.get_favorited_worlds_endpoint.call_with_http_info(**kwargs)

    def get_recent_worlds(
        self,
        **kwargs
    ):
        """List Recent Worlds  # noqa: E501

        Search and list recently visited worlds by query filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_recent_worlds(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            featured (str): Filters on featured results.. [optional]
            sort (str): [optional] if omitted the server will use the default value of "popularity"
            n (int): The number of objects to return.. [optional] if omitted the server will use the default value of 60
            order (str): [optional] if omitted the server will use the default value of "descending"
            offset (int): A zero-based offset from the default object sorting from where search results start.. [optional]
            search (str): Filters by world name.. [optional]
            tag (str): Tags to include (comma-separated). Any of the tags needs to be present.. [optional]
            notag (str): Tags to exclude (comma-separated).. [optional]
            release_status (str): Filter by ReleaseStatus.. [optional] if omitted the server will use the default value of "public"
            max_unity_version (str): The maximum Unity version supported by the asset.. [optional]
            min_unity_version (str): The minimum Unity version supported by the asset.. [optional]
            platform (str): The platform the asset supports.. [optional]
            user_id (str): Target user to see information on, admin-only.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [LimitedWorld]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.get_recent_worlds_endpoint.call_with_http_info(**kwargs)

    def get_world(
        self,
        world_id,
        **kwargs
    ):
        """Get World by ID  # noqa: E501

        Get information about a specific World.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_world(world_id, async_req=True)
        >>> result = thread.get()

        Args:
            world_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            World
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['world_id'] = \
            world_id
        return self.get_world_endpoint.call_with_http_info(**kwargs)

    def get_world_instance(
        self,
        world_id,
        instance_id,
        **kwargs
    ):
        """Get World Instance  # noqa: E501

        Returns a worlds instance.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_world_instance(world_id, instance_id, async_req=True)
        >>> result = thread.get()

        Args:
            world_id (str):
            instance_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Instance
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['world_id'] = \
            world_id
        kwargs['instance_id'] = \
            instance_id
        return self.get_world_instance_endpoint.call_with_http_info(**kwargs)

    def get_world_metadata(
        self,
        world_id,
        **kwargs
    ):
        """Get World Metadata  # noqa: E501

        Return a worlds custom metadata. This is currently believed to be unused. Metadata can be set with `updateWorld` and can be any arbitrary object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_world_metadata(world_id, async_req=True)
        >>> result = thread.get()

        Args:
            world_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            WorldMetadata
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['world_id'] = \
            world_id
        return self.get_world_metadata_endpoint.call_with_http_info(**kwargs)

    def get_world_publish_status(
        self,
        world_id,
        **kwargs
    ):
        """Get World Publish Status  # noqa: E501

        Returns a worlds publish status.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_world_publish_status(world_id, async_req=True)
        >>> result = thread.get()

        Args:
            world_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            WorldPublishStatus
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['world_id'] = \
            world_id
        return self.get_world_publish_status_endpoint.call_with_http_info(**kwargs)

    def publish_world(
        self,
        world_id,
        **kwargs
    ):
        """Publish World  # noqa: E501

        Publish a world. You can only publish one world per week.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.publish_world(world_id, async_req=True)
        >>> result = thread.get()

        Args:
            world_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['world_id'] = \
            world_id
        return self.publish_world_endpoint.call_with_http_info(**kwargs)

    def search_worlds(
        self,
        **kwargs
    ):
        """Search All Worlds  # noqa: E501

        Search and list any worlds by query filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.search_worlds(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            featured (str): Filters on featured results.. [optional]
            sort (str): [optional] if omitted the server will use the default value of "popularity"
            user (str): Set to `me` for searching own worlds.. [optional] if omitted the server will use the default value of "me"
            user_id (str): Filter by UserID.. [optional]
            n (int): The number of objects to return.. [optional] if omitted the server will use the default value of 60
            order (str): [optional] if omitted the server will use the default value of "descending"
            offset (int): A zero-based offset from the default object sorting from where search results start.. [optional]
            search (str): Filters by world name.. [optional]
            tag (str): Tags to include (comma-separated). Any of the tags needs to be present.. [optional]
            notag (str): Tags to exclude (comma-separated).. [optional]
            release_status (str): Filter by ReleaseStatus.. [optional] if omitted the server will use the default value of "public"
            max_unity_version (str): The maximum Unity version supported by the asset.. [optional]
            min_unity_version (str): The minimum Unity version supported by the asset.. [optional]
            platform (str): The platform the asset supports.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [LimitedWorld]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.search_worlds_endpoint.call_with_http_info(**kwargs)

    def unpublish_world(
        self,
        world_id,
        **kwargs
    ):
        """Unpublish World  # noqa: E501

        Unpublish a world.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.unpublish_world(world_id, async_req=True)
        >>> result = thread.get()

        Args:
            world_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['world_id'] = \
            world_id
        return self.unpublish_world_endpoint.call_with_http_info(**kwargs)

    def update_world(
        self,
        world_id,
        **kwargs
    ):
        """Update World  # noqa: E501

        Update information about a specific World.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_world(world_id, async_req=True)
        >>> result = thread.get()

        Args:
            world_id (str):

        Keyword Args:
            update_world_request (UpdateWorldRequest): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            World
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['world_id'] = \
            world_id
        return self.update_world_endpoint.call_with_http_info(**kwargs)

