"""evaluation_randomness

Revision ID: 97cf99b7348f
Revises: cfd5c3386014
Create Date: 2019-04-11 13:21:09.907895

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = '97cf99b7348f'
down_revision = 'cfd5c3386014'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('evaluations', sa.Column('best_value', sa.Numeric(), nullable=True), schema='train_results')
    op.add_column('evaluations', sa.Column('worst_value', sa.Numeric(), nullable=True), schema='train_results')
    op.add_column('evaluations', sa.Column('stochastic_value', sa.Numeric(), nullable=True), schema='train_results')
    op.add_column('evaluations', sa.Column('num_sort_trials', sa.Integer(), nullable=True), schema='train_results')
    op.add_column('evaluations', sa.Column('standard_deviation', sa.Numeric(), nullable=True), schema='train_results')
    op.add_column('evaluations', sa.Column('best_value', sa.Numeric(), nullable=True), schema='test_results')
    op.add_column('evaluations', sa.Column('worst_value', sa.Numeric(), nullable=True), schema='test_results')
    op.add_column('evaluations', sa.Column('stochastic_value', sa.Numeric(), nullable=True), schema='test_results')
    op.add_column('evaluations', sa.Column('num_sort_trials', sa.Integer(), nullable=True), schema='test_results')
    op.add_column('evaluations', sa.Column('standard_deviation', sa.Numeric(), nullable=True), schema='test_results')
    op.execute("update train_results.evaluations set stochastic_value = value, num_sort_trials = 1")
    op.execute("update test_results.evaluations set stochastic_value = value, num_sort_trials = 1")
    op.drop_column('evaluations', 'value', schema='train_results')
    op.drop_column('evaluations', 'value', schema='test_results')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('evaluations', sa.Column('value', sa.Numeric(), nullable=True), schema='train_results')
    op.add_column('evaluations', sa.Column('value', sa.Numeric(), nullable=True), schema='test_results')
    op.execute("update train_results.evaluations set value = stochastic_value")
    op.execute("update test_results.evaluations set value = stochastic_value")
    op.drop_column('evaluations', 'worst_value', schema='test_results')
    op.drop_column('evaluations', 'stochastic_value', schema='test_results')
    op.drop_column('evaluations', 'best_value', schema='test_results')
    op.drop_column('evaluations', 'num_sort_trials', schema='test_results')
    op.drop_column('evaluations', 'standard_deviation', schema='test_results')
    op.drop_column('evaluations', 'worst_value', schema='train_results')
    op.drop_column('evaluations', 'stochastic_value', schema='train_results')
    op.drop_column('evaluations', 'best_value', schema='train_results')
    op.drop_column('evaluations', 'num_sort_trials', schema='train_results')
    op.drop_column('evaluations', 'standard_deviation', schema='train_results')
    # ### end Alembic commands ###
