"""Add production prediction metadata

Revision ID: 670289044eb2
Revises: ce5b50ffa8e2
Create Date: 2021-01-08 22:27:23.433813

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = '670289044eb2'
down_revision = 'ce5b50ffa8e2'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('prediction_metadata',
    sa.Column('model_id', sa.Integer(), nullable=False),
    sa.Column('matrix_uuid', sa.Text(), nullable=False),
    sa.Column('tiebreaker_ordering', sa.Text(), nullable=True),
    sa.Column('random_seed', sa.Integer(), nullable=True),
    sa.Column('predictions_saved', sa.Boolean(), nullable=True),
    sa.ForeignKeyConstraint(['matrix_uuid'], ['triage_metadata.matrices.matrix_uuid'], ),
    sa.ForeignKeyConstraint(['model_id'], ['triage_metadata.models.model_id'], ),
    sa.PrimaryKeyConstraint('model_id', 'matrix_uuid'),
    schema='production'
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('prediction_metadata', schema='production')
    # ### end Alembic commands ###
