# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['carte_cli',
 'carte_cli.extractor',
 'carte_cli.loader',
 'carte_cli.model',
 'carte_cli.utils']

package_data = \
{'': ['*']}

install_requires = \
['SQLAlchemy>=1.3.23,<2.0.0',
 'amundsen-databuilder>=4.1.0,<5.0.0',
 'boto3>=1.17.2,<2.0.0',
 'click-spinner>=0.1.10,<0.2.0',
 'psycopg2>=2.8.6,<3.0.0',
 'ruamel.yaml>=0.16.12,<0.17.0',
 'typer>=0.3.2,<0.4.0']

entry_points = \
{'console_scripts': ['carte = carte_cli.main:app']}

setup_kwargs = {
    'name': 'carte-cli',
    'version': '0.2.0',
    'description': 'A static site generator for data catalogs',
    'long_description': "# Carte\n[![PyPI version](https://badge.fury.io/py/carte.svg)](https://badge.fury.io/py/carte)\n[![License](http://img.shields.io/:license-Apache%202-blue.svg)](LICENSE)\n[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/carte.svg)](https://pypi.org/project/carte/)\n\n\nCarte is a Python library for extracting metadata from your data sources and generating structured Markdown files from it. It's a companion library to the Carte front end, a lightweight data catalog for fast moving data teams. Carte currently supports the AWS Glue catalog and PostgreSQL but more sources are coming.\n\nThe files generated by Carte can be fed into the front end as-is to get a statically generated data catalog.\n\n## Installation\n\n``` sh\npip install carte-cli\n```\n\n## Usage\n\nCarte uses the Boto3 library to fetch the Glue catalog. This means you need an AWS CLI profile defined that can access the required databases and tables.\n\nFor PostgreSQL, you need to construct a connection string with your username, password, the DB's host, and the database you'd like to extract on the host.\n\nCarte CLI works from a YAML config that you have to specify when running an extraction. An example config with both Glue and Postgres:\n\n``` yaml\nconnections:\n  - type: glue\n    name: aws_glue\n  - type: postgresql\n    config:\n      extractor.sqlalchemy.conn_string: 'postgresql://<user>:<password>@<host>:<port>/<database>'\n```\n\nIf you name this config `extract.config.yml`, then you can run an extraction with:\n\n``` sh\ncarte -c extract.config.yml -o data/datasets\n```\n\nwhere the `-o` flag specifies the output folder.\n",
    'author': 'Balint Haller',
    'author_email': 'balint@hey.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://cartedata.com',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
