# Carte
[![PyPI version](https://badge.fury.io/py/carte.svg)](https://badge.fury.io/py/carte)
[![License](http://img.shields.io/:license-Apache%202-blue.svg)](LICENSE)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/carte.svg)](https://pypi.org/project/carte/)


Carte is a Python library for extracting metadata from your data sources and generating structured Markdown files from it. It's a companion library to the Carte front end, a lightweight data catalog for fast moving data teams. Carte currently supports the AWS Glue catalog and PostgreSQL but more sources are coming.

The files generated by Carte can be fed into the front end as-is to get a statically generated data catalog.

## Installation

``` sh
pip install carte-cli
```

## Usage

Carte uses the Boto3 library to fetch the Glue catalog. This means you need an AWS CLI profile defined that can access the required databases and tables.

For PostgreSQL, you need to construct a connection string with your username, password, the DB's host, and the database you'd like to extract on the host.

Carte CLI works from a YAML config that you have to specify when running an extraction. An example config with both Glue and Postgres:

``` yaml
connections:
  - type: glue
    name: aws_glue
  - type: postgresql
    config:
      extractor.sqlalchemy.conn_string: 'postgresql://<user>:<password>@<host>:<port>/<database>'
```

If you name this config `extract.config.yml`, then you can run an extraction with:

``` sh
carte -c extract.config.yml -o data/datasets
```

where the `-o` flag specifies the output folder.
