/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.xhtml;

import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.primitive.XhtmlDt;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.instance.model.api.IBaseXhtml;
import org.hl7.fhir.utilities.MarkDownProcessor;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlComposer;
import org.hl7.fhir.utilities.xhtml.XhtmlDocument;
import org.hl7.fhir.utilities.xhtml.XhtmlParser;

@DatatypeDef(name="xhtml")
public class XhtmlNode
implements IBaseXhtml {
    private static final long serialVersionUID = -4362547161441436492L;
    public static final String NBSP = Character.toString('\u00a0');
    public static final String XMLNS = "http://www.w3.org/1999/xhtml";
    private static final String DECL_XMLNS = " xmlns=\"http://www.w3.org/1999/xhtml\"";
    private Location location;
    private NodeType nodeType;
    private String name;
    private Map<String, String> attributes = new HashMap<String, String>();
    private List<XhtmlNode> childNodes = new ArrayList<XhtmlNode>();
    private String content;
    private boolean notPretty;
    private boolean inPara;
    private boolean inLink;
    private boolean seperated;

    public XhtmlNode() {
    }

    public XhtmlNode(NodeType nodeType, String name) {
        this.nodeType = nodeType;
        this.name = name;
    }

    public XhtmlNode(NodeType nodeType) {
        this.nodeType = nodeType;
    }

    public NodeType getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(NodeType nodeType) {
        this.nodeType = nodeType;
    }

    public String getName() {
        return this.name;
    }

    public XhtmlNode setName(String name) {
        assert (!name.contains(":")) : "Name should not contain any : but was " + name;
        this.name = name;
        return this;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public List<XhtmlNode> getChildNodes() {
        return this.childNodes;
    }

    public String getContent() {
        return this.content;
    }

    public XhtmlNode setContent(String content) {
        if (this.nodeType == NodeType.Text && this.nodeType == NodeType.Comment) {
            throw new Error("Wrong node type");
        }
        this.content = content;
        return this;
    }

    public void validate(List<String> errors, String path, boolean inResource, boolean inPara, boolean inLink) {
        if (this.nodeType == NodeType.Element || this.nodeType == NodeType.Document) {
            String string = path = Utilities.noString(path) ? this.name : path + "/" + this.name;
            if (inResource) {
                if (!Utilities.existsInList(this.name, "p", "br", "div", "h1", "h2", "h3", "h4", "h5", "h6", "a", "span", "b", "em", "i", "strong", "small", "big", "tt", "small", "dfn", "q", "var", "abbr", "acronym", "cite", "blockquote", "hr", "address", "bdo", "kbd", "q", "sub", "sup", "ul", "ol", "li", "dl", "dt", "dd", "pre", "table", "caption", "colgroup", "col", "thead", "tr", "tfoot", "tbody", "th", "td", "code", "samp", "img", "map", "area")) {
                    errors.add("Error at " + path + ": Found " + this.name + " in a resource");
                }
                for (String an : this.attributes.keySet()) {
                    boolean ok = an.startsWith("xmlns") || Utilities.existsInList(an, "title", "style", "class", "ID", "lang", "xml:lang", "dir", "accesskey", "tabindex", "span", "width", "align", "valign", "char", "charoff", "abbr", "axis", "headers", "scope", "rowspan", "colspan") || Utilities.existsInList(this.name + "." + an, "a.href", "a.name", "img.src", "img.border", "div.xmlns", "blockquote.cite", "q.cite", "a.charset", "a.type", "a.name", "a.href", "a.hreflang", "a.rel", "a.rev", "a.shape", "a.coords", "img.src", "img.alt", "img.longdesc", "img.height", "img.width", "img.usemap", "img.ismap", "map.name", "area.shape", "area.coords", "area.href", "area.nohref", "area.alt", "table.summary", "table.width", "table.border", "table.frame", "table.rules", "table.cellspacing", "table.cellpadding", "pre.space", "td.nowrap");
                    if (ok) continue;
                    errors.add("Error at " + path + ": Found attribute " + this.name + "." + an + " in a resource");
                }
            }
            if (inPara && Utilities.existsInList(this.name, "div", "blockquote", "table", "ol", "ul", "p")) {
                errors.add("Error at " + path + ": Found " + this.name + " inside an html paragraph");
            }
            if (inLink && Utilities.existsInList(this.name, "a")) {
                errors.add("Error at " + path + ": Found an <a> inside an <a> paragraph");
            }
            if (this.childNodes != null) {
                if ("p".equals(this.name)) {
                    inPara = true;
                }
                if ("a".equals(this.name)) {
                    inLink = true;
                }
                for (XhtmlNode child : this.childNodes) {
                    child.validate(errors, path, inResource, inPara, inLink);
                }
            }
        }
    }

    public XhtmlNode addTag(String name) {
        if (this.nodeType != NodeType.Element && this.nodeType != NodeType.Document) {
            throw new Error("Wrong node type - node is " + this.nodeType.toString() + " ('" + this.getName() + "/" + this.getContent() + "')");
        }
        XhtmlNode node = new XhtmlNode(NodeType.Element);
        node.setName(name);
        if (this.inPara || name.equals("p")) {
            node.inPara = true;
        }
        if (this.inLink || name.equals("a")) {
            node.inLink = true;
        }
        this.childNodes.add(node);
        return node;
    }

    public XhtmlNode addTag(int index, String name) {
        if (this.nodeType != NodeType.Element && this.nodeType != NodeType.Document) {
            throw new Error("Wrong node type. is " + this.nodeType.toString());
        }
        XhtmlNode node = new XhtmlNode(NodeType.Element);
        if (this.inPara || name.equals("p")) {
            node.inPara = true;
        }
        if (this.inLink || name.equals("a")) {
            node.inLink = true;
        }
        node.setName(name);
        this.childNodes.add(index, node);
        return node;
    }

    public XhtmlNode addComment(String content) {
        if (this.nodeType != NodeType.Element && this.nodeType != NodeType.Document) {
            throw new Error("Wrong node type");
        }
        XhtmlNode node = new XhtmlNode(NodeType.Comment);
        node.setContent(content);
        this.childNodes.add(node);
        return node;
    }

    public XhtmlNode addDocType(String content) {
        if (this.nodeType != NodeType.Document) {
            throw new Error("Wrong node type");
        }
        XhtmlNode node = new XhtmlNode(NodeType.DocType);
        node.setContent(content);
        this.childNodes.add(node);
        return node;
    }

    public XhtmlNode addInstruction(String content) {
        if (this.nodeType != NodeType.Document) {
            throw new Error("Wrong node type");
        }
        XhtmlNode node = new XhtmlNode(NodeType.Instruction);
        node.setContent(content);
        this.childNodes.add(node);
        return node;
    }

    public XhtmlNode addText(String content) {
        if (this.nodeType != NodeType.Element && this.nodeType != NodeType.Document) {
            throw new Error("Wrong node type");
        }
        if (content != null) {
            XhtmlNode node = new XhtmlNode(NodeType.Text);
            node.setContent(content);
            this.childNodes.add(node);
            return node;
        }
        return null;
    }

    public XhtmlNode addText(int index, String content) {
        if (this.nodeType != NodeType.Element && this.nodeType != NodeType.Document) {
            throw new Error("Wrong node type");
        }
        if (content == null) {
            throw new Error("Content cannot be null");
        }
        XhtmlNode node = new XhtmlNode(NodeType.Text);
        node.setContent(content);
        this.childNodes.add(index, node);
        return node;
    }

    public boolean allChildrenAreText() {
        boolean res = true;
        for (XhtmlNode n : this.childNodes) {
            res = res && n.getNodeType() == NodeType.Text;
        }
        return res;
    }

    public XhtmlNode getElement(String name) {
        for (XhtmlNode n : this.childNodes) {
            if (n.getNodeType() != NodeType.Element || !name.equals(n.getName())) continue;
            return n;
        }
        return null;
    }

    public XhtmlNode getFirstElement() {
        for (XhtmlNode n : this.childNodes) {
            if (n.getNodeType() != NodeType.Element) continue;
            return n;
        }
        return null;
    }

    public String allText() {
        if (this.childNodes == null || this.childNodes.isEmpty()) {
            return this.getContent();
        }
        StringBuilder b = new StringBuilder();
        for (XhtmlNode n : this.childNodes) {
            if (n.getNodeType() == NodeType.Text) {
                b.append(n.getContent());
                continue;
            }
            if (n.getNodeType() != NodeType.Element) continue;
            b.append(n.allText());
        }
        return b.toString();
    }

    public XhtmlNode attribute(String name, String value) {
        if (this.nodeType != NodeType.Element && this.nodeType != NodeType.Document) {
            throw new Error("Wrong node type");
        }
        if (name == null) {
            throw new Error("name is null");
        }
        if (value == null) {
            throw new Error("value is null");
        }
        this.attributes.put(name, value);
        return this;
    }

    public boolean hasAttribute(String name) {
        return this.getAttributes().containsKey(name);
    }

    public String getAttribute(String name) {
        return this.getAttributes().get(name);
    }

    public XhtmlNode setAttribute(String name, String value) {
        if (this.nodeType != NodeType.Element) {
            throw new Error("Attempt to set an attribute on something that is not an element");
        }
        this.getAttributes().put(name, value);
        return this;
    }

    public XhtmlNode copy() {
        XhtmlNode dst = new XhtmlNode(this.nodeType);
        dst.name = this.name;
        for (String string : this.attributes.keySet()) {
            dst.attributes.put(string, this.attributes.get(string));
        }
        for (XhtmlNode xhtmlNode : this.childNodes) {
            dst.childNodes.add(xhtmlNode.copy());
        }
        dst.content = this.content;
        return dst;
    }

    @Override
    public boolean isEmpty() {
        return (this.childNodes == null || this.childNodes.isEmpty()) && this.content == null;
    }

    public boolean equalsDeep(XhtmlNode other) {
        if (other == null) {
            return false;
        }
        if (this.nodeType != other.nodeType || !this.compare(this.name, other.name) || !this.compare(this.content, other.content)) {
            return false;
        }
        if (this.attributes.size() != other.attributes.size()) {
            return false;
        }
        for (String an : this.attributes.keySet()) {
            if (this.attributes.get(an).equals(other.attributes.get(an))) continue;
            return false;
        }
        if (this.childNodes.size() != other.childNodes.size()) {
            return false;
        }
        for (int i = 0; i < this.childNodes.size(); ++i) {
            if (XhtmlNode.compareDeep(this.childNodes.get(i), other.childNodes.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean compare(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    private static boolean compareDeep(XhtmlNode e1, XhtmlNode e2) {
        if (e1 == null && e2 == null) {
            return true;
        }
        if (e1 == null || e2 == null) {
            return false;
        }
        return e1.equalsDeep(e2);
    }

    public String getNsDecl() {
        for (String an : this.attributes.keySet()) {
            if (!an.equals("xmlns")) continue;
            return this.attributes.get(an);
        }
        return null;
    }

    @Override
    public String getValueAsString() {
        if (this.isEmpty()) {
            return null;
        }
        try {
            String retVal = new XhtmlComposer(true).compose(this);
            retVal = XhtmlDt.preprocessXhtmlNamespaceDeclaration(retVal);
            return retVal;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setValueAsString(String theValue) throws IllegalArgumentException {
        this.attributes = null;
        this.childNodes = null;
        this.content = null;
        this.name = null;
        this.nodeType = null;
        if (theValue == null || theValue.length() == 0) {
            return;
        }
        String val = theValue.trim();
        if (!val.startsWith("<")) {
            val = "<div xmlns=\"http://www.w3.org/1999/xhtml\">" + val + "</div>";
        }
        if (val.startsWith("<?") && val.endsWith("?>")) {
            return;
        }
        val = XhtmlDt.preprocessXhtmlNamespaceDeclaration(val);
        try {
            XhtmlDocument fragment = new XhtmlParser().parse(val, "div");
            this.attributes = fragment.getAttributes();
            this.childNodes = fragment.getChildNodes();
            if (this.childNodes.size() > 0 && this.childNodes.get(0) != null && this.childNodes.get(0).getNodeType() == NodeType.Instruction) {
                this.childNodes.remove(0);
            }
            this.content = fragment.getContent();
            this.name = fragment.getName();
            this.nodeType = fragment.getNodeType();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public XhtmlNode getElementByIndex(int i) {
        int c = 0;
        for (XhtmlNode n : this.childNodes) {
            if (n.getNodeType() != NodeType.Element) continue;
            if (c == i) {
                return n;
            }
            ++c;
        }
        return null;
    }

    @Override
    public String getValue() {
        return this.getValueAsString();
    }

    @Override
    public boolean hasValue() {
        return StringUtils.isNotBlank(this.getValueAsString());
    }

    public XhtmlNode setValue(String theValue) throws IllegalArgumentException {
        this.setValueAsString(theValue);
        return this;
    }

    @Override
    public boolean hasFormatComment() {
        return false;
    }

    @Override
    public List<String> getFormatCommentsPre() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> getFormatCommentsPost() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getUserData(String theName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setUserData(String theName, Object theValue) {
        throw new UnsupportedOperationException();
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public XhtmlNode h1() {
        return this.addTag("h1");
    }

    public XhtmlNode h2() {
        return this.addTag("h2");
    }

    public XhtmlNode h(int level) {
        if (level < 1 || level > 6) {
            throw new FHIRException("Illegal Header level " + level);
        }
        return this.addTag("h" + Integer.toString(level));
    }

    public XhtmlNode h3() {
        return this.addTag("h3");
    }

    public XhtmlNode h4() {
        return this.addTag("h4");
    }

    public XhtmlNode table(String clss) {
        XhtmlNode res = this.addTag("table");
        if (!Utilities.noString(clss)) {
            res.setAttribute("class", clss);
        }
        return res;
    }

    public XhtmlNode tr() {
        return this.addTag("tr");
    }

    public XhtmlNode th() {
        return this.addTag("th");
    }

    public XhtmlNode td() {
        return this.addTag("td");
    }

    public XhtmlNode td(String clss) {
        return this.addTag("td").attribute("class", clss);
    }

    public XhtmlNode colspan(String n) {
        return this.setAttribute("colspan", n);
    }

    public XhtmlNode div() {
        return this.addTag("div");
    }

    public XhtmlNode para() {
        return this.addTag("p");
    }

    public XhtmlNode pre() {
        return this.addTag("pre");
    }

    public XhtmlNode pre(String clss) {
        return this.addTag("pre").setAttribute("class", clss);
    }

    public void br() {
        this.addTag("br");
    }

    public void hr() {
        this.addTag("hr");
    }

    public XhtmlNode ul() {
        return this.addTag("ul");
    }

    public XhtmlNode li() {
        return this.addTag("li");
    }

    public XhtmlNode b() {
        return this.addTag("b");
    }

    public XhtmlNode i() {
        return this.addTag("i");
    }

    public XhtmlNode tx(String cnt) {
        return this.addText(cnt);
    }

    public XhtmlNode txN(String cnt) {
        this.addText(cnt);
        return this;
    }

    public XhtmlNode tx(int cnt) {
        return this.addText(Integer.toString(cnt));
    }

    public XhtmlNode ah(String href) {
        return this.addTag("a").attribute("href", href);
    }

    public XhtmlNode ah(String href, String title) {
        return this.addTag("a").attribute("href", href).attribute("title", title);
    }

    public XhtmlNode img(String src) {
        return this.addTag("img").attribute("src", src);
    }

    public XhtmlNode img(String src, String title) {
        return this.addTag("img").attribute("src", src).attribute("title", title);
    }

    public XhtmlNode an(String href) {
        return this.an(href, " ");
    }

    public XhtmlNode an(String href, String tx) {
        XhtmlNode a = this.addTag("a").attribute("name", href);
        a.tx(tx);
        return a;
    }

    public XhtmlNode span(String style, String title) {
        XhtmlNode res = this.addTag("span");
        if (!Utilities.noString(style)) {
            res.attribute("style", style);
        }
        if (!Utilities.noString(title)) {
            res.attribute("title", title);
        }
        return res;
    }

    public XhtmlNode code(String text) {
        return this.addTag("code").tx(text);
    }

    public XhtmlNode code() {
        return this.addTag("code");
    }

    public XhtmlNode blockquote() {
        return this.addTag("blockquote");
    }

    public String toString() {
        switch (this.nodeType) {
            case Document: 
            case Element: {
                try {
                    return new XhtmlComposer(false).compose(this);
                }
                catch (IOException e) {
                    return super.toString();
                }
            }
            case Text: {
                return this.content;
            }
            case Comment: {
                return "<!-- " + this.content + " -->";
            }
            case DocType: {
                return "<? " + this.content + " />";
            }
            case Instruction: {
                return "<? " + this.content + " />";
            }
        }
        return super.toString();
    }

    public XhtmlNode getNextElement(XhtmlNode c) {
        boolean f = false;
        for (XhtmlNode n : this.childNodes) {
            if (n == c) {
                f = true;
                continue;
            }
            if (!f || n.getNodeType() != NodeType.Element) continue;
            return n;
        }
        return null;
    }

    public XhtmlNode notPretty() {
        this.notPretty = true;
        return this;
    }

    public boolean isNoPretty() {
        return this.notPretty;
    }

    public XhtmlNode style(String style) {
        if (this.hasAttribute("style")) {
            this.setAttribute("style", this.getAttribute("style") + "; " + style);
        } else {
            this.setAttribute("style", style);
        }
        return this;
    }

    public XhtmlNode nbsp() {
        this.addText(NBSP);
        return this;
    }

    public XhtmlNode para(String text) {
        XhtmlNode p = this.para();
        p.addText(text);
        return p;
    }

    public XhtmlNode add(XhtmlNode n) {
        this.getChildNodes().add(n);
        return this;
    }

    public XhtmlNode addChildren(List<XhtmlNode> children) {
        this.getChildNodes().addAll(children);
        return this;
    }

    public XhtmlNode addChildren(XhtmlNode x) {
        if (x != null) {
            this.getChildNodes().addAll(x.getChildNodes());
        }
        return this;
    }

    public XhtmlNode input(String name, String type, String placeholder, int size) {
        XhtmlNode p = new XhtmlNode(NodeType.Element, "input");
        p.attribute("name", name);
        p.attribute("type", type);
        p.attribute("placeholder", placeholder);
        p.attribute("size", Integer.toString(size));
        this.getChildNodes().add(p);
        return p;
    }

    public XhtmlNode select(String name) {
        XhtmlNode p = new XhtmlNode(NodeType.Element, "select");
        p.attribute("name", name);
        p.attribute("size", "1");
        this.getChildNodes().add(p);
        return p;
    }

    public XhtmlNode option(String value, String text, boolean selected) {
        XhtmlNode p = new XhtmlNode(NodeType.Element, "option");
        p.attribute("value", value);
        p.attribute("selected", Boolean.toString(selected));
        p.tx(text);
        this.getChildNodes().add(p);
        return p;
    }

    public XhtmlNode remove(XhtmlNode x) {
        this.getChildNodes().remove(x);
        return this;
    }

    public void clear() {
        this.getChildNodes().clear();
    }

    public XhtmlNode backgroundColor(String color) {
        this.style("background-color: " + color);
        return this;
    }

    public boolean isPara() {
        return "p".equals(this.name);
    }

    public void markdown(String md, String source) throws IOException {
        if (md != null) {
            XhtmlDocument m3;
            String s2 = new MarkDownProcessor(MarkDownProcessor.Dialect.COMMON_MARK).process(md, source);
            XhtmlParser p = new XhtmlParser();
            try {
                m3 = p.parse("<div>" + s2 + "</div>", "div");
            }
            catch (FHIRFormatError e) {
                throw new FHIRFormatError(e.getMessage(), e);
            }
            this.getChildNodes().addAll(m3.getChildNodes());
        }
    }

    public XhtmlNode sep(String separator) {
        if (!this.seperated) {
            this.seperated = true;
            return this;
        }
        return this.tx(separator);
    }

    public static class Location
    implements Serializable {
        private static final long serialVersionUID = -4079302502900219721L;
        private int line;
        private int column;

        public Location(int line, int column) {
            this.line = line;
            this.column = column;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }

        public String toString() {
            return "Line " + Integer.toString(this.line) + ", column " + Integer.toString(this.column);
        }
    }
}

