/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.PathEngineException;
import org.hl7.fhir.r4.context.IWorkerContext;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.ExpressionNode;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.Tuple;
import org.hl7.fhir.r4.model.TypeDetails;
import org.hl7.fhir.r4.model.ValueSet;
import org.hl7.fhir.r4.utils.FHIRPathEngine;
import org.hl7.fhir.utilities.Utilities;

public class LiquidEngine
implements FHIRPathEngine.IEvaluationContext {
    private FHIRPathEngine.IEvaluationContext externalHostServices;
    private FHIRPathEngine engine;
    private ILiquidEngineIcludeResolver includeResolver;

    public LiquidEngine(IWorkerContext context, FHIRPathEngine.IEvaluationContext hostServices) {
        this.externalHostServices = hostServices;
        this.engine = new FHIRPathEngine(context);
        this.engine.setHostServices(this);
    }

    public ILiquidEngineIcludeResolver getIncludeResolver() {
        return this.includeResolver;
    }

    public void setIncludeResolver(ILiquidEngineIcludeResolver includeResolver) {
        this.includeResolver = includeResolver;
    }

    public LiquidDocument parse(String source, String sourceName) throws FHIRException {
        return new LiquidParser(source).parse(sourceName);
    }

    public String evaluate(LiquidDocument document, Resource resource, Object appContext) throws FHIRException {
        StringBuilder b = new StringBuilder();
        LiquidEngineContext ctxt = new LiquidEngineContext(appContext);
        for (LiquidNode n : document.body) {
            n.evaluate(b, resource, ctxt);
        }
        return b.toString();
    }

    @Override
    public Base resolveConstant(Object appContext, String name, boolean beforeContext) throws PathEngineException {
        LiquidEngineContext ctxt = (LiquidEngineContext)appContext;
        if (ctxt.vars.containsKey(name)) {
            return (Base)ctxt.vars.get(name);
        }
        if (this.externalHostServices == null) {
            return null;
        }
        return this.externalHostServices.resolveConstant(ctxt.externalContext, name, beforeContext);
    }

    @Override
    public TypeDetails resolveConstantType(Object appContext, String name) throws PathEngineException {
        if (this.externalHostServices == null) {
            return null;
        }
        LiquidEngineContext ctxt = (LiquidEngineContext)appContext;
        return this.externalHostServices.resolveConstantType(ctxt.externalContext, name);
    }

    @Override
    public boolean log(String argument, List<Base> focus) {
        if (this.externalHostServices == null) {
            return false;
        }
        return this.externalHostServices.log(argument, focus);
    }

    @Override
    public FHIRPathEngine.IEvaluationContext.FunctionDetails resolveFunction(String functionName) {
        if (this.externalHostServices == null) {
            return null;
        }
        return this.externalHostServices.resolveFunction(functionName);
    }

    @Override
    public TypeDetails checkFunction(Object appContext, String functionName, List<TypeDetails> parameters) throws PathEngineException {
        if (this.externalHostServices == null) {
            return null;
        }
        LiquidEngineContext ctxt = (LiquidEngineContext)appContext;
        return this.externalHostServices.checkFunction(ctxt.externalContext, functionName, parameters);
    }

    @Override
    public List<Base> executeFunction(Object appContext, List<Base> focus, String functionName, List<List<Base>> parameters) {
        if (this.externalHostServices == null) {
            return null;
        }
        LiquidEngineContext ctxt = (LiquidEngineContext)appContext;
        return this.externalHostServices.executeFunction(ctxt.externalContext, focus, functionName, parameters);
    }

    @Override
    public Base resolveReference(Object appContext, String url) throws FHIRException {
        if (this.externalHostServices == null) {
            return null;
        }
        LiquidEngineContext ctxt = (LiquidEngineContext)appContext;
        return this.resolveReference(ctxt.externalContext, url);
    }

    @Override
    public boolean conformsToProfile(Object appContext, Base item, String url) throws FHIRException {
        if (this.externalHostServices == null) {
            return false;
        }
        LiquidEngineContext ctxt = (LiquidEngineContext)appContext;
        return this.conformsToProfile(ctxt.externalContext, item, url);
    }

    @Override
    public ValueSet resolveValueSet(Object appContext, String url) {
        LiquidEngineContext ctxt = (LiquidEngineContext)appContext;
        if (this.externalHostServices != null) {
            return this.externalHostServices.resolveValueSet(ctxt.externalContext, url);
        }
        return this.engine.getWorker().fetchResource(ValueSet.class, url);
    }

    private class LiquidParser {
        private String source;
        private int cursor;
        private String name;

        public LiquidParser(String source) {
            this.source = source;
            this.cursor = 0;
        }

        private char next1() {
            if (this.cursor >= this.source.length()) {
                return '\u0000';
            }
            return this.source.charAt(this.cursor);
        }

        private char next2() {
            if (this.cursor >= this.source.length() - 1) {
                return '\u0000';
            }
            return this.source.charAt(this.cursor + 1);
        }

        private char grab() {
            ++this.cursor;
            return this.source.charAt(this.cursor - 1);
        }

        public LiquidDocument parse(String name) throws FHIRException {
            this.name = name;
            LiquidDocument doc = new LiquidDocument();
            this.parseList(doc.body, new String[0]);
            return doc;
        }

        private String parseList(List<LiquidNode> list, String[] terminators) throws FHIRException {
            String close = null;
            while (this.cursor < this.source.length()) {
                if (this.next1() == '{' && (this.next2() == '%' || this.next2() == '{')) {
                    if (this.next2() == '%') {
                        String cnt = this.parseTag('%');
                        if (Utilities.existsInList(cnt, terminators)) {
                            close = cnt;
                            break;
                        }
                        if (cnt.startsWith("if ")) {
                            list.add(this.parseIf(cnt));
                            continue;
                        }
                        if (cnt.startsWith("loop ")) {
                            list.add(this.parseLoop(cnt.substring(4).trim()));
                            continue;
                        }
                        if (cnt.startsWith("include ")) {
                            list.add(this.parseInclude(cnt.substring(7).trim()));
                            continue;
                        }
                        throw new FHIRException("Script " + this.name + ": Script " + this.name + ": Unknown flow control statement " + cnt);
                    }
                    list.add(this.parseStatement());
                    continue;
                }
                if (list.size() == 0 || !(list.get(list.size() - 1) instanceof LiquidConstant)) {
                    list.add(new LiquidConstant());
                }
                ((LiquidConstant)list.get(list.size() - 1)).addChar(this.grab());
            }
            for (LiquidNode n : list) {
                n.closeUp();
            }
            if (terminators.length > 0 && !Utilities.existsInList(close, terminators)) {
                throw new FHIRException("Script " + this.name + ": Script " + this.name + ": Found end of script looking for " + terminators);
            }
            return close;
        }

        private LiquidNode parseIf(String cnt) throws FHIRException {
            LiquidIf res = new LiquidIf();
            res.condition = cnt.substring(3).trim();
            String term = this.parseList(res.thenBody, new String[]{"else", "endif"});
            if ("else".equals(term)) {
                term = this.parseList(res.elseBody, new String[]{"endif"});
            }
            return res;
        }

        private LiquidNode parseInclude(String cnt) throws FHIRException {
            int i;
            for (i = 1; i < cnt.length() && !Character.isWhitespace(cnt.charAt(i)); ++i) {
            }
            if (i == cnt.length() || i == 0) {
                throw new FHIRException("Script " + this.name + ": Error reading include: " + cnt);
            }
            LiquidInclude res = new LiquidInclude();
            res.page = cnt.substring(0, i);
            while (i < cnt.length() && Character.isWhitespace(cnt.charAt(i))) {
                ++i;
            }
            while (i < cnt.length()) {
                int j = i;
                while (i < cnt.length() && cnt.charAt(i) != '=') {
                    ++i;
                }
                if (i >= cnt.length() || j == i) {
                    throw new FHIRException("Script " + this.name + ": Error reading include: " + cnt);
                }
                String n = cnt.substring(j, i);
                if (res.params.containsKey(n)) {
                    throw new FHIRException("Script " + this.name + ": Error reading include: " + cnt);
                }
                FHIRPathEngine.ExpressionNodeWithOffset t = LiquidEngine.this.engine.parsePartial(cnt, ++i);
                res.params.put(n, t.getNode());
                for (i = t.getOffset(); i < cnt.length() && Character.isWhitespace(cnt.charAt(i)); ++i) {
                }
            }
            return res;
        }

        private LiquidNode parseLoop(String cnt) throws FHIRException {
            int i = 0;
            while (!Character.isWhitespace(cnt.charAt(i))) {
                ++i;
            }
            LiquidLoop res = new LiquidLoop();
            res.varName = cnt.substring(0, i);
            while (Character.isWhitespace(cnt.charAt(i))) {
                ++i;
            }
            int j = i;
            while (!Character.isWhitespace(cnt.charAt(i))) {
                ++i;
            }
            if (!"in".equals(cnt.substring(j, i))) {
                throw new FHIRException("Script " + this.name + ": Script " + this.name + ": Error reading loop: " + cnt);
            }
            res.condition = cnt.substring(i).trim();
            this.parseList(res.body, new String[]{"endloop"});
            return res;
        }

        private String parseTag(char ch) throws FHIRException {
            this.grab();
            this.grab();
            StringBuilder b = new StringBuilder();
            while (this.cursor < this.source.length() && (this.next1() != '%' || this.next2() != '}')) {
                b.append(this.grab());
            }
            if (this.next1() != '%' || this.next2() != '}') {
                throw new FHIRException("Script " + this.name + ": Unterminated Liquid statement {% " + b.toString());
            }
            this.grab();
            this.grab();
            return b.toString().trim();
        }

        private LiquidStatement parseStatement() throws FHIRException {
            this.grab();
            this.grab();
            StringBuilder b = new StringBuilder();
            while (this.cursor < this.source.length() && (this.next1() != '}' || this.next2() != '}')) {
                b.append(this.grab());
            }
            if (this.next1() != '}' || this.next2() != '}') {
                throw new FHIRException("Script " + this.name + ": Unterminated Liquid statement {{ " + b.toString());
            }
            this.grab();
            this.grab();
            LiquidStatement res = new LiquidStatement();
            res.statement = b.toString().trim();
            return res;
        }
    }

    public static class LiquidDocument {
        private List<LiquidNode> body = new ArrayList<LiquidNode>();
    }

    private class LiquidInclude
    extends LiquidNode {
        private String page;
        private Map<String, ExpressionNode> params;

        private LiquidInclude() {
            this.params = new HashMap<String, ExpressionNode>();
        }

        @Override
        public void evaluate(StringBuilder b, Resource resource, LiquidEngineContext ctxt) throws FHIRException {
            String src = LiquidEngine.this.includeResolver.fetchInclude(LiquidEngine.this, this.page);
            LiquidParser parser = new LiquidParser(src);
            LiquidDocument doc = parser.parse(this.page);
            LiquidEngineContext nctxt = new LiquidEngineContext(ctxt.externalContext);
            Tuple incl = new Tuple();
            nctxt.vars.put("include", incl);
            for (String s2 : this.params.keySet()) {
                incl.addProperty(s2, LiquidEngine.this.engine.evaluate((Object)ctxt, resource, resource, (Base)resource, this.params.get(s2)));
            }
            for (LiquidNode n : doc.body) {
                n.evaluate(b, resource, nctxt);
            }
        }
    }

    private class LiquidLoop
    extends LiquidNode {
        private String varName;
        private String condition;
        private ExpressionNode compiled;
        private List<LiquidNode> body;

        private LiquidLoop() {
            this.body = new ArrayList<LiquidNode>();
        }

        @Override
        public void evaluate(StringBuilder b, Resource resource, LiquidEngineContext ctxt) throws FHIRException {
            if (this.compiled == null) {
                this.compiled = LiquidEngine.this.engine.parse(this.condition);
            }
            List<Base> list = LiquidEngine.this.engine.evaluate((Object)ctxt, resource, resource, (Base)resource, this.compiled);
            LiquidEngineContext lctxt = new LiquidEngineContext(ctxt);
            for (Base o : list) {
                lctxt.vars.put(this.varName, o);
                for (LiquidNode n : this.body) {
                    n.evaluate(b, resource, lctxt);
                }
            }
        }
    }

    private class LiquidIf
    extends LiquidNode {
        private String condition;
        private ExpressionNode compiled;
        private List<LiquidNode> thenBody;
        private List<LiquidNode> elseBody;

        private LiquidIf() {
            this.thenBody = new ArrayList<LiquidNode>();
            this.elseBody = new ArrayList<LiquidNode>();
        }

        @Override
        public void evaluate(StringBuilder b, Resource resource, LiquidEngineContext ctxt) throws FHIRException {
            boolean ok;
            if (this.compiled == null) {
                this.compiled = LiquidEngine.this.engine.parse(this.condition);
            }
            List<LiquidNode> list = (ok = LiquidEngine.this.engine.evaluateToBoolean((Object)ctxt, resource, resource, (Base)resource, this.compiled)) ? this.thenBody : this.elseBody;
            for (LiquidNode n : list) {
                n.evaluate(b, resource, ctxt);
            }
        }
    }

    private class LiquidStatement
    extends LiquidNode {
        private String statement;
        private ExpressionNode compiled;

        private LiquidStatement() {
        }

        @Override
        public void evaluate(StringBuilder b, Resource resource, LiquidEngineContext ctxt) throws FHIRException {
            if (this.compiled == null) {
                this.compiled = LiquidEngine.this.engine.parse(this.statement);
            }
            b.append(LiquidEngine.this.engine.evaluateToString(ctxt, resource, resource, resource, this.compiled));
        }
    }

    private class LiquidConstant
    extends LiquidNode {
        private String constant;
        private StringBuilder b;

        private LiquidConstant() {
            this.b = new StringBuilder();
        }

        @Override
        protected void closeUp() {
            this.constant = this.b.toString();
            this.b = null;
        }

        public void addChar(char ch) {
            this.b.append(ch);
        }

        @Override
        public void evaluate(StringBuilder b, Resource resource, LiquidEngineContext ctxt) {
            b.append(this.constant);
        }
    }

    private abstract class LiquidNode {
        private LiquidNode() {
        }

        protected void closeUp() {
        }

        public abstract void evaluate(StringBuilder var1, Resource var2, LiquidEngineContext var3) throws FHIRException;
    }

    private class LiquidEngineContext {
        private Object externalContext;
        private Map<String, Base> vars = new HashMap<String, Base>();

        public LiquidEngineContext(Object externalContext) {
            this.externalContext = externalContext;
        }

        public LiquidEngineContext(LiquidEngineContext existing) {
            this.externalContext = existing.externalContext;
            this.vars.putAll(existing.vars);
        }
    }

    public static interface ILiquidEngineIcludeResolver {
        public String fetchInclude(LiquidEngine var1, String var2);
    }
}

