/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.ConsentCategory;

public class ConsentCategoryEnumFactory
implements EnumFactory<ConsentCategory> {
    @Override
    public ConsentCategory fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("acd".equals(codeString)) {
            return ConsentCategory.ACD;
        }
        if ("dnr".equals(codeString)) {
            return ConsentCategory.DNR;
        }
        if ("emrgonly".equals(codeString)) {
            return ConsentCategory.EMRGONLY;
        }
        if ("hcd".equals(codeString)) {
            return ConsentCategory.HCD;
        }
        if ("npp".equals(codeString)) {
            return ConsentCategory.NPP;
        }
        if ("polst".equals(codeString)) {
            return ConsentCategory.POLST;
        }
        if ("research".equals(codeString)) {
            return ConsentCategory.RESEARCH;
        }
        if ("rsdid".equals(codeString)) {
            return ConsentCategory.RSDID;
        }
        if ("rsreid".equals(codeString)) {
            return ConsentCategory.RSREID;
        }
        throw new IllegalArgumentException("Unknown ConsentCategory code '" + codeString + "'");
    }

    @Override
    public String toCode(ConsentCategory code) {
        if (code == ConsentCategory.ACD) {
            return "acd";
        }
        if (code == ConsentCategory.DNR) {
            return "dnr";
        }
        if (code == ConsentCategory.EMRGONLY) {
            return "emrgonly";
        }
        if (code == ConsentCategory.HCD) {
            return "hcd";
        }
        if (code == ConsentCategory.NPP) {
            return "npp";
        }
        if (code == ConsentCategory.POLST) {
            return "polst";
        }
        if (code == ConsentCategory.RESEARCH) {
            return "research";
        }
        if (code == ConsentCategory.RSDID) {
            return "rsdid";
        }
        if (code == ConsentCategory.RSREID) {
            return "rsreid";
        }
        return "?";
    }

    @Override
    public String toSystem(ConsentCategory code) {
        return code.getSystem();
    }
}

