/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.i18n.Msg;
import java.lang.ref.SoftReference;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public final class DateUtils {
    public static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    public static final String PATTERN_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final String PATTERN_RFC1036 = "EEE, dd-MMM-yy HH:mm:ss zzz";
    public static final String PATTERN_ASCTIME = "EEE MMM d HH:mm:ss yyyy";
    private static final String PATTERN_INTEGER_DATE = "yyyyMMdd";
    private static final String[] DEFAULT_PATTERNS = new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz", "EEE, dd-MMM-yy HH:mm:ss zzz", "EEE MMM d HH:mm:ss yyyy"};
    private static final Date DEFAULT_TWO_DIGIT_YEAR_START;

    private DateUtils() {
    }

    public static Date parseDate(String theDateValue) {
        DateUtils.notNull(theDateValue, "Date value");
        String v = theDateValue;
        if (v.length() > 1 && v.startsWith("'") && v.endsWith("'")) {
            v = v.substring(1, v.length() - 1);
        }
        for (String dateFormat : DEFAULT_PATTERNS) {
            SimpleDateFormat dateParser = DateFormatHolder.formatFor(dateFormat);
            dateParser.set2DigitYearStart(DEFAULT_TWO_DIGIT_YEAR_START);
            ParsePosition pos = new ParsePosition(0);
            Date result = dateParser.parse(v, pos);
            if (pos.getIndex() == 0) continue;
            return result;
        }
        return null;
    }

    public static Date getHighestInstantFromDate(Date theDateValue) {
        Calendar sourceCal = Calendar.getInstance();
        sourceCal.setTime(theDateValue);
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT-12:00"));
        DateUtils.copyDateAndTrundateTime(sourceCal, cal);
        return cal.getTime();
    }

    public static Date getLowestInstantFromDate(Date theDateValue) {
        Calendar sourceCal = Calendar.getInstance();
        sourceCal.setTime(theDateValue);
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT+14:00"));
        DateUtils.copyDateAndTrundateTime(sourceCal, cal);
        return cal.getTime();
    }

    private static void copyDateAndTrundateTime(Calendar theSourceCal, Calendar theCal) {
        theCal.set(1, theSourceCal.get(1));
        theCal.set(2, theSourceCal.get(2));
        theCal.set(5, theSourceCal.get(5));
        theCal.set(11, 0);
        theCal.set(12, 0);
        theCal.set(13, 0);
        theCal.set(14, 0);
    }

    public static int convertDateToDayInteger(Date theDateValue) {
        DateUtils.notNull(theDateValue, "Date value");
        SimpleDateFormat format = new SimpleDateFormat(PATTERN_INTEGER_DATE);
        String theDateString = format.format(theDateValue);
        return Integer.parseInt(theDateString);
    }

    public static String convertDateToIso8601String(Date theDateValue) {
        DateUtils.notNull(theDateValue, "Date value");
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        return format.format(theDateValue);
    }

    public static String formatDate(Date date) {
        DateUtils.notNull(date, "Date");
        DateUtils.notNull(PATTERN_RFC1123, "Pattern");
        SimpleDateFormat formatter = DateFormatHolder.formatFor(PATTERN_RFC1123);
        return formatter.format(date);
    }

    public static <T> T notNull(T argument, String name) {
        if (argument == null) {
            throw new IllegalArgumentException(Msg.code(1783) + name + " may not be null");
        }
        return argument;
    }

    public static Pair<String, String> getCompletedDate(String theIncompleteDateStr) {
        if (StringUtils.isBlank(theIncompleteDateStr)) {
            return new ImmutablePair<Object, Object>(null, null);
        }
        if (theIncompleteDateStr.length() == 4) {
            String lbStr = theIncompleteDateStr + "-01-01";
            String upStr = theIncompleteDateStr + "-12-31";
            return new ImmutablePair<String, String>(lbStr, upStr);
        }
        if (theIncompleteDateStr.length() != 7) {
            return new ImmutablePair<String, String>(theIncompleteDateStr, theIncompleteDateStr);
        }
        Date lb = null;
        try {
            lb = new SimpleDateFormat("yyyy-MM-dd").parse(theIncompleteDateStr + "-01");
        }
        catch (ParseException e) {
            return new ImmutablePair<String, String>(theIncompleteDateStr, theIncompleteDateStr);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(lb);
        calendar.add(2, 1);
        calendar.set(5, 1);
        calendar.add(5, -1);
        Date ub = calendar.getTime();
        String lbStr = new SimpleDateFormat("yyyy-MM-dd").format(lb);
        String upStr = new SimpleDateFormat("yyyy-MM-dd").format(ub);
        return new ImmutablePair<String, String>(lbStr, upStr);
    }

    public static Date getEndOfDay(Date theDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(theDate);
        cal.set(11, cal.getMaximum(11));
        cal.set(12, cal.getMaximum(12));
        cal.set(13, cal.getMaximum(13));
        cal.set(14, cal.getMaximum(14));
        return cal.getTime();
    }

    static {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(GMT);
        calendar.set(2000, 0, 1, 0, 0, 0);
        calendar.set(14, 0);
        DEFAULT_TWO_DIGIT_YEAR_START = calendar.getTime();
    }

    static final class DateFormatHolder {
        private static final ThreadLocal<SoftReference<Map<String, SimpleDateFormat>>> THREADLOCAL_FORMATS = ThreadLocal.withInitial(() -> new SoftReference(new HashMap()));

        DateFormatHolder() {
        }

        static SimpleDateFormat formatFor(String pattern) {
            SimpleDateFormat format;
            SoftReference<Map<String, SimpleDateFormat>> ref = THREADLOCAL_FORMATS.get();
            Map<String, SimpleDateFormat> formats = ref.get();
            if (formats == null) {
                formats = new HashMap<String, SimpleDateFormat>();
                THREADLOCAL_FORMATS.set(new SoftReference<Map<String, SimpleDateFormat>>(formats));
            }
            if ((format = formats.get(pattern)) == null) {
                format = new SimpleDateFormat(pattern, Locale.US);
                format.setTimeZone(TimeZone.getTimeZone("GMT"));
                formats.put(pattern, format);
            }
            return format;
        }
    }
}

