/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.api.definitions;

import ca.uhn.fhir.context.FhirVersionEnum;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;

public abstract class FhirConversionSupport
implements Serializable {
    private static final long serialVersionUID = -108611742759595166L;
    private static final String R4_SUPPORT_CLASS = "au.csiro.pathling.api.definitions.R4FhirConversionSupport";
    private static final Map<FhirVersionEnum, FhirConversionSupport> FHIR_SUPPORT = new HashMap<FhirVersionEnum, FhirConversionSupport>();

    public abstract String fhirType(IBase var1);

    public abstract List<IBaseResource> extractEntryFromBundle(IBaseBundle var1, String var2);

    public abstract IBaseBundle wrapInBundle(IBaseResource ... var1);

    private static FhirConversionSupport newInstance(FhirVersionEnum fhirVersion) {
        Class<?> fhirSupportClass;
        if (FhirVersionEnum.R4.equals((Object)fhirVersion)) {
            try {
                fhirSupportClass = Class.forName(R4_SUPPORT_CLASS);
            }
            catch (ClassNotFoundException exception) {
                throw new IllegalStateException(exception);
            }
        } else {
            throw new IllegalArgumentException("Unsupported FHIR version: " + fhirVersion);
        }
        try {
            return (FhirConversionSupport)fhirSupportClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Unable to create FHIR support class", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FhirConversionSupport supportFor(FhirVersionEnum fhirVersion) {
        Map<FhirVersionEnum, FhirConversionSupport> map = FHIR_SUPPORT;
        synchronized (map) {
            FhirConversionSupport support = FHIR_SUPPORT.get((Object)fhirVersion);
            if (support == null) {
                support = FhirConversionSupport.newInstance(fhirVersion);
                FHIR_SUPPORT.put(fhirVersion, support);
            }
            return support;
        }
    }

    public static FhirConversionSupport forStu3() {
        return FhirConversionSupport.supportFor(FhirVersionEnum.DSTU3);
    }
}

