from typing import Any, Dict, List, Type, TypeVar

import attr

T = TypeVar("T", bound="TxStagesResponseSwapFinalised")


@attr.s(auto_attribs=True)
class TxStagesResponseSwapFinalised:
    """
    Attributes:
        completed (bool): returns true if an inbound transaction's swap (successful or refunded) is no longer pending
    """

    completed: bool
    additional_properties: Dict[str, Any] = attr.ib(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        completed = self.completed

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "completed": completed,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        completed = d.pop("completed")

        tx_stages_response_swap_finalised = cls(
            completed=completed,
        )

        tx_stages_response_swap_finalised.additional_properties = d
        return tx_stages_response_swap_finalised

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
