from typing import Any, Dict, List, Type, TypeVar, Union, cast

import attr

from ..types import UNSET, Unset

T = TypeVar("T", bound="InvariantsResponse")


@attr.s(auto_attribs=True)
class InvariantsResponse:
    """
    Attributes:
        invariants (Union[Unset, List[str]]):
    """

    invariants: Union[Unset, List[str]] = UNSET
    additional_properties: Dict[str, Any] = attr.ib(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        invariants: Union[Unset, List[str]] = UNSET
        if not isinstance(self.invariants, Unset):
            invariants = self.invariants

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if invariants is not UNSET:
            field_dict["invariants"] = invariants

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        invariants = cast(List[str], d.pop("invariants", UNSET))

        invariants_response = cls(
            invariants=invariants,
        )

        invariants_response.additional_properties = d
        return invariants_response

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
