"""Parsing configuration for SDMX-ML 2.1 messages."""

# Common
HEADER = "Header"
DATASET = "DataSet"
SERIES = "Series"
OBS = "Obs"
AGENCY_ID = "agencyID"
ID = "id"
VERSION = "version"
REQUIRED = "required"
POSITION = "position"
CLASS = "class"
PACKAGE = "package"
LINK = "Link"

# Structure Specific
STR_SPE = "StructureSpecificData"
GENERIC = "GenericData"
SERIES_KEY = "SeriesKey"
GROUP_KEY = "GroupKey"
ATTRIBUTES = "Attributes"
VALUE = "Value"
OBS_DIM = "ObsDimension"
OBS_VALUE_XML_TAG = "ObsValue"
OBS_VALUE_ID = "OBS_VALUE"
OBS_KEY = "ObsKey"
SIBLING_TYPE = "SiblingType"
# Header
STR_REF = "structureRef"
STRUCTURE = "Structure"
STR_USAGE = "StructureUsage"
PROV_AGREMENT = "ProvisionAgrement"
PROV_AGREEMENT = "ProvisionAgreement"
STR_ID = "structureID"
STR_TYPE = "structure_type"
DIM_OBS = "dimensionAtObservation"
ALL_DIM = "AllDimensions"
REF = "Ref"
DATASET_ID = "DataSetID"
DATASET_ACTION = "DataSetAction"
TEST = "Test"
PREPARED = "Prepared"
SENDER = "Sender"
RECEIVER = "Receiver"
SOURCE = "Source"
HEADER_ID = "ID"
NAMESPACE = "namespace"
NAMES = "names"
REGISTRY_LOW = "registry"


# SDMX Error handling
ERROR = "Error"
ERROR_MESSAGE = "ErrorMessage"
ERROR_CODE = "code"
ERROR_TEXT = "Text"

# SDMX Registry Interface handling
REG_INTERFACE = "RegistryInterface"
SUBMIT_STRUCTURE_RESPONSE = "SubmitStructureResponse"
SUBMISSION_RESULT = "SubmissionResult"
SUBMITTED_STRUCTURE = "SubmittedStructure"
MAINTAINABLE_OBJECT = "MaintainableObject"
ACTION = "action"
STATUS_MSG = "StatusMessage"
STATUS = "status"

# Structures
# Common
NAME = "Name"
NAME_LOW = "name"
DESC = "Description"
DESC_LOW = "description"
LANG = "lang"
XML_TEXT = "#text"
STR_URL = "structureURL"
STR_URL_LOW = "structure_url"
SER_URL = "serviceURL"
SER_URL_LOW = "service_url"
ALIAS_LOW = "alias"

# General
ANNOTATIONS = "Annotations"
ANNOTATIONS_LOW = "annotations"
STRUCTURES = "Structures"
ORGS = "OrganisationSchemes"
AGENCIES = "AgencySchemes"
AGENCY_SCHEME = "AgencyScheme"
CODELISTS = "Codelists"
CONCEPTS = "Concepts"
CON_SCHEMES = "ConceptSchemes"
DSDS = "DataStructures"
DATAFLOWS = "Dataflows"
CONSTRAINTS = "Constraints"

# Individual
AGENCY = "Agency"
CL = "Codelist"
CL_LOW = "codelist"
CODE = "Code"
CODES = "Codes"
CODES_LOW = "codes"
CS = "ConceptScheme"
CS_LOW = "concept_scheme"
CON = "Concept"
CON_LOW = "concept"
DSD = "DataStructure"
DSD_LOW = "datastructure"

# DSD components
DSD_COMPS = "DataStructureComponents"
CON_ID = "ConceptIdentity"
CON_ID_LOW = "concept_identity"
CON_ROLE = "ConceptRole"
CON_ROLE_LOW = "concept_role"
# Dimension
DIM_LIST = "DimensionList"
DIM_LIST_LOW = "dimension_list"
DIM = "Dimension"
TIME_DIM = "TimeDimension"
# Attribute
ATT_LIST = "AttributeList"
ATT_LIST_LOW = "attribute_list"
ATT = "Attribute"
ATT_LVL = "attachment_level"
ATT_REL_LOW = "attribute_relationship"
ATT_REL = "AttributeRelationship"
AS_STATUS = "assignmentStatus"
USAGE = "usage"
MANDATORY = "Mandatory"
MANDATORY_LOW = "mandatory"
CONDITIONAL = "Conditional"
OPTIONAL_LOW = "optional"
ME_REL = "MeasureRelationship"
OBSERVATION = "Observation"
# Measure
ME_LIST = "MeasureList"
ME_LIST_LOW = "measure_list"
MSR = "Measure"
MEASURE = "PrimaryMeasure"
MEASURE_RELATIONSHIP = "MeasureRelationship"
# Group Dimension
GROUP = "Group"
GROUP_LOW = "group"
GROUPS_LOW = "groups"
GROUP_DIM_LOW = "group_dimension_descriptor"
GROUP_DIM = "GroupDimension"
ATTACH_GROUP = "AttachmentGroup"
DIM_REF = "DimensionReference"

# Constraints
CON_CONS = "ContentConstraint"
CONS_ATT = "ConstraintAttachment"
CUBE_REGION = "CubeRegion"
CONTENT_REGION = "dataContentRegion"
KEY = "Key"
KEY_VALUE = "KeyValue"
DATA_KEY_SET = "DataKeySet"
DATA_KEY_SET_LOW = "dataKeySet"
INCLUDED = "isIncluded"
INCLUDE = "include"

# Annotation
ANNOTATION = "Annotation"
ANNOTATION_TITLE = "AnnotationTitle"
ANNOTATION_TYPE = "AnnotationType"
ANNOTATION_TEXT = "AnnotationText"
ANNOTATION_URL = "AnnotationURL"

TITLE = "title"
TYPE_ = "type_"
TYPE = "type"
TEXT = "text"
URL = "url"
URN = "URN"
URN_LOW = "urn"

# Representation
CORE_REP = "CoreRepresentation"
CORE_REP_LOW = "core_representation"
DTYPE = "dtype"
LOCAL_DTYPE = "local_dtype"
LOCAL_REP = "LocalRepresentation"
LOCAL_REP_LOW = "local_representation"
LOCAL_CODES = "LocalCodes"
LOCAL_CODES_LOW = "local_codes"
LOCAL_FACETS = "LocalFacets"
LOCAL_FACETS_LOW = "local_facets"
ENUM = "Enumeration"
ENUM_FORMAT = "EnumerationFormat"
TEXT_FORMAT = "TextFormat"

# Facets
FACETS = "facets"
TEXT_TYPE = "textType"
TEXT_TYPE_LOW = "text_type"

# Contact
CONTACT = "Contact"
CONTACTS_LOW = "contacts"
DEPARTMENT = "Department"
ROLE = "Role"
URI = "URI"
URI_LOW = "uri"
EMAIL = "Email"
X400 = "X400"
TELEPHONE = "Telephone"
FAX = "Fax"

# Extras
MAINTAINER = "maintainer"
XMLNS = "xmlns"
COMPS = "components"
PARENT = "Parent"
PAR_ID = "maintainableParentID"
PAR_VER = "maintainableParentVersion"
REL_TO = "relatedTo"
NO_REL = "NoSpecifiedRelationship"
METADATA = "Metadata"

# To exclude from attached_attributes
EXCLUDED_ATTRIBUTES = [
    STR_REF,
    "action",
    "dataScope",
    "xsi:type",
    SERIES,
    OBS,
    GROUP,
]

# Content types
DATASTRUCTURES_CM = "DataStructures"
DATAFLOWS_CM = "Dataflows"
CODELISTS_CM = "Codelists"
CONCEPTS_CM = "Concepts"
ORGANISATIONSCHEMES_CM = "OrganisationSchemes"

VALID_FROM = "validFrom"
VALID_FROM_LOW = "valid_from"
VALID_TO = "validTo"
VALID_TO_LOW = "valid_to"

# Structures
IS_EXTERNAL_REF = "isExternalReference"
IS_EXTERNAL_REF_LOW = "is_external_reference"
IS_FINAL = "isFinal"
IS_FINAL_LOW = "is_final"
IS_PARTIAL = "isPartial"
IS_PARTIAL_LOW = "is_partial"

# Contact
URIS = "uris"
EMAILS = "emails"
TELEPHONES = "telephones"
FAXES = "faxes"

# Structure types
CLS = "Codelists"
DFW = "Dataflow"
DFW_LOW = "dataflow"
DFWS = "Dataflows"
DFWS_LOW = "dataflows"
RULESETS = "Rulesets"
RULE_SCHEME = "RulesetScheme"
RULE_SCHEMES = "RulesetSchemes"
RULE = "Ruleset"
UDOS = "UserDefinedOperators"
UDO_SCHEME = "UserDefinedOperatorScheme"
UDO_SCHEMES = "UserDefinedOperatorSchemes"
UDO = "UserDefinedOperator"
TRANSFORMATIONS = "Transformations"
TRANS_SCHEME = "TransformationScheme"
TRANS_SCHEMES = "TransformationSchemes"
TRANSFORMATION = "Transformation"
VTLMAPPINGS = "VtlMappings"
VTLMAPPING_SCHEMES = "VtlMappingSchemes"
VTLMAPPING = "VtlMapping"
VTL_DFW_MAPP = "VtlDataflowMapping"
VTL_CL_MAPP = "VtlCodelistMapping"
VTL_CON_MAPP = "VtlConceptMapping"
VTL_MAPPING_SCHEME = "VtlMappingScheme"
DFW_ALIAS_LOW = "dataflow_alias"
NAME_PER_SCHEME = "NamePersonalisationScheme"
NAME_PER_SCHEMES = "NamePersonalisationSchemes"
NAME_PER = "NamePersonalisation"
NAME_PERS = "NamePersonalisations"
CUSTOM_TYPE_SCHEME = "CustomTypeScheme"
CUSTOM_TYPE_SCHEMES = "CustomTypeSchemes"
CUSTOM_TYPE = "CustomType"
CUSTOM_TYPES = "CustomTypes"
VALUE_LISTS = "ValueLists"
VALUE_LIST = "ValueList"
VALUE_LIST_LOW = "valuelist"
VALUE_ITEM = "ValueItem"
