# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['keepasxcli_wrapper']

package_data = \
{'': ['*']}

install_requires = \
['click>=7.1.2,<8.0.0', 'pexpect>=4.8.0,<5.0.0']

entry_points = \
{'console_scripts': ['kpowg = keepasxcli_wrapper.client:attr',
                     'kpowr = keepasxcli_wrapper.client:raw']}

setup_kwargs = {
    'name': 'keepasxcli-wrapper',
    'version': '0.1.5',
    'description': 'Wrapper arround keepassxc-cli open command.',
    'long_description': '# Keepassxc-cli WRAPPER\n\nCreate a wrapper around **keepassxc-cli open** command and keep it open without need of keep the terminal open. \nIt allows you to access any password (or other attributes) from database in **terminal** or **scripts** without \nneed of providing the password to the database again.\n\n## install\nI strongly recommend use of **pipx** to install keepassxc-cli.\n```shell\npipx install keepassxcli-wrapper\n```\nEventually you can install it by yourself in global \n```shell\npip install keepassxcli-wrapper\n```\nor better in some virtualenv, for example like this:\n```shell\npython -m venv ~/.keepassxcli-wrapper\n.keepassxcli-wrapper/bin/pip install .keepassxcli-wrapper\necho "alias kpowg=~/.keepassxcli-wrapper/bin/kpowg" >> .bashrc\necho "alias kpowr=~/.keepassxcli-wrapper/bin/kpowr" >> .bashrc\n```\n\n## How it works\nWhen you ask for a password for some entry in keepassxc db and the db is not open yet, you will be prompted for \nthe keepassxc database password. It will start a server in a background with opened **keepassxcli open** session.\nIf you ask for some entry\'s password again, you get the password from the existing server. The connection with the server\nis maintained with a file sockets. This limits usage for linux and OSX. **One socket file can have only one \ndatabase**.\n\n```bash\n# server is not running\n> ps -x | grep keepasxcli_wrapper/server.py | grep -v grep | wc -l \n  0\n# first time usage trigger prompt for database file and password\n> kpowr ls\nOpen database: path/to/db.kdbx\nPassword:\ngmail\nfacebook\n# server is running now in background\n> ps -x | grep keepasxcli_wrapper/server.py | grep -v grep | wc -l \n  1\n# no password is required\n> kpowr ls\ngmail\nfacebook\n> kpowg facebook\npassword for entry facebook has been clipped\n# quiting server\n> kpowr quit\n> ps -x | grep keepasxcli_wrapper/server.py | grep -v grep | wc -l \n  0\n# open db again\n> kpowr ls\nOpen database:\n```\n\n## Examples\nThere are two scripts. Both can open db. **kpowg** *(KeePassxc Open Wrapper Get)* is for accessing entry\'s attributes. \n**kpowr** *(KeePassxc Open Run) is for run command on original **keepassc-cli open** session.\n### kpowg\nEither **clip** or **print** the **attributes** for the entries. \n\nclip the **password** for gmail in the db (gmail is the title of entry)\n```shell\n> kpowg gmail\npassword for entry facebook has been clipped\n```\nclip the **username** for gmail\n```shell\n> kpowg gmail username\nusername for entry entry1 has been clipped\n```\n**(-s/--show)** print the **username** (it is printed without new line at the end)\n```shell\n> kpowg --show gmail username\nxyz@gmail.com\n```\nA partial name let you choose between all the matches.\n```shell\n> kpowg mail\n[1] gmail\n[2] yahoo e-mail\n\nChoose entry 1 - 2 (default 1): 2\npassword for entry yahoo email has been clipped\n```\nUse **(-np/--no-prompt)** in script to prevent from prompt. If the db is not open it will fail, but it will not\nblock the rest of script.\n``` \n#! /bin/sh\nGMAILPASSWORD="$(kpowg -np -s gmail)"\n```\n**(-wfp/--window-for-password)** will create dialog window for password input. Use for scripts running in \nbackground. Use in the pair with -np in case of wrong db path configuration.\n``` \n#! /bin/sh\nGMAILPASSWORD="$(kpowg --wfp -np -s gmail)"\n```\n### kpowr\nThis just pass commands to **keepassxcli-cli**.\n\n#### !!! WARNING\n**kpowr add --password-prompt** and **kpowr edit --password-prompt** is not yet supported.\n\n#### help\n```shell\n# show help for kpowr\n> kpowr --help\n# show help for keepassxc-cli\n> kpowr help\n# show help for keepassxc-cli add entry\n> kpowr help add\n```\n\n#### some useful commands\n```shell\n# add entry gmail-for-work with usernam work@gmail.com and autogenerated password\n> kpowr add -g -u work@gmail.com gmail-for-work\n# change url for previous password\n> kpowr edit --url https://gmail.com gmail-for-work\n# move entry to Recycle Bin\n> kpowr rm gmail-for-work\n```\n\n## Configuration\nYou are always prompt for db path. You can tell **kpowr** or **kpowg** where the database file exists\nvia **configuration file** or **ENVIRONMENT VARIABLES**.\n\n### Simple one database only usage\nInsert in .bashrc\n```shell\nexport KEEPASSXCCLI2_NONAME_DB=/path/to/db.kdbx\n```\n\n### Multiple databases\nMultiple databases require multiple entries in config file (or env).\n#### File config\nConfig file can be passed with **(-cf/--config-file)**. ie: ```kpowg -cf path/to/mycfg.ini gmail```. Also looking in \nthese files:\n- ~/.keepassxccli2.ini\n- ~/.config/.keepassxccli2.ini\nResult is merged from all founded files, but passed file has priority in case of conflict.\n```ini\n# default database (if you do not specify (-n/--name) in kpowg/kpowr command\n[noname] \ndb = /my/persona/db.kdbx\n# for noname db is setup default file for socket\n\n# other custom db must contain pid_file for socket communication between kpowg/kpowr and server\n[work]\n# db is optional, but you will be prompted each time\npid_file = /tmp/work_keepassxc\n\n[work2]\ndb = /path/to/work2.kdbx\npid_file = /tmp/work2_keepassxc\n\n[work3]\ndb = /path/to/work3.kdbx\npid_file = /tmp/work3_keepassxc\n# path to key file\nkey_file = /path/to/keyfile\n# yubikey slot[:serial]\nyubikey = 1:7370001\n# for bigger databases could be default (0.3) timeout not enough to read all entries (in seconds)\ntimeout = 0.5\n```\n#### ENV\nSame config can be achieved with setting ENV. In case of conflict (ENV and config is set for same name) \nthe **ENV** has priority. So you can use ENV for override config. Format is **KEEPASSXCCLI2_{{NAME}}_{{ATTR}}**.\n```shell\nexport KEEPASSXCCLI2_NONAME_DB=/my/persona/db.kdbx\n\nexport KEEPASSXCCLI2_WORK_PID_FILE=/tmp/work_keepassxc\n\nexport KEEPASSXCCLI2_WORK2_DB=/path/to/work2.kdbx\nexport KEEPASSXCCLI2_WORK2_PID_FILE=/tmp/work2_keepassxc\n\nexport KEEPASSXCCLI2_WORK3_DB=/path/to/work3.kdbx\nexport KEEPASSXCCLI2_WORK3_PID_FILE=/tmp/work3_keepassxc\nexport KEEPASSXCCLI2_WORK3_KEY_FILE=/path/to/keyfile\nexport KEEPASSXCCLI2_WORK3_YUBIKEY=1:7370001\nexport KEEPASSXCCLI2_WORK3_TIMEOUT=0.5\n```\n\n#### Example:\n\n```shell\n>kpowg facebook\n# open /my/persona/db.kdbx from config\nPassword:\npassword for facebook has been clipped\n\n>kpowg -n work2 gmail\n# open /path/to/work.kdbx from config\nPassword:\npassword for entry gmail has been clipped\n```\n\n',
    'author': 'Daniel Barton',
    'author_email': 'daniel.barton@seznam.cz',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/dburton90/keepasssxcli-wrapper',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
