# coding: utf-8

"""
    NCBI Datasets API

    NCBI service to query and download biological sequence data across all domains of life from NCBI databases.  # noqa: E501

    The version of the OpenAPI document: v1alpha
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ncbi.datasets.api_client import ApiClient
from ncbi.datasets.exceptions import (
    ApiTypeError,
    ApiValueError
)


class VirusDownloadApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_sars2_protein_dataset(self, proteins, **kwargs):  # noqa: E501
        """Retrieve SARS-CoV-2 genome datasets by protein name  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sars2_protein_dataset(proteins, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[str] proteins: Which proteins to retrieve in the data package (required)
        :param bool refseq_only: The source database is RefSeq.
        :param bool annotated_only: Only those assemblies with annotation as asserted by Virus.
        :param datetime released_since: Date since which to limit the request, to only retrieve newer assemblies.
        :param str host: Assemblies that were taken from this host (tax-id or name) or its taxonomic descendents.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_sars2_protein_dataset_with_http_info(proteins, **kwargs)  # noqa: E501

    def get_sars2_protein_dataset_with_http_info(self, proteins, **kwargs):  # noqa: E501
        """Retrieve SARS-CoV-2 genome datasets by protein name  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sars2_protein_dataset_with_http_info(proteins, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[str] proteins: Which proteins to retrieve in the data package (required)
        :param bool refseq_only: The source database is RefSeq.
        :param bool annotated_only: Only those assemblies with annotation as asserted by Virus.
        :param datetime released_since: Date since which to limit the request, to only retrieve newer assemblies.
        :param str host: Assemblies that were taken from this host (tax-id or name) or its taxonomic descendents.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['proteins', 'refseq_only', 'annotated_only', 'released_since', 'host']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sars2_protein_dataset" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'proteins' is set
        if self.api_client.client_side_validation and ('proteins' not in local_var_params or  # noqa: E501
                                                        local_var_params['proteins'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `proteins` when calling `get_sars2_protein_dataset`")  # noqa: E501

        if self.api_client.client_side_validation and ('proteins' in local_var_params and  # noqa: E501
                                                        len(local_var_params['proteins']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `proteins` when calling `get_sars2_protein_dataset`, number of items must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'proteins' in local_var_params:
            path_params['proteins'] = local_var_params['proteins']  # noqa: E501
            collection_formats['proteins'] = 'csv'  # noqa: E501

        query_params = []
        if 'refseq_only' in local_var_params and local_var_params['refseq_only'] is not None:  # noqa: E501
            query_params.append(('refseq_only', local_var_params['refseq_only']))  # noqa: E501
        if 'annotated_only' in local_var_params and local_var_params['annotated_only'] is not None:  # noqa: E501
            query_params.append(('annotated_only', local_var_params['annotated_only']))  # noqa: E501
        if 'released_since' in local_var_params and local_var_params['released_since'] is not None:  # noqa: E501
            query_params.append(('released_since', local_var_params['released_since']))  # noqa: E501
        if 'host' in local_var_params and local_var_params['host'] is not None:  # noqa: E501
            query_params.append(('host', local_var_params['host']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/zip'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/download/virus/sars2/protein/{proteins}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_virus_dataset_sars_stream(self, **kwargs):  # noqa: E501
        """Retrieve SARS-CoV-2 genome datasets  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_virus_dataset_sars_stream(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param bool refseq_only: The source database is RefSeq.
        :param bool annotated_only: Only those assemblies with annotation as asserted by Virus.
        :param datetime released_since: Date since which to limit the request, to only retrieve newer assemblies.
        :param str host: Assemblies that were taken from this host (tax-id or name) or its taxonomic descendents.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_virus_dataset_sars_stream_with_http_info(**kwargs)  # noqa: E501

    def get_virus_dataset_sars_stream_with_http_info(self, **kwargs):  # noqa: E501
        """Retrieve SARS-CoV-2 genome datasets  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_virus_dataset_sars_stream_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param bool refseq_only: The source database is RefSeq.
        :param bool annotated_only: Only those assemblies with annotation as asserted by Virus.
        :param datetime released_since: Date since which to limit the request, to only retrieve newer assemblies.
        :param str host: Assemblies that were taken from this host (tax-id or name) or its taxonomic descendents.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['refseq_only', 'annotated_only', 'released_since', 'host']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_virus_dataset_sars_stream" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'refseq_only' in local_var_params and local_var_params['refseq_only'] is not None:  # noqa: E501
            query_params.append(('refseq_only', local_var_params['refseq_only']))  # noqa: E501
        if 'annotated_only' in local_var_params and local_var_params['annotated_only'] is not None:  # noqa: E501
            query_params.append(('annotated_only', local_var_params['annotated_only']))  # noqa: E501
        if 'released_since' in local_var_params and local_var_params['released_since'] is not None:  # noqa: E501
            query_params.append(('released_since', local_var_params['released_since']))  # noqa: E501
        if 'host' in local_var_params and local_var_params['host'] is not None:  # noqa: E501
            query_params.append(('host', local_var_params['host']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/zip'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/download/virus/sars2', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_virus_dataset_stream(self, tax_id, **kwargs):  # noqa: E501
        """Retrieve Coronavirus genome datasets by taxonomy ID  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_virus_dataset_stream(tax_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int tax_id: NCBI Taxonomy ID (required)
        :param bool refseq_only: The source database is RefSeq.
        :param bool annotated_only: Only those assemblies with annotation as asserted by Virus.
        :param datetime released_since: Date since which to limit the request, to only retrieve newer assemblies.
        :param str host: Assemblies that were taken from this host (tax-id or name) or its taxonomic descendents.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_virus_dataset_stream_with_http_info(tax_id, **kwargs)  # noqa: E501

    def get_virus_dataset_stream_with_http_info(self, tax_id, **kwargs):  # noqa: E501
        """Retrieve Coronavirus genome datasets by taxonomy ID  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_virus_dataset_stream_with_http_info(tax_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int tax_id: NCBI Taxonomy ID (required)
        :param bool refseq_only: The source database is RefSeq.
        :param bool annotated_only: Only those assemblies with annotation as asserted by Virus.
        :param datetime released_since: Date since which to limit the request, to only retrieve newer assemblies.
        :param str host: Assemblies that were taken from this host (tax-id or name) or its taxonomic descendents.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['tax_id', 'refseq_only', 'annotated_only', 'released_since', 'host']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_virus_dataset_stream" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tax_id' is set
        if self.api_client.client_side_validation and ('tax_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['tax_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tax_id` when calling `get_virus_dataset_stream`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tax_id' in local_var_params:
            path_params['tax_id'] = local_var_params['tax_id']  # noqa: E501

        query_params = []
        if 'refseq_only' in local_var_params and local_var_params['refseq_only'] is not None:  # noqa: E501
            query_params.append(('refseq_only', local_var_params['refseq_only']))  # noqa: E501
        if 'annotated_only' in local_var_params and local_var_params['annotated_only'] is not None:  # noqa: E501
            query_params.append(('annotated_only', local_var_params['annotated_only']))  # noqa: E501
        if 'released_since' in local_var_params and local_var_params['released_since'] is not None:  # noqa: E501
            query_params.append(('released_since', local_var_params['released_since']))  # noqa: E501
        if 'host' in local_var_params and local_var_params['host'] is not None:  # noqa: E501
            query_params.append(('host', local_var_params['host']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/zip'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/download/virus/taxid/{tax_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_virus_dataset_stream_by_name(self, tax_name, **kwargs):  # noqa: E501
        """Retrieve Coronavirus genome datasets by taxonomy name  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_virus_dataset_stream_by_name(tax_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str tax_name: Common or scientific name at any tax rank for all domains of life (required)
        :param bool refseq_only: The source database is RefSeq.
        :param bool annotated_only: Only those assemblies with annotation as asserted by Virus.
        :param datetime released_since: Date since which to limit the request, to only retrieve newer assemblies.
        :param str host: Assemblies that were taken from this host (tax-id or name) or its taxonomic descendents.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_virus_dataset_stream_by_name_with_http_info(tax_name, **kwargs)  # noqa: E501

    def get_virus_dataset_stream_by_name_with_http_info(self, tax_name, **kwargs):  # noqa: E501
        """Retrieve Coronavirus genome datasets by taxonomy name  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_virus_dataset_stream_by_name_with_http_info(tax_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str tax_name: Common or scientific name at any tax rank for all domains of life (required)
        :param bool refseq_only: The source database is RefSeq.
        :param bool annotated_only: Only those assemblies with annotation as asserted by Virus.
        :param datetime released_since: Date since which to limit the request, to only retrieve newer assemblies.
        :param str host: Assemblies that were taken from this host (tax-id or name) or its taxonomic descendents.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['tax_name', 'refseq_only', 'annotated_only', 'released_since', 'host']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_virus_dataset_stream_by_name" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tax_name' is set
        if self.api_client.client_side_validation and ('tax_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['tax_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tax_name` when calling `get_virus_dataset_stream_by_name`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tax_name' in local_var_params:
            path_params['tax_name'] = local_var_params['tax_name']  # noqa: E501

        query_params = []
        if 'refseq_only' in local_var_params and local_var_params['refseq_only'] is not None:  # noqa: E501
            query_params.append(('refseq_only', local_var_params['refseq_only']))  # noqa: E501
        if 'annotated_only' in local_var_params and local_var_params['annotated_only'] is not None:  # noqa: E501
            query_params.append(('annotated_only', local_var_params['annotated_only']))  # noqa: E501
        if 'released_since' in local_var_params and local_var_params['released_since'] is not None:  # noqa: E501
            query_params.append(('released_since', local_var_params['released_since']))  # noqa: E501
        if 'host' in local_var_params and local_var_params['host'] is not None:  # noqa: E501
            query_params.append(('host', local_var_params['host']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/zip'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/download/virus/organism/{tax_name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
