try:
    import psutil
except ImportError:
    psutil = False

# Get available RAM, if available
if psutil:
    tmem = psutil.virtual_memory().total
    TOTAL_RAM = '{:.1f} GB'.format(tmem / (1024.0 ** 3))
else:
    TOTAL_RAM = False

try:
    import mkl
except ImportError:
    mkl = False

try:
    import numexpr
except ImportError:
    numexpr = False

# Get mkl info from numexpr or mkl, if available
if mkl:
    MKL_INFO = mkl.get_version_string()
elif numexpr:
    MKL_INFO = numexpr.get_vml_version()
else:
    MKL_INFO = False


def sort_dictionary(dictionary):
    """Sorts a dictionary alphabetically. Case insensitive."""
    sorted_dictionary = {}
    for name in sorted(dictionary.keys(), key=lambda x: x.lower()):
        sorted_dictionary[name] = dictionary[name]
    return sorted_dictionary
