"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GitHubOidcProvider = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
/**
 * Defines an OIDC provider for GitHub workflows.
 *
 * This provider can be
 *
 * @stability stable
 */
class GitHubOidcProvider extends core_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id) {
        super(scope, id);
        const provider = new iam.CfnOIDCProvider(scope, `${id}.GithubOidcProvider`, {
            url: `https://${GitHubOidcProvider.DOMAIN}`,
            thumbprintList: [GitHubOidcProvider.THUMBPRINT],
            clientIdList: ['sigstore'],
        });
        this.providerArn = provider.attrArn;
    }
    /**
     * @param account The AWS account for which you want to obtain the OIDC provider.
     * @returns The singleton GitHub OIDC provider for an account.
     * @stability stable
     */
    static forAccount(account) {
        return {
            providerArn: arnForAccount(account),
        };
    }
}
exports.GitHubOidcProvider = GitHubOidcProvider;
_a = JSII_RTTI_SYMBOL_1;
GitHubOidcProvider[_a] = { fqn: "cdk-github-role.GitHubOidcProvider", version: "0.0.2" };
/**
 * The OIDC domain for GitHub.
 *
 * @stability stable
 */
GitHubOidcProvider.DOMAIN = 'token.actions.githubusercontent.com';
/**
 * The OIDC domain thumbprint for GitHub.
 *
 * @stability stable
 */
GitHubOidcProvider.THUMBPRINT = 'a031c46782e6e6c662c2c87c76da9aa62ccabd8e';
function arnForAccount(account) {
    account = account !== null && account !== void 0 ? account : core_1.Aws.ACCOUNT_ID;
    return `arn:aws:iam::${account}:oidc-provider/${GitHubOidcProvider.DOMAIN}`;
}
//# sourceMappingURL=data:application/json;base64,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